/*
 * Decompiled with CFR 0.152.
 */
package org.egothor.stemmer;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.lucene.util.SuppressForbidden;
import org.egothor.stemmer.Diff;
import org.egothor.stemmer.Gener;
import org.egothor.stemmer.Lift;
import org.egothor.stemmer.MultiTrie2;
import org.egothor.stemmer.Optimizer;
import org.egothor.stemmer.Optimizer2;
import org.egothor.stemmer.Trie;

public class Compile {
    private Compile() {
    }

    @SuppressForbidden(reason="System.out required: command line tool")
    public static void main(String[] args) throws Exception {
        int i;
        boolean multi;
        if (args.length < 1) {
            return;
        }
        boolean backward = args[0].charAt(0) == '-';
        int qq = backward ? 1 : 0;
        boolean storeorig = false;
        if (args[0].charAt(qq) == '0') {
            storeorig = true;
            ++qq;
        }
        boolean bl = multi = args[0].charAt(qq) == 'M';
        if (multi) {
            ++qq;
        }
        String charset = System.getProperty("egothor.stemmer.charset", "UTF-8");
        char[] optimizer = new char[args[0].length() - qq];
        for (i = 0; i < optimizer.length; ++i) {
            optimizer[i] = args[0].charAt(qq + i);
        }
        for (i = 1; i < args.length; ++i) {
            Diff diff = new Diff();
            Trie trie = Compile.allocTrie(multi, backward);
            System.out.println(args[i]);
            try (LineNumberReader in = new LineNumberReader(Files.newBufferedReader(Paths.get(args[i], new String[0]), Charset.forName(charset)));){
                String line = in.readLine();
                while (line != null) {
                    try {
                        line = line.toLowerCase(Locale.ROOT);
                        StringTokenizer st = new StringTokenizer(line);
                        String stem = st.nextToken();
                        if (storeorig) {
                            trie.add(stem, "-a");
                        }
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (token.equals(stem)) continue;
                            trie.add(token, diff.exec(token, stem));
                        }
                    }
                    catch (NoSuchElementException st) {
                        // empty catch block
                    }
                    line = in.readLine();
                }
            }
            Optimizer o = new Optimizer();
            Optimizer2 o2 = new Optimizer2();
            Lift l = new Lift(true);
            Lift e = new Lift(false);
            Gener g = new Gener();
            block23: for (char c : optimizer) {
                String prefix;
                switch (c) {
                    case 'G': {
                        trie = trie.reduce(g);
                        prefix = "G: ";
                        break;
                    }
                    case 'L': {
                        trie = trie.reduce(l);
                        prefix = "L: ";
                        break;
                    }
                    case 'E': {
                        trie = trie.reduce(e);
                        prefix = "E: ";
                        break;
                    }
                    case '2': {
                        trie = trie.reduce(o2);
                        prefix = "2: ";
                        break;
                    }
                    case '1': {
                        trie = trie.reduce(o);
                        prefix = "1: ";
                        break;
                    }
                    default: {
                        continue block23;
                    }
                }
                trie.printInfo(System.out, prefix + " ");
            }
            try (DataOutputStream os = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(args[i] + ".out", new String[0]), new OpenOption[0])));){
                os.writeUTF(args[0]);
                trie.store(os);
                continue;
            }
        }
    }

    static Trie allocTrie(boolean multi, boolean backward) {
        if (multi) {
            return new MultiTrie2(!backward);
        }
        return new Trie(!backward);
    }
}

