/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.util;

import inet.ipaddr.Address;
import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.AddressTrie;
import inet.ipaddr.format.util.BinaryTreeNode;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public abstract class BaseDualIPv4v6Tries<T4 extends AddressTrie<IPv4Address>, T6 extends AddressTrie<IPv6Address>>
implements Iterable<IPAddress>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private BinaryTreeNode.ChangeTracker ipv4Tracker;
    private BinaryTreeNode.ChangeTracker ipv6Tracker;
    static final Comparator<?> BLOCK_SIZE_COMP = new BlockSizeComp(false);
    static final Comparator<?> REVERSE_BLOCK_SIZE_COMP = new BlockSizeComp(true);

    public abstract T4 getIPv4Trie();

    public abstract T6 getIPv6Trie();

    BaseDualIPv4v6Tries(AddressTrie<IPv4Address> ipv4Trie, AddressTrie<IPv6Address> ipv6Trie) {
        this.assignTrackers(ipv4Trie, ipv6Trie);
    }

    void assignTrackers(AddressTrie<IPv4Address> ipv4Trie, AddressTrie<IPv6Address> ipv6Trie) {
        this.ipv4Tracker = ipv4Trie.absoluteRoot().changeTracker;
        this.ipv6Tracker = ipv6Trie.absoluteRoot().changeTracker;
    }

    public BaseDualIPv4v6Tries<T4, T6> clone() {
        try {
            return (BaseDualIPv4v6Tries)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof BaseDualIPv4v6Tries) {
            BaseDualIPv4v6Tries o = (BaseDualIPv4v6Tries)other;
            return ((AddressTrie)this.getIPv4Trie()).equals(o.getIPv4Trie()) && ((AddressTrie)this.getIPv6Trie()).equals(o.getIPv6Trie());
        }
        return false;
    }

    public String toString() {
        return AddressTrie.toString(true, new AddressTrie[]{this.getIPv4Trie(), this.getIPv6Trie()});
    }

    static boolean addressPredicateOp(IPAddress addr, Predicate<IPv4Address> ipv4Op, Predicate<IPv6Address> ipv6Op) {
        if (addr.isIPv4()) {
            return ipv4Op.test(addr.toIPv4());
        }
        if (addr.isIPv6()) {
            return ipv6Op.test(addr.toIPv6());
        }
        return false;
    }

    static <T> T addressFuncOp(IPAddress addr, Function<IPv4Address, T> ipv4Op, Function<IPv6Address, T> ipv6Op) {
        if (addr.isIPv4()) {
            return ipv4Op.apply(addr.toIPv4());
        }
        if (addr.isIPv6()) {
            return ipv6Op.apply(addr.toIPv6());
        }
        return null;
    }

    static <V> V addressValValBiFuncOp(IPAddress addr, V value, BiFunction<IPv4Address, V, V> ipv4Op, BiFunction<IPv6Address, V, V> ipv6Op) {
        if (addr.isIPv4()) {
            return ipv4Op.apply(addr.toIPv4(), value);
        }
        if (addr.isIPv6()) {
            return ipv6Op.apply(addr.toIPv6(), value);
        }
        return null;
    }

    static <V, R> R addressValBiFuncOp(IPAddress addr, V value, BiFunction<IPv4Address, V, R> ipv4Op, BiFunction<IPv6Address, V, R> ipv6Op) {
        if (addr.isIPv4()) {
            return ipv4Op.apply(addr.toIPv4(), value);
        }
        if (addr.isIPv6()) {
            return ipv6Op.apply(addr.toIPv6(), value);
        }
        return null;
    }

    static <V> boolean addressValBiPredicateOp(IPAddress addr, V value, BiPredicate<IPv4Address, V> ipv4Op, BiPredicate<IPv6Address, V> ipv6Op) {
        if (addr.isIPv4()) {
            return ipv4Op.test(addr.toIPv4(), value);
        }
        if (addr.isIPv6()) {
            return ipv6Op.test(addr.toIPv6(), value);
        }
        return false;
    }

    static <T extends AddressTrie.TrieNode<? extends IPAddress>, R extends AddressTrie.TrieNode<? extends IPAddress>, R1 extends AddressTrie.TrieNode<IPv4Address>, R2 extends AddressTrie.TrieNode<IPv6Address>> R unaryOp(T trie, UnaryOperator<R1> ipv4Op, UnaryOperator<R2> ipv6Op) {
        IPAddress addr = (IPAddress)trie.getKey();
        if (addr.isIPv4()) {
            return (R)((AddressTrie.TrieNode)ipv4Op.apply(trie));
        }
        if (addr.isIPv6()) {
            return (R)((AddressTrie.TrieNode)ipv6Op.apply(trie));
        }
        return null;
    }

    public int size() {
        return ((AddressTrie)this.getIPv4Trie()).size() + ((AddressTrie)this.getIPv6Trie()).size();
    }

    public boolean isEmpty() {
        return ((AddressTrie)this.getIPv4Trie()).isEmpty() && ((AddressTrie)this.getIPv6Trie()).isEmpty();
    }

    public boolean add(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressPredicateOp(addr, arg_0 -> this.getIPv4Trie().add(arg_0), arg_0 -> this.getIPv6Trie().add(arg_0));
    }

    public boolean contains(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressPredicateOp(addr, arg_0 -> this.getIPv4Trie().contains(arg_0), arg_0 -> this.getIPv6Trie().contains(arg_0));
    }

    public boolean remove(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressPredicateOp(addr, arg_0 -> this.getIPv4Trie().remove(arg_0), arg_0 -> this.getIPv6Trie().remove(arg_0));
    }

    public boolean elementContains(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressPredicateOp(addr, arg_0 -> this.getIPv4Trie().elementContains(arg_0), arg_0 -> this.getIPv6Trie().elementContains(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> elementsContaining(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().elementsContaining(arg_0), arg_0 -> this.getIPv6Trie().elementsContaining(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> elementsContainedBy(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().elementsContainedBy(arg_0), arg_0 -> this.getIPv6Trie().elementsContainedBy(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> removeElementsContainedBy(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().removeElementsContainedBy(arg_0), arg_0 -> this.getIPv6Trie().removeElementsContainedBy(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> getAddedNode(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().getAddedNode(arg_0), arg_0 -> this.getIPv6Trie().getAddedNode(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> longestPrefixMatchNode(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().longestPrefixMatchNode(arg_0), arg_0 -> this.getIPv6Trie().longestPrefixMatchNode(arg_0));
    }

    public IPAddress longestPrefixMatch(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().longestPrefixMatch(arg_0), arg_0 -> this.getIPv6Trie().longestPrefixMatch(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> addNode(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().addNode(arg_0), arg_0 -> this.getIPv6Trie().addNode(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> addTrie(AddressTrie.TrieNode<? extends IPAddress> trie) {
        return BaseDualIPv4v6Tries.unaryOp(trie, arg_0 -> this.getIPv4Trie().addTrie(arg_0), arg_0 -> this.getIPv6Trie().addTrie(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> floorAddedNode(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().floorAddedNode(arg_0), arg_0 -> this.getIPv6Trie().floorAddedNode(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> lowerAddedNode(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().lowerAddedNode(arg_0), arg_0 -> this.getIPv6Trie().lowerAddedNode(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> ceilingAddedNode(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().ceilingAddedNode(arg_0), arg_0 -> this.getIPv6Trie().ceilingAddedNode(arg_0));
    }

    public AddressTrie.TrieNode<? extends IPAddress> higherAddedNode(IPAddress addr) {
        return BaseDualIPv4v6Tries.addressFuncOp(addr, arg_0 -> this.getIPv4Trie().higherAddedNode(arg_0), arg_0 -> this.getIPv6Trie().higherAddedNode(arg_0));
    }

    public IPAddress floor(IPAddress addr) {
        return AddressTrie.getNodeKey(this.floorAddedNode(addr));
    }

    public IPAddress lower(IPAddress addr) {
        return AddressTrie.getNodeKey(this.lowerAddedNode(addr));
    }

    public IPAddress ceiling(IPAddress addr) {
        return AddressTrie.getNodeKey(this.ceilingAddedNode(addr));
    }

    public IPAddress higher(IPAddress addr) {
        return AddressTrie.getNodeKey(this.higherAddedNode(addr));
    }

    @Override
    public Iterator<IPAddress> iterator() {
        Iterator ipv4Iterator = ((AddressTrie)this.getIPv4Trie()).iterator();
        Iterator ipv6Iterator = ((AddressTrie)this.getIPv6Trie()).iterator();
        return new DualIterator<IPAddress>(ipv4Iterator, ipv6Iterator, true);
    }

    public Iterator<IPAddress> descendingIterator() {
        Iterator ipv4Iterator = ((AddressTrie)this.getIPv4Trie()).descendingIterator();
        Iterator ipv6Iterator = ((AddressTrie)this.getIPv6Trie()).descendingIterator();
        return new DualIterator<IPAddress>(ipv4Iterator, ipv6Iterator, false);
    }

    @Override
    public Spliterator<IPAddress> spliterator() {
        Spliterator ipv4Iterator = ((AddressTrie)this.getIPv4Trie()).spliterator();
        Spliterator ipv6Iterator = ((AddressTrie)this.getIPv6Trie()).spliterator();
        return new DualSpliterator<IPAddress>(ipv4Iterator, ipv6Iterator);
    }

    public Spliterator<IPAddress> descendingSpliterator() {
        Spliterator ipv4Iterator = ((AddressTrie)this.getIPv4Trie()).descendingSpliterator();
        Spliterator ipv6Iterator = ((AddressTrie)this.getIPv6Trie()).descendingSpliterator();
        return new DualSpliterator<IPAddress>(ipv6Iterator, ipv4Iterator);
    }

    <T extends AddressTrie.TrieNode<? extends IPAddress>> Iterator<T> combineNodeIterators(boolean forward, Iterator<? extends T> ipv4It, Iterator<? extends T> ipv6It) {
        Iterator<? extends T> ipv4I = ipv4It;
        Iterator<? extends T> ipv6I = ipv6It;
        return new DualIterator<T>(ipv4I, ipv6I, forward);
    }

    <T extends AddressTrie.TrieNode<? extends IPAddress>> Iterator<T> combineBlockSizeNodeIterators(boolean lowerSubNodeFirst, Iterator<? extends T> ipv4It, Iterator<? extends T> ipv6It) {
        Iterator<? extends T> ipv4I = ipv4It;
        Iterator<? extends T> ipv6I = ipv6It;
        return new DualBlockSizeIterator<T>(lowerSubNodeFirst, ipv4I, ipv6I);
    }

    public abstract Iterator<? extends AddressTrie.TrieNode<? extends IPAddress>> nodeIterator(boolean var1);

    public abstract Iterator<? extends AddressTrie.TrieNode<? extends IPAddress>> containingFirstIterator(boolean var1);

    public abstract Iterator<? extends AddressTrie.TrieNode<? extends IPAddress>> containedFirstIterator(boolean var1);

    public abstract Iterator<? extends AddressTrie.TrieNode<? extends IPAddress>> blockSizeNodeIterator(boolean var1);

    public abstract Spliterator<? extends AddressTrie.TrieNode<? extends IPAddress>> nodeSpliterator(boolean var1);

    <T extends AddressTrie.TrieNode<? extends IPAddress>> Spliterator<T> combineNodeSpliterators(boolean forward, Spliterator<? extends T> ipv4It, Spliterator<? extends T> ipv6It) {
        Spliterator<? extends T> ipv4I = ipv4It;
        Spliterator<? extends T> ipv6I = ipv6It;
        if (forward) {
            return new DualSpliterator<T>(ipv4I, ipv6I);
        }
        return new DualSpliterator<T>(ipv6I, ipv4I);
    }

    static int compareLowValues(Address one, Address two) {
        return Address.ADDRESS_LOW_VALUE_COMPARATOR.compare(one, two);
    }

    class DualSpliterator<T>
    extends BaseDualIterator
    implements Spliterator<T> {
        Spliterator<T> first;
        Spliterator<T> second;
        Spliterator<T> current;

        DualSpliterator(Spliterator<T> first, Spliterator<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            this.changedSince();
            if (this.current == null) {
                if (this.first.tryAdvance(action)) {
                    return true;
                }
                return this.second.tryAdvance(action);
            }
            return this.current.tryAdvance(action);
        }

        @Override
        public Spliterator<T> trySplit() {
            this.changedSince();
            if (this.current == null) {
                this.current = this.second;
                return this.first;
            }
            return this.current.trySplit();
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.changedSince();
            if (this.current == null) {
                this.current = this.second;
                this.first.forEachRemaining(action);
                this.second.forEachRemaining(action);
            } else {
                this.current.forEachRemaining(action);
            }
        }

        @Override
        public long estimateSize() {
            if (this.current == null) {
                return this.first.estimateSize() + this.second.estimateSize();
            }
            return this.current.estimateSize();
        }

        @Override
        public int characteristics() {
            if (this.current == null) {
                return this.first.characteristics() & this.second.characteristics();
            }
            return this.current.characteristics();
        }
    }

    class DualIterator<T>
    extends BaseDualIterator
    implements Iterator<T> {
        private Iterator<T> current;
        private Iterator<T> first;
        private Iterator<T> last;
        private boolean firstIsIPv4;

        DualIterator(Iterator<T> ipv4Iterator, Iterator<T> ipv6Iterator, boolean forward) {
            if (forward) {
                this.first = ipv4Iterator;
                this.last = ipv6Iterator;
            } else {
                this.first = ipv6Iterator;
                this.last = ipv4Iterator;
            }
            this.current = this.first;
            this.firstIsIPv4 = forward;
        }

        @Override
        public boolean hasNext() {
            if (this.current == this.last) {
                return this.last.hasNext();
            }
            return this.current.hasNext() || this.last.hasNext();
        }

        @Override
        public T next() {
            if (this.current != this.last && !this.first.hasNext()) {
                this.current = this.last;
            }
            if (this.current.hasNext()) {
                this.changedSince();
            }
            return this.current.next();
        }

        @Override
        public void remove() {
            this.changedSince();
            this.current.remove();
            if (this.current == this.first ? this.firstIsIPv4 : !this.firstIsIPv4) {
                if (BaseDualIPv4v6Tries.this.ipv4Tracker != null) {
                    this.ipv4CurrentChange = BaseDualIPv4v6Tries.this.ipv4Tracker.getCurrent();
                }
            } else if (BaseDualIPv4v6Tries.this.ipv6Tracker != null) {
                this.ipv6CurrentChange = BaseDualIPv4v6Tries.this.ipv6Tracker.getCurrent();
            }
        }
    }

    class DualBlockSizeIterator<T extends AddressTrie.TrieNode<? extends IPAddress>>
    extends BaseDualIterator
    implements Iterator<T> {
        T ipv4Item;
        T ipv6Item;
        Iterator<T> ipv4Iterator;
        Iterator<T> ipv6Iterator;
        T lastItem;
        Comparator<IPAddress> comp;

        DualBlockSizeIterator(boolean lowerSubNodeFirst, Iterator<T> ipv4Iterator, Iterator<T> ipv6Iterator) {
            boolean reverseBlocksEqualSize = !lowerSubNodeFirst;
            this.comp = reverseBlocksEqualSize ? REVERSE_BLOCK_SIZE_COMP : BLOCK_SIZE_COMP;
            this.ipv4Iterator = ipv4Iterator;
            this.ipv6Iterator = ipv6Iterator;
        }

        @Override
        public boolean hasNext() {
            return this.ipv4Item != null || this.ipv6Item != null || this.ipv4Iterator.hasNext() || this.ipv6Iterator.hasNext();
        }

        @Override
        public T next() {
            T result;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.changedSince();
            if (this.ipv4Item == null && this.ipv4Iterator.hasNext()) {
                this.ipv4Item = (AddressTrie.TrieNode)this.ipv4Iterator.next();
            }
            if (this.ipv6Item == null && this.ipv6Iterator.hasNext()) {
                this.ipv6Item = (AddressTrie.TrieNode)this.ipv6Iterator.next();
            }
            if (this.ipv4Item == null) {
                this.lastItem = this.ipv6Item;
                result = this.lastItem;
                this.ipv6Item = null;
            } else if (this.ipv6Item == null) {
                this.lastItem = this.ipv4Item;
                result = this.lastItem;
                this.ipv4Item = null;
            } else {
                int cmp = this.comp.compare((IPAddress)((BinaryTreeNode)this.ipv4Item).getKey(), (IPAddress)((BinaryTreeNode)this.ipv6Item).getKey());
                if (cmp < 0) {
                    this.lastItem = this.ipv4Item;
                    result = this.lastItem;
                    this.ipv4Item = null;
                } else {
                    this.lastItem = this.ipv6Item;
                    result = this.lastItem;
                    this.ipv6Item = null;
                }
            }
            return result;
        }

        @Override
        public void remove() {
            if (this.lastItem == null) {
                throw new IllegalStateException();
            }
            this.changedSince();
            if (((IPAddress)((BinaryTreeNode)this.lastItem).getKey()).isIPv4()) {
                this.ipv4Iterator.remove();
                this.ipv4CurrentChange = BaseDualIPv4v6Tries.this.ipv4Tracker.getCurrent();
            } else {
                this.ipv6Iterator.remove();
                this.ipv6CurrentChange = BaseDualIPv4v6Tries.this.ipv6Tracker.getCurrent();
            }
            this.lastItem = null;
        }
    }

    class BaseDualIterator {
        BinaryTreeNode.ChangeTracker.Change ipv4CurrentChange;
        BinaryTreeNode.ChangeTracker.Change ipv6CurrentChange;

        BaseDualIterator() {
            if (BaseDualIPv4v6Tries.this.ipv4Tracker != null) {
                this.ipv4CurrentChange = BaseDualIPv4v6Tries.this.ipv4Tracker.getCurrent();
            }
            if (BaseDualIPv4v6Tries.this.ipv6Tracker != null) {
                this.ipv6CurrentChange = BaseDualIPv4v6Tries.this.ipv6Tracker.getCurrent();
            }
        }

        void changedSince() {
            if (BaseDualIPv4v6Tries.this.ipv4Tracker != null) {
                BaseDualIPv4v6Tries.this.ipv4Tracker.changedSince(this.ipv4CurrentChange);
            }
            if (BaseDualIPv4v6Tries.this.ipv6Tracker != null) {
                BaseDualIPv4v6Tries.this.ipv6Tracker.changedSince(this.ipv6CurrentChange);
            }
        }
    }

    static class BlockSizeComp<E extends Address>
    implements Comparator<E> {
        private final boolean reverseBlocksEqualSize;

        BlockSizeComp(boolean reverseBlocksEqualSize) {
            this.reverseBlocksEqualSize = reverseBlocksEqualSize;
        }

        @Override
        public int compare(E addr1, E addr2) {
            if (addr1 == addr2) {
                return 0;
            }
            if (((Address)addr1).isPrefixed()) {
                if (((Address)addr2).isPrefixed()) {
                    int val = ((Address)addr2).getBitCount() - ((Address)addr2).getPrefixLength() - (((Address)addr1).getBitCount() - ((Address)addr1).getPrefixLength());
                    if (val == 0) {
                        int compVal = BaseDualIPv4v6Tries.compareLowValues(addr1, addr2);
                        return this.reverseBlocksEqualSize ? -compVal : compVal;
                    }
                    return val;
                }
                return -1;
            }
            if (((Address)addr2).isPrefixed()) {
                return 1;
            }
            int compVal = BaseDualIPv4v6Tries.compareLowValues(addr1, addr2);
            return this.reverseBlocksEqualSize ? -compVal : compVal;
        }
    }
}

