/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.indexmanagement.indexstatemanagement.ManagedIndexRunner;
import org.opensearch.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import org.opensearch.indexmanagement.rollup.RollupRunner;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.snapshotmanagement.SMRunner;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.indexmanagement.transform.TransformRunner;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/IndexManagementRunner;", "Lorg/opensearch/jobscheduler/spi/ScheduledJobRunner;", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "runJob", "", "job", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParameter;", "context", "Lorg/opensearch/jobscheduler/spi/JobExecutionContext;", "opensearch-index-management"})
public final class IndexManagementRunner
implements ScheduledJobRunner {
    @NotNull
    public static final IndexManagementRunner INSTANCE = new IndexManagementRunner();
    private static final Logger logger = LogManager.getLogger(INSTANCE.getClass());

    private IndexManagementRunner() {
    }

    public void runJob(@NotNull ScheduledJobParameter job, @NotNull JobExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ScheduledJobParameter scheduledJobParameter = job;
        if (scheduledJobParameter instanceof ManagedIndexConfig) {
            ManagedIndexRunner.INSTANCE.runJob(job, context);
        } else if (scheduledJobParameter instanceof Rollup) {
            RollupRunner.INSTANCE.runJob(job, context);
        } else if (scheduledJobParameter instanceof Transform) {
            TransformRunner.INSTANCE.runJob(job, context);
        } else if (scheduledJobParameter instanceof SMPolicy) {
            SMRunner.INSTANCE.runJob(job, context);
        } else {
            String errorMessage = "Invalid job type, found " + job.getClass().getSimpleName() + " with id: " + context.getJobId();
            logger.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

