/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.resthandler;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.common.model.rest.SearchParams;
import org.opensearch.indexmanagement.indexstatemanagement.model.ExplainFilter;
import org.opensearch.indexmanagement.indexstatemanagement.resthandler.RestExplainActionKt;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.explain.ExplainAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.explain.ExplainRequest;
import org.opensearch.indexmanagement.util.RestHandlerUtilsKt;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/resthandler/RestExplainAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "replacedRoutes", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "Companion", "opensearch-index-management"})
public final class RestExplainAction
extends BaseRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EXPLAIN_BASE_URI = "/_plugins/_ism/explain";
    @NotNull
    public static final String LEGACY_EXPLAIN_BASE_URI = "/_opendistro/_ism/explain";

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.GET, EXPLAIN_BASE_URI, RestRequest.Method.GET, LEGACY_EXPLAIN_BASE_URI), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_ism/explain/{index}", RestRequest.Method.GET, "/_opendistro/_ism/explain/{index}"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, EXPLAIN_BASE_URI, RestRequest.Method.POST, LEGACY_EXPLAIN_BASE_URI), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_ism/explain/{index}", RestRequest.Method.POST, "/_opendistro/_ism/explain/{index}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getName() {
        return "ism_explain_action";
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        ExplainFilter explainFilter;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestExplainActionKt.access$getLog$p().debug(request.method() + " " + request.path());
        Object[] objectArray = Strings.splitStringByCommaToArray((String)request.param("index"));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"splitStringByCommaToArray(...)");
        Object[] indices = objectArray;
        SearchParams searchParams = RestHandlerUtilsKt.getSearchParams(request, "managed_index.index");
        String indexType = request.param("type", "_default");
        if (request.method() == RestRequest.Method.POST) {
            XContentParser xcp = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            Intrinsics.checkNotNull((Object)xcp);
            explainFilter = ExplainFilter.Companion.parse(xcp);
        } else {
            explainFilter = null;
        }
        ExplainFilter explainFilter2 = explainFilter;
        DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestExplainAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)deprecationLogger, (String)"getLogger(...)");
        TimeValue clusterManagerTimeout = org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt.parseClusterManagerTimeout(request, deprecationLogger, this.getName());
        List list = ArraysKt.toList((Object[])indices);
        boolean bl = request.paramAsBoolean("local", false);
        boolean bl2 = request.paramAsBoolean("show_policy", false);
        boolean bl3 = request.paramAsBoolean("validate_action", false);
        Intrinsics.checkNotNull((Object)indexType);
        ExplainRequest explainRequest = new ExplainRequest(list, bl, clusterManagerTimeout, searchParams, explainFilter2, bl2, bl3, indexType);
        return arg_0 -> RestExplainAction.prepareRequest$lambda$0(client, explainRequest, arg_0);
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, ExplainRequest $explainRequest, RestChannel channel) {
        $client.execute((ActionType)ExplainAction.Companion.getINSTANCE(), (ActionRequest)$explainRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/resthandler/RestExplainAction$Companion;", "", "<init>", "()V", "EXPLAIN_BASE_URI", "", "LEGACY_EXPLAIN_BASE_URI", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

