/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.util;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.node.stats.NodeStats;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.indexmanagement.indexstatemanagement.util.StepUtilsKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ShrinkActionProperties;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.monitor.fs.FsInfo;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.ClusterAdminClient;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\b\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000f\u001a&\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013\u001a(\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013\u001a\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f\u001a6\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a\u001a\u0016\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0015\u001a\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#\u001a\u0016\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001a\u001a\u000e\u0010(\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&\u001a\u001e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&\u001a(\u0010-\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010.\u001a\u00020/H\u0086@\u00a2\u0006\u0002\u00100\u001a2\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000504H\u0086@\u00a2\u0006\u0002\u00105\u001a\u000e\u00106\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a\u000e\u00107\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a3\u00108\u001a\u0014\u0012\u0004\u0012\u000209\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050:042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u0010>\u001a\u00020?\u00a2\u0006\u0002\u0010@\u00a8\u0006A"}, d2={"issueUpdateSettingsRequest", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "client", "Lorg/opensearch/transport/client/Client;", "indexName", "", "settings", "Lorg/opensearch/common/settings/Settings;", "(Lorg/opensearch/transport/client/Client;Ljava/lang/String;Lorg/opensearch/common/settings/Settings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "releaseShrinkLock", "", "shrinkActionProperties", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ShrinkActionProperties;", "lockService", "Lorg/opensearch/jobscheduler/spi/utils/LockService;", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ShrinkActionProperties;Lorg/opensearch/jobscheduler/spi/utils/LockService;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteShrinkLock", "logger", "Lorg/apache/logging/log4j/Logger;", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ShrinkActionProperties;Lorg/opensearch/jobscheduler/spi/utils/LockService;Lorg/apache/logging/log4j/Logger;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renewShrinkLock", "Lorg/opensearch/jobscheduler/spi/LockModel;", "getShrinkLockModel", "nodeName", "jobIndexName", "lockEpochSecond", "", "lockPrimaryTerm", "lockSeqNo", "lockDurationSecond", "getUpdatedShrinkActionProperties", "lock", "getActionStartTime", "Ljava/time/Instant;", "managedIndexMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "getFreeBytesThresholdHigh", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "totalNodeBytes", "getDiskSettings", "getNodeFreeDiskSpaceAfterShrink", "node", "Lorg/opensearch/action/admin/cluster/node/stats/NodeStats;", "indexSizeInBytes", "isIndexGreen", "timeout", "Lorg/opensearch/common/unit/TimeValue;", "(Lorg/opensearch/transport/client/Client;Ljava/lang/String;Lorg/opensearch/common/unit/TimeValue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetReadOnlyAndRouting", "index", "originalSettings", "", "(Ljava/lang/String;Lorg/opensearch/transport/client/Client;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getShrinkLockID", "getShrinkJobID", "getShardIdToNodeNameSet", "", "", "shardStats", "", "Lorg/opensearch/action/admin/indices/stats/ShardStats;", "nodes", "Lorg/opensearch/cluster/node/DiscoveryNodes;", "([Lorg/opensearch/action/admin/indices/stats/ShardStats;Lorg/opensearch/cluster/node/DiscoveryNodes;)Ljava/util/Map;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nStepUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StepUtils.kt\norg/opensearch/indexmanagement/indexstatemanagement/util/StepUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
public final class StepUtilsKt {
    @Nullable
    public static final Object issueUpdateSettingsRequest(@NotNull Client client, @NotNull String indexName, @NotNull Settings settings, @NotNull Continuation<? super AcknowledgedResponse> $completion) {
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client.admin().indices(), (arg_0, arg_1) -> StepUtilsKt.issueUpdateSettingsRequest$lambda$0(settings, indexName, arg_0, arg_1), $completion);
    }

    @Nullable
    public static final Object releaseShrinkLock(@NotNull ShrinkActionProperties shrinkActionProperties, @NotNull LockService lockService, @NotNull Continuation<? super Boolean> $completion) {
        LockModel lock = StepUtilsKt.getShrinkLockModel(shrinkActionProperties);
        return OpenSearchExtensionsKt.suspendUntil(lockService, (arg_0, arg_1) -> StepUtilsKt.releaseShrinkLock$lambda$1(lock, arg_0, arg_1), $completion);
    }

    @Nullable
    public static final Object deleteShrinkLock(@NotNull ShrinkActionProperties shrinkActionProperties, @NotNull LockService lockService, @NotNull Logger logger, @NotNull Continuation<? super Boolean> $completion) {
        String lockID = StepUtilsKt.getShrinkLockID(shrinkActionProperties.getNodeName());
        logger.info("Deleting lock: " + lockID);
        return OpenSearchExtensionsKt.suspendUntil(lockService, (arg_0, arg_1) -> StepUtilsKt.deleteShrinkLock$lambda$2(lockID, arg_0, arg_1), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object renewShrinkLock(@NotNull ShrinkActionProperties shrinkActionProperties, @NotNull LockService lockService, @NotNull Logger logger, @NotNull Continuation<? super LockModel> $completion) {
        if (!($completion instanceof renewShrinkLock.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StepUtilsKt.renewShrinkLock(null, null, null, (Continuation<? super LockModel>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                lock = StepUtilsKt.getShrinkLockModel(shrinkActionProperties);
                $continuation.L$0 = shrinkActionProperties;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)lockService);
                $continuation.L$2 = logger;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)lock);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil(lockService, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, renewShrinkLock$lambda$3(org.opensearch.jobscheduler.spi.LockModel org.opensearch.jobscheduler.spi.utils.LockService org.opensearch.core.action.ActionListener ), (Lorg/opensearch/jobscheduler/spi/utils/LockService;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((LockModel)lock), $continuation);
                ** if (v0 != var9_6) goto lbl23
lbl22:
                // 1 sources

                return var9_6;
lbl23:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                lock = (LockModel)$continuation.L$3;
                logger = (Logger)$continuation.L$2;
                lockService = (LockService)$continuation.L$1;
                shrinkActionProperties = (ShrinkActionProperties)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    var5_9 = (LockModel)v0;
                }
                catch (Exception e) {
                    logger.error("Failed to renew Shrink action lock on node [" + shrinkActionProperties.getNodeName() + "]: " + e);
                    var5_9 = null;
                }
                return var5_9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final LockModel getShrinkLockModel(@NotNull ShrinkActionProperties shrinkActionProperties) {
        Intrinsics.checkNotNullParameter((Object)shrinkActionProperties, (String)"shrinkActionProperties");
        return StepUtilsKt.getShrinkLockModel(shrinkActionProperties.getNodeName(), ".opendistro-ism-config", shrinkActionProperties.getLockEpochSecond(), shrinkActionProperties.getLockPrimaryTerm(), shrinkActionProperties.getLockSeqNo(), shrinkActionProperties.getLockDurationSecond());
    }

    @NotNull
    public static final LockModel getShrinkLockModel(@NotNull String nodeName, @NotNull String jobIndexName, long lockEpochSecond, long lockPrimaryTerm, long lockSeqNo, long lockDurationSecond) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)jobIndexName, (String)"jobIndexName");
        String jobID = StepUtilsKt.getShrinkJobID(nodeName);
        Instant instant = Instant.ofEpochSecond(lockEpochSecond);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
        Instant lockCreationInstant = instant;
        return new LockModel(jobIndexName, jobID, lockCreationInstant, lockDurationSecond, false, lockSeqNo, lockPrimaryTerm);
    }

    @NotNull
    public static final ShrinkActionProperties getUpdatedShrinkActionProperties(@NotNull ShrinkActionProperties shrinkActionProperties, @NotNull LockModel lock) {
        Intrinsics.checkNotNullParameter((Object)shrinkActionProperties, (String)"shrinkActionProperties");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        return new ShrinkActionProperties(shrinkActionProperties.getNodeName(), shrinkActionProperties.getTargetIndexName(), shrinkActionProperties.getTargetNumShards(), lock.getPrimaryTerm(), lock.getSeqNo(), lock.getLockTime().getEpochSecond(), lock.getLockDurationSeconds(), shrinkActionProperties.getOriginalIndexSettings());
    }

    @NotNull
    public static final Instant getActionStartTime(@NotNull ManagedIndexMetaData managedIndexMetaData) {
        Intrinsics.checkNotNullParameter((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        ActionMetaData actionMetadata = managedIndexMetaData.getActionMetaData();
        Object object = actionMetadata;
        if (object != null && (object = object.getStartTime()) != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            Instant instant = Instant.ofEpochMilli(it);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
            return instant;
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return instant;
    }

    public static final long getFreeBytesThresholdHigh(@NotNull ClusterSettings clusterSettings, long totalNodeBytes) {
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        DiskThresholdSettings diskThresholdSettings = new DiskThresholdSettings(StepUtilsKt.getDiskSettings(clusterSettings), clusterSettings);
        Double diskThresholdPercent = diskThresholdSettings.getFreeDiskThresholdHigh();
        ByteSizeValue diskThresholdBytes = diskThresholdSettings.getFreeBytesThresholdHigh();
        return diskThresholdPercent > 0.001 ? (long)(diskThresholdPercent / (double)100 * (double)totalNodeBytes) : diskThresholdBytes.getBytes();
    }

    @NotNull
    public static final Settings getDiskSettings(@NotNull ClusterSettings clusterSettings) {
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        Settings settings = Settings.builder().put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), (String)clusterSettings.get(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING)).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), (String)clusterSettings.get(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING)).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), (String)clusterSettings.get(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING)).build();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"build(...)");
        return settings;
    }

    public static final long getNodeFreeDiskSpaceAfterShrink(@NotNull NodeStats node, long indexSizeInBytes, @NotNull ClusterSettings clusterSettings) {
        long totalNodeDisk;
        long freeBytesThresholdHigh;
        long requiredBytes;
        long diskSpaceLeftInNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        FsInfo fsStats = node.getFs();
        if (fsStats != null && (diskSpaceLeftInNode = fsStats.getTotal().getFree().getBytes()) > (requiredBytes = (long)2 * indexSizeInBytes + (freeBytesThresholdHigh = StepUtilsKt.getFreeBytesThresholdHigh(clusterSettings, totalNodeDisk = fsStats.getTotal().getTotal().getBytes())))) {
            return diskSpaceLeftInNode - requiredBytes;
        }
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object isIndexGreen(@NotNull Client client, @NotNull String indexName, @NotNull TimeValue timeout, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isIndexGreen.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StepUtilsKt.isIndexGreen(null, null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new String[]{indexName};
                healthReq = new ClusterHealthRequest().indices(var5_7).waitForGreenStatus().timeout(timeout);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexName);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)timeout);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)healthReq);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client.admin().cluster(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, isIndexGreen$lambda$5(org.opensearch.action.admin.cluster.health.ClusterHealthRequest org.opensearch.transport.client.ClusterAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/ClusterAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((ClusterHealthRequest)healthReq), $continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                healthReq = (ClusterHealthRequest)$continuation.L$3;
                timeout = (TimeValue)$continuation.L$2;
                indexName = (String)$continuation.L$1;
                client = (Client)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                return Boxing.boxBoolean((boolean)((response = (ClusterHealthResponse)v0).isTimedOut() == false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object isIndexGreen$default(Client client, String string, TimeValue timeValue, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            timeValue = new TimeValue(30000L);
        }
        return StepUtilsKt.isIndexGreen(client, string, timeValue, (Continuation<? super Boolean>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object resetReadOnlyAndRouting(@NotNull String index, @NotNull Client client, @NotNull Map<String, String> originalSettings, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof resetReadOnlyAndRouting.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StepUtilsKt.resetReadOnlyAndRouting(null, null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                allocationSettings = Settings.builder().put("index.routing.allocation.require._name", originalSettings.get("index.routing.allocation.require._name")).put(IndexMetadata.SETTING_BLOCKS_WRITE, (String)originalSettings.get(IndexMetadata.SETTING_BLOCKS_WRITE)).build();
                Intrinsics.checkNotNull((Object)allocationSettings);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)index);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)originalSettings);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)allocationSettings);
                $continuation.label = 1;
                v0 = StepUtilsKt.issueUpdateSettingsRequest(client, index, allocationSettings, (Continuation<? super AcknowledgedResponse>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                allocationSettings = (Settings)$continuation.L$3;
                originalSettings = (Map)$continuation.L$2;
                client = (Client)$continuation.L$1;
                index = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                if (!(response = (AcknowledgedResponse)v0).isAcknowledged()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final String getShrinkLockID(@NotNull String nodeName) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        String string = LockModel.generateLockId((String)".opendistro-ism-config", (String)StepUtilsKt.getShrinkJobID(nodeName));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateLockId(...)");
        return string;
    }

    @NotNull
    public static final String getShrinkJobID(@NotNull String nodeName) {
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        return "shrink-node_name-" + nodeName;
    }

    @NotNull
    public static final Map<Integer, Set<String>> getShardIdToNodeNameSet(@NotNull ShardStats[] shardStats, @NotNull DiscoveryNodes nodes) {
        Intrinsics.checkNotNullParameter((Object)shardStats, (String)"shardStats");
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        Map shardIdToNodeList = new LinkedHashMap();
        for (ShardStats shard : shardStats) {
            String nodeName;
            int shardId = shard.getShardRouting().shardId().getId();
            if (nodes.get(shard.getShardRouting().currentNodeId()).getName() == null) continue;
            if (shardIdToNodeList.containsKey(shardId)) {
                Set set = (Set)shardIdToNodeList.get(shardId);
                if (set != null) {
                    set.add(nodeName);
                }
                continue;
            }
            Map map = shardIdToNodeList;
            Integer n = shardId;
            Object object = new String[]{nodeName};
            object = SetsKt.mutableSetOf((Object[])object);
            map.put(n, object);
        }
        return shardIdToNodeList;
    }

    private static final Unit issueUpdateSettingsRequest$lambda$0(Settings $settings, String $indexName, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{$indexName};
        $this$suspendUntil.updateSettings(new UpdateSettingsRequest($settings, stringArray), it);
        return Unit.INSTANCE;
    }

    private static final Unit releaseShrinkLock$lambda$1(LockModel $lock, LockService $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.release($lock, it);
        return Unit.INSTANCE;
    }

    private static final Unit deleteShrinkLock$lambda$2(String $lockID, LockService $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.deleteLock($lockID, it);
        return Unit.INSTANCE;
    }

    private static final Unit renewShrinkLock$lambda$3(LockModel $lock, LockService $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.renewLock($lock, it);
        return Unit.INSTANCE;
    }

    private static final Unit isIndexGreen$lambda$5(ClusterHealthRequest $healthReq, ClusterAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.health($healthReq, it);
        return Unit.INSTANCE;
    }
}

