/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.refreshanalyzer;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.core.action.ShardOperationFailedException;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.refreshanalyzer.RefreshSearchAnalyzerShardResponse;
import org.opensearch.rest.action.RestActions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B=\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\u0004\b\u0004\u0010\u000fJ\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u000b0\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerResponse;", "Lorg/opensearch/action/support/broadcast/BroadcastResponse;", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "<init>", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "totalShards", "", "successfulShards", "failedShards", "shardFailures", "", "Lorg/opensearch/core/action/support/DefaultShardOperationFailedException;", "shardResponses", "Lorg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerShardResponse;", "(IIILjava/util/List;Ljava/util/List;)V", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "getSuccessfulRefreshDetails", "", "", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRefreshSearchAnalyzerResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshSearchAnalyzerResponse.kt\norg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerResponse\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,100:1\n37#2:101\n36#2,3:102\n*S KotlinDebug\n*F\n+ 1 RefreshSearchAnalyzerResponse.kt\norg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerResponse\n*L\n45#1:101\n45#1:102,3\n*E\n"})
public final class RefreshSearchAnalyzerResponse
extends BroadcastResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private List<RefreshSearchAnalyzerShardResponse> shardResponses;
    private List<DefaultShardOperationFailedException> shardFailures;
    @NotNull
    private static final ConstructingObjectParser<RefreshSearchAnalyzerResponse, Void> PARSER = new ConstructingObjectParser("_refresh_search_analyzers", true, RefreshSearchAnalyzerResponse::PARSER$lambda$0);

    public RefreshSearchAnalyzerResponse(@NotNull StreamInput inp) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        inp.readList(RefreshSearchAnalyzerShardResponse::new);
        inp.readList(DefaultShardOperationFailedException::readShardOperationFailed);
    }

    public RefreshSearchAnalyzerResponse(int totalShards, int successfulShards, int failedShards, @NotNull List<? extends DefaultShardOperationFailedException> shardFailures, @NotNull List<RefreshSearchAnalyzerShardResponse> shardResponses) {
        Intrinsics.checkNotNullParameter(shardFailures, (String)"shardFailures");
        Intrinsics.checkNotNullParameter(shardResponses, (String)"shardResponses");
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardResponses = CollectionsKt.toMutableList((Collection)shardResponses);
        this.shardFailures = CollectionsKt.toMutableList((Collection)shardFailures);
    }

    @Nullable
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) throws IOException {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.startObject();
        int n = this.getTotalShards();
        int n2 = this.getSuccessfulShards();
        int n3 = this.getFailedShards();
        List<DefaultShardOperationFailedException> list = this.shardFailures;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shardFailures");
            list = null;
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RestActions.buildBroadcastShardsHeader((XContentBuilder)builder, (ToXContent.Params)params, (int)n, (int)n2, (int)-1, (int)n3, (ShardOperationFailedException[])((ShardOperationFailedException[])thisCollection$iv.toArray(new DefaultShardOperationFailedException[0])));
        builder.startArray("successful_refresh_details");
        Map<String, List<String>> successfulIndices = this.getSuccessfulRefreshDetails();
        for (String index2 : successfulIndices.keySet()) {
            List<String> reloadedAnalyzers;
            Intrinsics.checkNotNull(successfulIndices.get(index2));
            builder.startObject().field("index", index2).startArray("refreshed_analyzers");
            for (String analyzer : reloadedAnalyzers) {
                builder.value(analyzer);
            }
            builder.endArray().endObject();
        }
        builder.endArray().endObject();
        return builder;
    }

    @NotNull
    public final Map<String, List<String>> getSuccessfulRefreshDetails() {
        Map successfulRefreshDetails = new HashMap();
        Set failedIndices = new LinkedHashSet();
        List<DefaultShardOperationFailedException> list = this.shardFailures;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shardFailures");
            list = null;
        }
        for (DefaultShardOperationFailedException failure : list) {
            String string = failure.index();
            Intrinsics.checkNotNull((Object)string);
            failedIndices.add(string);
        }
        List<RefreshSearchAnalyzerShardResponse> list2 = this.shardResponses;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shardResponses");
            list2 = null;
        }
        for (RefreshSearchAnalyzerShardResponse response2 : list2) {
            if (failedIndices.contains(response2.getIndex())) continue;
            successfulRefreshDetails.putIfAbsent(response2.getIndex(), response2.getReloadedAnalyzers());
        }
        return successfulRefreshDetails;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        List<RefreshSearchAnalyzerShardResponse> list = this.shardResponses;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shardResponses");
            list = null;
        }
        out.writeCollection((Collection)list);
        List<DefaultShardOperationFailedException> list2 = this.shardFailures;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shardFailures");
            list2 = null;
        }
        out.writeCollection((Collection)list2);
    }

    private static final RefreshSearchAnalyzerResponse PARSER$lambda$0(Object[] arg) {
        List<RefreshSearchAnalyzerShardResponse> list;
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Object object = arg[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.refreshanalyzer.RefreshSearchAnalyzerResponse");
        RefreshSearchAnalyzerResponse response2 = (RefreshSearchAnalyzerResponse)((Object)object);
        int n = response2.getTotalShards();
        int n2 = response2.getSuccessfulShards();
        int n3 = response2.getFailedShards();
        List<DefaultShardOperationFailedException> list2 = response2.shardFailures;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shardFailures");
            list2 = null;
        }
        if ((list = response2.shardResponses) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shardResponses");
            list = null;
        }
        return new RefreshSearchAnalyzerResponse(n, n2, n3, list2, list);
    }

    static {
        BroadcastResponse.declareBroadcastFields(PARSER);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerResponse$Companion;", "", "<init>", "()V", "PARSER", "Lorg/opensearch/core/xcontent/ConstructingObjectParser;", "Lorg/opensearch/indexmanagement/refreshanalyzer/RefreshSearchAnalyzerResponse;", "Ljava/lang/Void;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

