/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataset.remote;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.annotation.InputDataSet;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;

@InputDataSet(value=MLInputDataType.REMOTE)
public class RemoteInferenceInputDataSet
extends MLInputDataset {
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG = CommonValue.VERSION_2_16_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_DLQ_CONFIG = CommonValue.VERSION_2_19_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_OPTIONAL_STRING = CommonValue.VERSION_3_3_0;
    private Map<String, String> parameters;
    private ConnectorAction.ActionType actionType;
    private Map<String, String> dlq;

    public RemoteInferenceInputDataSet(Map<String, String> parameters, ConnectorAction.ActionType actionType, Map<String, String> dlq) {
        super(MLInputDataType.REMOTE);
        this.parameters = parameters;
        this.actionType = actionType;
        this.dlq = dlq;
    }

    public RemoteInferenceInputDataSet(Map<String, String> parameters, ConnectorAction.ActionType actionType) {
        this(parameters, actionType, null);
    }

    public RemoteInferenceInputDataSet(Map<String, String> parameters) {
        this(parameters, null, null);
    }

    public RemoteInferenceInputDataSet(StreamInput streamInput) throws IOException {
        super(MLInputDataType.REMOTE);
        Version streamInputVersion = streamInput.getVersion();
        if (streamInput.readBoolean()) {
            this.parameters = streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_OPTIONAL_STRING) ? streamInput.readMap(StreamInput::readString, StreamInput::readOptionalString) : streamInput.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG)) {
            this.actionType = streamInput.readBoolean() ? (ConnectorAction.ActionType)streamInput.readEnum(ConnectorAction.ActionType.class) : null;
        }
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_DLQ_CONFIG)) {
            this.dlq = streamInput.readBoolean() ? streamInput.readMap(s -> s.readString(), s -> s.readString()) : null;
        }
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        Version streamOutputVersion = streamOutput.getVersion();
        if (this.parameters != null) {
            streamOutput.writeBoolean(true);
            if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_OPTIONAL_STRING)) {
                streamOutput.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
            } else {
                streamOutput.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeString);
            }
        } else {
            streamOutput.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_CLIENT_CONFIG)) {
            if (this.actionType != null) {
                streamOutput.writeBoolean(true);
                streamOutput.writeEnum((Enum)this.actionType);
            } else {
                streamOutput.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_DLQ_CONFIG)) {
            if (this.dlq != null) {
                streamOutput.writeBoolean(true);
                streamOutput.writeMap(this.dlq, StreamOutput::writeString, StreamOutput::writeString);
            } else {
                streamOutput.writeBoolean(false);
            }
        }
    }

    @Generated
    public static RemoteInferenceInputDataSetBuilder builder() {
        return new RemoteInferenceInputDataSetBuilder();
    }

    @Generated
    public RemoteInferenceInputDataSetBuilder toBuilder() {
        return new RemoteInferenceInputDataSetBuilder().parameters(this.parameters).actionType(this.actionType).dlq(this.dlq);
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public ConnectorAction.ActionType getActionType() {
        return this.actionType;
    }

    @Generated
    public Map<String, String> getDlq() {
        return this.dlq;
    }

    @Generated
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setActionType(ConnectorAction.ActionType actionType) {
        this.actionType = actionType;
    }

    @Generated
    public void setDlq(Map<String, String> dlq) {
        this.dlq = dlq;
    }

    @Generated
    public static class RemoteInferenceInputDataSetBuilder {
        @Generated
        private Map<String, String> parameters;
        @Generated
        private ConnectorAction.ActionType actionType;
        @Generated
        private Map<String, String> dlq;

        @Generated
        RemoteInferenceInputDataSetBuilder() {
        }

        @Generated
        public RemoteInferenceInputDataSetBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public RemoteInferenceInputDataSetBuilder actionType(ConnectorAction.ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        @Generated
        public RemoteInferenceInputDataSetBuilder dlq(Map<String, String> dlq) {
            this.dlq = dlq;
            return this;
        }

        @Generated
        public RemoteInferenceInputDataSet build() {
            return new RemoteInferenceInputDataSet(this.parameters, this.actionType, this.dlq);
        }

        @Generated
        public String toString() {
            return "RemoteInferenceInputDataSet.RemoteInferenceInputDataSetBuilder(parameters=" + String.valueOf(this.parameters) + ", actionType=" + String.valueOf((Object)this.actionType) + ", dlq=" + String.valueOf(this.dlq) + ")";
        }
    }
}

