/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.ml.common.memorycontainer.MemoryType;

public class MLDeleteMemoriesByQueryRequest
extends ActionRequest
implements ToXContentObject {
    private static final String QUERY_FIELD = "query";
    private String memoryContainerId;
    private MemoryType memoryType;
    private QueryBuilder query;

    public MLDeleteMemoriesByQueryRequest(String memoryContainerId, MemoryType memoryType, QueryBuilder query) {
        this.memoryContainerId = memoryContainerId;
        this.memoryType = memoryType;
        this.query = query;
    }

    public MLDeleteMemoriesByQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.memoryContainerId = in.readString();
        this.memoryType = (MemoryType)in.readEnum(MemoryType.class);
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.memoryContainerId);
        out.writeEnum((Enum)this.memoryType);
        out.writeNamedWriteable((NamedWriteable)this.query);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.memoryContainerId == null || this.memoryContainerId.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Memory container ID is required", validationException);
        }
        if (this.memoryType == null) {
            validationException = ValidateActions.addValidationError((String)"Memory type is required", (ActionRequestValidationException)validationException);
        }
        if (this.query == null) {
            validationException = ValidateActions.addValidationError((String)"Query is required", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("memory_container_id", this.memoryContainerId);
        builder.field("memory_type", this.memoryType.getValue());
        builder.field(QUERY_FIELD, (ToXContent)this.query);
        builder.endObject();
        return builder;
    }

    public static MLDeleteMemoriesByQueryRequest parse(XContentParser parser) throws IOException {
        String memoryContainerId = null;
        MemoryType memoryType = null;
        QueryBuilder query = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "memory_container_id": {
                    memoryContainerId = parser.text();
                    continue block10;
                }
                case "memory_type": {
                    memoryType = MemoryType.fromString(parser.text());
                    continue block10;
                }
                case "query": {
                    query = MLDeleteMemoriesByQueryRequest.parseQuery(parser);
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        return new MLDeleteMemoriesByQueryRequest(memoryContainerId, memoryType, query);
    }

    private static QueryBuilder parseQuery(XContentParser parser) throws IOException {
        return AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
    }

    @Generated
    public static MLDeleteMemoriesByQueryRequestBuilder builder() {
        return new MLDeleteMemoriesByQueryRequestBuilder();
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    @Generated
    public QueryBuilder getQuery() {
        return this.query;
    }

    @Generated
    public static class MLDeleteMemoriesByQueryRequestBuilder {
        @Generated
        private String memoryContainerId;
        @Generated
        private MemoryType memoryType;
        @Generated
        private QueryBuilder query;

        @Generated
        MLDeleteMemoriesByQueryRequestBuilder() {
        }

        @Generated
        public MLDeleteMemoriesByQueryRequestBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLDeleteMemoriesByQueryRequestBuilder memoryType(MemoryType memoryType) {
            this.memoryType = memoryType;
            return this;
        }

        @Generated
        public MLDeleteMemoriesByQueryRequestBuilder query(QueryBuilder query) {
            this.query = query;
            return this;
        }

        @Generated
        public MLDeleteMemoriesByQueryRequest build() {
            return new MLDeleteMemoriesByQueryRequest(this.memoryContainerId, this.memoryType, this.query);
        }

        @Generated
        public String toString() {
            return "MLDeleteMemoriesByQueryRequest.MLDeleteMemoriesByQueryRequestBuilder(memoryContainerId=" + this.memoryContainerId + ", memoryType=" + String.valueOf((Object)this.memoryType) + ", query=" + String.valueOf(this.query) + ")";
        }
    }
}

