/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.batch.utils;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.neuralsearch.highlight.batch.HighlightContext;
import org.opensearch.neuralsearch.processor.highlight.SentenceHighlightingRequest;
import org.opensearch.neuralsearch.processor.util.ProcessorUtils;
import org.opensearch.search.SearchHit;

public class HighlightRequestPreparer {
    @Generated
    private static final Logger log = LogManager.getLogger(HighlightRequestPreparer.class);

    public HighlightContext prepare(SearchResponse response, String queryText, String fieldName, String modelId, long startTime, String preTag, String postTag) {
        SearchHit[] hits = response.getHits().getHits();
        ArrayList<SentenceHighlightingRequest> requests = new ArrayList<SentenceHighlightingRequest>();
        ArrayList<SearchHit> validHits = new ArrayList<SearchHit>();
        for (SearchHit hit : hits) {
            String fieldText = this.extractFieldText(hit, fieldName);
            if (fieldText == null || fieldText.isEmpty()) continue;
            requests.add((SentenceHighlightingRequest)((SentenceHighlightingRequest.SentenceHighlightingRequestBuilder)((SentenceHighlightingRequest.SentenceHighlightingRequestBuilder)((SentenceHighlightingRequest.SentenceHighlightingRequestBuilder)SentenceHighlightingRequest.builder().modelId(modelId)).question(queryText)).context(fieldText)).build());
            validHits.add(hit);
        }
        return HighlightContext.builder().requests(requests).validHits(validHits).fieldName(fieldName).originalResponse(response).startTime(startTime).preTag(preTag).postTag(postTag).build();
    }

    private String extractFieldText(SearchHit hit, String fieldName) {
        return ProcessorUtils.getValueFromSource(hit.getSourceAsMap(), fieldName).map(Object::toString).orElse(null);
    }
}

