/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.optimization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.neuralsearch.processor.util.ProcessorUtils;
import org.opensearch.neuralsearch.util.ProcessorDocumentUtils;

public abstract class InferenceFilter {
    @Generated
    private static final Logger log = LogManager.getLogger(InferenceFilter.class);
    protected Map<String, String> reversedFieldMap;

    public InferenceFilter(Map<String, Object> fieldMap) {
        this.reversedFieldMap = ProcessorDocumentUtils.flattenAndFlip(fieldMap);
    }

    public abstract Object filterInferenceValue(String var1, Object var2, Map<String, Object> var3, Map<String, Object> var4, int var5);

    public abstract Object copyEmbeddingForSingleObject(String var1, Object var2, Object var3, Object var4, Map<String, Object> var5, int var6);

    public abstract List<Object> copyEmbeddingForListObject(String var1, List<Object> var2, List<Object> var3, List<Object> var4, Map<String, Object> var5);

    public Map<String, Object> filterAndCopyExistingEmbeddings(Map<String, Object> existingSourceAndMetadataMap, Map<String, Object> sourceAndMetadataMap, Map<String, Object> processMap) {
        return this.filterAndCopyExistingEmbeddings(existingSourceAndMetadataMap, sourceAndMetadataMap, processMap, "");
    }

    private Map<String, Object> filterAndCopyExistingEmbeddings(Map<String, Object> existingSourceAndMetadataMap, Map<String, Object> sourceAndMetadataMap, Map<String, Object> processMap, String traversedPath) {
        HashMap<String, Object> filteredProcessMap = new HashMap<String, Object>();
        Map<String, Object> castedProcessMap = ProcessorUtils.unsafeCastToObjectMap(processMap);
        for (Map.Entry<String, Object> entry : castedProcessMap.entrySet()) {
            String currentPath;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = currentPath = traversedPath.isEmpty() ? key : traversedPath + "." + key;
            if (value instanceof Map) {
                Map<String, Object> filteredInnerMap = this.filterAndCopyExistingEmbeddings(existingSourceAndMetadataMap, sourceAndMetadataMap, ProcessorUtils.unsafeCastToObjectMap(value), currentPath);
                filteredProcessMap.put(key, filteredInnerMap.isEmpty() ? null : filteredInnerMap);
                continue;
            }
            if (value instanceof List) {
                List<Object> processedList = this.filterListValue(currentPath, ProcessorUtils.unsafeCastToObjectList(value), sourceAndMetadataMap, existingSourceAndMetadataMap);
                filteredProcessMap.put(key, processedList);
                continue;
            }
            if (!(value instanceof String)) continue;
            Object processedValue = this.filterInferenceValue(currentPath, value, sourceAndMetadataMap, existingSourceAndMetadataMap, -1);
            filteredProcessMap.put(key, processedValue);
        }
        return filteredProcessMap;
    }

    protected List<Object> filterListValue(String embeddingKey, List<Object> processList, Map<String, Object> sourceAndMetadataMap, Map<String, Object> existingSourceAndMetadataMap) {
        String textKey = this.reversedFieldMap.get(embeddingKey);
        Optional<Object> existingListOptional = ProcessorUtils.getValueFromSource(existingSourceAndMetadataMap, textKey);
        Optional<Object> embeddingListOptional = ProcessorUtils.getValueFromSource(existingSourceAndMetadataMap, embeddingKey);
        if (!existingListOptional.isPresent() || !embeddingListOptional.isPresent()) {
            return processList;
        }
        List<Object> existingListValue = ProcessorUtils.unsafeCastToObjectList(existingListOptional.get());
        if (existingListValue.getFirst() instanceof List) {
            return this.copyEmbeddingForListObject(embeddingKey, processList, ProcessorUtils.unsafeCastToObjectList(existingListValue.getFirst()), ProcessorUtils.unsafeCastToObjectList(embeddingListOptional.get()), sourceAndMetadataMap);
        }
        return this.filterMapValuesInList(embeddingKey, processList, ProcessorUtils.unsafeCastToObjectList(existingListOptional.get()), ProcessorUtils.unsafeCastToObjectList(embeddingListOptional.get()), sourceAndMetadataMap);
    }

    public List<Object> filterMapValuesInList(String embeddingKey, List<Object> processList, List<Object> existingList, List<Object> embeddingList, Map<String, Object> sourceAndMetadataMap) {
        ArrayList<Object> filteredList = new ArrayList<Object>();
        ListIterator<Object> processListIterator = processList.listIterator();
        ListIterator<Object> existingListIterator = existingList.listIterator();
        ListIterator<Object> embeddingListIterator = embeddingList.listIterator();
        int index = 0;
        for (Object processValue : processList) {
            if (Objects.nonNull(processValue) && existingListIterator.hasNext() && embeddingListIterator.hasNext()) {
                Object processedItem = this.copyEmbeddingForSingleObject(embeddingKey, processValue, existingListIterator.next(), embeddingListIterator.next(), sourceAndMetadataMap, index);
                filteredList.add(processedItem);
            }
            ++index;
        }
        return filteredList;
    }
}

