/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search;

import java.util.Locale;
import lombok.Generated;
import org.apache.lucene.search.ScoreMode;

public class HitsThresholdChecker {
    private int hitCount;
    private final int totalHitsThreshold;

    public HitsThresholdChecker(int totalHitsThreshold) {
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "totalHitsThreshold must be >= 0, got %d", totalHitsThreshold));
        }
        this.totalHitsThreshold = totalHitsThreshold;
    }

    public void incrementHitCount() {
        ++this.hitCount;
    }

    public boolean isThresholdReached() {
        return this.hitCount >= this.getTotalHitsThreshold();
    }

    public ScoreMode scoreMode() {
        return ScoreMode.TOP_SCORES;
    }

    @Generated
    public int getTotalHitsThreshold() {
        return this.totalHitsThreshold;
    }
}

