/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SetProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, SetProcessor> {
    @Nullable
    private final String copyFrom;
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreEmptyValue;
    @Nullable
    private final String mediaType;
    @Nullable
    private final Boolean override;
    @Nullable
    private final JsonData value;
    public static final JsonpDeserializer<SetProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SetProcessor::setupSetProcessorDeserializer);

    private SetProcessor(Builder builder) {
        super(builder);
        this.copyFrom = builder.copyFrom;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreEmptyValue = builder.ignoreEmptyValue;
        this.mediaType = builder.mediaType;
        this.override = builder.override;
        this.value = builder.value;
    }

    public static SetProcessor of(Function<Builder, ObjectBuilder<SetProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Set;
    }

    @Nullable
    public final String copyFrom() {
        return this.copyFrom;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreEmptyValue() {
        return this.ignoreEmptyValue;
    }

    @Nullable
    public final String mediaType() {
        return this.mediaType;
    }

    @Nullable
    public final Boolean override() {
        return this.override;
    }

    @Nullable
    public final JsonData value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.copyFrom != null) {
            generator.writeKey("copy_from");
            generator.write(this.copyFrom);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreEmptyValue != null) {
            generator.writeKey("ignore_empty_value");
            generator.write(this.ignoreEmptyValue.booleanValue());
        }
        if (this.mediaType != null) {
            generator.writeKey("media_type");
            generator.write(this.mediaType);
        }
        if (this.override != null) {
            generator.writeKey("override");
            generator.write(this.override.booleanValue());
        }
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSetProcessorDeserializer(ObjectDeserializer<Builder> op) {
        SetProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::copyFrom, JsonpDeserializer.stringDeserializer(), "copy_from");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreEmptyValue, JsonpDeserializer.booleanDeserializer(), "ignore_empty_value");
        op.add(Builder::mediaType, JsonpDeserializer.stringDeserializer(), "media_type");
        op.add(Builder::override, JsonpDeserializer.booleanDeserializer(), "override");
        op.add(Builder::value, JsonData._DESERIALIZER, "value");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.copyFrom);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreEmptyValue);
        result = 31 * result + Objects.hashCode(this.mediaType);
        result = 31 * result + Objects.hashCode(this.override);
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetProcessor other = (SetProcessor)o;
        return Objects.equals(this.copyFrom, other.copyFrom) && this.field.equals(other.field) && Objects.equals(this.ignoreEmptyValue, other.ignoreEmptyValue) && Objects.equals(this.mediaType, other.mediaType) && Objects.equals(this.override, other.override) && Objects.equals(this.value, other.value);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SetProcessor> {
        @Nullable
        private String copyFrom;
        private String field;
        @Nullable
        private Boolean ignoreEmptyValue;
        @Nullable
        private String mediaType;
        @Nullable
        private Boolean override;
        @Nullable
        private JsonData value;

        public Builder() {
        }

        private Builder(SetProcessor o) {
            super(o);
            this.copyFrom = o.copyFrom;
            this.field = o.field;
            this.ignoreEmptyValue = o.ignoreEmptyValue;
            this.mediaType = o.mediaType;
            this.override = o.override;
            this.value = o.value;
        }

        private Builder(Builder o) {
            super(o);
            this.copyFrom = o.copyFrom;
            this.field = o.field;
            this.ignoreEmptyValue = o.ignoreEmptyValue;
            this.mediaType = o.mediaType;
            this.override = o.override;
            this.value = o.value;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder copyFrom(@Nullable String value) {
            this.copyFrom = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreEmptyValue(@Nullable Boolean value) {
            this.ignoreEmptyValue = value;
            return this;
        }

        @Nonnull
        public final Builder mediaType(@Nullable String value) {
            this.mediaType = value;
            return this;
        }

        @Nonnull
        public final Builder override(@Nullable Boolean value) {
            this.override = value;
            return this;
        }

        @Nonnull
        public final Builder value(@Nullable JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        @Nonnull
        public SetProcessor build() {
            this._checkSingleUse();
            return new SetProcessor(this);
        }
    }
}

