/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.UsageStats;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardAdmissionControlStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardAdmissionControlStats> {
    @Nullable
    private final UsageStats globalCpuUsage;
    @Nullable
    private final UsageStats globalIoUsage;
    public static final JsonpDeserializer<ShardAdmissionControlStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardAdmissionControlStats::setupShardAdmissionControlStatsDeserializer);

    private ShardAdmissionControlStats(Builder builder) {
        this.globalCpuUsage = builder.globalCpuUsage;
        this.globalIoUsage = builder.globalIoUsage;
    }

    public static ShardAdmissionControlStats of(Function<Builder, ObjectBuilder<ShardAdmissionControlStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final UsageStats globalCpuUsage() {
        return this.globalCpuUsage;
    }

    @Nullable
    public final UsageStats globalIoUsage() {
        return this.globalIoUsage;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.globalCpuUsage != null) {
            generator.writeKey("global_cpu_usage");
            this.globalCpuUsage.serialize(generator, mapper);
        }
        if (this.globalIoUsage != null) {
            generator.writeKey("global_io_usage");
            this.globalIoUsage.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardAdmissionControlStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::globalCpuUsage, UsageStats._DESERIALIZER, "global_cpu_usage");
        op.add(Builder::globalIoUsage, UsageStats._DESERIALIZER, "global_io_usage");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.globalCpuUsage);
        result = 31 * result + Objects.hashCode(this.globalIoUsage);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardAdmissionControlStats other = (ShardAdmissionControlStats)o;
        return Objects.equals(this.globalCpuUsage, other.globalCpuUsage) && Objects.equals(this.globalIoUsage, other.globalIoUsage);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardAdmissionControlStats> {
        @Nullable
        private UsageStats globalCpuUsage;
        @Nullable
        private UsageStats globalIoUsage;

        public Builder() {
        }

        private Builder(ShardAdmissionControlStats o) {
            this.globalCpuUsage = o.globalCpuUsage;
            this.globalIoUsage = o.globalIoUsage;
        }

        private Builder(Builder o) {
            this.globalCpuUsage = o.globalCpuUsage;
            this.globalIoUsage = o.globalIoUsage;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder globalCpuUsage(@Nullable UsageStats value) {
            this.globalCpuUsage = value;
            return this;
        }

        @Nonnull
        public final Builder globalCpuUsage(Function<UsageStats.Builder, ObjectBuilder<UsageStats>> fn) {
            return this.globalCpuUsage(fn.apply(new UsageStats.Builder()).build());
        }

        @Nonnull
        public final Builder globalIoUsage(@Nullable UsageStats value) {
            this.globalIoUsage = value;
            return this;
        }

        @Nonnull
        public final Builder globalIoUsage(Function<UsageStats.Builder, ObjectBuilder<UsageStats>> fn) {
            return this.globalIoUsage(fn.apply(new UsageStats.Builder()).build());
        }

        @Override
        @Nonnull
        public ShardAdmissionControlStats build() {
            this._checkSingleUse();
            return new ShardAdmissionControlStats(this);
        }
    }
}

