\name{ConnectedComponentImageFilter}
\alias{ConnectedComponentImageFilter}
\title{ConnectedComponentImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Label the objects in a binary image.
ConnectedComponentImageFilter}
\details{
ConnectedComponentImageFilter labels the objects in a binary image (non-zero pixels are considered
to be objects, zero-valued pixels are considered to be background).
Each distinct object is assigned a unique label. The filter
experiments with some improvements to the existing implementation, and
is based on run length encoding along raster lines. If the output
background value is set to zero (the default), the final object labels
start with 1 and are consecutive. If the output background is set to a
non-zero value (by calling the SetBackgroundValue() routine of the
filter), the final labels start at 0, and remain consecutive except
for skipping the background value as needed. Objects that are reached
earlier by a raster order scan have a lower label. This is different
to the behaviour of the original connected component image filter
which did not produce consecutive labels or impose any particular
ordering.
After the filter is executed, ObjectCount holds the number of
connected components.
See:
ImageToImageFilter
ConnectedComponent for the procedural interface
itk::ConnectedComponentImageFilter for the Doxygen on the original ITK class.
ConnectedComponentImageFilter}
%C++ includes: sitkConnectedComponentImageFilter.h
\section{Methods}{
\describe{
\item{ ConnectedComponentImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image):}{}
\item{Image Execute(const Image &image, const Image &maskImage):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetObjectCount() const:}{
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ConnectedComponentImageFilter():}{
Destructor
}
}
}
