\name{CurvatureAnisotropicDiffusionImageFilter}
\alias{CurvatureAnisotropicDiffusionImageFilter}
\title{CurvatureAnisotropicDiffusionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter performs anisotropic diffusion on a scalar itk::Image using the modified curvature diffusion equation (MCDE).
CurvatureAnisotropicDiffusionImageFilter}
\details{
For detailed information on anisotropic diffusion and the MCDE see
itkAnisotropicDiffusionFunction and
itkCurvatureNDAnisotropicDiffusionFunction.
Inputs and Outputs
The input and output to this filter must be a scalar itk::Image with numerical pixel types (float or double). A user defined type
which correctly defines arithmetic operations with floating point
accuracy should also give correct results.
Parameters
Please first read all the documentation found in AnisotropicDiffusionImageFilter and AnisotropicDiffusionFunction . Also see CurvatureNDAnisotropicDiffusionFunction .
 The default time step for this filter is set to the maximum
theoretically stable value: 0.5 / 2^N, where N is the dimensionality
of the image. For a 2D image, this means valid time steps are below
0.1250. For a 3D image, valid time steps are below 0.0625.
See:
AnisotropicDiffusionImageFilter
AnisotropicDiffusionFunction
CurvatureNDAnisotropicDiffusionFunction
CurvatureAnisotropicDiffusion for the procedural interface
itk::CurvatureAnisotropicDiffusionImageFilter for the Doxygen on the original ITK class.
CurvatureAnisotropicDiffusionImageFilter}
%C++ includes: sitkCurvatureAnisotropicDiffusionImageFilter.h
\section{Methods}{
\describe{
\item{ CurvatureAnisotropicDiffusionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{double EstimateOptimalTimeStep(Image &inImage):}{
This method autmatically sets the optimal timestep for an image given
its spacing.
}
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{double GetConductanceParameter() const:}{}
\item{unsigned int GetConductanceScalingUpdateInterval() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetTimeStep() const:}{}
\item{Self SetConductanceParameter(double ConductanceParameter):}{}
\item{Self SetConductanceScalingUpdateInterval(unsigned int ConductanceScalingUpdateInterval):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetTimeStep(double TimeStep):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~CurvatureAnisotropicDiffusionImageFilter():}{
Destructor
}
}
}
