\name{ForwardFFTImageFilter}
\alias{ForwardFFTImageFilter}
\title{ForwardFFTImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Base class for forward Fast Fourier Transform .
ForwardFFTImageFilter}
\details{
This is a base class for the "forward" or "direct" discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child class available on the system when the
object is created via the object factory system.
This class transforms a real input image into its full complex Fourier
transform. The Fourier transform of a real input image has Hermitian
symmetry: \eqn{ f(\mathbf{x}) = f^*(-\mathbf{x}) } . That is, when the result of the transform is split in half along
the x-dimension, the values in the second half of the transform are
the complex conjugates of values in the first half reflected about the
center of the image in each dimension.
This filter works only for real single-component input image types.
The output generated from a ForwardFFTImageFilter is in the dual space or frequency domain. Refer to FrequencyFFTLayoutImageRegionConstIteratorWithIndex for a description of the layout of frequencies generated after a
forward FFT. Also see ITKImageFrequency for a set of filters requiring
input images in the frequency domain.
See:
Forward1DFFTImageFilter
InverseFFTImageFilter
ComplexToComplexFFTImageFilter
ForwardFFT for the procedural interface
itk::ForwardFFTImageFilter for the Doxygen on the original ITK class.
ForwardFFTImageFilter}
%C++ includes: sitkForwardFFTImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ ForwardFFTImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ForwardFFTImageFilter():}{
Destructor
}
}
}
