\name{LabelIntensityStatisticsImageFilter}
\alias{LabelIntensityStatisticsImageFilter}
\title{LabelIntensityStatisticsImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
a convenient class to convert a label image to a label map and valuate
the statistics attributes at once
LabelIntensityStatisticsImageFilter}
\details{
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
See:
StatisticsLabelObject , LabelStatisticsOpeningImageFilter , LabelStatisticsOpeningImageFilter
itk::LabelImageToStatisticsLabelMapFilter for the Doxygen on the original ITK class.
LabelIntensityStatisticsImageFilter}
%C++ includes: sitkLabelIntensityStatisticsImageFilter.h
\section{Methods}{
\describe{
\item{Self ComputeFeretDiameterOff():}{}
\item{Self ComputeFeretDiameterOn():}{
Set the value of ComputeFeretDiameter to true or false respectfully.
}
\item{Self ComputePerimeterOff():}{}
\item{Self ComputePerimeterOn():}{
Set the value of ComputePerimeter to true or false respectfully.
}
\item{void Execute(const Image &image, const Image &featureImage):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{std::vector< unsigned int > GetBoundingBox(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetCenterOfGravity(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetCentroid(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{bool GetComputeFeretDiameter() const:}{
Set/Get whether the maximum Feret diameter should be computed or not.
The default value is false, because of the high computation time
required.
}
\item{bool GetComputePerimeter() const:}{
Set/Get whether the perimeter should be computed or not. The default
value is false, because of the high computation time required.
}
\item{double GetElongation(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetEquivalentEllipsoidDiameter(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetEquivalentSphericalPerimeter(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetEquivalentSphericalRadius(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetFeretDiameter(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetFlatness(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetKurtosis(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< int64_t > GetLabels() const:}{
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetMaximum(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< uint32_t > GetMaximumIndex(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetMean(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetMedian(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetMinimum(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< uint32_t > GetMinimumIndex(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfBins() const:}{
Set/Get the number of bins in the histogram. Note that the histogram
is used to compute the median value, and that this option may have an
effect on the value of the median.
}
\item{uint64_t GetNumberOfLabels():}{
Return the number of labels after execution.
}
\item{uint64_t GetNumberOfPixels(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{uint64_t GetNumberOfPixelsOnBorder(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetPerimeter(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetPerimeterOnBorder(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetPerimeterOnBorderRatio(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetPhysicalSize(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetPrincipalAxes(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetPrincipalMoments(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< unsigned int > GetRegion(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetRoundness(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetSkewness(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetStandardDeviation(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetSum(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetVariance(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetWeightedElongation(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetWeightedFlatness(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetWeightedPrincipalAxes(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetWeightedPrincipalMoments(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{bool HasLabel(int64_t label):}{
Does the specified label exist? Can only be called after a call a call
to Update().
}
\item{ LabelIntensityStatisticsImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetComputeFeretDiameter(bool ComputeFeretDiameter):}{
Set/Get whether the maximum Feret diameter should be computed or not.
The default value is false, because of the high computation time
required.
}
\item{Self SetComputePerimeter(bool ComputePerimeter):}{
Set/Get whether the perimeter should be computed or not. The default
value is false, because of the high computation time required.
}
\item{Self SetNumberOfBins(uint32_t NumberOfBins):}{
Set/Get the number of bins in the histogram. Note that the histogram
is used to compute the median value, and that this option may have an
effect on the value of the median.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelIntensityStatisticsImageFilter():}{
Destructor
}
}
}
