/*
Copyright (c) 2024 - 2025 Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
#ifndef ROCJPEG_API_NEGATIVE_TESTS_H
#define ROCJPEG_API_NEGATIVE_TESTS_H

#include <iostream>
#include <vector>
#include <rocjpeg/rocjpeg.h>

/**
 * @class RocJpegApiNegativeTests
 * @brief A class to perform negative API tests for the rocJPEG library.
 *
 * This class contains a set of test cases designed to validate the behavior
 * of the rocJPEG library when invalid or unexpected inputs are provided.
 * It ensures the robustness and error handling capabilities of the library.
 */
class RocJpegApiNegativeTests {
    public:
        RocJpegApiNegativeTests();
        ~RocJpegApiNegativeTests();
        int RunTests();
    private:
        int TestInvalidStreamCreate();
        int TestInvalidStreamParse();
        int TestInvalidStreamDestroy();
        int TestInvalidCreate();
        int TestInvalidDestroy();
        int TestInvalidGetImageInfo();
        int TestInvalidDecode();
        int TestInvalidDecodeBatched();
        int TestInvalidGetErrorName();
        RocJpegHandle rocjpeg_handle_;
        RocJpegStreamHandle rocjpeg_stream_handle_;
};

#endif // ROCJPEG_API_NEGATIVE_TESTS_H