#ifdef __cplusplus
extern "C" {
#endif

typedef Boolean Flag;

INLINE Boolean
Is_In_Anonymous_Access_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Assignable_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Digits_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Discrete_Or_Fixed_Point_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Entry_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Evaluable_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Global_Name_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Named_Access_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Numeric_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Record_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Scope_Kind (Entity_Kind kind);

INLINE Boolean
Is_In_Subprogram_Type_Or_Kind (Entity_Kind kind);

enum Entity_Kind : unsigned int {
  E_Void = 0,
  E_Enumeration_Type = 1,
  E_Enumeration_Subtype = 2,
  E_Signed_Integer_Type = 3,
  E_Signed_Integer_Subtype = 4,
  E_Modular_Integer_Type = 5,
  E_Modular_Integer_Subtype = 6,
  E_Ordinary_Fixed_Point_Type = 7,
  E_Ordinary_Fixed_Point_Subtype = 8,
  E_Decimal_Fixed_Point_Type = 9,
  E_Decimal_Fixed_Point_Subtype = 10,
  E_Floating_Point_Type = 11,
  E_Floating_Point_Subtype = 12,
  E_Access_Type = 13,
  E_Access_Subtype = 14,
  E_Access_Attribute_Type = 15,
  E_Allocator_Type = 16,
  E_General_Access_Type = 17,
  E_Access_Subprogram_Type = 18,
  E_Access_Protected_Subprogram_Type = 19,
  E_Anonymous_Access_Protected_Subprogram_Type = 20,
  E_Anonymous_Access_Subprogram_Type = 21,
  E_Anonymous_Access_Type = 22,
  E_Array_Type = 23,
  E_Array_Subtype = 24,
  E_String_Literal_Subtype = 25,
  E_Class_Wide_Type = 26,
  E_Class_Wide_Subtype = 27,
  E_Record_Type = 28,
  E_Record_Subtype = 29,
  E_Record_Type_With_Private = 30,
  E_Record_Subtype_With_Private = 31,
  E_Private_Type = 32,
  E_Private_Subtype = 33,
  E_Limited_Private_Type = 34,
  E_Limited_Private_Subtype = 35,
  E_Incomplete_Type = 36,
  E_Incomplete_Subtype = 37,
  E_Task_Type = 38,
  E_Task_Subtype = 39,
  E_Protected_Type = 40,
  E_Protected_Subtype = 41,
  E_Exception_Type = 42,
  E_Subprogram_Type = 43,
  E_Component = 44,
  E_Discriminant = 45,
  E_Constant = 46,
  E_Variable = 47,
  E_Loop_Parameter = 48,
  E_Out_Parameter = 49,
  E_In_Out_Parameter = 50,
  E_In_Parameter = 51,
  E_Generic_In_Out_Parameter = 52,
  E_Generic_In_Parameter = 53,
  E_Exception = 54,
  E_Named_Integer = 55,
  E_Named_Real = 56,
  E_Enumeration_Literal = 57,
  E_Function = 58,
  E_Operator = 59,
  E_Procedure = 60,
  E_Abstract_State = 61,
  E_Entry = 62,
  E_Entry_Family = 63,
  E_Block = 64,
  E_Entry_Index_Parameter = 65,
  E_Generic_Function = 66,
  E_Generic_Procedure = 67,
  E_Generic_Package = 68,
  E_Label = 69,
  E_Loop = 70,
  E_Return_Statement = 71,
  E_Package = 72,
  E_Package_Body = 73,
  E_Protected_Body = 74,
  E_Task_Body = 75,
  E_Subprogram_Body = 76,
};
#define Number_Entity_Kinds 77

SUBTYPE (Void_Or_Type_Kind, Entity_Kind,
   E_Void,
   E_Subprogram_Type)
SUBTYPE (Type_Kind, Void_Or_Type_Kind,
   E_Enumeration_Type,
   E_Subprogram_Type)
SUBTYPE (Elementary_Kind, Type_Kind,
   E_Enumeration_Type,
   E_Anonymous_Access_Type)
SUBTYPE (Scalar_Kind, Elementary_Kind,
   E_Enumeration_Type,
   E_Floating_Point_Subtype)
SUBTYPE (Discrete_Kind, Scalar_Kind,
   E_Enumeration_Type,
   E_Modular_Integer_Subtype)
SUBTYPE (Enumeration_Kind, Discrete_Kind,
   E_Enumeration_Type,
   E_Enumeration_Subtype)
SUBTYPE (Integer_Kind, Discrete_Kind,
   E_Signed_Integer_Type,
   E_Modular_Integer_Subtype)
SUBTYPE (Signed_Integer_Kind, Integer_Kind,
   E_Signed_Integer_Type,
   E_Signed_Integer_Subtype)
SUBTYPE (Modular_Integer_Kind, Integer_Kind,
   E_Modular_Integer_Type,
   E_Modular_Integer_Subtype)
SUBTYPE (Real_Kind, Scalar_Kind,
   E_Ordinary_Fixed_Point_Type,
   E_Floating_Point_Subtype)
SUBTYPE (Fixed_Point_Kind, Real_Kind,
   E_Ordinary_Fixed_Point_Type,
   E_Decimal_Fixed_Point_Subtype)
SUBTYPE (Ordinary_Fixed_Point_Kind, Fixed_Point_Kind,
   E_Ordinary_Fixed_Point_Type,
   E_Ordinary_Fixed_Point_Subtype)
SUBTYPE (Decimal_Fixed_Point_Kind, Fixed_Point_Kind,
   E_Decimal_Fixed_Point_Type,
   E_Decimal_Fixed_Point_Subtype)
SUBTYPE (Float_Kind, Real_Kind,
   E_Floating_Point_Type,
   E_Floating_Point_Subtype)
SUBTYPE (Access_Kind, Elementary_Kind,
   E_Access_Type,
   E_Anonymous_Access_Type)
SUBTYPE (Access_Subprogram_Kind, Access_Kind,
   E_Access_Subprogram_Type,
   E_Anonymous_Access_Subprogram_Type)
SUBTYPE (Access_Protected_Kind, Access_Subprogram_Kind,
   E_Access_Protected_Subprogram_Type,
   E_Anonymous_Access_Protected_Subprogram_Type)
SUBTYPE (Composite_Kind, Type_Kind,
   E_Array_Type,
   E_Protected_Subtype)
SUBTYPE (Aggregate_Kind, Composite_Kind,
   E_Array_Type,
   E_Record_Subtype)
SUBTYPE (Array_Kind, Aggregate_Kind,
   E_Array_Type,
   E_String_Literal_Subtype)
SUBTYPE (Class_Wide_Kind, Aggregate_Kind,
   E_Class_Wide_Type,
   E_Class_Wide_Subtype)
SUBTYPE (Incomplete_Or_Private_Kind, Composite_Kind,
   E_Record_Type_With_Private,
   E_Incomplete_Subtype)
SUBTYPE (Private_Kind, Incomplete_Or_Private_Kind,
   E_Record_Type_With_Private,
   E_Limited_Private_Subtype)
SUBTYPE (Incomplete_Kind, Incomplete_Or_Private_Kind,
   E_Incomplete_Type,
   E_Incomplete_Subtype)
SUBTYPE (Concurrent_Kind, Composite_Kind,
   E_Task_Type,
   E_Protected_Subtype)
SUBTYPE (Task_Kind, Concurrent_Kind,
   E_Task_Type,
   E_Task_Subtype)
SUBTYPE (Protected_Kind, Concurrent_Kind,
   E_Protected_Type,
   E_Protected_Subtype)
SUBTYPE (Exception_Or_Object_Kind, Entity_Kind,
   E_Component,
   E_Exception)
SUBTYPE (Object_Kind, Exception_Or_Object_Kind,
   E_Component,
   E_Generic_In_Parameter)
SUBTYPE (Record_Field_Kind, Object_Kind,
   E_Component,
   E_Discriminant)
SUBTYPE (Allocatable_Kind, Object_Kind,
   E_Constant,
   E_Loop_Parameter)
SUBTYPE (Constant_Or_Variable_Kind, Allocatable_Kind,
   E_Constant,
   E_Variable)
SUBTYPE (Formal_Kind, Object_Kind,
   E_Out_Parameter,
   E_In_Parameter)
SUBTYPE (Formal_Object_Kind, Object_Kind,
   E_Generic_In_Out_Parameter,
   E_Generic_In_Parameter)
SUBTYPE (Named_Kind, Entity_Kind,
   E_Named_Integer,
   E_Named_Real)
SUBTYPE (Overloadable_Kind, Entity_Kind,
   E_Enumeration_Literal,
   E_Entry)
SUBTYPE (Subprogram_Kind, Overloadable_Kind,
   E_Function,
   E_Procedure)
SUBTYPE (Generic_Unit_Kind, Entity_Kind,
   E_Generic_Function,
   E_Generic_Package)
SUBTYPE (Generic_Subprogram_Kind, Generic_Unit_Kind,
   E_Generic_Function,
   E_Generic_Procedure)
SUBTYPE (Concurrent_Body_Kind, Entity_Kind,
   E_Protected_Body,
   E_Task_Body)

// Membership tests for union types

INLINE Boolean
Is_In_Anonymous_Access_Kind (Entity_Kind kind)
{
   return
      kind == E_Anonymous_Access_Protected_Subprogram_Type ||
      kind == E_Anonymous_Access_Subprogram_Type ||
      kind == E_Anonymous_Access_Type;
}

INLINE Boolean
Is_In_Assignable_Kind (Entity_Kind kind)
{
   return
      kind == E_Variable ||
      kind == E_Out_Parameter ||
      kind == E_In_Out_Parameter;
}

INLINE Boolean
Is_In_Digits_Kind (Entity_Kind kind)
{
   return
      IN (kind, Decimal_Fixed_Point_Kind) ||
      IN (kind, Float_Kind);
}

INLINE Boolean
Is_In_Discrete_Or_Fixed_Point_Kind (Entity_Kind kind)
{
   return
      IN (kind, Discrete_Kind) ||
      IN (kind, Fixed_Point_Kind);
}

INLINE Boolean
Is_In_Entry_Kind (Entity_Kind kind)
{
   return
      kind == E_Entry ||
      kind == E_Entry_Family;
}

INLINE Boolean
Is_In_Evaluable_Kind (Entity_Kind kind)
{
   return
      IN (kind, Exception_Or_Object_Kind) ||
      kind == E_Enumeration_Literal ||
      kind == E_Label ||
      IN (kind, Subprogram_Kind);
}

INLINE Boolean
Is_In_Global_Name_Kind (Entity_Kind kind)
{
   return
      IN (kind, Constant_Or_Variable_Kind) ||
      kind == E_Exception ||
      kind == E_Package ||
      IN (kind, Subprogram_Kind);
}

INLINE Boolean
Is_In_Named_Access_Kind (Entity_Kind kind)
{
   return
      kind == E_Access_Type ||
      kind == E_Access_Subtype ||
      kind == E_Access_Attribute_Type ||
      kind == E_Allocator_Type ||
      kind == E_General_Access_Type ||
      kind == E_Access_Subprogram_Type ||
      kind == E_Access_Protected_Subprogram_Type;
}

INLINE Boolean
Is_In_Numeric_Kind (Entity_Kind kind)
{
   return
      IN (kind, Integer_Kind) ||
      IN (kind, Fixed_Point_Kind) ||
      IN (kind, Float_Kind);
}

INLINE Boolean
Is_In_Record_Kind (Entity_Kind kind)
{
   return
      kind == E_Class_Wide_Type ||
      kind == E_Class_Wide_Subtype ||
      kind == E_Record_Type ||
      kind == E_Record_Subtype ||
      kind == E_Record_Type_With_Private ||
      kind == E_Record_Subtype_With_Private;
}

INLINE Boolean
Is_In_Scope_Kind (Entity_Kind kind)
{
   return
      kind == E_Void ||
      kind == E_Private_Type ||
      kind == E_Private_Subtype ||
      kind == E_Limited_Private_Type ||
      kind == E_Limited_Private_Subtype ||
      IN (kind, Concurrent_Kind) ||
      IN (kind, Subprogram_Kind) ||
      kind == E_Entry ||
      kind == E_Entry_Family ||
      kind == E_Block ||
      IN (kind, Generic_Unit_Kind) ||
      kind == E_Loop ||
      kind == E_Return_Statement ||
      kind == E_Package ||
      kind == E_Package_Body ||
      kind == E_Subprogram_Body ||
      Is_In_Record_Kind (kind) ||
      kind == E_Incomplete_Type ||
      kind == E_Subprogram_Type;
}

INLINE Boolean
Is_In_Subprogram_Type_Or_Kind (Entity_Kind kind)
{
   return
      IN (kind, Subprogram_Kind) ||
      kind == E_Subprogram_Body ||
      kind == E_Subprogram_Type;
}

// Getters for fields

INLINE Entity_Kind Ekind (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 8;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Entity_Kind val = (Entity_Kind) Raw;
   return val;
}

INLINE Convention_Id Basic_Convention (Node_Id N)
{
   const Field_Offset Off = 32;
   const Field_Offset F_Size = 8;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Convention_Id val = (Convention_Id) Raw;
   return val;
}

INLINE Elist_Id Abstract_States (Node_Id N)
{
   const Field_Offset Off = 20;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Elist_Id Accept_Address (Node_Id N)
{
   const Field_Offset Off = 55;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Elist_Id Access_Disp_Table (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Access_Disp_Table_Elab_Flag (Node_Id N)
{
   const Field_Offset Off = 45;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Access_Subprogram_Wrapper (Node_Id N)
{
   const Field_Offset Off = 36;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Activation_Record_Component (Node_Id N)
{
   const Field_Offset Off = 26;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Actual_Subtype (Node_Id N)
{
   const Field_Offset Off = 27;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Address_Taken (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Unat Alignment (Node_Id N)
{
   const Field_Offset Off = 21;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Unat val = (Unat) Raw;
   return val;
}

INLINE Elist_Id Anonymous_Collections (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Anonymous_Designated_Type (Node_Id N)
{
   const Field_Offset Off = 45;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Anonymous_Object (Node_Id N)
{
   const Field_Offset Off = 47;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Associated_Entity (Node_Id N)
{
   const Field_Offset Off = 9;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Associated_Formal_Package (Node_Id N)
{
   const Field_Offset Off = 50;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Associated_Node_For_Itype (Node_Id N)
{
   const Field_Offset Off = 34;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Associated_Storage_Pool (Node_Id N)
{
   const Field_Offset Off = 36;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Root_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Barrier_Function (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id BIP_Initialization_Call (Node_Id N)
{
   const Field_Offset Off = 38;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Block_Node (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Body_Entity (Node_Id N)
{
   const Field_Offset Off = 28;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Body_Needed_For_Inlining (Node_Id N)
{
   const Field_Offset Off = 540;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Body_Needed_For_SAL (Node_Id N)
{
   const Field_Offset Off = 539;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Elist_Id Body_References (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Flag C_Pass_By_Copy (Node_Id N)
{
   const Field_Offset Off = 978;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Can_Never_Be_Null (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Can_Use_Internal_Rep (Node_Id N)
{
   const Field_Offset Off = 928;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Checks_May_Be_Suppressed (Node_Id N)
{
   const Field_Offset Off = 31;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Class_Postconditions (Node_Id N)
{
   const Field_Offset Off = 31;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Class_Preconditions (Node_Id N)
{
   const Field_Offset Off = 33;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Class_Preconditions_Subprogram (Node_Id N)
{
   const Field_Offset Off = 41;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Class_Wide_Equivalent_Type (Node_Id N)
{
   const Field_Offset Off = 31;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Class_Wide_Type (Node_Id N)
{
   const Field_Offset Off = 33;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Cloned_Subtype (Node_Id N)
{
   const Field_Offset Off = 50;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Component_Alignment_Kind Component_Alignment (Node_Id N)
{
   const Field_Offset Off = 487;
   const Field_Offset F_Size = 2;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Component_Alignment_Kind val = (Component_Alignment_Kind) Raw;
   return val;
}

INLINE Uint Component_Bit_Offset (Node_Id N)
{
   const Field_Offset Off = 21;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Node_Id Component_Clause (Node_Id N)
{
   const Field_Offset Off = 24;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Uint Component_Size (Node_Id N)
{
   const Field_Offset Off = 42;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Node_Id Component_Type (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Contract (Node_Id N)
{
   const Field_Offset Off = 25;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Contract_Wrapper (Node_Id N)
{
   const Field_Offset Off = 20;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Concurrent_Type (Node_Id N)
{
   const Field_Offset Off = 49;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Discriminant (Node_Id N)
{
   const Field_Offset Off = 28;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Equality (Node_Id N)
{
   const Field_Offset Off = 34;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Record_Component (Node_Id N)
{
   const Field_Offset Off = 25;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Record_Type (Node_Id N)
{
   const Field_Offset Off = 46;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Corresponding_Remote_Type (Node_Id N)
{
   const Field_Offset Off = 48;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id CR_Discriminant (Node_Id N)
{
   const Field_Offset Off = 51;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Current_Use_Clause (Node_Id N)
{
   const Field_Offset Off = 23;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Current_Value (Node_Id N)
{
   const Field_Offset Off = 23;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Debug_Info_Off (Node_Id N)
{
   const Field_Offset Off = 264;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Debug_Renaming_Link (Node_Id N)
{
   const Field_Offset Off = 47;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Default_Aspect_Component_Value (Node_Id N)
{
   const Field_Offset Off = 45;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Default_Aspect_Value (Node_Id N)
{
   const Field_Offset Off = 42;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Default_Expr_Function (Node_Id N)
{
   const Field_Offset Off = 24;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Default_Expressions_Processed (Node_Id N)
{
   const Field_Offset Off = 265;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Default_Value (Node_Id N)
{
   const Field_Offset Off = 25;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Delay_Cleanups (Node_Id N)
{
   const Field_Offset Off = 266;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Ureal Delta_Value (Node_Id N)
{
   const Field_Offset Off = 43;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Ureal val = (Ureal) Raw;
   return val;
}

INLINE Elist_Id Dependent_Instances (Node_Id N)
{
   const Field_Offset Off = 32;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Flag Depends_On_Private (Node_Id N)
{
   const Field_Offset Off = 267;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Derived_Type_Link (Node_Id N)
{
   const Field_Offset Off = 37;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Upos Digits_Value (Node_Id N)
{
   const Field_Offset Off = 36;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Upos val = (Upos) Raw;
   return val;
}

INLINE Node_Id Predicated_Parent (Node_Id N)
{
   const Field_Offset Off = 49;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Predicates_Ignored (Node_Id N)
{
   const Field_Offset Off = 929;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Elist_Id Direct_Primitive_Operations (Node_Id N)
{
   const Field_Offset Off = 38;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Directly_Designated_Type (Node_Id N)
{
   const Field_Offset Off = 43;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Disable_Controlled (Node_Id N)
{
   const Field_Offset Off = 268;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Discard_Names (Node_Id N)
{
   const Field_Offset Off = 269;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Discriminal (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Discriminal_Link (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Discriminant_Checking_Func (Node_Id N)
{
   const Field_Offset Off = 28;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Discriminant_Constraint (Node_Id N)
{
   const Field_Offset Off = 43;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Discriminant_Default_Value (Node_Id N)
{
   const Field_Offset Off = 33;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Upos Discriminant_Number (Node_Id N)
{
   const Field_Offset Off = 52;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Upos val = (Upos) Raw;
   return val;
}

INLINE Elist_Id Dispatch_Table_Wrappers (Node_Id N)
{
   const Field_Offset Off = 47;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Dynamic_Call_Helper (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Uint DT_Entry_Count (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Node_Id DT_Offset_To_Top_Func (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Uint DT_Position (Node_Id N)
{
   const Field_Offset Off = 55;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Node_Id DTC_Entity (Node_Id N)
{
   const Field_Offset Off = 56;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Elaborate_Body_Desirable (Node_Id N)
{
   const Field_Offset Off = 541;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Elaboration_Entity (Node_Id N)
{
   const Field_Offset Off = 21;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Elaboration_Entity_Required (Node_Id N)
{
   const Field_Offset Off = 538;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Encapsulating_State (Node_Id N)
{
   const Field_Offset Off = 37;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Enclosing_Scope (Node_Id N)
{
   const Field_Offset Off = 53;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Entry_Accepted (Node_Id N)
{
   const Field_Offset Off = 539;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Entry_Bodies_Array (Node_Id N)
{
   const Field_Offset Off = 56;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Cancel_Parameter (Node_Id N)
{
   const Field_Offset Off = 46;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Component (Node_Id N)
{
   const Field_Offset Off = 30;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Formal (Node_Id N)
{
   const Field_Offset Off = 20;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Index_Constant (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Max_Queue_Lengths_Array (Node_Id N)
{
   const Field_Offset Off = 42;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Entry_Parameters_Type (Node_Id N)
{
   const Field_Offset Off = 42;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Enum_Pos_To_Rep (Node_Id N)
{
   const Field_Offset Off = 48;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Unat Enumeration_Pos (Node_Id N)
{
   const Field_Offset Off = 20;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Unat val = (Unat) Raw;
   return val;
}

INLINE Valid_Uint Enumeration_Rep (Node_Id N)
{
   const Field_Offset Off = 24;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Valid_Uint val = (Valid_Uint) Raw;
   return val;
}

INLINE Node_Id Enumeration_Rep_Expr (Node_Id N)
{
   const Field_Offset Off = 25;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Equivalent_Type (Node_Id N)
{
   const Field_Offset Off = 46;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Uint Esize (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Node_Id Extra_Accessibility (Node_Id N)
{
   const Field_Offset Off = 34;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Extra_Accessibility_Of_Result (Node_Id N)
{
   const Field_Offset Off = 42;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Extra_Constrained (Node_Id N)
{
   const Field_Offset Off = 36;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Extra_Formal (Node_Id N)
{
   const Field_Offset Off = 31;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Extra_Formals (Node_Id N)
{
   const Field_Offset Off = 43;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Finalization_Collection (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Root_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Finalization_Master_Node (Node_Id N)
{
   const Field_Offset Off = 35;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Finalize_Storage_Only (Node_Id N)
{
   const Field_Offset Off = 930;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Finalizer (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id First_Entity (Node_Id N)
{
   const Field_Offset Off = 26;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id First_Exit_Statement (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id First_Index (Node_Id N)
{
   const Field_Offset Off = 46;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id First_Literal (Node_Id N)
{
   const Field_Offset Off = 36;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id First_Private_Entity (Node_Id N)
{
   const Field_Offset Off = 45;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id First_Rep_Item (Node_Id N)
{
   const Field_Offset Off = 10;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Freeze_Node (Node_Id N)
{
   const Field_Offset Off = 11;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag From_Limited_With (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Full_View (Node_Id N)
{
   const Field_Offset Off = 28;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Generic_Homonym (Node_Id N)
{
   const Field_Offset Off = 54;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Generic_Renamings (Node_Id N)
{
   const Field_Offset Off = 39;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE List_Id Handler_Records (Node_Id N)
{
   const Field_Offset Off = 38;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Has_Aliased_Components (Node_Id N)
{
   const Field_Offset Off = 270;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Alignment_Clause (Node_Id N)
{
   const Field_Offset Off = 271;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_All_Calls_Remote (Node_Id N)
{
   const Field_Offset Off = 272;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Atomic_Components (Node_Id N)
{
   const Field_Offset Off = 273;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Biased_Representation (Node_Id N)
{
   const Field_Offset Off = 274;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Completion (Node_Id N)
{
   const Field_Offset Off = 275;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Completion_In_Body (Node_Id N)
{
   const Field_Offset Off = 931;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Complex_Representation (Node_Id N)
{
   const Field_Offset Off = 979;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Component_Size_Clause (Node_Id N)
{
   const Field_Offset Off = 978;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Constrained_Partial_View (Node_Id N)
{
   const Field_Offset Off = 932;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Contiguous_Rep (Node_Id N)
{
   const Field_Offset Off = 276;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Controlled_Component (Node_Id N)
{
   const Field_Offset Off = 277;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Controlling_Result (Node_Id N)
{
   const Field_Offset Off = 278;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Convention_Pragma (Node_Id N)
{
   const Field_Offset Off = 279;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Default_Aspect (Node_Id N)
{
   const Field_Offset Off = 280;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Delayed_Aspects (Node_Id N)
{
   const Field_Offset Off = 281;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Delayed_Freeze (Node_Id N)
{
   const Field_Offset Off = 282;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Delayed_Rep_Aspects (Node_Id N)
{
   const Field_Offset Off = 283;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Discriminants (Node_Id N)
{
   const Field_Offset Off = 933;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Dispatch_Table (Node_Id N)
{
   const Field_Offset Off = 934;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Dynamic_Predicate_Aspect (Node_Id N)
{
   const Field_Offset Off = 935;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Enumeration_Rep_Clause (Node_Id N)
{
   const Field_Offset Off = 974;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Exit (Node_Id N)
{
   const Field_Offset Off = 284;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Expanded_Contract (Node_Id N)
{
   const Field_Offset Off = 741;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_First_Controlling_Parameter_Aspect (Node_Id N)
{
   const Field_Offset Off = 936;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Forward_Instantiation (Node_Id N)
{
   const Field_Offset Off = 285;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Fully_Qualified_Name (Node_Id N)
{
   const Field_Offset Off = 286;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Ghost_Predicate_Aspect (Node_Id N)
{
   const Field_Offset Off = 937;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Gigi_Rep_Item (Node_Id N)
{
   const Field_Offset Off = 287;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Homonym (Node_Id N)
{
   const Field_Offset Off = 384;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Implicit_Dereference (Node_Id N)
{
   const Field_Offset Off = 385;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Independent_Components (Node_Id N)
{
   const Field_Offset Off = 386;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Inheritable_Invariants (Node_Id N)
{
   const Field_Offset Off = 938;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Inherited_DIC (Node_Id N)
{
   const Field_Offset Off = 939;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Inherited_Invariants (Node_Id N)
{
   const Field_Offset Off = 940;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Initial_Value (Node_Id N)
{
   const Field_Offset Off = 538;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Loop_Entry_Attributes (Node_Id N)
{
   const Field_Offset Off = 536;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Machine_Radix_Clause (Node_Id N)
{
   const Field_Offset Off = 537;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Master_Entity (Node_Id N)
{
   const Field_Offset Off = 387;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Missing_Return (Node_Id N)
{
   const Field_Offset Off = 540;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Nested_Block_With_Handler (Node_Id N)
{
   const Field_Offset Off = 388;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Nested_Subprogram (Node_Id N)
{
   const Field_Offset Off = 742;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Non_Standard_Rep (Node_Id N)
{
   const Field_Offset Off = 389;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Object_Size_Clause (Node_Id N)
{
   const Field_Offset Off = 941;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Out_Or_In_Out_Parameter (Node_Id N)
{
   const Field_Offset Off = 738;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Own_DIC (Node_Id N)
{
   const Field_Offset Off = 942;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Own_Invariants (Node_Id N)
{
   const Field_Offset Off = 943;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Partial_Visible_Refinement (Node_Id N)
{
   const Field_Offset Off = 537;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Per_Object_Constraint (Node_Id N)
{
   const Field_Offset Off = 390;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Controlled (Node_Id N)
{
   const Field_Offset Off = 537;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Elaborate_Body (Node_Id N)
{
   const Field_Offset Off = 391;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Inline (Node_Id N)
{
   const Field_Offset Off = 392;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Inline_Always (Node_Id N)
{
   const Field_Offset Off = 393;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_No_Inline (Node_Id N)
{
   const Field_Offset Off = 394;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Ordered (Node_Id N)
{
   const Field_Offset Off = 975;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Pack (Node_Id N)
{
   const Field_Offset Off = 537;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Preelab_Init (Node_Id N)
{
   const Field_Offset Off = 395;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Pure (Node_Id N)
{
   const Field_Offset Off = 396;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Pure_Function (Node_Id N)
{
   const Field_Offset Off = 397;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Thread_Local_Storage (Node_Id N)
{
   const Field_Offset Off = 398;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Unmodified (Node_Id N)
{
   const Field_Offset Off = 399;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Unreferenced (Node_Id N)
{
   const Field_Offset Off = 400;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Unreferenced_Objects (Node_Id N)
{
   const Field_Offset Off = 944;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Pragma_Unused (Node_Id N)
{
   const Field_Offset Off = 401;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Predicates (Node_Id N)
{
   const Field_Offset Off = 538;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Primitive_Operations (Node_Id N)
{
   const Field_Offset Off = 945;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Private_Ancestor (Node_Id N)
{
   const Field_Offset Off = 402;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Private_Declaration (Node_Id N)
{
   const Field_Offset Off = 403;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Private_Extension (Node_Id N)
{
   const Field_Offset Off = 946;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Protected (Node_Id N)
{
   const Field_Offset Off = 404;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Qualified_Name (Node_Id N)
{
   const Field_Offset Off = 405;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_RACW (Node_Id N)
{
   const Field_Offset Off = 960;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Record_Rep_Clause (Node_Id N)
{
   const Field_Offset Off = 980;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Recursive_Call (Node_Id N)
{
   const Field_Offset Off = 743;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Relaxed_Finalization (Node_Id N)
{
   const Field_Offset Off = 406;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Shift_Operator (Node_Id N)
{
   const Field_Offset Off = 974;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Size_Clause (Node_Id N)
{
   const Field_Offset Off = 407;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Small_Clause (Node_Id N)
{
   const Field_Offset Off = 537;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Specified_Layout (Node_Id N)
{
   const Field_Offset Off = 947;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Specified_Stream_Input (Node_Id N)
{
   const Field_Offset Off = 948;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Specified_Stream_Output (Node_Id N)
{
   const Field_Offset Off = 949;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Specified_Stream_Read (Node_Id N)
{
   const Field_Offset Off = 950;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Specified_Stream_Write (Node_Id N)
{
   const Field_Offset Off = 951;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Static_Discriminants (Node_Id N)
{
   const Field_Offset Off = 539;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Static_Predicate (Node_Id N)
{
   const Field_Offset Off = 952;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Static_Predicate_Aspect (Node_Id N)
{
   const Field_Offset Off = 953;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Storage_Size_Clause (Node_Id N)
{
   const Field_Offset Off = 975;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Stream_Size_Clause (Node_Id N)
{
   const Field_Offset Off = 408;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Task (Node_Id N)
{
   const Field_Offset Off = 409;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Timing_Event (Node_Id N)
{
   const Field_Offset Off = 410;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Thunks (Node_Id N)
{
   const Field_Offset Off = 411;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Unchecked_Union (Node_Id N)
{
   const Field_Offset Off = 412;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Unknown_Discriminants (Node_Id N)
{
   const Field_Offset Off = 954;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Visible_Refinement (Node_Id N)
{
   const Field_Offset Off = 538;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Volatile_Components (Node_Id N)
{
   const Field_Offset Off = 413;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Xref_Entry (Node_Id N)
{
   const Field_Offset Off = 414;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Has_Yield_Aspect (Node_Id N)
{
   const Field_Offset Off = 415;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Hiding_Loop_Variable (Node_Id N)
{
   const Field_Offset Off = 46;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Hidden_In_Formal_Instance (Node_Id N)
{
   const Field_Offset Off = 33;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Homonym (Node_Id N)
{
   const Field_Offset Off = 1;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Ignored_Class_Postconditions (Node_Id N)
{
   const Field_Offset Off = 45;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Ignored_Class_Preconditions (Node_Id N)
{
   const Field_Offset Off = 46;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Ignore_SPARK_Mode_Pragmas (Node_Id N)
{
   const Field_Offset Off = 974;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Import_Pragma (Node_Id N)
{
   const Field_Offset Off = 47;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Incomplete_Actuals (Node_Id N)
{
   const Field_Offset Off = 34;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Indirect_Call_Wrapper (Node_Id N)
{
   const Field_Offset Off = 48;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag In_Package_Body (Node_Id N)
{
   const Field_Offset Off = 416;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag In_Private_Part (Node_Id N)
{
   const Field_Offset Off = 417;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag In_Use (Node_Id N)
{
   const Field_Offset Off = 418;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Initialization_Statements (Node_Id N)
{
   const Field_Offset Off = 43;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Inner_Instances (Node_Id N)
{
   const Field_Offset Off = 37;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Interface_Alias (Node_Id N)
{
   const Field_Offset Off = 49;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Interface_Name (Node_Id N)
{
   const Field_Offset Off = 22;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Interfaces (Node_Id N)
{
   const Field_Offset Off = 36;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Flag Is_Abstract_Subprogram (Node_Id N)
{
   const Field_Offset Off = 736;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Abstract_Type (Node_Id N)
{
   const Field_Offset Off = 955;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Access_Constant (Node_Id N)
{
   const Field_Offset Off = 974;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Activation_Record (Node_Id N)
{
   const Field_Offset Off = 539;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Actual_Subtype (Node_Id N)
{
   const Field_Offset Off = 956;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Ada_2005_Only (Node_Id N)
{
   const Field_Offset Off = 419;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Ada_2012_Only (Node_Id N)
{
   const Field_Offset Off = 420;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Ada_2022_Only (Node_Id N)
{
   const Field_Offset Off = 421;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Aliased (Node_Id N)
{
   const Field_Offset Off = 422;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Asynchronous (Node_Id N)
{
   const Field_Offset Off = 540;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Atomic (Node_Id N)
{
   const Field_Offset Off = 423;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Bit_Packed_Array (Node_Id N)
{
   const Field_Offset Off = 424;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Called (Node_Id N)
{
   const Field_Offset Off = 542;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Character_Type (Node_Id N)
{
   const Field_Offset Off = 425;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Checked_Ghost_Entity (Node_Id N)
{
   const Field_Offset Off = 426;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Child_Unit (Node_Id N)
{
   const Field_Offset Off = 427;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Class_Wide_Equivalent_Type (Node_Id N)
{
   const Field_Offset Off = 428;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Class_Wide_Wrapper (Node_Id N)
{
   const Field_Offset Off = 429;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Compilation_Unit (Node_Id N)
{
   const Field_Offset Off = 430;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Completely_Hidden (Node_Id N)
{
   const Field_Offset Off = 536;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Concurrent_Record_Type (Node_Id N)
{
   const Field_Offset Off = 431;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Constr_Array_Subt_With_Bounds (Node_Id N)
{
   const Field_Offset Off = 432;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Constr_Subt_For_U_Nominal (Node_Id N)
{
   const Field_Offset Off = 433;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Constrained (Node_Id N)
{
   const Field_Offset Off = 434;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Constructor (Node_Id N)
{
   const Field_Offset Off = 435;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Controlled_Active (Node_Id N)
{
   const Field_Offset Off = 436;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Controlling_Formal (Node_Id N)
{
   const Field_Offset Off = 536;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_CPP_Class (Node_Id N)
{
   const Field_Offset Off = 437;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_CUDA_Kernel (Node_Id N)
{
   const Field_Offset Off = 745;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Descendant_Of_Address (Node_Id N)
{
   const Field_Offset Off = 438;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_DIC_Procedure (Node_Id N)
{
   const Field_Offset Off = 746;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Discrim_SO_Function (Node_Id N)
{
   const Field_Offset Off = 439;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Discriminant_Check_Function (Node_Id N)
{
   const Field_Offset Off = 440;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Dispatch_Table_Entity (Node_Id N)
{
   const Field_Offset Off = 441;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Dispatch_Table_Wrapper (Node_Id N)
{
   const Field_Offset Off = 442;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Dispatching_Operation (Node_Id N)
{
   const Field_Offset Off = 443;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Elaboration_Checks_OK_Id (Node_Id N)
{
   const Field_Offset Off = 543;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Elaboration_Warnings_OK_Id (Node_Id N)
{
   const Field_Offset Off = 537;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Eliminated (Node_Id N)
{
   const Field_Offset Off = 444;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Entry_Formal (Node_Id N)
{
   const Field_Offset Off = 445;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Entry_Wrapper (Node_Id N)
{
   const Field_Offset Off = 446;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Exception_Handler (Node_Id N)
{
   const Field_Offset Off = 536;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Exported (Node_Id N)
{
   const Field_Offset Off = 447;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Finalized_Transient (Node_Id N)
{
   const Field_Offset Off = 539;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Finalizer (Node_Id N)
{
   const Field_Offset Off = 448;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_First_Subtype (Node_Id N)
{
   const Field_Offset Off = 449;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Fixed_Lower_Bound_Array_Subtype (Node_Id N)
{
   const Field_Offset Off = 957;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Fixed_Lower_Bound_Index_Subtype (Node_Id N)
{
   const Field_Offset Off = 958;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Formal_Subprogram (Node_Id N)
{
   const Field_Offset Off = 450;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Frozen (Node_Id N)
{
   const Field_Offset Off = 451;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Generic_Actual_Subprogram (Node_Id N)
{
   const Field_Offset Off = 747;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Generic_Actual_Type (Node_Id N)
{
   const Field_Offset Off = 959;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Generic_Instance (Node_Id N)
{
   const Field_Offset Off = 19;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Generic_Type (Node_Id N)
{
   const Field_Offset Off = 452;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Hidden (Node_Id N)
{
   const Field_Offset Off = 453;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Hidden_Non_Overridden_Subpgm (Node_Id N)
{
   const Field_Offset Off = 454;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Hidden_Open_Scope (Node_Id N)
{
   const Field_Offset Off = 455;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Ignored_For_Finalization (Node_Id N)
{
   const Field_Offset Off = 540;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Ignored_Ghost_Entity (Node_Id N)
{
   const Field_Offset Off = 456;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Immediately_Visible (Node_Id N)
{
   const Field_Offset Off = 16;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Implementation_Defined (Node_Id N)
{
   const Field_Offset Off = 457;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Implicit_Full_View (Node_Id N)
{
   const Field_Offset Off = 961;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Imported (Node_Id N)
{
   const Field_Offset Off = 458;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Independent (Node_Id N)
{
   const Field_Offset Off = 459;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Initial_Condition_Procedure (Node_Id N)
{
   const Field_Offset Off = 748;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Inlined (Node_Id N)
{
   const Field_Offset Off = 460;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Inlined_Always (Node_Id N)
{
   const Field_Offset Off = 749;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Instantiated (Node_Id N)
{
   const Field_Offset Off = 461;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Interface (Node_Id N)
{
   const Field_Offset Off = 462;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Internal (Node_Id N)
{
   const Field_Offset Off = 463;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Interrupt_Handler (Node_Id N)
{
   const Field_Offset Off = 464;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Intrinsic_Subprogram (Node_Id N)
{
   const Field_Offset Off = 465;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Invariant_Procedure (Node_Id N)
{
   const Field_Offset Off = 750;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Itype (Node_Id N)
{
   const Field_Offset Off = 466;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Known_Non_Null (Node_Id N)
{
   const Field_Offset Off = 467;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Known_Null (Node_Id N)
{
   const Field_Offset Off = 468;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Known_Valid (Node_Id N)
{
   const Field_Offset Off = 469;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Limited_Composite (Node_Id N)
{
   const Field_Offset Off = 470;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Limited_Interface (Node_Id N)
{
   const Field_Offset Off = 471;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Limited_Record (Node_Id N)
{
   const Field_Offset Off = 472;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Local_Anonymous_Access (Node_Id N)
{
   const Field_Offset Off = 976;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Loop_Parameter (Node_Id N)
{
   const Field_Offset Off = 473;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Machine_Code_Subprogram (Node_Id N)
{
   const Field_Offset Off = 744;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Mutably_Tagged_Type (Node_Id N)
{
   const Field_Offset Off = 962;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Non_Static_Subtype (Node_Id N)
{
   const Field_Offset Off = 963;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Null_Init_Proc (Node_Id N)
{
   const Field_Offset Off = 755;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Obsolescent (Node_Id N)
{
   const Field_Offset Off = 474;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Only_Out_Parameter (Node_Id N)
{
   const Field_Offset Off = 537;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Package_Body_Entity (Node_Id N)
{
   const Field_Offset Off = 475;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Packed (Node_Id N)
{
   const Field_Offset Off = 476;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Packed_Array_Impl_Type (Node_Id N)
{
   const Field_Offset Off = 477;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Not_Self_Hidden (Node_Id N)
{
   const Field_Offset Off = 478;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Param_Block_Component_Type (Node_Id N)
{
   const Field_Offset Off = 543;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Partial_Invariant_Procedure (Node_Id N)
{
   const Field_Offset Off = 751;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Potentially_Use_Visible (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = Node_Offsets_Ptr[N].Slots[Slot_Off];
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Predicate_Function (Node_Id N)
{
   const Field_Offset Off = 752;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Preelaborated (Node_Id N)
{
   const Field_Offset Off = 479;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Primitive (Node_Id N)
{
   const Field_Offset Off = 541;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Primitive_Wrapper (Node_Id N)
{
   const Field_Offset Off = 753;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Private_Composite (Node_Id N)
{
   const Field_Offset Off = 964;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Private_Descendant (Node_Id N)
{
   const Field_Offset Off = 480;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Private_Primitive (Node_Id N)
{
   const Field_Offset Off = 754;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Public (Node_Id N)
{
   const Field_Offset Off = 481;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Pure (Node_Id N)
{
   const Field_Offset Off = 482;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Pure_Unit_Access_Type (Node_Id N)
{
   const Field_Offset Off = 977;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_RACW_Stub_Type (Node_Id N)
{
   const Field_Offset Off = 965;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Raised (Node_Id N)
{
   const Field_Offset Off = 536;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Remote_Call_Interface (Node_Id N)
{
   const Field_Offset Off = 483;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Remote_Types (Node_Id N)
{
   const Field_Offset Off = 484;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Renaming_Of_Object (Node_Id N)
{
   const Field_Offset Off = 485;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Return_Object (Node_Id N)
{
   const Field_Offset Off = 486;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Safe_To_Reevaluate (Node_Id N)
{
   const Field_Offset Off = 487;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Shared_Passive (Node_Id N)
{
   const Field_Offset Off = 488;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Static_Type (Node_Id N)
{
   const Field_Offset Off = 489;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Statically_Allocated (Node_Id N)
{
   const Field_Offset Off = 490;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Tag (Node_Id N)
{
   const Field_Offset Off = 491;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Tagged_Type (Node_Id N)
{
   const Field_Offset Off = 492;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Thunk (Node_Id N)
{
   const Field_Offset Off = 493;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Trivial_Subprogram (Node_Id N)
{
   const Field_Offset Off = 494;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_True_Constant (Node_Id N)
{
   const Field_Offset Off = 495;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Unchecked_Union (Node_Id N)
{
   const Field_Offset Off = 496;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Underlying_Full_View (Node_Id N)
{
   const Field_Offset Off = 497;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Underlying_Record_View (Node_Id N)
{
   const Field_Offset Off = 498;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Unimplemented (Node_Id N)
{
   const Field_Offset Off = 499;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Unsigned_Type (Node_Id N)
{
   const Field_Offset Off = 966;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Uplevel_Referenced_Entity (Node_Id N)
{
   const Field_Offset Off = 500;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Valued_Procedure (Node_Id N)
{
   const Field_Offset Off = 756;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Visible_Formal (Node_Id N)
{
   const Field_Offset Off = 501;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Visible_Lib_Unit (Node_Id N)
{
   const Field_Offset Off = 502;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Volatile_Type (Node_Id N)
{
   const Field_Offset Off = 503;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Volatile_Object (Node_Id N)
{
   const Field_Offset Off = 504;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Volatile_Full_Access (Node_Id N)
{
   const Field_Offset Off = 505;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Is_Wrapper (Node_Id N)
{
   const Field_Offset Off = 506;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Itype_Printed (Node_Id N)
{
   const Field_Offset Off = 967;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Kill_Elaboration_Checks (Node_Id N)
{
   const Field_Offset Off = 507;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Known_To_Have_Preelab_Init (Node_Id N)
{
   const Field_Offset Off = 968;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Last_Aggregate_Assignment (Node_Id N)
{
   const Field_Offset Off = 39;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Last_Assignment (Node_Id N)
{
   const Field_Offset Off = 33;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Last_Entity (Node_Id N)
{
   const Field_Offset Off = 27;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Limited_View (Node_Id N)
{
   const Field_Offset Off = 35;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Linker_Section_Pragma (Node_Id N)
{
   const Field_Offset Off = 20;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Lit_Hash (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Root_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Lit_Indexes (Node_Id N)
{
   const Field_Offset Off = 46;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Lit_Strings (Node_Id N)
{
   const Field_Offset Off = 47;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Low_Bound_Tested (Node_Id N)
{
   const Field_Offset Off = 508;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id LSP_Subprogram (Node_Id N)
{
   const Field_Offset Off = 50;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Machine_Radix_10 (Node_Id N)
{
   const Field_Offset Off = 543;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Master_Id (Node_Id N)
{
   const Field_Offset Off = 45;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Materialize_Entity (Node_Id N)
{
   const Field_Offset Off = 509;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag May_Inherit_Delayed_Rep_Aspects (Node_Id N)
{
   const Field_Offset Off = 510;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Mechanism_Type Mechanism (Node_Id N)
{
   const Field_Offset Off = 35;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Mechanism_Type val = (Mechanism_Type) Raw;
   return val;
}

INLINE Node_Id Minimum_Accessibility (Node_Id N)
{
   const Field_Offset Off = 32;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Uint Modulus (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Flag Must_Be_On_Byte_Boundary (Node_Id N)
{
   const Field_Offset Off = 969;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Must_Have_Preelab_Init (Node_Id N)
{
   const Field_Offset Off = 970;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Needs_Activation_Record (Node_Id N)
{
   const Field_Offset Off = 511;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Needs_Debug_Info (Node_Id N)
{
   const Field_Offset Off = 512;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Needs_No_Actuals (Node_Id N)
{
   const Field_Offset Off = 975;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Never_Set_In_Source (Node_Id N)
{
   const Field_Offset Off = 513;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Next_Inlined_Subprogram (Node_Id N)
{
   const Field_Offset Off = 40;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag No_Dynamic_Predicate_On_Actual (Node_Id N)
{
   const Field_Offset Off = 537;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Pool_Assigned (Node_Id N)
{
   const Field_Offset Off = 978;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Root_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Predicate_On_Actual (Node_Id N)
{
   const Field_Offset Off = 543;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Raise (Node_Id N)
{
   const Field_Offset Off = 739;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Reordering (Node_Id N)
{
   const Field_Offset Off = 981;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Return (Node_Id N)
{
   const Field_Offset Off = 740;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag No_Strict_Aliasing (Node_Id N)
{
   const Field_Offset Off = 979;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id No_Tagged_Streams_Pragma (Node_Id N)
{
   const Field_Offset Off = 39;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Non_Binary_Modulus (Node_Id N)
{
   const Field_Offset Off = 971;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Non_Limited_View (Node_Id N)
{
   const Field_Offset Off = 49;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Nonzero_Is_True (Node_Id N)
{
   const Field_Offset Off = 976;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Uint Normalized_First_Bit (Node_Id N)
{
   const Field_Offset Off = 26;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Uint Normalized_Position (Node_Id N)
{
   const Field_Offset Off = 27;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Flag OK_To_Rename (Node_Id N)
{
   const Field_Offset Off = 961;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Optimize_Alignment_Space (Node_Id N)
{
   const Field_Offset Off = 541;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Optimize_Alignment_Time (Node_Id N)
{
   const Field_Offset Off = 542;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Original_Access_Type (Node_Id N)
{
   const Field_Offset Off = 47;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Original_Array_Type (Node_Id N)
{
   const Field_Offset Off = 36;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Original_Protected_Subprogram (Node_Id N)
{
   const Field_Offset Off = 57;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Original_Record_Component (Node_Id N)
{
   const Field_Offset Off = 41;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Overlays_Constant (Node_Id N)
{
   const Field_Offset Off = 514;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Overridden_Operation (Node_Id N)
{
   const Field_Offset Off = 28;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Package_Instantiation (Node_Id N)
{
   const Field_Offset Off = 49;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Packed_Array_Impl_Type (Node_Id N)
{
   const Field_Offset Off = 47;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Parent_Subtype (Node_Id N)
{
   const Field_Offset Off = 42;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Part_Of_Constituents (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Elist_Id Part_Of_References (Node_Id N)
{
   const Field_Offset Off = 48;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Flag Partial_View_Has_Unknown_Discr (Node_Id N)
{
   const Field_Offset Off = 972;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Predicate_Expression (Node_Id N)
{
   const Field_Offset Off = 61;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Prev_Entity (Node_Id N)
{
   const Field_Offset Off = 17;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Prival (Node_Id N)
{
   const Field_Offset Off = 32;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Prival_Link (Node_Id N)
{
   const Field_Offset Off = 40;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Private_Dependents (Node_Id N)
{
   const Field_Offset Off = 47;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Protected_Body_Subprogram (Node_Id N)
{
   const Field_Offset Off = 29;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Protected_Formal (Node_Id N)
{
   const Field_Offset Off = 37;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Protected_Subprogram (Node_Id N)
{
   const Field_Offset Off = 58;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Protection_Object (Node_Id N)
{
   const Field_Offset Off = 53;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Reachable (Node_Id N)
{
   const Field_Offset Off = 536;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Receiving_Entry (Node_Id N)
{
   const Field_Offset Off = 32;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Referenced (Node_Id N)
{
   const Field_Offset Off = 515;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Referenced_As_LHS (Node_Id N)
{
   const Field_Offset Off = 516;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Referenced_As_Out_Parameter (Node_Id N)
{
   const Field_Offset Off = 517;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Elist_Id Refinement_Constituents (Node_Id N)
{
   const Field_Offset Off = 20;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Node_Id Register_Exception_Call (Node_Id N)
{
   const Field_Offset Off = 20;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Related_Array_Object (Node_Id N)
{
   const Field_Offset Off = 48;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Related_Expression (Node_Id N)
{
   const Field_Offset Off = 32;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Related_Instance (Node_Id N)
{
   const Field_Offset Off = 31;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Related_Type (Node_Id N)
{
   const Field_Offset Off = 31;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Relative_Deadline_Variable (Node_Id N)
{
   const Field_Offset Off = 48;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Renamed_In_Spec (Node_Id N)
{
   const Field_Offset Off = 961;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Renamed_Or_Alias (Node_Id N)
{
   const Field_Offset Off = 18;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Renames_Limited_View (Node_Id N)
{
   const Field_Offset Off = 962;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Requires_Overriding (Node_Id N)
{
   const Field_Offset Off = 737;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Return_Applies_To (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Return_Present (Node_Id N)
{
   const Field_Offset Off = 518;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Return_Statement (Node_Id N)
{
   const Field_Offset Off = 41;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Returns_By_Ref (Node_Id N)
{
   const Field_Offset Off = 519;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Reverse_Bit_Order (Node_Id N)
{
   const Field_Offset Off = 982;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Reverse_Storage_Order (Node_Id N)
{
   const Field_Offset Off = 543;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Uint RM_Size (Node_Id N)
{
   const Field_Offset Off = 35;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Node_Id Scalar_Range (Node_Id N)
{
   const Field_Offset Off = 45;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Uint Scale_Value (Node_Id N)
{
   const Field_Offset Off = 57;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Uint val = (Uint) (Raw? Raw : No_Uint);
   return val;
}

INLINE Unat Scope_Depth_Value (Node_Id N)
{
   const Field_Offset Off = 36;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Unat val = (Unat) Raw;
   return val;
}

INLINE Flag Sec_Stack_Needed_For_Return (Node_Id N)
{
   const Field_Offset Off = 520;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Shared_Var_Procs_Instance (Node_Id N)
{
   const Field_Offset Off = 49;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Size_Check_Code (Node_Id N)
{
   const Field_Offset Off = 42;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Size_Depends_On_Discriminant (Node_Id N)
{
   const Field_Offset Off = 521;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Size_Known_At_Compile_Time (Node_Id N)
{
   const Field_Offset Off = 522;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Ureal Small_Value (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Ureal val = (Ureal) Raw;
   return val;
}

INLINE Node_Id SPARK_Aux_Pragma (Node_Id N)
{
   const Field_Offset Off = 44;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag SPARK_Aux_Pragma_Inherited (Node_Id N)
{
   const Field_Offset Off = 976;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id SPARK_Pragma (Node_Id N)
{
   const Field_Offset Off = 24;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag SPARK_Pragma_Inherited (Node_Id N)
{
   const Field_Offset Off = 536;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Spec_Entity (Node_Id N)
{
   const Field_Offset Off = 22;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag SSO_Set_High_By_Default (Node_Id N)
{
   const Field_Offset Off = 976;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag SSO_Set_Low_By_Default (Node_Id N)
{
   const Field_Offset Off = 977;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Static_Call_Helper (Node_Id N)
{
   const Field_Offset Off = 51;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE List_Id Static_Discrete_Predicate (Node_Id N)
{
   const Field_Offset Off = 43;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   List_Id val = (List_Id) Raw;
   return val;
}

INLINE Flag Static_Elaboration_Desired (Node_Id N)
{
   const Field_Offset Off = 963;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Static_Initialization (Node_Id N)
{
   const Field_Offset Off = 35;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Static_Real_Or_String_Predicate (Node_Id N)
{
   const Field_Offset Off = 50;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Storage_Size_Variable (Node_Id N)
{
   const Field_Offset Off = 42;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Stored_Constraint (Node_Id N)
{
   const Field_Offset Off = 40;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Flag Stores_Attribute_Old_Prefix (Node_Id N)
{
   const Field_Offset Off = 523;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Strict_Alignment (Node_Id N)
{
   const Field_Offset Off = 524;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Unat String_Literal_Length (Node_Id N)
{
   const Field_Offset Off = 49;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Unat val = (Unat) Raw;
   return val;
}

INLINE Node_Id String_Literal_Low_Bound (Node_Id N)
{
   const Field_Offset Off = 50;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Elist_Id Subprograms_For_Type (Node_Id N)
{
   const Field_Offset Off = 41;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Elist_Id val = (Elist_Id) (Raw? Raw : No_Elist);
   return val;
}

INLINE Unat Subps_Index (Node_Id N)
{
   const Field_Offset Off = 52;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Unat val = (Unat) Raw;
   return val;
}

INLINE Flag Suppress_Elaboration_Warnings (Node_Id N)
{
   const Field_Offset Off = 525;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Suppress_Initialization (Node_Id N)
{
   const Field_Offset Off = 960;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Suppress_Style_Checks (Node_Id N)
{
   const Field_Offset Off = 526;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Suppress_Value_Tracking_On_Call (Node_Id N)
{
   const Field_Offset Off = 527;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Task_Body_Procedure (Node_Id N)
{
   const Field_Offset Off = 49;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Thunk_Entity (Node_Id N)
{
   const Field_Offset Off = 59;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Treat_As_Volatile (Node_Id N)
{
   const Field_Offset Off = 528;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Underlying_Full_View (Node_Id N)
{
   const Field_Offset Off = 50;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Underlying_Record_View (Node_Id N)
{
   const Field_Offset Off = 46;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Universal_Aliasing (Node_Id N)
{
   const Field_Offset Off = 973;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[Implementation_Base_Type (N)].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Unset_Reference (Node_Id N)
{
   const Field_Offset Off = 28;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Used_As_Generic_Actual (Node_Id N)
{
   const Field_Offset Off = 529;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Uses_Lock_Free (Node_Id N)
{
   const Field_Offset Off = 537;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Uses_Sec_Stack (Node_Id N)
{
   const Field_Offset Off = 530;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Validated_Object (Node_Id N)
{
   const Field_Offset Off = 50;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Flag Warnings_Off (Node_Id N)
{
   const Field_Offset Off = 531;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Warnings_Off_Used (Node_Id N)
{
   const Field_Offset Off = 532;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Warnings_Off_Used_Unmodified (Node_Id N)
{
   const Field_Offset Off = 533;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Warnings_Off_Used_Unreferenced (Node_Id N)
{
   const Field_Offset Off = 534;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Flag Was_Hidden (Node_Id N)
{
   const Field_Offset Off = 535;
   const Field_Offset F_Size = 1;
   const any_slot Mask = (1 << F_Size) - 1;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = (slot >> (Off % F_Per_Slot) * F_Size) & Mask;
   Flag val = (Flag) Raw;
   return val;
}

INLINE Node_Id Wrapped_Entity (Node_Id N)
{
   const Field_Offset Off = 60;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

INLINE Node_Id Wrapped_Statements (Node_Id N)
{
   const Field_Offset Off = 54;
   const Field_Offset F_Size = 32;
   const Field_Offset F_Per_Slot = Slot_Size / F_Size;
   const Field_Offset Slot_Off = Off / F_Per_Slot;

   any_slot slot = *(Slots_Ptr + Node_Offsets_Ptr[N].Offset + Slot_Off);
   unsigned int Raw = slot;
   Node_Id val = (Node_Id) Raw;
   return val;
}

// Abstract type queries

INLINE B Is_Void_Or_Type (E Id)
   { return IN (Ekind (Id), Void_Or_Type_Kind); }
INLINE B Is_Type (E Id)
   { return IN (Ekind (Id), Type_Kind); }
INLINE B Is_Elementary_Type (E Id)
   { return IN (Ekind (Id), Elementary_Kind); }
INLINE B Is_Scalar_Type (E Id)
   { return IN (Ekind (Id), Scalar_Kind); }
INLINE B Is_Discrete_Type (E Id)
   { return IN (Ekind (Id), Discrete_Kind); }
INLINE B Is_Enumeration_Type (E Id)
   { return IN (Ekind (Id), Enumeration_Kind); }
INLINE B Is_Integer_Type (E Id)
   { return IN (Ekind (Id), Integer_Kind); }
INLINE B Is_Signed_Integer_Type (E Id)
   { return IN (Ekind (Id), Signed_Integer_Kind); }
INLINE B Is_Modular_Integer_Type (E Id)
   { return IN (Ekind (Id), Modular_Integer_Kind); }
INLINE B Is_Real_Type (E Id)
   { return IN (Ekind (Id), Real_Kind); }
INLINE B Is_Fixed_Point_Type (E Id)
   { return IN (Ekind (Id), Fixed_Point_Kind); }
INLINE B Is_Ordinary_Fixed_Point_Type (E Id)
   { return IN (Ekind (Id), Ordinary_Fixed_Point_Kind); }
INLINE B Is_Decimal_Fixed_Point_Type (E Id)
   { return IN (Ekind (Id), Decimal_Fixed_Point_Kind); }
INLINE B Is_Float_Type (E Id)
   { return IN (Ekind (Id), Float_Kind); }
INLINE B Is_Access_Type (E Id)
   { return IN (Ekind (Id), Access_Kind); }
INLINE B Is_Access_Subprogram_Type (E Id)
   { return IN (Ekind (Id), Access_Subprogram_Kind); }
INLINE B Is_Access_Protected_Type (E Id)
   { return IN (Ekind (Id), Access_Protected_Kind); }
INLINE B Is_Composite_Type (E Id)
   { return IN (Ekind (Id), Composite_Kind); }
INLINE B Is_Aggregate_Type (E Id)
   { return IN (Ekind (Id), Aggregate_Kind); }
INLINE B Is_Array_Type (E Id)
   { return IN (Ekind (Id), Array_Kind); }
INLINE B Is_Class_Wide_Type (E Id)
   { return IN (Ekind (Id), Class_Wide_Kind); }
INLINE B Is_Incomplete_Or_Private_Type (E Id)
   { return IN (Ekind (Id), Incomplete_Or_Private_Kind); }
INLINE B Is_Private_Type (E Id)
   { return IN (Ekind (Id), Private_Kind); }
INLINE B Is_Incomplete_Type (E Id)
   { return IN (Ekind (Id), Incomplete_Kind); }
INLINE B Is_Concurrent_Type (E Id)
   { return IN (Ekind (Id), Concurrent_Kind); }
INLINE B Is_Task_Type (E Id)
   { return IN (Ekind (Id), Task_Kind); }
INLINE B Is_Protected_Type (E Id)
   { return IN (Ekind (Id), Protected_Kind); }
INLINE B Is_Exception_Or_Object (E Id)
   { return IN (Ekind (Id), Exception_Or_Object_Kind); }
INLINE B Is_Object (E Id)
   { return IN (Ekind (Id), Object_Kind); }
INLINE B Is_Record_Field (E Id)
   { return IN (Ekind (Id), Record_Field_Kind); }
INLINE B Is_Allocatable (E Id)
   { return IN (Ekind (Id), Allocatable_Kind); }
INLINE B Is_Constant_Or_Variable (E Id)
   { return IN (Ekind (Id), Constant_Or_Variable_Kind); }
INLINE B Is_Formal (E Id)
   { return IN (Ekind (Id), Formal_Kind); }
INLINE B Is_Formal_Object (E Id)
   { return IN (Ekind (Id), Formal_Object_Kind); }
INLINE B Is_Named (E Id)
   { return IN (Ekind (Id), Named_Kind); }
INLINE B Is_Overloadable (E Id)
   { return IN (Ekind (Id), Overloadable_Kind); }
INLINE B Is_Subprogram (E Id)
   { return IN (Ekind (Id), Subprogram_Kind); }
INLINE B Is_Generic_Unit (E Id)
   { return IN (Ekind (Id), Generic_Unit_Kind); }
INLINE B Is_Generic_Subprogram (E Id)
   { return IN (Ekind (Id), Generic_Subprogram_Kind); }
INLINE B Is_Concurrent_Body (E Id)
   { return IN (Ekind (Id), Concurrent_Body_Kind); }

#ifdef __cplusplus
}
#endif
