/* do not edit automatically generated by mc from M2CaseList.  */
/* M2CaseList.def implement ISO case label lists.

Copyright (C) 2009-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2CaseList_H)
#   define _M2CaseList_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GDynamicStrings.h"
#   include "GLists.h"

#   if defined (_M2CaseList_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   PushCase - create a case entity and push it to an internal stack.
              rec is NulSym if this is a CASE statement.
              If rec is a record then it indicates a possible
              varients reside in the record to check.
              Both rec and va might be NulSym and then the expr
              will contain the selector expression to a case statement.
              Return the case id.
*/

EXTERN unsigned int M2CaseList_PushCase (unsigned int rec, unsigned int va, unsigned int expr);

/*
   PopCase - pop the top element of the case entity from the internal
             stack.
*/

EXTERN void M2CaseList_PopCase (void);

/*
   ElseCase - indicates that this case varient does have an else clause.
*/

EXTERN void M2CaseList_ElseCase (unsigned int f);

/*
   BeginCaseList - create a new label list.
*/

EXTERN void M2CaseList_BeginCaseList (unsigned int v);

/*
   EndCaseList - terminate the current label list.
*/

EXTERN void M2CaseList_EndCaseList (void);

/*
   AddRange - add a range to the current label list.
*/

EXTERN void M2CaseList_AddRange (unsigned int r1, unsigned int r2, unsigned int tok);

/*
   CaseBoundsResolved - returns TRUE if all constants in the case list, c,
                        are known to GCC.
*/

EXTERN bool M2CaseList_CaseBoundsResolved (unsigned int tokenno, unsigned int c);

/*
   TypeCaseBounds - returns TRUE if all bounds in case list, c, are
                    compatible with the tagged type.
*/

EXTERN bool M2CaseList_TypeCaseBounds (unsigned int c);

/*
   OverlappingCaseBounds - returns TRUE if there were any overlapping bounds
                           in the case list, c.  It will generate an error
                           messages for each overlapping bound found.
*/

EXTERN bool M2CaseList_OverlappingCaseBounds (unsigned int c);

/*
   MissingCaseBounds - returns TRUE if there were any missing bounds
                       in the varient record case list, c.  It will
                       generate an error message for each missing
                       bounds found.
*/

EXTERN bool M2CaseList_MissingCaseBounds (unsigned int tokenno, unsigned int c);

/*
   MissingCaseStatementBounds - returns TRUE if the case statement has a missing
                                clause.  It will also generate error messages.
*/

EXTERN bool M2CaseList_MissingCaseStatementBounds (unsigned int tokenno, unsigned int c);

/*
   WriteCase - displays the case list.
*/

EXTERN void M2CaseList_WriteCase (unsigned int c);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
