/* do not edit automatically generated by mc from M2Range.  */
/* M2Range.def exports procedures which maintain the range checking.

Copyright (C) 2008-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Range_H)
#   define _M2Range_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GCDataTypes.h"
#   include "Ggcctypes.h"
#   include "GDynamicStrings.h"

#   if defined (_M2Range_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   InitAssignmentRangeCheck - returns a range check node which
                              remembers the information necessary
                              so that a range check for d := e
                              can be generated later on.
*/

EXTERN unsigned int M2Range_InitAssignmentRangeCheck (unsigned int tokno, unsigned int des, unsigned int expr, unsigned int destok, unsigned int exprtok);

/*
   InitReturnRangeCheck - returns a range check node which
                           remembers the information necessary
                           so that a range check for RETURN e
                           from procedure, d, can be generated later on.
*/

EXTERN unsigned int M2Range_InitReturnRangeCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitSubrangeRangeCheck - returns a range check node which
                            remembers the information necessary
                            so that a range check for d := e
                            can be generated later on.
*/

EXTERN unsigned int M2Range_InitSubrangeRangeCheck (unsigned int d, unsigned int e);

/*
   InitStaticArraySubscriptRangeCheck - returns a range check node which
                                        remembers the information necessary
                                        so that a range check for d[e]
                                        can be generated later on.
*/

EXTERN unsigned int M2Range_InitStaticArraySubscriptRangeCheck (unsigned int d, unsigned int e, unsigned int dim);

/*
   InitDynamicArraySubscriptRangeCheck - returns a range check node which
                                         remembers the information necessary
                                         so that a range check for d[e]
                                         can be generated later on.
*/

EXTERN unsigned int M2Range_InitDynamicArraySubscriptRangeCheck (unsigned int d, unsigned int e, unsigned int dim);

/*
   InitIncRangeCheck - returns a range check node which
                       remembers the information necessary
                       so that a range check for INC(d, e)
                       can be generated later on.
*/

EXTERN unsigned int M2Range_InitIncRangeCheck (unsigned int d, unsigned int e);

/*
   InitDecRangeCheck - returns a range check node which
                       remembers the information necessary
                       so that a range check for DEC(d, e)
                       can be generated later on.
*/

EXTERN unsigned int M2Range_InitDecRangeCheck (unsigned int d, unsigned int e);

/*
   InitForLoopBeginRangeCheck - returns a range check node which
                                remembers the information necessary
                                so that a range check for
                                FOR des := expr1 TO expr2 DO
                                can be generated later on.  expr2 is
                                only used to type check with des.
*/

EXTERN unsigned int M2Range_InitForLoopBeginRangeCheck (unsigned int des, unsigned int destok, unsigned int expr1, unsigned int expr1tok, unsigned int expr2, unsigned int expr2tok, unsigned int byconst, unsigned int byconsttok);

/*
   PutRangeForIncrement - places incrementquad into the range record.
*/

EXTERN void M2Range_PutRangeForIncrement (unsigned int range, unsigned int incrementquad);

/*
   InitForLoopToRangeCheck - returns a range check node which
                             remembers the information necessary
                             so that a range check for the final value
                             implied by ... e1 TO e2 BY e3 DO
                             can be generated later on.
*/

EXTERN unsigned int M2Range_InitForLoopToRangeCheck (unsigned int d, unsigned int e);

/*
   InitForLoopEndRangeCheck - returns a range check node which
                              remembers the information necessary
                              so that a range check for
                              INC or DEC(d, e)
                              can be generated later on.
*/

EXTERN unsigned int M2Range_InitForLoopEndRangeCheck (unsigned int d, unsigned int e);

/*
   InitPointerRangeCheck - creates a pointer # NIL check.
*/

EXTERN unsigned int M2Range_InitPointerRangeCheck (unsigned int tokno, unsigned int d, bool isLeft);

/*
   InitNoReturnRangeCheck - creates a check held in the function
                            to detect the absence of a RETURN
                            statement at runtime.
*/

EXTERN unsigned int M2Range_InitNoReturnRangeCheck (void);

/*
   InitNoElseRangeCheck - creates a check held at the end of
                          a CASE statement without an ELSE
                          clause to detect its absence
                          at runtime.
*/

EXTERN unsigned int M2Range_InitNoElseRangeCheck (void);

/*
   InitWholeNonPosDivCheck - creates a check expression for non positive
                             or zero 2nd operand to division.
*/

EXTERN unsigned int M2Range_InitWholeNonPosDivCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitWholeNonPosModCheck - creates a check expression for non positive
                             or zero 2nd operand to modulus.
*/

EXTERN unsigned int M2Range_InitWholeNonPosModCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitWholeZeroDivisionCheck - creates a check expression for zero 2nd
                                operand for division.
*/

EXTERN unsigned int M2Range_InitWholeZeroDivisionCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitWholeZeroRemainderCheck - creates a check expression for zero 2nd
                                 operand for remainder.
*/

EXTERN unsigned int M2Range_InitWholeZeroRemainderCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitInclCheck - checks to see that bit, e, is type compatible with
                   d and also in range.
*/

EXTERN unsigned int M2Range_InitInclCheck (unsigned int d, unsigned int e);

/*
   InitExclCheck - checks to see that bit, e, is type compatible with
                   d and also in range.
*/

EXTERN unsigned int M2Range_InitExclCheck (unsigned int d, unsigned int e);

/*
   InitShiftCheck - checks to see that bit, e, is type compatible with
                    d and also in range.
*/

EXTERN unsigned int M2Range_InitShiftCheck (unsigned int d, unsigned int e);

/*
   InitRotateCheck - checks to see that bit, e, is type compatible with
                     d and also in range.
*/

EXTERN unsigned int M2Range_InitRotateCheck (unsigned int d, unsigned int e);

/*
   InitTypesAssignmentCheck - checks to see that the types of, d, and, e,
                              are assignment compatible.
*/

EXTERN unsigned int M2Range_InitTypesAssignmentCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitTypesParameterCheck - checks to see that the types of, d, and, e,
                             are parameter compatible.
*/

EXTERN unsigned int M2Range_InitTypesParameterCheck (unsigned int tokno, unsigned int proc, unsigned int paramno, unsigned int formal, unsigned int actual, unsigned int depRangeId);

/*
   InitParameterRangeCheck - checks to see that the types of, d, and, e,
                             are parameter compatible.
*/

EXTERN unsigned int M2Range_InitParameterRangeCheck (unsigned int tokno, unsigned int proc, unsigned int paramno, unsigned int formal, unsigned int actual, unsigned int parentRangeId);

/*
   InitTypesExpressionCheck - checks to see that the types of, d, and, e,
                              are expression compatible.
*/

EXTERN unsigned int M2Range_InitTypesExpressionCheck (unsigned int tokno, unsigned int d, unsigned int e, bool strict, bool isin);

/*
   InitTypesIndrXCheck - checks to see that the types of d and e
                         are assignment compatible.  The type checking
                         will dereference *e during the type check.
                         d = *e.
*/

EXTERN unsigned int M2Range_InitTypesIndrXCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitTypesReturnTypeCheck - checks to see that the type of val can
                                   be returned from func.
*/

EXTERN unsigned int M2Range_InitTypesReturnTypeCheck (unsigned int tokno, unsigned int func, unsigned int val);

/*
   InitCaseBounds - creates a case bound range check.
*/

EXTERN unsigned int M2Range_InitCaseBounds (unsigned int b);

/*
   CodeRangeCheck - creates a sequence of Trees representing the code for a
                    range test defined by, r.
*/

EXTERN void M2Range_CodeRangeCheck (unsigned int r, DynamicStrings_String function);

/*
   FoldRangeCheck - attempts to resolve the range check.
*/

EXTERN void M2Range_FoldRangeCheck (unsigned int tokenno, unsigned int quad, unsigned int range);

/*
   CodeErrorCheck - returns a Tree calling the approprate exception handler.
*/

EXTERN tree M2Range_CodeErrorCheck (unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   WriteRangeCheck - displays debugging information about range, r.
*/

EXTERN void M2Range_WriteRangeCheck (unsigned int r);

/*
   OverlapsRange - returns TRUE if a1..a2 overlaps with b1..b2.
*/

EXTERN bool M2Range_OverlapsRange (tree a1, tree a2, tree b1, tree b2);

/*
   IsEqual - returns TRUE if a=b.
*/

EXTERN bool M2Range_IsEqual (tree a, tree b);

/*
   IsGreaterOrEqual - returns TRUE if a>=b.
*/

EXTERN bool M2Range_IsGreaterOrEqual (tree a, tree b);

/*
   IsGreater - returns TRUE if a>b.
*/

EXTERN bool M2Range_IsGreater (tree a, tree b);

/*
   BuildIfCallWholeHandlerLoc - return a Tree containing a runtime test whether, condition, is true.
*/

EXTERN tree M2Range_BuildIfCallWholeHandlerLoc (location_t location, tree condition, const char * scope, const char * message);

/*
   BuildIfCallRealHandlerLoc - return a Tree containing a runtime test whether, condition, is true.
*/

EXTERN tree M2Range_BuildIfCallRealHandlerLoc (location_t location, tree condition, const char * scope, const char * message);

/*
   GetMinMax - returns TRUE if we know the max and min of a type, t.
*/

EXTERN bool M2Range_GetMinMax (unsigned int tokenno, unsigned int type, tree *min, tree *max);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
