/* do not edit automatically generated by mc from M2StateCheck.  */
/* M2StateCheck.def provide state check tracking for declarations.

Copyright (C) 2024-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaiusmod2@gmail.com>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2StateCheck_H)
#   define _M2StateCheck_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif


#   if defined (_M2StateCheck_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (M2StateCheck_StateCheck_D)
#  define M2StateCheck_StateCheck_D
   typedef void *M2StateCheck_StateCheck;
#endif


/*
   InitState - returns a new initialized StateCheck.
*/

EXTERN M2StateCheck_StateCheck M2StateCheck_InitState (void);

/*
   KillState - destructor for StateCheck.
*/

EXTERN void M2StateCheck_KillState (M2StateCheck_StateCheck *s);

/*
   PushState - duplicates the StateCheck s and chains the new copy to s.
               Return the copy.
*/

EXTERN void M2StateCheck_PushState (M2StateCheck_StateCheck *s);

/*
   PopState - pops the current state.
*/

EXTERN void M2StateCheck_PopState (M2StateCheck_StateCheck *s);

/*
   InclVar - s := s + {var}.
*/

EXTERN void M2StateCheck_InclVar (M2StateCheck_StateCheck s);

/*
   InclConst - s := s + {const}.
*/

EXTERN void M2StateCheck_InclConst (M2StateCheck_StateCheck s);

/*
   InclType - s := s + {type}.
*/

EXTERN void M2StateCheck_InclType (M2StateCheck_StateCheck s);

/*
   InclConstFunc - s := s + {constfunc}.
*/

EXTERN void M2StateCheck_InclConstFunc (M2StateCheck_StateCheck s);

/*
   InclVarParam - s := s + {varparam}.
*/

EXTERN void M2StateCheck_InclVarParam (M2StateCheck_StateCheck s);

/*
   InclConstructor - s := s + {constructor}.
*/

EXTERN void M2StateCheck_InclConstructor (M2StateCheck_StateCheck s);

/*
   ExclVar - s := s + {var}.
*/

EXTERN void M2StateCheck_ExclVar (M2StateCheck_StateCheck s);

/*
   ExclConst - s := s + {const}.
*/

EXTERN void M2StateCheck_ExclConst (M2StateCheck_StateCheck s);

/*
   ExclType - s := s + {type}.
*/

EXTERN void M2StateCheck_ExclType (M2StateCheck_StateCheck s);

/*
   ExclConstFunc - s := s + {constfunc}.
*/

EXTERN void M2StateCheck_ExclConstFunc (M2StateCheck_StateCheck s);

/*
   ExclVarParam - s := s + {varparam}.
*/

EXTERN void M2StateCheck_ExclVarParam (M2StateCheck_StateCheck s);

/*
   ExclConstructor - s := s - {varparam}.
*/

EXTERN void M2StateCheck_ExclConstructor (M2StateCheck_StateCheck s);

/*
   CheckQualident - checks to see that qualident sym is allowed in the state s.
*/

EXTERN void M2StateCheck_CheckQualident (unsigned int tok, M2StateCheck_StateCheck s, unsigned int sym);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
