/* do not edit automatically generated by mc from M2GCCDeclare.  */
/* M2GCCDeclare.mod declares Modula-2 types to GCC.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2GCCDeclare_C

#include "GM2GCCDeclare.h"
#   include "GSYSTEM.h"
#   include "GASCII.h"
#   include "GStorage.h"
#   include "GM2Debug.h"
#   include "GM2Quads.h"
#   include "Gm2pp.h"
#   include "GFIO.h"
#   include "GM2Options.h"
#   include "GM2AsmUtil.h"
#   include "GM2Batch.h"
#   include "GNameKey.h"
#   include "GM2FileName.h"
#   include "GDynamicStrings.h"
#   include "GM2LexBuf.h"
#   include "GM2MetaError.h"
#   include "GM2Error.h"
#   include "GM2LangDump.h"
#   include "GM2Printf.h"
#   include "GIndexing.h"
#   include "GLists.h"
#   include "GSets.h"
#   include "GM2BasicBlock.h"
#   include "GSymbolTable.h"
#   include "GM2Base.h"
#   include "GM2System.h"
#   include "GM2Bitset.h"
#   include "GSymbolConversion.h"
#   include "GM2GenGCC.h"
#   include "GM2Scope.h"
#   include "GM2ALU.h"
#   include "Ggcctypes.h"
#   include "Gm2linemap.h"
#   include "Gm2decl.h"
#   include "Gm2type.h"
#   include "Gm2convert.h"
#   include "Gm2expr.h"
#   include "Gm2block.h"

#   define Debugging false
#   define Progress false
#   define EnableSSA false
#   define EnableWatch true
#   define TraceQuadruples false
typedef struct M2GCCDeclare_StartProcedure_p M2GCCDeclare_StartProcedure;

typedef struct M2GCCDeclare_doDeclareProcedure_p M2GCCDeclare_doDeclareProcedure;

typedef struct M2GCCDeclare__T1_r M2GCCDeclare__T1;

typedef M2GCCDeclare__T1 *M2GCCDeclare_Group;

typedef enum {M2GCCDeclare_fullydeclared, M2GCCDeclare_partiallydeclared, M2GCCDeclare_niltypedarrays, M2GCCDeclare_heldbyalignment, M2GCCDeclare_finishedalignment, M2GCCDeclare_todolist, M2GCCDeclare_tobesolvedbyquads, M2GCCDeclare_finishedsetarray} M2GCCDeclare_ListType;

typedef enum {M2GCCDeclare_norule, M2GCCDeclare_partialtype, M2GCCDeclare_arraynil, M2GCCDeclare_pointernilarray, M2GCCDeclare_arraypartial, M2GCCDeclare_pointerfully, M2GCCDeclare_recordkind, M2GCCDeclare_recordfully, M2GCCDeclare_typeconstfully, M2GCCDeclare_pointerfrompartial, M2GCCDeclare_typefrompartial, M2GCCDeclare_partialfrompartial, M2GCCDeclare_partialtofully, M2GCCDeclare_circulartodo, M2GCCDeclare_circularpartial, M2GCCDeclare_circularniltyped} M2GCCDeclare_Rule;

#   define DebugLoop 1000
typedef tree (*M2GCCDeclare_StartProcedure_t) (location_t, void *);
struct M2GCCDeclare_StartProcedure_p { M2GCCDeclare_StartProcedure_t proc; };

typedef void (*M2GCCDeclare_doDeclareProcedure_t) (unsigned int, unsigned int);
struct M2GCCDeclare_doDeclareProcedure_p { M2GCCDeclare_doDeclareProcedure_t proc; };

struct M2GCCDeclare__T1_r {
                            Sets_Set ToBeSolvedByQuads;
                            Sets_Set FinishedSetArray;
                            Sets_Set NilTypedArrays;
                            Sets_Set FullyDeclared;
                            Sets_Set PartiallyDeclared;
                            Sets_Set HeldByAlignment;
                            Sets_Set FinishedAlignment;
                            Sets_Set ToDoList;
                            M2GCCDeclare_Group Next;
                          };

static M2GCCDeclare_Group FreeGroup;
static M2GCCDeclare_Group GlobalGroup;
static Sets_Set ErrorDepList;
static Sets_Set VisitedList;
static Sets_Set ChainedList;
static bool HaveInitDefaultTypes;
static Sets_Set WatchList;
static Indexing_Index EnumerationIndex;
static M2GCCDeclare_IsAction action;
static bool ConstantResolved;
static bool enumDeps;
static M2GCCDeclare_WalkAction bodyp;
static M2GCCDeclare_IsAction bodyq;
static M2GCCDeclare_ListType bodyt;
static M2GCCDeclare_Rule bodyr;
static bool recursionCaught;
static bool oneResolved;
static bool noMoreWritten;
static M2GCCDeclare_WalkAction unboundedp;
static unsigned int MaxEnumerationField;
static unsigned int MinEnumerationField;

/*
   FoldConstants - a wrapper for ResolveConstantExpressions.
*/

extern "C" void M2GCCDeclare_FoldConstants (M2BasicBlock_BasicBlock bb);

/*
   StartDeclareScope - declares types, variables associated with this scope.
*/

extern "C" void M2GCCDeclare_StartDeclareScope (unsigned int scope);

/*
   EndDeclareScope -
*/

extern "C" void M2GCCDeclare_EndDeclareScope (void);

/*
   DeclareParameters -
*/

extern "C" void M2GCCDeclare_DeclareParameters (unsigned int sym);

/*
   DeclareConstant - checks to see whether, sym, is a constant and
                     declares the constant to gcc.
*/

extern "C" void M2GCCDeclare_DeclareConstant (unsigned int tokenno, unsigned int sym);

/*
   DeclareConstructor - declares a constructor.
*/

extern "C" void M2GCCDeclare_DeclareConstructor (unsigned int tokenno, unsigned int quad, unsigned int sym);

/*
   TryDeclareConstant - try and declare a constant.  If, sym, is a
                        constant try and declare it, if we cannot
                        then enter it into the to do list.
*/

extern "C" void M2GCCDeclare_TryDeclareConstant (unsigned int tokenno, unsigned int sym);

/*
   TryDeclareType - try and declare a type.  If sym is a
                    type try and declare it, if we cannot
                    then enter it into the to do list.
*/

extern "C" void M2GCCDeclare_TryDeclareType (unsigned int type);

/*
   TryDeclareConstructor - try and declare a constructor.  If, sym, is a
                           constructor try and declare it, if we cannot
                           then enter it into the to do list.
*/

extern "C" void M2GCCDeclare_TryDeclareConstructor (unsigned int tokenno, unsigned int sym);

/*
   DeclareLocalVariables - declares Local variables for procedure.
*/

extern "C" void M2GCCDeclare_DeclareLocalVariables (unsigned int procedure);

/*
   DeclareLocalVariable - declare a local variable var.
*/

extern "C" void M2GCCDeclare_DeclareLocalVariable (unsigned int var);

/*
   DeclareProcedure - declares procedure, sym, or all procedures inside
                      module sym.
*/

extern "C" void M2GCCDeclare_DeclareProcedure (unsigned int sym);

/*
   DeclareModuleVariables - declares Module variables for a module
                            which was declared inside a procedure.
*/

extern "C" void M2GCCDeclare_DeclareModuleVariables (unsigned int sym);

/*
   IsProcedureGccNested - returns TRUE if procedure, sym, will be considered
                          as nested by GCC.
                          This will occur if either its outer defining scope
                          is a procedure or is a module which is inside a
                          procedure.
*/

extern "C" bool M2GCCDeclare_IsProcedureGccNested (unsigned int sym);

/*
   PoisonSymbols - poisons all gcc symbols from procedure, sym.
                   A debugging aid.
*/

extern "C" void M2GCCDeclare_PoisonSymbols (unsigned int sym);

/*
   PromoteToString - declare, sym, and then promote it to a string.
                     Note that if sym is a single character we do
                          *not* record it as a string
                          but as a char however we always
                          return a string constant.
*/

extern "C" tree M2GCCDeclare_PromoteToString (unsigned int tokenno, unsigned int sym);

/*
   PromoteToCString - declare, sym, and then promote it to a string.
                      Note that if sym is a single character we do
                          *not* record it as a string
                          but as a char however we always
                          return a string constant.
*/

extern "C" tree M2GCCDeclare_PromoteToCString (unsigned int tokenno, unsigned int sym);

/*
   CompletelyResolved - returns TRUE if a symbols has been completely resolved
                        and is not partically declared (such as a record).
*/

extern "C" bool M2GCCDeclare_CompletelyResolved (unsigned int sym);

/*
   ConstantKnownAndUsed -
*/

extern "C" void M2GCCDeclare_ConstantKnownAndUsed (unsigned int sym, tree t);

/*
   PutToBeSolvedByQuads - places, sym, to this list and returns,
                          sym.
*/

extern "C" void M2GCCDeclare_PutToBeSolvedByQuads (unsigned int sym);

/*
   MarkExported - tell GCC to mark all exported procedures in module sym.
*/

extern "C" void M2GCCDeclare_MarkExported (unsigned int sym);

/*
   GetTypeMin -
*/

extern "C" unsigned int M2GCCDeclare_GetTypeMin (unsigned int type);

/*
   GetTypeMax -
*/

extern "C" unsigned int M2GCCDeclare_GetTypeMax (unsigned int type);

/*
   PrintSym - prints limited information about a symbol.
              This procedure is externally visible.
*/

extern "C" void M2GCCDeclare_PrintSym (unsigned int sym);

/*
   IncludeDumpSymbol - include sym into the watch list and all syms dependants.
*/

extern "C" void M2GCCDeclare_IncludeDumpSymbol (unsigned int sym);

/*
   DumpFilteredResolver - dumps the gimple or tree representation of all watched symbols.
*/

extern "C" void M2GCCDeclare_DumpFilteredResolver (void);

/*
   DumpFilteredDefinitive - dumps the gimple or tree representation of all watched symbols.
*/

extern "C" void M2GCCDeclare_DumpFilteredDefinitive (void);

/*
   InitDeclarations - initializes default types and the source filename.
*/

extern "C" void M2GCCDeclare_InitDeclarations (void);

/*
   PrintNum -
*/

static void PrintNum (unsigned int sym);

/*
   DebugSet -
*/

static void DebugSet (const char *a_, unsigned int _a_high, Sets_Set l);

/*
   DebugSets -
*/

static void DebugSets (void);

/*
   DebugNumber -
*/

static void DebugNumber (const char *a_, unsigned int _a_high, Sets_Set s);
static void DebugSetNumbers (void);

/*
   AddSymToWatch - adds symbol, sym, to the list of symbols
                   to watch and annotate their movement between
                   lists.
*/

static void AddSymToWatch (unsigned int sym);

/*
   doInclude -
*/

static void doInclude (Sets_Set l, const char *a_, unsigned int _a_high, unsigned int sym);

/*
   WatchIncludeList - include a symbol onto the set first checking
                      whether it is already on the set and
                      displaying a debug message if the set is
                      changed.
*/

static void WatchIncludeList (unsigned int sym, M2GCCDeclare_ListType lt);

/*
   doExclude -
*/

static void doExclude (Sets_Set l, const char *a_, unsigned int _a_high, unsigned int sym);

/*
   WatchRemoveList - remove a symbol onto the list first checking
                     whether it is already on the list and
                     displaying a debug message if the list is
                     changed.
*/

static void WatchRemoveList (unsigned int sym, M2GCCDeclare_ListType lt);

/*
   NewGroup -
*/

static void NewGroup (M2GCCDeclare_Group *g);

/*
   DisposeGroup -
*/

static void DisposeGroup (M2GCCDeclare_Group *g);

/*
   InitGroup - initialize all sets in group and return the group.
*/

static M2GCCDeclare_Group InitGroup (void);

/*
   KillGroup - delete all sets in group and deallocate g.
*/

static void KillGroup (M2GCCDeclare_Group *g);

/*
   DupGroup - If g is not NIL then destroy g.
              Return a duplicate of GlobalGroup.
*/

static M2GCCDeclare_Group DupGroup (M2GCCDeclare_Group g);

/*
   EqualGroup - return TRUE if group left = right.
*/

static bool EqualGroup (M2GCCDeclare_Group left, M2GCCDeclare_Group right);

/*
   LookupSet -
*/

static Sets_Set LookupSet (M2GCCDeclare_ListType listtype);

/*
   GetEnumList -
*/

static tree GetEnumList (unsigned int sym);

/*
   PutEnumList -
*/

static void PutEnumList (unsigned int sym, tree enumlist);

/*
   Chained - checks to see that, sym, has not already been placed on a chain.
             It returns the symbol, sym.
*/

static unsigned int Chained (unsigned int sym);

/*
   DoStartDeclaration - returns a tree representing a symbol which has
                        not yet been finished.  Used when declaring
                        recursive types.
*/

static tree DoStartDeclaration (unsigned int sym, M2GCCDeclare_StartProcedure p);

/*
   ArrayComponentsDeclared - returns TRUE if array, sym,
                             subscripts and type are known.
*/

static bool ArrayComponentsDeclared (unsigned int sym);

/*
   GetRecordOfVarient -
*/

static unsigned int GetRecordOfVarient (unsigned int sym);

/*
   CanDeclareRecordKind -
*/

static bool CanDeclareRecordKind (unsigned int sym);

/*
   DeclareRecordKind - works out whether record, sym, is packed or not.
*/

static void DeclareRecordKind (unsigned int sym);

/*
   CanDeclareRecord -
*/

static bool CanDeclareRecord (unsigned int sym);

/*
   FinishDeclareRecord -
*/

static void FinishDeclareRecord (unsigned int sym);

/*
   CanDeclareTypePartially - return TRUE if we are able to make a
                             gcc partially created type.
*/

static bool CanDeclareTypePartially (unsigned int sym);

/*
   DeclareTypePartially - create the gcc partial type symbol from, sym.
*/

static void DeclareTypePartially (unsigned int sym);

/*
   CanDeclareArrayAsNil -
*/

static bool CanDeclareArrayAsNil (unsigned int sym);

/*
   DeclareArrayAsNil -
*/

static void DeclareArrayAsNil (unsigned int sym);

/*
   CanDeclareArrayPartially -
*/

static bool CanDeclareArrayPartially (unsigned int sym);

/*
   DeclareArrayPartially -
*/

static void DeclareArrayPartially (unsigned int sym);

/*
   CanDeclarePointerToNilArray -
*/

static bool CanDeclarePointerToNilArray (unsigned int sym);

/*
   DeclarePointerToNilArray -
*/

static void DeclarePointerToNilArray (unsigned int sym);

/*
   CanPromotePointerFully -
*/

static bool CanPromotePointerFully (unsigned int sym);

/*
   PromotePointerFully -
*/

static void PromotePointerFully (unsigned int sym);

/*
   IsTypeQ - returns TRUE if all q(dependants) of, sym,
             return TRUE.
*/

static bool IsTypeQ (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   IsNilTypedArrays - returns TRUE if, sym, is dependant upon a NIL typed array
*/

static bool IsNilTypedArrays (unsigned int sym);

/*
   IsFullyDeclared - returns TRUE if, sym, is fully declared.
*/

static bool IsFullyDeclared (unsigned int sym);

/*
   AllDependantsFullyDeclared - returns TRUE if all dependants of,
                                sym, are declared.
*/

static bool AllDependantsFullyDeclared (unsigned int sym);

/*
   NotAllDependantsFullyDeclared - returns TRUE if any dependants of,
                                   sym, are not declared.
*/

static bool NotAllDependantsFullyDeclared (unsigned int sym);

/*
   IsPartiallyDeclared - returns TRUE if, sym, is partially declared.
*/

static bool IsPartiallyDeclared (unsigned int sym);

/*
   AllDependantsPartiallyDeclared - returns TRUE if all dependants of,
                                    sym, are partially declared.
*/

static bool AllDependantsPartiallyDeclared (unsigned int sym);

/*
   NotAllDependantsPartiallyDeclared - returns TRUE if any dependants of,
                                       sym, are not partially declared.
*/

static bool NotAllDependantsPartiallyDeclared (unsigned int sym);

/*
   IsPartiallyOrFullyDeclared - returns TRUE if, sym, is partially or fully declared.
*/

static bool IsPartiallyOrFullyDeclared (unsigned int sym);

/*
   AllDependantsPartiallyOrFullyDeclared - returns TRUE if all dependants of,
                                           sym, are partially or fully declared.
*/

static bool AllDependantsPartiallyOrFullyDeclared (unsigned int sym);

/*
   TypeConstDependantsFullyDeclared - returns TRUE if sym is a constant or
                                      type and its dependants are fully
                                      declared.
*/

static bool TypeConstDependantsFullyDeclared (unsigned int sym);

/*
   CanBeDeclaredViaPartialDependants - returns TRUE if this symbol
                                       can be declared by partial
                                       dependants.  Such a symbol must
                                       be a record, proctype or
                                       an array.
*/

static bool CanBeDeclaredViaPartialDependants (unsigned int sym);

/*
   DeclareConstFully - will add, sym, to the fully declared list and
                       also remove it from the to do list.  This is
                       called indirectly from M2GenGCC as it calculates
                       constants during quadruple processing.
*/

static void DeclareConstFully (unsigned int sym);

/*
   DeclareTypeConstFully - declare the GCC type and add the double
                           book keeping entry.
*/

static void DeclareTypeConstFully (unsigned int sym);

/*
   DeclareTypeFromPartial - declare the full GCC type from a partial type
                            and add the double book keeping entry.
*/

static void DeclareTypeFromPartial (unsigned int sym);

/*
   CanBeDeclaredPartiallyViaPartialDependants - returns TRUE if, sym,
                                                can be partially declared via
                                                another partially declared type.
*/

static bool CanBeDeclaredPartiallyViaPartialDependants (unsigned int sym);

/*
   EmitCircularDependencyError - issue a dependency error.
*/

static void EmitCircularDependencyError (unsigned int sym);

/*
   WriteRule - writes out the name of the rule.
*/

static void WriteRule (void);

/*
   Body -
*/

static void Body (unsigned int sym);

/*
   ForeachTryDeclare - while q (of one sym in set t) is true
                          for each symbol in set t,
                             if q (sym)
                             then
                                p (sym)
                             end
                          end
                       end
*/

static bool ForeachTryDeclare (M2GCCDeclare_ListType t, M2GCCDeclare_Rule r, M2GCCDeclare_IsAction q, M2GCCDeclare_WalkAction p);
static bool DeclaredOutstandingTypes (bool ForceComplete);

/*
   CompleteDeclarationOf - returns the GCC Tree for, sym, if it can
                           be created from partially or fully declared
                           dependents.
*/

static tree CompleteDeclarationOf (unsigned int sym);

/*
   DeclareType - here a type has been created via TYPE foo = bar,
                 we must tell GCC about it.
*/

static tree DeclareType (unsigned int sym);
static void DeclareConstantFromTree (unsigned int sym, tree value);

/*
   DeclareCharConstant - declares a character constant.
*/

static void DeclareCharConstant (unsigned int tokenno, unsigned int sym);

/*
   DeclareStringConstant - declares a string constant the sym will be known.
*/

static void DeclareStringConstant (unsigned int tokenno, unsigned int sym);

/*
   WalkConstructor - walks all dependants of, sym.
*/

static void WalkConstructor (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   WalkConst - walks all dependants of, sym.
*/

static void WalkConst (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsConstDependants - returns TRUE if the symbol, sym,
                       q(dependants) all return TRUE.
*/

static bool IsConstDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   IsAnyType - return TRUE if sym is any Modula-2 type.
*/

static bool IsAnyType (unsigned int sym);

/*
   DeclareConstString -
*/

static bool DeclareConstString (unsigned int tokenno, unsigned int sym);

/*
   TryDeclareConst - try to declare a const to gcc.  If it cannot
                     declare the symbol it places it into the
                     todolist.
*/

static void TryDeclareConst (unsigned int tokenno, unsigned int sym);

/*
   DeclareConst - declares a const to gcc and returns a Tree.
*/

static tree DeclareConst (unsigned int tokenno, unsigned int sym);

/*
   WalkFamilyOfUnbounded -
*/

static void WalkFamilyOfUnbounded (unsigned int oaf __attribute__((unused)), unsigned int dim __attribute__((unused)), unsigned int unbounded);

/*
   WalkAssociatedUnbounded -
*/

static void WalkAssociatedUnbounded (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   WalkDependants - walks through all dependants of, Sym,
                    calling, p, for each dependant.
*/

static void WalkDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   TraverseDependantsInner -
*/

static void TraverseDependantsInner (unsigned int sym);

/*
   TraverseDependants - walks, sym, dependants.  But it checks
                        to see that, sym, is not on the
                        FullyDeclared and not on the ToDoList.
*/

static void TraverseDependants (unsigned int sym);

/*
   WalkTypeInfo - walks type, sym, and its dependants.
*/

static void WalkTypeInfo (unsigned int sym);

/*
   DeclareUnboundedProcedureParameters -
*/

static void DeclareUnboundedProcedureParameters (unsigned int sym);

/*
   WalkUnboundedProcedureParameters -
*/

static void WalkUnboundedProcedureParameters (unsigned int sym);

/*
   WalkTypesInProcedure - walk all types in procedure, Sym.
*/

static void WalkTypesInProcedure (unsigned int sym);

/*
   WalkTypesInModule - declare all types in module, Sym, to GCC.
*/

static void WalkTypesInModule (unsigned int sym);

/*
   IsRecordFieldDependants - returns TRUE if the record field
                             symbol, sym, p(dependants) all return TRUE.
*/

static bool IsRecordFieldDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   GetModuleWhereDeclared - returns the module where, Sym, was created.
*/

static unsigned int GetModuleWhereDeclared (unsigned int sym);

/*
   IsPseudoProcFunc - returns TRUE if Sym is a pseudo function or procedure.
*/

static bool IsPseudoProcFunc (unsigned int Sym);

/*
   IsExternal -
*/

static bool IsExternal (unsigned int sym);

/*
   IsExternalToWholeProgram - return TRUE if the symbol, sym, is external to the
                              sources that we have parsed.
*/

static bool IsExternalToWholeProgram (unsigned int sym);

/*
   DeclareProcedureToGccWholeProgram -
*/

static void DeclareProcedureToGccWholeProgram (unsigned int Sym);

/*
   DeclareProcedureToGccSeparateProgram -
*/

static void DeclareProcedureToGccSeparateProgram (unsigned int Sym);

/*
   DeclareProcedureToGcc - traverses all parameters and interfaces to gm2gcc.
*/

static void DeclareProcedureToGcc (unsigned int sym);

/*
   ActivateWatch - activate a watch for any symbol (lista xor listb).
*/

static void ActivateWatch (Sets_Set lista, Sets_Set listb);

/*
   DeclareTypesConstantsProceduresInRange -
*/

static void DeclareTypesConstantsProceduresInRange (unsigned int scope, unsigned int start, unsigned int end);

/*
   SkipModuleScope - skips all module scopes for, scope.
                     It returns either NulSym or a procedure sym.
*/

static unsigned int SkipModuleScope (unsigned int scope);

/*
   PushBinding -
*/

static void PushBinding (unsigned int scope);

/*
   PopBinding -
*/

static void PopBinding (unsigned int scope);

/*
   DeclareTypesConstantsProcedures -
*/

static void DeclareTypesConstantsProcedures (unsigned int scope);

/*
   AssertAllTypesDeclared - asserts that all types for variables are declared in, scope.
*/

static void AssertAllTypesDeclared (unsigned int scope);

/*
   DeclareModuleInit - declare all the ctor related functions within
                       a module.
*/

static void DeclareModuleInit (unsigned int moduleSym);

/*
   StartDeclareProcedureScope -
*/

static void StartDeclareProcedureScope (unsigned int scope);

/*
   StartDeclareModuleScopeSeparate -
*/

static void StartDeclareModuleScopeSeparate (unsigned int scope);

/*
   StartDeclareModuleScopeWholeProgram -
*/

static void StartDeclareModuleScopeWholeProgram (unsigned int scope);

/*
   StartDeclareModuleScope -
*/

static void StartDeclareModuleScope (unsigned int scope);

/*
   DumpResolver - dumps the m2 representation of sym.
*/

static void DumpResolver (unsigned int sym);

/*
   DumpDefinitive - dumps the m2 and m2 gimple representation of sym.
*/

static void DumpDefinitive (unsigned int sym);

/*
   PreAddModGcc - adds a relationship between sym and tree.
*/

static void PreAddModGcc (unsigned int sym, tree tree);

/*
   DeclareDefaultType - declares a default type, sym, with, name.
*/

static void DeclareDefaultType (unsigned int sym, const char *name_, unsigned int _name_high, tree gcctype);

/*
   DeclareBoolean - declares the Boolean type together with true and false.
*/

static void DeclareBoolean (void);

/*
   DeclareFixedSizedType - declares the GNU Modula-2 fixed types
                           (if the back end support such a type).
*/

static void DeclareFixedSizedType (const char *name_, unsigned int _name_high, unsigned int type, tree t);

/*
   DeclareDefaultSimpleTypes - declares the simple types.
*/

static void DeclareDefaultSimpleTypes (void);

/*
   DeclarePackedBoolean -
*/

static void DeclarePackedBoolean (void);

/*
   DeclarePackedDefaultSimpleTypes -
*/

static void DeclarePackedDefaultSimpleTypes (void);

/*
   DeclareDefaultTypes - makes default types known to GCC
*/

static void DeclareDefaultTypes (void);

/*
   DeclareDefaultConstants - make default constants known to GCC
*/

static void DeclareDefaultConstants (void);

/*
   FindContext - returns the scope where the symbol
                 should be created.

                 Symbols created in a module will
                 return the global context tree, but symbols created
                 in a module which is declared inside
                 a procedure will return the procedure Tree.
*/

static tree FindContext (unsigned int sym);

/*
   IsEffectivelyImported - returns TRUE if symbol, Sym, was
                           effectively imported into ModSym.
*/

static bool IsEffectivelyImported (unsigned int ModSym, unsigned int sym);

/*
   FindOuterModule - returns the out most module where, sym,
                     was declared.  It returns NulSym if the
                     symbol or the module was declared inside
                     a procedure.
*/

static unsigned int FindOuterModule (unsigned int sym);

/*
   DoVariableDeclaration - create a corresponding gcc variable and add the association
                           between the front end symbol var and the gcc tree.
*/

static void DoVariableDeclaration (unsigned int var, void * name, bool isImported, bool isExported, bool isTemporary, bool isGlobal, tree scope);

/*
   TypeDependentsDeclared - return TRUE if all type dependents of variable
                            have been declared.
*/

static bool TypeDependentsDeclared (unsigned int variable, bool errorMessage);

/*
   PrepareGCCVarDeclaration -
*/

static void PrepareGCCVarDeclaration (unsigned int var, void * name, bool isImported, bool isExported, bool isTemporary, bool isGlobal, tree scope);

/*
   IsGlobal - is the variable not in a procedure scope.
*/

static bool IsGlobal (unsigned int sym);

/*
   DeclareVariable - declares a global variable to GCC.
*/

static void DeclareVariable (unsigned int ModSym, unsigned int variable);

/*
   DeclareVariableWholeProgram - declares a global variable to GCC when using -fm2-whole-program.
*/

static void DeclareVariableWholeProgram (unsigned int mainModule, unsigned int variable);

/*
   DeclareGlobalVariablesWholeProgram -
*/

static void DeclareGlobalVariablesWholeProgram (unsigned int ModSym);

/*
   DeclareGlobalVariables - lists the Global variables for
                            Module ModSym together with their offset.
*/

static void DeclareGlobalVariables (unsigned int ModSym);

/*
   DeclareImportedVariables - declares all imported variables to GM2.
*/

static void DeclareImportedVariables (unsigned int sym);

/*
   DeclareImportedVariablesWholeProgram - declares all imported variables.
*/

static void DeclareImportedVariablesWholeProgram (unsigned int sym);

/*
   DeclareFieldValue -
*/

static tree DeclareFieldValue (unsigned int sym, tree value, tree *list);

/*
   DeclareFieldEnumeration - declares an enumerator within the current enumeration type.
*/

static tree DeclareFieldEnumeration (unsigned int sym);

/*
   DeclareEnumeration - declare an enumerated type.
*/

static tree DeclareEnumeration (unsigned int sym);

/*
   DeclareSubrangeNarrow - will return cardinal, integer, or type depending on whether
                           low..high fits in the C data type.
*/

static tree DeclareSubrangeNarrow (location_t location, unsigned int high, unsigned int low, tree type);

/*
   DeclareSubrange - declare a subrange type.
*/

static tree DeclareSubrange (unsigned int sym);

/*
   IncludeGetNth -
*/

static void IncludeGetNth (Lists_List l, unsigned int sym);

/*
   IncludeType -
*/

static void IncludeType (Lists_List l, unsigned int sym);

/*
   IncludeSubscript -
*/

static void IncludeSubscript (Lists_List l, unsigned int sym);

/*
   PrintLocalSymbol -
*/

static void PrintLocalSymbol (unsigned int sym);

/*
   PrintLocalSymbols -
*/

static void PrintLocalSymbols (unsigned int sym);

/*
   IncludeGetVarient -
*/

static void IncludeGetVarient (Lists_List l, unsigned int sym);

/*
   IncludeUnbounded - includes the record component of an unbounded type.
*/

static void IncludeUnbounded (Lists_List l, unsigned int sym);

/*
   IncludePartialUnbounded - includes the type component of a partial unbounded symbol.
*/

static void IncludePartialUnbounded (Lists_List l, unsigned int sym);

/*
   PrintDeclared - prints out where, sym, was declared.
*/

static void PrintDeclared (unsigned int sym);

/*
   PrintAlignment -
*/

static void PrintAlignment (unsigned int sym);

/*
   IncludeGetParent -
*/

static void IncludeGetParent (Lists_List l, unsigned int sym);

/*
   PrintDecl -
*/

static void PrintDecl (unsigned int sym);

/*
   PrintScope - displays the scope and line number of declaration of symbol, sym.
*/

static void PrintScope (unsigned int sym);

/*
   PrintKind -
*/

static void PrintKind (SymbolTable_ProcedureKind kind);

/*
   PrintProcedureParameters -
*/

static void PrintProcedureParameters (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   PrintProcedureReturnType -
*/

static void PrintProcedureReturnType (unsigned int sym);

/*
   PrintProcedure -
*/

static void PrintProcedure (unsigned int sym);

/*
   PrintProcTypeParameters -
*/

static void PrintProcTypeParameters (unsigned int sym);

/*
   PrintProcType -
*/

static void PrintProcType (unsigned int sym);

/*
   PrintString -
*/

static void PrintString (unsigned int sym);

/*
   PrintVerboseFromList - prints the, i, th element in the list, l.
*/

static void PrintVerboseFromList (Lists_List l, unsigned int i);

/*
   PrintVerbose - prints limited information about a symbol.
*/

static void PrintVerbose (unsigned int sym);

/*
   PrintTerse -
*/

static void PrintTerse (unsigned int sym);

/*
   CheckAlignment -
*/

static tree CheckAlignment (tree type, unsigned int sym);

/*
   CheckPragma -
*/

static tree CheckPragma (tree type, unsigned int sym);

/*
   IsZero - returns TRUE if symbol, sym, is zero.
*/

static bool IsZero (unsigned int sym);

/*
   SetFieldPacked - sets Varient, VarientField and RecordField symbols
                    as packed.
*/

static void SetFieldPacked (unsigned int field);

/*
   RecordPacked - indicates that record, sym, and its fields
                  are all packed.
*/

static void RecordPacked (unsigned int sym);

/*
   SetFieldNotPacked - sets Varient, VarientField and RecordField symbols
                       as not packed.
*/

static void SetFieldNotPacked (unsigned int field);

/*
   RecordNotPacked - indicates that record, sym, and its fields
                     are all not packed.
*/

static void RecordNotPacked (unsigned int sym);

/*
   DetermineIfRecordPacked -
*/

static void DetermineIfRecordPacked (unsigned int sym);

/*
   DeclarePackedSubrange -
*/

static void DeclarePackedSubrange (unsigned int equiv, unsigned int sym);

/*
   DeclarePackedSet -
*/

static void DeclarePackedSet (unsigned int equiv, unsigned int sym);
static void DeclarePackedFieldEnumeration (unsigned int sym);

/*
   DeclarePackedEnumeration -
*/

static void DeclarePackedEnumeration (unsigned int equiv, unsigned int sym);

/*
   DeclarePackedType -
*/

static void DeclarePackedType (unsigned int equiv, unsigned int sym);

/*
   doDeclareEquivalent -
*/

static tree doDeclareEquivalent (unsigned int sym, M2GCCDeclare_doDeclareProcedure p);

/*
   PossiblyPacked -
*/

static tree PossiblyPacked (unsigned int sym, bool isPacked);

/*
   GetPackedType - returns a possibly packed type for field.
*/

static tree GetPackedType (unsigned int sym);

/*
   MaybeAlignField - checks to see whether, field, is packed or aligned and it updates
                     the offsets if appropriate.
*/

static tree MaybeAlignField (unsigned int field, tree *byteOffset, tree *bitOffset);

/*
   DeclareRecord - declares a record and its fields to gcc.
                   The final gcc record type is returned.
*/

static tree DeclareRecord (unsigned int Sym);

/*
   DeclareRecordField -
*/

static tree DeclareRecordField (unsigned int sym);

/*
   DeclareVarient - declares a record and its fields to gcc.
                    The final gcc record type is returned.
*/

static tree DeclareVarient (unsigned int sym);

/*
   DeclareFieldVarient -
*/

static tree DeclareFieldVarient (unsigned int sym);

/*
   DeclarePointer - declares a pointer type to gcc and returns the Tree.
*/

static tree DeclarePointer (unsigned int sym);

/*
   DeclareUnbounded - builds an unbounded type and returns the gcc tree.
*/

static tree DeclareUnbounded (unsigned int sym);

/*
   BuildIndex -
*/

static tree BuildIndex (unsigned int tokenno, unsigned int array);

/*
   DeclareArray - declares an array to gcc and returns the gcc tree.
*/

static tree DeclareArray (unsigned int Sym);

/*
   DeclareProcType - declares a procedure type to gcc and returns the gcc type tree.
*/

static tree DeclareProcType (unsigned int Sym);

/*
   FindMinMaxEnum - finds the minimum and maximum enumeration fields.
*/

static void FindMinMaxEnum (unsigned int field);

/*
   PushNoOfBits - pushes the integer value of the number of bits required
                  to maintain a set of type.
*/

static void PushNoOfBits (unsigned int type, unsigned int low, unsigned int high);

/*
   DeclareLargeSet - n is the name of the set.
                     type is the subrange type (or simple type)
                     low and high are the limits of the subrange.
*/

static tree DeclareLargeSet (NameKey_Name n, unsigned int type, unsigned int low, unsigned int high);

/*
   DeclareLargeOrSmallSet - works out whether the set will exceed TSIZE(WORD). If it does
                            we manufacture a set using:

                            settype = RECORD
                                         w1: SET OF [...]
                                         w2: SET OF [...]
                                      END

                            We do this as GCC and GDB (stabs) only knows about WORD sized sets.
                            If the set will fit into a WORD then we call gccgm2 directly.
*/

static tree DeclareLargeOrSmallSet (unsigned int sym, NameKey_Name n, unsigned int type, unsigned int low, unsigned int high);

/*
   DeclareSet - declares a set type to gcc and returns a Tree.
*/

static tree DeclareSet (unsigned int sym);

/*
   CheckResolveSubrange - checks to see whether we can determine
                          the subrange type.  We are able to do
                          this once low, high and the type are known.
*/

static void CheckResolveSubrange (unsigned int sym);

/*
   TypeConstFullyDeclared - all, sym, dependents are declared, so create and
                            return the GCC Tree equivalent.
*/

static tree TypeConstFullyDeclared (unsigned int sym);

/*
   IsBaseType - returns true if a type, Sym, is a base type and
                we use predefined GDB information to represent this
                type.
*/

static bool IsBaseType (unsigned int Sym);

/*
   IsFieldEnumerationDependants - sets enumDeps to FALSE if action(Sym)
                                  is also FALSE.
*/

static void IsFieldEnumerationDependants (unsigned int Sym);

/*
   IsEnumerationDependants - returns true if the enumeration
                             p(dependants) all return true.
*/

static bool IsEnumerationDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkEnumerationDependants - returns walks all dependants of Sym.
*/

static void WalkEnumerationDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   WalkSubrangeDependants - calls p(dependants) for each dependant of, sym.
*/

static void WalkSubrangeDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsSubrangeDependants - returns TRUE if the subrange
                          q(dependants) all return TRUE.
*/

static bool IsSubrangeDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkComponentDependants -
*/

static void WalkComponentDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsComponentDependants -
*/

static bool IsComponentDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkVarDependants - walks all dependants of sym.
*/

static void WalkVarDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsVarDependants - returns TRUE if the pointer symbol, sym,
                     p(dependants) all return TRUE.
*/

static bool IsVarDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkPointerDependants - walks all dependants of sym.
*/

static void WalkPointerDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsPointerDependants - returns TRUE if the pointer symbol, sym,
      	       	         p(dependants) all return TRUE.
*/

static bool IsPointerDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   IsRecordAlignment -
*/

static bool IsRecordAlignment (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   IsRecordDependants - returns TRUE if the symbol, sym,
                        q(dependants) all return TRUE.
*/

static bool IsRecordDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkRecordAlignment - walks the alignment constant associated with
                         record, sym.
*/

static void WalkRecordAlignment (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   WalkRecordDependants - walks symbol, sym, dependants.  It only
                          walks the fields if the alignment is
                          unused or fully declared.
*/

static void WalkRecordDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   WalkRecordFieldDependants -
*/

static void WalkRecordFieldDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   WalkRecordDependants2 - walks the fields of record, sym, calling
                           p on every dependant.
*/

static void WalkRecordDependants2 (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsVarientAlignment -
*/

static bool IsVarientAlignment (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   IsVarientDependants - returns TRUE if the symbol, sym,
                         q(dependants) all return TRUE.
*/

static bool IsVarientDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkVarientAlignment -
*/

static void WalkVarientAlignment (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   WalkVarientDependants - walks symbol, sym, dependants.
*/

static void WalkVarientDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsVarientFieldDependants - returns TRUE if the symbol, sym,
                              q(dependants) all return TRUE.
*/

static bool IsVarientFieldDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkVarientFieldDependants -
*/

static void WalkVarientFieldDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsArrayDependants - returns TRUE if the symbol, sym,
      	       	       q(dependants) all return TRUE.

*/

static bool IsArrayDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkArrayDependants - walks symbol, sym, dependants.
*/

static void WalkArrayDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsSetDependants - returns TRUE if the symbol, sym,
                     q(dependants) all return TRUE.
*/

static bool IsSetDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkSetDependants - walks dependants, sym.
*/

static void WalkSetDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsProcTypeDependants -
*/

static bool IsProcTypeDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkProcTypeDependants - walks dependants, sym.
*/

static void WalkProcTypeDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsProcedureDependants -
*/

static bool IsProcedureDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkProcedureDependants - walks dependants, sym.
*/

static void WalkProcedureDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsUnboundedDependants - returns TRUE if the symbol, sym,
                           q(dependants) all return TRUE.
*/

static bool IsUnboundedDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkUnboundedDependants - walks the dependants of, sym.
*/

static void WalkUnboundedDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsTypeDependants - returns TRUE if all q(dependants) return
                      TRUE.
*/

static bool IsTypeDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkTypeDependants - walks all dependants of, sym.
*/

static void WalkTypeDependants (unsigned int sym, M2GCCDeclare_WalkAction p);


/*
   PrintNum -
*/

static void PrintNum (unsigned int sym)
{
  M2Printf_printf1 ((const char *) "%d, ", 4, (const unsigned char *) &sym, (sizeof (sym)-1));
}


/*
   DebugSet -
*/

static void DebugSet (const char *a_, unsigned int _a_high, Sets_Set l)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  M2Printf_printf0 ((const char *) a, _a_high);
  M2Printf_printf0 ((const char *) " {", 2);
  Sets_ForeachElementInSetDo (l, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) PrintNum});
  M2Printf_printf0 ((const char *) "}\\n", 3);
}


/*
   DebugSets -
*/

static void DebugSets (void)
{
  DebugSet ((const char *) "ToDoList", 8, GlobalGroup->ToDoList);
  DebugSet ((const char *) "HeldByAlignment", 15, GlobalGroup->HeldByAlignment);
  DebugSet ((const char *) "FinishedAlignment", 17, GlobalGroup->FinishedAlignment);
  DebugSet ((const char *) "PartiallyDeclared", 17, GlobalGroup->PartiallyDeclared);
  DebugSet ((const char *) "FullyDeclared", 13, GlobalGroup->FullyDeclared);
  DebugSet ((const char *) "NilTypedArrays", 14, GlobalGroup->NilTypedArrays);
  DebugSet ((const char *) "ToBeSolvedByQuads", 17, GlobalGroup->ToBeSolvedByQuads);
  DebugSet ((const char *) "FinishedSetArray", 16, GlobalGroup->FinishedSetArray);
}


/*
   DebugNumber -
*/

static void DebugNumber (const char *a_, unsigned int _a_high, Sets_Set s)
{
  unsigned int n;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  n = Sets_NoOfElementsInSet (s);
  M2Printf_printf1 ((const char *) a, _a_high, (const unsigned char *) &n, (sizeof (n)-1));
  FIO_FlushBuffer (FIO_StdOut);
}

static void DebugSetNumbers (void)
{
  /* 
   DebugSets -
  */
  DebugNumber ((const char *) "ToDoList : %d\\n", 15, GlobalGroup->ToDoList);
  DebugNumber ((const char *) "HeldByAlignment : %d\\n", 22, GlobalGroup->HeldByAlignment);
  DebugNumber ((const char *) "PartiallyDeclared : %d\\n", 24, GlobalGroup->PartiallyDeclared);
  DebugNumber ((const char *) "FullyDeclared : %d\\n", 20, GlobalGroup->FullyDeclared);
  DebugNumber ((const char *) "NilTypedArrays : %d\\n", 21, GlobalGroup->NilTypedArrays);
  DebugNumber ((const char *) "ToBeSolvedByQuads : %d\\n", 24, GlobalGroup->ToBeSolvedByQuads);
  DebugNumber ((const char *) "FinishedSetArray : %d\\n", 23, GlobalGroup->FinishedSetArray);
}


/*
   AddSymToWatch - adds symbol, sym, to the list of symbols
                   to watch and annotate their movement between
                   lists.
*/

static void AddSymToWatch (unsigned int sym)
{
  if ((sym != SymbolTable_NulSym) && (! (Sets_IsElementInSet (WatchList, sym))))
    {
      Sets_IncludeElementIntoSet (WatchList, sym);
      WalkDependants (sym, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) AddSymToWatch});
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "%d, ", 4, (const unsigned char *) &sym, (sizeof (sym)-1));
    }
}


/*
   doInclude -
*/

static void doInclude (Sets_Set l, const char *a_, unsigned int _a_high, unsigned int sym)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  if (! (Sets_IsElementInSet (l, sym)))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "rule: ", 6);
      WriteRule ();
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) a, _a_high, (const unsigned char *) &sym, (sizeof (sym)-1));
      Sets_IncludeElementIntoSet (l, sym);
    }
}


/*
   WatchIncludeList - include a symbol onto the set first checking
                      whether it is already on the set and
                      displaying a debug message if the set is
                      changed.
*/

static void WatchIncludeList (unsigned int sym, M2GCCDeclare_ListType lt)
{
  if (Sets_IsElementInSet (WatchList, sym))
    {
      switch (lt)
        {
          case M2GCCDeclare_tobesolvedbyquads:
            doInclude (GlobalGroup->ToBeSolvedByQuads, (const char *) "symbol %d -> ToBeSolvedByQuads\\n", 32, sym);
            break;

          case M2GCCDeclare_fullydeclared:
            doInclude (GlobalGroup->FullyDeclared, (const char *) "symbol %d -> FullyDeclared\\n", 28, sym);
            break;

          case M2GCCDeclare_partiallydeclared:
            doInclude (GlobalGroup->PartiallyDeclared, (const char *) "symbol %d -> PartiallyDeclared\\n", 32, sym);
            break;

          case M2GCCDeclare_heldbyalignment:
            doInclude (GlobalGroup->HeldByAlignment, (const char *) "symbol %d -> HeldByAlignment\\n", 30, sym);
            break;

          case M2GCCDeclare_finishedalignment:
            doInclude (GlobalGroup->FinishedAlignment, (const char *) "symbol %d -> FinishedAlignment\\n", 32, sym);
            break;

          case M2GCCDeclare_todolist:
            doInclude (GlobalGroup->ToDoList, (const char *) "symbol %d -> ToDoList\\n", 23, sym);
            break;

          case M2GCCDeclare_niltypedarrays:
            doInclude (GlobalGroup->NilTypedArrays, (const char *) "symbol %d -> NilTypedArrays\\n", 29, sym);
            break;

          case M2GCCDeclare_finishedsetarray:
            doInclude (GlobalGroup->FinishedSetArray, (const char *) "symbol %d -> FinishedSetArray\\n", 31, sym);
            break;


          default:
            M2Error_InternalError ((const char *) "unknown list", 12);
            break;
        }
    }
  else
    {
      switch (lt)
        {
          case M2GCCDeclare_tobesolvedbyquads:
            Sets_IncludeElementIntoSet (GlobalGroup->ToBeSolvedByQuads, sym);
            break;

          case M2GCCDeclare_fullydeclared:
            Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, sym);
            break;

          case M2GCCDeclare_partiallydeclared:
            Sets_IncludeElementIntoSet (GlobalGroup->PartiallyDeclared, sym);
            break;

          case M2GCCDeclare_heldbyalignment:
            Sets_IncludeElementIntoSet (GlobalGroup->HeldByAlignment, sym);
            break;

          case M2GCCDeclare_finishedalignment:
            Sets_IncludeElementIntoSet (GlobalGroup->FinishedAlignment, sym);
            break;

          case M2GCCDeclare_todolist:
            Sets_IncludeElementIntoSet (GlobalGroup->ToDoList, sym);
            break;

          case M2GCCDeclare_niltypedarrays:
            Sets_IncludeElementIntoSet (GlobalGroup->NilTypedArrays, sym);
            break;

          case M2GCCDeclare_finishedsetarray:
            Sets_IncludeElementIntoSet (GlobalGroup->FinishedSetArray, sym);
            break;


          default:
            M2Error_InternalError ((const char *) "unknown list", 12);
            break;
        }
    }
}


/*
   doExclude -
*/

static void doExclude (Sets_Set l, const char *a_, unsigned int _a_high, unsigned int sym)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  if (Sets_IsElementInSet (l, sym))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "rule: ", 6);
      WriteRule ();
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) a, _a_high, (const unsigned char *) &sym, (sizeof (sym)-1));
      Sets_ExcludeElementFromSet (l, sym);
    }
}


/*
   WatchRemoveList - remove a symbol onto the list first checking
                     whether it is already on the list and
                     displaying a debug message if the list is
                     changed.
*/

static void WatchRemoveList (unsigned int sym, M2GCCDeclare_ListType lt)
{
  if (Sets_IsElementInSet (WatchList, sym))
    {
      switch (lt)
        {
          case M2GCCDeclare_tobesolvedbyquads:
            doExclude (GlobalGroup->ToBeSolvedByQuads, (const char *) "symbol %d off ToBeSolvedByQuads\\n", 33, sym);
            break;

          case M2GCCDeclare_fullydeclared:
            doExclude (GlobalGroup->FullyDeclared, (const char *) "symbol %d off FullyDeclared\\n", 29, sym);
            break;

          case M2GCCDeclare_partiallydeclared:
            doExclude (GlobalGroup->PartiallyDeclared, (const char *) "symbol %d off PartiallyDeclared\\n", 33, sym);
            break;

          case M2GCCDeclare_heldbyalignment:
            doExclude (GlobalGroup->HeldByAlignment, (const char *) "symbol %d -> HeldByAlignment\\n", 30, sym);
            break;

          case M2GCCDeclare_finishedalignment:
            doExclude (GlobalGroup->FinishedAlignment, (const char *) "symbol %d -> FinishedAlignment\\n", 32, sym);
            break;

          case M2GCCDeclare_todolist:
            doExclude (GlobalGroup->ToDoList, (const char *) "symbol %d off ToDoList\\n", 24, sym);
            break;

          case M2GCCDeclare_niltypedarrays:
            doExclude (GlobalGroup->NilTypedArrays, (const char *) "symbol %d off NilTypedArrays\\n", 30, sym);
            break;

          case M2GCCDeclare_finishedsetarray:
            doExclude (GlobalGroup->FinishedSetArray, (const char *) "symbol %d off FinishedSetArray\\n", 32, sym);
            break;


          default:
            M2Error_InternalError ((const char *) "unknown list", 12);
            break;
        }
    }
  else
    {
      switch (lt)
        {
          case M2GCCDeclare_tobesolvedbyquads:
            Sets_ExcludeElementFromSet (GlobalGroup->ToBeSolvedByQuads, sym);
            break;

          case M2GCCDeclare_fullydeclared:
            Sets_ExcludeElementFromSet (GlobalGroup->FullyDeclared, sym);
            break;

          case M2GCCDeclare_partiallydeclared:
            Sets_ExcludeElementFromSet (GlobalGroup->PartiallyDeclared, sym);
            break;

          case M2GCCDeclare_heldbyalignment:
            Sets_ExcludeElementFromSet (GlobalGroup->HeldByAlignment, sym);
            break;

          case M2GCCDeclare_finishedalignment:
            Sets_ExcludeElementFromSet (GlobalGroup->FinishedAlignment, sym);
            break;

          case M2GCCDeclare_todolist:
            Sets_ExcludeElementFromSet (GlobalGroup->ToDoList, sym);
            break;

          case M2GCCDeclare_niltypedarrays:
            Sets_ExcludeElementFromSet (GlobalGroup->NilTypedArrays, sym);
            break;

          case M2GCCDeclare_finishedsetarray:
            Sets_ExcludeElementFromSet (GlobalGroup->FinishedSetArray, sym);
            break;


          default:
            M2Error_InternalError ((const char *) "unknown list", 12);
            break;
        }
    }
}


/*
   NewGroup -
*/

static void NewGroup (M2GCCDeclare_Group *g)
{
  if (FreeGroup == NULL)
    {
      Storage_ALLOCATE ((void **) &(*g), sizeof (M2GCCDeclare__T1));
    }
  else
    {
      (*g) = FreeGroup;
      FreeGroup = FreeGroup->Next;
    }
}


/*
   DisposeGroup -
*/

static void DisposeGroup (M2GCCDeclare_Group *g)
{
  (*g)->Next = FreeGroup;
  FreeGroup = (*g);
  (*g) = NULL;
}


/*
   InitGroup - initialize all sets in group and return the group.
*/

static M2GCCDeclare_Group InitGroup (void)
{
  M2GCCDeclare_Group g;

  NewGroup (&g);
  /* Initialize all sets in group.  */
  g->FinishedSetArray = Sets_InitSet (1);
  g->ToDoList = Sets_InitSet (1);
  g->FullyDeclared = Sets_InitSet (1);
  g->PartiallyDeclared = Sets_InitSet (1);
  g->NilTypedArrays = Sets_InitSet (1);
  g->HeldByAlignment = Sets_InitSet (1);
  g->FinishedAlignment = Sets_InitSet (1);
  g->ToBeSolvedByQuads = Sets_InitSet (1);
  g->Next = NULL;
  return g;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillGroup - delete all sets in group and deallocate g.
*/

static void KillGroup (M2GCCDeclare_Group *g)
{
  /* Delete all sets in group.  */
  if ((*g) != NULL)
    {
      (*g)->FinishedSetArray = Sets_KillSet ((*g)->FinishedSetArray);
      (*g)->ToDoList = Sets_KillSet ((*g)->ToDoList);
      (*g)->FullyDeclared = Sets_KillSet ((*g)->FullyDeclared);
      (*g)->PartiallyDeclared = Sets_KillSet ((*g)->PartiallyDeclared);
      (*g)->NilTypedArrays = Sets_KillSet ((*g)->NilTypedArrays);
      (*g)->HeldByAlignment = Sets_KillSet ((*g)->HeldByAlignment);
      (*g)->FinishedAlignment = Sets_KillSet ((*g)->FinishedAlignment);
      (*g)->ToBeSolvedByQuads = Sets_KillSet ((*g)->ToBeSolvedByQuads);
      (*g)->Next = NULL;
      DisposeGroup (g);
    }
}


/*
   DupGroup - If g is not NIL then destroy g.
              Return a duplicate of GlobalGroup.
*/

static M2GCCDeclare_Group DupGroup (M2GCCDeclare_Group g)
{
  if (g != NULL)
    {
      /* Kill old group.  */
      KillGroup (&g);
    }
  NewGroup (&g);
  /* Copy all sets.  */
  g->FinishedSetArray = Sets_DuplicateSet (GlobalGroup->FinishedSetArray);
  g->ToDoList = Sets_DuplicateSet (GlobalGroup->ToDoList);
  g->FullyDeclared = Sets_DuplicateSet (GlobalGroup->FullyDeclared);
  g->PartiallyDeclared = Sets_DuplicateSet (GlobalGroup->PartiallyDeclared);
  g->NilTypedArrays = Sets_DuplicateSet (GlobalGroup->NilTypedArrays);
  g->HeldByAlignment = Sets_DuplicateSet (GlobalGroup->HeldByAlignment);
  g->FinishedAlignment = Sets_DuplicateSet (GlobalGroup->FinishedAlignment);
  g->ToBeSolvedByQuads = Sets_DuplicateSet (GlobalGroup->ToBeSolvedByQuads);
  g->Next = NULL;
  return g;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   EqualGroup - return TRUE if group left = right.
*/

static bool EqualGroup (M2GCCDeclare_Group left, M2GCCDeclare_Group right)
{
  return (left == right) || ((((((((Sets_EqualSet (left->FullyDeclared, right->FullyDeclared)) && (Sets_EqualSet (left->PartiallyDeclared, right->PartiallyDeclared))) && (Sets_EqualSet (left->NilTypedArrays, right->NilTypedArrays))) && (Sets_EqualSet (left->HeldByAlignment, right->HeldByAlignment))) && (Sets_EqualSet (left->FinishedAlignment, right->FinishedAlignment))) && (Sets_EqualSet (left->ToDoList, right->ToDoList))) && (Sets_EqualSet (left->ToBeSolvedByQuads, right->ToBeSolvedByQuads))) && (Sets_EqualSet (left->FinishedSetArray, right->FinishedSetArray)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   LookupSet -
*/

static Sets_Set LookupSet (M2GCCDeclare_ListType listtype)
{
  switch (listtype)
    {
      case M2GCCDeclare_fullydeclared:
        return GlobalGroup->FullyDeclared;
        break;

      case M2GCCDeclare_partiallydeclared:
        return GlobalGroup->PartiallyDeclared;
        break;

      case M2GCCDeclare_niltypedarrays:
        return GlobalGroup->NilTypedArrays;
        break;

      case M2GCCDeclare_heldbyalignment:
        return GlobalGroup->HeldByAlignment;
        break;

      case M2GCCDeclare_finishedalignment:
        return GlobalGroup->FinishedAlignment;
        break;

      case M2GCCDeclare_todolist:
        return GlobalGroup->ToDoList;
        break;

      case M2GCCDeclare_tobesolvedbyquads:
        return GlobalGroup->ToBeSolvedByQuads;
        break;

      case M2GCCDeclare_finishedsetarray:
        return GlobalGroup->FinishedSetArray;
        break;


      default:
        M2Error_InternalError ((const char *) "unknown ListType", 16);
        break;
    }
  return static_cast<Sets_Set> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetEnumList -
*/

static tree GetEnumList (unsigned int sym)
{
  if (Indexing_InBounds (EnumerationIndex, sym))
    {
      return (tree) (Indexing_GetIndice (EnumerationIndex, sym));
    }
  else
    {
      return NULL;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutEnumList -
*/

static void PutEnumList (unsigned int sym, tree enumlist)
{
  Indexing_PutIndice (EnumerationIndex, sym, enumlist);
}


/*
   Chained - checks to see that, sym, has not already been placed on a chain.
             It returns the symbol, sym.
*/

static unsigned int Chained (unsigned int sym)
{
  if (Sets_IsElementInSet (ChainedList, sym))
    {
      M2Error_InternalError ((const char *) "symbol has already been chained onto a previous list", 52);
    }
  Sets_IncludeElementIntoSet (ChainedList, sym);
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoStartDeclaration - returns a tree representing a symbol which has
                        not yet been finished.  Used when declaring
                        recursive types.
*/

static tree DoStartDeclaration (unsigned int sym, M2GCCDeclare_StartProcedure p)
{
  location_t location;

  if (! (SymbolConversion_GccKnowsAbout (sym)))
    {
      location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
      PreAddModGcc (sym, (tree) ((*p.proc) (location, NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (sym)))));
    }
  return SymbolConversion_Mod2Gcc (sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ArrayComponentsDeclared - returns TRUE if array, sym,
                             subscripts and type are known.
*/

static bool ArrayComponentsDeclared (unsigned int sym)
{
  unsigned int Subscript;
  unsigned int Type;
  unsigned int High;
  unsigned int Low;

  Subscript = SymbolTable_GetArraySubscript (sym);
  M2Debug_Assert (SymbolTable_IsSubscript (Subscript));
  Type = SymbolTable_GetDType (Subscript);
  Low = M2GCCDeclare_GetTypeMin (Type);
  High = M2GCCDeclare_GetTypeMax (Type);
  return ((IsFullyDeclared (Type)) && (IsFullyDeclared (Low))) && (IsFullyDeclared (High));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetRecordOfVarient -
*/

static unsigned int GetRecordOfVarient (unsigned int sym)
{
  if ((SymbolTable_IsVarient (sym)) || (SymbolTable_IsFieldVarient (sym)))
    {
      do {
        sym = SymbolTable_GetParent (sym);
      } while (! (SymbolTable_IsRecord (sym)));
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CanDeclareRecordKind -
*/

static bool CanDeclareRecordKind (unsigned int sym)
{
  sym = GetRecordOfVarient (sym);
  return (SymbolTable_IsRecord (sym)) && (((SymbolTable_GetDefaultRecordFieldAlignment (sym)) == SymbolTable_NulSym) || (IsFullyDeclared (SymbolTable_GetDefaultRecordFieldAlignment (sym))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareRecordKind - works out whether record, sym, is packed or not.
*/

static void DeclareRecordKind (unsigned int sym)
{
  if (SymbolTable_IsRecord (sym))
    {
      DetermineIfRecordPacked (sym);
    }
  WatchIncludeList (sym, M2GCCDeclare_todolist);
  WatchRemoveList (sym, M2GCCDeclare_heldbyalignment);
  WatchIncludeList (sym, M2GCCDeclare_finishedalignment);
  if (AllDependantsFullyDeclared (sym))
    {}  /* empty.  */
  /* All good and ready to be solved.  */
}


/*
   CanDeclareRecord -
*/

static bool CanDeclareRecord (unsigned int sym)
{
  TraverseDependants (sym);
  if (AllDependantsFullyDeclared (sym))
    {
      return true;
    }
  else
    {
      WatchIncludeList (sym, M2GCCDeclare_finishedalignment);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FinishDeclareRecord -
*/

static void FinishDeclareRecord (unsigned int sym)
{
  DeclareTypeConstFully (sym);
  WatchRemoveList (sym, M2GCCDeclare_heldbyalignment);
  WatchRemoveList (sym, M2GCCDeclare_finishedalignment);
  WatchRemoveList (sym, M2GCCDeclare_todolist);
  WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
}


/*
   CanDeclareTypePartially - return TRUE if we are able to make a
                             gcc partially created type.
*/

static bool CanDeclareTypePartially (unsigned int sym)
{
  unsigned int type;

  if (Sets_IsElementInSet (GlobalGroup->PartiallyDeclared, sym))
    {
      return false;
    }
  else if ((((SymbolTable_IsProcType (sym)) || (SymbolTable_IsRecord (sym))) || (SymbolTable_IsVarient (sym))) || (SymbolTable_IsFieldVarient (sym)))
    {
      /* avoid dangling else.  */
      return true;
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      type = SymbolTable_GetSType (sym);
      if ((type != SymbolTable_NulSym) && (IsNilTypedArrays (type)))
        {
          return true;
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareTypePartially - create the gcc partial type symbol from, sym.
*/

static void DeclareTypePartially (unsigned int sym)
{
  location_t location;

  /* check to see if we have already partially declared the symbol  */
  if (! (Sets_IsElementInSet (GlobalGroup->PartiallyDeclared, sym)))
    {
      if (SymbolTable_IsRecord (sym))
        {
          M2Debug_Assert (! (Sets_IsElementInSet (GlobalGroup->HeldByAlignment, sym)));
          M2Debug_Assert ((DoStartDeclaration (sym, (M2GCCDeclare_StartProcedure) {(M2GCCDeclare_StartProcedure_t) m2type_BuildStartRecord})) != NULL);
          WatchIncludeList (sym, M2GCCDeclare_heldbyalignment);
        }
      else if (SymbolTable_IsVarient (sym))
        {
          /* avoid dangling else.  */
          M2Debug_Assert (! (Sets_IsElementInSet (GlobalGroup->HeldByAlignment, sym)));
          M2Debug_Assert ((DoStartDeclaration (sym, (M2GCCDeclare_StartProcedure) {(M2GCCDeclare_StartProcedure_t) m2type_BuildStartVarient})) != NULL);
          WatchIncludeList (sym, M2GCCDeclare_heldbyalignment);
        }
      else if (SymbolTable_IsFieldVarient (sym))
        {
          /* avoid dangling else.  */
          M2Debug_Assert (! (Sets_IsElementInSet (GlobalGroup->HeldByAlignment, sym)));
          M2Debug_Assert ((DoStartDeclaration (sym, (M2GCCDeclare_StartProcedure) {(M2GCCDeclare_StartProcedure_t) m2type_BuildStartFieldVarient})) != NULL);
          WatchIncludeList (sym, M2GCCDeclare_heldbyalignment);
        }
      else if (SymbolTable_IsProcType (sym))
        {
          /* avoid dangling else.  */
          M2Debug_Assert ((DoStartDeclaration (sym, (M2GCCDeclare_StartProcedure) {(M2GCCDeclare_StartProcedure_t) m2type_BuildStartFunctionType})) != NULL);
        }
      else if (SymbolTable_IsType (sym))
        {
          /* avoid dangling else.  */
          if (! (SymbolConversion_GccKnowsAbout (sym)))
            {
              location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
              PreAddModGcc (sym, m2type_BuildStartType (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (sym))), SymbolConversion_Mod2Gcc (SymbolTable_GetSType (sym))));
            }
        }
      else
        {
          /* avoid dangling else.  */
          M2Error_InternalError ((const char *) "do not know how to create a partial type from this symbol", 57);
        }
      WatchIncludeList (sym, M2GCCDeclare_partiallydeclared);
      TraverseDependants (sym);
    }
}


/*
   CanDeclareArrayAsNil -
*/

static bool CanDeclareArrayAsNil (unsigned int sym)
{
  return (SymbolTable_IsArray (sym)) && (ArrayComponentsDeclared (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareArrayAsNil -
*/

static void DeclareArrayAsNil (unsigned int sym)
{
  PreAddModGcc (sym, m2type_BuildStartArrayType (BuildIndex (SymbolTable_GetDeclaredMod (sym), sym), NULL, static_cast<int> (SymbolTable_GetDType (sym))));
  WatchIncludeList (sym, M2GCCDeclare_niltypedarrays);
}


/*
   CanDeclareArrayPartially -
*/

static bool CanDeclareArrayPartially (unsigned int sym)
{
  unsigned int type;

  if (SymbolTable_IsArray (sym))
    {
      type = SymbolTable_GetSType (sym);
      if ((IsPartiallyOrFullyDeclared (type)) || ((SymbolTable_IsPointer (type)) && (IsNilTypedArrays (type))))
        {
          return true;
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareArrayPartially -
*/

static void DeclareArrayPartially (unsigned int sym)
{
  M2Debug_Assert ((SymbolTable_IsArray (sym)) && (SymbolConversion_GccKnowsAbout (sym)));
  m2type_PutArrayType (SymbolConversion_Mod2Gcc (sym), SymbolConversion_Mod2Gcc (SymbolTable_GetSType (sym)));
  WatchIncludeList (sym, M2GCCDeclare_partiallydeclared);
}


/*
   CanDeclarePointerToNilArray -
*/

static bool CanDeclarePointerToNilArray (unsigned int sym)
{
  return (SymbolTable_IsPointer (sym)) && (IsNilTypedArrays (SymbolTable_GetSType (sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclarePointerToNilArray -
*/

static void DeclarePointerToNilArray (unsigned int sym)
{
  PreAddModGcc (sym, m2type_BuildPointerType (SymbolConversion_Mod2Gcc (SymbolTable_GetSType (sym))));
  WatchIncludeList (sym, M2GCCDeclare_niltypedarrays);
}


/*
   CanPromotePointerFully -
*/

static bool CanPromotePointerFully (unsigned int sym)
{
  return (SymbolTable_IsPointer (sym)) && (IsPartiallyOrFullyDeclared (SymbolTable_GetSType (sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PromotePointerFully -
*/

static void PromotePointerFully (unsigned int sym)
{
  WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
}


/*
   IsTypeQ - returns TRUE if all q(dependants) of, sym,
             return TRUE.
*/

static bool IsTypeQ (unsigned int sym, M2GCCDeclare_IsAction q)
{
  if (SymbolTable_IsVar (sym))
    {
      return IsVarDependants (sym, q);
    }
  else if (SymbolTable_IsEnumeration (sym))
    {
      /* avoid dangling else.  */
      return IsEnumerationDependants (sym, q);
    }
  else if (SymbolTable_IsFieldEnumeration (sym))
    {
      /* avoid dangling else.  */
      return true;
    }
  else if (SymbolTable_IsSubrange (sym))
    {
      /* avoid dangling else.  */
      return IsSubrangeDependants (sym, q);
    }
  else if (SymbolTable_IsPointer (sym))
    {
      /* avoid dangling else.  */
      return IsPointerDependants (sym, q);
    }
  else if (SymbolTable_IsRecord (sym))
    {
      /* avoid dangling else.  */
      return IsRecordDependants (sym, q);
    }
  else if (SymbolTable_IsRecordField (sym))
    {
      /* avoid dangling else.  */
      return IsRecordFieldDependants (sym, q);
    }
  else if (SymbolTable_IsVarient (sym))
    {
      /* avoid dangling else.  */
      return IsVarientDependants (sym, q);
    }
  else if (SymbolTable_IsFieldVarient (sym))
    {
      /* avoid dangling else.  */
      return IsVarientFieldDependants (sym, q);
    }
  else if (SymbolTable_IsArray (sym))
    {
      /* avoid dangling else.  */
      return IsArrayDependants (sym, q);
    }
  else if (SymbolTable_IsProcType (sym))
    {
      /* avoid dangling else.  */
      return IsProcTypeDependants (sym, q);
    }
  else if (SymbolTable_IsUnbounded (sym))
    {
      /* avoid dangling else.  */
      return IsUnboundedDependants (sym, q);
    }
  else if (SymbolTable_IsPartialUnbounded (sym))
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "should not be declaring a partial unbounded symbol", 50);
    }
  else if (SymbolTable_IsSet (sym))
    {
      /* avoid dangling else.  */
      return IsSetDependants (sym, q);
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      return IsTypeDependants (sym, q);
    }
  else if (SymbolTable_IsConst (sym))
    {
      /* avoid dangling else.  */
      return IsConstDependants (sym, q);
    }
  else if ((SymbolTable_IsConstructor (sym)) || (SymbolTable_IsConstSet (sym)))
    {
      /* avoid dangling else.  */
      /* sym can be a constructor, but at present we have not resolved whether
         all dependants are constants.
  */
      return M2ALU_IsConstructorDependants (sym, q);
    }
  else if (SymbolTable_IsProcedure (sym))
    {
      /* avoid dangling else.  */
      return IsProcedureDependants (sym, q);
    }
  else
    {
      /* avoid dangling else.  */
      return true;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2GCCDeclare.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsNilTypedArrays - returns TRUE if, sym, is dependant upon a NIL typed array
*/

static bool IsNilTypedArrays (unsigned int sym)
{
  return Sets_IsElementInSet (GlobalGroup->NilTypedArrays, sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsFullyDeclared - returns TRUE if, sym, is fully declared.
*/

static bool IsFullyDeclared (unsigned int sym)
{
  return Sets_IsElementInSet (GlobalGroup->FullyDeclared, sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AllDependantsFullyDeclared - returns TRUE if all dependants of,
                                sym, are declared.
*/

static bool AllDependantsFullyDeclared (unsigned int sym)
{
  return IsTypeQ (sym, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) IsFullyDeclared});
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NotAllDependantsFullyDeclared - returns TRUE if any dependants of,
                                   sym, are not declared.
*/

static bool NotAllDependantsFullyDeclared (unsigned int sym)
{
  return ! (IsTypeQ (sym, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) IsFullyDeclared}));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPartiallyDeclared - returns TRUE if, sym, is partially declared.
*/

static bool IsPartiallyDeclared (unsigned int sym)
{
  return Sets_IsElementInSet (GlobalGroup->PartiallyDeclared, sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AllDependantsPartiallyDeclared - returns TRUE if all dependants of,
                                    sym, are partially declared.
*/

static bool AllDependantsPartiallyDeclared (unsigned int sym)
{
  return IsTypeQ (sym, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) IsPartiallyDeclared});
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NotAllDependantsPartiallyDeclared - returns TRUE if any dependants of,
                                       sym, are not partially declared.
*/

static bool NotAllDependantsPartiallyDeclared (unsigned int sym)
{
  return ! (IsTypeQ (sym, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) IsPartiallyDeclared}));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPartiallyOrFullyDeclared - returns TRUE if, sym, is partially or fully declared.
*/

static bool IsPartiallyOrFullyDeclared (unsigned int sym)
{
  return (Sets_IsElementInSet (GlobalGroup->PartiallyDeclared, sym)) || (Sets_IsElementInSet (GlobalGroup->FullyDeclared, sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AllDependantsPartiallyOrFullyDeclared - returns TRUE if all dependants of,
                                           sym, are partially or fully declared.
*/

static bool AllDependantsPartiallyOrFullyDeclared (unsigned int sym)
{
  return IsTypeQ (sym, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) IsPartiallyOrFullyDeclared});
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TypeConstDependantsFullyDeclared - returns TRUE if sym is a constant or
                                      type and its dependants are fully
                                      declared.
*/

static bool TypeConstDependantsFullyDeclared (unsigned int sym)
{
  return (((! (SymbolTable_IsVar (sym))) && (! (SymbolTable_IsRecord (sym)))) && (! (SymbolTable_IsParameter (sym)))) && (AllDependantsFullyDeclared (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CanBeDeclaredViaPartialDependants - returns TRUE if this symbol
                                       can be declared by partial
                                       dependants.  Such a symbol must
                                       be a record, proctype or
                                       an array.
*/

static bool CanBeDeclaredViaPartialDependants (unsigned int sym)
{
  return ((SymbolTable_IsPointer (sym)) || (SymbolTable_IsProcType (sym))) && (AllDependantsPartiallyOrFullyDeclared (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareConstFully - will add, sym, to the fully declared list and
                       also remove it from the to do list.  This is
                       called indirectly from M2GenGCC as it calculates
                       constants during quadruple processing.
*/

static void DeclareConstFully (unsigned int sym)
{
  WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
  WatchRemoveList (sym, M2GCCDeclare_todolist);
  WatchRemoveList (sym, M2GCCDeclare_partiallydeclared);
  WatchRemoveList (sym, M2GCCDeclare_tobesolvedbyquads);
}


/*
   DeclareTypeConstFully - declare the GCC type and add the double
                           book keeping entry.
*/

static void DeclareTypeConstFully (unsigned int sym)
{
  tree t;

  if (! (Sets_IsElementInSet (GlobalGroup->ToBeSolvedByQuads, sym)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)))
        {
          WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
          WatchRemoveList (sym, M2GCCDeclare_partiallydeclared);
          WatchRemoveList (sym, M2GCCDeclare_todolist);
        }
      else if (SymbolTable_IsProcedure (sym))
        {
          /* avoid dangling else.  */
          DeclareProcedureToGcc (sym);
          WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
          WatchRemoveList (sym, M2GCCDeclare_partiallydeclared);
          WatchRemoveList (sym, M2GCCDeclare_todolist);
        }
      else
        {
          /* avoid dangling else.  */
          t = TypeConstFullyDeclared (sym);
          if (t != NULL)
            {
              /* add relationship between gccsym and sym  */
              PreAddModGcc (sym, t);
              WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
              WatchRemoveList (sym, M2GCCDeclare_partiallydeclared);
              WatchRemoveList (sym, M2GCCDeclare_heldbyalignment);
              WatchRemoveList (sym, M2GCCDeclare_finishedalignment);
              WatchRemoveList (sym, M2GCCDeclare_todolist);
            }
        }
    }
}


/*
   DeclareTypeFromPartial - declare the full GCC type from a partial type
                            and add the double book keeping entry.
*/

static void DeclareTypeFromPartial (unsigned int sym)
{
  tree t;

  t = CompleteDeclarationOf (sym);
  if (t == NULL)
    {
      M2Error_InternalError ((const char *) "expecting to be able to create a gcc type", 41);
    }
  else
    {
      SymbolConversion_AddModGcc (sym, t);
      WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
      WatchRemoveList (sym, M2GCCDeclare_partiallydeclared);
    }
}


/*
   CanBeDeclaredPartiallyViaPartialDependants - returns TRUE if, sym,
                                                can be partially declared via
                                                another partially declared type.
*/

static bool CanBeDeclaredPartiallyViaPartialDependants (unsigned int sym)
{
  return (SymbolTable_IsType (sym)) && (AllDependantsPartiallyDeclared (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   EmitCircularDependencyError - issue a dependency error.
*/

static void EmitCircularDependencyError (unsigned int sym)
{
  /* Ensure we only issue one dependency message per symbol for this
      error classification.  */
  if (! (Sets_IsElementInSet (ErrorDepList, sym)))
    {
      Sets_IncludeElementIntoSet (ErrorDepList, sym);
      if ((SymbolTable_IsVar (sym)) || (SymbolTable_IsParameter (sym)))
        {
          M2MetaError_MetaError1 ((const char *) "circular dependency error found when trying to resolve {%1Had}", 62, sym);
        }
      else
        {
          M2MetaError_MetaError1 ((const char *) "circular dependency error found when trying to resolve {%1Dad}", 62, sym);
        }
    }
}


/*
   WriteRule - writes out the name of the rule.
*/

static void WriteRule (void)
{
  if (Debugging)
    {
      switch (bodyr)
        {
          case M2GCCDeclare_norule:
            M2Printf_printf0 ((const char *) "norule", 6);
            break;

          case M2GCCDeclare_partialtype:
            M2Printf_printf0 ((const char *) "partialtype", 11);
            break;

          case M2GCCDeclare_arraynil:
            M2Printf_printf0 ((const char *) "arraynil", 8);
            break;

          case M2GCCDeclare_pointernilarray:
            M2Printf_printf0 ((const char *) "pointernilarray", 15);
            break;

          case M2GCCDeclare_arraypartial:
            M2Printf_printf0 ((const char *) "arraypartial", 12);
            break;

          case M2GCCDeclare_pointerfully:
            M2Printf_printf0 ((const char *) "pointerfully", 12);
            break;

          case M2GCCDeclare_recordkind:
            M2Printf_printf0 ((const char *) "recordkind", 10);
            break;

          case M2GCCDeclare_recordfully:
            M2Printf_printf0 ((const char *) "recordfully", 11);
            break;

          case M2GCCDeclare_typeconstfully:
            M2Printf_printf0 ((const char *) "typeconstfully", 14);
            break;

          case M2GCCDeclare_pointerfrompartial:
            M2Printf_printf0 ((const char *) "pointerfrompartial", 18);
            break;

          case M2GCCDeclare_typefrompartial:
            M2Printf_printf0 ((const char *) "typefrompartial", 15);
            break;

          case M2GCCDeclare_partialfrompartial:
            M2Printf_printf0 ((const char *) "partialfrompartial", 18);
            break;

          case M2GCCDeclare_partialtofully:
            M2Printf_printf0 ((const char *) "partialtofully", 14);
            break;

          case M2GCCDeclare_circulartodo:
            M2Printf_printf0 ((const char *) "circulartodo", 12);
            break;

          case M2GCCDeclare_circularpartial:
            M2Printf_printf0 ((const char *) "circularpartial", 15);
            break;

          case M2GCCDeclare_circularniltyped:
            M2Printf_printf0 ((const char *) "circularniltyped", 16);
            break;


          default:
            M2Error_InternalError ((const char *) "unknown rule", 12);
            break;
        }
    }
}


/*
   Body -
*/

static void Body (unsigned int sym)
{
  if ((*bodyq.proc) (sym))
    {
      WatchRemoveList (sym, bodyt);
      (*bodyp.proc) (sym);
      /* The bodyp (sym) procedure function might have replaced sym into the set.  */
      if (! (Sets_IsElementInSet (LookupSet (bodyt), sym)))
        {
          noMoreWritten = false;
          oneResolved = true;
        }
    }
}


/*
   ForeachTryDeclare - while q (of one sym in set t) is true
                          for each symbol in set t,
                             if q (sym)
                             then
                                p (sym)
                             end
                          end
                       end
*/

static bool ForeachTryDeclare (M2GCCDeclare_ListType t, M2GCCDeclare_Rule r, M2GCCDeclare_IsAction q, M2GCCDeclare_WalkAction p)
{
  if (recursionCaught)
    {
      M2Error_InternalError ((const char *) "caught recursive cycle in ForeachTryDeclare", 43);
    }
  bodyt = t;
  bodyq = q;
  bodyp = p;
  bodyr = r;
  recursionCaught = true;
  oneResolved = false;
  do {
    noMoreWritten = true;
    Sets_ForeachElementInSetDo (LookupSet (t), (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) Body});
  } while (! (noMoreWritten));
  bodyr = M2GCCDeclare_norule;
  recursionCaught = false;
  return oneResolved;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

static bool DeclaredOutstandingTypes (bool ForceComplete)
{
  bool finished;
  M2GCCDeclare_Group copy;

  /* 
   DeclaredOutandingTypes - writes out any types that have their
                            dependants solved.  It returns TRUE if
                            all outstanding types have been written.
  */
  copy = NULL;
  finished = false;
  do {
    if (Progress && (copy != NULL))
      {
        if (! (EqualGroup (copy, GlobalGroup)))
          {
            DebugSetNumbers ();
            DebugSets ();
          }
      }
    copy = DupGroup (copy);
    if (ForeachTryDeclare (M2GCCDeclare_todolist, M2GCCDeclare_partialtype, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) CanDeclareTypePartially}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclareTypePartially}))
      {}  /* empty.  */
    /* Continue looping.  */
    else if (ForeachTryDeclare (M2GCCDeclare_todolist, M2GCCDeclare_arraynil, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) CanDeclareArrayAsNil}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclareArrayAsNil}))
      {
        /* avoid dangling else.  */
      }
    else if (ForeachTryDeclare (M2GCCDeclare_todolist, M2GCCDeclare_pointernilarray, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) CanDeclarePointerToNilArray}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclarePointerToNilArray}))
      {
        /* avoid dangling else.  */
      }
    else if (ForeachTryDeclare (M2GCCDeclare_niltypedarrays, M2GCCDeclare_arraypartial, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) CanDeclareArrayPartially}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclareArrayPartially}))
      {
        /* avoid dangling else.  */
      }
    else if (ForeachTryDeclare (M2GCCDeclare_niltypedarrays, M2GCCDeclare_pointerfully, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) CanPromotePointerFully}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) PromotePointerFully}))
      {
        /* avoid dangling else.  */
      }
    else if (ForeachTryDeclare (M2GCCDeclare_heldbyalignment, M2GCCDeclare_recordkind, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) CanDeclareRecordKind}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclareRecordKind}))
      {
        /* avoid dangling else.  */
      }
    else if (ForeachTryDeclare (M2GCCDeclare_finishedalignment, M2GCCDeclare_recordfully, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) CanDeclareRecord}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) FinishDeclareRecord}))
      {
        /* avoid dangling else.  */
      }
    else if (ForeachTryDeclare (M2GCCDeclare_todolist, M2GCCDeclare_typeconstfully, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) TypeConstDependantsFullyDeclared}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclareTypeConstFully}))
      {
        /* avoid dangling else.  */
      }
    else if (ForeachTryDeclare (M2GCCDeclare_todolist, M2GCCDeclare_typefrompartial, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) CanBeDeclaredViaPartialDependants}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclareTypeFromPartial}))
      {
        /* avoid dangling else.  */
      }
    else if (ForeachTryDeclare (M2GCCDeclare_partiallydeclared, M2GCCDeclare_partialfrompartial, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) CanBeDeclaredPartiallyViaPartialDependants}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclareTypePartially}))
      {
        /* avoid dangling else.  */
      }
    else if (ForeachTryDeclare (M2GCCDeclare_partiallydeclared, M2GCCDeclare_partialtofully, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) TypeConstDependantsFullyDeclared}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclareTypeConstFully}))
      {
        /* avoid dangling else.  */
      }
    else
      {
        /* avoid dangling else.  */
        /* Nothing left to do (and constants are resolved elsewhere).  */
        finished = true;
      }
  } while (! (finished));
  KillGroup (&copy);
  if (ForceComplete)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (ForeachTryDeclare (M2GCCDeclare_todolist, M2GCCDeclare_circulartodo, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) NotAllDependantsFullyDeclared}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) EmitCircularDependencyError}))
        {}  /* empty.  */
      else if (ForeachTryDeclare (M2GCCDeclare_partiallydeclared, M2GCCDeclare_circularpartial, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) NotAllDependantsPartiallyDeclared}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) EmitCircularDependencyError}))
        {
          /* avoid dangling else.  */
        }
      else if (ForeachTryDeclare (M2GCCDeclare_niltypedarrays, M2GCCDeclare_circularniltyped, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) NotAllDependantsPartiallyDeclared}, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) EmitCircularDependencyError}))
        {
          /* avoid dangling else.  */
        }
    }
  return (Sets_NoOfElementsInSet (GlobalGroup->ToDoList)) == 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CompleteDeclarationOf - returns the GCC Tree for, sym, if it can
                           be created from partially or fully declared
                           dependents.
*/

static tree CompleteDeclarationOf (unsigned int sym)
{
  if (SymbolTable_IsArray (sym))
    {
      return DeclareArray (sym);
    }
  else if (SymbolTable_IsProcType (sym))
    {
      /* avoid dangling else.  */
      return DeclareProcType (sym);
    }
  else if (SymbolTable_IsRecordField (sym))
    {
      /* avoid dangling else.  */
      return DeclareRecordField (sym);
    }
  else if (SymbolTable_IsPointer (sym))
    {
      /* avoid dangling else.  */
      return DeclarePointer (sym);
    }
  else
    {
      /* avoid dangling else.  */
      return NULL;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareType - here a type has been created via TYPE foo = bar,
                 we must tell GCC about it.
*/

static tree DeclareType (unsigned int sym)
{
  tree t;
  location_t location;

  if ((SymbolTable_GetSType (sym)) == SymbolTable_NulSym)
    {
      M2MetaError_MetaError1 ((const char *) "base type {%1Ua} not understood", 31, sym);
      M2Error_InternalError ((const char *) "base type should have been declared", 35);
    }
  else
    {
      if ((SymbolTable_GetSymName (sym)) == NameKey_NulName)
        {
          return (tree) (SymbolConversion_Mod2Gcc (SymbolTable_GetSType (sym)));
        }
      else
        {
          location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
          if (SymbolConversion_GccKnowsAbout (sym))
            {
              t = SymbolConversion_Mod2Gcc (sym);
            }
          else
            {
              /* not partially declared therefore start it  */
              t = m2type_BuildStartType (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (sym))), SymbolConversion_Mod2Gcc (SymbolTable_GetSType (sym)));
            }
          t = m2type_BuildEndType (location, t);  /* now finish it  */
          return t;  /* now finish it  */
        }
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2GCCDeclare.def", 20, 1);
  __builtin_unreachable ();
}

static void DeclareConstantFromTree (unsigned int sym, tree value)
{
  /* 
   DeclareIntegerFromTree - declares an integer constant from a Tree, value.
  */
  PreAddModGcc (sym, value);
  WatchRemoveList (sym, M2GCCDeclare_todolist);
  WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
}


/*
   DeclareCharConstant - declares a character constant.
*/

static void DeclareCharConstant (unsigned int tokenno, unsigned int sym)
{
  location_t location;

  M2Debug_Assert (SymbolTable_IsConstStringKnown (sym));
  location = M2LexBuf_TokenToLocation (tokenno);
  PreAddModGcc (sym, m2type_BuildCharConstant (location, const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetString (sym))))));
  WatchRemoveList (sym, M2GCCDeclare_todolist);
  WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
}


/*
   DeclareStringConstant - declares a string constant the sym will be known.
*/

static void DeclareStringConstant (unsigned int tokenno, unsigned int sym)
{
  tree symtree;

  M2Debug_Assert (SymbolTable_IsConstStringKnown (sym));
  if ((SymbolTable_IsConstStringM2nul (sym)) || (SymbolTable_IsConstStringCnul (sym)))
    {
      /* in either case the string needs a nul terminator.  If the string
         is a C variant it will already have had any escape characters applied.
         The BuildCStringConstant only adds the nul terminator.  */
      symtree = m2decl_BuildCStringConstant (const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetString (sym)))), static_cast<int> (SymbolTable_GetStringLength (tokenno, sym)));
    }
  else
    {
      symtree = m2decl_BuildStringConstant (const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetString (sym)))), static_cast<int> (SymbolTable_GetStringLength (tokenno, sym)));
    }
  PreAddModGcc (sym, symtree);
  WatchRemoveList (sym, M2GCCDeclare_todolist);
  WatchIncludeList (sym, M2GCCDeclare_fullydeclared);
}


/*
   WalkConstructor - walks all dependants of, sym.
*/

static void WalkConstructor (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int type;

  type = SymbolTable_GetSType (sym);
  if (type != SymbolTable_NulSym)
    {
      WalkDependants (type, p);
      M2ALU_WalkConstructorDependants (sym, p);
    }
}


/*
   WalkConst - walks all dependants of, sym.
*/

static void WalkConst (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int type;

  M2Debug_Assert (SymbolTable_IsConst (sym));
  type = SymbolTable_GetSType (sym);
  if (type != SymbolTable_NulSym)
    {
      (*p.proc) (type);
    }
  if ((SymbolTable_IsConstSet (sym)) || (SymbolTable_IsConstructor (sym)))
    {
      WalkConstructor (sym, p);
    }
}


/*
   IsConstDependants - returns TRUE if the symbol, sym,
                       q(dependants) all return TRUE.
*/

static bool IsConstDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int type;

  M2Debug_Assert (SymbolTable_IsConst (sym));
  type = SymbolTable_GetSType (sym);
  if (type != SymbolTable_NulSym)
    {
      if (! ((*q.proc) (type)))
        {
          return false;
        }
    }
  if ((SymbolTable_IsConstSet (sym)) || (SymbolTable_IsConstructor (sym)))
    {
      return M2ALU_IsConstructorDependants (sym, q);
    }
  return SymbolTable_IsValueSolved (sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsAnyType - return TRUE if sym is any Modula-2 type.
*/

static bool IsAnyType (unsigned int sym)
{
  return (((((((SymbolTable_IsRecord (sym)) || (SymbolTable_IsType (sym))) || (SymbolTable_IsRecordField (sym))) || (SymbolTable_IsPointer (sym))) || (SymbolTable_IsArray (sym))) || (SymbolTable_IsSet (sym))) || (SymbolTable_IsEnumeration (sym))) || (SymbolTable_IsPointer (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareConstString -
*/

static bool DeclareConstString (unsigned int tokenno, unsigned int sym)
{
  unsigned int size;

  if (SymbolTable_IsConstStringKnown (sym))
    {
      size = SymbolTable_GetStringLength (tokenno, sym);
      if (size == 1)
        {
          DeclareCharConstant (tokenno, sym);
        }
      else
        {
          DeclareStringConstant (tokenno, sym);
        }
      return true;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TryDeclareConst - try to declare a const to gcc.  If it cannot
                     declare the symbol it places it into the
                     todolist.
*/

static void TryDeclareConst (unsigned int tokenno, unsigned int sym)
{
  unsigned int type;

  if (! (SymbolConversion_GccKnowsAbout (sym)))
    {
      if ((SymbolTable_IsConstructor (sym)) || (SymbolTable_IsConstSet (sym)))
        {
          M2ALU_WalkConstructorDependants (sym, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) TraverseDependants});
          M2ALU_TryEvaluateValue (sym);
          if (! (M2ALU_IsConstructorDependants (sym, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) IsFullyDeclared})))
            {
              TraverseDependants (sym);
              return;
            }
          if (! (SymbolTable_IsConstructorConstant (sym)))
            {
              return;
            }
        }
      if ((SymbolTable_IsConstString (sym)) && (SymbolTable_IsConstStringKnown (sym)))
        {
          /* avoid dangling else.  */
          if (DeclareConstString (tokenno, sym))
            {}  /* empty.  */
        }
      else if (SymbolTable_IsValueSolved (sym))
        {
          /* avoid dangling else.  */
          SymbolTable_PushValue (sym);
          if (SymbolTable_IsConstSet (sym))
            {
              DeclareConstantFromTree (sym, M2ALU_PopSetTree (tokenno));
            }
          else if (SymbolTable_IsConstructor (sym))
            {
              /* avoid dangling else.  */
              DeclareConstantFromTree (sym, M2ALU_PopConstructorTree (tokenno));
            }
          else if ((M2Base_IsRealType (SymbolTable_GetDType (sym))) || (M2System_IsRealN (SymbolTable_GetDType (sym))))
            {
              /* avoid dangling else.  */
              type = SymbolTable_GetDType (sym);
              DeclareConstantFromTree (sym, m2convert_BuildConvert (M2LexBuf_TokenToLocation (tokenno), SymbolConversion_Mod2Gcc (type), M2ALU_PopRealTree (), true));
            }
          else if (M2Base_IsComplexType (SymbolTable_GetDType (sym)))
            {
              /* avoid dangling else.  */
              type = SymbolTable_GetDType (sym);
              DeclareConstantFromTree (sym, m2convert_BuildConvert (M2LexBuf_TokenToLocation (tokenno), SymbolConversion_Mod2Gcc (type), M2ALU_PopComplexTree (), true));
            }
          else
            {
              /* avoid dangling else.  */
              if ((SymbolTable_GetSType (sym)) == SymbolTable_NulSym)
                {
                  type = M2Base_ZType;
                }
              else
                {
                  type = SymbolTable_GetDType (sym);
                }
              DeclareConstantFromTree (sym, m2convert_BuildConvert (M2LexBuf_TokenToLocation (tokenno), SymbolConversion_Mod2Gcc (type), M2ALU_PopIntegerTree (), true));
            }
        }
      else
        {
          /* avoid dangling else.  */
          TraverseDependants (sym);
        }
    }
}


/*
   DeclareConst - declares a const to gcc and returns a Tree.
*/

static tree DeclareConst (unsigned int tokenno, unsigned int sym)
{
  unsigned int type;

  if (SymbolConversion_GccKnowsAbout (sym))
    {
      return SymbolConversion_Mod2Gcc (sym);
    }
  if ((SymbolTable_IsConstructor (sym)) || (SymbolTable_IsConstSet (sym)))
    {
      M2ALU_EvaluateValue (sym);
    }
  if (SymbolTable_IsConstString (sym))
    {
      /* avoid dangling else.  */
      if (DeclareConstString (tokenno, sym))
        {}  /* empty.  */
    }
  else if (SymbolTable_IsValueSolved (sym))
    {
      /* avoid dangling else.  */
      SymbolTable_PushValue (sym);
      if (SymbolTable_IsConstSet (sym))
        {
          DeclareConstantFromTree (sym, M2ALU_PopSetTree (tokenno));
        }
      else if (SymbolTable_IsConstructor (sym))
        {
          /* avoid dangling else.  */
          DeclareConstantFromTree (sym, M2ALU_PopConstructorTree (tokenno));
        }
      else if (M2Base_IsRealType (SymbolTable_GetDType (sym)))
        {
          /* avoid dangling else.  */
          type = SymbolTable_GetDType (sym);
          DeclareConstantFromTree (sym, m2convert_BuildConvert (M2LexBuf_TokenToLocation (tokenno), SymbolConversion_Mod2Gcc (type), M2ALU_PopRealTree (), true));
        }
      else if (M2Base_IsComplexType (SymbolTable_GetDType (sym)))
        {
          /* avoid dangling else.  */
          type = SymbolTable_GetDType (sym);
          DeclareConstantFromTree (sym, m2convert_BuildConvert (M2LexBuf_TokenToLocation (tokenno), SymbolConversion_Mod2Gcc (type), M2ALU_PopComplexTree (), true));
        }
      else
        {
          /* avoid dangling else.  */
          if ((SymbolTable_GetSType (sym)) == SymbolTable_NulSym)
            {
              type = M2Base_ZType;
            }
          else
            {
              type = SymbolTable_GetDType (sym);
            }
          DeclareConstantFromTree (sym, m2convert_BuildConvert (M2LexBuf_TokenToLocation (tokenno), SymbolConversion_Mod2Gcc (type), M2ALU_PopIntegerTree (), true));
        }
    }
  if (SymbolConversion_GccKnowsAbout (sym))
    {
      return SymbolConversion_Mod2Gcc (sym);
    }
  else
    {
      return NULL;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkFamilyOfUnbounded -
*/

static void WalkFamilyOfUnbounded (unsigned int oaf __attribute__((unused)), unsigned int dim __attribute__((unused)), unsigned int unbounded)
{
  if (unbounded != SymbolTable_NulSym)
    {
      (*unboundedp.proc) (unbounded);
    }
}


/*
   WalkAssociatedUnbounded -
*/

static void WalkAssociatedUnbounded (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int oaf;
  M2GCCDeclare_WalkAction o;

  oaf = SymbolTable_GetOAFamily (sym);
  o = unboundedp;
  unboundedp = p;
  SymbolTable_ForeachOAFamily (oaf, (SymbolTable_FamilyOperation) {(SymbolTable_FamilyOperation_t) WalkFamilyOfUnbounded});
  unboundedp = o;
}


/*
   WalkDependants - walks through all dependants of, Sym,
                    calling, p, for each dependant.
*/

static void WalkDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  WalkAssociatedUnbounded (sym, p);
  if (SymbolTable_IsComponent (sym))
    {
      WalkComponentDependants (sym, p);
    }
  else if (SymbolTable_IsEnumeration (sym))
    {
      /* avoid dangling else.  */
      WalkEnumerationDependants (sym, p);
    }
  else if (SymbolTable_IsSubrange (sym))
    {
      /* avoid dangling else.  */
      WalkSubrangeDependants (sym, p);
    }
  else if (SymbolTable_IsPointer (sym))
    {
      /* avoid dangling else.  */
      WalkPointerDependants (sym, p);
    }
  else if (SymbolTable_IsRecord (sym))
    {
      /* avoid dangling else.  */
      WalkRecordDependants (sym, p);
    }
  else if (SymbolTable_IsVarient (sym))
    {
      /* avoid dangling else.  */
      WalkVarientDependants (sym, p);
    }
  else if (SymbolTable_IsRecordField (sym))
    {
      /* avoid dangling else.  */
      WalkRecordFieldDependants (sym, p);
    }
  else if (SymbolTable_IsFieldVarient (sym))
    {
      /* avoid dangling else.  */
      WalkVarientFieldDependants (sym, p);
    }
  else if (SymbolTable_IsArray (sym))
    {
      /* avoid dangling else.  */
      WalkArrayDependants (sym, p);
    }
  else if (SymbolTable_IsProcType (sym))
    {
      /* avoid dangling else.  */
      WalkProcTypeDependants (sym, p);
    }
  else if (SymbolTable_IsUnbounded (sym))
    {
      /* avoid dangling else.  */
      WalkUnboundedDependants (sym, p);
    }
  else if (SymbolTable_IsSet (sym))
    {
      /* avoid dangling else.  */
      WalkSetDependants (sym, p);
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      WalkTypeDependants (sym, p);
    }
  else if (SymbolTable_IsConst (sym))
    {
      /* avoid dangling else.  */
      WalkConst (sym, p);
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      WalkVarDependants (sym, p);
    }
  else if (SymbolTable_IsProcedure (sym))
    {
      /* avoid dangling else.  */
      WalkProcedureDependants (sym, p);
    }
}


/*
   TraverseDependantsInner -
*/

static void TraverseDependantsInner (unsigned int sym)
{
  if ((! (Sets_IsElementInSet (GlobalGroup->FullyDeclared, sym))) && (! (Sets_IsElementInSet (GlobalGroup->ToDoList, sym))))
    {
      WatchIncludeList (sym, M2GCCDeclare_todolist);
    }
  if (! (Sets_IsElementInSet (VisitedList, sym)))
    {
      Sets_IncludeElementIntoSet (VisitedList, sym);
      WalkDependants (sym, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) TraverseDependantsInner});
    }
}


/*
   TraverseDependants - walks, sym, dependants.  But it checks
                        to see that, sym, is not on the
                        FullyDeclared and not on the ToDoList.
*/

static void TraverseDependants (unsigned int sym)
{
  if (VisitedList == NULL)
    {
      VisitedList = Sets_InitSet (1);
      TraverseDependantsInner (sym);
      VisitedList = Sets_KillSet (VisitedList);
    }
  else
    {
      M2Error_InternalError ((const char *) "recursive call to TraverseDependants caught", 43);
    }
}


/*
   WalkTypeInfo - walks type, sym, and its dependants.
*/

static void WalkTypeInfo (unsigned int sym)
{
  if (SymbolTable_IsVarient (sym))
    {
      M2Error_InternalError ((const char *) "why have we reached here?", 25);
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      WalkTypeInfo (SymbolTable_GetSType (sym));
      if ((SymbolTable_GetVarBackEndType (sym)) != SymbolTable_NulSym)
        {
          WalkTypeInfo (SymbolTable_GetVarBackEndType (sym));
        }
    }
  else if (SymbolTable_IsAModula2Type (sym))
    {
      /* avoid dangling else.  */
      TraverseDependants (sym);
    }
}


/*
   DeclareUnboundedProcedureParameters -
*/

static void DeclareUnboundedProcedureParameters (unsigned int sym)
{
  unsigned int param;
  unsigned int type;
  unsigned int p;
  unsigned int i;
  location_t location;

  if (SymbolTable_IsProcedure (sym))
    {
      p = SymbolTable_NoOfParamAny (sym);
      i = p;
      while (i > 0)
        {
          if (SymbolTable_IsUnboundedParamAny (sym, i))
            {
              /* avoid dangling else.  */
              param = SymbolTable_GetNthParamAny (sym, i);
              type = SymbolTable_GetSType (param);
              TraverseDependants (type);
              if (SymbolConversion_GccKnowsAbout (type))
                {
                  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (type));
                  m2type_BuildTypeDeclaration (location, SymbolConversion_Mod2Gcc (type));
                }
            }
          else
            {
              param = SymbolTable_GetNth (sym, i);
              type = SymbolTable_GetSType (param);
              TraverseDependants (type);
            }
          i -= 1;
        }
    }
}


/*
   WalkUnboundedProcedureParameters -
*/

static void WalkUnboundedProcedureParameters (unsigned int sym)
{
  unsigned int param;
  unsigned int type;
  unsigned int p;
  unsigned int i;

  if (SymbolTable_IsProcedure (sym))
    {
      p = SymbolTable_NoOfParamAny (sym);
      i = p;
      while (i > 0)
        {
          if (SymbolTable_IsUnboundedParamAny (sym, i))
            {
              param = SymbolTable_GetNthParamAny (sym, i);
            }
          else
            {
              param = SymbolTable_GetNth (sym, i);
            }
          type = SymbolTable_GetSType (param);
          WalkTypeInfo (type);
          i -= 1;
        }
    }
}


/*
   WalkTypesInProcedure - walk all types in procedure, Sym.
*/

static void WalkTypesInProcedure (unsigned int sym)
{
  SymbolTable_ForeachLocalSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) TraverseDependants});
}


/*
   WalkTypesInModule - declare all types in module, Sym, to GCC.
*/

static void WalkTypesInModule (unsigned int sym)
{
  NameKey_Name n;

  if (Debugging)
    {
      n = SymbolTable_GetSymName (sym);
      M2Printf_printf1 ((const char *) "Declaring types in MODULE %a\\n", 30, (const unsigned char *) &n, (sizeof (n)-1));
    }
  SymbolTable_ForeachLocalSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) WalkTypeInfo});
  SymbolTable_ForeachLocalSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) WalkUnboundedProcedureParameters});
  SymbolTable_ForeachInnerModuleDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) WalkTypesInModule});
}


/*
   IsRecordFieldDependants - returns TRUE if the record field
                             symbol, sym, p(dependants) all return TRUE.
*/

static bool IsRecordFieldDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int align;
  bool final;

  final = true;
  if (! ((*q.proc) (SymbolTable_GetSType (sym))))
    {
      final = false;
    }
  align = SymbolTable_GetAlignment (sym);
  if ((align != SymbolTable_NulSym) && (! ((*q.proc) (align))))
    {
      final = false;
    }
  return final;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetModuleWhereDeclared - returns the module where, Sym, was created.
*/

static unsigned int GetModuleWhereDeclared (unsigned int sym)
{
  unsigned int s;

  s = SymbolTable_GetScope (sym);
  if (((s == SymbolTable_NulSym) || (SymbolTable_IsDefImp (s))) || ((SymbolTable_IsModule (s)) && ((SymbolTable_GetScope (s)) == SymbolTable_NulSym)))
    {
      return s;
    }
  else
    {
      return GetModuleWhereDeclared (s);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPseudoProcFunc - returns TRUE if Sym is a pseudo function or procedure.
*/

static bool IsPseudoProcFunc (unsigned int Sym)
{
  return ((M2Base_IsPseudoBaseProcedure (Sym)) || (M2Base_IsPseudoBaseFunction (Sym))) || (M2System_IsPseudoSystemFunction (Sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsExternal -
*/

static bool IsExternal (unsigned int sym)
{
  unsigned int mod;

  M2Debug_Assert (! (SymbolTable_IsDefImp (sym)));
  if ((SymbolTable_IsProcedure (sym)) && (SymbolTable_IsExtern (sym)))
    {
      return true;
    }
  mod = SymbolTable_GetScope (sym);
  do {
    if (mod == SymbolTable_NulSym)
      {
        return false;
      }
    else if (SymbolTable_IsDefImp (mod))
      {
        /* avoid dangling else.  */
        return mod != (SymbolTable_GetMainModule ());
      }
    mod = SymbolTable_GetScope (mod);
  } while (! (mod == SymbolTable_NulSym));
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsExternalToWholeProgram - return TRUE if the symbol, sym, is external to the
                              sources that we have parsed.
*/

static bool IsExternalToWholeProgram (unsigned int sym)
{
  unsigned int mod;

  mod = SymbolTable_GetScope (sym);
  do {
    if (mod == SymbolTable_NulSym)
      {
        return false;
      }
    else if (SymbolTable_IsDefImp (mod))
      {
        /* avoid dangling else.  */
        /* return TRUE if we have no source file.  */
        return (M2Batch_GetModuleFile (mod)) == NULL;
      }
    mod = SymbolTable_GetScope (mod);
  } while (! (mod == SymbolTable_NulSym));
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareProcedureToGccWholeProgram -
*/

static void DeclareProcedureToGccWholeProgram (unsigned int Sym)
{
  tree returnType;
  tree GccParam;
  unsigned int scope;
  unsigned int Variable;
  unsigned int p;
  unsigned int i;
  unsigned int b;
  unsigned int e;
  location_t begin;
  location_t end;
  location_t location;

  if ((! (SymbolConversion_GccKnowsAbout (Sym))) && (! (IsPseudoProcFunc (Sym))))
    {
      m2decl_BuildStartFunctionDeclaration (SymbolTable_UsesVarArgs (Sym));
      p = SymbolTable_NoOfParamAny (Sym);
      i = p;
      /* note we dont use GetNthParamAny as we want the parameter that is seen by the procedure block
            remember that this is treated exactly the same as a variable, just its position on
            the activation record is special (ie a parameter)
  */
      while (i > 0)
        {
          Variable = SymbolTable_GetNth (Sym, i);
          location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (Variable));
          if (SymbolTable_IsUnboundedParamAny (Sym, i))
            {
              GccParam = m2decl_BuildParameterDeclaration (location, const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetSymName (Variable)))), SymbolConversion_Mod2Gcc (SymbolTable_GetLType (Variable)), false);
            }
          else
            {
              GccParam = m2decl_BuildParameterDeclaration (location, const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetSymName (Variable)))), SymbolConversion_Mod2Gcc (SymbolTable_GetLType (Variable)), SymbolTable_IsVarParamAny (Sym, i));
            }
          PreAddModGcc (Variable, GccParam);
          WatchRemoveList (Variable, M2GCCDeclare_todolist);
          WatchIncludeList (Variable, M2GCCDeclare_fullydeclared);
          i -= 1;
        }
      SymbolTable_GetProcedureBeginEnd (Sym, &b, &e);
      begin = M2LexBuf_TokenToLocation (b);
      end = M2LexBuf_TokenToLocation (e);
      scope = SymbolTable_GetScope (Sym);
      PushBinding (scope);
      if ((SymbolTable_GetSType (Sym)) == SymbolTable_NulSym)
        {
          returnType = NULL;
        }
      else
        {
          returnType = SymbolConversion_Mod2Gcc (SymbolTable_GetSType (Sym));
        }
      PreAddModGcc (Sym, m2decl_BuildEndFunctionDeclaration (begin, end, const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (Sym)))), returnType, IsExternalToWholeProgram (Sym), M2GCCDeclare_IsProcedureGccNested (Sym), SymbolTable_IsExported (GetModuleWhereDeclared (Sym), Sym), SymbolTable_IsProcedureAnyNoReturn (Sym)));
      PopBinding (scope);
      WatchRemoveList (Sym, M2GCCDeclare_todolist);
      WatchIncludeList (Sym, M2GCCDeclare_fullydeclared);
    }
}


/*
   DeclareProcedureToGccSeparateProgram -
*/

static void DeclareProcedureToGccSeparateProgram (unsigned int Sym)
{
  tree returnType;
  tree GccParam;
  unsigned int scope;
  unsigned int Variable;
  unsigned int p;
  unsigned int i;
  unsigned int b;
  unsigned int e;
  location_t begin;
  location_t end;
  location_t location;
  unsigned int tok;

  tok = SymbolTable_GetDeclaredMod (Sym);
  if (((! (SymbolConversion_GccKnowsAbout (Sym))) && (! (IsPseudoProcFunc (Sym)))) && ((((((IsEffectivelyImported (SymbolTable_GetMainModule (), Sym)) || ((GetModuleWhereDeclared (Sym)) == (SymbolTable_GetMainModule ()))) || (M2Base_IsNeededAtRunTime (tok, Sym))) || (SymbolTable_IsImported (SymbolTable_GetBaseModule (), Sym))) || (SymbolTable_IsExported (GetModuleWhereDeclared (Sym), Sym))) || (SymbolTable_IsExtern (Sym))))
    {
      m2decl_BuildStartFunctionDeclaration (SymbolTable_UsesVarArgs (Sym));
      p = SymbolTable_NoOfParamAny (Sym);
      i = p;
      /* Note we dont use GetNthParamAny as we want the parameter that is seen by
            the procedure block remember that this is treated exactly the same as
            a variable, just its position on the activation record is special (ie
            a parameter).  */
      while (i > 0)
        {
          Variable = SymbolTable_GetNth (Sym, i);
          location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (Variable));
          if (SymbolTable_IsUnboundedParamAny (Sym, i))
            {
              GccParam = m2decl_BuildParameterDeclaration (location, const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetSymName (Variable)))), SymbolConversion_Mod2Gcc (SymbolTable_GetLType (Variable)), false);
            }
          else
            {
              GccParam = m2decl_BuildParameterDeclaration (location, const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetSymName (Variable)))), SymbolConversion_Mod2Gcc (SymbolTable_GetLType (Variable)), SymbolTable_IsVarParamAny (Sym, i));
            }
          PreAddModGcc (Variable, GccParam);
          WatchRemoveList (Variable, M2GCCDeclare_todolist);
          WatchIncludeList (Variable, M2GCCDeclare_fullydeclared);
          i -= 1;
        }
      SymbolTable_GetProcedureBeginEnd (Sym, &b, &e);
      begin = M2LexBuf_TokenToLocation (b);
      end = M2LexBuf_TokenToLocation (e);
      scope = SymbolTable_GetScope (Sym);
      PushBinding (scope);
      if ((SymbolTable_GetSType (Sym)) == SymbolTable_NulSym)
        {
          returnType = NULL;
        }
      else
        {
          returnType = SymbolConversion_Mod2Gcc (SymbolTable_GetSType (Sym));
        }
      /* Exported from the module where it was declared.  */
      PreAddModGcc (Sym, m2decl_BuildEndFunctionDeclaration (begin, end, const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (Sym)))), returnType, IsExternal (Sym), M2GCCDeclare_IsProcedureGccNested (Sym), (SymbolTable_IsExported (GetModuleWhereDeclared (Sym), Sym)) || (SymbolTable_IsExtern (Sym)), SymbolTable_IsProcedureAnyNoReturn (Sym)));
      PopBinding (scope);
      WatchRemoveList (Sym, M2GCCDeclare_todolist);
      WatchIncludeList (Sym, M2GCCDeclare_fullydeclared);
    }
}


/*
   DeclareProcedureToGcc - traverses all parameters and interfaces to gm2gcc.
*/

static void DeclareProcedureToGcc (unsigned int sym)
{
  if (sym != SymbolTable_NulSym)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (M2Options_WholeProgram)
        {
          DeclareProcedureToGccWholeProgram (sym);
        }
      else
        {
          DeclareProcedureToGccSeparateProgram (sym);
        }
    }
}


/*
   ActivateWatch - activate a watch for any symbol (lista xor listb).
*/

static void ActivateWatch (Sets_Set lista, Sets_Set listb)
{
  Sets_Set smallest;
  Sets_Set largest;
  unsigned int n;
  unsigned int sym;

  if ((Sets_NoOfElementsInSet (lista)) != (Sets_NoOfElementsInSet (listb)))
    {
      if ((Sets_NoOfElementsInSet (lista)) > (Sets_NoOfElementsInSet (listb)))
        {
          largest = lista;
          smallest = listb;
        }
      else
        {
          largest = listb;
          smallest = lista;
        }
      M2Printf_printf0 ((const char *) "adding the following symbols to the watch list as the declarator has detected an internal bug: ", 95);
      sym = 1;
      n = SymbolTable_FinalSymbol ();
      while (sym <= n)
        {
          if (((Sets_IsElementInSet (largest, sym)) && (! (Sets_IsElementInSet (smallest, sym)))) || ((! (Sets_IsElementInSet (largest, sym))) && (Sets_IsElementInSet (smallest, sym))))
            {
              AddSymToWatch (sym);
              M2Printf_printf1 ((const char *) "%d ", 3, (const unsigned char *) &sym, (sizeof (sym)-1));
            }
          sym += 1;
        }
      M2Printf_printf0 ((const char *) "\\n", 2);
    }
}


/*
   DeclareTypesConstantsProceduresInRange -
*/

static void DeclareTypesConstantsProceduresInRange (unsigned int scope, unsigned int start, unsigned int end)
{
  M2GCCDeclare_Group copy;
  unsigned int loop;
  M2Scope_ScopeBlock sb;
  M2BasicBlock_BasicBlock bb;

  if (TraceQuadruples)
    {
      M2Quads_DisplayQuadRange (scope, start, end);
    }
  loop = 0;
  copy = NULL;
  sb = M2Scope_InitScopeBlock (scope);
  /* Throw away any unreachable quad.  */
  do {
    bb = M2BasicBlock_InitBasicBlocks (sb);
    M2BasicBlock_KillBasicBlocks (&bb);
    /* Now iterate over remaining quads in scope attempting to resolve constants.  */
    copy = DupGroup (copy);
    bb = M2BasicBlock_InitBasicBlocks (sb);
    ConstantResolved = false;
    M2BasicBlock_ForeachBasicBlockDo (bb, (M2BasicBlock_BasicBlockProc) {(M2BasicBlock_BasicBlockProc_t) M2GCCDeclare_FoldConstants});
    M2BasicBlock_KillBasicBlocks (&bb);
    /* And now types.  */
    if (DeclaredOutstandingTypes (false))
      {}  /* empty.  */
    if (loop == DebugLoop)
      {
        if (TraceQuadruples)
          {
            M2Quads_DisplayQuadRange (scope, start, end);
          }
        ActivateWatch (copy->ToDoList, GlobalGroup->ToDoList);
        loop = 0;
      }
    loop += 1;
  } while (! (! ConstantResolved && (EqualGroup (copy, GlobalGroup))));
  KillGroup (&copy);
  bb = M2BasicBlock_InitBasicBlocks (sb);
  M2BasicBlock_KillBasicBlocks (&bb);
  M2Scope_KillScopeBlock (&sb);
}


/*
   SkipModuleScope - skips all module scopes for, scope.
                     It returns either NulSym or a procedure sym.
*/

static unsigned int SkipModuleScope (unsigned int scope)
{
  if ((scope == SymbolTable_NulSym) || (SymbolTable_IsProcedure (scope)))
    {
      return scope;
    }
  else
    {
      return SkipModuleScope (SymbolTable_GetScope (scope));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushBinding -
*/

static void PushBinding (unsigned int scope)
{
  scope = SkipModuleScope (scope);
  if (scope == SymbolTable_NulSym)
    {
      m2block_pushGlobalScope ();
    }
  else
    {
      m2block_pushFunctionScope (SymbolConversion_Mod2Gcc (scope));
    }
}


/*
   PopBinding -
*/

static void PopBinding (unsigned int scope)
{
  scope = SkipModuleScope (scope);
  if (scope == SymbolTable_NulSym)
    {
      m2block_popGlobalScope ();
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsProcedure (scope));
      m2block_finishFunctionDecl (M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (scope)), SymbolConversion_Mod2Gcc (scope));
      M2Debug_Assert ((m2block_popFunctionScope ()) != NULL);
    }
}


/*
   DeclareTypesConstantsProcedures -
*/

static void DeclareTypesConstantsProcedures (unsigned int scope)
{
  M2GCCDeclare_Group copy;
  M2Scope_ScopeBlock sb;

  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "declaring types constants in: ", 30);
      PrintTerse (scope);
    }
  copy = NULL;
  sb = M2Scope_InitScopeBlock (scope);
  PushBinding (scope);
  do {
    copy = DupGroup (copy);
    M2Scope_ForeachScopeBlockDo3 (sb, (M2Scope_ScopeProcedure3) {(M2Scope_ScopeProcedure3_t) DeclareTypesConstantsProceduresInRange});
  } while (! (EqualGroup (copy, GlobalGroup)));
  KillGroup (&copy);
  PopBinding (scope);
  M2Scope_KillScopeBlock (&sb);
}


/*
   AssertAllTypesDeclared - asserts that all types for variables are declared in, scope.
*/

static void AssertAllTypesDeclared (unsigned int scope)
{
  unsigned int n;
  unsigned int Var;
  bool failed;

  failed = false;
  n = 1;
  Var = SymbolTable_GetNth (scope, n);
  while (Var != SymbolTable_NulSym)
    {
      if (! (TypeDependentsDeclared (Var, true)))
        {
          failed = true;
        }
      n += 1;
      Var = SymbolTable_GetNth (scope, n);
    }
  if (failed)
    {
      M2Error_FlushErrors ();
    }
}


/*
   DeclareModuleInit - declare all the ctor related functions within
                       a module.
*/

static void DeclareModuleInit (unsigned int moduleSym)
{
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  SymbolTable_GetModuleCtors (moduleSym, &ctor, &init, &fini, &dep);
  DeclareProcedureToGcc (ctor);
  DeclareProcedureToGcc (init);
  DeclareProcedureToGcc (fini);
  DeclareProcedureToGcc (dep);
}


/*
   StartDeclareProcedureScope -
*/

static void StartDeclareProcedureScope (unsigned int scope)
{
  WalkTypesInProcedure (scope);
  M2GCCDeclare_DeclareProcedure (scope);
  SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) WalkTypesInModule});
  DeclareTypesConstantsProcedures (scope);
  SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareTypesConstantsProcedures});
  M2GCCDeclare_DeclareLocalVariables (scope);
  SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_DeclareModuleVariables});
  AssertAllTypesDeclared (scope);
  SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_DeclareProcedure});
  SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_StartDeclareScope});
}


/*
   StartDeclareModuleScopeSeparate -
*/

static void StartDeclareModuleScopeSeparate (unsigned int scope)
{
  if (scope == (SymbolTable_GetMainModule ()))
    {
      SymbolTable_ForeachModuleDo ((SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) WalkTypesInModule});  /* will populate the TYPE and CONST ToDo list  */
      DeclareTypesConstantsProcedures (scope);  /* will resolved TYPEs and CONSTs on the ToDo  */
      /* lists.  */
      SymbolTable_ForeachModuleDo ((SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_DeclareProcedure});
      /* Now that all types have been resolved it is safe to declare
         variables.  */
      AssertAllTypesDeclared (scope);
      DeclareGlobalVariables (scope);
      SymbolTable_ForeachImportedDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareImportedVariables});
      /* Now it is safe to declare all procedures.  */
      SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_DeclareProcedure});
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) WalkTypesInModule});
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareTypesConstantsProcedures});
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_StartDeclareScope});
      DeclareModuleInit (scope);
    }
  else
    {
      DeclareTypesConstantsProcedures (scope);
      AssertAllTypesDeclared (scope);
      SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_DeclareProcedure});
      DeclareModuleInit (scope);
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_StartDeclareScope});
    }
}


/*
   StartDeclareModuleScopeWholeProgram -
*/

static void StartDeclareModuleScopeWholeProgram (unsigned int scope)
{
  if (M2Batch_IsSourceSeen (scope))
    {
      SymbolTable_ForeachModuleDo ((SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) WalkTypesInModule});  /* will populate the TYPE and CONST ToDo list  */
      DeclareTypesConstantsProcedures (scope);  /* will resolved TYPEs and CONSTs on the ToDo  */
      /* lists.  */
      SymbolTable_ForeachModuleDo ((SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_DeclareProcedure});
      SymbolTable_ForeachModuleDo ((SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareModuleInit});
      /* Now that all types have been resolved it is safe to declare
         variables.  */
      AssertAllTypesDeclared (scope);
      DeclareGlobalVariablesWholeProgram (scope);
      SymbolTable_ForeachImportedDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareImportedVariablesWholeProgram});
      /* Now it is safe to declare all procedures.  */
      SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_DeclareProcedure});
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) WalkTypesInModule});
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareTypesConstantsProcedures});
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_StartDeclareScope});
      DeclareModuleInit (scope);
    }
  else
    {
      DeclareTypesConstantsProcedures (scope);
      AssertAllTypesDeclared (scope);
      SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_DeclareProcedure});
      DeclareModuleInit (scope);
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_StartDeclareScope});
    }
}


/*
   StartDeclareModuleScope -
*/

static void StartDeclareModuleScope (unsigned int scope)
{
  if (M2Options_WholeProgram)
    {
      StartDeclareModuleScopeWholeProgram (scope);
    }
  else
    {
      StartDeclareModuleScopeSeparate (scope);
    }
}


/*
   DumpResolver - dumps the m2 representation of sym.
*/

static void DumpResolver (unsigned int sym)
{
  M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "dump filtered symbol %d and dependants\\n", 40, (const unsigned char *) &sym, (sizeof (sym)-1));
  PrintVerbose (sym);
}


/*
   DumpDefinitive - dumps the m2 and m2 gimple representation of sym.
*/

static void DumpDefinitive (unsigned int sym)
{
  int fd;

  M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "\\nm2 symbol synopsis: %d\\n", 26, (const unsigned char *) &sym, (sizeof (sym)-1));
  PrintVerbose (sym);
  if (SymbolConversion_GccKnowsAbout (sym))
    {
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "\\nm2 gimple: %d", 15, (const unsigned char *) &sym, (sizeof (sym)-1));
      FIO_FlushBuffer (M2LangDump_GetDumpFile ());
      fd = FIO_GetUnixFileDescriptor (M2LangDump_GetDumpFile ());
      m2pp_DumpGimpleFd (fd, SymbolConversion_Mod2Gcc (sym));
    }
  else
    {
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "\\nno m2 gimple for %d\\n", 23, (const unsigned char *) &sym, (sizeof (sym)-1));
    }
}


/*
   PreAddModGcc - adds a relationship between sym and tree.
*/

static void PreAddModGcc (unsigned int sym, tree tree)
{
  SymbolConversion_AddModGcc (sym, tree);
}


/*
   DeclareDefaultType - declares a default type, sym, with, name.
*/

static void DeclareDefaultType (unsigned int sym, const char *name_, unsigned int _name_high, tree gcctype)
{
  tree t;
  unsigned int high;
  unsigned int low;
  location_t location;
  char name[_name_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);

  /* DeclareDefaultType will declare a new identifier as a type of, gcctype, if it has not already been
      declared by gccgm2.c  */
  location = m2linemap_BuiltinsLocation ();
  t = m2type_GetDefaultType (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (NameKey_MakeKey ((const char *) name, _name_high))), gcctype);
  SymbolConversion_AddModGcc (sym, t);
  Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, sym);
  WalkAssociatedUnbounded (sym, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) TraverseDependants});
  /* 
      this is very simplistic and assumes that the caller only uses Subranges, Sets and GCC types.
      We need to declare any constants with the types so that AllDependantsFullyDeclared works.
  */
  if (SymbolTable_IsSubrange (sym))
    {
      SymbolTable_GetSubrange (sym, &high, &low);
      M2GCCDeclare_DeclareConstant (SymbolTable_GetDeclaredMod (sym), high);
      M2GCCDeclare_DeclareConstant (SymbolTable_GetDeclaredMod (sym), low);
    }
  else if (SymbolTable_IsSet (sym))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsSubrange (SymbolTable_GetSType (sym)))
        {
          if (! (SymbolConversion_GccKnowsAbout (SymbolTable_GetSType (sym))))
            {
              /* only true for internal types of course  */
              M2Error_InternalError ((const char *) "subrange type within the set type must be declared before the set type", 70);
            }
          SymbolTable_GetSubrange (SymbolTable_GetSType (sym), &high, &low);
          M2GCCDeclare_DeclareConstant (SymbolTable_GetDeclaredMod (sym), high);
          M2GCCDeclare_DeclareConstant (SymbolTable_GetDeclaredMod (sym), low);
        }
      else if (SymbolTable_IsEnumeration (SymbolTable_GetSType (sym)))
        {
          /* avoid dangling else.  */
          if (! (SymbolConversion_GccKnowsAbout (SymbolTable_GetSType (sym))))
            {
              /* only true for internal types of course  */
              M2Error_InternalError ((const char *) "enumeration type within the set type must be declared before the set type", 73);
            }
        }
    }
}


/*
   DeclareBoolean - declares the Boolean type together with true and false.
*/

static void DeclareBoolean (void)
{
  SymbolConversion_AddModGcc (M2Base_Boolean, m2type_GetBooleanType ());
  SymbolConversion_AddModGcc (M2Base_True, m2type_GetBooleanTrue ());
  SymbolConversion_AddModGcc (M2Base_False, m2type_GetBooleanFalse ());
  Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, M2Base_Boolean);
  Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, M2Base_True);
  Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, M2Base_False);
  WalkAssociatedUnbounded (M2Base_Boolean, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) TraverseDependants});
}


/*
   DeclareFixedSizedType - declares the GNU Modula-2 fixed types
                           (if the back end support such a type).
*/

static void DeclareFixedSizedType (const char *name_, unsigned int _name_high, unsigned int type, tree t)
{
  location_t location;
  unsigned int typetype;
  unsigned int low;
  unsigned int high;
  char name[_name_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);

  if (type != SymbolTable_NulSym)
    {
      if ((SymbolTable_IsSet (type)) && (! (SymbolConversion_GccKnowsAbout (SymbolTable_GetSType (type)))))
        {
          typetype = SymbolTable_GetSType (type);
          SymbolTable_GetSubrange (typetype, &high, &low);
          M2GCCDeclare_DeclareConstant (SymbolTable_GetDeclaredMod (type), high);
          M2GCCDeclare_DeclareConstant (SymbolTable_GetDeclaredMod (type), low);
          location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (typetype));
          PreAddModGcc (typetype, m2type_BuildSubrangeType (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (typetype))), SymbolConversion_Mod2Gcc (SymbolTable_GetSType (typetype)), SymbolConversion_Mod2Gcc (low), SymbolConversion_Mod2Gcc (high)));
          Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, typetype);
          WalkAssociatedUnbounded (typetype, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) TraverseDependants});
        }
      /* gcc back end supports, type  */
      DeclareDefaultType (type, (const char *) name, _name_high, t);
    }
}


/*
   DeclareDefaultSimpleTypes - declares the simple types.
*/

static void DeclareDefaultSimpleTypes (void)
{
  SymbolConversion_AddModGcc (M2Base_ZType, m2type_GetM2ZType ());
  SymbolConversion_AddModGcc (M2Base_RType, m2type_GetM2RType ());
  SymbolConversion_AddModGcc (M2Base_CType, m2type_GetM2CType ());
  Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, M2Base_ZType);
  Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, M2Base_RType);
  Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, M2Base_CType);
  DeclareDefaultType (M2Base_Cardinal, (const char *) "CARDINAL", 8, m2type_GetM2CardinalType ());
  DeclareDefaultType (M2Base_Integer, (const char *) "INTEGER", 7, m2type_GetM2IntegerType ());
  DeclareDefaultType (M2Base_Char, (const char *) "CHAR", 4, m2type_GetM2CharType ());
  DeclareDefaultType (M2System_Loc, (const char *) "LOC", 3, m2type_GetISOLocType ());
  if (M2Options_Iso)
    {
      DeclareDefaultType (M2System_Byte, (const char *) "BYTE", 4, m2type_GetISOByteType ());
      DeclareDefaultType (M2System_Word, (const char *) "WORD", 4, m2type_GetISOWordType ());
    }
  else
    {
      DeclareDefaultType (M2System_Byte, (const char *) "BYTE", 4, m2type_GetByteType ());
      DeclareDefaultType (M2System_Word, (const char *) "WORD", 4, m2type_GetWordType ());
    }
  DeclareDefaultType (M2Base_Proc, (const char *) "PROC", 4, m2type_GetProcType ());
  DeclareDefaultType (M2System_Address, (const char *) "ADDRESS", 7, m2type_GetPointerType ());
  DeclareDefaultType (M2Base_LongInt, (const char *) "LONGINT", 7, m2type_GetM2LongIntType ());
  DeclareDefaultType (M2Base_LongCard, (const char *) "LONGCARD", 8, m2type_GetM2LongCardType ());
  DeclareDefaultType (M2Base_ShortInt, (const char *) "SHORTINT", 8, m2type_GetM2ShortIntType ());
  DeclareDefaultType (M2Base_ShortCard, (const char *) "SHORTCARD", 9, m2type_GetM2ShortCardType ());
  DeclareDefaultType (M2Base_ShortReal, (const char *) "SHORTREAL", 9, m2type_GetM2ShortRealType ());
  DeclareDefaultType (M2Base_Real, (const char *) "REAL", 4, m2type_GetM2RealType ());
  DeclareDefaultType (M2Base_LongReal, (const char *) "LONGREAL", 8, m2type_GetM2LongRealType ());
  DeclareDefaultType (M2Bitset_Bitnum, (const char *) "BITNUM", 6, m2type_GetBitnumType ());
  DeclareDefaultType (M2Bitset_Bitset, (const char *) "BITSET", 6, m2type_GetBitsetType ());
  DeclareDefaultType (M2Base_Complex, (const char *) "COMPLEX", 7, m2type_GetM2ComplexType ());
  DeclareDefaultType (M2Base_LongComplex, (const char *) "LONGCOMPLEX", 11, m2type_GetM2LongComplexType ());
  DeclareDefaultType (M2Base_ShortComplex, (const char *) "SHORTCOMPLEX", 12, m2type_GetM2ShortComplexType ());
  DeclareDefaultType (M2System_CSizeT, (const char *) "CSIZE_T", 7, m2type_GetCSizeTType ());
  DeclareDefaultType (M2System_CSSizeT, (const char *) "CSSIZE_T", 8, m2type_GetCSSizeTType ());
  DeclareDefaultType (M2System_COffT, (const char *) "COFF_T", 6, m2type_GetCOffTType ());
  DeclareBoolean ();
  DeclareFixedSizedType ((const char *) "INTEGER8", 8, M2System_IntegerN (8), m2type_GetM2Integer8 ());
  DeclareFixedSizedType ((const char *) "INTEGER16", 9, M2System_IntegerN (16), m2type_GetM2Integer16 ());
  DeclareFixedSizedType ((const char *) "INTEGER32", 9, M2System_IntegerN (32), m2type_GetM2Integer32 ());
  DeclareFixedSizedType ((const char *) "INTEGER64", 9, M2System_IntegerN (64), m2type_GetM2Integer64 ());
  DeclareFixedSizedType ((const char *) "CARDINAL8", 9, M2System_CardinalN (8), m2type_GetM2Cardinal8 ());
  DeclareFixedSizedType ((const char *) "CARDINAL16", 10, M2System_CardinalN (16), m2type_GetM2Cardinal16 ());
  DeclareFixedSizedType ((const char *) "CARDINAL32", 10, M2System_CardinalN (32), m2type_GetM2Cardinal32 ());
  DeclareFixedSizedType ((const char *) "CARDINAL64", 10, M2System_CardinalN (64), m2type_GetM2Cardinal64 ());
  DeclareFixedSizedType ((const char *) "WORD16", 6, M2System_WordN (16), m2type_GetM2Word16 ());
  DeclareFixedSizedType ((const char *) "WORD32", 6, M2System_WordN (32), m2type_GetM2Word32 ());
  DeclareFixedSizedType ((const char *) "WORD64", 6, M2System_WordN (64), m2type_GetM2Word64 ());
  DeclareFixedSizedType ((const char *) "BITSET8", 7, M2System_SetN (8), m2type_GetM2Bitset8 ());
  DeclareFixedSizedType ((const char *) "BITSET16", 8, M2System_SetN (16), m2type_GetM2Bitset16 ());
  DeclareFixedSizedType ((const char *) "BITSET32", 8, M2System_SetN (32), m2type_GetM2Bitset32 ());
  DeclareFixedSizedType ((const char *) "REAL32", 6, M2System_RealN (32), m2type_GetM2Real32 ());
  DeclareFixedSizedType ((const char *) "REAL64", 6, M2System_RealN (64), m2type_GetM2Real64 ());
  DeclareFixedSizedType ((const char *) "REAL96", 6, M2System_RealN (96), m2type_GetM2Real96 ());
  DeclareFixedSizedType ((const char *) "REAL128", 7, M2System_RealN (128), m2type_GetM2Real128 ());
  DeclareFixedSizedType ((const char *) "COMPLEX32", 9, M2System_ComplexN (32), m2type_GetM2Complex32 ());
  DeclareFixedSizedType ((const char *) "COMPLEX64", 9, M2System_ComplexN (64), m2type_GetM2Complex64 ());
  DeclareFixedSizedType ((const char *) "COMPLEX96", 9, M2System_ComplexN (96), m2type_GetM2Complex96 ());
  DeclareFixedSizedType ((const char *) "COMPLEX128", 10, M2System_ComplexN (128), m2type_GetM2Complex128 ());
}


/*
   DeclarePackedBoolean -
*/

static void DeclarePackedBoolean (void)
{
  unsigned int e;

  e = SymbolTable_GetPackedEquivalent (M2Base_Boolean);
  SymbolConversion_AddModGcc (e, m2type_GetPackedBooleanType ());
  Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, e);
}


/*
   DeclarePackedDefaultSimpleTypes -
*/

static void DeclarePackedDefaultSimpleTypes (void)
{
  DeclarePackedBoolean ();
}


/*
   DeclareDefaultTypes - makes default types known to GCC
*/

static void DeclareDefaultTypes (void)
{
  if (! HaveInitDefaultTypes)
    {
      HaveInitDefaultTypes = true;
      m2block_pushGlobalScope ();
      DeclareDefaultSimpleTypes ();
      DeclarePackedDefaultSimpleTypes ();
      m2block_popGlobalScope ();
    }
}


/*
   DeclareDefaultConstants - make default constants known to GCC
*/

static void DeclareDefaultConstants (void)
{
  SymbolConversion_AddModGcc (M2Base_Nil, m2expr_GetPointerZero (m2linemap_BuiltinsLocation ()));
  Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, M2Base_Nil);
}


/*
   FindContext - returns the scope where the symbol
                 should be created.

                 Symbols created in a module will
                 return the global context tree, but symbols created
                 in a module which is declared inside
                 a procedure will return the procedure Tree.
*/

static tree FindContext (unsigned int sym)
{
  sym = SymbolTable_GetProcedureScope (sym);
  if (sym == SymbolTable_NulSym)
    {
      return m2block_GetGlobalContext ();
    }
  else
    {
      return SymbolConversion_Mod2Gcc (sym);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsEffectivelyImported - returns TRUE if symbol, Sym, was
                           effectively imported into ModSym.
*/

static bool IsEffectivelyImported (unsigned int ModSym, unsigned int sym)
{
  return (SymbolTable_IsImported (ModSym, sym)) || ((SymbolTable_IsImported (ModSym, GetModuleWhereDeclared (sym))) && (SymbolTable_IsExported (GetModuleWhereDeclared (sym), sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FindOuterModule - returns the out most module where, sym,
                     was declared.  It returns NulSym if the
                     symbol or the module was declared inside
                     a procedure.
*/

static unsigned int FindOuterModule (unsigned int sym)
{
  sym = SymbolTable_GetScope (sym);
  while (! (SymbolTable_IsDefImp (sym)))
    {
      if (SymbolTable_IsModule (sym))
        {
          if ((SymbolTable_GetScope (sym)) == SymbolTable_NulSym)
            {
              return sym;
            }
          else
            {
              sym = SymbolTable_GetScope (sym);
            }
        }
      else if (SymbolTable_IsProcedure (sym))
        {
          /* avoid dangling else.  */
          sym = SymbolTable_GetScope (sym);
        }
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoVariableDeclaration - create a corresponding gcc variable and add the association
                           between the front end symbol var and the gcc tree.
*/

static void DoVariableDeclaration (unsigned int var, void * name, bool isImported, bool isExported, bool isTemporary, bool isGlobal, tree scope)
{
  if (! ((SymbolTable_IsComponent (var)) || (SymbolTable_IsVarHeap (var))))
    {
      if (TypeDependentsDeclared (var, true))
        {
          PrepareGCCVarDeclaration (var, name, isImported, isExported, isTemporary, isGlobal, scope);
        }
    }
}


/*
   TypeDependentsDeclared - return TRUE if all type dependents of variable
                            have been declared.
*/

static bool TypeDependentsDeclared (unsigned int variable, bool errorMessage)
{
  unsigned int type;

  type = SymbolTable_GetSType (variable);
  if (AllDependantsFullyDeclared (type))
    {
      return true;
    }
  else
    {
      if (errorMessage)
        {
          EmitCircularDependencyError (variable);
          Sets_ForeachElementInSetDo (GlobalGroup->ToDoList, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) EmitCircularDependencyError});
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PrepareGCCVarDeclaration -
*/

static void PrepareGCCVarDeclaration (unsigned int var, void * name, bool isImported, bool isExported, bool isTemporary, bool isGlobal, tree scope)
{
  tree type;
  unsigned int varType;
  location_t location;

  if ((SymbolTable_GetMode (var)) == SymbolTable_LeftValue)
    {
      /* 
        There are two issues to deal with:

        (i)   LeftValue is really a pointer to GetSType (var), which is built
              here.
        (ii)  Front end might have specified the back end use a particular
              data type, in which case we use the specified type.
              We do not add an extra pointer if this is the case.
  */
      varType = SymbolTable_SkipType (SymbolTable_GetVarBackEndType (var));
      if (varType == SymbolTable_NulSym)
        {
          /* We have not explicity told back end the type, so build it.  */
          varType = SymbolTable_GetSType (var);
          if (SymbolTable_IsVariableAtAddress (var))
            {
              type = m2type_BuildConstPointerType (SymbolConversion_Mod2Gcc (varType));
            }
          else
            {
              type = m2type_BuildPointerType (SymbolConversion_Mod2Gcc (varType));
            }
        }
      else
        {
          /* We have been requested to use varType.  */
          type = SymbolConversion_Mod2Gcc (varType);
        }
      M2Debug_Assert (AllDependantsFullyDeclared (varType));
    }
  else
    {
      type = SymbolConversion_Mod2Gcc (SymbolTable_GetDType (var));
    }
  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (var));
  PreAddModGcc (var, m2decl_DeclareKnownVariable (location, const_cast <const char * > (static_cast <char * > (name)), type, isExported, isImported, isTemporary, isGlobal, scope, NULL));
  WatchRemoveList (var, M2GCCDeclare_todolist);
  WatchIncludeList (var, M2GCCDeclare_fullydeclared);
}


/*
   IsGlobal - is the variable not in a procedure scope.
*/

static bool IsGlobal (unsigned int sym)
{
  unsigned int s;

  s = SymbolTable_GetScope (sym);
  while (((s != SymbolTable_NulSym) && (! (SymbolTable_IsDefImp (s)))) && (! (SymbolTable_IsModule (s))))
    {
      if (SymbolTable_IsProcedure (s))
        {
          return false;
        }
      s = SymbolTable_GetScope (s);
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareVariable - declares a global variable to GCC.
*/

static void DeclareVariable (unsigned int ModSym, unsigned int variable)
{
  tree scope;
  unsigned int decl;

  if (! (SymbolConversion_GccKnowsAbout (variable)))
    {
      scope = FindContext (ModSym);
      decl = FindOuterModule (variable);
      PushBinding (ModSym);
      /* in Modula-2 we are allowed to import from ourselves, but we do not present this to GCC  */
      DoVariableDeclaration (variable, NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (variable)), (IsEffectivelyImported (ModSym, variable)) && ((SymbolTable_GetMainModule ()) != decl), SymbolTable_IsExported (ModSym, variable), SymbolTable_IsTemporary (variable), IsGlobal (variable), scope);
      PopBinding (ModSym);
    }
}


/*
   DeclareVariableWholeProgram - declares a global variable to GCC when using -fm2-whole-program.
*/

static void DeclareVariableWholeProgram (unsigned int mainModule, unsigned int variable)
{
  tree scope;
  unsigned int decl;

  if (! (SymbolConversion_GccKnowsAbout (variable)))
    {
      scope = FindContext (mainModule);
      decl = FindOuterModule (variable);
      PushBinding (mainModule);
      DoVariableDeclaration (variable, NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (variable)), ((! (M2Batch_IsSourceSeen (decl))) && (IsEffectivelyImported (mainModule, variable))) && ((SymbolTable_GetMainModule ()) != decl), SymbolTable_IsExported (mainModule, variable), SymbolTable_IsTemporary (variable), IsGlobal (variable), scope);
      PopBinding (mainModule);
    }
}


/*
   DeclareGlobalVariablesWholeProgram -
*/

static void DeclareGlobalVariablesWholeProgram (unsigned int ModSym)
{
  unsigned int n;
  unsigned int Variable;

  n = 1;
  Variable = SymbolTable_GetNth (ModSym, n);
  while (Variable != SymbolTable_NulSym)
    {
      DeclareVariableWholeProgram (ModSym, Variable);
      n += 1;
      Variable = SymbolTable_GetNth (ModSym, n);
    }
  SymbolTable_ForeachInnerModuleDo (ModSym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareGlobalVariablesWholeProgram});
}


/*
   DeclareGlobalVariables - lists the Global variables for
                            Module ModSym together with their offset.
*/

static void DeclareGlobalVariables (unsigned int ModSym)
{
  unsigned int n;
  unsigned int Variable;

  n = 1;
  Variable = SymbolTable_GetNth (ModSym, n);
  while (Variable != SymbolTable_NulSym)
    {
      DeclareVariable (ModSym, Variable);
      n += 1;
      Variable = SymbolTable_GetNth (ModSym, n);
    }
  SymbolTable_ForeachInnerModuleDo (ModSym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareGlobalVariables});
}


/*
   DeclareImportedVariables - declares all imported variables to GM2.
*/

static void DeclareImportedVariables (unsigned int sym)
{
  if (SymbolTable_IsVar (sym))
    {
      DeclareVariable (SymbolTable_GetMainModule (), sym);
    }
  else if (SymbolTable_IsDefImp (sym))
    {
      /* avoid dangling else.  */
      SymbolTable_ForeachExportedDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareImportedVariables});
    }
}


/*
   DeclareImportedVariablesWholeProgram - declares all imported variables.
*/

static void DeclareImportedVariablesWholeProgram (unsigned int sym)
{
  if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      if (! (M2Batch_IsSourceSeen (FindOuterModule (sym))))
        {
          /* import is necessary, even for -fm2-whole-program as we
            cannot see the source.  */
          DeclareVariableWholeProgram (SymbolTable_GetMainModule (), sym);
        }
    }
  else if (SymbolTable_IsDefImp (sym))
    {
      /* avoid dangling else.  */
      SymbolTable_ForeachExportedDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclareImportedVariablesWholeProgram});
    }
}


/*
   DeclareFieldValue -
*/

static tree DeclareFieldValue (unsigned int sym, tree value, tree *list)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  if (((GetModuleWhereDeclared (sym)) == SymbolTable_NulSym) || ((GetModuleWhereDeclared (sym)) == (SymbolTable_GetMainModule ())))
    {
      return m2type_BuildEnumerator (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym))), value, list);
    }
  else
    {
      return m2type_BuildEnumerator (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullScopeAsmName (sym))), value, list);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareFieldEnumeration - declares an enumerator within the current enumeration type.
*/

static tree DeclareFieldEnumeration (unsigned int sym)
{
  unsigned int type;
  tree field;
  tree enumlist;

  /* add relationship between gccSym and sym  */
  type = SymbolTable_GetSType (sym);
  enumlist = GetEnumList (type);
  SymbolTable_PushValue (sym);
  field = DeclareFieldValue (sym, M2ALU_PopIntegerTree (), &enumlist);
  PutEnumList (type, enumlist);
  return field;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareEnumeration - declare an enumerated type.
*/

static tree DeclareEnumeration (unsigned int sym)
{
  tree enumlist;
  tree gccenum;
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  gccenum = m2type_BuildStartEnumeration (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (sym))), false);
  enumlist = GetEnumList (sym);
  return m2type_BuildEndEnumeration (location, gccenum, enumlist);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareSubrangeNarrow - will return cardinal, integer, or type depending on whether
                           low..high fits in the C data type.
*/

static tree DeclareSubrangeNarrow (location_t location, unsigned int high, unsigned int low, tree type)
{
  tree m2low;
  tree m2high;
  tree lowtree;
  tree hightree;

  /* No zero alignment, therefore the front end will prioritize subranges to match
      unsigned int, int, or ZTYPE assuming the low..high range fits.  */
  lowtree = SymbolConversion_Mod2Gcc (low);
  hightree = SymbolConversion_Mod2Gcc (high);
  if ((m2expr_CompareTrees (lowtree, m2expr_GetIntegerZero (location))) >= 0)
    {
      /* avoid dangling else.  */
      /* low..high is always positive, can we use unsigned int?  */
      m2high = m2type_GetMaxFrom (location, m2type_GetM2CardinalType ());
      if ((m2expr_CompareTrees (hightree, m2high)) <= 0)
        {
          return m2type_GetM2CardinalType ();
        }
    }
  else
    {
      /* Must be a signed subrange base, can we use int?  */
      m2high = m2type_GetMaxFrom (location, m2type_GetM2IntegerType ());
      m2low = m2type_GetMinFrom (location, m2type_GetM2IntegerType ());
      if (((m2expr_CompareTrees (lowtree, m2low)) >= 0) && ((m2expr_CompareTrees (hightree, m2high)) <= 0))
        {
          return m2type_GetM2IntegerType ();
        }
    }
  /* Fall back to the ZType.  */
  return type;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareSubrange - declare a subrange type.
*/

static tree DeclareSubrange (unsigned int sym)
{
  tree type;
  tree gccsym;
  unsigned int align;
  unsigned int high;
  unsigned int low;
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  SymbolTable_GetSubrange (sym, &high, &low);
  align = SymbolTable_GetAlignment (sym);
  type = SymbolConversion_Mod2Gcc (SymbolTable_GetSType (sym));
  if (align != SymbolTable_NulSym)
    {
      if (m2expr_AreConstantsEqual (m2expr_GetIntegerZero (location), SymbolConversion_Mod2Gcc (align)))
        {
          type = m2type_BuildSmallestTypeRange (location, SymbolConversion_Mod2Gcc (low), SymbolConversion_Mod2Gcc (high));
        }
      else
        {
          M2MetaError_MetaError1 ((const char *) "a non-zero alignment in a subrange type {%1Wa} is currently not implemented and will be ignored", 95, sym);
        }
    }
  else if ((SymbolTable_GetSType (sym)) == M2Base_ZType)
    {
      /* avoid dangling else.  */
      /* Can we narrow the ZType subrange to CARDINAL or INTEGER?  */
      type = DeclareSubrangeNarrow (location, high, low, type);
    }
  gccsym = m2type_BuildSubrangeType (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (sym))), type, SymbolConversion_Mod2Gcc (low), SymbolConversion_Mod2Gcc (high));
  return gccsym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IncludeGetNth -
*/

static void IncludeGetNth (Lists_List l, unsigned int sym)
{
  unsigned int i;

  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " ListOfFields [", 15);
  i = 1;
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      if (i > 1)
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) ", ", 2);
        }
      Lists_IncludeItemIntoList (l, SymbolTable_GetNth (sym, i));
      PrintTerse (SymbolTable_GetNth (sym, i));
      i += 1;
    }
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "]", 1);
}


/*
   IncludeType -
*/

static void IncludeType (Lists_List l, unsigned int sym)
{
  unsigned int t;

  t = SymbolTable_GetSType (sym);
  if (t != SymbolTable_NulSym)
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " type [", 7);
      PrintTerse (t);
      Lists_IncludeItemIntoList (l, t);
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "]", 1);
      t = SymbolTable_GetVarBackEndType (sym);
      if (t != SymbolTable_NulSym)
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " gcc type [", 11);
          PrintTerse (t);
          Lists_IncludeItemIntoList (l, t);
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "]", 1);
        }
    }
}


/*
   IncludeSubscript -
*/

static void IncludeSubscript (Lists_List l, unsigned int sym)
{
  unsigned int t;

  t = SymbolTable_GetArraySubscript (sym);
  if (t != SymbolTable_NulSym)
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " subrange [", 11);
      PrintTerse (t);
      Lists_IncludeItemIntoList (l, t);
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "]", 1);
    }
}


/*
   PrintLocalSymbol -
*/

static void PrintLocalSymbol (unsigned int sym)
{
  PrintTerse (sym);
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) ", ", 2);
}


/*
   PrintLocalSymbols -
*/

static void PrintLocalSymbols (unsigned int sym)
{
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Local Symbols {", 15);
  SymbolTable_ForeachLocalSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) PrintLocalSymbol});
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "}", 1);
}


/*
   IncludeGetVarient -
*/

static void IncludeGetVarient (Lists_List l, unsigned int sym)
{
  if ((SymbolTable_GetVarient (sym)) != SymbolTable_NulSym)
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " Varient [", 10);
      PrintTerse (SymbolTable_GetVarient (sym));
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "]", 1);
      Lists_IncludeItemIntoList (l, SymbolTable_GetVarient (sym));
    }
}


/*
   IncludeUnbounded - includes the record component of an unbounded type.
*/

static void IncludeUnbounded (Lists_List l, unsigned int sym)
{
  if ((SymbolTable_GetUnboundedRecordType (sym)) != SymbolTable_NulSym)
    {
      Lists_IncludeItemIntoList (l, SymbolTable_GetUnboundedRecordType (sym));
    }
}


/*
   IncludePartialUnbounded - includes the type component of a partial unbounded symbol.
*/

static void IncludePartialUnbounded (Lists_List l, unsigned int sym)
{
  if ((SymbolTable_GetSType (sym)) != SymbolTable_NulSym)
    {
      Lists_IncludeItemIntoList (l, SymbolTable_GetSType (sym));
    }
}


/*
   PrintDeclared - prints out where, sym, was declared.
*/

static void PrintDeclared (unsigned int sym)
{
  DynamicStrings_String filename;
  unsigned int lineno;
  unsigned int tokenno;

  tokenno = SymbolTable_GetDeclaredMod (sym);
  filename = M2LexBuf_FindFileNameFromToken (tokenno, 0);
  lineno = M2LexBuf_TokenToLineNo (tokenno, 0);
  M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) " declared in %s:%d", 18, (const unsigned char *) &filename, (sizeof (filename)-1), (const unsigned char *) &lineno, (sizeof (lineno)-1));
}


/*
   PrintAlignment -
*/

static void PrintAlignment (unsigned int sym)
{
  unsigned int align;

  if (((((SymbolTable_IsRecord (sym)) || (SymbolTable_IsType (sym))) || (SymbolTable_IsRecordField (sym))) || (SymbolTable_IsPointer (sym))) || (SymbolTable_IsArray (sym)))
    {
      align = SymbolTable_GetAlignment (sym);
      if (align != SymbolTable_NulSym)
        {
          M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) " aligned [%d]", 13, (const unsigned char *) &align, (sizeof (align)-1));
        }
    }
}


/*
   IncludeGetParent -
*/

static void IncludeGetParent (Lists_List l, unsigned int sym)
{
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " Parent [", 9);
  Lists_IncludeItemIntoList (l, SymbolTable_GetParent (sym));
  PrintTerse (SymbolTable_GetParent (sym));
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "]", 1);
}


/*
   PrintDecl -
*/

static void PrintDecl (unsigned int sym)
{
  if (SymbolTable_IsDeclaredPackedResolved (sym))
    {
      if (SymbolTable_IsDeclaredPacked (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " packed", 7);
        }
      else
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " unpacked", 9);
        }
    }
  else
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " unknown if packed", 18);
    }
}


/*
   PrintScope - displays the scope and line number of declaration of symbol, sym.
*/

static void PrintScope (unsigned int sym)
{
  NameKey_Name name;
  unsigned int scope;
  unsigned int line;

  line = M2LexBuf_TokenToLineNo (SymbolTable_GetDeclaredMod (sym), 0);
  scope = SymbolTable_GetScope (sym);
  name = SymbolTable_GetSymName (scope);
  M2Printf_fprintf3 (M2LangDump_GetDumpFile (), (const char *) " scope %a:%d %d", 15, (const unsigned char *) &name, (sizeof (name)-1), (const unsigned char *) &line, (sizeof (line)-1), (const unsigned char *) &scope, (sizeof (scope)-1));
}


/*
   PrintKind -
*/

static void PrintKind (SymbolTable_ProcedureKind kind)
{
  DynamicStrings_String s;

  s = SymbolTable_GetProcedureKindDesc (kind);
  M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "%s", 2, (const unsigned char *) &s, (sizeof (s)-1));
  s = DynamicStrings_KillString (s);
}


/*
   PrintProcedureParameters -
*/

static void PrintProcedureParameters (unsigned int sym, SymbolTable_ProcedureKind kind)
{
  NameKey_Name typeName;
  NameKey_Name paramName;
  unsigned int p;
  unsigned int i;
  unsigned int n;
  unsigned int type;

  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " (", 2);
  n = SymbolTable_NoOfParam (sym, kind);
  i = 1;
  while (i <= n)
    {
      if (i > 1)
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "; ", 2);
        }
      if (SymbolTable_IsVarParam (sym, kind, i))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "VAR ", 4);
        }
      p = SymbolTable_GetNthParam (sym, kind, i);
      paramName = SymbolTable_GetSymName (p);
      type = SymbolTable_GetType (p);
      typeName = SymbolTable_GetSymName (type);
      if (SymbolTable_IsUnboundedParam (sym, kind, i))
        {
          M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "%a: ARRAY OF %a", 15, (const unsigned char *) &paramName, (sizeof (paramName)-1), (const unsigned char *) &typeName, (sizeof (typeName)-1));
        }
      else
        {
          M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "%a: %a", 6, (const unsigned char *) &paramName, (sizeof (paramName)-1), (const unsigned char *) &typeName, (sizeof (typeName)-1));
        }
      i += 1;
    }
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) ")", 1);
}


/*
   PrintProcedureReturnType -
*/

static void PrintProcedureReturnType (unsigned int sym)
{
  NameKey_Name typeName;

  if ((SymbolTable_GetType (sym)) != SymbolTable_NulSym)
    {
      typeName = SymbolTable_GetSymName (SymbolTable_GetType (sym));
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) " : %a", 5, (const unsigned char *) &typeName, (sizeof (typeName)-1));
    }
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " ;", 2);
}


/*
   PrintProcedure -
*/

static void PrintProcedure (unsigned int sym)
{
  NameKey_Name n;
  SymbolTable_ProcedureKind kind;

  n = SymbolTable_GetSymName (sym);
  M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsProcedure (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
  if (SymbolTable_IsProcedureReachable (sym))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " IsProcedureReachable", 21);
    }
  PrintScope (sym);
  if (SymbolTable_IsExtern (sym))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " extern", 7);
    }
  if (SymbolTable_IsPublic (sym))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " public", 7);
    }
  if (SymbolTable_IsCtor (sym))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " ctor", 5);
    }
  PrintDeclared (sym);
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "\\n", 2);
  for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "parameters ", 11);
      PrintKind (kind);
      if (SymbolTable_GetProcedureParametersDefined (sym, kind))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " defined", 8);
          PrintProcedureParameters (sym, kind);
          PrintProcedureReturnType (sym);
        }
      else
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " undefined", 10);
        }
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "\\n", 2);
    }
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " Associated proctype: ", 22);
  PrintProcType (SymbolTable_GetProcedureProcType (sym));
}


/*
   PrintProcTypeParameters -
*/

static void PrintProcTypeParameters (unsigned int sym)
{
  NameKey_Name typeName;
  unsigned int p;
  unsigned int i;
  unsigned int n;
  unsigned int type;

  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " (", 2);
  n = SymbolTable_NoOfParam (sym, SymbolTable_ProperProcedure);
  i = 1;
  while (i <= n)
    {
      if (i > 1)
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "; ", 2);
        }
      if (SymbolTable_IsVarParam (sym, SymbolTable_ProperProcedure, i))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "VAR ", 4);
        }
      p = SymbolTable_GetNthParam (sym, SymbolTable_ProperProcedure, i);
      type = SymbolTable_GetType (p);
      typeName = SymbolTable_GetSymName (type);
      if (SymbolTable_IsUnboundedParam (sym, SymbolTable_ProperProcedure, i))
        {
          M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "ARRAY OF %a", 11, (const unsigned char *) &typeName, (sizeof (typeName)-1));
        }
      else
        {
          M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "%a", 2, (const unsigned char *) &typeName, (sizeof (typeName)-1));
        }
      i += 1;
    }
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) ")", 1);
}


/*
   PrintProcType -
*/

static void PrintProcType (unsigned int sym)
{
  NameKey_Name n;

  n = SymbolTable_GetSymName (sym);
  M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsProcType (%a)", 22, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
  PrintScope (sym);
  PrintDeclared (sym);
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "\\n", 2);
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "parameters ", 11);
  PrintProcTypeParameters (sym);
  PrintProcedureReturnType (sym);
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "\\n", 2);
}


/*
   PrintString -
*/

static void PrintString (unsigned int sym)
{
  unsigned int len;
  unsigned int tokenno;

  if (SymbolTable_IsConstStringKnown (sym))
    {
      if (SymbolTable_IsConstStringM2 (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "a Modula-2 string", 17);
        }
      else if (SymbolTable_IsConstStringC (sym))
        {
          /* avoid dangling else.  */
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " a C string", 11);
        }
      else if (SymbolTable_IsConstStringM2nul (sym))
        {
          /* avoid dangling else.  */
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " a nul terminated Modula-2 string", 33);
        }
      else if (SymbolTable_IsConstStringCnul (sym))
        {
          /* avoid dangling else.  */
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " a nul terminated C string", 26);
        }
      tokenno = SymbolTable_GetDeclaredMod (sym);
      len = SymbolTable_GetStringLength (tokenno, sym);
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) " length %d", 10, (const unsigned char *) &len, (sizeof (len)-1));
    }
  else
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "is not currently known", 22);
    }
}


/*
   PrintVerboseFromList - prints the, i, th element in the list, l.
*/

static void PrintVerboseFromList (Lists_List l, unsigned int i)
{
  unsigned int type;
  unsigned int low;
  unsigned int high;
  unsigned int sym;
  NameKey_Name n;
  NameKey_Name n2;

  sym = static_cast<unsigned int> (Lists_GetItemFromList (l, i));
  n = SymbolTable_GetSymName (sym);
  if (SymbolTable_IsError (sym))
    {
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsError (%a)", 19, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsDefImp (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsDefImp (%a)", 20, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      if (SymbolTable_IsDefinitionForC (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "and IsDefinitionForC", 20);
        }
      if (SymbolTable_IsHiddenTypeDeclared (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " IsHiddenTypeDeclared", 21);
        }
      SymbolTable_ForeachProcedureDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) PrintProcedure});
    }
  else if (SymbolTable_IsModule (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsModule (%a)", 20, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      if (SymbolTable_IsModuleWithinProcedure (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " and IsModuleWithinProcedure", 28);
        }
    }
  else if (SymbolTable_IsInnerModule (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsInnerModule (%a)", 25, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsUnknown (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsUnknown (%a)", 21, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsType (%a)", 18, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      IncludeType (l, sym);
      PrintAlignment (sym);
    }
  else if (SymbolTable_IsProcedure (sym))
    {
      /* avoid dangling else.  */
      PrintProcedure (sym);
    }
  else if (SymbolTable_IsParameter (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsParameter (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      if ((SymbolTable_GetParameterShadowVar (sym)) == SymbolTable_NulSym)
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " no shadow local variable", 25);
        }
      else
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " shadow ", 8);
          /* PrintVerboseFromList(l, GetParameterShadowVar(sym))  */
          IncludeType (l, SymbolTable_GetParameterShadowVar (sym));
        }
      IncludeType (l, sym);
    }
  else if (SymbolTable_IsPointer (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsPointer (%a)", 21, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      IncludeType (l, sym);
      PrintAlignment (sym);
    }
  else if (SymbolTable_IsRecord (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsRecord (%a)", 20, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      PrintLocalSymbols (sym);
      IncludeGetNth (l, sym);
      PrintAlignment (sym);
      PrintDecl (sym);
    }
  else if (SymbolTable_IsVarient (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsVarient (%a)", 21, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      PrintDecl (sym);
      IncludeGetNth (l, sym);
      IncludeGetVarient (l, sym);
      IncludeGetParent (l, sym);
    }
  else if (SymbolTable_IsFieldVarient (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsFieldVarient (%a)", 26, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      PrintDecl (sym);
      IncludeGetNth (l, sym);
      IncludeGetVarient (l, sym);
      IncludeGetParent (l, sym);
    }
  else if (SymbolTable_IsFieldEnumeration (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsFieldEnumeration (%a)", 30, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsArray (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsArray (%a)", 19, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      IncludeSubscript (l, sym);
      IncludeType (l, sym);
      PrintAlignment (sym);
    }
  else if (SymbolTable_IsEnumeration (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsEnumeration (%a)", 25, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsSet (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsSet (%a)", 17, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      IncludeType (l, sym);
    }
  else if (SymbolTable_IsUnbounded (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsUnbounded (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      IncludeUnbounded (l, sym);
    }
  else if (SymbolTable_IsPartialUnbounded (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsPartialUnbounded (%a)", 30, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      IncludePartialUnbounded (l, sym);
    }
  else if (SymbolTable_IsRecordField (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsRecordField (%a)", 25, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      if (SymbolTable_IsRecordFieldAVarientTag (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " variant tag", 12);
        }
      IncludeType (l, sym);
      IncludeGetVarient (l, sym);
      IncludeGetParent (l, sym);
      PrintAlignment (sym);
      PrintDecl (sym);
    }
  else if (SymbolTable_IsProcType (sym))
    {
      /* avoid dangling else.  */
      PrintProcType (sym);
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsVar (%a) declared in ", 30, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      PrintScope (sym);
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "mode ", 5);
      switch (SymbolTable_GetMode (sym))
        {
          case SymbolTable_LeftValue:
            M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "l ", 2);
            break;

          case SymbolTable_RightValue:
            M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "r ", 2);
            break;

          case SymbolTable_ImmediateValue:
            M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "i ", 2);
            break;

          case SymbolTable_NoValue:
            M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "n ", 2);
            break;


          default:
            CaseException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2GCCDeclare.def", 20, 1);
            __builtin_unreachable ();
        }
      if (SymbolTable_IsTemporary (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "temporary ", 10);
        }
      if (SymbolTable_IsComponent (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "component ", 10);
        }
      if (SymbolTable_IsVarHeap (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "heap ", 5);
        }
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "\\n", 2);
      SymbolTable_PrintInitialized (sym);
      IncludeType (l, sym);
    }
  else if (SymbolTable_IsConst (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsConst (%a)", 19, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      if (SymbolTable_IsConstString (sym))
        {
          M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "  also IsConstString (%a)", 25, (const unsigned char *) &n, (sizeof (n)-1));
          PrintString (sym);
        }
      else if (SymbolTable_IsConstructor (sym))
        {
          /* avoid dangling else.  */
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " constant constructor ", 22);
          IncludeType (l, sym);
        }
      else if (SymbolTable_IsConstSet (sym))
        {
          /* avoid dangling else.  */
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " constant constructor set ", 26);
          IncludeType (l, sym);
        }
      else
        {
          /* avoid dangling else.  */
          IncludeType (l, sym);
        }
    }
  else if (SymbolTable_IsConstructor (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsConstructor (non constant) (%a)", 40, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      IncludeType (l, sym);
    }
  else if (SymbolTable_IsConstLit (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsConstLit (%a)", 22, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsDummy (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsDummy (%a)", 19, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsTemporary (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsTemporary (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsVarAParam (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsVarAParam (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsSubscript (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsSubscript (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsSubrange (sym))
    {
      /* avoid dangling else.  */
      SymbolTable_GetSubrange (sym, &high, &low);
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsSubrange (%a)", 22, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      if ((low != SymbolTable_NulSym) && (high != SymbolTable_NulSym))
        {
          type = SymbolTable_GetSType (sym);
          if (type != SymbolTable_NulSym)
            {
              IncludeType (l, sym);
              n = SymbolTable_GetSymName (type);
              M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) " %a", 3, (const unsigned char *) &n, (sizeof (n)-1));
            }
          n = SymbolTable_GetSymName (low);
          n2 = SymbolTable_GetSymName (high);
          M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "[%a..%a]", 8, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
        }
    }
  else if (SymbolTable_IsProcedureVariable (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsProcedureVariable (%a)", 31, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsProcedureNested (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsProcedureNested (%a)", 29, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsAModula2Type (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsAModula2Type (%a)", 26, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsObject (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsObject (%a)", 20, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsTuple (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsTuple (%a)", 19, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      low = SymbolTable_GetNth (sym, 1);
      high = SymbolTable_GetNth (sym, 2);
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "%d, %d\\n", 8, (const unsigned char *) &low, (sizeof (low)-1), (const unsigned char *) &high, (sizeof (high)-1));
    }
  else if (SymbolTable_IsGnuAsm (sym))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsGnuAsmVolatile (sym))
        {
          M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsGnuAsmVolatile (%a)", 28, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
        }
      else
        {
          M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsGnuAsm (%a)", 20, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
        }
    }
  else if (SymbolTable_IsComponent (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsComponent (%a) ", 24, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      i = 1;
      do {
        type = SymbolTable_GetNth (sym, i);
        if (type != SymbolTable_NulSym)
          {
            Lists_IncludeItemIntoList (l, type);
            n = SymbolTable_GetSymName (type);
            M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "[%a %d] ", 8, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &type, (sizeof (type)-1));
            i += 1;
          }
      } while (! (type == SymbolTable_NulSym));
    }
  if (SymbolTable_IsHiddenType (sym))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " IsHiddenType", 13);
    }
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "\\n", 2);
}


/*
   PrintVerbose - prints limited information about a symbol.
*/

static void PrintVerbose (unsigned int sym)
{
  Lists_List l;
  unsigned int i;

  Lists_InitList (&l);
  Lists_IncludeItemIntoList (l, sym);
  i = 1;
  while (i <= (Lists_NoOfItemsInList (l)))
    {
      PrintVerboseFromList (l, i);
      i += 1;
    }
  Lists_KillList (&l);
}


/*
   PrintTerse -
*/

static void PrintTerse (unsigned int sym)
{
  NameKey_Name n;

  n = SymbolTable_GetSymName (sym);
  if (SymbolTable_IsError (sym))
    {
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsError (%a)", 19, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsDefImp (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsDefImp (%a)", 20, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      if (SymbolTable_IsDefinitionForC (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "and IsDefinitionForC", 20);
        }
      if (SymbolTable_IsHiddenTypeDeclared (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " IsHiddenTypeDeclared", 21);
        }
    }
  else if (SymbolTable_IsModule (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsModule (%a)", 20, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      if (SymbolTable_IsModuleWithinProcedure (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " and IsModuleWithinProcedure", 28);
        }
    }
  else if (SymbolTable_IsInnerModule (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsInnerModule (%a)", 25, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsUnknown (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsUnknown (%a)", 21, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsType (%a)", 18, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsProcedure (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsProcedure (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
      if (SymbolTable_IsProcedureReachable (sym))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " and IsProcedureReachable", 25);
        }
    }
  else if (SymbolTable_IsParameter (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsParameter (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsPointer (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsPointer (%a)", 21, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsRecord (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsRecord (%a)", 20, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsVarient (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsVarient (%a)", 21, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsFieldVarient (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsFieldVarient (%a)", 26, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsFieldEnumeration (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsFieldEnumeration (%a)", 30, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsArray (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsArray (%a)", 19, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsEnumeration (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsEnumeration (%a)", 25, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsSet (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsSet (%a)", 17, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsUnbounded (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsUnbounded (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsRecordField (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsRecordField (%a)", 25, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsProcType (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsProcType (%a)", 22, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsVar (%a)", 17, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsConstString (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsConstString (%a)", 25, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsConst (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsConst (%a)", 19, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsConstLit (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsConstLit (%a)", 22, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsDummy (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsDummy (%a)", 19, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsTemporary (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsTemporary (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsVarAParam (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsVarAParam (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsSubscript (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsSubscript (%a)", 23, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsSubrange (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsSubrange (%a)", 22, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsProcedureVariable (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsProcedureVariable (%a)", 31, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsProcedureNested (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsProcedureNested (%a)", 29, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsAModula2Type (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsAModula2Type (%a)", 26, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsGnuAsm (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsGnuAsm (%a)", 20, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsImport (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsImport", 15, (const unsigned char *) &sym, (sizeof (sym)-1));
    }
  else if (SymbolTable_IsImportStatement (sym))
    {
      /* avoid dangling else.  */
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "sym %d IsImportStatement", 24, (const unsigned char *) &sym, (sizeof (sym)-1));
    }
  if (SymbolTable_IsHiddenType (sym))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " IsHiddenType", 13);
    }
}


/*
   CheckAlignment -
*/

static tree CheckAlignment (tree type, unsigned int sym)
{
  unsigned int align;

  align = SymbolTable_GetAlignment (sym);
  if (align != SymbolTable_NulSym)
    {
      M2ALU_PushInt (0);
      SymbolTable_PushValue (align);
      if (! (M2ALU_Equ (SymbolTable_GetDeclaredMod (sym))))
        {
          return m2type_SetAlignment (type, SymbolConversion_Mod2Gcc (SymbolTable_GetAlignment (sym)));
        }
    }
  return type;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckPragma -
*/

static tree CheckPragma (tree type, unsigned int sym)
{
  if (SymbolTable_IsDeclaredPacked (sym))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((SymbolTable_IsRecordField (sym)) || (SymbolTable_IsFieldVarient (sym)))
        {
          type = m2type_SetDeclPacked (type);
        }
      else if ((SymbolTable_IsRecord (sym)) || (SymbolTable_IsVarient (sym)))
        {
          /* avoid dangling else.  */
          type = m2type_SetTypePacked (type);
        }
    }
  return CheckAlignment (type, sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsZero - returns TRUE if symbol, sym, is zero.
*/

static bool IsZero (unsigned int sym)
{
  M2ALU_PushIntegerTree (SymbolConversion_Mod2Gcc (sym));
  M2ALU_PushInt (0);
  return M2ALU_Equ (SymbolTable_GetDeclaredMod (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetFieldPacked - sets Varient, VarientField and RecordField symbols
                    as packed.
*/

static void SetFieldPacked (unsigned int field)
{
  if (((SymbolTable_IsVarient (field)) || (SymbolTable_IsFieldVarient (field))) || (SymbolTable_IsRecordField (field)))
    {
      SymbolTable_PutDeclaredPacked (field, true);
    }
}


/*
   RecordPacked - indicates that record, sym, and its fields
                  are all packed.
*/

static void RecordPacked (unsigned int sym)
{
  SymbolTable_PutDeclaredPacked (sym, true);
  WalkRecordDependants (sym, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) SetFieldPacked});
}


/*
   SetFieldNotPacked - sets Varient, VarientField and RecordField symbols
                       as not packed.
*/

static void SetFieldNotPacked (unsigned int field)
{
  if (((SymbolTable_IsVarient (field)) || (SymbolTable_IsFieldVarient (field))) || (SymbolTable_IsRecordField (field)))
    {
      SymbolTable_PutDeclaredPacked (field, false);
    }
}


/*
   RecordNotPacked - indicates that record, sym, and its fields
                     are all not packed.
*/

static void RecordNotPacked (unsigned int sym)
{
  SymbolTable_PutDeclaredPacked (sym, false);
  WalkRecordDependants (sym, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) SetFieldNotPacked});
}


/*
   DetermineIfRecordPacked -
*/

static void DetermineIfRecordPacked (unsigned int sym)
{
  unsigned int defaultAlignment;

  defaultAlignment = SymbolTable_GetDefaultRecordFieldAlignment (sym);
  if ((defaultAlignment != SymbolTable_NulSym) && (IsZero (defaultAlignment)))
    {
      RecordPacked (sym);
    }
  else
    {
      RecordNotPacked (sym);
    }
}


/*
   DeclarePackedSubrange -
*/

static void DeclarePackedSubrange (unsigned int equiv, unsigned int sym)
{
  tree type;
  tree gccsym;
  unsigned int high;
  unsigned int low;
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  SymbolTable_GetSubrange (sym, &high, &low);
  type = m2type_BuildSmallestTypeRange (location, SymbolConversion_Mod2Gcc (low), SymbolConversion_Mod2Gcc (high));
  gccsym = m2type_BuildSubrangeType (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (sym))), type, SymbolConversion_Mod2Gcc (low), SymbolConversion_Mod2Gcc (high));
  SymbolConversion_AddModGcc (equiv, gccsym);
}


/*
   DeclarePackedSet -
*/

static void DeclarePackedSet (unsigned int equiv, unsigned int sym)
{
  tree highLimit;
  tree range;
  tree gccsym;
  unsigned int type;
  unsigned int high;
  unsigned int low;
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  M2Debug_Assert (SymbolTable_IsSet (sym));
  type = SymbolTable_GetDType (sym);
  low = M2GCCDeclare_GetTypeMin (type);
  high = M2GCCDeclare_GetTypeMax (type);
  highLimit = m2expr_BuildSub (location, SymbolConversion_Mod2Gcc (high), SymbolConversion_Mod2Gcc (low), false);
  /* --fixme-- we need to check that low <= WORDLENGTH.  */
  highLimit = m2expr_BuildLSL (location, m2expr_GetIntegerOne (location), highLimit, false);
  range = m2type_BuildSmallestTypeRange (location, m2expr_GetIntegerZero (location), highLimit);
  gccsym = m2type_BuildSubrangeType (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (sym))), range, m2expr_GetIntegerZero (location), highLimit);
  SymbolConversion_AddModGcc (equiv, gccsym);
}

static void DeclarePackedFieldEnumeration (unsigned int sym)
{
  unsigned int equiv;
  unsigned int type;
  tree field;
  tree enumlist;

  /* add relationship between gccSym and sym  */
  type = SymbolTable_GetSType (sym);
  equiv = SymbolTable_GetPackedEquivalent (type);
  enumlist = GetEnumList (equiv);
  SymbolTable_PushValue (sym);
  field = DeclareFieldValue (sym, M2ALU_PopIntegerTree (), &enumlist);
  M2Debug_Assert (field != NULL);
  PutEnumList (equiv, enumlist);
}


/*
   DeclarePackedEnumeration -
*/

static void DeclarePackedEnumeration (unsigned int equiv, unsigned int sym)
{
  tree enumlist;
  tree gccenum;
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  gccenum = m2type_BuildStartEnumeration (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (sym))), true);
  SymbolTable_ForeachLocalSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DeclarePackedFieldEnumeration});
  enumlist = GetEnumList (equiv);
  gccenum = m2type_BuildEndEnumeration (location, gccenum, enumlist);
  SymbolConversion_AddModGcc (equiv, gccenum);
}


/*
   DeclarePackedType -
*/

static void DeclarePackedType (unsigned int equiv, unsigned int sym)
{
  unsigned int type;

  type = SymbolTable_GetSType (sym);
  if (type == SymbolTable_NulSym)
    {
      if (sym == M2Base_Boolean)
        {
          SymbolConversion_AddModGcc (equiv, m2type_GetPackedBooleanType ());
        }
      else
        {
          SymbolConversion_AddModGcc (equiv, SymbolConversion_Mod2Gcc (sym));
        }
    }
  else
    {
      DeclarePackedType (SymbolTable_GetPackedEquivalent (type), type);
      SymbolConversion_AddModGcc (equiv, SymbolConversion_Mod2Gcc (SymbolTable_GetPackedEquivalent (type)));
    }
}


/*
   doDeclareEquivalent -
*/

static tree doDeclareEquivalent (unsigned int sym, M2GCCDeclare_doDeclareProcedure p)
{
  unsigned int equiv;

  equiv = SymbolTable_GetPackedEquivalent (sym);
  if (! (SymbolConversion_GccKnowsAbout (equiv)))
    {
      (*p.proc) (equiv, sym);
      Sets_IncludeElementIntoSet (GlobalGroup->FullyDeclared, equiv);
    }
  return SymbolConversion_Mod2Gcc (equiv);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PossiblyPacked -
*/

static tree PossiblyPacked (unsigned int sym, bool isPacked)
{
  if (isPacked)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsSubrange (sym))
        {
          return doDeclareEquivalent (sym, (M2GCCDeclare_doDeclareProcedure) {(M2GCCDeclare_doDeclareProcedure_t) DeclarePackedSubrange});
        }
      else if (SymbolTable_IsType (sym))
        {
          /* avoid dangling else.  */
          return doDeclareEquivalent (sym, (M2GCCDeclare_doDeclareProcedure) {(M2GCCDeclare_doDeclareProcedure_t) DeclarePackedType});
        }
      else if (SymbolTable_IsEnumeration (sym))
        {
          /* avoid dangling else.  */
          return doDeclareEquivalent (sym, (M2GCCDeclare_doDeclareProcedure) {(M2GCCDeclare_doDeclareProcedure_t) DeclarePackedEnumeration});
        }
      else if (SymbolTable_IsSet (sym))
        {
          /* avoid dangling else.  */
          return doDeclareEquivalent (sym, (M2GCCDeclare_doDeclareProcedure) {(M2GCCDeclare_doDeclareProcedure_t) DeclarePackedSet});
        }
    }
  return SymbolConversion_Mod2Gcc (sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetPackedType - returns a possibly packed type for field.
*/

static tree GetPackedType (unsigned int sym)
{
  if (SymbolTable_IsSubrange (sym))
    {
      return doDeclareEquivalent (sym, (M2GCCDeclare_doDeclareProcedure) {(M2GCCDeclare_doDeclareProcedure_t) DeclarePackedSubrange});
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      return doDeclareEquivalent (sym, (M2GCCDeclare_doDeclareProcedure) {(M2GCCDeclare_doDeclareProcedure_t) DeclarePackedType});
    }
  else if (SymbolTable_IsEnumeration (sym))
    {
      /* avoid dangling else.  */
      return doDeclareEquivalent (sym, (M2GCCDeclare_doDeclareProcedure) {(M2GCCDeclare_doDeclareProcedure_t) DeclarePackedEnumeration});
    }
  return SymbolConversion_Mod2Gcc (sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MaybeAlignField - checks to see whether, field, is packed or aligned and it updates
                     the offsets if appropriate.
*/

static tree MaybeAlignField (unsigned int field, tree *byteOffset, tree *bitOffset)
{
  tree f;
  tree ftype;
  tree nbits;
  location_t location;

  f = SymbolConversion_Mod2Gcc (field);
  if (SymbolTable_IsDeclaredPacked (field))
    {
      location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (field));
      f = m2type_SetDeclPacked (f);
      ftype = GetPackedType (SymbolTable_GetSType (field));
      nbits = m2expr_BuildTBitSize (location, ftype);
      f = m2type_SetRecordFieldOffset (f, (*byteOffset), (*bitOffset), ftype, nbits);
      (*bitOffset) = m2expr_BuildAdd (location, (*bitOffset), nbits, false);
      return f;
    }
  else
    {
      return CheckAlignment (f, field);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareRecord - declares a record and its fields to gcc.
                   The final gcc record type is returned.
*/

static tree DeclareRecord (unsigned int Sym)
{
  unsigned int Field;
  unsigned int i;
  tree nbits;
  tree ftype;
  tree field;
  tree byteOffset;
  tree bitOffset;
  tree FieldList;
  tree RecordType;
  location_t location;

  i = 1;
  FieldList = (tree) (NULL);
  RecordType = DoStartDeclaration (Sym, (M2GCCDeclare_StartProcedure) {(M2GCCDeclare_StartProcedure_t) m2type_BuildStartRecord});
  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (Sym));
  byteOffset = m2expr_GetIntegerZero (location);
  bitOffset = m2expr_GetIntegerZero (location);
  do {
    Field = SymbolTable_GetNth (Sym, i);
    if (Field != SymbolTable_NulSym)
      {
        /* avoid gcc warning by using compound statement even if not strictly necessary.  */
        if (((SymbolTable_IsRecordField (Field)) && (SymbolTable_IsRecordFieldAVarientTag (Field))) && ((SymbolTable_GetSymName (Field)) == NameKey_NulName))
          {}  /* empty.  */
        /* do not include a nameless tag into the C struct  */
        else if (SymbolTable_IsVarient (Field))
          {
            /* avoid dangling else.  */
            Field = Chained (Field);
            field = SymbolConversion_Mod2Gcc (Field);
            if (SymbolTable_IsDeclaredPacked (Field))
              {
                location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (Field));
                field = m2type_SetDeclPacked (field);
                ftype = GetPackedType (SymbolTable_GetSType (Field));
                nbits = m2expr_BuildTBitSize (location, ftype);
                field = m2type_SetRecordFieldOffset (field, byteOffset, bitOffset, ftype, nbits);
                bitOffset = m2expr_BuildAdd (location, bitOffset, nbits, false);
                byteOffset = m2expr_BuildAdd (location, byteOffset, m2expr_BuildDivTrunc (location, bitOffset, m2decl_BuildIntegerConstant (8), false), false);
                bitOffset = m2expr_BuildModTrunc (location, bitOffset, m2decl_BuildIntegerConstant (8), false);
              }
            FieldList = m2type_ChainOn (FieldList, field);
          }
        else
          {
            /* avoid dangling else.  */
            if (Debugging)
              {
                M2Printf_printf0 ((const char *) "chaining ", 9);
                PrintTerse (Field);
                M2Printf_printf0 ((const char *) "\\n", 2);
              }
            FieldList = m2type_ChainOn (FieldList, MaybeAlignField (Chained (Field), &byteOffset, &bitOffset));
          }
      }
    i += 1;
  } while (! (Field == SymbolTable_NulSym));
  WatchRemoveList (Sym, M2GCCDeclare_partiallydeclared);
  WatchRemoveList (Sym, M2GCCDeclare_heldbyalignment);
  WatchRemoveList (Sym, M2GCCDeclare_finishedalignment);
  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (Sym));
  return m2type_BuildEndRecord (location, RecordType, FieldList, SymbolTable_IsDeclaredPacked (Sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareRecordField -
*/

static tree DeclareRecordField (unsigned int sym)
{
  tree field;
  tree GccFieldType;
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  GccFieldType = PossiblyPacked (SymbolTable_GetSType (sym), SymbolTable_IsDeclaredPacked (sym));
  field = m2type_BuildFieldRecord (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (sym))), GccFieldType);
  return field;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareVarient - declares a record and its fields to gcc.
                    The final gcc record type is returned.
*/

static tree DeclareVarient (unsigned int sym)
{
  unsigned int Field;
  unsigned int i;
  tree byteOffset;
  tree bitOffset;
  tree FieldList;
  tree VarientType;
  location_t location;

  i = 1;
  FieldList = (tree) (NULL);
  VarientType = DoStartDeclaration (sym, (M2GCCDeclare_StartProcedure) {(M2GCCDeclare_StartProcedure_t) m2type_BuildStartVarient});
  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  byteOffset = m2expr_GetIntegerZero (location);
  bitOffset = m2expr_GetIntegerZero (location);
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      Field = SymbolTable_GetNth (sym, i);
      if (((SymbolTable_IsRecordField (Field)) && (SymbolTable_IsRecordFieldAVarientTag (Field))) && ((SymbolTable_GetSymName (Field)) == NameKey_NulName))
        {}  /* empty.  */
      else
        {
          /* do not include a nameless tag into the C struct  */
          if (Debugging)
            {
              M2Printf_printf0 ((const char *) "chaining ", 9);
              PrintTerse (Field);
              M2Printf_printf0 ((const char *) "\\n", 2);
            }
          FieldList = m2type_ChainOn (FieldList, MaybeAlignField (Chained (Field), &byteOffset, &bitOffset));
        }
      i += 1;
    }
  WatchRemoveList (sym, M2GCCDeclare_partiallydeclared);
  WatchRemoveList (sym, M2GCCDeclare_heldbyalignment);
  WatchRemoveList (sym, M2GCCDeclare_finishedalignment);
  VarientType = m2type_BuildEndVarient (location, VarientType, FieldList, SymbolTable_IsDeclaredPacked (sym));
  return VarientType;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareFieldVarient -
*/

static tree DeclareFieldVarient (unsigned int sym)
{
  unsigned int i;
  unsigned int f;
  tree VarientList;
  tree VarientType;
  tree byteOffset;
  tree bitOffset;
  tree GccFieldType;
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  i = 1;
  VarientList = (tree) (NULL);
  VarientType = DoStartDeclaration (sym, (M2GCCDeclare_StartProcedure) {(M2GCCDeclare_StartProcedure_t) m2type_BuildStartFieldVarient});
  /* no need to store the [sym, RecordType] tuple as it is stored by DeclareRecord which calls us  */
  byteOffset = m2expr_GetIntegerZero (location);
  bitOffset = m2expr_GetIntegerZero (location);
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      f = SymbolTable_GetNth (sym, i);
      if ((SymbolTable_IsFieldVarient (f)) && (SymbolTable_IsEmptyFieldVarient (f)))
        {}  /* empty.  */
      else
        {
          /* do not include empty varient fields (created via 'else end' in variant records  */
          if (Debugging)
            {
              M2Printf_printf0 ((const char *) "chaining ", 9);
              PrintTerse (f);
              M2Printf_printf0 ((const char *) "\\n", 2);
            }
          VarientList = m2type_ChainOn (VarientList, MaybeAlignField (Chained (f), &byteOffset, &bitOffset));
        }
      i += 1;
    }
  WatchRemoveList (sym, M2GCCDeclare_partiallydeclared);
  GccFieldType = m2type_BuildEndFieldVarient (location, VarientType, VarientList, SymbolTable_IsDeclaredPacked (sym));
  return GccFieldType;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclarePointer - declares a pointer type to gcc and returns the Tree.
*/

static tree DeclarePointer (unsigned int sym)
{
  return m2type_BuildPointerType (SymbolConversion_Mod2Gcc (SymbolTable_GetSType (sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareUnbounded - builds an unbounded type and returns the gcc tree.
*/

static tree DeclareUnbounded (unsigned int sym)
{
  unsigned int record;

  M2Debug_Assert (SymbolTable_IsUnbounded (sym));
  if (SymbolConversion_GccKnowsAbout (sym))
    {
      return SymbolConversion_Mod2Gcc (sym);
    }
  else
    {
      record = SymbolTable_GetUnboundedRecordType (sym);
      M2Debug_Assert (SymbolTable_IsRecord (record));
      M2Debug_Assert (AllDependantsFullyDeclared (record));
      if (! (SymbolConversion_GccKnowsAbout (record)))
        {
          DeclareTypeConstFully (record);
          WatchRemoveList (record, M2GCCDeclare_todolist);
        }
      return SymbolConversion_Mod2Gcc (record);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildIndex -
*/

static tree BuildIndex (unsigned int tokenno, unsigned int array)
{
  unsigned int Subscript;
  unsigned int Type;
  unsigned int High;
  unsigned int Low;
  tree n;
  tree low;
  tree high;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  Subscript = SymbolTable_GetArraySubscript (array);
  M2Debug_Assert (SymbolTable_IsSubscript (Subscript));
  Type = SymbolTable_GetDType (Subscript);
  Low = M2GCCDeclare_GetTypeMin (Type);
  High = M2GCCDeclare_GetTypeMax (Type);
  M2GCCDeclare_DeclareConstant (tokenno, Low);
  M2GCCDeclare_DeclareConstant (tokenno, High);
  low = SymbolConversion_Mod2Gcc (Low);
  high = SymbolConversion_Mod2Gcc (High);
  if (m2type_ExceedsTypeRange (m2type_GetIntegerType (), low, high))
    {
      location = M2LexBuf_TokenToLocation (tokenno);
      n = m2convert_BuildConvert (location, m2type_GetIntegerType (), m2expr_BuildSub (location, high, low, false), false);
      if ((m2expr_TreeOverflow (n)) || (m2type_ValueOutOfTypeRange (m2type_GetIntegerType (), n)))
        {
          M2MetaError_MetaError3 ((const char *) "implementation restriction, array is too large {%1EDM}, the range {%2ad}..{%3ad} exceeds the integer range", 106, array, Low, High);
          return m2type_BuildArrayIndexType (m2expr_GetIntegerZero (location), m2expr_GetIntegerZero (location));
        }
      else
        {
          SymbolTable_PutArrayLarge (array);
          return m2type_BuildArrayIndexType (m2expr_GetIntegerZero (location), n);
        }
    }
  else
    {
      low = m2convert_BuildConvert (location, m2type_GetIntegerType (), low, false);
      high = m2convert_BuildConvert (location, m2type_GetIntegerType (), high, false);
      return m2type_BuildArrayIndexType (low, high);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareArray - declares an array to gcc and returns the gcc tree.
*/

static tree DeclareArray (unsigned int Sym)
{
  unsigned int typeOfArray;
  tree ArrayType;
  tree GccArray;
  tree GccIndex;
  unsigned int Subscript;
  unsigned int tokenno;
  location_t location;

  M2Debug_Assert (SymbolTable_IsArray (Sym));
  tokenno = SymbolTable_GetDeclaredMod (Sym);
  location = M2LexBuf_TokenToLocation (tokenno);
  Subscript = SymbolTable_GetArraySubscript (Sym);
  typeOfArray = SymbolTable_GetDType (Sym);
  GccArray = SymbolConversion_Mod2Gcc (typeOfArray);
  GccIndex = BuildIndex (tokenno, Sym);
  if (SymbolConversion_GccKnowsAbout (Sym))
    {
      ArrayType = SymbolConversion_Mod2Gcc (Sym);
    }
  else
    {
      ArrayType = m2type_BuildStartArrayType (GccIndex, GccArray, static_cast<int> (typeOfArray));
      PreAddModGcc (Sym, ArrayType);
    }
  PreAddModGcc (Subscript, GccArray);  /* we save the type of this array as the subscript  */
  M2ALU_PushIntegerTree (m2expr_BuildSize (location, GccArray, false));  /* and the size of this array so far  */
  SymbolTable_PopSize (Subscript);  /* and the size of this array so far  */
  GccArray = m2type_BuildEndArrayType (ArrayType, GccArray, GccIndex, static_cast<int> (typeOfArray));
  M2Debug_Assert (GccArray == ArrayType);
  return GccArray;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareProcType - declares a procedure type to gcc and returns the gcc type tree.
*/

static tree DeclareProcType (unsigned int Sym)
{
  unsigned int i;
  unsigned int p;
  unsigned int Parameter;
  unsigned int ReturnType;
  tree func;
  tree GccParam;
  location_t location;

  ReturnType = SymbolTable_GetSType (Sym);
  func = DoStartDeclaration (Sym, (M2GCCDeclare_StartProcedure) {(M2GCCDeclare_StartProcedure_t) m2type_BuildStartFunctionType});
  m2type_InitFunctionTypeParameters ();
  p = SymbolTable_NoOfParamAny (Sym);
  i = p;
  while (i > 0)
    {
      Parameter = SymbolTable_GetNthParamAny (Sym, i);
      location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (Parameter));
      GccParam = m2type_BuildProcTypeParameterDeclaration (location, SymbolConversion_Mod2Gcc (SymbolTable_GetSType (Parameter)), SymbolTable_IsVarParamAny (Sym, i));
      PreAddModGcc (Parameter, GccParam);
      i -= 1;
    }
  if (ReturnType == SymbolTable_NulSym)
    {
      return m2type_BuildEndFunctionType (func, NULL, SymbolTable_UsesVarArgs (Sym));
    }
  else
    {
      return m2type_BuildEndFunctionType (func, SymbolConversion_Mod2Gcc (ReturnType), SymbolTable_UsesVarArgs (Sym));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FindMinMaxEnum - finds the minimum and maximum enumeration fields.
*/

static void FindMinMaxEnum (unsigned int field)
{
  if (MaxEnumerationField == SymbolTable_NulSym)
    {
      MaxEnumerationField = static_cast<unsigned int> (field);
    }
  else
    {
      SymbolTable_PushValue (field);
      SymbolTable_PushValue (MaxEnumerationField);
      if (M2ALU_Gre (SymbolTable_GetDeclaredMod (field)))
        {
          MaxEnumerationField = static_cast<unsigned int> (field);
        }
    }
  if (MinEnumerationField == SymbolTable_NulSym)
    {
      MinEnumerationField = static_cast<unsigned int> (field);
    }
  else
    {
      SymbolTable_PushValue (field);
      SymbolTable_PushValue (MinEnumerationField);
      if (M2ALU_Less (SymbolTable_GetDeclaredMod (field)))
        {
          MinEnumerationField = static_cast<unsigned int> (field);
        }
    }
}


/*
   PushNoOfBits - pushes the integer value of the number of bits required
                  to maintain a set of type.
*/

static void PushNoOfBits (unsigned int type, unsigned int low, unsigned int high)
{
  SymbolTable_PushValue (high);
  M2ALU_ConvertToType (type);
  SymbolTable_PushValue (low);
  M2ALU_ConvertToType (type);
  M2ALU_Sub ();
  M2ALU_ConvertToType (M2Base_Cardinal);
}


/*
   DeclareLargeSet - n is the name of the set.
                     type is the subrange type (or simple type)
                     low and high are the limits of the subrange.
*/

static tree DeclareLargeSet (NameKey_Name n, unsigned int type, unsigned int low, unsigned int high)
{
  tree lowtree;
  tree hightree;
  tree BitsInSet;
  tree RecordType;
  tree GccField;
  tree FieldList;
  unsigned int bpw;
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (type));
  bpw = m2decl_GetBitsPerBitset ();
  SymbolTable_PushValue (low);
  lowtree = M2ALU_PopIntegerTree ();
  SymbolTable_PushValue (high);
  hightree = M2ALU_PopIntegerTree ();
  FieldList = (tree) (NULL);
  RecordType = m2type_BuildStartRecord (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (n)));  /* no problem with recursive types here  */
  PushNoOfBits (type, low, high);  /* no problem with recursive types here  */
  M2ALU_PushCard (1);
  M2ALU_Addn ();
  BitsInSet = M2ALU_PopIntegerTree ();
  M2ALU_PushIntegerTree (BitsInSet);
  M2ALU_PushCard (0);
  while (M2ALU_Gre (SymbolTable_GetDeclaredMod (type)))
    {
      M2ALU_PushIntegerTree (BitsInSet);
      M2ALU_PushCard (bpw-1);
      if (M2ALU_GreEqu (SymbolTable_GetDeclaredMod (type)))
        {
          M2ALU_PushIntegerTree (lowtree);
          M2ALU_PushCard (bpw-1);
          M2ALU_Addn ();
          GccField = m2type_BuildFieldRecord (location, NULL, m2type_BuildSetType (location, NULL, SymbolConversion_Mod2Gcc (type), lowtree, M2ALU_PopIntegerTree (), false));
          M2ALU_PushIntegerTree (lowtree);
          M2ALU_PushCard (bpw);
          M2ALU_Addn ();
          lowtree = M2ALU_PopIntegerTree ();
          M2ALU_PushIntegerTree (BitsInSet);
          M2ALU_PushCard (bpw);
          M2ALU_Sub ();
          BitsInSet = M2ALU_PopIntegerTree ();
        }
      else
        {
          /* printf2('range is %a..%a
          ', GetSymName(low), GetSymName(high)) ;  */
          GccField = m2type_BuildFieldRecord (location, NULL, m2type_BuildSetType (location, NULL, SymbolConversion_Mod2Gcc (type), lowtree, hightree, false));
          M2ALU_PushCard (0);
          BitsInSet = M2ALU_PopIntegerTree ();
        }
      FieldList = m2type_ChainOn (FieldList, GccField);
      M2ALU_PushIntegerTree (BitsInSet);
      M2ALU_PushCard (0);
    }
  return m2type_BuildEndRecord (location, RecordType, FieldList, false);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareLargeOrSmallSet - works out whether the set will exceed TSIZE(WORD). If it does
                            we manufacture a set using:

                            settype = RECORD
                                         w1: SET OF [...]
                                         w2: SET OF [...]
                                      END

                            We do this as GCC and GDB (stabs) only knows about WORD sized sets.
                            If the set will fit into a WORD then we call gccgm2 directly.
*/

static tree DeclareLargeOrSmallSet (unsigned int sym, NameKey_Name n, unsigned int type, unsigned int low, unsigned int high)
{
  location_t location;
  bool packed;

  PushNoOfBits (type, low, high);
  M2ALU_PushCard (static_cast<unsigned int> (m2decl_GetBitsPerBitset ()));
  packed = SymbolTable_IsSetPacked (sym);
  if (M2ALU_Less (SymbolTable_GetDeclaredMod (type)))
    {
      location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
      /* PutSetSmall(sym) ;  */
      return m2type_BuildSetType (location, reinterpret_cast <char * > (NameKey_KeyToCharStar (n)), SymbolConversion_Mod2Gcc (type), SymbolConversion_Mod2Gcc (low), SymbolConversion_Mod2Gcc (high), packed);
    }
  else
    {
      return DeclareLargeSet (n, type, low, high);  /* --fixme-- finish packed here as well.  */
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareSet - declares a set type to gcc and returns a Tree.
*/

static tree DeclareSet (unsigned int sym)
{
  tree gccsym;
  unsigned int type;
  unsigned int high;
  unsigned int low;

  type = SymbolTable_GetDType (sym);
  if (SymbolTable_IsSubrange (type))
    {
      SymbolTable_GetSubrange (type, &high, &low);
      gccsym = DeclareLargeOrSmallSet (sym, M2AsmUtil_GetFullSymName (sym), SymbolTable_GetSType (type), low, high);
    }
  else
    {
      gccsym = DeclareLargeOrSmallSet (sym, M2AsmUtil_GetFullSymName (sym), type, M2GCCDeclare_GetTypeMin (type), M2GCCDeclare_GetTypeMax (type));
    }
  return gccsym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckResolveSubrange - checks to see whether we can determine
                          the subrange type.  We are able to do
                          this once low, high and the type are known.
*/

static void CheckResolveSubrange (unsigned int sym)
{
  unsigned int tokenno;
  unsigned int size;
  unsigned int high;
  unsigned int low;
  unsigned int type;

  SymbolTable_GetSubrange (sym, &high, &low);
  tokenno = SymbolTable_GetDeclaredMod (sym);
  type = SymbolTable_GetSType (sym);
  if (type == SymbolTable_NulSym)
    {
      if ((SymbolConversion_GccKnowsAbout (low)) && (SymbolConversion_GccKnowsAbout (high)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if ((SymbolTable_IsConstString (low)) && (SymbolTable_IsConstStringKnown (low)))
            {
              size = SymbolTable_GetStringLength (tokenno, low);
              if (size <= 1)
                {
                  SymbolTable_PutSubrange (sym, low, high, M2Base_Char);
                }
              else
                {
                  M2MetaError_MetaError1 ((const char *) "cannot have a subrange of a string type {%1Uad}", 47, sym);
                }
            }
          else if (SymbolTable_IsFieldEnumeration (low))
            {
              /* avoid dangling else.  */
              if ((SymbolTable_GetSType (low)) == (SymbolTable_GetSType (high)))
                {
                  SymbolTable_PutSubrange (sym, low, high, SymbolTable_GetSType (low));
                }
              else
                {
                  M2MetaError_MetaError1 ((const char *) "subrange limits must be of the same type {%1Uad}", 48, sym);
                }
            }
          else if (SymbolTable_IsValueSolved (low))
            {
              /* avoid dangling else.  */
              if ((SymbolTable_GetSType (low)) == M2Base_LongReal)
                {
                  M2MetaError_MetaError1 ((const char *) "cannot have a subrange of a SHORTREAL, REAL or LONGREAL type {%1Uad}", 68, sym);
                }
              else
                {
                  SymbolTable_PutSubrange (sym, low, high, M2Base_MixTypes (SymbolTable_GetSType (low), SymbolTable_GetSType (high), SymbolTable_GetDeclaredMod (sym)));
                }
            }
        }
    }
}


/*
   TypeConstFullyDeclared - all, sym, dependents are declared, so create and
                            return the GCC Tree equivalent.
*/

static tree TypeConstFullyDeclared (unsigned int sym)
{
  tree t;

  if (SymbolTable_IsEnumeration (sym))
    {
      t = DeclareEnumeration (sym);
    }
  else if (SymbolTable_IsFieldEnumeration (sym))
    {
      /* avoid dangling else.  */
      t = DeclareFieldEnumeration (sym);
    }
  else if (SymbolTable_IsSubrange (sym))
    {
      /* avoid dangling else.  */
      t = DeclareSubrange (sym);
    }
  else if (SymbolTable_IsRecord (sym))
    {
      /* avoid dangling else.  */
      t = CheckPragma (DeclareRecord (sym), sym);
    }
  else if (SymbolTable_IsRecordField (sym))
    {
      /* avoid dangling else.  */
      t = CheckPragma (DeclareRecordField (sym), sym);
    }
  else if (SymbolTable_IsFieldVarient (sym))
    {
      /* avoid dangling else.  */
      t = DeclareFieldVarient (sym);
    }
  else if (SymbolTable_IsVarient (sym))
    {
      /* avoid dangling else.  */
      t = DeclareVarient (sym);
    }
  else if (SymbolTable_IsPointer (sym))
    {
      /* avoid dangling else.  */
      t = CheckAlignment (DeclarePointer (sym), sym);
    }
  else if (SymbolTable_IsUnbounded (sym))
    {
      /* avoid dangling else.  */
      t = DeclareUnbounded (sym);
    }
  else if (SymbolTable_IsArray (sym))
    {
      /* avoid dangling else.  */
      t = CheckAlignment (DeclareArray (sym), sym);
    }
  else if (SymbolTable_IsProcType (sym))
    {
      /* avoid dangling else.  */
      t = DeclareProcType (sym);
    }
  else if (SymbolTable_IsSet (sym))
    {
      /* avoid dangling else.  */
      t = DeclareSet (sym);
    }
  else if (SymbolTable_IsConst (sym))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConstructor (sym))
        {
          SymbolTable_PushValue (sym);
          M2ALU_ChangeToConstructor (SymbolTable_GetDeclaredMod (sym), SymbolTable_GetSType (sym));
          SymbolTable_PopValue (sym);
          M2ALU_EvaluateValue (sym);
          M2ALU_PutConstructorSolved (sym);
        }
      else if (SymbolTable_IsConstSet (sym))
        {
          /* avoid dangling else.  */
          M2ALU_EvaluateValue (sym);
        }
      if (! (SymbolTable_IsValueSolved (sym)))
        {
          return NULL;
        }
      t = DeclareConst (SymbolTable_GetDeclaredMod (sym), sym);
      M2Debug_Assert (t != NULL);
    }
  else if (SymbolTable_IsConstructor (sym))
    {
      /* avoid dangling else.  */
      /* not yet known as a constant  */
      return NULL;
    }
  else
    {
      /* avoid dangling else.  */
      t = DeclareType (sym);
      if (SymbolTable_IsType (sym))
        {
          t = CheckAlignment (t, sym);
        }
    }
  return m2block_RememberType (t);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsBaseType - returns true if a type, Sym, is a base type and
                we use predefined GDB information to represent this
                type.
*/

static bool IsBaseType (unsigned int Sym)
{
  return (((Sym == M2Base_Cardinal) || (Sym == M2Base_Integer)) || (Sym == M2Base_Char)) || (Sym == M2Base_Proc);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsFieldEnumerationDependants - sets enumDeps to FALSE if action(Sym)
                                  is also FALSE.
*/

static void IsFieldEnumerationDependants (unsigned int Sym)
{
  if (! ((*action.proc) (Sym)))
    {
      enumDeps = false;
    }
}


/*
   IsEnumerationDependants - returns true if the enumeration
                             p(dependants) all return true.
*/

static bool IsEnumerationDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  action = q;
  enumDeps = true;
  SymbolTable_ForeachLocalSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) IsFieldEnumerationDependants});
  return enumDeps;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkEnumerationDependants - returns walks all dependants of Sym.
*/

static void WalkEnumerationDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  SymbolTable_ForeachLocalSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) p.proc});
}


/*
   WalkSubrangeDependants - calls p(dependants) for each dependant of, sym.
*/

static void WalkSubrangeDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int type;
  unsigned int align;
  unsigned int high;
  unsigned int low;

  SymbolTable_GetSubrange (sym, &high, &low);
  CheckResolveSubrange (sym);
  type = SymbolTable_GetSType (sym);
  if (type != SymbolTable_NulSym)
    {
      (*p.proc) (type);
    }
  /* low and high are not types but constants and they are resolved by M2GenGCC  */
  (*p.proc) (low);
  (*p.proc) (high);
  align = SymbolTable_GetAlignment (sym);
  if (align != SymbolTable_NulSym)
    {
      (*p.proc) (align);
    }
}


/*
   IsSubrangeDependants - returns TRUE if the subrange
                          q(dependants) all return TRUE.
*/

static bool IsSubrangeDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  bool result;
  unsigned int align;
  unsigned int type;
  unsigned int high;
  unsigned int low;

  SymbolTable_GetSubrange (sym, &high, &low);
  /* low and high are not types but constants and they are resolved by M2GenGCC  */
  CheckResolveSubrange (sym);
  result = true;
  type = SymbolTable_GetSType (sym);
  if ((type == SymbolTable_NulSym) || (! ((*q.proc) (type))))
    {
      result = false;
    }
  if (! ((*q.proc) (low)))
    {
      result = false;
    }
  if (! ((*q.proc) (high)))
    {
      result = false;
    }
  align = SymbolTable_GetAlignment (sym);
  if ((align != SymbolTable_NulSym) && (! ((*q.proc) (align))))
    {
      result = false;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkComponentDependants -
*/

static void WalkComponentDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int i;
  unsigned int type;

  /* need to walk record and field  */
  i = 1;
  do {
    type = SymbolTable_GetNth (sym, i);
    if (type != SymbolTable_NulSym)
      {
        if (SymbolTable_IsVar (type))
          {
            (*p.proc) (SymbolTable_GetSType (type));
          }
        else
          {
            (*p.proc) (type);
          }
        i += 1;
      }
  } while (! (type == SymbolTable_NulSym));
}


/*
   IsComponentDependants -
*/

static bool IsComponentDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int type;
  unsigned int i;
  bool result;

  /* need to check record is completely resolved  */
  result = true;
  i = 1;
  do {
    type = SymbolTable_GetNth (sym, i);
    if (type != SymbolTable_NulSym)
      {
        if (SymbolTable_IsVar (type))
          {
            type = SymbolTable_GetSType (type);
          }
        if (! ((*q.proc) (type)))
          {
            result = false;
          }
        i += 1;
      }
  } while (! (type == SymbolTable_NulSym));
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkVarDependants - walks all dependants of sym.
*/

static void WalkVarDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int type;

  (*p.proc) (SymbolTable_GetSType (sym));
  if (SymbolTable_IsComponent (sym))
    {
      WalkComponentDependants (sym, p);
    }
  type = SymbolTable_GetVarBackEndType (sym);
  if (type != SymbolTable_NulSym)
    {
      (*p.proc) (type);
    }
}


/*
   IsVarDependants - returns TRUE if the pointer symbol, sym,
                     p(dependants) all return TRUE.
*/

static bool IsVarDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int type;
  bool result;

  result = true;
  if (! ((*q.proc) (SymbolTable_GetSType (sym))))
    {
      result = false;
    }
  if (SymbolTable_IsComponent (sym))
    {
      if (! (IsComponentDependants (sym, q)))
        {
          result = false;
        }
    }
  type = SymbolTable_GetVarBackEndType (sym);
  if (type != SymbolTable_NulSym)
    {
      if (! ((*q.proc) (type)))
        {
          result = false;
        }
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkPointerDependants - walks all dependants of sym.
*/

static void WalkPointerDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int align;

  (*p.proc) (SymbolTable_GetSType (sym));
  align = SymbolTable_GetAlignment (sym);
  if (align != SymbolTable_NulSym)
    {
      (*p.proc) (align);
    }
}


/*
   IsPointerDependants - returns TRUE if the pointer symbol, sym,
      	       	         p(dependants) all return TRUE.
*/

static bool IsPointerDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int align;
  bool final;

  final = true;
  if (! ((*q.proc) (SymbolTable_GetSType (sym))))
    {
      final = false;
    }
  align = SymbolTable_GetAlignment (sym);
  if (final && (align != SymbolTable_NulSym))
    {
      if (! ((*q.proc) (align)))
        {
          final = false;
        }
    }
  return final;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRecordAlignment -
*/

static bool IsRecordAlignment (unsigned int sym, M2GCCDeclare_IsAction q)
{
  if ((SymbolTable_GetDefaultRecordFieldAlignment (sym)) != SymbolTable_NulSym)
    {
      if (! ((*q.proc) (SymbolTable_GetDefaultRecordFieldAlignment (sym))))
        {
          return false;
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRecordDependants - returns TRUE if the symbol, sym,
                        q(dependants) all return TRUE.
*/

static bool IsRecordDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  bool result;
  unsigned int i;
  unsigned int field;

  result = IsRecordAlignment (sym, q);
  i = 1;
  do {
    field = SymbolTable_GetNth (sym, i);
    if (field != SymbolTable_NulSym)
      {
        /* avoid gcc warning by using compound statement even if not strictly necessary.  */
        if (SymbolTable_IsRecordField (field))
          {
            /* avoid dangling else.  */
            if ((! (SymbolTable_IsRecordFieldAVarientTag (field))) || ((SymbolTable_GetSymName (field)) != NameKey_NulName))
              {
                if (! ((*q.proc) (field)))
                  {
                    result = false;
                  }
              }
          }
        else if (SymbolTable_IsVarient (field))
          {
            /* avoid dangling else.  */
            if (! ((*q.proc) (field)))
              {
                result = false;
              }
          }
        else if (SymbolTable_IsFieldVarient (field))
          {
            /* avoid dangling else.  */
            M2Error_InternalError ((const char *) "should not see a field varient", 30);
          }
        else
          {
            /* avoid dangling else.  */
            M2Error_InternalError ((const char *) "unknown symbol in record", 24);
          }
      }
    i += 1;
  } while (! (field == SymbolTable_NulSym));
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkRecordAlignment - walks the alignment constant associated with
                         record, sym.
*/

static void WalkRecordAlignment (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  if ((SymbolTable_GetDefaultRecordFieldAlignment (sym)) != SymbolTable_NulSym)
    {
      (*p.proc) (SymbolTable_GetDefaultRecordFieldAlignment (sym));
    }
}


/*
   WalkRecordDependants - walks symbol, sym, dependants.  It only
                          walks the fields if the alignment is
                          unused or fully declared.
*/

static void WalkRecordDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  WalkRecordAlignment (sym, p);
  WalkRecordDependants2 (sym, p);
}


/*
   WalkRecordFieldDependants -
*/

static void WalkRecordFieldDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int v;
  unsigned int align;

  M2Debug_Assert (SymbolTable_IsRecordField (sym));
  (*p.proc) (SymbolTable_GetSType (sym));
  v = SymbolTable_GetVarient (sym);
  if (v != SymbolTable_NulSym)
    {
      (*p.proc) (v);
    }
  align = SymbolTable_GetAlignment (sym);
  if (align != SymbolTable_NulSym)
    {
      (*p.proc) (align);
    }
}


/*
   WalkRecordDependants2 - walks the fields of record, sym, calling
                           p on every dependant.
*/

static void WalkRecordDependants2 (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int i;
  unsigned int Field;

  i = 1;
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      Field = SymbolTable_GetNth (sym, i);
      (*p.proc) (Field);
      if (SymbolTable_IsRecordField (Field))
        {
          WalkRecordFieldDependants (Field, p);
        }
      else if (SymbolTable_IsVarient (Field))
        {
          /* avoid dangling else.  */
          WalkVarientDependants (Field, p);
        }
      else if (SymbolTable_IsFieldVarient (Field))
        {
          /* avoid dangling else.  */
          M2Error_InternalError ((const char *) "should not see a field varient", 30);
        }
      else
        {
          /* avoid dangling else.  */
          M2Error_InternalError ((const char *) "unknown symbol in record", 24);
        }
      i += 1;
    }
}


/*
   IsVarientAlignment -
*/

static bool IsVarientAlignment (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int align;

  sym = GetRecordOfVarient (sym);
  align = SymbolTable_GetDefaultRecordFieldAlignment (sym);
  if ((align != SymbolTable_NulSym) && (! ((*q.proc) (align))))
    {
      return false;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsVarientDependants - returns TRUE if the symbol, sym,
                         q(dependants) all return TRUE.
*/

static bool IsVarientDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  bool result;
  unsigned int i;
  unsigned int Field;

  result = IsVarientAlignment (sym, q);
  i = 1;
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      Field = SymbolTable_GetNth (sym, i);
      M2Debug_Assert (SymbolTable_IsFieldVarient (Field));
      if (! ((*q.proc) (Field)))
        {
          result = false;
        }
      i += 1;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkVarientAlignment -
*/

static void WalkVarientAlignment (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int align;

  sym = GetRecordOfVarient (sym);
  align = SymbolTable_GetDefaultRecordFieldAlignment (sym);
  if (align != SymbolTable_NulSym)
    {
      (*p.proc) (align);
    }
}


/*
   WalkVarientDependants - walks symbol, sym, dependants.
*/

static void WalkVarientDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int i;
  unsigned int v;
  unsigned int Field;

  WalkVarientAlignment (sym, p);
  if ((SymbolTable_GetSType (sym)) != SymbolTable_NulSym)
    {
      (*p.proc) (SymbolTable_GetSType (sym));
    }
  v = SymbolTable_GetVarient (sym);
  if (v != SymbolTable_NulSym)
    {
      (*p.proc) (v);
    }
  i = 1;
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      Field = SymbolTable_GetNth (sym, i);
      M2Debug_Assert (SymbolTable_IsFieldVarient (Field));  /* field varients do _not_ have a type  */
      (*p.proc) (Field);  /* field varients do _not_ have a type  */
      WalkVarientFieldDependants (Field, p);
      i += 1;
    }
}


/*
   IsVarientFieldDependants - returns TRUE if the symbol, sym,
                              q(dependants) all return TRUE.
*/

static bool IsVarientFieldDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int i;
  unsigned int type;
  unsigned int Field;
  bool result;

  i = 1;
  result = IsVarientAlignment (sym, q);
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      Field = SymbolTable_GetNth (sym, i);
      if (! ((*q.proc) (Field)))
        {
          result = false;
        }
      type = SymbolTable_GetSType (Field);
      if (type != SymbolTable_NulSym)
        {
          if (! ((*q.proc) (type)))
            {
              result = false;
            }
        }
      i += 1;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkVarientFieldDependants -
*/

static void WalkVarientFieldDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int i;
  unsigned int type;
  unsigned int Field;

  WalkVarientAlignment (sym, p);
  i = 1;
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      Field = SymbolTable_GetNth (sym, i);
      (*p.proc) (Field);
      type = SymbolTable_GetSType (Field);
      if (type != SymbolTable_NulSym)
        {
          (*p.proc) (type);
        }
      i += 1;
    }
}


/*
   IsArrayDependants - returns TRUE if the symbol, sym,
      	       	       q(dependants) all return TRUE.

*/

static bool IsArrayDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  bool result;
  unsigned int align;
  unsigned int subscript;
  unsigned int high;
  unsigned int low;
  unsigned int type;

  result = true;
  M2Debug_Assert (SymbolTable_IsArray (sym));
  type = SymbolTable_GetSType (sym);
  if (! ((*q.proc) (type)))
    {
      result = false;
    }
  subscript = SymbolTable_GetArraySubscript (sym);
  if (subscript != SymbolTable_NulSym)
    {
      M2Debug_Assert (SymbolTable_IsSubscript (subscript));
      type = SymbolTable_GetSType (subscript);
      if (! ((*q.proc) (type)))
        {
          result = false;
        }
      type = SymbolTable_SkipType (type);
      /* the array might be declared as ARRAY type OF foo  */
      low = M2GCCDeclare_GetTypeMin (type);
      high = M2GCCDeclare_GetTypeMax (type);
      if (! ((*q.proc) (low)))
        {
          result = false;
        }
      if (! ((*q.proc) (high)))
        {
          result = false;
        }
      align = SymbolTable_GetAlignment (sym);
      if ((align != SymbolTable_NulSym) && (! ((*q.proc) (align))))
        {
          result = false;
        }
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkArrayDependants - walks symbol, sym, dependants.
*/

static void WalkArrayDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int align;
  unsigned int subscript;
  unsigned int high;
  unsigned int low;
  unsigned int type;

  M2Debug_Assert (SymbolTable_IsArray (sym));
  type = SymbolTable_GetSType (sym);
  (*p.proc) (type);
  subscript = SymbolTable_GetArraySubscript (sym);
  if (subscript != SymbolTable_NulSym)
    {
      M2Debug_Assert (SymbolTable_IsSubscript (subscript));
      type = SymbolTable_GetSType (subscript);
      (*p.proc) (type);
      type = SymbolTable_SkipType (type);
      /* the array might be declared as ARRAY type OF foo  */
      low = M2GCCDeclare_GetTypeMin (type);
      high = M2GCCDeclare_GetTypeMax (type);
      (*p.proc) (low);
      (*p.proc) (high);
      align = SymbolTable_GetAlignment (sym);
      if (align != SymbolTable_NulSym)
        {
          (*p.proc) (align);
        }
    }
}


/*
   IsSetDependants - returns TRUE if the symbol, sym,
                     q(dependants) all return TRUE.
*/

static bool IsSetDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  bool result;
  unsigned int type;
  unsigned int low;
  unsigned int high;

  result = true;
  M2Debug_Assert (SymbolTable_IsSet (sym));
  type = SymbolTable_GetDType (sym);
  if (! ((*q.proc) (type)))
    {
      result = false;
    }
  low = M2GCCDeclare_GetTypeMin (type);
  high = M2GCCDeclare_GetTypeMax (type);
  if (! ((*q.proc) (low)))
    {
      result = false;
    }
  if (! ((*q.proc) (high)))
    {
      result = false;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkSetDependants - walks dependants, sym.
*/

static void WalkSetDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int type;
  unsigned int low;
  unsigned int high;

  M2Debug_Assert (SymbolTable_IsSet (sym));
  type = SymbolTable_GetDType (sym);
  (*p.proc) (type);
  low = M2GCCDeclare_GetTypeMin (type);
  (*p.proc) (low);
  high = M2GCCDeclare_GetTypeMax (type);
  (*p.proc) (high);
}


/*
   IsProcTypeDependants -
*/

static bool IsProcTypeDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int i;
  unsigned int p;
  unsigned int son;
  unsigned int ParamType;
  unsigned int ReturnType;
  bool result;

  result = true;
  M2Debug_Assert (SymbolTable_IsProcType (sym));
  i = 1;
  ReturnType = SymbolTable_GetSType (sym);
  p = SymbolTable_NoOfParamAny (sym);
  while (i <= p)
    {
      son = SymbolTable_GetNthParamAny (sym, i);
      ParamType = SymbolTable_GetSType (son);
      if (! ((*q.proc) (ParamType)))
        {
          result = false;
        }
      i += 1;
    }
  if ((ReturnType == SymbolTable_NulSym) || ((*q.proc) (ReturnType)))
    {
      return result;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkProcTypeDependants - walks dependants, sym.
*/

static void WalkProcTypeDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int i;
  unsigned int n;
  unsigned int son;
  unsigned int ParamType;
  unsigned int ReturnType;

  M2Debug_Assert (SymbolTable_IsProcType (sym));
  i = 1;
  ReturnType = SymbolTable_GetSType (sym);
  n = SymbolTable_NoOfParamAny (sym);
  while (i <= n)
    {
      son = SymbolTable_GetNthParamAny (sym, i);
      ParamType = SymbolTable_GetSType (son);
      (*p.proc) (ParamType);
      i += 1;
    }
  if (ReturnType != SymbolTable_NulSym)
    {
      (*p.proc) (ReturnType);
    }
}


/*
   IsProcedureDependants -
*/

static bool IsProcedureDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int i;
  unsigned int son;
  unsigned int type;
  unsigned int ReturnType;
  bool result;

  result = true;
  M2Debug_Assert (SymbolTable_IsProcedure (sym));
  i = 1;
  ReturnType = SymbolTable_GetSType (sym);
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      son = SymbolTable_GetNth (sym, i);
      type = SymbolTable_GetSType (son);
      if (! ((*q.proc) (type)))
        {
          result = false;
        }
      i += 1;
    }
  if ((ReturnType == SymbolTable_NulSym) || ((*q.proc) (ReturnType)))
    {
      return result;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkProcedureDependants - walks dependants, sym.
*/

static void WalkProcedureDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int i;
  unsigned int son;
  unsigned int type;
  unsigned int ReturnType;

  M2Debug_Assert (SymbolTable_IsProcedure (sym));
  i = 1;
  ReturnType = SymbolTable_GetSType (sym);
  while ((SymbolTable_GetNth (sym, i)) != SymbolTable_NulSym)
    {
      son = SymbolTable_GetNth (sym, i);
      type = SymbolTable_GetSType (son);
      (*p.proc) (type);
      i += 1;
    }
  if (ReturnType != SymbolTable_NulSym)
    {
      (*p.proc) (ReturnType);
    }
}


/*
   IsUnboundedDependants - returns TRUE if the symbol, sym,
                           q(dependants) all return TRUE.
*/

static bool IsUnboundedDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  bool result;

  result = true;
  if (! ((*q.proc) (SymbolTable_GetUnboundedRecordType (sym))))
    {
      result = false;
    }
  if (! ((*q.proc) (M2Base_Cardinal)))
    {
      result = false;
    }
  if (! ((*q.proc) (SymbolTable_GetSType (sym))))
    {
      result = false;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkUnboundedDependants - walks the dependants of, sym.
*/

static void WalkUnboundedDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  (*p.proc) (SymbolTable_GetUnboundedRecordType (sym));
  (*p.proc) (M2Base_Cardinal);
  (*p.proc) (SymbolTable_GetSType (sym));
}


/*
   IsTypeDependants - returns TRUE if all q(dependants) return
                      TRUE.
*/

static bool IsTypeDependants (unsigned int sym, M2GCCDeclare_IsAction q)
{
  unsigned int align;
  unsigned int type;
  bool final;

  type = SymbolTable_GetSType (sym);
  final = true;
  if ((type != SymbolTable_NulSym) && (! ((*q.proc) (type))))
    {
      final = false;
    }
  align = SymbolTable_GetAlignment (sym);
  if ((align != SymbolTable_NulSym) && (! ((*q.proc) (align))))
    {
      final = false;
    }
  return final;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkTypeDependants - walks all dependants of, sym.
*/

static void WalkTypeDependants (unsigned int sym, M2GCCDeclare_WalkAction p)
{
  unsigned int align;
  unsigned int type;

  type = SymbolTable_GetSType (sym);
  if (type != SymbolTable_NulSym)
    {
      (*p.proc) (type);
    }
  align = SymbolTable_GetAlignment (sym);
  if (align != SymbolTable_NulSym)
    {
      (*p.proc) (align);
    }
}


/*
   FoldConstants - a wrapper for ResolveConstantExpressions.
*/

extern "C" void M2GCCDeclare_FoldConstants (M2BasicBlock_BasicBlock bb)
{
  if (M2GenGCC_ResolveConstantExpressions ((M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) DeclareConstFully}, bb))
    {
      ConstantResolved = true;
    }
}


/*
   StartDeclareScope - declares types, variables associated with this scope.
*/

extern "C" void M2GCCDeclare_StartDeclareScope (unsigned int scope)
{
  NameKey_Name n;

  if (Debugging)
    {
      n = SymbolTable_GetSymName (scope);
      M2Printf_printf1 ((const char *) "declaring symbols in BLOCK %a\\n", 31, (const unsigned char *) &n, (sizeof (n)-1));
    }
  if (SymbolTable_IsProcedure (scope))
    {
      StartDeclareProcedureScope (scope);
    }
  else
    {
      StartDeclareModuleScope (scope);
    }
  if (Debugging)
    {
      n = SymbolTable_GetSymName (scope);
      M2Printf_printf1 ((const char *) "\\nEND declaring symbols in BLOCK %a\\n", 37, (const unsigned char *) &n, (sizeof (n)-1));
    }
}


/*
   EndDeclareScope -
*/

extern "C" void M2GCCDeclare_EndDeclareScope (void)
{
}


/*
   DeclareParameters -
*/

extern "C" void M2GCCDeclare_DeclareParameters (unsigned int sym)
{
  DeclareUnboundedProcedureParameters (sym);
}


/*
   DeclareConstant - checks to see whether, sym, is a constant and
                     declares the constant to gcc.
*/

extern "C" void M2GCCDeclare_DeclareConstant (unsigned int tokenno, unsigned int sym)
{
  unsigned int type;
  tree t;

  if (SymbolTable_IsConst (sym))
    {
      TraverseDependants (sym);
      type = SymbolTable_GetSType (sym);
      M2Debug_Assert ((type == SymbolTable_NulSym) || (M2GCCDeclare_CompletelyResolved (type)));
      M2Debug_Assert ((! (SymbolTable_IsConstructor (sym))) || (SymbolTable_IsConstructorConstant (sym)));
      M2Debug_Assert ((type != SymbolTable_NulSym) || (! ((SymbolTable_IsConstructor (sym)) || (SymbolTable_IsConstSet (sym)))));
      t = DeclareConst (tokenno, sym);
      M2Debug_Assert (t != NULL);
    }
}


/*
   DeclareConstructor - declares a constructor.
*/

extern "C" void M2GCCDeclare_DeclareConstructor (unsigned int tokenno, unsigned int quad, unsigned int sym)
{
  if (sym == SymbolTable_NulSym)
    {
      M2Error_InternalError ((const char *) "trying to declare the NulSym", 28);
    }
  if ((SymbolTable_IsConstructor (sym)) && (! (SymbolConversion_GccKnowsAbout (sym))))
    {
      WalkConstructor (sym, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) TraverseDependants});
      DeclareTypesConstantsProceduresInRange (SymbolTable_GetScope (sym), quad, quad);
      M2Debug_Assert (M2ALU_IsConstructorDependants (sym, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) IsFullyDeclared}));
      SymbolTable_PushValue (sym);
      DeclareConstantFromTree (sym, M2ALU_PopConstructorTree (tokenno));
    }
}


/*
   TryDeclareConstant - try and declare a constant.  If, sym, is a
                        constant try and declare it, if we cannot
                        then enter it into the to do list.
*/

extern "C" void M2GCCDeclare_TryDeclareConstant (unsigned int tokenno, unsigned int sym)
{
  unsigned int type;

  M2GCCDeclare_TryDeclareConstructor (tokenno, sym);
  if (SymbolTable_IsConst (sym))
    {
      TraverseDependants (sym);
      type = SymbolTable_GetSType (sym);
      if ((type != SymbolTable_NulSym) && (! (M2GCCDeclare_CompletelyResolved (type))))
        {
          TraverseDependants (sym);
          return;
        }
      if ((SymbolTable_IsConstructor (sym)) && (! (SymbolTable_IsConstructorConstant (sym))))
        {
          TraverseDependants (sym);
          return;
        }
      if (((SymbolTable_IsConstructor (sym)) || (SymbolTable_IsConstSet (sym))) && (type == SymbolTable_NulSym))
        {
          TraverseDependants (sym);
          return;
        }
      if (Sets_IsElementInSet (GlobalGroup->ToBeSolvedByQuads, sym))
        {
          /* we allow the above rules to be executed even if it is fully declared
            so to ensure that types of compiler builtin constants (BitsetSize
            etc) are fully declared.

            However at this point if, sym, is fully declared we return
  */
          if (IsFullyDeclared (sym))
            {
              return;
            }
          TraverseDependants (sym);
        }
      else
        {
          TryDeclareConst (tokenno, sym);
        }
    }
}


/*
   TryDeclareType - try and declare a type.  If sym is a
                    type try and declare it, if we cannot
                    then enter it into the to do list.
*/

extern "C" void M2GCCDeclare_TryDeclareType (unsigned int type)
{
  if ((type != SymbolTable_NulSym) && (IsAnyType (type)))
    {
      TraverseDependants (type);
    }
}


/*
   TryDeclareConstructor - try and declare a constructor.  If, sym, is a
                           constructor try and declare it, if we cannot
                           then enter it into the to do list.
*/

extern "C" void M2GCCDeclare_TryDeclareConstructor (unsigned int tokenno, unsigned int sym)
{
  if (sym != SymbolTable_NulSym)
    {
      if ((SymbolTable_IsConstructor (sym)) && (! (SymbolConversion_GccKnowsAbout (sym))))
        {
          WalkConstructor (sym, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) TraverseDependants});
          if (! (Sets_IsElementInSet (GlobalGroup->ToBeSolvedByQuads, sym)))
            {
              M2ALU_TryEvaluateValue (sym);
              if (M2ALU_IsConstructorDependants (sym, (M2GCCDeclare_IsAction) {(M2GCCDeclare_IsAction_t) IsFullyDeclared}))
                {
                  SymbolTable_PushValue (sym);
                  DeclareConstantFromTree (sym, M2ALU_PopConstructorTree (tokenno));
                }
            }
        }
    }
}


/*
   DeclareLocalVariables - declares Local variables for procedure.
*/

extern "C" void M2GCCDeclare_DeclareLocalVariables (unsigned int procedure)
{
  unsigned int i;
  unsigned int var;

  i = (SymbolTable_NoOfParamAny (procedure))+1;
  var = SymbolTable_GetNth (procedure, i);
  while (var != SymbolTable_NulSym)
    {
      M2Debug_Assert (procedure == (SymbolTable_GetScope (var)));
      M2GCCDeclare_DeclareLocalVariable (var);
      i += 1;
      var = SymbolTable_GetNth (procedure, i);
    }
}


/*
   DeclareLocalVariable - declare a local variable var.
*/

extern "C" void M2GCCDeclare_DeclareLocalVariable (unsigned int var)
{
  DoVariableDeclaration (var, NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (var)), false, false, SymbolTable_IsTemporary (var), false, SymbolConversion_Mod2Gcc (SymbolTable_GetScope (var)));  /* and are not global  */
}


/*
   DeclareProcedure - declares procedure, sym, or all procedures inside
                      module sym.
*/

extern "C" void M2GCCDeclare_DeclareProcedure (unsigned int sym)
{
  if (SymbolTable_IsProcedure (sym))
    {
      DeclareProcedureToGcc (sym);
    }
  else if ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)))
    {
      /* avoid dangling else.  */
      SymbolTable_ForeachProcedureDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_DeclareProcedure});
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "expecting procedure", 19);
    }
}


/*
   DeclareModuleVariables - declares Module variables for a module
                            which was declared inside a procedure.
*/

extern "C" void M2GCCDeclare_DeclareModuleVariables (unsigned int sym)
{
  tree scope;
  unsigned int i;
  unsigned int Var;

  i = 1;
  scope = SymbolConversion_Mod2Gcc (SymbolTable_GetProcedureScope (sym));
  Var = SymbolTable_GetNth (sym, i);
  while (Var != SymbolTable_NulSym)
    {
      DoVariableDeclaration (Var, NameKey_KeyToCharStar (M2AsmUtil_GetFullSymName (Var)), false, false, SymbolTable_IsTemporary (Var), false, scope);  /* and are not global  */
      i += 1;
      Var = SymbolTable_GetNth (sym, i);
    }
}


/*
   IsProcedureGccNested - returns TRUE if procedure, sym, will be considered
                          as nested by GCC.
                          This will occur if either its outer defining scope
                          is a procedure or is a module which is inside a
                          procedure.
*/

extern "C" bool M2GCCDeclare_IsProcedureGccNested (unsigned int sym)
{
  return (SymbolTable_IsProcedureNested (sym)) || ((SymbolTable_IsModule (SymbolTable_GetScope (sym))) && (SymbolTable_IsModuleWithinProcedure (SymbolTable_GetScope (sym))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PoisonSymbols - poisons all gcc symbols from procedure, sym.
                   A debugging aid.
*/

extern "C" void M2GCCDeclare_PoisonSymbols (unsigned int sym)
{
  if (SymbolTable_IsProcedure (sym))
    {
      SymbolTable_ForeachLocalSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SymbolConversion_Poison});
    }
}


/*
   PromoteToString - declare, sym, and then promote it to a string.
                     Note that if sym is a single character we do
                          *not* record it as a string
                          but as a char however we always
                          return a string constant.
*/

extern "C" tree M2GCCDeclare_PromoteToString (unsigned int tokenno, unsigned int sym)
{
  unsigned int size;
  char ch;

  M2GCCDeclare_DeclareConstant (tokenno, sym);
  if ((SymbolTable_IsConst (sym)) && ((SymbolTable_GetSType (sym)) == M2Base_Char))
    {
      SymbolTable_PushValue (sym);
      ch = M2ALU_PopChar (tokenno);
      return m2decl_BuildCStringConstant (const_cast <const char * > (static_cast <char * > (DynamicStrings_string (DynamicStrings_InitStringChar (ch)))), 1);
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsConstStringKnown (sym));
      size = SymbolTable_GetStringLength (tokenno, sym);
      if (size > 1)
        {
          /* It will be already be declared as a string, so return it.  */
          return (tree) (SymbolConversion_Mod2Gcc (sym));
        }
      else
        {
          return m2decl_BuildStringConstant (const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetString (sym)))), static_cast<int> (SymbolTable_GetStringLength (tokenno, sym)));
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PromoteToCString - declare, sym, and then promote it to a string.
                      Note that if sym is a single character we do
                          *not* record it as a string
                          but as a char however we always
                          return a string constant.
*/

extern "C" tree M2GCCDeclare_PromoteToCString (unsigned int tokenno, unsigned int sym)
{
  unsigned int size;
  char ch;

  M2GCCDeclare_DeclareConstant (tokenno, sym);
  M2Debug_Assert (SymbolTable_IsConstStringKnown (sym));
  if ((SymbolTable_IsConst (sym)) && ((SymbolTable_GetSType (sym)) == M2Base_Char))
    {
      SymbolTable_PushValue (sym);
      ch = M2ALU_PopChar (tokenno);
      return m2decl_BuildCStringConstant (const_cast <const char * > (static_cast <char * > (DynamicStrings_string (DynamicStrings_InitStringChar (ch)))), 1);
    }
  else
    {
      size = SymbolTable_GetStringLength (tokenno, sym);
      return m2decl_BuildCStringConstant (const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetString (sym)))), static_cast<int> (size));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CompletelyResolved - returns TRUE if a symbols has been completely resolved
                        and is not partically declared (such as a record).
*/

extern "C" bool M2GCCDeclare_CompletelyResolved (unsigned int sym)
{
  return Sets_IsElementInSet (GlobalGroup->FullyDeclared, sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConstantKnownAndUsed -
*/

extern "C" void M2GCCDeclare_ConstantKnownAndUsed (unsigned int sym, tree t)
{
  DeclareConstantFromTree (sym, m2block_RememberConstant (t));
}


/*
   PutToBeSolvedByQuads - places, sym, to this list and returns,
                          sym.
*/

extern "C" void M2GCCDeclare_PutToBeSolvedByQuads (unsigned int sym)
{
  WatchIncludeList (sym, M2GCCDeclare_tobesolvedbyquads);
}


/*
   MarkExported - tell GCC to mark all exported procedures in module sym.
*/

extern "C" void M2GCCDeclare_MarkExported (unsigned int sym)
{
  if (M2Options_Optimizing)
    {
      m2type_MarkFunctionReferenced (SymbolConversion_Mod2Gcc (sym));
      if ((SymbolTable_IsDefImp (sym)) || (SymbolTable_IsModule (sym)))
        {
          SymbolTable_ForeachExportedDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2GCCDeclare_MarkExported});
        }
    }
}


/*
   GetTypeMin -
*/

extern "C" unsigned int M2GCCDeclare_GetTypeMin (unsigned int type)
{
  unsigned int min;
  unsigned int max;

  if (SymbolTable_IsSubrange (type))
    {
      SymbolTable_GetSubrange (type, &max, &min);
      return min;
    }
  else if (SymbolTable_IsSet (type))
    {
      /* avoid dangling else.  */
      return M2GCCDeclare_GetTypeMin (SymbolTable_GetSType (type));
    }
  else if (SymbolTable_IsEnumeration (type))
    {
      /* avoid dangling else.  */
      MinEnumerationField = SymbolTable_NulSym;
      MaxEnumerationField = SymbolTable_NulSym;
      SymbolTable_ForeachLocalSymDo (type, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) FindMinMaxEnum});
      return MinEnumerationField;
    }
  else if (IsBaseType (type))
    {
      /* avoid dangling else.  */
      M2Base_GetBaseTypeMinMax (type, &min, &max);
      return min;
    }
  else if (M2System_IsSystemType (type))
    {
      /* avoid dangling else.  */
      M2System_GetSystemTypeMinMax (type, &min, &max);
      return min;
    }
  else if ((SymbolTable_GetSType (type)) == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "unable to obtain the MIN value for type {%1as}", 46, type);
      return SymbolTable_NulSym;
    }
  else
    {
      /* avoid dangling else.  */
      return M2GCCDeclare_GetTypeMin (SymbolTable_GetSType (type));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetTypeMax -
*/

extern "C" unsigned int M2GCCDeclare_GetTypeMax (unsigned int type)
{
  unsigned int min;
  unsigned int max;

  if (SymbolTable_IsSubrange (type))
    {
      SymbolTable_GetSubrange (type, &max, &min);
      return max;
    }
  else if (SymbolTable_IsSet (type))
    {
      /* avoid dangling else.  */
      return M2GCCDeclare_GetTypeMax (SymbolTable_GetSType (type));
    }
  else if (SymbolTable_IsEnumeration (type))
    {
      /* avoid dangling else.  */
      MinEnumerationField = SymbolTable_NulSym;
      MaxEnumerationField = SymbolTable_NulSym;
      SymbolTable_ForeachLocalSymDo (type, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) FindMinMaxEnum});
      return MaxEnumerationField;
    }
  else if (IsBaseType (type))
    {
      /* avoid dangling else.  */
      M2Base_GetBaseTypeMinMax (type, &min, &max);
      return max;
    }
  else if (M2System_IsSystemType (type))
    {
      /* avoid dangling else.  */
      M2System_GetSystemTypeMinMax (type, &min, &max);
      return max;
    }
  else if ((SymbolTable_GetSType (type)) == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "unable to obtain the MAX value for type {%1as}", 46, type);
      return SymbolTable_NulSym;
    }
  else
    {
      /* avoid dangling else.  */
      return M2GCCDeclare_GetTypeMax (SymbolTable_GetSType (type));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PrintSym - prints limited information about a symbol.
              This procedure is externally visible.
*/

extern "C" void M2GCCDeclare_PrintSym (unsigned int sym)
{
  M2Printf_printf1 ((const char *) "information about symbol: %d\\n", 30, (const unsigned char *) &sym, (sizeof (sym)-1));
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "==============================\\n", 32);
  PrintVerbose (sym);
}


/*
   IncludeDumpSymbol - include sym into the watch list and all syms dependants.
*/

extern "C" void M2GCCDeclare_IncludeDumpSymbol (unsigned int sym)
{
  if (sym != SymbolTable_NulSym)
    {
      /* 
      fprintf0 (GetDumpFile (), "
      ") ;
      PrintVerbose (sym) ;
      fprintf0 (GetDumpFile (), "
      ")
  */
      AddSymToWatch (sym);
    }
}


/*
   DumpFilteredResolver - dumps the gimple or tree representation of all watched symbols.
*/

extern "C" void M2GCCDeclare_DumpFilteredResolver (void)
{
  Sets_ForeachElementInSetDo (WatchList, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DumpResolver});
}


/*
   DumpFilteredDefinitive - dumps the gimple or tree representation of all watched symbols.
*/

extern "C" void M2GCCDeclare_DumpFilteredDefinitive (void)
{
  Sets_ForeachElementInSetDo (WatchList, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DumpDefinitive});
}


/*
   InitDeclarations - initializes default types and the source filename.
*/

extern "C" void M2GCCDeclare_InitDeclarations (void)
{
  DeclareDefaultTypes ();
  DeclareDefaultConstants ();
}

extern "C" void _M2_M2GCCDeclare_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  FreeGroup = NULL;
  GlobalGroup = InitGroup ();
  ErrorDepList = Sets_InitSet (1);
  ChainedList = Sets_InitSet (1);
  WatchList = Sets_InitSet (1);
  VisitedList = static_cast<Sets_Set> (NULL);
  EnumerationIndex = Indexing_InitIndex (1);
  HaveInitDefaultTypes = false;
  recursionCaught = false;
}

extern "C" void _M2_M2GCCDeclare_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
