/* do not edit automatically generated by mc from M2LangDump.  */
/* M2LangDump.mod provides support routines for the -flang-dump.

Copyright (C) 2024-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaiusmod2@gmail.com>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2LangDump_C

#include "GM2LangDump.h"
#   include "GSYSTEM.h"
#   include "GDynamicStrings.h"
#   include "GSymbolTable.h"
#   include "GM2Options.h"
#   include "GM2AsmUtil.h"
#   include "GM2GCCDeclare.h"
#   include "GFormatStrings.h"
#   include "GNameKey.h"
#   include "GSymbolConversion.h"
#   include "GM2LexBuf.h"
#   include "GM2Printf.h"
#   include "GM2Error.h"
#   include "GM2Batch.h"
#   include "Gm2misc.h"
#   include "GStrLib.h"
#   include "Glibc.h"
#   include "GFIO.h"
#   include "GSFIO.h"
#   include "GStdIO.h"

#   define Debugging false
static FIO_File outputFile;
static bool declActive;
static bool quadActive;
static bool mustClose;
static unsigned int NoOfQuadDumps;
static unsigned int NoOfDeclDumps;

/*
   IsDumpRequiredTree - return TRUE if the gcc tree should be dumped.
*/

extern "C" bool M2LangDump_IsDumpRequiredTree (tree gcctree, bool default_);

/*
   IsDumpRequired - return TRUE if symbol sym should be dumped
                    according to the rules of the filter.
                    No filter specified will always return default.
                    The filter is a comma separated list.  Each element
                    of the list can specify a symbol three ways.
                    Firstly by DECL name for example: m2pim_NumberIO_HexToStr
                    Secondly by qualified scope: [pathname.]NumberIO.HexToStr
                    Thirdly by filename and scope: NumberIO.mod:HexToStr
*/

extern "C" bool M2LangDump_IsDumpRequired (unsigned int sym, bool default_);

/*
   MakeQuadTemplate - return a template for the quad dump file.
*/

extern "C" DynamicStrings_String M2LangDump_MakeQuadTemplate (void);

/*
   MakeGimpleTemplate - return a template for the gimple dump file and assign
                        len to the max number of characters required to complete
                        a template (including a nul terminator).
*/

extern "C" DynamicStrings_String M2LangDump_MakeGimpleTemplate (unsigned int *len);

/*
   GetDumpFile - return the dump output file.
*/

extern "C" FIO_File M2LangDump_GetDumpFile (void);

/*
   CreateDumpQuad - create the dump file for a quad dump.
*/

extern "C" void M2LangDump_CreateDumpQuad (const char *title_, unsigned int _title_high);

/*
   CloseDumpQuad - close the dump output file.
*/

extern "C" void M2LangDump_CloseDumpQuad (void);

/*
   CreateDumpDecl - create the dump file for a decl dump.
*/

extern "C" void M2LangDump_CreateDumpDecl (const char *title_, unsigned int _title_high);

/*
   CloseDumpDecl - close the dump output file.
*/

extern "C" void M2LangDump_CloseDumpDecl (void);

/*
   Assert - call InternalError is NOT value.
*/

static void Assert (bool value);

/*
   DumpWrite - writes a single ch to the dump output.
*/

static void DumpWrite (char ch);

/*
   CloseDump - close the dump file and pop the default write procedure.
*/

static void CloseDump (void);

/*
   OpenDump - open filename as a dump file.  The filename '-' is treated as stdout.
              It pushes a write procedure to StdIO.
*/

static void OpenDump (DynamicStrings_String filename, unsigned int no);

/*
   AddRuleTextDump - filter on the textual name given to GCC.
*/

static void AddRuleTextDump (DynamicStrings_String rule);

/*
   AddRuleScopeQualidentDump -
*/

static void AddRuleScopeQualidentDump (DynamicStrings_String rule, int dot, unsigned int modsym);

/*
   AddRuleScopeDump -
*/

static void AddRuleScopeDump (DynamicStrings_String rule);

/*
   GenQualidentSymString - returns the qualified sym string (including
                           any nested procedure and modules).
*/

static DynamicStrings_String GenQualidentSymString (unsigned int sym);

/*
   IdentQualidentMatch - return TRUE if sym name matches symstr.
*/

static bool IdentQualidentMatch (unsigned int sym, DynamicStrings_String symstr);

/*
   IsRuleFilenameMatch - return TRUE if rule matches sym.
*/

static bool IsRuleFilenameMatch (DynamicStrings_String rule, unsigned int sym);

/*
   CheckRuleMatch - issue a warning if seenMatch is FALSE and this is the first time
                    the rule is matched.
*/

static void CheckRuleMatch (bool seenMatch, DynamicStrings_String rule);

/*
   AddRuleFilenameDump -
*/

static void AddRuleFilenameDump (DynamicStrings_String rule);

/*
   AddRuleSymToDump - call appropriate sub rule.  FileName if : present.
                      Scope if . present otherwise assume a text rule.
*/

static void AddRuleSymToDump (DynamicStrings_String rule);

/*
   AddFilterListToDumpWatch -
*/

static void AddFilterListToDumpWatch (void * filter);

/*
   CreateDumpTitle - creates the underlined title.
*/

static void CreateDumpTitle (const char *title_, unsigned int _title_high);

/*
   Match - return TRUE if sym matches any of the filter rules.
*/

static bool Match (void * filter, unsigned int sym);

/*
   MatchRule - return TRUE if rule matches sym.
*/

static bool MatchRule (DynamicStrings_String rule, unsigned int sym);

/*
   MatchRuleFilenameScope - returns TRUE if rule contains filename.ext:qualident
                            and it matches sym.
*/

static bool MatchRuleFilenameScope (DynamicStrings_String rule, unsigned int sym);

/*
   MatchRuleScope - returns TRUE if rule contains a [libname.]qualified.ident
                    and it matches sym.
*/

static bool MatchRuleScope (DynamicStrings_String rule, unsigned int sym);

/*
   MatchRuleQualident - returns TRUE if rule matches qualified sym.
                        PostCondition:  subrule will be deallocated upon exit.
                                        TRUE is returned if rule matches qualified sym.
*/

static bool MatchRuleQualident (DynamicStrings_String rule, DynamicStrings_String subrule, int i, unsigned int sym);

/*
   QualifiedScope - PostCondition: true is returned is rule matches a qualified sym.
                                   i is -1 if no more qualifications or libname is found.
                                   scope will be the set to the last outer scope seen.
*/

static bool QualifiedScope (DynamicStrings_String rule, unsigned int sym, int *i, unsigned int *scope);

/*
   OptionalLibname - returns TRUE if rule[0..dot] matches syms libname or
                     if there is no libname the scope is a module or defimp
                     symbol.
*/

static bool OptionalLibname (DynamicStrings_String rule, unsigned int sym, int dot, unsigned int scope);

/*
   MatchRuleIdent - return TRUE if ident sym matches rule.
                    The ident must be in a module or defimp scope.
*/

static bool MatchRuleIdent (DynamicStrings_String rule, unsigned int sym);

/*
   MatchRuleText - returns TRUE if rule matches sym.
*/

static bool MatchRuleText (DynamicStrings_String rule, unsigned int sym);

/*
   TextCompareName - return TRUE if rule matches name.
*/

static bool TextCompareName (DynamicStrings_String rule, NameKey_Name name);

/*
   TextMatch - returns TRUE if rule matches text.  Currently this
               is a simple string compare, but could be extended
               to implement regexp (seen in the rule).
*/

static bool TextMatch (DynamicStrings_String rule, DynamicStrings_String text);

/*
   CreateTemplate - create and return a template filename with extension.
                    If the user has specified "-" then "-" is returned otherwise
                    a template is formed from "dumpdir + filename + .%03dl.extension".
*/

static DynamicStrings_String CreateTemplate (DynamicStrings_String filename, DynamicStrings_String extension);

/*
   MakeDeclTemplate - return a template for the decl dump file.
*/

static DynamicStrings_String MakeDeclTemplate (void);

/*
   Init - initialize the module global variables.
*/

static void Init (void);


/*
   Assert - call InternalError is NOT value.
*/

static void Assert (bool value)
{
  if (! value)
    {
      M2Error_InternalError ((const char *) "assert failed in M2LangDump", 27);
    }
}


/*
   DumpWrite - writes a single ch to the dump output.
*/

static void DumpWrite (char ch)
{
  FIO_WriteChar (outputFile, ch);
}


/*
   CloseDump - close the dump file and pop the default write procedure.
*/

static void CloseDump (void)
{
  if (mustClose)
    {
      FIO_Close (outputFile);
      mustClose = false;
    }
  else
    {
      FIO_FlushBuffer (outputFile);
    }
  StdIO_PopOutput ();
  outputFile = FIO_StdOut;
}


/*
   OpenDump - open filename as a dump file.  The filename '-' is treated as stdout.
              It pushes a write procedure to StdIO.
*/

static void OpenDump (DynamicStrings_String filename, unsigned int no)
{
  if (DynamicStrings_EqualArray (filename, (const char *) "-", 1))
    {
      mustClose = false;
      outputFile = FIO_StdOut;
    }
  else
    {
      filename = FormatStrings_Sprintf1 (filename, (const unsigned char *) &no, (sizeof (no)-1));
      outputFile = SFIO_OpenToWrite (filename);
      mustClose = FIO_IsNoError (outputFile);
    }
  filename = DynamicStrings_KillString (filename);
  StdIO_PushOutput ((StdIO_ProcWrite) {(StdIO_ProcWrite_t) DumpWrite});
}


/*
   AddRuleTextDump - filter on the textual name given to GCC.
*/

static void AddRuleTextDump (DynamicStrings_String rule)
{
  unsigned int sym;
  NameKey_Name key;
  bool seenMatch;

  sym = 1;
  seenMatch = false;
  key = NameKey_makekey (DynamicStrings_string (rule));
  while (sym <= (SymbolTable_FinalSymbol ()))
    {
      if ((SymbolTable_IsProcedure (sym)) && (key == (M2AsmUtil_GetFullSymName (sym))))
        {
          M2GCCDeclare_IncludeDumpSymbol (sym);
          seenMatch = true;
        }
      sym += 1;
    }
  CheckRuleMatch (seenMatch, rule);
}


/*
   AddRuleScopeQualidentDump -
*/

static void AddRuleScopeQualidentDump (DynamicStrings_String rule, int dot, unsigned int modsym)
{
  DynamicStrings_String modstr;
  DynamicStrings_String idstr;
  int start;
  unsigned int sym;

  start = dot+1;
  dot = DynamicStrings_Index (rule, '.', static_cast<unsigned int> (start));
  while (dot > 0)
    {
      modstr = DynamicStrings_Slice (rule, start, dot);
      modsym = SymbolTable_GetLocalSym (modsym, NameKey_makekey (DynamicStrings_string (modstr)));
      if ((modsym != SymbolTable_NulSym) && (SymbolTable_IsModule (modsym)))
        {
          start = dot+1;
          dot = DynamicStrings_Index (rule, '.', static_cast<unsigned int> (start));
        }
      else
        {
          modstr = DynamicStrings_KillString (modstr);
          return;
        }
    }
  idstr = DynamicStrings_Slice (rule, start, 0);
  sym = SymbolTable_GetLocalSym (modsym, NameKey_makekey (DynamicStrings_string (idstr)));
  if (sym == SymbolTable_NulSym)
    {
      CheckRuleMatch (false, rule);
    }
  else
    {
      M2GCCDeclare_IncludeDumpSymbol (sym);
    }
}


/*
   AddRuleScopeDump -
*/

static void AddRuleScopeDump (DynamicStrings_String rule)
{
  unsigned int modsym;
  DynamicStrings_String libstr;
  DynamicStrings_String modstr;
  int start;
  int dot;

  dot = DynamicStrings_Index (rule, '.', 0);
  Assert (dot != -1);
  libstr = static_cast<DynamicStrings_String> (NULL);
  modstr = DynamicStrings_Slice (rule, 0, dot);
  modsym = M2Batch_Get (NameKey_makekey (DynamicStrings_string (modstr)));
  if (modsym == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      libstr = modstr;
      start = dot+1;
      dot = DynamicStrings_Index (rule, '.', static_cast<unsigned int> (start));
      if (dot > 0)
        {
          modstr = DynamicStrings_Slice (rule, start, dot);
          modsym = M2Batch_Get (NameKey_makekey (DynamicStrings_string (modstr)));
          if ((modsym != SymbolTable_NulSym) && ((NameKey_makekey (DynamicStrings_string (libstr))) == (SymbolTable_GetLibName (modsym))))
            {
              AddRuleScopeQualidentDump (rule, dot, modsym);
            }
        }
    }
  else
    {
      AddRuleScopeQualidentDump (rule, dot, modsym);
    }
}


/*
   GenQualidentSymString - returns the qualified sym string (including
                           any nested procedure and modules).
*/

static DynamicStrings_String GenQualidentSymString (unsigned int sym)
{
  DynamicStrings_String identstr;
  DynamicStrings_String qualidentstr;

  qualidentstr = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym)));
  while ((SymbolTable_GetScope (sym)) != SymbolTable_NulSym)
    {
      sym = SymbolTable_GetScope (sym);
      identstr = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym)));
      identstr = DynamicStrings_ConCatChar (identstr, '.');
      qualidentstr = DynamicStrings_ConCat (identstr, DynamicStrings_Mark (qualidentstr));
    }
  return qualidentstr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IdentQualidentMatch - return TRUE if sym name matches symstr.
*/

static bool IdentQualidentMatch (unsigned int sym, DynamicStrings_String symstr)
{
  bool success;
  DynamicStrings_String qualidentstr;

  qualidentstr = GenQualidentSymString (sym);
  success = DynamicStrings_Equal (qualidentstr, symstr);
  qualidentstr = DynamicStrings_KillString (qualidentstr);
  return success;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRuleFilenameMatch - return TRUE if rule matches sym.
*/

static bool IsRuleFilenameMatch (DynamicStrings_String rule, unsigned int sym)
{
  DynamicStrings_String fname;
  DynamicStrings_String modstr;
  DynamicStrings_String symstr;
  DynamicStrings_String filename;
  unsigned int tokenno;
  int dot;
  int colon;
  bool success;

  tokenno = SymbolTable_GetDeclaredMod (sym);
  filename = M2LexBuf_FindFileNameFromToken (tokenno, 0);
  fname = static_cast<DynamicStrings_String> (NULL);
  symstr = static_cast<DynamicStrings_String> (NULL);
  modstr = static_cast<DynamicStrings_String> (NULL);
  success = false;
  colon = DynamicStrings_Index (rule, ':', 0);
  if (colon > 0)
    {
      fname = DynamicStrings_Slice (rule, 0, colon);
      if (DynamicStrings_Equal (fname, filename))
        {
          if (((int ) (DynamicStrings_Length (rule))) > colon)
            {
              symstr = DynamicStrings_Slice (rule, colon+1, 0);
              dot = DynamicStrings_ReverseIndex (symstr, '.', -1);
              if (dot >= 0)
                {
                  success = IdentQualidentMatch (sym, symstr);
                }
              else
                {
                  success = (SymbolTable_GetSymName (sym)) == (NameKey_makekey (DynamicStrings_string (symstr)));
                }
            }
        }
    }
  fname = DynamicStrings_KillString (fname);
  modstr = DynamicStrings_KillString (modstr);
  symstr = DynamicStrings_KillString (symstr);
  return success;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckRuleMatch - issue a warning if seenMatch is FALSE and this is the first time
                    the rule is matched.
*/

static void CheckRuleMatch (bool seenMatch, DynamicStrings_String rule)
{
  DynamicStrings_String message;

  if ((NoOfDeclDumps == 1) && ! seenMatch)
    {
      message = DynamicStrings_InitString ((const char *) "no symbol matching: %qs has been found when applying the dump filter", 68);
      m2misc_warning_m2_dump_filter (DynamicStrings_string (message), DynamicStrings_string (rule));
    }
}


/*
   AddRuleFilenameDump -
*/

static void AddRuleFilenameDump (DynamicStrings_String rule)
{
  unsigned int sym;
  bool seenMatch;

  sym = 1;
  seenMatch = false;
  while (sym <= (SymbolTable_FinalSymbol ()))
    {
      if ((SymbolTable_IsProcedure (sym)) && (IsRuleFilenameMatch (rule, sym)))
        {
          M2GCCDeclare_IncludeDumpSymbol (sym);
          seenMatch = true;
        }
      sym += 1;
    }
  CheckRuleMatch (seenMatch, rule);
}


/*
   AddRuleSymToDump - call appropriate sub rule.  FileName if : present.
                      Scope if . present otherwise assume a text rule.
*/

static void AddRuleSymToDump (DynamicStrings_String rule)
{
  if ((DynamicStrings_Index (rule, ':', 0)) != -1)
    {
      /* Filename and scope rule.  */
      AddRuleFilenameDump (rule);
    }
  else if ((DynamicStrings_Index (rule, '.', 0)) != -1)
    {
      /* avoid dangling else.  */
      /* Modula-2 scoping tests.  */
      AddRuleScopeDump (rule);
    }
  else
    {
      /* avoid dangling else.  */
      /* Text decl tests.  */
      AddRuleTextDump (rule);
    }
}


/*
   AddFilterListToDumpWatch -
*/

static void AddFilterListToDumpWatch (void * filter)
{
  DynamicStrings_String rule;
  DynamicStrings_String full;
  int start;
  int i;

  full = DynamicStrings_InitStringCharStar (filter);
  start = 0;
  do {
    i = DynamicStrings_Index (full, ',', static_cast<unsigned int> (start));
    if (i == -1)
      {
        rule = DynamicStrings_Slice (full, start, 0);
      }
    else
      {
        rule = DynamicStrings_Slice (full, start, i);
      }
    AddRuleSymToDump (rule);
    rule = DynamicStrings_KillString (rule);
    start = i+1;
  } while (! (i == -1));
  full = DynamicStrings_KillString (full);
}


/*
   CreateDumpTitle - creates the underlined title.
*/

static void CreateDumpTitle (const char *title_, unsigned int _title_high)
{
  unsigned int len;
  unsigned int text;
  unsigned int i;
  DynamicStrings_String s;
  char title[_title_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (title, title_, _title_high+1);

  s = FormatStrings_Sprintf0 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) title, _title_high)));
  s = DynamicStrings_KillString (SFIO_WriteS (M2LangDump_GetDumpFile (), s));
  len = StrLib_StrLen ((const char *) title, _title_high);
  i = 0;
  text = 0;
  while (i < len)
    {
      if (title[i] == '\\')
        {
          i += 2;
        }
      else
        {
          i += 1;
          text += 1;
        }
    }
  s = DynamicStrings_Mult (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "=", 1)), text);
  s = DynamicStrings_KillString (SFIO_WriteS (M2LangDump_GetDumpFile (), s));
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "\\n", 2);
}


/*
   Match - return TRUE if sym matches any of the filter rules.
*/

static bool Match (void * filter, unsigned int sym)
{
  bool result;
  DynamicStrings_String rule;
  DynamicStrings_String full;
  int start;
  int i;

  full = DynamicStrings_InitStringCharStar (filter);
  start = 0;
  do {
    i = DynamicStrings_Index (full, ',', static_cast<unsigned int> (start));
    if (i == -1)
      {
        rule = DynamicStrings_Slice (full, start, 0);
      }
    else
      {
        rule = DynamicStrings_Slice (full, start, i);
      }
    result = MatchRule (rule, sym);
    rule = DynamicStrings_KillString (rule);
    if (result)
      {
        full = DynamicStrings_KillString (full);
        return true;
      }
    start = i+1;
  } while (! (i == -1));
  full = DynamicStrings_KillString (full);
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MatchRule - return TRUE if rule matches sym.
*/

static bool MatchRule (DynamicStrings_String rule, unsigned int sym)
{
  if ((DynamicStrings_Index (rule, ':', 0)) != -1)
    {
      /* Filename and scope qualification tests.  */
      return MatchRuleFilenameScope (rule, sym);
    }
  else if ((DynamicStrings_Index (rule, '.', 0)) != -1)
    {
      /* avoid dangling else.  */
      /* Modula-2 scoping tests.  */
      return MatchRuleScope (rule, sym);
    }
  else
    {
      /* avoid dangling else.  */
      /* Text decl tests.  */
      return MatchRuleText (rule, sym);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MatchRuleFilenameScope - returns TRUE if rule contains filename.ext:qualident
                            and it matches sym.
*/

static bool MatchRuleFilenameScope (DynamicStrings_String rule, unsigned int sym)
{
  DynamicStrings_String rulefile;
  DynamicStrings_String symfile;
  DynamicStrings_String subrule;

  rulefile = DynamicStrings_Slice (rule, 0, DynamicStrings_Index (rule, ':', 0));
  /* Do not deallocate symfile.  */
  symfile = M2LexBuf_FindFileNameFromToken (SymbolTable_GetDeclaredMod (sym), 0);
  if (TextMatch (rulefile, symfile))
    {
      subrule = DynamicStrings_Slice (rule, (DynamicStrings_Index (rule, ':', 0))+1, 0);
      if (MatchRuleScope (subrule, sym))
        {
          subrule = DynamicStrings_KillString (subrule);
          return true;
        }
    }
  rulefile = DynamicStrings_KillString (rulefile);
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MatchRuleScope - returns TRUE if rule contains a [libname.]qualified.ident
                    and it matches sym.
*/

static bool MatchRuleScope (DynamicStrings_String rule, unsigned int sym)
{
  int i;
  NameKey_Name name;

  if (Debugging)
    {
      name = SymbolTable_GetSymName (sym);
      M2Printf_printf2 ((const char *) "MatchRuleScope (%s, %a)\\n", 25, (const unsigned char *) &rule, (sizeof (rule)-1), (const unsigned char *) &name, (sizeof (name)-1));
    }
  /* Compare qualident right to left.  */
  i = DynamicStrings_RIndex (rule, '.', 0);
  if (i == -1)
    {
      /* No qualification, just the ident.  */
      return MatchRuleIdent (rule, sym);
    }
  else
    {
      return MatchRuleQualident (rule, DynamicStrings_Slice (rule, i+1, 0), i, sym);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MatchRuleQualident - returns TRUE if rule matches qualified sym.
                        PostCondition:  subrule will be deallocated upon exit.
                                        TRUE is returned if rule matches qualified sym.
*/

static bool MatchRuleQualident (DynamicStrings_String rule, DynamicStrings_String subrule, int i, unsigned int sym)
{
  unsigned int scope;

  if (TextCompareName (subrule, SymbolTable_GetSymName (sym)))
    {
      if (! (QualifiedScope (rule, sym, &i, &scope)))
        {
          return false;
        }
      if (OptionalLibname (rule, sym, i, scope))
        {
          return true;
        }
    }
  subrule = DynamicStrings_KillString (subrule);
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "MatchRuleQualident FALSE\\n", 26);
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   QualifiedScope - PostCondition: true is returned is rule matches a qualified sym.
                                   i is -1 if no more qualifications or libname is found.
                                   scope will be the set to the last outer scope seen.
*/

static bool QualifiedScope (DynamicStrings_String rule, unsigned int sym, int *i, unsigned int *scope)
{
  DynamicStrings_String subrule;
  int j;
  NameKey_Name name;

  if (Debugging)
    {
      name = SymbolTable_GetSymName (sym);
      M2Printf_printf2 ((const char *) "seen ident name, QualifiedScope (rule = %s, %a)\\n", 49, (const unsigned char *) &rule, (sizeof (rule)-1), (const unsigned char *) &name, (sizeof (name)-1));
    }
  (*scope) = sym;
  subrule = static_cast<DynamicStrings_String> (NULL);
  do {
    j = (*i);
    (*scope) = SymbolTable_GetScope ((*scope));
    (*i) = DynamicStrings_ReverseIndex (rule, '.', j-1);
    if (Debugging)
      {
        M2Printf_printf2 ((const char *) " reverseindex (rule = %s, '.', j = %d)\\n", 40, (const unsigned char *) &rule, (sizeof (rule)-1), (const unsigned char *) &j, (sizeof (j)-1));
        M2Printf_printf1 ((const char *) "    returns i = %d\\n", 20, (const unsigned char *) &(*i), (sizeof ((*i))-1));
      }
    if ((*scope) != SymbolTable_NulSym)
      {
        subrule = DynamicStrings_KillString (subrule);
        subrule = DynamicStrings_Slice (rule, (*i)+1, j);
        if (Debugging)
          {
            name = SymbolTable_GetSymName ((*scope));
            M2Printf_printf2 ((const char *) "QualifiedScope (subrule = %s, %a)\\n", 35, (const unsigned char *) &subrule, (sizeof (subrule)-1), (const unsigned char *) &name, (sizeof (name)-1));
          }
        if (! (TextCompareName (subrule, SymbolTable_GetSymName ((*scope)))))
          {
            subrule = DynamicStrings_KillString (subrule);
            if (Debugging)
              {
                M2Printf_printf0 ((const char *) "QualifiedScope FALSE\\n", 22);
              }
            return false;
          }
      }
  } while (! ((((*i) <= 0) || (SymbolTable_IsDefImp ((*scope)))) || (SymbolTable_IsModule ((*scope)))));
  subrule = DynamicStrings_KillString (subrule);
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OptionalLibname - returns TRUE if rule[0..dot] matches syms libname or
                     if there is no libname the scope is a module or defimp
                     symbol.
*/

static bool OptionalLibname (DynamicStrings_String rule, unsigned int sym, int dot, unsigned int scope)
{
  DynamicStrings_String subrule;

  if (dot > 0)
    {
      /* Check for optional libname.  */
      subrule = DynamicStrings_Slice (rule, 0, dot);
      if (Debugging)
        {
          M2Printf_printf2 ((const char *) "checking for optional libname (subrule = %s, '.', dot = %d)\\n", 61, (const unsigned char *) &rule, (sizeof (rule)-1), (const unsigned char *) &dot, (sizeof (dot)-1));
        }
      if (TextCompareName (subrule, SymbolTable_GetLibName (SymbolTable_GetModuleScope (sym))))
        {
          subrule = DynamicStrings_KillString (subrule);
          if (Debugging)
            {
              M2Printf_printf0 ((const char *) "OptionalLibname TRUE\\n", 22);
            }
          return true;
        }
      subrule = DynamicStrings_KillString (subrule);
    }
  else if ((scope != SymbolTable_NulSym) && ((SymbolTable_IsModule (scope)) || (SymbolTable_IsDefImp (scope))))
    {
      /* avoid dangling else.  */
      if (Debugging)
        {
          M2Printf_printf0 ((const char *) "OptionalLibname TRUE\\n", 22);
        }
      return true;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MatchRuleIdent - return TRUE if ident sym matches rule.
                    The ident must be in a module or defimp scope.
*/

static bool MatchRuleIdent (DynamicStrings_String rule, unsigned int sym)
{
  unsigned int scope;

  if (TextCompareName (rule, SymbolTable_GetSymName (sym)))
    {
      scope = SymbolTable_GetScope (sym);
      return (SymbolTable_IsModule (scope)) || (SymbolTable_IsDefImp (scope));
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MatchRuleText - returns TRUE if rule matches sym.
*/

static bool MatchRuleText (DynamicStrings_String rule, unsigned int sym)
{
  return TextCompareName (rule, M2AsmUtil_GetFullScopeAsmName (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TextCompareName - return TRUE if rule matches name.
*/

static bool TextCompareName (DynamicStrings_String rule, NameKey_Name name)
{
  bool result;
  DynamicStrings_String text;

  text = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name));
  result = TextMatch (rule, text);
  text = DynamicStrings_KillString (text);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TextMatch - returns TRUE if rule matches text.  Currently this
               is a simple string compare, but could be extended
               to implement regexp (seen in the rule).
*/

static bool TextMatch (DynamicStrings_String rule, DynamicStrings_String text)
{
  if (Debugging)
    {
      M2Printf_printf2 ((const char *) "TextMatch (%s, %s)\\n", 20, (const unsigned char *) &rule, (sizeof (rule)-1), (const unsigned char *) &text, (sizeof (text)-1));
    }
  return DynamicStrings_Equal (rule, text);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CreateTemplate - create and return a template filename with extension.
                    If the user has specified "-" then "-" is returned otherwise
                    a template is formed from "dumpdir + filename + .%03dl.extension".
*/

static DynamicStrings_String CreateTemplate (DynamicStrings_String filename, DynamicStrings_String extension)
{
  if (filename == NULL)
    {
      /* User has not specified a file.  */
      if ((M2Options_GetDumpDir ()) == NULL)
        {
          filename = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (SymbolTable_GetMainModule ())));
        }
      else
        {
          filename = DynamicStrings_Dup (M2Options_GetDumpDir ());
          filename = DynamicStrings_ConCat (filename, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (SymbolTable_GetMainModule ())))));
        }
      filename = DynamicStrings_ConCat (filename, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".mod", 4)));
    }
  else
    {
      /* We need to duplicate the filename to create a new string before ConCat
         is used later on.  */
      filename = DynamicStrings_Dup (filename);
    }
  if (! (DynamicStrings_EqualArray (filename, (const char *) "-", 1)))
    {
      filename = DynamicStrings_ConCat (DynamicStrings_ConCat (filename, DynamicStrings_InitString ((const char *) ".%03dl.", 7)), extension);
    }
  return filename;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeDeclTemplate - return a template for the decl dump file.
*/

static DynamicStrings_String MakeDeclTemplate (void)
{
  return CreateTemplate (M2Options_GetDumpDeclFilename (), DynamicStrings_InitString ((const char *) "decl", 4));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Init - initialize the module global variables.
*/

static void Init (void)
{
  NoOfQuadDumps = 0;
  NoOfDeclDumps = 0;
  declActive = false;
  quadActive = false;
  mustClose = false;
  outputFile = FIO_StdOut;
}


/*
   IsDumpRequiredTree - return TRUE if the gcc tree should be dumped.
*/

extern "C" bool M2LangDump_IsDumpRequiredTree (tree gcctree, bool default_)
{
  unsigned int sym;

  sym = SymbolConversion_Gcc2Mod (gcctree);
  if (sym == SymbolTable_NulSym)
    {
      return default_;
    }
  else
    {
      return M2LangDump_IsDumpRequired (sym, default_);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsDumpRequired - return TRUE if symbol sym should be dumped
                    according to the rules of the filter.
                    No filter specified will always return default.
                    The filter is a comma separated list.  Each element
                    of the list can specify a symbol three ways.
                    Firstly by DECL name for example: m2pim_NumberIO_HexToStr
                    Secondly by qualified scope: [pathname.]NumberIO.HexToStr
                    Thirdly by filename and scope: NumberIO.mod:HexToStr
*/

extern "C" bool M2LangDump_IsDumpRequired (unsigned int sym, bool default_)
{
  DynamicStrings_String filter;

  filter = static_cast<DynamicStrings_String> (M2Options_GetM2DumpFilter ());
  if (filter == NULL)
    {
      return default_;
    }
  else
    {
      return Match (reinterpret_cast <void *> (filter), sym);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeQuadTemplate - return a template for the quad dump file.
*/

extern "C" DynamicStrings_String M2LangDump_MakeQuadTemplate (void)
{
  return CreateTemplate (M2Options_GetDumpQuadFilename (), DynamicStrings_InitString ((const char *) "quad", 4));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeGimpleTemplate - return a template for the gimple dump file and assign
                        len to the max number of characters required to complete
                        a template (including a nul terminator).
*/

extern "C" DynamicStrings_String M2LangDump_MakeGimpleTemplate (unsigned int *len)
{
  DynamicStrings_String filename;

  filename = CreateTemplate (M2Options_GetDumpGimpleFilename (), DynamicStrings_InitString ((const char *) "gimple", 6));
  (*len) = DynamicStrings_Length (filename);  /* This is a short cut based on '%03d' format
                                  specifier used above.  */
  return filename;  /* This is a short cut based on '%03d' format
                                  specifier used above.  */
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDumpFile - return the dump output file.
*/

extern "C" FIO_File M2LangDump_GetDumpFile (void)
{
  return outputFile;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CreateDumpQuad - create the dump file for a quad dump.
*/

extern "C" void M2LangDump_CreateDumpQuad (const char *title_, unsigned int _title_high)
{
  char title[_title_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (title, title_, _title_high+1);

  Assert (! declActive);
  Assert (! quadActive);
  quadActive = true;
  NoOfQuadDumps += 1;
  OpenDump (M2LangDump_MakeQuadTemplate (), NoOfQuadDumps);
  CreateDumpTitle ((const char *) title, _title_high);
}


/*
   CloseDumpQuad - close the dump output file.
*/

extern "C" void M2LangDump_CloseDumpQuad (void)
{
  CloseDump ();
  quadActive = false;
}


/*
   CreateDumpDecl - create the dump file for a decl dump.
*/

extern "C" void M2LangDump_CreateDumpDecl (const char *title_, unsigned int _title_high)
{
  char title[_title_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (title, title_, _title_high+1);

  if ((M2Options_GetM2DumpFilter ()) != NULL)
    {
      Assert (! declActive);
      Assert (! quadActive);
      declActive = true;
      NoOfDeclDumps += 1;
      OpenDump (MakeDeclTemplate (), NoOfDeclDumps);
      CreateDumpTitle ((const char *) title, _title_high);
      AddFilterListToDumpWatch (M2Options_GetM2DumpFilter ());
    }
}


/*
   CloseDumpDecl - close the dump output file.
*/

extern "C" void M2LangDump_CloseDumpDecl (void)
{
  if (declActive)
    {
      CloseDump ();
      declActive = false;
    }
}

extern "C" void _M2_M2LangDump_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_M2LangDump_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
