/* do not edit automatically generated by mc from M2Optimize.  */
/* M2Optimize.mod removes redundant quadruples.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#define _M2Optimize_C

#include "GM2Optimize.h"
#   include "GM2Debug.h"
#   include "GNameKey.h"
#   include "GStrIO.h"
#   include "GNumberIO.h"
#   include "GM2Error.h"
#   include "GM2Batch.h"
#   include "GM2Quiet.h"
#   include "GM2Scope.h"
#   include "GSymbolTable.h"
#   include "GM2Quads.h"


/*
   FoldBranches - folds unneccessary branches in the list of quadruples.
                  It searches for the following patterns:

                  [x]  GotoOp  _   _   y                GotoOp   _   _   z
                  ...                                   ...
                  [y]  GotoOp  _   _   z      "deleted"

                  WHERE ... may contain 0..n Pseudo Quads


                  OR


                  [x]  IfREL   _   _   z      If NOT REL  _   _   a
                  ...                         ...
                  [y]  Goto    _   _   a      "deleted"
                  ...                         ...
                  [z]


                  WHERE ... may contain 0..n Pseudo Quads
                  but in this case they must not be a
                      target of any other quad.
*/

extern "C" void M2Optimize_FoldBranches (unsigned int start, unsigned int end);

/*
   RemoveProcedures - removes any procedures that are never referenced
                      by the quadruples.
*/

extern "C" void M2Optimize_RemoveProcedures (unsigned int scope);

/*
   DisplayReachable - Displays the data structures surrounding Reachablity.
*/

extern "C" void M2Optimize_DisplayReachable (void);

/*
   ReduceBranch - searches for the following pattern:

                  [x]  IfREL   _   _   z      If NOT REL  _   _   a
                  ...                         ...
                  [y]  Goto    _   _   a      "deleted"
                  ...                         ...
                  [z]


                  WHERE ... may contain 0..n Pseudo Quads
                  but in this case they must not be a
                      target of any other quad.

*/

static bool ReduceBranch (M2Quads_QuadOperator Operator, unsigned int CurrentQuad, unsigned int CurrentOperand1, unsigned int CurrentOperand2, unsigned int CurrentOperand3, unsigned int *NextQuad, bool Folded);

/*
   IsBasicBlock - returns TRUE if no other quadruple jumps inbetween
                  the range From..To.
                  It assumes that there are no jumps in the quadruples
                  From..To.
*/

static bool IsBasicBlock (unsigned int From, unsigned int To);

/*
   ReduceGoto - searches for the following patterns:

                [x]  GotoOp  _   _   y                GotoOp   _   _   z
                  ...                                   ...
                [y]  GotoOp  _   _   z      "deleted"


*/

static bool ReduceGoto (unsigned int CurrentQuad, unsigned int CurrentOperand3, unsigned int NextQuad, bool Folded);

/*
   FoldMultipleGoto - takes a QuadNo and if it jumps to another GotoOp
                      then it takes the later target as a replacement
                      for its own.

                      NOTE  it does not remove any quadruples.
*/

static bool FoldMultipleGoto (unsigned int QuadNo);

/*
   CheckNeedSavePriority -
*/

static void CheckNeedSavePriority (unsigned int sym);

/*
   CheckExportedReachable - checks to see whether procedure, sym, was
                            exported and if so it calls RemoveProcedures.
*/

static void CheckExportedReachable (unsigned int sym);
static void KnownReachable (unsigned int Start, unsigned int End);
static void KnownReach (unsigned int sym);


/*
   ReduceBranch - searches for the following pattern:

                  [x]  IfREL   _   _   z      If NOT REL  _   _   a
                  ...                         ...
                  [y]  Goto    _   _   a      "deleted"
                  ...                         ...
                  [z]


                  WHERE ... may contain 0..n Pseudo Quads
                  but in this case they must not be a
                      target of any other quad.

*/

static bool ReduceBranch (M2Quads_QuadOperator Operator, unsigned int CurrentQuad, unsigned int CurrentOperand1, unsigned int CurrentOperand2, unsigned int CurrentOperand3, unsigned int *NextQuad, bool Folded)
{
  bool constExpr;
  bool overflowChecking;
  M2Quads_QuadOperator OpNext;
  unsigned int tok;
  unsigned int NextPlusOne;
  unsigned int Op1Next;
  unsigned int Op2Next;
  unsigned int Op3Next;
  unsigned int op1tok;
  unsigned int op2tok;
  unsigned int op3tok;
  unsigned int From;
  unsigned int To;

  /* Goto          x  */
  if ((*NextQuad) != 0)
    {
      if (((M2Quads_GetNextQuad (CurrentQuad)) == CurrentOperand3) || ((M2Quads_GetRealQuad (M2Quads_GetNextQuad (CurrentQuad))) == CurrentOperand3))
        {
          M2Quads_SubQuad (CurrentQuad);
          Folded = true;
        }
      else
        {
          From = M2Quads_GetNextQuad (CurrentQuad);  /* start after CurrentQuad  */
          To = (*NextQuad);  /* start after CurrentQuad  */
          CurrentOperand3 = M2Quads_GetRealQuad (CurrentOperand3);
          NextPlusOne = M2Quads_GetRealQuad (M2Quads_GetNextQuad ((*NextQuad)));
          M2Quads_GetQuad ((*NextQuad), &OpNext, &Op1Next, &Op2Next, &Op3Next);
          if (((OpNext == M2Quads_GotoOp) && (NextPlusOne == CurrentOperand3)) && (IsBasicBlock (From, To)))
            {
              M2Quads_GetQuadOtok (CurrentQuad, &tok, &Operator, &CurrentOperand1, &CurrentOperand2, &CurrentOperand3, &overflowChecking, &constExpr, &op1tok, &op2tok, &op3tok);
              M2Quads_SubQuad ((*NextQuad));
              M2Quads_PutQuadOtok (CurrentQuad, tok, M2Quads_Opposite (Operator), CurrentOperand1, CurrentOperand2, Op3Next, overflowChecking, constExpr, op1tok, op2tok, op3tok);
              (*NextQuad) = NextPlusOne;
              Folded = true;
            }
        }
      if (FoldMultipleGoto (CurrentQuad))
        {
          Folded = true;
        }
    }
  return Folded;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsBasicBlock - returns TRUE if no other quadruple jumps inbetween
                  the range From..To.
                  It assumes that there are no jumps in the quadruples
                  From..To.
*/

static bool IsBasicBlock (unsigned int From, unsigned int To)
{
  while (From != To)
    {
      if (M2Quads_IsReferenced (From))
        {
          return false;
        }
      else
        {
          if (From > To)
            {
              M2Error_InternalError ((const char *) "assert failed From should never be larger than To", 49);
            }
          From = M2Quads_GetNextQuad (From);
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ReduceGoto - searches for the following patterns:

                [x]  GotoOp  _   _   y                GotoOp   _   _   z
                  ...                                   ...
                [y]  GotoOp  _   _   z      "deleted"


*/

static bool ReduceGoto (unsigned int CurrentQuad, unsigned int CurrentOperand3, unsigned int NextQuad, bool Folded)
{
  CurrentOperand3 = M2Quads_GetRealQuad (CurrentOperand3);
  /* IF next quad is a GotoOp  */
  if (CurrentOperand3 == NextQuad)
    {
      M2Quads_SubQuad (CurrentQuad);
      Folded = true;
    }
  else
    {
      /* Does Goto point to another Goto ?  */
      if (FoldMultipleGoto (CurrentQuad))
        {
          Folded = true;
        }
    }
  return Folded;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldMultipleGoto - takes a QuadNo and if it jumps to another GotoOp
                      then it takes the later target as a replacement
                      for its own.

                      NOTE  it does not remove any quadruples.
*/

static bool FoldMultipleGoto (unsigned int QuadNo)
{
  M2Quads_QuadOperator Operator;
  M2Quads_QuadOperator Op;
  unsigned int Op1;
  unsigned int Op2;
  unsigned int Op3;
  unsigned int Operand1;
  unsigned int Operand2;
  unsigned int Operand3;

  M2Quads_GetQuad (QuadNo, &Operator, &Operand1, &Operand2, &Operand3);
  Operand3 = M2Quads_GetRealQuad (Operand3);  /* skip pseudo quadruples  */
  M2Quads_GetQuad (Operand3, &Op, &Op1, &Op2, &Op3);  /* skip pseudo quadruples  */
  if (Op == M2Quads_GotoOp)
    {
      M2Quads_PutQuad (QuadNo, Operator, Operand1, Operand2, Op3);
      /* forever.  */
      return Op3 != Operand3;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckNeedSavePriority -
*/

static void CheckNeedSavePriority (unsigned int sym)
{
  if ((SymbolTable_IsProcedure (sym)) && ((SymbolTable_GetPriority (SymbolTable_GetModuleScope (sym))) != SymbolTable_NulSym))
    {
      SymbolTable_PutNeedSavePriority (sym);
    }
}


/*
   CheckExportedReachable - checks to see whether procedure, sym, was
                            exported and if so it calls RemoveProcedures.
*/

static void CheckExportedReachable (unsigned int sym)
{
  if (SymbolTable_IsExported (SymbolTable_GetModuleScope (sym), sym))
    {
      M2Optimize_RemoveProcedures (sym);
      CheckNeedSavePriority (sym);
    }
}

static void KnownReachable (unsigned int Start, unsigned int End)
{
  M2Quads_QuadOperator Op;
  unsigned int Op1;
  unsigned int Op2;
  unsigned int Op3;

  /* DeleteUnReachableProcedures  */
  if (Start != 0)
    {
      do {
        M2Quads_GetQuad (Start, &Op, &Op1, &Op2, &Op3);
        switch (Op)
          {
            case M2Quads_CallOp:
              KnownReach (Op3);
              break;

            case M2Quads_AddrOp:
            case M2Quads_ParamOp:
            case M2Quads_XIndrOp:
            case M2Quads_BecomesOp:
              KnownReach (Op3);
              CheckNeedSavePriority (Op3);
              break;


            default:
              break;
          }
        Start = M2Quads_GetNextQuad (Start);
      } while (! ((Start > End) || (Start == 0)));
    }
}

static void KnownReach (unsigned int sym)
{
  if ((SymbolTable_IsProcedure (sym)) && (! (SymbolTable_IsProcedureReachable (sym))))
    {
      M2Optimize_RemoveProcedures (sym);
    }
}


/*
   FoldBranches - folds unneccessary branches in the list of quadruples.
                  It searches for the following patterns:

                  [x]  GotoOp  _   _   y                GotoOp   _   _   z
                  ...                                   ...
                  [y]  GotoOp  _   _   z      "deleted"

                  WHERE ... may contain 0..n Pseudo Quads


                  OR


                  [x]  IfREL   _   _   z      If NOT REL  _   _   a
                  ...                         ...
                  [y]  Goto    _   _   a      "deleted"
                  ...                         ...
                  [z]


                  WHERE ... may contain 0..n Pseudo Quads
                  but in this case they must not be a
                      target of any other quad.
*/

extern "C" void M2Optimize_FoldBranches (unsigned int start, unsigned int end)
{
  bool Folded;
  unsigned int i;
  unsigned int j;
  unsigned int Right;
  M2Quads_QuadOperator Operator;
  unsigned int Operand1;
  unsigned int Operand2;
  unsigned int Operand3;

  do {
    i = start;
    Folded = false;
    while ((i <= end) && (i != 0))
      {
        j = M2Quads_GetNextQuad (i);
        if ((j > end) || (j == 0))
          {
            return;
          }
        Right = M2Quads_GetRealQuad (j);
        if (Right == 0)
          {
            return;
          }
        M2Quads_GetQuad (i, &Operator, &Operand1, &Operand2, &Operand3);
        switch (Operator)
          {
            case M2Quads_GotoOp:
              Folded = ReduceGoto (i, Operand3, Right, Folded);
              break;

            case M2Quads_IfInOp:
            case M2Quads_IfNotInOp:
            case M2Quads_IfNotEquOp:
            case M2Quads_IfEquOp:
            case M2Quads_IfLessEquOp:
            case M2Quads_IfGreEquOp:
            case M2Quads_IfGreOp:
            case M2Quads_IfLessOp:
              Folded = ReduceBranch (Operator, i, Operand1, Operand2, Operand3, &Right, Folded);
              break;


            default:
              break;
          }
        i = Right;
      }
  } while (! (! Folded));
}


/*
   RemoveProcedures - removes any procedures that are never referenced
                      by the quadruples.
*/

extern "C" void M2Optimize_RemoveProcedures (unsigned int scope)
{
  M2Scope_ScopeBlock sb;

  sb = M2Scope_InitScopeBlock (scope);
  if (SymbolTable_IsProcedure (scope))
    {
      SymbolTable_PutProcedureReachable (scope);
      M2Scope_ForeachScopeBlockDo2 (sb, (M2Scope_ScopeProcedure2) {(M2Scope_ScopeProcedure2_t) KnownReachable});
    }
  else if (SymbolTable_IsModuleWithinProcedure (scope))
    {
      /* avoid dangling else.  */
      M2Scope_ForeachScopeBlockDo2 (sb, (M2Scope_ScopeProcedure2) {(M2Scope_ScopeProcedure2_t) KnownReachable});
      SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) CheckExportedReachable});
    }
  else
    {
      /* avoid dangling else.  */
      M2Scope_ForeachScopeBlockDo2 (sb, (M2Scope_ScopeProcedure2) {(M2Scope_ScopeProcedure2_t) KnownReachable});
      SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) CheckExportedReachable});
    }
  SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2Optimize_RemoveProcedures});
  M2Scope_KillScopeBlock (&sb);
}


/*
   DisplayReachable - Displays the data structures surrounding Reachablity.
*/

extern "C" void M2Optimize_DisplayReachable (void)
{
  unsigned int n;
  unsigned int m;
  unsigned int Scope;
  unsigned int StartInit;
  unsigned int EndInit;
  unsigned int StartFinish;
  unsigned int EndFinish;
  unsigned int Module;
  unsigned int Proc;

  m = 1;
  do {
    Module = M2Batch_GetModuleNo (m);
    if (Module != SymbolTable_NulSym)
      {
        StrIO_WriteString ((const char *) "Module", 6);
        NumberIO_WriteCard (m, 3);
        NameKey_WriteKey (SymbolTable_GetSymName (Module));
        SymbolTable_GetModuleQuads (Module, &StartInit, &EndInit, &StartFinish, &EndFinish);
        StrIO_WriteString ((const char *) " Reachable initialization", 25);
        NumberIO_WriteCard (StartInit, 6);
        NumberIO_WriteCard (EndInit, 6);
        StrIO_WriteLn ();
        StrIO_WriteString ((const char *) "Module", 6);
        NumberIO_WriteCard (m, 3);
        NameKey_WriteKey (SymbolTable_GetSymName (Module));
        SymbolTable_GetModuleQuads (Module, &StartInit, &EndInit, &StartFinish, &EndFinish);
        StrIO_WriteString ((const char *) " Reachable finalization", 23);
        NumberIO_WriteCard (StartFinish, 6);
        NumberIO_WriteCard (EndFinish, 6);
        StrIO_WriteLn ();
        n = 1;
        Proc = SymbolTable_GetNthProcedure (Module, n);
        while (Proc != SymbolTable_NulSym)
          {
            StrIO_WriteString ((const char *) "Procedure ", 10);
            NameKey_WriteKey (SymbolTable_GetSymName (Proc));
            SymbolTable_GetProcedureQuads (Proc, &Scope, &StartInit, &EndInit);
            StrIO_WriteString ((const char *) " Quads: ", 8);
            NumberIO_WriteCard (StartInit, 6);
            NumberIO_WriteCard (EndInit, 6);
            if (! (SymbolTable_IsProcedureReachable (Proc)))
              {
                StrIO_WriteString ((const char *) " UN reachable", 13);
              }
            else
              {
                StrIO_WriteString ((const char *) " IS reachable", 13);
              }
            StrIO_WriteLn ();
            n += 1;
            Proc = SymbolTable_GetNthProcedure (Module, n);
          }
        m += 1;
      }
  } while (! (Module == SymbolTable_NulSym));
}

extern "C" void _M2_M2Optimize_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2Optimize_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
