/* do not edit automatically generated by mc from M2System.  */
/* M2System.mod defines the SYSTEM builtin types.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2System_C

#include "GM2System.h"
#   include "GSymbolTable.h"
#   include "GAssertion.h"
#   include "GM2LexBuf.h"
#   include "GM2Options.h"
#   include "GNameKey.h"
#   include "GM2Batch.h"
#   include "GM2Base.h"
#   include "GM2Size.h"
#   include "GM2ALU.h"
#   include "GM2Error.h"
#   include "GLists.h"
#   include "GSymbolKey.h"
#   include "GStrLib.h"
#   include "GM2Printf.h"
#   include "GSymbolConversion.h"
#   include "Ggcctypes.h"
#   include "Gm2linemap.h"
#   include "Gm2decl.h"
#   include "Gm2type.h"
#   include "Gm2expr.h"

typedef struct M2System_IsP_p M2System_IsP;

typedef bool (*M2System_IsP_t) (unsigned int);
struct M2System_IsP_p { M2System_IsP_t proc; };

static SymbolKey_SymbolTree MinValues;
static SymbolKey_SymbolTree MaxValues;
static Lists_List SystemTypes;

/*
   InitSystem - creates the system dependant types and procedures.
                Note that they are not exported here, but they are
                exported in the textual module: SYSTEM.def.
                We build our system types from those given in the gcc
                backend. Essentially we perform double book keeping.
*/

extern "C" void M2System_InitSystem (void);

/*
   GetSystemTypeMinMax - returns the minimum and maximum values for a given system type.
*/

extern "C" void M2System_GetSystemTypeMinMax (unsigned int type, unsigned int *min, unsigned int *max);

/*
   IsPseudoSystemFunction - returns true if sym is a SYSTEM pseudo function.
*/

extern "C" bool M2System_IsPseudoSystemFunction (unsigned int sym);

/*
   IsPseudoSystemProcedure - returns true if sym is a SYSTEM pseudo procedure.
*/

extern "C" bool M2System_IsPseudoSystemProcedure (unsigned int sym);

/*
   IsPseudoSystemFunctionConstExpression - returns TRUE if this procedure
                                           is legal in a constant expression.
*/

extern "C" bool M2System_IsPseudoSystemFunctionConstExpression (unsigned int sym);

/*
   IsSystemType - returns TRUE if sym is a SYSTEM (inbuilt) type.
                  It does not search your SYSTEM implementation module.
*/

extern "C" bool M2System_IsSystemType (unsigned int sym);

/*
   IntegerN - returns the symbol associated with INTEGER[N].
              NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_IntegerN (unsigned int bitlength);

/*
   CardinalN - returns the symbol associated with CARDINAL[N].
               NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_CardinalN (unsigned int bitlength);

/*
   WordN - returns the symbol associated with WORD[N].
           NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_WordN (unsigned int bitlength);

/*
   SetN - returns the symbol associated with SET[N].
          NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_SetN (unsigned int bitlength);

/*
   RealN - returns the symbol associated with REAL[N].
           NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_RealN (unsigned int bitlength);

/*
   ComplexN - returns the symbol associated with COMPLEX[N].
              NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_ComplexN (unsigned int bitlength);

/*
   IsIntegerN - returns the TRUE if, sym, is one of the SYSTEM
                INTEGER types (not the base INTEGER type).
*/

extern "C" bool M2System_IsIntegerN (unsigned int sym);

/*
   IsCardinalN - returns the TRUE if, sym, is one of the SYSTEM
                 CARDINAL types (not the base CARDINAL type).
*/

extern "C" bool M2System_IsCardinalN (unsigned int sym);

/*
   IsWordN - returns the TRUE if, sym, is one of the SYSTEM
             WORD[n] types (not the default SYSTEM WORD type).
*/

extern "C" bool M2System_IsWordN (unsigned int sym);

/*
   IsSetN - returns the TRUE if, sym, is one of the SYSTEM
            SET[n] types (not the default SYSTEM BITSET type).
*/

extern "C" bool M2System_IsSetN (unsigned int sym);

/*
   IsRealN - returns the TRUE if, sym, is one of the SYSTEM
             REAL[n] types (not the default base REAL type).
*/

extern "C" bool M2System_IsRealN (unsigned int sym);

/*
   IsComplexN - returns the TRUE if, sym, is one of the SYSTEM
                COMPLEX[n] types (not the default base COMPLEX,
                LONGCOMPLEX or SHORTCOMPLEX types).
*/

extern "C" bool M2System_IsComplexN (unsigned int sym);

/*
   IsGenericSystemType - returns TRUE if, sym, is of type
                         BYTE, WORD or any other length.
*/

extern "C" bool M2System_IsGenericSystemType (unsigned int sym);

/*
   IsSameSizePervasiveType - returns TRUE if a or b are CARDINAL, INTEGER, REAL,
                             LONGREAL, SHORTREAL and the other type is the same
                             size and of the same type.
*/

extern "C" bool M2System_IsSameSizePervasiveType (unsigned int a, unsigned int b);

/*
   IsSameSize - return TRUE if SIZE(a)=SIZE(b)
*/

extern "C" bool M2System_IsSameSize (unsigned int a, unsigned int b);

/*
   Init -
*/

static void Init (void);

/*
   CreateMinMaxFor - creates the min and max values for type given gccType.
*/

static void CreateMinMaxFor (unsigned int type, const char *min_, unsigned int _min_high, const char *max_, unsigned int _max_high, tree gccType, bool realtype);

/*
   MapType - create a mapping of the M2 frontend type to gcctype.
*/

static void MapType (unsigned int type, const char *name_, unsigned int _name_high, const char *min_, unsigned int _min_high, const char *max_, unsigned int _max_high, bool needsExporting, tree gcctype, bool realtype);

/*
   CreateType - create and return a frontend type which matches the GCC tree type.
*/

static unsigned int CreateType (const char *name_, unsigned int _name_high, const char *min_, unsigned int _min_high, const char *max_, unsigned int _max_high, bool needsExporting, tree gccType, bool realtype);

/*
   AttemptToCreateType - attempts to create a frontend type which matches the
                         GCC tree type.
*/

static void AttemptToCreateType (const char *name_, unsigned int _name_high, const char *min_, unsigned int _min_high, const char *max_, unsigned int _max_high, bool needsExporting, tree gccType, bool realtype);

/*
   CreateSetType - creates and returns a, SET OF [0..highBit], type.
                   It maps this type onto the GCC type.
*/

static unsigned int CreateSetType (const char *name_, unsigned int _name_high, const char *highBit_, unsigned int _highBit_high, bool needsExporting, tree gccType);

/*
   AttemptToCreateSetType - creates and returns a, SET OF [0..highBit], type.
                            It maps this type onto the GCC type.
*/

static void AttemptToCreateSetType (const char *name_, unsigned int _name_high, const char *highBit_, unsigned int _highBit_high, bool needsExporting, tree gccType);

/*
   MakeFixedSizedTypes - creates the SYSTEM fixed sized types providing the
                         gcc backend supports them.
*/

static void MakeFixedSizedTypes (void);

/*
   InitPIMTypes -
*/

static void InitPIMTypes (void);

/*
   InitISOTypes -
*/

static void InitISOTypes (void);

/*
   MakeExtraSystemTypes - create any extra system types required
                          for portability.
*/

static void MakeExtraSystemTypes (void);

/*
   IsISOPseudoSystemFunction -
*/

static bool IsISOPseudoSystemFunction (unsigned int sym);

/*
   IsPIMPseudoSystemFunction - returns TRUE if sym is specifically a PIM
                               system function.
*/

static bool IsPIMPseudoSystemFunction (unsigned int sym);

/*
   GetSafeSystem -
*/

static unsigned int GetSafeSystem (NameKey_Name name);

/*
   IsSameType - returns TRUE if, t, is the same type as a or b
                and a or b are a type, p.
*/

static bool IsSameType (unsigned int t, M2System_IsP p, unsigned int a, unsigned int b);


/*
   Init -
*/

static void Init (void)
{
  Lists_InitList (&SystemTypes);
  SymbolKey_InitTree (&MinValues);
  SymbolKey_InitTree (&MaxValues);
}


/*
   CreateMinMaxFor - creates the min and max values for type given gccType.
*/

static void CreateMinMaxFor (unsigned int type, const char *min_, unsigned int _min_high, const char *max_, unsigned int _max_high, tree gccType, bool realtype)
{
  unsigned int maxval;
  unsigned int minval;
  char min[_min_high+1];
  char max[_max_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (min, min_, _min_high+1);
  memcpy (max, max_, _max_high+1);

  maxval = SymbolTable_MakeConstVar (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) max, _max_high));
  if (realtype)
    {
      M2ALU_PushRealTree (m2type_GetMaxFrom (m2linemap_BuiltinsLocation (), gccType));
    }
  else
    {
      M2ALU_PushIntegerTree (m2type_GetMaxFrom (m2linemap_BuiltinsLocation (), gccType));
    }
  SymbolTable_PopValue (maxval);
  SymbolTable_PutVar (maxval, type);
  SymbolKey_PutSymKey (MaxValues, SymbolTable_GetSymName (type), maxval);
  minval = SymbolTable_MakeConstVar (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) min, _min_high));
  if (realtype)
    {
      M2ALU_PushRealTree (m2type_GetMinFrom (m2linemap_BuiltinsLocation (), gccType));
    }
  else
    {
      M2ALU_PushIntegerTree (m2type_GetMinFrom (m2linemap_BuiltinsLocation (), gccType));
    }
  SymbolTable_PopValue (minval);
  SymbolTable_PutVar (minval, type);
  SymbolKey_PutSymKey (MinValues, SymbolTable_GetSymName (type), minval);
}


/*
   MapType - create a mapping of the M2 frontend type to gcctype.
*/

static void MapType (unsigned int type, const char *name_, unsigned int _name_high, const char *min_, unsigned int _min_high, const char *max_, unsigned int _max_high, bool needsExporting, tree gcctype, bool realtype)
{
  NameKey_Name n;
  char name[_name_high+1];
  char min[_min_high+1];
  char max[_max_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);
  memcpy (min, min_, _min_high+1);
  memcpy (max, max_, _max_high+1);

  M2ALU_PushIntegerTree (m2expr_BuildSize (m2linemap_BuiltinsLocation (), gcctype, false));
  SymbolTable_PopSize (type);
  if (Lists_IsItemInList (SystemTypes, type))
    {
      M2Error_InternalError ((const char *) "not expecting system type to already be declared", 48);
    }
  Lists_PutItemIntoList (SystemTypes, type);
  /* Create min, max constants if type is ordinal or a floating point type.  */
  if ((! (StrLib_StrEqual ((const char *) min, _min_high, (const char *) "", 0))) && (! (StrLib_StrEqual ((const char *) max, _max_high, (const char *) "", 0))))
    {
      CreateMinMaxFor (type, (const char *) min, _min_high, (const char *) max, _max_high, gcctype, realtype);
    }
  if (needsExporting && M2Options_DumpSystemExports)
    {
      n = SymbolTable_GetSymName (type);
      M2Printf_printf1 ((const char *) "SYSTEM module creates type: %a\\n", 32, (const unsigned char *) &n, (sizeof (n)-1));
    }
}


/*
   CreateType - create and return a frontend type which matches the GCC tree type.
*/

static unsigned int CreateType (const char *name_, unsigned int _name_high, const char *min_, unsigned int _min_high, const char *max_, unsigned int _max_high, bool needsExporting, tree gccType, bool realtype)
{
  unsigned int type;
  char name[_name_high+1];
  char min[_min_high+1];
  char max[_max_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);
  memcpy (min, min_, _min_high+1);
  memcpy (max, max_, _max_high+1);

  if (gccType == NULL)
    {
      /* GCC backend does not support this type.  */
      return SymbolTable_NulSym;
    }
  else
    {
      /* Create base type.  */
      type = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) name, _name_high));
      SymbolTable_PutType (type, SymbolTable_NulSym);  /* a Base Type  */
      MapType (type, (const char *) name, _name_high, (const char *) min, _min_high, (const char *) max, _max_high, needsExporting, gccType, realtype);  /* a Base Type  */
      return type;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AttemptToCreateType - attempts to create a frontend type which matches the
                         GCC tree type.
*/

static void AttemptToCreateType (const char *name_, unsigned int _name_high, const char *min_, unsigned int _min_high, const char *max_, unsigned int _max_high, bool needsExporting, tree gccType, bool realtype)
{
  char name[_name_high+1];
  char min[_min_high+1];
  char max[_max_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);
  memcpy (min, min_, _min_high+1);
  memcpy (max, max_, _max_high+1);

  Assertion_Assert (SymbolTable_IsLegal (CreateType ((const char *) name, _name_high, (const char *) min, _min_high, (const char *) max, _max_high, needsExporting, gccType, realtype)));
}


/*
   CreateSetType - creates and returns a, SET OF [0..highBit], type.
                   It maps this type onto the GCC type.
*/

static unsigned int CreateSetType (const char *name_, unsigned int _name_high, const char *highBit_, unsigned int _highBit_high, bool needsExporting, tree gccType)
{
  unsigned int low;
  unsigned int high;
  unsigned int subrange;
  unsigned int type;
  char name[_name_high+1];
  char highBit[_highBit_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);
  memcpy (highBit, highBit_, _highBit_high+1);

  if (gccType == NULL)
    {
      /* GCC backend does not support this type  */
      return SymbolTable_NulSym;
    }
  else
    {
      /* create base type  */
      type = SymbolTable_MakeSet (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) name, _name_high));
      low = SymbolTable_MakeConstLit (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
      high = SymbolTable_MakeConstLit (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) highBit, _highBit_high), M2Base_Cardinal);
      subrange = SymbolTable_MakeSubrange (M2LexBuf_BuiltinTokenNo, NameKey_NulName);
      SymbolTable_PutSubrange (subrange, low, high, M2Base_Cardinal);
      SymbolTable_PutSet (type, subrange, false);
      MapType (type, (const char *) name, _name_high, (const char *) "", 0, (const char *) "", 0, needsExporting, gccType, false);
      return type;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AttemptToCreateSetType - creates and returns a, SET OF [0..highBit], type.
                            It maps this type onto the GCC type.
*/

static void AttemptToCreateSetType (const char *name_, unsigned int _name_high, const char *highBit_, unsigned int _highBit_high, bool needsExporting, tree gccType)
{
  char name[_name_high+1];
  char highBit[_highBit_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);
  memcpy (highBit, highBit_, _highBit_high+1);

  Assertion_Assert (SymbolTable_IsLegal (CreateSetType ((const char *) name, _name_high, (const char *) highBit, _highBit_high, needsExporting, gccType)));
}


/*
   MakeFixedSizedTypes - creates the SYSTEM fixed sized types providing the
                         gcc backend supports them.
*/

static void MakeFixedSizedTypes (void)
{
  AttemptToCreateType ((const char *) "INTEGER8", 8, (const char *) "MinInteger8", 11, (const char *) "MaxInteger8", 11, true, m2type_GetM2Integer8 (), false);
  AttemptToCreateType ((const char *) "INTEGER16", 9, (const char *) "MinInteger16", 12, (const char *) "MaxInteger16", 12, true, m2type_GetM2Integer16 (), false);
  AttemptToCreateType ((const char *) "INTEGER32", 9, (const char *) "MinInteger32", 12, (const char *) "MaxInteger32", 12, true, m2type_GetM2Integer32 (), false);
  AttemptToCreateType ((const char *) "INTEGER64", 9, (const char *) "MinInteger64", 12, (const char *) "MaxInteger64", 12, true, m2type_GetM2Integer64 (), false);
  AttemptToCreateType ((const char *) "CARDINAL8", 9, (const char *) "MinCardinal8", 12, (const char *) "MaxCardinal8", 12, true, m2type_GetM2Cardinal8 (), false);
  AttemptToCreateType ((const char *) "CARDINAL16", 10, (const char *) "MinCardinal16", 13, (const char *) "MaxCardinal16", 13, true, m2type_GetM2Cardinal16 (), false);
  AttemptToCreateType ((const char *) "CARDINAL32", 10, (const char *) "MinCardinal32", 13, (const char *) "MaxCardinal32", 13, true, m2type_GetM2Cardinal32 (), false);
  AttemptToCreateType ((const char *) "CARDINAL64", 10, (const char *) "MinCardinal64", 13, (const char *) "MaxCardinal64", 13, true, m2type_GetM2Cardinal64 (), false);
  AttemptToCreateType ((const char *) "WORD16", 6, (const char *) "", 0, (const char *) "", 0, true, m2type_GetM2Word16 (), false);
  AttemptToCreateType ((const char *) "WORD32", 6, (const char *) "", 0, (const char *) "", 0, true, m2type_GetM2Word32 (), false);
  AttemptToCreateType ((const char *) "WORD64", 6, (const char *) "", 0, (const char *) "", 0, true, m2type_GetM2Word64 (), false);
  AttemptToCreateSetType ((const char *) "BITSET8", 7, (const char *) "7", 1, true, m2type_GetM2Bitset8 ());
  AttemptToCreateSetType ((const char *) "BITSET16", 8, (const char *) "15", 2, true, m2type_GetM2Bitset16 ());
  AttemptToCreateSetType ((const char *) "BITSET32", 8, (const char *) "31", 2, true, m2type_GetM2Bitset32 ());
  AttemptToCreateType ((const char *) "REAL32", 6, (const char *) "MinReal32", 9, (const char *) "MaxReal32", 9, true, m2type_GetM2Real32 (), true);
  AttemptToCreateType ((const char *) "REAL64", 6, (const char *) "MinReal64", 9, (const char *) "MaxReal64", 9, true, m2type_GetM2Real64 (), true);
  AttemptToCreateType ((const char *) "REAL96", 6, (const char *) "MinReal96", 9, (const char *) "MaxReal96", 9, true, m2type_GetM2Real96 (), true);
  AttemptToCreateType ((const char *) "REAL128", 7, (const char *) "MinReal128", 10, (const char *) "MaxReal128", 10, true, m2type_GetM2Real128 (), true);
  AttemptToCreateType ((const char *) "COMPLEX32", 9, (const char *) "", 0, (const char *) "", 0, true, m2type_GetM2Complex32 (), true);
  AttemptToCreateType ((const char *) "COMPLEX64", 9, (const char *) "", 0, (const char *) "", 0, true, m2type_GetM2Complex64 (), true);
  AttemptToCreateType ((const char *) "COMPLEX96", 9, (const char *) "", 0, (const char *) "", 0, true, m2type_GetM2Complex96 (), true);
  AttemptToCreateType ((const char *) "COMPLEX128", 10, (const char *) "", 0, (const char *) "", 0, true, m2type_GetM2Complex128 (), true);
}


/*
   InitPIMTypes -
*/

static void InitPIMTypes (void)
{
  M2System_Loc = CreateType ((const char *) "LOC", 3, (const char *) "", 0, (const char *) "", 0, true, m2type_GetISOLocType (), false);
  m2type_InitSystemTypes (m2linemap_BuiltinsLocation (), static_cast<int> (M2System_Loc));
  M2System_Word = CreateType ((const char *) "WORD", 4, (const char *) "", 0, (const char *) "", 0, true, m2type_GetWordType (), false);
  M2System_Byte = CreateType ((const char *) "BYTE", 4, (const char *) "", 0, (const char *) "", 0, true, m2type_GetByteType (), false);
  /* ADDRESS = POINTER TO BYTE  */
  M2System_Address = SymbolTable_MakePointer (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ADDRESS", 7));
  SymbolTable_PutPointer (M2System_Address, M2System_Byte);  /* Base Type  */
  MapType (M2System_Address, (const char *) "ADDRESS", 7, (const char *) "", 0, (const char *) "", 0, true, m2type_GetPointerType (), false);  /* Base Type  */
}


/*
   InitISOTypes -
*/

static void InitISOTypes (void)
{
  M2System_Loc = CreateType ((const char *) "LOC", 3, (const char *) "MinLoc", 6, (const char *) "MaxLoc", 6, true, m2type_GetISOLocType (), false);
  m2type_InitSystemTypes (m2linemap_BuiltinsLocation (), static_cast<int> (M2System_Loc));
  M2System_Address = SymbolTable_MakePointer (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ADDRESS", 7));
  SymbolTable_PutPointer (M2System_Address, M2System_Loc);  /* Base Type  */
  MapType (M2System_Address, (const char *) "ADDRESS", 7, (const char *) "", 0, (const char *) "", 0, true, m2type_GetPointerType (), false);  /* Base Type  */
  M2System_Byte = CreateType ((const char *) "BYTE", 4, (const char *) "", 0, (const char *) "", 0, true, m2type_GetISOByteType (), false);
  M2System_Word = CreateType ((const char *) "WORD", 4, (const char *) "", 0, (const char *) "", 0, true, m2type_GetISOWordType (), false);
}


/*
   MakeExtraSystemTypes - create any extra system types required
                          for portability.
*/

static void MakeExtraSystemTypes (void)
{
  M2System_CSizeT = CreateType ((const char *) "CSIZE_T", 7, (const char *) "", 0, (const char *) "", 0, true, m2type_GetCSizeTType (), false);
  M2System_CSSizeT = CreateType ((const char *) "CSSIZE_T", 8, (const char *) "", 0, (const char *) "", 0, true, m2type_GetCSSizeTType (), false);
  M2System_COffT = CreateType ((const char *) "COFF_T", 6, (const char *) "", 0, (const char *) "", 0, true, m2type_GetCOffTType (), false);
}


/*
   IsISOPseudoSystemFunction -
*/

static bool IsISOPseudoSystemFunction (unsigned int sym)
{
  return M2Options_Iso && (((((((sym == M2System_AddAdr) || (sym == M2System_SubAdr)) || (sym == M2System_DifAdr)) || (sym == M2System_MakeAdr)) || (sym == M2System_Rotate)) || (sym == M2System_Shift)) || (sym == M2System_Cast));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPIMPseudoSystemFunction - returns TRUE if sym is specifically a PIM
                               system function.
*/

static bool IsPIMPseudoSystemFunction (unsigned int sym)
{
  return ! M2Options_Iso && (((sym == M2Size_Size) || (sym == M2System_Shift)) || (sym == M2System_Rotate));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetSafeSystem -
*/

static unsigned int GetSafeSystem (NameKey_Name name)
{
  unsigned int sym;
  unsigned int i;
  unsigned int n;

  n = Lists_NoOfItemsInList (SystemTypes);
  i = 1;
  while (i <= n)
    {
      sym = static_cast<unsigned int> (Lists_GetItemFromList (SystemTypes, i));
      if ((SymbolTable_GetSymName (sym)) == name)
        {
          return sym;
        }
      i += 1;
    }
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSameType - returns TRUE if, t, is the same type as a or b
                and a or b are a type, p.
*/

static bool IsSameType (unsigned int t, M2System_IsP p, unsigned int a, unsigned int b)
{
  if (t == a)
    {
      return ((*p.proc) (b)) && (M2System_IsSameSize (a, b));
    }
  else if (t == b)
    {
      /* avoid dangling else.  */
      return ((*p.proc) (a)) && (M2System_IsSameSize (a, b));
    }
  else
    {
      /* avoid dangling else.  */
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitSystem - creates the system dependant types and procedures.
                Note that they are not exported here, but they are
                exported in the textual module: SYSTEM.def.
                We build our system types from those given in the gcc
                backend. Essentially we perform double book keeping.
*/

extern "C" void M2System_InitSystem (void)
{
  unsigned int Previous;

  Init ();
  /* create SYSTEM module  */
  M2System_System = M2Batch_MakeDefinitionSource (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SYSTEM", 6));
  SymbolTable_StartScope (M2System_System);
  Previous = SymbolTable_GetCurrentModule ();
  SymbolTable_SetCurrentModule (M2System_System);
  if (M2Options_Iso)
    {
      InitISOTypes ();
      M2Size_MakeSize ();
      SymbolTable_PutExportQualified (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SIZE", 4));
    }
  else
    {
      InitPIMTypes ();
      /* SIZE is declared in SYSTEM.def in PIM-2 but not PIM-[34]  */
      if (M2Options_Pedantic)
        {
          /* avoid dangling else.  */
          if (M2Options_Pim2)
            {
              M2Size_MakeSize ();
              SymbolTable_PutExportQualified (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SIZE", 4));
            }
        }
      else
        {
          M2Size_MakeSize ();
          SymbolTable_PutExportQualified (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SIZE", 4));
        }
    }
  /* The predefined pseudo functions.  */
  M2System_Adr = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ADR", 3));  /* Function  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2System_Adr, SymbolTable_DefProcedure, M2System_Address);
  /* Address  */
  M2System_TSize = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "TSIZE", 5));  /* Function  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2System_TSize, SymbolTable_DefProcedure, M2Base_ZType);
  /* ZType  */
  M2System_TBitSize = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "TBITSIZE", 8));  /* GNU extension  */
  /* Function  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2System_TBitSize, SymbolTable_DefProcedure, M2Base_ZType);
  /* The ISO specific predefined pseudo functions.  */
  M2System_AddAdr = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ADDADR", 6));  /* Function  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2System_AddAdr, SymbolTable_DefProcedure, M2System_Address);
  /* Return Type  */
  M2System_SubAdr = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SUBADR", 6));  /* Function  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2System_SubAdr, SymbolTable_DefProcedure, M2System_Address);
  /* Return Type  */
  M2System_DifAdr = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "DIFADR", 6));  /* Function  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2System_DifAdr, SymbolTable_DefProcedure, M2System_Address);
  /* Return Type  */
  M2System_MakeAdr = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "MAKEADR", 7));  /* Function  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2System_MakeAdr, SymbolTable_DefProcedure, M2System_Address);
  /* The return value for ROTATE, SHIFT and CAST is the
      same as the first parameter and is faked in M2Quads.  */
  M2System_Rotate = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ROTATE", 6));  /* Function  */
  M2System_Shift = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SHIFT", 5));  /* Function  */
  M2System_Cast = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "CAST", 4));  /* Function  */
  M2System_Throw = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "THROW", 5));  /* Procedure  */
  SymbolTable_PutProcedureNoReturn (M2System_Throw, SymbolTable_DefProcedure, true);  /* Procedure  */
  CreateMinMaxFor (M2System_Word, (const char *) "MinWord", 7, (const char *) "MaxWord", 7, m2type_GetWordType (), false);
  CreateMinMaxFor (M2System_Address, (const char *) "MinAddress", 10, (const char *) "MaxAddress", 10, m2type_GetPointerType (), false);
  CreateMinMaxFor (M2System_Byte, (const char *) "MinByte", 7, (const char *) "MaxByte", 7, m2type_GetByteType (), false);
  MakeFixedSizedTypes ();
  MakeExtraSystemTypes ();
  SymbolTable_EndScope ();
  SymbolTable_SetCurrentModule (Previous);
}


/*
   GetSystemTypeMinMax - returns the minimum and maximum values for a given system type.
*/

extern "C" void M2System_GetSystemTypeMinMax (unsigned int type, unsigned int *min, unsigned int *max)
{
  if (Lists_IsItemInList (SystemTypes, type))
    {
      (*min) = static_cast<unsigned int> (SymbolKey_GetSymKey (MinValues, SymbolTable_GetSymName (type)));
      (*max) = static_cast<unsigned int> (SymbolKey_GetSymKey (MaxValues, SymbolTable_GetSymName (type)));
    }
  else
    {
      M2Error_InternalError ((const char *) "system does not know about this type", 36);
    }
}


/*
   IsPseudoSystemFunction - returns true if sym is a SYSTEM pseudo function.
*/

extern "C" bool M2System_IsPseudoSystemFunction (unsigned int sym)
{
  return ((((sym == M2System_Adr) || (sym == M2System_TSize)) || (sym == M2System_TBitSize)) || (IsPIMPseudoSystemFunction (sym))) || (IsISOPseudoSystemFunction (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPseudoSystemProcedure - returns true if sym is a SYSTEM pseudo procedure.
*/

extern "C" bool M2System_IsPseudoSystemProcedure (unsigned int sym)
{
  return sym == M2System_Throw;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPseudoSystemFunctionConstExpression - returns TRUE if this procedure
                                           is legal in a constant expression.
*/

extern "C" bool M2System_IsPseudoSystemFunctionConstExpression (unsigned int sym)
{
  return ((((sym == M2Size_Size) || (sym == M2System_TSize)) || (sym == M2System_Rotate)) || (sym == M2System_Shift)) || (M2Options_Iso && ((sym == M2System_Cast) || (sym == M2System_MakeAdr)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSystemType - returns TRUE if sym is a SYSTEM (inbuilt) type.
                  It does not search your SYSTEM implementation module.
*/

extern "C" bool M2System_IsSystemType (unsigned int sym)
{
  return Lists_IsItemInList (SystemTypes, sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IntegerN - returns the symbol associated with INTEGER[N].
              NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_IntegerN (unsigned int bitlength)
{
  switch (bitlength)
    {
      case 8:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "INTEGER8", 8));
        break;

      case 16:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "INTEGER16", 9));
        break;

      case 32:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "INTEGER32", 9));
        break;

      case 64:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "INTEGER64", 9));
        break;


      default:
        M2Error_InternalError ((const char *) "system does not know about this type", 36);
        break;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2System.def", 20, 1);
  __builtin_unreachable ();
}


/*
   CardinalN - returns the symbol associated with CARDINAL[N].
               NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_CardinalN (unsigned int bitlength)
{
  switch (bitlength)
    {
      case 8:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "CARDINAL8", 9));
        break;

      case 16:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "CARDINAL16", 10));
        break;

      case 32:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "CARDINAL32", 10));
        break;

      case 64:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "CARDINAL64", 10));
        break;


      default:
        M2Error_InternalError ((const char *) "system does not know about this type", 36);
        break;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2System.def", 20, 1);
  __builtin_unreachable ();
}


/*
   WordN - returns the symbol associated with WORD[N].
           NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_WordN (unsigned int bitlength)
{
  switch (bitlength)
    {
      case 16:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "WORD16", 6));
        break;

      case 32:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "WORD32", 6));
        break;

      case 64:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "WORD64", 6));
        break;


      default:
        M2Error_InternalError ((const char *) "system does not know about this type", 36);
        break;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2System.def", 20, 1);
  __builtin_unreachable ();
}


/*
   SetN - returns the symbol associated with SET[N].
          NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_SetN (unsigned int bitlength)
{
  switch (bitlength)
    {
      case 8:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "BITSET8", 7));
        break;

      case 16:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "BITSET16", 8));
        break;

      case 32:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "BITSET32", 8));
        break;


      default:
        M2Error_InternalError ((const char *) "system does not know about this type", 36);
        break;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2System.def", 20, 1);
  __builtin_unreachable ();
}


/*
   RealN - returns the symbol associated with REAL[N].
           NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_RealN (unsigned int bitlength)
{
  switch (bitlength)
    {
      case 32:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "REAL32", 6));
        break;

      case 64:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "REAL64", 6));
        break;

      case 96:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "REAL96", 6));
        break;

      case 128:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "REAL128", 7));
        break;


      default:
        M2Error_InternalError ((const char *) "system does not know about this type", 36);
        break;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2System.def", 20, 1);
  __builtin_unreachable ();
}


/*
   ComplexN - returns the symbol associated with COMPLEX[N].
              NulSym is returned if the type does not exist.
*/

extern "C" unsigned int M2System_ComplexN (unsigned int bitlength)
{
  switch (bitlength)
    {
      case 32:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "COMPLEX32", 9));
        break;

      case 64:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "COMPLEX64", 9));
        break;

      case 96:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "COMPLEX96", 9));
        break;

      case 128:
        return GetSafeSystem (NameKey_MakeKey ((const char *) "COMPLEX128", 10));
        break;


      default:
        M2Error_InternalError ((const char *) "system does not know about this type", 36);
        break;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2System.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsIntegerN - returns the TRUE if, sym, is one of the SYSTEM
                INTEGER types (not the base INTEGER type).
*/

extern "C" bool M2System_IsIntegerN (unsigned int sym)
{
  return (sym != SymbolTable_NulSym) && ((((sym == (M2System_IntegerN (8))) || (sym == (M2System_IntegerN (16)))) || (sym == (M2System_IntegerN (32)))) || (sym == (M2System_IntegerN (64))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsCardinalN - returns the TRUE if, sym, is one of the SYSTEM
                 CARDINAL types (not the base CARDINAL type).
*/

extern "C" bool M2System_IsCardinalN (unsigned int sym)
{
  return (sym != SymbolTable_NulSym) && ((((sym == (M2System_CardinalN (8))) || (sym == (M2System_CardinalN (16)))) || (sym == (M2System_CardinalN (32)))) || (sym == (M2System_CardinalN (64))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsWordN - returns the TRUE if, sym, is one of the SYSTEM
             WORD[n] types (not the default SYSTEM WORD type).
*/

extern "C" bool M2System_IsWordN (unsigned int sym)
{
  return (sym != SymbolTable_NulSym) && (((sym == (M2System_WordN (16))) || (sym == (M2System_WordN (32)))) || (sym == (M2System_WordN (64))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSetN - returns the TRUE if, sym, is one of the SYSTEM
            SET[n] types (not the default SYSTEM BITSET type).
*/

extern "C" bool M2System_IsSetN (unsigned int sym)
{
  return (sym != SymbolTable_NulSym) && (((sym == (M2System_SetN (8))) || (sym == (M2System_SetN (16)))) || (sym == (M2System_SetN (32))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRealN - returns the TRUE if, sym, is one of the SYSTEM
             REAL[n] types (not the default base REAL type).
*/

extern "C" bool M2System_IsRealN (unsigned int sym)
{
  return (sym != SymbolTable_NulSym) && ((((sym == (M2System_RealN (32))) || (sym == (M2System_RealN (64)))) || (sym == (M2System_RealN (96)))) || (sym == (M2System_RealN (128))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsComplexN - returns the TRUE if, sym, is one of the SYSTEM
                COMPLEX[n] types (not the default base COMPLEX,
                LONGCOMPLEX or SHORTCOMPLEX types).
*/

extern "C" bool M2System_IsComplexN (unsigned int sym)
{
  return (sym != SymbolTable_NulSym) && ((((sym == (M2System_ComplexN (32))) || (sym == (M2System_ComplexN (64)))) || (sym == (M2System_ComplexN (96)))) || (sym == (M2System_ComplexN (128))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsGenericSystemType - returns TRUE if, sym, is of type
                         BYTE, WORD or any other length.
*/

extern "C" bool M2System_IsGenericSystemType (unsigned int sym)
{
  return (sym != SymbolTable_NulSym) && ((((M2System_IsWordN (sym)) || (sym == M2System_Word)) || (sym == M2System_Byte)) || (sym == M2System_Loc));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSameSizePervasiveType - returns TRUE if a or b are CARDINAL, INTEGER, REAL,
                             LONGREAL, SHORTREAL and the other type is the same
                             size and of the same type.
*/

extern "C" bool M2System_IsSameSizePervasiveType (unsigned int a, unsigned int b)
{
  return ((((((((((((IsSameType (M2Base_Integer, (M2System_IsP) {(M2System_IsP_t) M2System_IsIntegerN}, a, b)) || (IsSameType (M2Base_Cardinal, (M2System_IsP) {(M2System_IsP_t) M2System_IsCardinalN}, a, b))) || (IsSameType (M2System_Word, (M2System_IsP) {(M2System_IsP_t) M2System_IsWordN}, a, b))) || (IsSameType (M2Base_Real, (M2System_IsP) {(M2System_IsP_t) M2System_IsRealN}, a, b))) || (IsSameType (M2Base_Complex, (M2System_IsP) {(M2System_IsP_t) M2System_IsComplexN}, a, b))) || (IsSameType (M2Base_LongInt, (M2System_IsP) {(M2System_IsP_t) M2System_IsIntegerN}, a, b))) || (IsSameType (M2Base_LongCard, (M2System_IsP) {(M2System_IsP_t) M2System_IsCardinalN}, a, b))) || (IsSameType (M2Base_LongComplex, (M2System_IsP) {(M2System_IsP_t) M2System_IsComplexN}, a, b))) || (IsSameType (M2Base_LongReal, (M2System_IsP) {(M2System_IsP_t) M2System_IsRealN}, a, b))) || (IsSameType (M2Base_ShortInt, (M2System_IsP) {(M2System_IsP_t) M2System_IsIntegerN}, a, b))) || (IsSameType (M2Base_ShortCard, (M2System_IsP) {(M2System_IsP_t) M2System_IsCardinalN}, a, b))) || (IsSameType (M2Base_ShortComplex, (M2System_IsP) {(M2System_IsP_t) M2System_IsComplexN}, a, b))) || (IsSameType (M2Base_ShortReal, (M2System_IsP) {(M2System_IsP_t) M2System_IsRealN}, a, b));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSameSize - return TRUE if SIZE(a)=SIZE(b)
*/

extern "C" bool M2System_IsSameSize (unsigned int a, unsigned int b)
{
  return m2expr_AreConstantsEqual (m2expr_BuildSize (m2linemap_BuiltinsLocation (), SymbolConversion_Mod2Gcc (a), false), m2expr_BuildSize (m2linemap_BuiltinsLocation (), SymbolConversion_Mod2Gcc (b), false));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2System_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2System_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
