/* do not edit automatically generated by mc from PathName.  */
/* 
   HandleEscape - translates \a, \b, \e, \f, 
, \r, \x[hex] \[octal]
                  into their respective ascii codes.  It also converts
                  \[any] into a single [any] character.
  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _PathName_C

#include "GPathName.h"
#   include "GStorage.h"
#   include "GDynamicStrings.h"
#   include "GSFIO.h"
#   include "GFIO.h"
#   include "GM2Printf.h"
#   include "GFormatStrings.h"
#   include "GDynamicPath.h"
#   include "GM2RTS.h"

#   define Debugging false
typedef struct PathName__T1_r PathName__T1;

typedef PathName__T1 *PathName_NamedPath__opaque;

struct PathName__T1_r {
                        DynamicPath_PathList pathList;
                        DynamicStrings_String name;
                        PathName_NamedPath__opaque tail;
                        PathName_NamedPath__opaque next;
                      };

static PathName_NamedPath__opaque FreeList;
static PathName_NamedPath__opaque NamedPathHead;

/*
   FindNamedPathFile - Post-condition: returns NIL if a file cannot be found otherwise
                       it returns the path including the filename.
                       It also returns a new string the name of the path.
                       Pre-condition: if name = NIL then it searches
                                          user path first, followed by any
                                          named path.
                                      elsif name = ''
                                      then
                                         search user path
                                      else
                                         search named path
                                      fi
*/

extern "C" DynamicStrings_String PathName_FindNamedPathFile (DynamicStrings_String filename, DynamicStrings_String *name);

/*
   AddInclude - adds include path to the named path.  If named path
                is the same as the previous call then the include path
                is appended to the named path PathList otherwise a new
                named path is created and placed at the end of the
                named path list.
*/

extern "C" void PathName_AddInclude (DynamicStrings_String named, DynamicStrings_String directory);

/*
   InitNamedPath - creates a new path name with an associated pathlist.
*/

extern "C" PathName_NamedPath PathName_InitNamedPath (DynamicStrings_String name, DynamicPath_PathList pl);

/*
   KillNamedPath - places list np onto the freelist.
                   Postcondition: np will be NIL.
*/

extern "C" void PathName_KillNamedPath (PathName_NamedPath *np);

/*
   Cons - appends pl to the end of a named path.
          If np is NIL a new list is created and returned
          containing named and pl.
*/

extern "C" PathName_NamedPath PathName_Cons (PathName_NamedPath np, DynamicStrings_String named, DynamicPath_PathList pl);

/*
   ConsList - concatenates named path left and right together.
*/

extern "C" PathName_NamedPath PathName_ConsList (PathName_NamedPath left, PathName_NamedPath right);

/*
   Stash - returns np before setting np to NIL.
*/

extern "C" PathName_NamedPath PathName_Stash (PathName_NamedPath *np);

/*
   SetNamedPath - assigns the named path to the default path.
*/

extern "C" void PathName_SetNamedPath (PathName_NamedPath named);

/*
   GetNamedPath - returns the default named path.
*/

extern "C" PathName_NamedPath PathName_GetNamedPath (void);

/*
   DumpPathName - display the dictionary of names and all path entries.
*/

extern "C" void PathName_DumpPathName (const char *name_, unsigned int _name_high);

/*
   AddSystem -
*/

static void AddSystem (DynamicStrings_String named, DynamicStrings_String directory);

/*
   AddUser -
*/

static void AddUser (DynamicStrings_String named, DynamicStrings_String directory);


/*
   AddSystem -
*/

static void AddSystem (DynamicStrings_String named, DynamicStrings_String directory)
{
  if (NamedPathHead == NULL)
    {
      /* Empty dictionary add single entry.  */
      PathName_SetNamedPath (PathName_InitNamedPath (named, DynamicPath_InitPathList (directory)));
    }
  else if (DynamicStrings_Equal (NamedPathHead->tail->name, named))
    {
      /* avoid dangling else.  */
      NamedPathHead->tail->pathList = DynamicPath_Cons (NamedPathHead->tail->pathList, directory);
    }
  else
    {
      /* avoid dangling else.  */
      PathName_SetNamedPath (PathName_ConsList (static_cast<PathName_NamedPath> (NamedPathHead), PathName_InitNamedPath (named, DynamicPath_InitPathList (directory))));
    }
}


/*
   AddUser -
*/

static void AddUser (DynamicStrings_String named, DynamicStrings_String directory)
{
  if (NamedPathHead == NULL)
    {
      /* Empty dictionary add single entry.  */
      PathName_SetNamedPath (PathName_InitNamedPath (named, DynamicPath_InitPathList (directory)));
    }
  else if (DynamicStrings_EqualArray (NamedPathHead->name, (const char *) "", 0))
    {
      /* avoid dangling else.  */
      /* Found user node.  */
      NamedPathHead->pathList = DynamicPath_Cons (NamedPathHead->pathList, directory);
    }
  else
    {
      /* avoid dangling else.  */
      /* No user node yet, so we will create one.  */
      NamedPathHead = static_cast<PathName_NamedPath__opaque> (PathName_ConsList (PathName_InitNamedPath (named, DynamicPath_InitPathList (directory)), static_cast<PathName_NamedPath> (NamedPathHead)));
      PathName_SetNamedPath (static_cast<PathName_NamedPath> (NamedPathHead));
    }
}


/*
   FindNamedPathFile - Post-condition: returns NIL if a file cannot be found otherwise
                       it returns the path including the filename.
                       It also returns a new string the name of the path.
                       Pre-condition: if name = NIL then it searches
                                          user path first, followed by any
                                          named path.
                                      elsif name = ''
                                      then
                                         search user path
                                      else
                                         search named path
                                      fi
*/

extern "C" DynamicStrings_String PathName_FindNamedPathFile (DynamicStrings_String filename, DynamicStrings_String *name)
{
  DynamicStrings_String foundFile;
  PathName_NamedPath__opaque np;

  np = NamedPathHead;
  while (np != NULL)
    {
      if (((*name) == NULL) || (DynamicStrings_Equal (np->name, (*name))))
        {
          foundFile = DynamicPath_FindFileName (filename, np->pathList);
          if (foundFile != NULL)
            {
              (*name) = DynamicStrings_Dup (np->name);
              return foundFile;
            }
        }
      np = np->next;
    }
  (*name) = static_cast<DynamicStrings_String> (NULL);
  return static_cast<DynamicStrings_String> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddInclude - adds include path to the named path.  If named path
                is the same as the previous call then the include path
                is appended to the named path PathList otherwise a new
                named path is created and placed at the end of the
                named path list.
*/

extern "C" void PathName_AddInclude (DynamicStrings_String named, DynamicStrings_String directory)
{
  if (Debugging)
    {
      M2Printf_fprintf2 (FIO_StdErr, (const char *) "named = %s, directory =%s\\n", 27, (const unsigned char *) &named, (sizeof (named)-1), (const unsigned char *) &directory, (sizeof (directory)-1));
    }
  if ((named == NULL) || (DynamicStrings_EqualArray (named, (const char *) "", 0)))
    {
      /* avoid dangling else.  */
      AddUser (named, directory);
      if (Debugging)
        {
          PathName_DumpPathName ((const char *) "User pathname", 13);
        }
    }
  else
    {
      AddSystem (named, directory);
      if (Debugging)
        {
          PathName_DumpPathName ((const char *) "System pathname", 15);
        }
    }
}


/*
   InitNamedPath - creates a new path name with an associated pathlist.
*/

extern "C" PathName_NamedPath PathName_InitNamedPath (DynamicStrings_String name, DynamicPath_PathList pl)
{
  PathName_NamedPath__opaque np;

  Storage_ALLOCATE ((void **) &np, sizeof (PathName__T1));
  if (np == NULL)
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  else
    {
      np->pathList = pl;
      np->name = DynamicStrings_Dup (name);
      np->next = static_cast<PathName_NamedPath__opaque> (NULL);
      np->tail = np;
    }
  return static_cast<PathName_NamedPath> (np);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillNamedPath - places list np onto the freelist.
                   Postcondition: np will be NIL.
*/

extern "C" void PathName_KillNamedPath (PathName_NamedPath *np)
{
  if ((*np) != NULL)
    {
      static_cast<PathName_NamedPath__opaque> ((*np))->tail->next = FreeList;
      FreeList = static_cast<PathName_NamedPath__opaque> ((*np));
      (*np) = static_cast<PathName_NamedPath> (NULL);
    }
}


/*
   Cons - appends pl to the end of a named path.
          If np is NIL a new list is created and returned
          containing named and pl.
*/

extern "C" PathName_NamedPath PathName_Cons (PathName_NamedPath np, DynamicStrings_String named, DynamicPath_PathList pl)
{
  if (np == NULL)
    {
      np = PathName_InitNamedPath (named, pl);
    }
  else
    {
      np = PathName_ConsList (np, PathName_InitNamedPath (named, pl));
    }
  return np;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConsList - concatenates named path left and right together.
*/

extern "C" PathName_NamedPath PathName_ConsList (PathName_NamedPath left, PathName_NamedPath right)
{
  if (right != NULL)
    {
      static_cast<PathName_NamedPath__opaque> (left)->tail->next = static_cast<PathName_NamedPath__opaque> (right);
      static_cast<PathName_NamedPath__opaque> (left)->tail = static_cast<PathName_NamedPath__opaque> (right)->tail;
    }
  return left;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Stash - returns np before setting np to NIL.
*/

extern "C" PathName_NamedPath PathName_Stash (PathName_NamedPath *np)
{
  PathName_NamedPath__opaque old;

  old = static_cast<PathName_NamedPath__opaque> ((*np));
  (*np) = static_cast<PathName_NamedPath> (NULL);
  return static_cast<PathName_NamedPath> (old);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetNamedPath - assigns the named path to the default path.
*/

extern "C" void PathName_SetNamedPath (PathName_NamedPath named)
{
  NamedPathHead = static_cast<PathName_NamedPath__opaque> (named);
}


/*
   GetNamedPath - returns the default named path.
*/

extern "C" PathName_NamedPath PathName_GetNamedPath (void)
{
  return static_cast<PathName_NamedPath> (NamedPathHead);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DumpPathName - display the dictionary of names and all path entries.
*/

extern "C" void PathName_DumpPathName (const char *name_, unsigned int _name_high)
{
  PathName_NamedPath__opaque np;
  DynamicStrings_String leader;
  char name[_name_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);

  M2Printf_fprintf0 (FIO_StdErr, (const char *) name, _name_high);
  M2Printf_fprintf0 (FIO_StdErr, (const char *) " = {\\n", 6);
  np = NamedPathHead;
  while (np != NULL)
    {
      leader = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "  %s", 4)), (const unsigned char *) &np->name, (sizeof (np->name)-1));
      DynamicPath_DumpPath (leader, np->pathList);
      leader = DynamicStrings_KillString (leader);
      np = np->next;
    }
  M2Printf_fprintf0 (FIO_StdErr, (const char *) "}\\n", 3);
}

extern "C" void _M2_PathName_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  NamedPathHead = static_cast<PathName_NamedPath__opaque> (NULL);
  FreeList = static_cast<PathName_NamedPath__opaque> (NULL);
}

extern "C" void _M2_PathName_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
