/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern4 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  switch (GET_CODE (x4))
    {
    case AND:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x6 = XEXP (x4, 0);
      operands[2] = x6;
      if (!register_operand (operands[2], E_QImode))
        return -1;
      return pattern3 (x2); /* [-1, 1] */

    case PLUS:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x6 = XEXP (x4, 0);
      operands[2] = x6;
      if (!nonimmediate_operand (operands[2], E_QImode))
        return -1;
      res = pattern3 (x2);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      x6 = XEXP (x4, 0);
      operands[3] = x6;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      x7 = XEXP (x4, 1);
      operands[2] = x7;
      if (!nonimmediate_operand (operands[2], E_QImode))
        return -1;
      res = pattern2 (x2);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      return 6;

    default:
      return -1;
    }
}

int
pattern33 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      return pattern5 (x3, 
E_V32QImode); /* [-1, 0] */

    case E_V16HImode:
      if (pattern5 (x3, 
E_V16HImode) != 0)
        return -1;
      return 1;

    case E_V8SImode:
      if (pattern5 (x3, 
E_V8SImode) != 0)
        return -1;
      return 2;

    case E_V16SImode:
      if (pattern5 (x3, 
E_V16SImode) != 0)
        return -1;
      return 3;

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode)
        return -1;
      return 4;

    case E_V8DImode:
      if (pattern5 (x3, 
E_V8DImode) != 0)
        return -1;
      return 5;

    case E_V4DImode:
      if (pattern5 (x3, 
E_V4DImode) != 0)
        return -1;
      return 6;

    case E_V2DImode:
      if (pattern5 (x3, 
E_V2DImode) != 0)
        return -1;
      return 7;

    case E_V64QImode:
      if (pattern5 (x3, 
E_V64QImode) != 0)
        return -1;
      return 8;

    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode)
        return -1;
      return 9;

    case E_V32HImode:
      if (pattern5 (x3, 
E_V32HImode) != 0)
        return -1;
      return 10;

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern42 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_TImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  return pattern41 (x2, 
E_DImode, 
E_TImode); /* [-1, 0] */
}

int
pattern46 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!flags_reg_operand (operands[0], E_VOIDmode))
    return -1;
  operands[1] = x2;
  if (!compare_operator (operands[1], E_VOIDmode))
    return -1;
  x5 = XEXP (x2, 0);
  x6 = XEXP (x5, 0);
  operands[2] = x6;
  if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
    return -1;
  x7 = XEXP (x5, 1);
  operands[3] = x7;
  if (!const_int_operand (operands[3], E_QImode))
    return -1;
  x8 = XEXP (x5, 2);
  operands[4] = x8;
  if (!const_int_operand (operands[4], E_QImode))
    return -1;
  switch (GET_MODE (x5))
    {
    case E_HImode:
      return 0;

    case E_SImode:
      return 1;

    case E_DImode:
      return 2;

    default:
      return -1;
    }
}

int
pattern56 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern57 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x4 = XEXP (x1, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern62 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      return pattern61 (x3, 
E_HFmode); /* [-1, 0] */

    case E_SFmode:
      if (pattern61 (x3, 
E_SFmode) != 0)
        return -1;
      return 1;

    case E_DFmode:
      if (pattern61 (x3, 
E_DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern70 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  return pattern69 (x1); /* [-1, 2] */
}

int
pattern76 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  x4 = XEXP (x1, 0);
  switch (GET_CODE (x4))
    {
    case STRICT_LOW_PART:
      return pattern72 (x1, pnum_clobbers); /* [-1, 1] */

    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (pattern73 (x2, pnum_clobbers) != 0)
            return -1;
          return 2;

        case E_HImode:
          if (pattern74 (x2, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V2SFmode:
          if (pattern7 (x2, 
E_V2SFmode) != 0)
            return -1;
          return 4;

        case E_V2BFmode:
          if (pattern7 (x2, 
E_V2BFmode) != 0)
            return -1;
          return 5;

        case E_V4BFmode:
          if (pattern7 (x2, 
E_V4BFmode) != 0)
            return -1;
          return 6;

        case E_V2HFmode:
          if (pattern7 (x2, 
E_V2HFmode) != 0)
            return -1;
          return 7;

        case E_V4HFmode:
          if (pattern7 (x2, 
E_V4HFmode) != 0)
            return -1;
          return 8;

        case E_V8QImode:
          if (pattern8 (x2, 
E_V8QImode) != 0)
            return -1;
          return 9;

        case E_V4HImode:
          if (pattern8 (x2, 
E_V4HImode) != 0)
            return -1;
          return 10;

        case E_V2SImode:
          if (pattern8 (x2, 
E_V2SImode) != 0)
            return -1;
          return 11;

        case E_V4QImode:
          if (pattern75 (x2, pnum_clobbers, 
E_V4QImode) != 0)
            return -1;
          return 12;

        case E_V2QImode:
          if (pattern75 (x2, pnum_clobbers, 
E_V2QImode) != 0)
            return -1;
          return 13;

        case E_V2HImode:
          if (pattern75 (x2, pnum_clobbers, 
E_V2HImode) != 0)
            return -1;
          return 14;

        case E_BFmode:
          if (pattern7 (x2, 
E_BFmode) != 0)
            return -1;
          return 15;

        case E_HFmode:
          if (pattern7 (x2, 
E_HFmode) != 0)
            return -1;
          return 16;

        case E_SFmode:
          if (pattern7 (x2, 
E_SFmode) != 0)
            return -1;
          return 17;

        case E_DFmode:
          if (pattern7 (x2, 
E_DFmode) != 0)
            return -1;
          return 18;

        case E_TFmode:
          if (pattern25 (x2, 
E_TFmode) != 0)
            return -1;
          return 19;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern109 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      switch (GET_MODE (x2))
        {
        case E_SImode:
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          return 0;

        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode)
              || !nonmemory_operand (operands[2], E_QImode))
            return -1;
          return 1;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode)
              || !nonmemory_operand (operands[2], E_QImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonmemory_operand (operands[2], E_QImode))
        return -1;
      switch (GET_MODE (x2))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode))
            return -1;
          return 3;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern128 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern140 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 2);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!nonimmediate_operand (operands[0], E_V16QImode)
          || GET_MODE (x1) != E_V16QImode
          || GET_MODE (x2) != E_V16QImode
          || !nonimm_or_0_operand (operands[2], E_V16QImode)
          || !register_operand (operands[3], E_HImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V16SImode:
          if (!register_operand (operands[1], E_V16SImode))
            return -1;
          return 0;

        case E_V16HImode:
          if (!register_operand (operands[1], E_V16HImode))
            return -1;
          return 1;

        default:
          return -1;
        }

    case E_V16HImode:
      if (pattern139 (x1, 
E_V16HImode, 
E_HImode, 
E_V16SImode) != 0)
        return -1;
      return 2;

    case E_V8SImode:
      if (pattern139 (x1, 
E_V8SImode, 
E_QImode, 
E_V8DImode) != 0)
        return -1;
      return 3;

    case E_V8HImode:
      if (!nonimmediate_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode
          || GET_MODE (x2) != E_V8HImode
          || !nonimm_or_0_operand (operands[2], E_V8HImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8DImode:
          if (!register_operand (operands[1], E_V8DImode))
            return -1;
          return 4;

        case E_V8SImode:
          if (!register_operand (operands[1], E_V8SImode))
            return -1;
          return 5;

        default:
          return -1;
        }

    case E_V32QImode:
      if (pattern139 (x1, 
E_V32QImode, 
E_SImode, 
E_V32HImode) != 0)
        return -1;
      return 6;

    case E_V4SImode:
      if (pattern139 (x1, 
E_V4SImode, 
E_QImode, 
E_V4DImode) != 0)
        return -1;
      return 7;

    default:
      return -1;
    }
}

int
pattern158 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i2))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], i2))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern163 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2))
    return -1;
  return 0;
}

int
pattern166 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      return pattern165 (x3, 
E_V32HFmode, 
E_V64QImode, 
E_V32QImode); /* [-1, 0] */

    case E_V16QImode:
      if (pattern165 (x3, 
E_V16HFmode, 
E_V32QImode, 
E_V16QImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern176 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HImode:
      return pattern172 (x3, 
E_V32HImode); /* [-1, 0] */

    case E_V16SImode:
      if (pattern172 (x3, 
E_V16SImode) != 0)
        return -1;
      return 1;

    case E_V8DImode:
      if (pattern172 (x3, 
E_V8DImode) != 0)
        return -1;
      return 2;

    case E_V16HImode:
      if (pattern172 (x3, 
E_V16HImode) != 0)
        return -1;
      return 3;

    case E_V8SImode:
      if (pattern172 (x3, 
E_V8SImode) != 0)
        return -1;
      return 4;

    case E_V4DImode:
      if (pattern172 (x3, 
E_V4DImode) != 0)
        return -1;
      return 5;

    case E_V8HImode:
      if (pattern172 (x3, 
E_V8HImode) != 0)
        return -1;
      return 6;

    case E_V4SImode:
      if (pattern172 (x3, 
E_V4SImode) != 0)
        return -1;
      return 7;

    case E_V2DImode:
      if (pattern172 (x3, 
E_V2DImode) != 0)
        return -1;
      return 8;

    default:
      return -1;
    }
}

int
pattern190 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_CONCAT)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x1, 1);
  if (GET_CODE (x5) != VEC_SELECT)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != VEC_CONCAT)
    return -1;
  x7 = XEXP (x5, 1);
  if (GET_CODE (x7) != PARALLEL)
    return -1;
  x8 = XEXP (x3, 0);
  operands[1] = x8;
  x9 = XEXP (x3, 1);
  operands[2] = x9;
  x10 = XEXP (x6, 0);
  if (!rtx_equal_p (x10, operands[1]))
    return -1;
  x11 = XEXP (x6, 1);
  if (!rtx_equal_p (x11, operands[2]))
    return -1;
  switch (XVECLEN (x4, 0))
    {
    case 16:
      return pattern188 (x1); /* [-1, 0] */

    case 8:
      x12 = XVECEXP (x4, 0, 0);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x13 = XVECEXP (x4, 0, 1);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x14 = XVECEXP (x4, 0, 2);
      if (GET_CODE (x14) != CONST_INT)
        return -1;
      x15 = XVECEXP (x4, 0, 3);
      if (GET_CODE (x15) != CONST_INT)
        return -1;
      x16 = XVECEXP (x4, 0, 4);
      if (GET_CODE (x16) != CONST_INT)
        return -1;
      x17 = XVECEXP (x4, 0, 5);
      if (GET_CODE (x17) != CONST_INT)
        return -1;
      x18 = XVECEXP (x4, 0, 6);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
        return -1;
      x19 = XVECEXP (x4, 0, 7);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 14]
          || XVECLEN (x7, 0) != 8)
        return -1;
      x20 = XVECEXP (x7, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x21 = XVECEXP (x7, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x22 = XVECEXP (x7, 0, 2);
      if (GET_CODE (x22) != CONST_INT)
        return -1;
      x23 = XVECEXP (x7, 0, 3);
      if (GET_CODE (x23) != CONST_INT)
        return -1;
      x24 = XVECEXP (x7, 0, 4);
      if (GET_CODE (x24) != CONST_INT)
        return -1;
      x25 = XVECEXP (x7, 0, 5);
      if (GET_CODE (x25) != CONST_INT)
        return -1;
      x26 = XVECEXP (x7, 0, 6);
      if (x26 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
        return -1;
      x27 = XVECEXP (x7, 0, 7);
      if (x27 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
        return -1;
      switch (XWINT (x14, 0))
        {
        case 4L:
          if (XWINT (x15, 0) != 6L
              || XWINT (x16, 0) != 8L
              || XWINT (x17, 0) != 10L
              || XWINT (x22, 0) != 5L
              || XWINT (x23, 0) != 7L
              || XWINT (x24, 0) != 9L
              || XWINT (x25, 0) != 11L
              || pattern189 (x1, 
E_V16HImode, 
E_V8HImode) != 0)
            return -1;
          return 1;

        case 8L:
          if (XWINT (x15, 0) != 10L
              || XWINT (x16, 0) != 4L
              || XWINT (x17, 0) != 6L
              || XWINT (x22, 0) != 9L
              || XWINT (x23, 0) != 11L
              || XWINT (x24, 0) != 5L
              || XWINT (x25, 0) != 7L
              || pattern187 (x1, 
E_V16SImode, 
E_V8SImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case 4:
      x12 = XVECEXP (x4, 0, 0);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x13 = XVECEXP (x4, 0, 1);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x14 = XVECEXP (x4, 0, 2);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x15 = XVECEXP (x4, 0, 3);
      if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 6]
          || XVECLEN (x7, 0) != 4)
        return -1;
      x20 = XVECEXP (x7, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x21 = XVECEXP (x7, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x22 = XVECEXP (x7, 0, 2);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x23 = XVECEXP (x7, 0, 3);
      if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern189 (x1, 
E_V8SImode, 
E_V4SImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern220 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UMOD)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  x8 = XEXP (x6, 1);
  operands[3] = x8;
  x9 = XEXP (x2, 0);
  operands[1] = x9;
  x10 = XEXP (x3, 0);
  if (!rtx_equal_p (x10, operands[2]))
    return -1;
  x11 = XEXP (x3, 1);
  if (!rtx_equal_p (x11, operands[3]))
    return -1;
  switch (GET_CODE (operands[3]))
    {
    case REG:
    case SUBREG:
    case MEM:
      return 0;

    case CONST_INT:
      return 1;

    default:
      return -1;
    }
}

int
pattern230 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != MEM)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PLUS)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  return 0;
}

int
pattern238 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern237 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern237 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern237 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern237 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern249 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != VEC_SELECT)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != PARALLEL
      || XVECLEN (x2, 0) != 1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern253 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != SUBREG
      || maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[2] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XEXP (x1, 0);
      if (GET_CODE (x8) != ZERO_EXTRACT)
        return -1;
      x9 = XEXP (x8, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x10 = XEXP (x8, 2);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      if (!int248_register_operand (operands[0], E_VOIDmode))
        return -1;
      x12 = XEXP (x5, 0);
      operands[1] = x12;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      switch (GET_MODE (x8))
        {
        case E_HImode:
          if (GET_MODE (x2) != E_HImode
              || !extract_operator (operands[2], E_HImode))
            return -1;
          return 0;

        case E_SImode:
          if (GET_MODE (x2) != E_SImode
              || !extract_operator (operands[2], E_SImode))
            return -1;
          return 1;

        case E_DImode:
          if (GET_MODE (x2) != E_DImode
              || !extract_operator (operands[2], E_DImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern283 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern282 (x1); /* [-1, 1] */

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      x2 = XEXP (x1, 0);
      switch (GET_MODE (x2))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode))
            return -1;
          return 2;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode))
            return -1;
          return 3;

        case E_SImode:
          if (pnum_clobbers == NULL
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern296 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], E_DImode)
      || GET_MODE (x1) != E_DImode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_V8QImode:
      return pattern99 (); /* [-1, 2] */

    case E_V4HImode:
      switch (GET_MODE (operands[1]))
        {
        case E_V4SImode:
          if (!register_operand (operands[1], E_V4SImode))
            return -1;
          return 3;

        case E_V4DImode:
          if (!register_operand (operands[1], E_V4DImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    case E_V2SImode:
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern308 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern316 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_all_ones_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1)
      || !const_0_to_7_operand (operands[5], E_SImode))
    return -1;
  return 0;
}

int
pattern322 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x1) != E_V16SFmode
          || !nonimmediate_operand (operands[1], E_V16SFmode))
        return -1;
      return 0;

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x1) != E_V8SFmode
          || !nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      return 1;

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x1) != E_V4SFmode
          || !nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 2;

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x1) != E_V8DFmode
          || !nonimmediate_operand (operands[1], E_V8DFmode))
        return -1;
      return 3;

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x1) != E_V4DFmode
          || !nonimmediate_operand (operands[1], E_V4DFmode))
        return -1;
      return 4;

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x1) != E_V2DFmode
          || !nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern333 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern336 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !bcst_vector_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !bcst_vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern340 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  return 0;
}

int
pattern342 (rtx x1, int *pnum_clobbers, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != i1
      || GET_MODE (x6) != E_SImode)
    return -1;
  x7 = XEXP (x2, 0);
  operands[0] = x7;
  if (!register_operand (operands[0], E_DImode)
      || GET_MODE (x3) != E_DImode)
    return -1;
  return 0;
}

int
pattern346 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  return pattern345 (x6); /* [-1, 5] */
}

int
pattern350 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  return pattern349 (x1); /* [-1, 5] */
}

int
pattern354 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[2], i2))
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_MODE (x5) != i1
      || !nonimmediate_operand (operands[4], i2)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern358 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17)
    return -1;
  x6 = XEXP (x4, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x7) != CLOBBER)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_CODE (x8) != REG
      || REGNO (x8) != 17
      || GET_MODE (x8) != E_CCmode)
    return -1;
  x9 = XEXP (x2, 0);
  operands[0] = x9;
  x10 = XEXP (x3, 1);
  operands[1] = x10;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return 0;

    case E_HImode:
      return 1;

    case E_SImode:
      return 2;

    case E_DImode:
      return 3;

    default:
      return -1;
    }
}

int
pattern367 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x2, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17)
    return -1;
  x6 = XEXP (x3, 0);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x6, 1);
  operands[2] = x8;
  x9 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x9))
    {
    case SET:
      x10 = XEXP (x9, 0);
      operands[0] = x10;
      return 0;

    case CLOBBER:
      x10 = XEXP (x9, 0);
      operands[0] = x10;
      switch (GET_MODE (x6))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode)
              || !const_1_to_31_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_QImode))
            return -1;
          return 1;

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode)
              || !const_1_to_31_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_HImode))
            return -1;
          return 2;

        case E_SImode:
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !const_1_to_31_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_SImode))
            return -1;
          return 3;

        case E_DImode:
          if (!nonimmediate_operand (operands[1], E_DImode)
              || !const_1_to_63_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_DImode))
            return -1;
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern392 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[1], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern400 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern407 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern414 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!general_reg_operand (operands[0], i1)
      || GET_CODE (x1) != PARALLEL
      || XVECLEN (x1, 0) != 2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (!commutative_operator (x3, i1))
    return -1;
  operands[3] = x3;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  x6 = XEXP (x3, 1);
  operands[2] = x6;
  if (!memory_operand (operands[2], i1))
    return -1;
  x7 = XEXP (x3, 0);
  if (!rtx_equal_p (x7, operands[0]))
    return -1;
  x8 = XEXP (x2, 0);
  if (!rtx_equal_p (x8, operands[0]))
    return -1;
  return 0;
}

int
pattern425 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_SFmode))
        return -1;
      return 0;

    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern432 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x3, 0);
  operands[3] = x5;
  if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
    return -1;
  x6 = XEXP (x2, 1);
  operands[1] = x6;
  x7 = XEXP (x1, 1);
  operands[2] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return 0;

    case E_HImode:
      return 1;

    default:
      return -1;
    }
}

int
pattern445 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !x86_64_general_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern450 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  if (maybe_ne (SUBREG_BYTE (x2), 0)
      || GET_MODE (x2) != E_QImode)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      return pattern449 (x1); /* [-1, 1] */

    case PLUS:
      x4 = XEXP (x3, 0);
      operands[2] = x4;
      if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern448 (x1);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      x4 = XEXP (x3, 0);
      operands[3] = x4;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern16 (x1);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern466 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i4)
      || !nonimmediate_operand (operands[2], i3)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern472 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XEXP (x1, 1);
  switch (GET_CODE (x6))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x6;
      x7 = XEXP (x1, 2);
      if (GET_CODE (x7) != UNSPEC
          || XVECLEN (x7, 0) != 1
          || XINT (x7, 1) != 223)
        return -1;
      x8 = XVECEXP (x7, 0, 0);
      operands[5] = x8;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (!register_operand (operands[0], E_V32HFmode)
              || GET_MODE (x1) != E_V32HFmode
              || GET_MODE (x2) != E_V32HFmode
              || !vector_operand (operands[1], E_V32HFmode)
              || !vector_operand (operands[2], E_V32HFmode)
              || !vector_operand (operands[3], E_V32HFmode)
              || !const0_operand (operands[4], E_V32HFmode)
              || GET_MODE (x7) != E_SImode
              || !register_operand (operands[5], E_HImode))
            return -1;
          return 0;

        case E_V16HFmode:
          if (pattern470 (x1, 
E_HImode, 
E_V16HFmode) != 0)
            return -1;
          return 1;

        case E_V8HFmode:
          if (pattern470 (x1, 
E_QImode, 
E_V8HFmode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      x7 = XEXP (x1, 2);
      switch (GET_CODE (x7))
        {
        case UNSPEC:
          if (XVECLEN (x7, 0) != 1
              || XINT (x7, 1) != 223)
            return -1;
          x8 = XVECEXP (x7, 0, 0);
          operands[4] = x8;
          if (!rtx_equal_p (x6, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (!register_operand (operands[0], E_V32HFmode)
                  || GET_MODE (x1) != E_V32HFmode
                  || GET_MODE (x2) != E_V32HFmode
                  || !vector_operand (operands[1], E_V32HFmode)
                  || !vector_operand (operands[2], E_V32HFmode)
                  || !vector_operand (operands[3], E_V32HFmode)
                  || GET_MODE (x7) != E_SImode
                  || !register_operand (operands[4], E_HImode))
                return -1;
              return 3;

            case E_V16HFmode:
              if (pattern471 (x1, 
E_HImode, 
E_V16HFmode) != 0)
                return -1;
              return 4;

            case E_V8HFmode:
              if (pattern471 (x1, 
E_QImode, 
E_V8HFmode) != 0)
                return -1;
              return 5;

            default:
              return -1;
            }

        case CONST_INT:
          if (XWINT (x7, 0) != 3L
              || !register_operand (operands[0], E_V8HFmode)
              || GET_MODE (x1) != E_V8HFmode
              || GET_MODE (x2) != E_V8HFmode
              || !vector_operand (operands[1], E_V8HFmode)
              || !vector_operand (operands[2], E_V8HFmode)
              || !vector_operand (operands[3], E_V8HFmode)
              || !rtx_equal_p (x6, operands[2]))
            return -1;
          return 6;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern505 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i2
      || !nonimm_or_0_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4SImode:
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern512 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x1) != E_V16QImode)
        return -1;
      x2 = XEXP (x1, 0);
      switch (GET_MODE (x2))
        {
        case E_V4QImode:
          return pattern511 (
E_V12QImode); /* [-1, 1] */

        case E_V2QImode:
          if (!register_operand (operands[1], E_V2DImode)
              || !const0_operand (operands[2], E_V14QImode))
            return -1;
          return 2;

        case E_V8QImode:
          if (!const0_operand (operands[2], E_V8QImode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8SImode:
              if (!register_operand (operands[1], E_V8SImode))
                return -1;
              return 3;

            case E_V8HImode:
              if (!register_operand (operands[1], E_V8HImode))
                return -1;
              return 4;

            default:
              return -1;
            }

        default:
          return -1;
        }

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode)
        return -1;
      x2 = XEXP (x1, 0);
      switch (GET_MODE (x2))
        {
        case E_V4HImode:
          res = pattern511 (
E_V4HImode);
          if (res >= 0)
            return res + 5; /* [5, 6] */
          return -1;

        case E_V2HImode:
          if (!register_operand (operands[1], E_V2DImode)
              || !const0_operand (operands[2], E_V6HImode))
            return -1;
          return 7;

        default:
          return -1;
        }

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode)
        return -1;
      x2 = XEXP (x1, 0);
      if (GET_MODE (x2) != E_V2SImode
          || !register_operand (operands[1], E_V2DImode)
          || !const0_operand (operands[2], E_V2SImode))
        return -1;
      return 8;

    default:
      return -1;
    }
}

int
pattern534 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  operands[3] = x6;
  x7 = XEXP (x1, 1);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      return pattern530 (x1, 
E_V32HFmode); /* [-1, 0] */

    case E_V16HFmode:
      if (pattern530 (x1, 
E_V16HFmode) != 0)
        return -1;
      return 1;

    case E_V8HFmode:
      if (pattern530 (x1, 
E_V8HFmode) != 0)
        return -1;
      return 2;

    case E_V32BFmode:
      if (pattern530 (x1, 
E_V32BFmode) != 0)
        return -1;
      return 3;

    case E_V16BFmode:
      if (pattern530 (x1, 
E_V16BFmode) != 0)
        return -1;
      return 4;

    case E_V8BFmode:
      if (pattern530 (x1, 
E_V8BFmode) != 0)
        return -1;
      return 5;

    case E_V16SFmode:
      if (pattern530 (x1, 
E_V16SFmode) != 0)
        return -1;
      return 6;

    case E_V8SFmode:
      if (pattern530 (x1, 
E_V8SFmode) != 0)
        return -1;
      return 7;

    case E_V4SFmode:
      if (pattern530 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 8;

    case E_V8DFmode:
      if (pattern530 (x1, 
E_V8DFmode) != 0)
        return -1;
      return 9;

    case E_V4DFmode:
      if (pattern530 (x1, 
E_V4DFmode) != 0)
        return -1;
      return 10;

    case E_V2DFmode:
      if (pattern530 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern543 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_XFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  if (!register_operand (operands[0], E_XFmode))
    return -1;
  x7 = XVECEXP (x3, 0, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_XFmode))
    return -1;
  return 0;
}

int
pattern548 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_V2SFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != UNSPEC
      || XVECLEN (x4, 0) != 1
      || XINT (x4, 1) != 110)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  if (!register_operand (operands[0], E_V2SFmode))
    return -1;
  x7 = XVECEXP (x3, 0, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_V2SFmode))
    return -1;
  x8 = XVECEXP (x3, 0, 1);
  operands[2] = x8;
  if (!nonimmediate_operand (operands[2], E_V2SFmode))
    return -1;
  return 0;
}

int
pattern558 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || pattern557 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern561 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern567 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != E_QImode)
    return -1;
  return 0;
}

int
pattern571 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_SImode
      || !register_operand (operands[0], E_SImode)
      || !register_operand (operands[1], E_SImode)
      || !register_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern576 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  if (!const_int_operand (operands[3], E_QImode))
    return -1;
  return pattern574 (x1); /* [-1, 3] */
}

int
pattern582 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  return 0;
}

int
pattern586 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != UNSPEC
      || XVECLEN (x4, 0) != 1
      || XINT (x4, 1) != 32)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x1, 0, 3);
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 17
      || GET_MODE (x7) != E_CCmode)
    return -1;
  x8 = XVECEXP (x1, 0, 0);
  x9 = XEXP (x8, 0);
  operands[0] = x9;
  return pattern585 (x1); /* [-1, 1] */
}

int
pattern593 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[5] = x2;
  if (!memory_operand (operands[5], i1))
    return -1;
  x3 = XEXP (x1, 1);
  operands[0] = x3;
  if (!general_reg_operand (operands[0], i1))
    return -1;
  x4 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x4, 0);
  operands[1] = x6;
  if (!memory_operand (operands[1], i1))
    return -1;
  x7 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x7) != SET)
    return -1;
  x8 = XEXP (x7, 1);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x9 = XEXP (x7, 0);
  operands[2] = x9;
  if (!memory_operand (operands[2], i1))
    return -1;
  x10 = PATTERN (peep2_next_insn (3));
  if (GET_CODE (x10) != SET)
    return -1;
  x11 = XEXP (x10, 1);
  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x12 = XEXP (x10, 0);
  operands[3] = x12;
  if (!memory_operand (operands[3], i1))
    return -1;
  x13 = PATTERN (peep2_next_insn (4));
  if (GET_CODE (x13) != SET)
    return -1;
  x14 = XEXP (x13, 1);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x15 = XEXP (x13, 0);
  operands[4] = x15;
  if (!memory_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern609 (rtx x1, int *pnum_clobbers, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL
      || !register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern616 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[2] = x4;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x5 = XEXP (x1, 1);
  operands[1] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern615 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern615 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern626 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern632 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
      operands[4] = x2;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          return 0;

        case E_V16HFmode:
          return 1;

        case E_V8HFmode:
          return 2;

        case E_V16SFmode:
          return 3;

        case E_V8SFmode:
          return 4;

        case E_V4SFmode:
          return 5;

        case E_V8DFmode:
          return 6;

        case E_V4DFmode:
          return 7;

        case E_V2DFmode:
          return 8;

        case E_V32BFmode:
          return 9;

        case E_V16BFmode:
          return 10;

        case E_V8BFmode:
          return 11;

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x2, 0) != 1L)
        return -1;
      x3 = XEXP (x1, 1);
      if (!rtx_equal_p (x3, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          return 12;

        case E_V4SFmode:
          return 13;

        case E_V2DFmode:
          return 14;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern644 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XVECEXP (x1, 0, 1);
  if (!const_4_or_8_to_11_operand (x6, E_SImode))
    return -1;
  x7 = XEXP (x2, 2);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
      operands[4] = x7;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      operands[5] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          return pattern641 (x1, 
E_V32HFmode, 
E_SImode); /* [-1, 0] */

        case E_V16HFmode:
          if (pattern641 (x1, 
E_V16HFmode, 
E_HImode) != 0)
            return -1;
          return 1;

        case E_V8HFmode:
          if (pattern641 (x1, 
E_V8HFmode, 
E_QImode) != 0)
            return -1;
          return 2;

        case E_V16SFmode:
          if (pattern641 (x1, 
E_V16SFmode, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V8SFmode:
          if (pattern641 (x1, 
E_V8SFmode, 
E_QImode) != 0)
            return -1;
          return 4;

        case E_V4SFmode:
          if (pattern641 (x1, 
E_V4SFmode, 
E_QImode) != 0)
            return -1;
          return 5;

        case E_V8DFmode:
          if (pattern641 (x1, 
E_V8DFmode, 
E_QImode) != 0)
            return -1;
          return 6;

        case E_V4DFmode:
          if (pattern641 (x1, 
E_V4DFmode, 
E_QImode) != 0)
            return -1;
          return 7;

        case E_V2DFmode:
          if (pattern641 (x1, 
E_V2DFmode, 
E_QImode) != 0)
            return -1;
          return 8;

        default:
          return -1;
        }

    case CONST_INT:
      res = pattern643 (x1);
      if (res >= 0)
        return res + 9; /* [9, 11] */
      return -1;

    default:
      return -1;
    }
}

int
pattern663 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V2SImode)
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_CODE (x3) != CONST_VECTOR
      || XVECLEN (x3, 0) != 2
      || GET_MODE (x3) != E_V2SImode)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
      || !register_operand (operands[0], E_V4SImode)
      || GET_MODE (x1) != E_V4SImode
      || !nonimmediate_operand (operands[1], E_V2DFmode))
    return -1;
  return 0;
}

int
pattern671 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XVECEXP (x3, 0, 2);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x3, 0, 3);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
      || GET_MODE (x2) != i2)
    return -1;
  x8 = XEXP (x2, 0);
  if (GET_MODE (x8) != i1)
    return -1;
  return pattern27 (x1); /* [-1, 1] */
}

int
pattern681 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XEXP (x3, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x7) != CLOBBER)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_CODE (x8) != REG
      || REGNO (x8) != 17
      || GET_MODE (x8) != E_CCmode)
    return -1;
  x9 = XEXP (x2, 0);
  operands[0] = x9;
  if (!register_operand (operands[0], E_QImode)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x10 = XEXP (x4, 0);
  operands[1] = x10;
  x11 = XEXP (x4, 2);
  operands[2] = x11;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_SImode:
      if (!register_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern693 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_TFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      return pattern690 (x5, 
E_TFmode); /* [-1, 0] */

    case E_HFmode:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern221 (x5, 
E_V8HFmode, 
E_HFmode) != 0)
        return -1;
      return 1;

    case E_SFmode:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern221 (x5, 
E_V4SFmode, 
E_SFmode) != 0)
        return -1;
      return 2;

    case E_DFmode:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern221 (x5, 
E_V2DFmode, 
E_DFmode) != 0)
        return -1;
      return 3;

    case E_V2SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern691 (x5) != 0)
        return -1;
      return 4;

    case E_V2BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V2BFmode) != 0)
        return -1;
      return 5;

    case E_V4BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V4BFmode) != 0)
        return -1;
      return 6;

    case E_V2HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V2HFmode) != 0)
        return -1;
      return 7;

    case E_V4HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V4HFmode) != 0)
        return -1;
      return 8;

    case E_V32BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V32BFmode) != 0)
        return -1;
      return 9;

    case E_V16BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16BFmode) != 0)
        return -1;
      return 10;

    case E_V8BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8BFmode) != 0)
        return -1;
      return 11;

    case E_V32HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V32HFmode) != 0)
        return -1;
      return 12;

    case E_V16HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16HFmode) != 0)
        return -1;
      return 13;

    case E_V8HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8HFmode) != 0)
        return -1;
      return 14;

    case E_V16SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16SFmode) != 0)
        return -1;
      return 15;

    case E_V8SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8SFmode) != 0)
        return -1;
      return 16;

    case E_V4SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V4SFmode) != 0)
        return -1;
      return 17;

    case E_V8DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8DFmode) != 0)
        return -1;
      return 18;

    case E_V4DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V4DFmode) != 0)
        return -1;
      return 19;

    case E_V2DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V2DFmode) != 0)
        return -1;
      return 20;

    default:
      return -1;
    }
}

int
pattern741 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !ix86_comparison_uns_operator (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern748 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern747 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern747 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern754 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern761 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  switch (GET_CODE (x2))
    {
    case UNSPEC:
      if (XVECLEN (x2, 0) != 3
          || XINT (x2, 1) != 59)
        return -1;
      x3 = XVECEXP (x2, 0, 2);
      if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x4 = XEXP (x1, 0);
      operands[3] = x4;
      x5 = XEXP (x1, 1);
      operands[4] = x5;
      x6 = XVECEXP (x2, 0, 0);
      operands[1] = x6;
      x7 = XVECEXP (x2, 0, 1);
      operands[2] = x7;
      switch (GET_MODE (x1))
        {
        case E_V32QImode:
          return pattern760 (x2, 
E_V32QImode, 
E_SImode); /* [-1, 0] */

        case E_V16QImode:
          if (pattern760 (x2, 
E_V16QImode, 
E_HImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      operands[1] = x2;
      x4 = XEXP (x1, 0);
      operands[2] = x4;
      x5 = XEXP (x1, 1);
      operands[3] = x5;
      switch (GET_MODE (x1))
        {
        case E_V16QImode:
          if (!vector_all_ones_operand (operands[2], E_V16QImode)
              || !const0_operand (operands[3], E_V16QImode)
              || !register_operand (operands[1], E_HImode))
            return -1;
          return 2;

        case E_V32QImode:
          if (!vector_all_ones_operand (operands[2], E_V32QImode)
              || !const0_operand (operands[3], E_V32QImode)
              || !register_operand (operands[1], E_SImode))
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern789 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern794 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !ix86_comparison_int_operator (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern803 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !bcst_vector_operand (operands[1], i1)
      || !bcst_vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern809 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17
      || GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern814 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case CLOBBER:
      x2 = XEXP (x1, 0);
      if (GET_CODE (x2) != REG
          || REGNO (x2) != 17
          || GET_MODE (x2) != E_CCmode)
        return -1;
      return 0;

    case UNSPEC:
      if (XVECLEN (x1, 0) != 1
          || XINT (x1, 1) != 174)
        return -1;
      x3 = XVECEXP (x1, 0, 0);
      if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          return 1;

        case E_HImode:
          return 2;

        case E_SImode:
          return 3;

        case E_DImode:
          return 4;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern822 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !nonmemory_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern824 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[3] = x4;
  return pattern440 (x1); /* [-1, 1] */
}

int
pattern828 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  return 0;
}

int
pattern835 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != 2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x3) != SET)
    return -1;
  x4 = XEXP (x3, 1);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  return 0;
}

int
pattern839 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != VEC_SELECT)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 1)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != VEC_SELECT)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PARALLEL
      || XVECLEN (x6, 0) != 1)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern847 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_CONCAT)
    return -1;
  x4 = XEXP (x1, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x5, 1);
  operands[2] = x7;
  x8 = XEXP (x3, 0);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  x9 = XEXP (x3, 1);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  x10 = XEXP (x4, 1);
  switch (XVECLEN (x10, 0))
    {
    case 4:
      x11 = XVECEXP (x10, 0, 0);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x12 = XVECEXP (x10, 0, 1);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x13 = XVECEXP (x10, 0, 2);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x14 = XVECEXP (x10, 0, 3);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x15 = XEXP (x2, 1);
      if (XVECLEN (x15, 0) != 4)
        return -1;
      x16 = XVECEXP (x15, 0, 0);
      if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x17 = XVECEXP (x15, 0, 1);
      if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x18 = XVECEXP (x15, 0, 2);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x19 = XVECEXP (x15, 0, 3);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern846 (x1, 
E_V8HImode, 
E_V4HImode) != 0)
        return -1;
      return 0;

    case 2:
      x11 = XVECEXP (x10, 0, 0);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x12 = XVECEXP (x10, 0, 1);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x15 = XEXP (x2, 1);
      if (XVECLEN (x15, 0) != 2)
        return -1;
      x16 = XVECEXP (x15, 0, 0);
      if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x17 = XVECEXP (x15, 0, 1);
      if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
          || pattern846 (x1, 
E_V4SImode, 
E_V2SImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern877 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern887 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4SImode:
      if (!nonimmediate_operand (operands[1], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!nonimmediate_operand (operands[1], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern899 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern905 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern907 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern911 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern913 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern918 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x2) != CONST_INT)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  return 0;
}

int
pattern926 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!memory_operand (operands[2], E_DImode))
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  return pattern388 (x5); /* [-1, 2] */
}

int
pattern932 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x3, 1);
  operands[2] = x6;
  x7 = XEXP (x4, 1);
  switch (GET_CODE (x7))
    {
    case NE:
      return pattern931 (x3); /* [-1, 3] */

    case EQ:
      res = pattern931 (x3);
      if (res >= 0)
        return res + 4; /* [4, 7] */
      return -1;

    default:
      return -1;
    }
}

int
pattern942 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern949 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[6] = x2;
  x3 = XEXP (x1, 1);
  operands[7] = x3;
  if (!memory_operand (operands[7], i1))
    return -1;
  x4 = PATTERN (peep2_next_insn (1));
  x5 = XEXP (x4, 1);
  operands[9] = x5;
  if (!memory_operand (operands[9], i1))
    return -1;
  x6 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x6) != PARALLEL
      || XVECLEN (x6, 0) != 2)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (GET_CODE (x7) != SET)
    return -1;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != COMPARE
      || GET_MODE (x8) != E_CCCmode)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_CODE (x9) != ZERO_EXTEND
      || GET_MODE (x9) != i2)
    return -1;
  x10 = XEXP (x8, 1);
  if (GET_CODE (x10) != PLUS
      || GET_MODE (x10) != i2)
    return -1;
  x11 = XEXP (x10, 0);
  if (!ix86_carry_flag_operator (x11, i2))
    return -1;
  operands[4] = x11;
  x12 = XEXP (x11, 1);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x13 = XEXP (x10, 1);
  if (GET_CODE (x13) != ZERO_EXTEND
      || GET_MODE (x13) != i2)
    return -1;
  x14 = XEXP (x7, 0);
  if (GET_CODE (x14) != REG
      || REGNO (x14) != 17
      || GET_MODE (x14) != E_CCCmode)
    return -1;
  x15 = XVECEXP (x6, 0, 1);
  if (GET_CODE (x15) != SET)
    return -1;
  x16 = XEXP (x15, 1);
  if (GET_CODE (x16) != MINUS
      || GET_MODE (x16) != i1)
    return -1;
  x17 = XEXP (x16, 0);
  if (GET_CODE (x17) != MINUS
      || GET_MODE (x17) != i1)
    return -1;
  x18 = XEXP (x17, 1);
  if (!ix86_carry_flag_operator (x18, i1))
    return -1;
  operands[5] = x18;
  x19 = XEXP (x18, 1);
  if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x20 = XEXP (x9, 0);
  operands[0] = x20;
  if (!general_reg_operand (operands[0], i1))
    return -1;
  x21 = XEXP (x11, 0);
  operands[3] = x21;
  if (!flags_reg_operand (operands[3], E_VOIDmode))
    return -1;
  x22 = XEXP (x13, 0);
  operands[2] = x22;
  if (!general_reg_operand (operands[2], i1))
    return -1;
  x23 = XEXP (x17, 0);
  if (!rtx_equal_p (x23, operands[0]))
    return -1;
  x24 = XEXP (x18, 0);
  if (!rtx_equal_p (x24, operands[3]))
    return -1;
  x25 = XEXP (x16, 1);
  if (!rtx_equal_p (x25, operands[2]))
    return -1;
  x26 = XEXP (x15, 0);
  if (!rtx_equal_p (x26, operands[0]))
    return -1;
  x27 = PATTERN (peep2_next_insn (3));
  if (GET_CODE (x27) != SET)
    return -1;
  x28 = XEXP (x27, 1);
  switch (GET_CODE (x28))
    {
    case REG:
      if (!rtx_equal_p (x28, operands[0]))
        return -1;
      x29 = XEXP (x27, 0);
      operands[1] = x29;
      if (!memory_operand (operands[1], i1))
        return -1;
      return 0;

    case LTU:
      if (peep2_current_count < 5
          || peep2_current_count < 6
          || GET_MODE (x28) != E_QImode)
        return -1;
      x30 = XEXP (x28, 0);
      if (GET_CODE (x30) != REG
          || REGNO (x30) != 17
          || GET_MODE (x30) != E_CCCmode)
        return -1;
      x31 = XEXP (x28, 1);
      if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x29 = XEXP (x27, 0);
      operands[10] = x29;
      if (!general_reg_operand (operands[10], E_QImode))
        return -1;
      x32 = PATTERN (peep2_next_insn (4));
      if (GET_CODE (x32) != SET)
        return -1;
      x33 = XEXP (x32, 1);
      if (GET_CODE (x33) != ZERO_EXTEND
          || GET_MODE (x33) != i1)
        return -1;
      x34 = XEXP (x32, 0);
      operands[11] = x34;
      if (!general_reg_operand (operands[11], i1))
        return -1;
      x35 = XEXP (x33, 0);
      if (!rtx_equal_p (x35, operands[10]))
        return -1;
      x36 = PATTERN (peep2_next_insn (5));
      if (GET_CODE (x36) != SET)
        return -1;
      x37 = XEXP (x36, 0);
      operands[1] = x37;
      if (!memory_operand (operands[1], i1))
        return -1;
      x38 = XEXP (x36, 1);
      if (!rtx_equal_p (x38, operands[0]))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern984 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V4DImode)
      || GET_MODE (x1) != E_V4DImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V4DImode
      || !nonimm_or_0_operand (operands[2], E_V4DImode)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V4DFmode:
      if (!vector_operand (operands[1], E_V4DFmode))
        return -1;
      return 1;

    case E_V4SFmode:
      if (!vector_operand (operands[1], E_V4SFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern996 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[2], i1)
      || !reg_or_0_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1005 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_comparison_uns_operator (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1011 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1)
      || !const48_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern1018 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1029 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case PLUS:
      return pattern1026 (x1); /* [-1, 0] */

    case MINUS:
      if (pattern1026 (x1) != 0)
        return -1;
      return 1;

    case AND:
      if (pattern1026 (x1) != 0)
        return -1;
      return 2;

    case IOR:
      if (pattern1026 (x1) != 0)
        return -1;
      return 3;

    case XOR:
      if (pattern1026 (x1) != 0)
        return -1;
      return 4;

    case NEG:
      if (GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != SUBREG
          || maybe_ne (SUBREG_BYTE (x4), 0)
          || GET_MODE (x4) != E_QImode)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SIGN_EXTRACT:
        case ZERO_EXTRACT:
          operands[2] = x5;
          x6 = XEXP (x5, 1);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x7 = XEXP (x5, 2);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x8 = XEXP (x1, 0);
          if (GET_CODE (x8) != ZERO_EXTRACT)
            return -1;
          x9 = XEXP (x8, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x10 = XEXP (x8, 2);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x11 = XEXP (x8, 0);
          operands[0] = x11;
          if (!int248_register_operand (operands[0], E_VOIDmode))
            return -1;
          x12 = XEXP (x5, 0);
          operands[1] = x12;
          if (!int248_register_operand (operands[1], E_VOIDmode))
            return -1;
          switch (GET_MODE (x8))
            {
            case E_HImode:
              if (GET_MODE (x2) != E_HImode
                  || !extract_operator (operands[2], E_HImode))
                return -1;
              return 5;

            case E_SImode:
              if (GET_MODE (x2) != E_SImode
                  || !extract_operator (operands[2], E_SImode))
                return -1;
              return 6;

            case E_DImode:
              if (GET_MODE (x2) != E_DImode
                  || !extract_operator (operands[2], E_DImode))
                return -1;
              return 7;

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ASHIFT:
      if (GET_MODE (x3) != E_QImode)
        return -1;
      res = pattern1028 (x1);
      if (res >= 0)
        return res + 8; /* [8, 10] */
      return -1;

    case LSHIFTRT:
      return 11;

    case ASHIFTRT:
      return 12;

    default:
      return -1;
    }
}

int
pattern1055 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != ZERO_EXTRACT)
    return -1;
  x3 = XEXP (x2, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x4 = XEXP (x2, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x5 = XEXP (x2, 0);
  operands[2] = x5;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x6 = XEXP (x1, 1);
  operands[3] = x6;
  switch (GET_MODE (x2))
    {
    case E_HImode:
      if (!const_int_operand (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!const_int_operand (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!const_int_operand (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1068 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern1081 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1087 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_MODE (x2))
    {
    case E_HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1090 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V2DImode)
      || GET_MODE (x1) != E_V2DImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V2DImode
      || !nonimm_or_0_operand (operands[2], E_V2DImode)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      return 0;

    case E_V2DFmode:
      return 1;

    default:
      return -1;
    }
}

int
pattern1095 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i3))
    return -1;
  return 0;
}

int
pattern1103 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1110 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  x6 = XEXP (x4, 0);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x5, 0);
  operands[2] = x8;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HImode:
      return pattern1109 (x1, 
E_SImode, 
E_V32HImode, 
E_V32SImode); /* [-1, 0] */

    case E_V16HImode:
      if (pattern1109 (x1, 
E_HImode, 
E_V16HImode, 
E_V16SImode) != 0)
        return -1;
      return 1;

    case E_V8HImode:
      if (pattern1109 (x1, 
E_QImode, 
E_V8HImode, 
E_V8SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1123 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !bcst_vector_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1126 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i2)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1134 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      return pattern1133 (x5, 
E_SImode); /* [-1, 1] */

    case E_DImode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      res = pattern1133 (x5, 
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1143 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1151 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case AND:
      x2 = XEXP (x1, 0);
      operands[2] = x2;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      x3 = XEXP (x1, 1);
      operands[3] = x3;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      return 0;

    case PLUS:
      x2 = XEXP (x1, 0);
      operands[2] = x2;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      x3 = XEXP (x1, 1);
      operands[3] = x3;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      return 1;

    case MINUS:
      x2 = XEXP (x1, 0);
      operands[3] = x2;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x3 = XEXP (x1, 1);
      operands[2] = x3;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1167 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case SUBREG:
      if (maybe_ne (SUBREG_BYTE (x2), 0)
          || GET_MODE (x2) != E_QImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[1] = x3;
      return pattern1155 (x1); /* [-1, 11] */

    case CONST_INT:
      return 12;

    default:
      return -1;
    }
}

int
pattern1176 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1182 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30;
  int res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[0]))
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  switch (GET_CODE (x5))
    {
    case COMPARE:
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != REG
          || REGNO (x6) != 17)
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x7) != SET)
        return -1;
      x8 = XEXP (x7, 1);
      if (GET_MODE (x8) != i1)
        return -1;
      x9 = XEXP (x7, 0);
      if (!rtx_equal_p (x9, operands[0]))
        return -1;
      x10 = XEXP (x2, 0);
      if (!rtx_equal_p (x10, operands[1]))
        return -1;
      x11 = XEXP (x5, 0);
      switch (GET_CODE (x11))
        {
        case REG:
          return pattern1177 (x1, 
i1); /* [-1, 0] */

        case ZERO_EXTEND:
          if (GET_MODE (x11) != i2)
            return -1;
          x12 = XEXP (x5, 1);
          if (GET_CODE (x12) != PLUS
              || GET_MODE (x12) != i2)
            return -1;
          x13 = XEXP (x12, 0);
          if (!ix86_carry_flag_operator (x13, i2))
            return -1;
          operands[4] = x13;
          x14 = XEXP (x13, 1);
          if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x15 = XEXP (x12, 1);
          if (GET_CODE (x15) != ZERO_EXTEND
              || GET_MODE (x15) != i2
              || GET_MODE (x6) != E_CCCmode
              || GET_MODE (x5) != E_CCCmode)
            return -1;
          x16 = XEXP (x11, 0);
          switch (GET_CODE (x16))
            {
            case PLUS:
              if (GET_MODE (x16) != i1)
                return -1;
              x17 = XEXP (x16, 0);
              if (GET_CODE (x17) != PLUS
                  || GET_MODE (x17) != i1)
                return -1;
              x18 = XEXP (x17, 0);
              if (!ix86_carry_flag_operator (x18, i1))
                return -1;
              operands[5] = x18;
              x19 = XEXP (x18, 1);
              if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
                  || GET_CODE (x8) != PLUS)
                return -1;
              x20 = XEXP (x8, 0);
              if (GET_CODE (x20) != PLUS
                  || GET_MODE (x20) != i1)
                return -1;
              x21 = XEXP (x20, 0);
              switch (GET_CODE (x21))
                {
                case LTU:
                case UNLT:
                  if (!rtx_equal_p (x21, operands[5]))
                    return -1;
                  x22 = XEXP (x18, 0);
                  operands[3] = x22;
                  if (!flags_reg_operand (operands[3], E_VOIDmode))
                    return -1;
                  x23 = XEXP (x16, 1);
                  operands[2] = x23;
                  if (!memory_operand (operands[2], i1))
                    return -1;
                  x24 = XEXP (x17, 1);
                  if (!rtx_equal_p (x24, operands[0]))
                    return -1;
                  x25 = XEXP (x13, 0);
                  if (!rtx_equal_p (x25, operands[3]))
                    return -1;
                  x26 = XEXP (x15, 0);
                  if (!rtx_equal_p (x26, operands[2]))
                    return -1;
                  x27 = XEXP (x20, 1);
                  if (!rtx_equal_p (x27, operands[0]))
                    return -1;
                  x28 = XEXP (x8, 1);
                  if (!rtx_equal_p (x28, operands[2]))
                    return -1;
                  return 1;

                default:
                  return -1;
                }

            case REG:
              if (!rtx_equal_p (x16, operands[0])
                  || GET_CODE (x8) != MINUS)
                return -1;
              x20 = XEXP (x8, 0);
              if (GET_CODE (x20) != MINUS
                  || GET_MODE (x20) != i1)
                return -1;
              x27 = XEXP (x20, 1);
              if (!ix86_carry_flag_operator (x27, i1))
                return -1;
              operands[5] = x27;
              x29 = XEXP (x27, 1);
              if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x25 = XEXP (x13, 0);
              operands[3] = x25;
              if (!flags_reg_operand (operands[3], E_VOIDmode))
                return -1;
              x26 = XEXP (x15, 0);
              operands[2] = x26;
              if (!memory_operand (operands[2], i1))
                return -1;
              x21 = XEXP (x20, 0);
              if (!rtx_equal_p (x21, operands[0]))
                return -1;
              x30 = XEXP (x27, 0);
              if (!rtx_equal_p (x30, operands[3]))
                return -1;
              x28 = XEXP (x8, 1);
              if (!rtx_equal_p (x28, operands[2]))
                return -1;
              return 2;

            default:
              return -1;
            }

        case PLUS:
          if (pattern1178 (x1, 
i1) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    case PLUS:
      res = pattern1180 (x1, 
i1);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    case MINUS:
      res = pattern1181 (x1, 
i1);
      if (res >= 0)
        return res + 6; /* [6, 7] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1252 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (maybe_ne (SUBREG_BYTE (x3), 0)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[4] = x4;
      x5 = XEXP (x4, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x6 = XEXP (x4, 2);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      return pattern1251 (x1); /* [-1, 5] */

    default:
      return -1;
    }
}

int
pattern1262 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[4], i3))
    return -1;
  return 0;
}

int
pattern1271 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i4
      || !nonimmediate_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern1282 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1293 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || GET_MODE (x2) != i2
      || !register_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1)
      || !const_4_or_8_to_11_operand (operands[4], E_SImode))
    return -1;
  return 0;
}

int
pattern1299 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1303 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  if (!vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1309 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (!rtx_equal_p (x4, operands[1]))
    return -1;
  x5 = XEXP (x3, 1);
  if (!rtx_equal_p (x5, operands[2]))
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 1);
  x8 = XEXP (x7, 0);
  switch (GET_MODE (x8))
    {
    case E_QImode:
      return pattern1308 (x3, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern1308 (x3, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern1308 (x3, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !const_1_to_63_operand (operands[2], E_QImode)
          || !nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1329 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!general_reg_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 0);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  x4 = PATTERN (peep2_next_insn (2));
  x5 = XEXP (x4, 1);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  x6 = XEXP (x4, 0);
  if (!rtx_equal_p (x6, operands[2]))
    return -1;
  return 0;
}

int
pattern1336 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  if (!general_reg_operand (operands[0], i1))
    return -1;
  switch (GET_CODE (x1))
    {
    case SET:
      x2 = XEXP (x1, 1);
      switch (GET_CODE (x2))
        {
        case CONST_INT:
          if (XWINT (x2, 0) != 0L)
            return -1;
          x3 = XEXP (x1, 0);
          if (GET_CODE (x3) != ZERO_EXTRACT)
            return -1;
          x4 = XEXP (x3, 1);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x5 = XEXP (x3, 2);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x6 = XEXP (x3, 0);
          operands[1] = x6;
          if (!int248_register_operand (operands[1], E_VOIDmode))
            return -1;
          switch (GET_MODE (x3))
            {
            case E_HImode:
              return 0;

            case E_SImode:
              return 1;

            case E_DImode:
              return 2;

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[2] = x2;
          x3 = XEXP (x1, 0);
          if (GET_CODE (x3) != STRICT_LOW_PART)
            return -1;
          x6 = XEXP (x3, 0);
          operands[1] = x6;
          res = pattern1328 ();
          if (res >= 0)
            return res + 3; /* [3, 4] */
          return -1;

        default:
          return -1;
        }

    case PARALLEL:
      if (XVECLEN (x1, 0) != 2)
        return -1;
      x7 = XVECEXP (x1, 0, 0);
      if (GET_CODE (x7) != SET)
        return -1;
      x8 = XEXP (x7, 1);
      switch (GET_CODE (x8))
        {
        case PLUS:
          if (GET_MODE (x8) != i1
              || pattern1331 (x1) != 0)
            return -1;
          return 5;

        case IOR:
          if (GET_MODE (x8) != i1
              || pattern1331 (x1) != 0)
            return -1;
          return 6;

        case XOR:
          if (GET_MODE (x8) != i1
              || pattern1331 (x1) != 0)
            return -1;
          return 7;

        case UNSPEC:
          if (peep2_current_count < 3
              || peep2_current_count < 4
              || XVECLEN (x8, 0) != 2
              || XINT (x8, 1) != 40
              || GET_MODE (x8) != E_CCCmode)
            return -1;
          x9 = XVECEXP (x8, 0, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x10 = XEXP (x7, 0);
          if (GET_CODE (x10) != REG
              || REGNO (x10) != 17
              || GET_MODE (x10) != E_CCCmode)
            return -1;
          x11 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x11) != SET)
            return -1;
          x12 = XEXP (x11, 1);
          if (GET_CODE (x12) != NEG
              || GET_MODE (x12) != i1)
            return -1;
          x13 = XVECEXP (x8, 0, 0);
          operands[1] = x13;
          if (!general_reg_operand (operands[1], i1))
            return -1;
          x14 = XEXP (x12, 0);
          if (!rtx_equal_p (x14, operands[1]))
            return -1;
          x15 = XEXP (x11, 0);
          if (!rtx_equal_p (x15, operands[1]))
            return -1;
          x16 = PATTERN (peep2_next_insn (2));
          if (pattern1183 (x16, 
i1) != 0)
            return -1;
          return 8;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1395 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 2);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
      operands[4] = x3;
      x4 = XVECEXP (x1, 0, 1);
      operands[5] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          return 0;

        case E_V16SFmode:
          return 1;

        case E_V8DFmode:
          return 2;

        case E_V16HFmode:
          return 3;

        case E_V8HFmode:
          return 4;

        case E_V8SFmode:
          return 5;

        case E_V4SFmode:
          return 6;

        case E_V4DFmode:
          return 7;

        case E_V2DFmode:
          return 8;

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x3, 0) != 1L)
        return -1;
      x4 = XVECEXP (x1, 0, 1);
      operands[4] = x4;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          return 9;

        case E_V4SFmode:
          return 10;

        case E_V2DFmode:
          return 11;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1414 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !scratch_operand (operands[0], i1))
    return -1;
  return 0;
}

int
pattern1422 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case AND:
      return pattern1421 (x3); /* [-1, 1] */

    case PLUS:
      res = pattern1421 (x3);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      x6 = XEXP (x5, 0);
      operands[3] = x6;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x7 = XEXP (x5, 1);
      operands[2] = x7;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern198 (x3);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1436 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!const_int_operand (operands[2], E_VOIDmode))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_SImode:
      return pattern1435 (x3, 
E_SImode); /* [-1, 2] */

    case E_DImode:
      res = pattern1435 (x3, 
E_DImode);
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1446 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x3, 2);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1457 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 12);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
    return -1;
  x3 = XVECEXP (x1, 0, 13);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x4 = XVECEXP (x1, 0, 14);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
    return -1;
  x5 = XVECEXP (x1, 0, 15);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  return 0;
}

int
pattern1464 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1471 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 4);
  operands[2] = x2;
  if (!const_4_to_7_operand (operands[2], E_VOIDmode))
    return -1;
  x3 = XVECEXP (x1, 0, 5);
  operands[3] = x3;
  if (!const_4_to_7_operand (operands[3], E_VOIDmode))
    return -1;
  x4 = XVECEXP (x1, 0, 6);
  operands[4] = x4;
  if (!const_4_to_7_operand (operands[4], E_VOIDmode))
    return -1;
  x5 = XVECEXP (x1, 0, 7);
  operands[5] = x5;
  if (!const_4_to_7_operand (operands[5], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1482 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[2], i1)
      || !scratch_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1493 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[1], E_V8HFmode)
          || !nonimmediate_operand (operands[2], E_V8HFmode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!register_operand (operands[1], E_V4SFmode)
          || !nonimmediate_operand (operands[2], E_V4SFmode))
        return -1;
      return 1;

    case E_V2DFmode:
      if (!register_operand (operands[1], E_V2DFmode)
          || !nonimmediate_operand (operands[2], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1507 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_carry_flag_operator (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1515 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case COMPARE:
      x4 = XEXP (x2, 0);
      if (GET_CODE (x4) != REG
          || REGNO (x4) != 17)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != SET)
        return -1;
      x6 = XEXP (x5, 1);
      if (GET_MODE (x6) != i1)
        return -1;
      x7 = XEXP (x5, 0);
      if (!rtx_equal_p (x7, operands[0]))
        return -1;
      x8 = PATTERN (peep2_next_insn (2));
      x9 = XEXP (x8, 0);
      if (!rtx_equal_p (x9, operands[1]))
        return -1;
      x10 = XEXP (x3, 0);
      switch (GET_CODE (x10))
        {
        case REG:
          return pattern1177 (x1, 
i1); /* [-1, 0] */

        case PLUS:
          if (pattern1178 (x1, 
i1) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case PLUS:
      res = pattern1180 (x1, 
i1);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      res = pattern1181 (x1, 
i1);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1533 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1542 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i2
      || !sext_operand (operands[2], i1)
      || pattern714 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1552 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case UNSPEC:
      if (pnum_clobbers == NULL
          || XVECLEN (x1, 0) != 1
          || XINT (x1, 1) != 32)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      return 0;

    case CLOBBER:
      x3 = XEXP (x1, 0);
      if (GET_CODE (x3) != REG
          || REGNO (x3) != 17
          || GET_MODE (x3) != E_CCmode)
        return -1;
      return 1;

    case USE:
      if (pnum_clobbers == NULL)
        return -1;
      x3 = XEXP (x1, 0);
      operands[4] = x3;
      if (!register_operand (operands[4], E_SImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1563 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1571 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || pattern1570 (
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1580 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x5 = XEXP (x3, 2);
  if (GET_MODE (x5) != i1
      || !nonimmediate_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || !register_operand (operands[5], E_QImode))
    return -1;
  return 0;
}

int
pattern1593 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1600 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[6], E_QImode)
      || !vsib_mem_operator (operands[5], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1599 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1599 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1611 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1617 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1626 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      return pattern1625 (x1, 
E_V8HFmode); /* [-1, 0] */

    case E_V4SFmode:
      if (pattern1625 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    case E_V2DFmode:
      if (pattern1625 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1635 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[7], E_QImode)
      || !vsib_mem_operator (operands[6], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1634 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1634 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1649 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (XWINT (x2, 0) != 2L)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (XWINT (x3, 0) != 2L)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (XWINT (x4, 0) != 4L)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (XWINT (x5, 0) != 4L)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (XWINT (x6, 0) != 6L)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (XWINT (x7, 0) != 6L)
    return -1;
  return 0;
}

int
pattern1661 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_DImode))
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  if (!nonimmediate_operand (operands[1], E_DImode))
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != E_DImode)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != E_TImode)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != E_TImode)
    return -1;
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  if (!register_operand (operands[2], E_DImode))
    return -1;
  x8 = XEXP (x5, 1);
  operands[4] = x8;
  if (!const_0_to_255_operand (operands[4], E_QImode))
    return -1;
  return 0;
}

int
pattern1673 (rtx x1, int i1, int i2, int i3, int i4, int i5)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 12);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 13);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 14);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 15);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x6 = XVECEXP (x1, 0, 16);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + i5])
    return -1;
  return 0;
}

int
pattern1683 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V16SImode:
      if (!register_operand (operands[2], E_V16SImode)
          || !register_operand (operands[6], E_HImode)
          || !register_operand (operands[3], E_V16SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode)
          || !register_operand (operands[6], E_QImode)
          || !register_operand (operands[3], E_V8SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1695 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!vsib_mem_operator (operands[5], i1)
      || !register_operand (operands[6], E_QImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1
      || !scratch_operand (operands[1], E_QImode))
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  switch (GET_MODE (x4))
    {
    case E_SImode:
      return 0;

    case E_DImode:
      return 1;

    default:
      return -1;
    }
}

int
pattern1706 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V4SImode:
      if (!register_operand (operands[2], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1713 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[3] = x5;
  if (!any_QIreg_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1720 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x6 = XEXP (x4, 2);
  if (GET_MODE (x6) != i1
      || !register_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1728 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[7], E_QImode)
      || !vsib_mem_operator (operands[6], i1)
      || !scratch_operand (operands[2], E_QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1727 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1727 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1744 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1751 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (XWINT (x2, 0) != 1L)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (XWINT (x3, 0) != 2L)
    return -1;
  x4 = XVECEXP (x1, 0, 3);
  if (XWINT (x4, 0) != 3L)
    return -1;
  x5 = XVECEXP (x1, 0, 4);
  if (XWINT (x5, 0) != 4L)
    return -1;
  x6 = XVECEXP (x1, 0, 5);
  if (XWINT (x6, 0) != 5L)
    return -1;
  x7 = XVECEXP (x1, 0, 6);
  if (XWINT (x7, 0) != 6L)
    return -1;
  x8 = XVECEXP (x1, 0, 7);
  if (XWINT (x8, 0) != 7L)
    return -1;
  x9 = XVECEXP (x1, 0, 8);
  if (XWINT (x9, 0) != 8L)
    return -1;
  x10 = XVECEXP (x1, 0, 9);
  if (XWINT (x10, 0) != 9L)
    return -1;
  x11 = XVECEXP (x1, 0, 10);
  if (XWINT (x11, 0) != 10L)
    return -1;
  x12 = XVECEXP (x1, 0, 11);
  if (XWINT (x12, 0) != 11L)
    return -1;
  x13 = XVECEXP (x1, 0, 12);
  if (XWINT (x13, 0) != 12L)
    return -1;
  x14 = XVECEXP (x1, 0, 13);
  if (XWINT (x14, 0) != 13L)
    return -1;
  x15 = XVECEXP (x1, 0, 14);
  if (XWINT (x15, 0) != 14L)
    return -1;
  x16 = XVECEXP (x1, 0, 15);
  if (XWINT (x16, 0) != 15L)
    return -1;
  return 0;
}

int
pattern1769 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_SImode:
      if (!vsib_address_operand (operands[4], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!vsib_address_operand (operands[4], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1776 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !vsib_mem_operator (operands[7], i2)
      || !register_operand (operands[5], i1)
      || !scratch_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1775 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1775 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1789 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  int res ATTRIBUTE_UNUSED;
  if (!const_int_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (XVECLEN (x3, 0) != 4
      || XINT (x3, 1) != 109)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != UNSPEC_VOLATILE
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != 109)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x7) != SET)
    return -1;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != UNSPEC_VOLATILE
      || XVECLEN (x8, 0) != 1
      || XINT (x8, 1) != 109
      || GET_MODE (x8) != E_CCZmode)
    return -1;
  x9 = XVECEXP (x8, 0, 0);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x10 = XEXP (x7, 0);
  if (GET_CODE (x10) != REG
      || REGNO (x10) != 17
      || GET_MODE (x10) != E_CCZmode)
    return -1;
  x11 = XEXP (x2, 0);
  operands[2] = x11;
  x12 = XVECEXP (x3, 0, 0);
  operands[3] = x12;
  x13 = XVECEXP (x3, 0, 2);
  operands[4] = x13;
  x14 = XVECEXP (x3, 0, 3);
  operands[5] = x14;
  if (!const_int_operand (operands[5], E_SImode))
    return -1;
  x15 = XVECEXP (x3, 0, 1);
  if (!rtx_equal_p (x15, operands[2]))
    return -1;
  x16 = XEXP (x4, 0);
  if (!rtx_equal_p (x16, operands[3]))
    return -1;
  x17 = PATTERN (peep2_next_insn (2));
  x18 = XEXP (x17, 1);
  x19 = XEXP (x18, 0);
  if (!rtx_equal_p (x19, operands[2]))
    return -1;
  x20 = XEXP (x18, 1);
  if (!rtx_equal_p (x20, operands[1]))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_QImode:
      return pattern1788 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern1788 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern1788 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern1788 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1818 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V8SImode:
      if (!register_operand (operands[3], E_V8SImode)
          || !register_operand (operands[4], E_V8SFmode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[3], E_V4DImode)
          || !register_operand (operands[4], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1825 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_MODE (x4) != i2
      || !ix86_carry_flag_operator (operands[4], i2)
      || !const_scalar_int_operand (operands[6], i2)
      || !nonimmediate_operand (operands[0], i1))
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i1)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i1
      || !ix86_carry_flag_operator (operands[5], i1)
      || !x86_64_immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1836 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_15_operand (operands[2], E_VOIDmode)
      || !const_0_to_15_operand (operands[3], E_VOIDmode)
      || !const_0_to_15_operand (operands[4], E_VOIDmode)
      || !const_0_to_15_operand (operands[5], E_VOIDmode)
      || !const_0_to_15_operand (operands[6], E_VOIDmode)
      || !const_0_to_15_operand (operands[7], E_VOIDmode)
      || !const_0_to_15_operand (operands[8], E_VOIDmode)
      || !const_0_to_15_operand (operands[9], E_VOIDmode)
      || !const_0_to_15_operand (operands[10], E_VOIDmode)
      || !const_0_to_15_operand (operands[11], E_VOIDmode)
      || !const_0_to_15_operand (operands[12], E_VOIDmode)
      || !const_0_to_15_operand (operands[13], E_VOIDmode)
      || !const_0_to_15_operand (operands[14], E_VOIDmode)
      || !const_0_to_15_operand (operands[15], E_VOIDmode)
      || !const_0_to_15_operand (operands[16], E_VOIDmode)
      || !const_0_to_15_operand (operands[17], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1844 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 28);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 29);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 30);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 31);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern1849 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[4], i1)
      || GET_MODE (x1) != i1
      || !nonmemory_operand (operands[2], i1))
    return -1;
  x2 = PATTERN (peep2_next_insn (3));
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[4]))
    return -1;
  x4 = PATTERN (peep2_next_insn (4));
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  operands[5] = x6;
  x7 = XEXP (x5, 1);
  operands[6] = x7;
  return 0;
}

int
pattern1856 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !ix86_carry_flag_operator (operands[4], i2))
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x7 = XEXP (x4, 1);
  if (GET_MODE (x7) != i2
      || !x86_64_sext_operand (operands[2], i1)
      || pattern1854 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1864 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  return 0;
}

 int
recog_1 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x2, 1);
  switch (GET_CODE (x6))
    {
    case COMPARE:
      if (GET_MODE (x6) != E_CCmode)
        return -1;
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != MINUS)
        return -1;
      x8 = XEXP (x6, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != UNSPEC
          || XVECLEN (x9, 0) != 1
          || XINT (x9, 1) != 109
          || GET_MODE (x9) != E_CCmode)
        return -1;
      x10 = XEXP (x1, 0);
      operands[0] = x10;
      if (!flags_reg_operand (operands[0], E_CCmode)
          || GET_MODE (x2) != E_CCmode
          || !comparison_operator (operands[1], E_VOIDmode)
          || GET_MODE (x4) != E_CCmode)
        return -1;
      x11 = XEXP (x7, 0);
      operands[2] = x11;
      x12 = XEXP (x7, 1);
      operands[3] = x12;
      x13 = XVECEXP (x9, 0, 0);
      operands[4] = x13;
      if (!const_0_to_15_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (x7))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[2], E_QImode)
              || !general_operand (operands[3], E_QImode)
              || !
#line 1539 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP))
            return -1;
          return 1; /* ccmpqi */

        case E_HImode:
          if (!nonimmediate_operand (operands[2], E_HImode)
              || !general_operand (operands[3], E_HImode)
              || !
#line 1539 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP))
            return -1;
          return 2; /* ccmphi */

        case E_SImode:
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !x86_64_general_operand (operands[3], E_SImode)
              || !
#line 1539 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP))
            return -1;
          return 3; /* ccmpsi */

        case E_DImode:
          if (!nonimmediate_operand (operands[2], E_DImode)
              || !x86_64_general_operand (operands[3], E_DImode)
              || !(
#line 1539 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4; /* ccmpdi */

        default:
          return -1;
        }

    case LABEL_REF:
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != PC)
        return -1;
      x10 = XEXP (x1, 0);
      if (GET_CODE (x10) != PC
          || !ix86_comparison_operator (operands[1], E_VOIDmode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[0] = x7;
      return 1458; /* *jcc */

    case REG:
    case SUBREG:
    case MEM:
      operands[2] = x6;
      x10 = XEXP (x1, 0);
      operands[0] = x10;
      x9 = XEXP (x2, 2);
      operands[3] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (pattern1185 (x2, 
E_HImode) != 0
              || !
#line 26357 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
            return -1;
          return 1803; /* *movhicc_noc */

        case E_QImode:
          if (pattern1186 (x2) != 0
              || !
#line 26431 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE && !TARGET_PARTIAL_REG_STALL))
            return -1;
          return 1808; /* *movqicc_noc */

        case E_XFmode:
          if (!register_operand (operands[0], E_XFmode)
              || GET_MODE (x2) != E_XFmode
              || !fcmov_comparison_operator (operands[1], E_VOIDmode)
              || !register_operand (operands[2], E_XFmode)
              || !register_operand (operands[3], E_XFmode)
              || !
#line 26625 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE))
            return -1;
          return 1810; /* *movxfcc_1 */

        case E_DFmode:
          if (!register_operand (operands[0], E_DFmode)
              || pattern1244 (x2, 
E_DFmode) != 0
              || !
#line 26640 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
            return -1;
          return 1811; /* *movdfcc_1 */

        case E_SFmode:
          if (!register_operand (operands[0], E_SFmode)
              || pattern1244 (x2, 
E_SFmode) != 0
              || !
#line 26675 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
            return -1;
          return 1812; /* *movsfcc_1_387 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_14 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XVECLEN (x2, 0))
    {
    case 1:
      return recog_13 (x1, insn, pnum_clobbers);

    case 2:
      return recog_12 (x1, insn, pnum_clobbers);

    case 3:
      switch (XINT (x2, 1))
        {
        case 39:
          if (pnum_clobbers == NULL
              || GET_MODE (x2) != E_CCGZmode)
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          if (GET_CODE (x3) != LTU)
            return -1;
          x4 = XEXP (x3, 0);
          if (GET_CODE (x4) != REG
              || REGNO (x4) != 17
              || GET_MODE (x4) != E_CCmode)
            return -1;
          x5 = XEXP (x3, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x6 = XEXP (x1, 0);
          if (GET_CODE (x6) != REG
              || REGNO (x6) != 17
              || GET_MODE (x6) != E_CCGZmode)
            return -1;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          switch (GET_MODE (operands[1]))
            {
            case E_SImode:
              if (!register_operand (operands[1], E_SImode)
                  || !x86_64_general_operand (operands[2], E_SImode)
                  || GET_MODE (x3) != E_SImode
                  || !
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 521; /* subsi3_carry_ccgz */

            case E_DImode:
              if (!register_operand (operands[1], E_DImode)
                  || !x86_64_general_operand (operands[2], E_DImode)
                  || GET_MODE (x3) != E_DImode
                  || !
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 522; /* subdi3_carry_ccgz */

            default:
              return -1;
            }

        case 59:
          return recog_11 (x1, insn, pnum_clobbers);

        case 48:
          if (GET_MODE (x2) != E_HFmode)
            return -1;
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          if (!nonimmediate_operand (operands[0], E_HFmode))
            return -1;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          if (!nonimmediate_operand (operands[1], E_HFmode))
            return -1;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          if (!nonimm_or_0_operand (operands[2], E_HFmode))
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          operands[3] = x3;
          if (!register_operand (operands[3], E_QImode)
              || !
#line 26591 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 1809; /* movhf_mask */

        case 51:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          x3 = XVECEXP (x2, 0, 2);
          switch (GET_CODE (x3))
            {
            case LT:
              switch (pattern731 (x2))
                {
                case 0:
                  if (
#line 26824 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[3])
      && rtx_equal_p (operands[2], operands[4]))
  && ix86_pre_reload_split ()))
                    return 1827; /* *ieee_maxsf3_1 */
                  if (!
#line 26845 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[4])
      && rtx_equal_p (operands[2], operands[3]))
  && ix86_pre_reload_split ()))
                    return -1;
                  return 1829; /* *ieee_minsf3_1 */

                case 1:
                  if (
#line 26824 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[3])
      && rtx_equal_p (operands[2], operands[4]))
  && ix86_pre_reload_split ()))
                    return 1828; /* *ieee_maxdf3_1 */
                  if (!
#line 26845 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[4])
      && rtx_equal_p (operands[2], operands[3]))
  && ix86_pre_reload_split ()))
                    return -1;
                  return 1830; /* *ieee_mindf3_1 */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
              operands[3] = x3;
              switch (GET_MODE (operands[0]))
                {
                case E_V2SFmode:
                  if (pattern956 (x2, 
E_V2SFmode) == 0
                      && 
#line 1317 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                    return 2075; /* mmx_blendvps */
                  break;

                case E_V8QImode:
                  if (pattern956 (x2, 
E_V8QImode) == 0
                      && 
#line 4314 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                    return 2241; /* mmx_pblendvb_v8qi */
                  break;

                case E_V4QImode:
                  if (pattern956 (x2, 
E_V4QImode) == 0
                      && 
#line 4390 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
                    return 2245; /* mmx_pblendvb_v4qi */
                  break;

                case E_V2QImode:
                  if (pattern956 (x2, 
E_V2QImode) == 0
                      && 
#line 4390 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
                    return 2246; /* mmx_pblendvb_v2qi */
                  break;

                case E_V2HImode:
                  if (pattern956 (x2, 
E_V2HImode) == 0
                      && 
#line 4390 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
                    return 2247; /* mmx_pblendvb_v2hi */
                  break;

                case E_SFmode:
                  if (pattern956 (x2, 
E_SFmode) == 0
                      && 
#line 23547 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8614; /* sse4_1_blendvss */
                  break;

                case E_DFmode:
                  if (pattern956 (x2, 
E_DFmode) == 0
                      && 
#line 23547 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8615; /* sse4_1_blendvsd */
                  break;

                default:
                  break;
                }
              if (GET_CODE (x3) != SUBREG)
                return -1;
              switch (pattern841 (x2))
                {
                case 0:
                  if (!
#line 4366 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
                    return -1;
                  return 2243; /* *mmx_pblendvb_v8qi_2 */

                case 1:
                  if (!
#line 4366 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
                    return -1;
                  return 2244; /* *mmx_pblendvb_v8qi_2 */

                case 2:
                  if (!
#line 4442 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2251; /* *mmx_pblendvb_v4qi_2 */

                default:
                  return -1;
                }

            case EQ:
              switch (pattern733 (x2))
                {
                case 0:
                  if (!
#line 4338 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
                    return -1;
                  return 2242; /* *mmx_pblendvb_v8qi_1 */

                case 1:
                  if (!
#line 4414 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2248; /* *mmx_pblendvb_v4qi_1 */

                case 2:
                  if (!
#line 4414 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2249; /* *mmx_pblendvb_v2qi_1 */

                case 3:
                  if (!
#line 4414 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2250; /* *mmx_pblendvb_v2hi_1 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 50:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          operands[2] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[1] = x8;
          x3 = XVECEXP (x2, 0, 2);
          operands[3] = x3;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V2SFmode:
              if (pattern957 (x2, 
E_V2SFmode) != 0
                  || !
#line 1261 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                return -1;
              return 2072; /* sse4_1_insertps_v2sf */

            case E_V2SImode:
              if (pattern957 (x2, 
E_V2SImode) != 0
                  || !
#line 1261 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                return -1;
              return 2073; /* sse4_1_insertps_v2si */

            default:
              return -1;
            }

        case 53:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          x3 = XVECEXP (x2, 0, 2);
          operands[3] = x3;
          if (!nonimmediate_operand (operands[3], E_V16QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V8QImode:
              if (pattern958 (x2, 
E_V8QImode) != 0
                  || !
#line 4512 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP && TARGET_MMX_WITH_SSE))
                return -1;
              return 2263; /* mmx_ppermv64 */

            case E_V4QImode:
              if (pattern958 (x2, 
E_V4QImode) != 0
                  || !
#line 4524 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
                return -1;
              return 2264; /* mmx_ppermv32 */

            default:
              return -1;
            }

        case 47:
          if (GET_MODE (x2) != E_V8QImode)
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          if (GET_CODE (x3) != MEM
              || GET_MODE (x3) != E_V8QImode)
            return -1;
          x6 = XEXP (x1, 0);
          if (GET_CODE (x6) != MEM
              || GET_MODE (x6) != E_V8QImode)
            return -1;
          x9 = XEXP (x6, 0);
          operands[0] = x9;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          switch (pattern1059 (x2, 
E_V8QImode))
            {
            case 0:
              if (!(
#line 6860 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE || TARGET_3DNOW_A) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 2385; /* *mmx_maskmovq */

            case 1:
              if (!(
#line 6860 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE || TARGET_3DNOW_A) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 2386; /* *mmx_maskmovq */

            default:
              return -1;
            }

        case 157:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          switch (GET_CODE (x7))
            {
            case CONST_INT:
            case CONST_DOUBLE:
            case CONST_VECTOR:
            case REG:
            case SUBREG:
            case MEM:
              operands[1] = x7;
              x3 = XVECEXP (x2, 0, 2);
              if (GET_CODE (x3) != CONST_INT)
                return -1;
              x8 = XVECEXP (x2, 0, 1);
              operands[2] = x8;
              if (XWINT (x3, 0) == 0L)
                {
                  switch (pattern955 (x2))
                    {
                    case 0:
                      if ((
#line 4585 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3462; /* *avx512vl_eqv16qi3_1 */
                      break;

                    case 1:
                      if ((
#line 4585 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3474; /* *avx512vl_eqv16hi3_1 */
                      break;

                    case 2:
                      if ((
#line 4674 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return 3530; /* *avx512f_eqv16si3_1 */
                      break;

                    case 3:
                      if ((
#line 4585 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3478; /* *avx512vl_eqv8hi3_1 */
                      break;

                    case 4:
                      if ((
#line 4674 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3534; /* *avx512vl_eqv8si3_1 */
                      break;

                    case 5:
                      if ((
#line 4674 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3538; /* *avx512vl_eqv4si3_1 */
                      break;

                    case 6:
                      if ((
#line 4674 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return 3542; /* *avx512f_eqv8di3_1 */
                      break;

                    case 7:
                      if ((
#line 4674 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3546; /* *avx512vl_eqv4di3_1 */
                      break;

                    case 8:
                      if ((
#line 4674 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3550; /* *avx512vl_eqv2di3_1 */
                      break;

                    default:
                      break;
                    }
                }
              operands[3] = x3;
              if (!const_0_to_7_operand (operands[3], E_SImode))
                return -1;
              switch (pattern67 (x2))
                {
                case 0:
                  if (!(
#line 4600 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3482; /* avx512vl_ucmpv16qi3 */

                case 1:
                  if (!(
#line 4600 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3488; /* avx512vl_ucmpv16hi3 */

                case 2:
                  if (!(
#line 4689 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3552; /* avx512f_ucmpv16si3 */

                case 3:
                  if (!(
#line 4600 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3490; /* avx512vl_ucmpv8hi3 */

                case 4:
                  if (!(
#line 4689 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3554; /* avx512vl_ucmpv8si3 */

                case 5:
                  if (!(
#line 4689 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3556; /* avx512vl_ucmpv4si3 */

                case 6:
                  if (!(
#line 4689 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3558; /* avx512f_ucmpv8di3 */

                case 7:
                  if (!(
#line 4689 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3560; /* avx512vl_ucmpv4di3 */

                case 8:
                  if (!(
#line 4689 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3562; /* avx512vl_ucmpv2di3 */

                default:
                  return -1;
                }

            case US_MINUS:
              switch (pattern420 (x2))
                {
                case 0:
                  if (!(
#line 4792 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()
  && ix86_binary_operator_ok (US_MINUS, V16QImode, operands)
  && (INTVAL (operands[4]) & 1) == 0) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3609; /* *avx512vl_ucmpv16qi3_1 */

                case 1:
                  if (!(
#line 4792 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()
  && ix86_binary_operator_ok (US_MINUS, V16HImode, operands)
  && (INTVAL (operands[4]) & 1) == 0) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3615; /* *avx512vl_ucmpv16hi3_1 */

                case 2:
                  if (!(
#line 4792 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()
  && ix86_binary_operator_ok (US_MINUS, V8HImode, operands)
  && (INTVAL (operands[4]) & 1) == 0) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3617; /* *avx512vl_ucmpv8hi3_1 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 52:
          if (pattern59 (x1, pnum_clobbers, 
E_V8QImode) != 0)
            return -1;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          if (!register_mmxmem_operand (operands[2], E_V8QImode))
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          operands[4] = x3;
          if (!reg_or_const_vector_operand (operands[4], E_V4SImode)
              || !
#line 23153 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return -1;
          *pnum_clobbers = 1;
          return 8557; /* *ssse3_pshufbv8qi3 */

        case 132:
          if (pnum_clobbers == NULL
              || pattern251 (x1) != 0
              || !nonimmediate_operand (operands[3], E_V16QImode))
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          operands[4] = x3;
          if (!const_0_to_255_operand (operands[4], E_SImode)
              || !
#line 26074 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
            return -1;
          *pnum_clobbers = 2;
          return 8911; /* sse4_2_pcmpistr_cconly */

        default:
          return -1;
        }

    case 5:
      if (pnum_clobbers == NULL
          || XINT (x2, 1) != 131
          || pattern251 (x1) != 0
          || !register_operand (operands[3], E_SImode))
        return -1;
      x3 = XVECEXP (x2, 0, 2);
      operands[4] = x3;
      if (!nonimmediate_operand (operands[4], E_V16QImode))
        return -1;
      x10 = XVECEXP (x2, 0, 3);
      operands[5] = x10;
      if (!register_operand (operands[5], E_SImode))
        return -1;
      x11 = XVECEXP (x2, 0, 4);
      operands[6] = x11;
      if (!const_0_to_255_operand (operands[6], E_SImode)
          || !
#line 25949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
        return -1;
      *pnum_clobbers = 2;
      return 8907; /* sse4_2_pcmpestr_cconly */

    default:
      return -1;
    }
}

 int
recog_28 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_DFmode:
      if (GET_MODE (x3) != E_DFmode)
        return -1;
      if (nonimm_ssenomem_operand (operands[0], E_DFmode)
          && nonimmediate_operand (operands[1], E_SFmode)
          && 
#line 5307 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)))
        return 200; /* *extendsfdf2 */
      if (!register_operand (operands[0], E_DFmode)
          || !nonimmediate_operand (operands[1], E_HFmode)
          || !
#line 5463 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
        return -1;
      return 202; /* *extendhfdf2 */

    case E_SFmode:
      if (!register_operand (operands[0], E_SFmode)
          || GET_MODE (x3) != E_SFmode
          || !nonimmediate_operand (operands[1], E_HFmode)
          || !
#line 5463 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
        return -1;
      return 201; /* *extendhfsf2 */

    case E_XFmode:
      if (!nonimmediate_operand (operands[0], E_XFmode))
        return -1;
      switch (pattern425 (x3, 
E_XFmode))
        {
        case 0:
          if (!
#line 5525 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 204; /* *extendsfxf2_i387 */

        case 1:
          if (!
#line 5525 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 205; /* *extenddfxf2_i387 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_30 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (GET_MODE (x3) != E_SImode)
        return -1;
      if (register_operand (operands[0], E_SImode))
        {
          switch (pattern263 ())
            {
            case 0:
              if (
#line 5781 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
                return 212; /* fix_trunchfsi2 */
              break;

            case 1:
              if (
#line 5957 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)))
                return 225; /* fix_truncsfsi_sse */
              break;

            case 2:
              if (
#line 5957 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)))
                return 227; /* fix_truncdfsi_sse */
              break;

            default:
              break;
            }
        }
      if (pnum_clobbers == NULL
          || !nonimmediate_operand (operands[0], E_SImode)
          || !register_operand (operands[1], E_VOIDmode))
        return -1;
      if (
#line 5987 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_FISTTP
   && !((SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || SImode != DImode))
	&& TARGET_SSE_MATH)))
        {
          *pnum_clobbers = 1;
          return 230; /* fix_truncsi_i387_fisttp */
        }
      if (!
#line 6005 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || SImode != DImode))
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 233; /* *fix_truncsi_i387_1 */

    case E_DImode:
      if (GET_MODE (x3) != E_DImode)
        return -1;
      if (register_operand (operands[0], E_DImode))
        {
          switch (pattern263 ())
            {
            case 0:
              if ((
#line 5781 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 214; /* fix_trunchfdi2 */
              break;

            case 1:
              if ((
#line 5957 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 226; /* fix_truncsfdi_sse */
              break;

            case 2:
              if ((
#line 5957 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 228; /* fix_truncdfdi_sse */
              break;

            default:
              break;
            }
        }
      if (pnum_clobbers == NULL
          || !nonimmediate_operand (operands[0], E_DImode)
          || !register_operand (operands[1], E_VOIDmode))
        return -1;
      if (
#line 5987 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_FISTTP
   && !((SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || DImode != DImode))
	&& TARGET_SSE_MATH)))
        {
          *pnum_clobbers = 1;
          return 231; /* fix_truncdi_i387_fisttp */
        }
      if (!
#line 6005 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || DImode != DImode))
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 234; /* *fix_truncdi_i387_1 */

    case E_HImode:
      if (pattern262 (x3, pnum_clobbers, 
E_VOIDmode, 
E_HImode) != 0)
        return -1;
      if (
#line 5987 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_FISTTP
   && !((SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || HImode != DImode))
	&& TARGET_SSE_MATH)))
        {
          *pnum_clobbers = 1;
          return 229; /* fix_trunchi_i387_fisttp */
        }
      if (!
#line 6005 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || HImode != DImode))
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 232; /* *fix_trunchi_i387_1 */

    case E_V2SImode:
      if (!register_operand (operands[0], E_V2SImode)
          || GET_MODE (x3) != E_V2SImode
          || !vector_operand (operands[1], E_V2DFmode)
          || !
#line 8922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return -1;
      return 4828; /* sse2_cvttpd2pi */

    default:
      return -1;
    }
}

 int
recog_38 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case XOR:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (pattern739 (x2, 
E_HImode) != 0
              || !
#line 13621 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, HImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 835; /* *notxorhi_1 */

        case E_QImode:
          if (pattern739 (x2, 
E_QImode) != 0
              || !
#line 13821 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, QImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 871; /* *notxorqi_1 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      switch (pattern40 (x1))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_TImode:
              if (!nonimmediate_operand (operands[0], E_TImode)
                  || GET_MODE (x2) != E_TImode
                  || !nonimmediate_operand (operands[1], E_TImode)
                  || !(
#line 14990 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NOT, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1031; /* *one_cmplti2_doubleword */

            case E_HImode:
              if (!nonimmediate_operand (operands[0], E_HImode)
                  || GET_MODE (x2) != E_HImode
                  || !nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 15003 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NOT, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1032; /* *one_cmplhi2_1 */

            case E_QImode:
              if (!nonimmediate_operand (operands[0], E_QImode)
                  || GET_MODE (x2) != E_QImode
                  || !nonimmediate_operand (operands[1], E_QImode)
                  || !
#line 15047 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NOT, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1041; /* *one_cmplqi2_1 */

            case E_V4QImode:
              if (!register_operand (operands[0], E_V4QImode)
                  || GET_MODE (x2) != E_V4QImode
                  || !register_operand (operands[1], E_V4QImode))
                return -1;
              return 2265; /* one_cmplv4qi2 */

            case E_V2QImode:
              if (!register_operand (operands[0], E_V2QImode)
                  || GET_MODE (x2) != E_V2QImode
                  || !register_operand (operands[1], E_V2QImode))
                return -1;
              return 2266; /* one_cmplv2qi2 */

            case E_V2HImode:
              if (!register_operand (operands[0], E_V2HImode)
                  || GET_MODE (x2) != E_V2HImode
                  || !register_operand (operands[1], E_V2HImode))
                return -1;
              return 2267; /* one_cmplv2hi2 */

            default:
              return -1;
            }

        case 1:
          if (!
#line 15073 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 1042; /* *one_cmplqi_1_slp */

        case 2:
          if (!
#line 15073 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 1043; /* *one_cmplhi_1_slp */

        default:
          return -1;
        }

    case ZERO_EXTRACT:
      if (pnum_clobbers == NULL
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XEXP (x3, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x4 = XEXP (x1, 0);
      if (GET_CODE (x4) != ZERO_EXTRACT
          || GET_MODE (x4) != E_DImode)
        return -1;
      x7 = XEXP (x4, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x8 = XEXP (x4, 0);
      operands[0] = x8;
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x9 = XEXP (x4, 2);
      operands[1] = x9;
      if (!const_0_to_63_operand (operands[1], E_QImode)
          || GET_MODE (x2) != E_DImode)
        return -1;
      x5 = XEXP (x3, 0);
      if (!rtx_equal_p (x5, operands[0]))
        return -1;
      x10 = XEXP (x3, 2);
      if (!rtx_equal_p (x10, operands[1])
          || !
#line 19072 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && (TARGET_USE_BT || reload_completed)))
        return -1;
      *pnum_clobbers = 1;
      return 1415; /* *btcq_imm */

    case UNSPEC:
      if (XVECLEN (x3, 0) != 3)
        return -1;
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x11 = XVECEXP (x3, 0, 0);
      operands[1] = x11;
      x12 = XVECEXP (x3, 0, 1);
      operands[2] = x12;
      x13 = XVECEXP (x3, 0, 2);
      operands[3] = x13;
      switch (XINT (x3, 1))
        {
        case 59:
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              switch (pattern960 (x2))
                {
                case 0:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3381; /* *avx512f_cmpv16si3 */

                case 1:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3388; /* *avx512vl_cmpv16hf3 */

                case 2:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3390; /* *avx512f_cmpv16sf3 */

                case 3:
                  if (!(
#line 4567 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3446; /* *avx512vl_cmpv16qi3 */

                case 4:
                  if (!(
#line 4567 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3452; /* *avx512vl_cmpv16hi3 */

                default:
                  return -1;
                }

            case E_QImode:
              switch (pattern961 (x2))
                {
                case 0:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3382; /* *avx512vl_cmpv8si3 */

                case 1:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3383; /* *avx512vl_cmpv4si3 */

                case 2:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3384; /* *avx512f_cmpv8di3 */

                case 3:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3385; /* *avx512vl_cmpv4di3 */

                case 4:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3386; /* *avx512vl_cmpv2di3 */

                case 5:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3389; /* *avx512fp16_cmpv8hf3 */

                case 6:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3391; /* *avx512vl_cmpv8sf3 */

                case 7:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3392; /* *avx512vl_cmpv4sf3 */

                case 8:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3393; /* *avx512f_cmpv8df3 */

                case 9:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3394; /* *avx512vl_cmpv4df3 */

                case 10:
                  if (!(
#line 4472 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3395; /* *avx512vl_cmpv2df3 */

                case 11:
                  if (!(
#line 4567 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3454; /* *avx512vl_cmpv8hi3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 157:
          if (!const_0_to_7_operand (operands[3], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              switch (pattern1064 (x2))
                {
                case 0:
                  if (!(
#line 4567 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3447; /* *avx512vl_cmpv16qi3 */

                case 1:
                  if (!(
#line 4567 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3453; /* *avx512vl_cmpv16hi3 */

                case 2:
                  if (!(
#line 4765 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3600; /* *avx512f_ucmpv16si3 */

                default:
                  return -1;
                }

            case E_QImode:
              switch (pattern1065 (x2))
                {
                case 0:
                  if (!(
#line 4567 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3455; /* *avx512vl_cmpv8hi3 */

                case 1:
                  if (!(
#line 4765 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3601; /* *avx512vl_ucmpv8si3 */

                case 2:
                  if (!(
#line 4765 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3602; /* *avx512vl_ucmpv4si3 */

                case 3:
                  if (!(
#line 4765 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3603; /* *avx512f_ucmpv8di3 */

                case 4:
                  if (!(
#line 4765 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3604; /* *avx512vl_ucmpv4di3 */

                case 5:
                  if (!(
#line 4765 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3605; /* *avx512vl_ucmpv2di3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_55 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x3;
      res = recog_54 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (pnum_clobbers == NULL
          || GET_CODE (x3) != SUBREG
          || maybe_ne (SUBREG_BYTE (x3), 0)
          || GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case SIGN_EXTRACT:
        case ZERO_EXTRACT:
          operands[3] = x4;
          x5 = XEXP (x4, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x6 = XEXP (x4, 2);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x7 = XEXP (x2, 1);
          if (pattern596 (x7) != 0)
            return -1;
          x8 = XEXP (x7, 0);
          operands[4] = x8;
          x9 = XEXP (x8, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x10 = XEXP (x8, 2);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8]
              || GET_MODE (x2) != E_QImode)
            return -1;
          switch (pattern1251 (x1))
            {
            case 0:
              if (!
#line 8260 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 408; /* *subqi_exthi_2_slp */

            case 1:
              if (!
#line 8260 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 409; /* *subqi_extsi_2_slp */

            case 2:
              if (!(
#line 8260 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 410; /* *subqi_extdi_2_slp */

            case 3:
              *pnum_clobbers = 1;
              return 419; /* *subqi_ext2hi_0 */

            case 4:
              *pnum_clobbers = 1;
              return 420; /* *subqi_ext2si_0 */

            case 5:
              if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 421; /* *subqi_ext2di_0 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case MINUS:
      if (pnum_clobbers == NULL)
        return -1;
      x11 = XEXP (x1, 0);
      operands[0] = x11;
      switch (pattern291 (x2))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (pattern1345 (x2, 
E_QImode) != 0
                  || !
#line 9289 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              *pnum_clobbers = 1;
              return 487; /* subqi3_carry */

            case E_HImode:
              if (pattern1345 (x2, 
E_HImode) != 0
                  || !
#line 9289 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              *pnum_clobbers = 1;
              return 488; /* subhi3_carry */

            default:
              return -1;
            }

        case 1:
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (pattern1256 (x2, 
E_QImode) != 0
                  || !
#line 10242 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 570; /* *subqi3_eq */

            case E_HImode:
              if (pattern1256 (x2, 
E_HImode) != 0
                  || !
#line 10242 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 571; /* *subhi3_eq */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      switch (pattern91 (x1))
        {
        case 0:
          x4 = XEXP (x3, 0);
          operands[1] = x4;
          if (pattern962 (x2) != 0)
            return -1;
          x7 = XEXP (x2, 1);
          x8 = XEXP (x7, 0);
          if (!rtx_equal_p (x8, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (pattern1494 (x2, 
E_SFmode, 
E_V2SFmode) != 0
                  || !
#line 1058 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE3 && TARGET_MMX_WITH_SSE && ix86_partial_vec_fp_math
   && ix86_pre_reload_split ()))
                return -1;
              return 2067; /* *mmx_hsubv2sf3_low */

            case E_DFmode:
              if (pattern1494 (x2, 
E_DFmode, 
E_V2DFmode) != 0
                  || !
#line 3772 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3 && TARGET_V2DF_REDUCTION_PREFER_HADDPD))
                return -1;
              return 3154; /* *sse3_hsubv2df3_low */

            default:
              return -1;
            }

        case 1:
          switch (pattern847 (x2))
            {
            case 0:
              if (!
#line 22618 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
                return -1;
              return 8524; /* ssse3_phsubwv4hi3 */

            case 1:
              if (!
#line 22705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
                return -1;
              return 8531; /* ssse3_phsubdv2si3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_62 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  x5 = XEXP (x2, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      return recog_61 (x1, insn, pnum_clobbers);

    case VEC_CONCAT:
      switch (pattern275 (x2))
        {
        case 0:
          x6 = XVECEXP (x3, 0, 1);
          if (GET_CODE (x6) == CONST_INT)
            {
              switch (pattern966 (x2))
                {
                case 0:
                  if (
#line 1691 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
                    return 2087; /* *vec_interleave_lowv2sf */
                  break;

                case 1:
                  if (
#line 4991 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return 2303; /* mmx_punpckldq */
                  break;

                case 2:
                  if (
#line 1708 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
                    return 2088; /* *vec_interleave_highv2sf */
                  break;

                case 3:
                  if (
#line 4970 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return 2302; /* mmx_punpckhdq */
                  break;

                default:
                  break;
                }
            }
          x7 = XVECEXP (x3, 0, 0);
          operands[3] = x7;
          switch (pattern967 (x2))
            {
            case 0:
              if (!
#line 6197 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2368; /* *punpckwd */

            case 1:
              if (!
#line 6197 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2369; /* *punpckwd */

            case 2:
              if (!
#line 6197 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2370; /* *punpckwd */

            default:
              return -1;
            }

        case 1:
          if (!
#line 4850 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2296; /* mmx_punpckhbw */

        case 2:
          if (!
#line 4890 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2298; /* mmx_punpcklbw */

        case 3:
          if (!
#line 4871 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2297; /* mmx_punpckhbw_low */

        case 4:
          if (!
#line 4928 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2300; /* mmx_punpckhwd */

        case 5:
          if (!
#line 4911 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2299; /* mmx_punpcklbw_low */

        case 6:
          if (!
#line 4949 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2301; /* mmx_punpcklwd */

        default:
          return -1;
        }

    case UNSPEC:
      if (pattern276 (x2) != 0
          || !
#line 8409 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE))
        return -1;
      return 4716; /* sse_cvtps2pi */

    case FIX:
      if (pattern278 (x2) != 0
          || !
#line 8473 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE))
        return -1;
      return 4718; /* sse_cvttps2pi */

    default:
      return -1;
    }
}

 int
recog_66 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 1);
  operands[2] = x4;
  x5 = XEXP (x3, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      operands[1] = x5;
      x6 = XEXP (x3, 2);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
        case VEC_DUPLICATE:
          operands[3] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 5918 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3760; /* *fma_fmadd_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 5946 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3775; /* *fma_fmadd_sf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 5918 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3761; /* *fma_fmadd_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 5946 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3784; /* *fma_fmadd_df */

            case E_HFmode:
              if (pattern857 (x3, 
E_HFmode) != 0
                  || !(
#line 5946 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3774; /* *fma_fmadd_hf */

            default:
              return -1;
            }

        case NEG:
          x7 = XEXP (x6, 0);
          operands[3] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode
                  || GET_MODE (x6) != E_SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 6017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3823; /* *fma_fmsub_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 6049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3838; /* *fma_fmsub_sf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode
                  || GET_MODE (x6) != E_DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 6017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3824; /* *fma_fmsub_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 6049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3847; /* *fma_fmsub_df */

            case E_HFmode:
              if (pattern858 (x3, 
E_HFmode) != 0
                  || !(
#line 6049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3837; /* *fma_fmsub_hf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NEG:
      x8 = XEXP (x5, 0);
      operands[1] = x8;
      x6 = XEXP (x3, 2);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
        case VEC_DUPLICATE:
          operands[3] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode
                  || GET_MODE (x5) != E_SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 6123 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3886; /* *fma_fnmadd_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3901; /* *fma_fnmadd_sf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode
                  || GET_MODE (x5) != E_DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 6123 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3887; /* *fma_fnmadd_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3910; /* *fma_fnmadd_df */

            case E_HFmode:
              if (pattern859 (x3, 
E_HFmode) != 0
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3900; /* *fma_fnmadd_hf */

            default:
              return -1;
            }

        case NEG:
          x7 = XEXP (x6, 0);
          operands[3] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (pattern860 (x3, 
E_SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3943; /* *fma_fnmsub_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3972; /* *fma_fnmsub_sf */

            case E_DFmode:
              if (pattern860 (x3, 
E_DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3945; /* *fma_fnmsub_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3981; /* *fma_fnmsub_df */

            case E_HFmode:
              if (pattern861 (x3, 
E_HFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3971; /* *fma_fnmsub_hf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_73 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 1)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  operands[2] = x5;
  x6 = XEXP (x3, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      switch (pattern973 (x2, 
E_SImode))
        {
        case 0:
          if (
#line 5437 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)))
            return 2324; /* *mmx_pextrw_zext */
          break;

        case 1:
          if (
#line 6098 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2362; /* *pextrw_zext */
          break;

        case 2:
          if (
#line 21102 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return 8389; /* *vec_extractv8hi_zext */
          break;

        case 3:
          if (
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2328; /* *mmx_pextrb_zext */
          break;

        case 4:
          if (
#line 6130 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
            return 2366; /* *pextrb_zext */
          break;

        case 5:
          if ((
#line 21102 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 21045 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1)))
            return 8387; /* *vec_extractv16qi_zext */
          break;

        default:
          break;
        }
      break;

    case E_DImode:
      switch (pattern973 (x2, 
E_DImode))
        {
        case 0:
          if ((
#line 5437 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2325; /* *mmx_pextrw_zext */
          break;

        case 1:
          if ((
#line 6098 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2363; /* *pextrw_zext */
          break;

        case 2:
          if ((
#line 21102 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 8390; /* *vec_extractv8hi_zext */
          break;

        case 3:
          if ((
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2329; /* *mmx_pextrb_zext */
          break;

        case 4:
          if ((
#line 6130 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2367; /* *pextrb_zext */
          break;

        case 5:
          if ((
#line 21102 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && (
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21045 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))))
            return 8388; /* *vec_extractv16qi_zext */
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  if (!register_operand (operands[0], E_DImode)
      || GET_MODE (x2) != E_DImode
      || GET_MODE (x3) != E_SImode)
    return -1;
  operands[1] = x6;
  switch (XWINT (x5, 0))
    {
    case 0L:
      switch (GET_MODE (operands[1]))
        {
        case E_V2SImode:
          if (register_operand (operands[1], E_V2SImode))
            {
              if (
#line 5749 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE4_1))
                return 2350; /* *vec_extractv2si_0_zext_sse4 */
              if (
#line 5764 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_FROM_VEC))
                return 2351; /* *vec_extractv2si_0_zext */
            }
          break;

        case E_V4SImode:
          if (register_operand (operands[1], E_V4SImode))
            {
              if (
#line 21202 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE4_1))
                return 8397; /* *vec_extractv4si_0_zext_sse4 */
              if (
#line 21217 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_FROM_VEC))
                return 8398; /* *vec_extractv4si_0_zext */
            }
          break;

        default:
          break;
        }
      break;

    case 1L:
      if (register_operand (operands[1], E_V2SImode)
          && 
#line 5826 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_64BIT && TARGET_SSE4_1))
        return 2353; /* *vec_extractv2si_1_zext */
      break;

    default:
      break;
    }
  operands[2] = x5;
  switch (GET_MODE (operands[1]))
    {
    case E_V2SImode:
      if (!memory_operand (operands[1], E_V2SImode)
          || !const_0_to_1_operand (operands[2], E_SImode)
          || !
#line 5842 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_64BIT))
        return -1;
      return 2354; /* *vec_extractv2si_zext_mem */

    case E_V4SImode:
      if (!const_0_to_3_operand (operands[2], E_SImode))
        return -1;
      if (register_operand (operands[1], E_V4SImode)
          && 
#line 21278 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE4_1))
        return 8400; /* *vec_extractv4si_zext */
      if (!memory_operand (operands[1], E_V4SImode)
          || !
#line 21301 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
        return -1;
      return 8402; /* *vec_extractv4si_zext_mem */

    default:
      return -1;
    }
}

 int
recog_79 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      x5 = XEXP (x3, 1);
      switch (GET_CODE (x5))
        {
        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          x6 = XEXP (x2, 1);
          switch (GET_CODE (x6))
            {
            case CONST_INT:
            case CONST_WIDE_INT:
              operands[3] = x6;
              operands[1] = x4;
              operands[2] = x5;
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (pattern599 (x2, 
E_SImode) != 0
                      || !
#line 8051 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[3])
   < (HOST_WIDE_INT_1U << INTVAL (operands[2]))))
                    return -1;
                  return 376; /* *leasi_general_4 */

                case E_DImode:
                  if (GET_MODE (x2) != E_DImode
                      || GET_MODE (x3) != E_DImode)
                    return -1;
                  if (register_operand (operands[0], E_DImode)
                      && register_no_SP_operand (operands[1], E_DImode)
                      && const_0_to_3_operand (operands[2], E_VOIDmode)
                      && const_int_operand (operands[3], E_VOIDmode)
                      && (
#line 8051 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[3])
   < (HOST_WIDE_INT_1U << INTVAL (operands[2]))) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 378; /* *leadi_general_4 */
                  if (!nonimmediate_operand (operands[0], E_DImode)
                      || !register_operand (operands[1], E_DImode)
                      || !const_int_operand (operands[2], E_QImode)
                      || !const_scalar_int_operand (operands[3], E_DImode)
                      || !(
#line 14151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT / 2
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                    return -1;
                  return 929; /* *concatsidi3_5 */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              if (GET_MODE (x6) != E_DImode
                  || !nonimmediate_operand (operands[0], E_DImode)
                  || GET_MODE (x2) != E_DImode
                  || GET_MODE (x3) != E_DImode)
                return -1;
              operands[1] = x4;
              if (!register_operand (operands[1], E_DImode))
                return -1;
              operands[2] = x5;
              if (!const_int_operand (operands[2], E_QImode))
                return -1;
              x7 = XEXP (x6, 0);
              operands[3] = x7;
              if (!nonimmediate_operand (operands[3], E_SImode)
                  || !(
#line 14074 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 893; /* *concatsidi3_1 */

            case SUBREG:
              switch (pattern439 (x2, 
LSHIFTRT))
                {
                case 0:
                  operands[2] = x5;
                  if (pattern1347 (x2) == 0)
                    {
                      if (
#line 15451 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && TARGET_APX_NF))
                        return 1066; /* x86_64_shld_1_nf */
                      if (pnum_clobbers != NULL
                          && 
#line 15451 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && true))
                        {
                          *pnum_clobbers = 1;
                          return 1067; /* x86_64_shld_1 */
                        }
                    }
                  operands[3] = x5;
                  if (pattern1348 (x2) != 0)
                    return -1;
                  if (
#line 15473 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && INTVAL (operands[4]) == 64 - INTVAL (operands[3])
   && TARGET_APX_NF))
                    return 1068; /* x86_64_shld_ndd_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15473 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && INTVAL (operands[4]) == 64 - INTVAL (operands[3])
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1069; /* x86_64_shld_ndd_1 */

                case 1:
                  operands[2] = x5;
                  if (pattern1349 (x2) == 0)
                    {
                      if (
#line 15683 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
  && TARGET_APX_NF))
                        return 1078; /* x86_shld_1_nf */
                      if (pnum_clobbers != NULL
                          && 
#line 15683 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
  && true))
                        {
                          *pnum_clobbers = 1;
                          return 1079; /* x86_shld_1 */
                        }
                    }
                  operands[3] = x5;
                  if (pattern1350 (x2) != 0)
                    return -1;
                  if (
#line 15705 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD 
   && INTVAL (operands[4]) == 32 - INTVAL (operands[3])
   && TARGET_APX_NF))
                    return 1080; /* x86_shld_ndd_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15705 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD 
   && INTVAL (operands[4]) == 32 - INTVAL (operands[3])
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1081; /* x86_shld_ndd_1 */

                default:
                  return -1;
                }

            case LSHIFTRT:
              switch (pattern442 (x2, pnum_clobbers))
                {
                case 0:
                  if (
#line 15489 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_APX_NF
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return 1070; /* *x86_64_shld_shrd_1_nozext_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15545 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1071; /* *x86_64_shld_shrd_1_nozext */

                case 1:
                  if (
#line 15721 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF
   && INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return 1082; /* *x86_shld_shrd_1_nozext_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15777 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1083; /* *x86_shld_shrd_1_nozext */

                case 2:
                  x7 = XEXP (x6, 0);
                  operands[1] = x7;
                  if (nonimmediate_operand (operands[0], E_DImode))
                    {
                      operands[2] = x5;
                      if (rtx_equal_p (x4, operands[0]))
                        {
                          x8 = XEXP (x6, 1);
                          x9 = XEXP (x8, 1);
                          if (rtx_equal_p (x9, operands[2])
                              && 
#line 15598 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            {
                              *pnum_clobbers = 1;
                              return 1072; /* *x86_64_shld_2 */
                            }
                        }
                    }
                  operands[2] = x7;
                  if (!register_operand (operands[0], E_DImode))
                    return -1;
                  operands[1] = x4;
                  if (!nonimmediate_operand (operands[1], E_DImode))
                    return -1;
                  operands[3] = x5;
                  x8 = XEXP (x6, 1);
                  x9 = XEXP (x8, 1);
                  if (!rtx_equal_p (x9, operands[3])
                      || !
#line 15619 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1073; /* *x86_64_shld_ndd_2 */

                case 3:
                  x7 = XEXP (x6, 0);
                  operands[1] = x7;
                  if (nonimmediate_operand (operands[0], E_SImode))
                    {
                      operands[2] = x5;
                      if (rtx_equal_p (x4, operands[0]))
                        {
                          x8 = XEXP (x6, 1);
                          x9 = XEXP (x8, 1);
                          if (rtx_equal_p (x9, operands[2])
                              && 
#line 15829 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            {
                              *pnum_clobbers = 1;
                              return 1084; /* *x86_shld_2 */
                            }
                        }
                    }
                  operands[2] = x7;
                  if (!register_operand (operands[0], E_SImode))
                    return -1;
                  operands[1] = x4;
                  if (!nonimmediate_operand (operands[1], E_SImode))
                    return -1;
                  operands[3] = x5;
                  x8 = XEXP (x6, 1);
                  x9 = XEXP (x8, 1);
                  if (!rtx_equal_p (x9, operands[3])
                      || !
#line 15850 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1085; /* *x86_shld_ndd_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case AND:
          switch (pattern290 (x2, 
LSHIFTRT))
            {
            case 0:
              x6 = XEXP (x2, 1);
              x7 = XEXP (x6, 0);
              x10 = XEXP (x7, 0);
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              if (nonimmediate_operand (operands[0], E_DImode))
                {
                  res = recog_77 (x1, insn, pnum_clobbers);
                  if (res >= 0)
                    return res;
                }
              operands[2] = x11;
              if (!register_operand (operands[0], E_DImode))
                return -1;
              operands[1] = x4;
              if (!nonimmediate_operand (operands[1], E_DImode))
                return -1;
              x12 = XEXP (x5, 0);
              operands[3] = x12;
              x13 = XEXP (x7, 1);
              x14 = XEXP (x13, 1);
              x15 = XEXP (x14, 0);
              if (!rtx_equal_p (x15, operands[3]))
                return -1;
              if (
#line 15436 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
                return 1064; /* x86_64_shld_ndd_nf */
              if (pnum_clobbers == NULL
                  || !
#line 15436 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              *pnum_clobbers = 1;
              return 1065; /* x86_64_shld_ndd */

            case 1:
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || pattern289 (x2, 
E_SImode, 
E_DImode) != 0)
                return -1;
              x6 = XEXP (x2, 1);
              x7 = XEXP (x6, 0);
              x10 = XEXP (x7, 0);
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              x12 = XEXP (x5, 0);
              operands[2] = x12;
              if (rtx_equal_p (x4, operands[0]))
                {
                  x13 = XEXP (x7, 1);
                  x14 = XEXP (x13, 1);
                  x15 = XEXP (x14, 0);
                  if (rtx_equal_p (x15, operands[2]))
                    {
                      if (
#line 15645 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF))
                        return 1074; /* x86_shld_nf */
                      if (pnum_clobbers != NULL)
                        {
                          *pnum_clobbers = 1;
                          return 1075; /* x86_shld */
                        }
                    }
                }
              operands[2] = x11;
              operands[1] = x4;
              if (!nonimmediate_operand (operands[1], E_SImode))
                return -1;
              operands[3] = x12;
              x13 = XEXP (x7, 1);
              x14 = XEXP (x13, 1);
              x15 = XEXP (x14, 0);
              if (!rtx_equal_p (x15, operands[3]))
                return -1;
              if (
#line 15667 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
                return 1076; /* x86_shld_ndd_nf */
              if (pnum_clobbers == NULL
                  || !
#line 15667 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              *pnum_clobbers = 1;
              return 1077; /* x86_shld_ndd */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SIGN_EXTEND:
      switch (pattern260 (x2, 
E_SImode, 
E_DImode))
        {
        case 0:
          if (!(
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 905; /* *concatsidi3_3 */

        case 1:
          if (!(
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 935; /* *concatsidi3_6 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      switch (pattern260 (x2, 
E_SImode, 
E_DImode))
        {
        case 0:
          if (!(
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 908; /* *concatsidi3_3 */

        case 1:
          if (!(
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 938; /* *concatsidi3_6 */

        default:
          return -1;
        }

    case CONST_INT:
      switch (pattern288 (x2, pnum_clobbers))
        {
        case 0:
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          if (register_operand (operands[2], E_QImode))
            {
              switch (pattern748 (x2))
                {
                case 0:
                  if (
#line 18837 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT))
                    {
                      *pnum_clobbers = 1;
                      return 1391; /* *btssi */
                    }
                  break;

                case 1:
                  if ((
#line 18837 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pnum_clobbers = 1;
                      return 1393; /* *btsdi */
                    }
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x5) != SUBREG)
            return -1;
          switch (pattern757 (x2))
            {
            case 0:
              if (!
#line 18856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 1395; /* *btssi_mask */

            case 1:
              if (!(
#line 18856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1397; /* *btsdi_mask */

            default:
              return -1;
            }

        case 1:
          if (!
#line 18884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1399; /* *btssi_mask_1 */

        case 2:
          if (!(
#line 18884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1401; /* *btsdi_mask_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_98 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (pnum_clobbers != NULL)
        {
          x2 = XEXP (x1, 1);
          if (pattern734 (x2, 
E_DImode, 
E_QImode) == 0
              && 
#line 1195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            {
              *pnum_clobbers = 1;
              return 1131; /* ashrdi3_doubleword */
            }
        }
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      if (nonimmediate_operand (operands[0], E_DImode)
          && const_int_operand (operands[2], E_QImode))
        {
          if ((
#line 17258 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == GET_MODE_BITSIZE (DImode)-1
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1168; /* ashrdi3_cvt_nf */
          if (pnum_clobbers != NULL
              && (
#line 17258 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == GET_MODE_BITSIZE (DImode)-1
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1169; /* ashrdi3_cvt */
            }
        }
      if (register_operand (operands[0], E_DImode)
          && register_operand (operands[2], E_DImode)
          && (
#line 17327 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 1174; /* *bmi2_ashrdi3_1 */
      if (!nonimmediate_operand (operands[0], E_DImode)
          || !nonmemory_operand (operands[2], E_QImode))
        return -1;
      if ((
#line 17337 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 1177; /* *ashrdi3_1_nf */
      if (pnum_clobbers == NULL
          || !(
#line 17337 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1178; /* *ashrdi3_1 */

    case E_SImode:
      x2 = XEXP (x1, 1);
      if (pattern619 (x2, 
E_SImode) != 0)
        return -1;
      if (
#line 17337 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
        return 1175; /* *ashrsi3_1_nf */
      if (pnum_clobbers == NULL
          || !
#line 17337 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)
   && true))
        return -1;
      *pnum_clobbers = 1;
      return 1176; /* *ashrsi3_1 */

    default:
      return -1;
    }
}

 int
recog_103 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) == SUBREG
      && known_eq (SUBREG_BYTE (x2), 0))
    {
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      if (register_operand (operands[0], E_QImode))
        {
          x4 = XEXP (x1, 1);
          x5 = XEXP (x4, 2);
          operands[2] = x5;
          if (register_operand (operands[2], E_QImode))
            {
              switch (GET_MODE (x2))
                {
                case E_SImode:
                  if (GET_MODE (x4) == E_SImode
                      && register_operand (operands[1], E_SImode)
                      && 
#line 19356 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                    {
                      *pnum_clobbers = 1;
                      return 1434; /* *btsi_setcqi */
                    }
                  break;

                case E_DImode:
                  if (GET_MODE (x4) == E_DImode
                      && register_operand (operands[1], E_DImode)
                      && (
#line 19356 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pnum_clobbers = 1;
                      return 1435; /* *btdi_setcqi */
                    }
                  break;

                default:
                  break;
                }
            }
        }
    }
  x4 = XEXP (x1, 1);
  x5 = XEXP (x4, 2);
  if (GET_CODE (x5) != SUBREG
      || maybe_ne (SUBREG_BYTE (x5), 0)
      || GET_MODE (x5) != E_QImode)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != AND)
    return -1;
  operands[0] = x2;
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  x8 = XEXP (x6, 1);
  operands[3] = x8;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (pattern1439 (x4, 
E_SImode) != 0
          || !
#line 19437 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1442; /* *btsi_setcsi_mask */

    case E_DImode:
      if (pattern1439 (x4, 
E_DImode) != 0
          || !(
#line 19437 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1443; /* *btdi_setcdi_mask */

    default:
      return -1;
    }
}

 int
recog_104 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (XWINT (x3, 0) == 1L)
    {
      res = recog_103 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
    }
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  operands[2] = x3;
  if (!const_0_to_255_operand (operands[2], E_QImode))
    return -1;
  x6 = XEXP (x2, 2);
  operands[3] = x6;
  if (!const_0_to_255_operand (operands[3], E_QImode))
    return -1;
  switch (pattern126 (x2))
    {
    case 0:
      if (!
#line 22184 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
        return -1;
      *pnum_clobbers = 1;
      return 1604; /* tbm_bextri_si */

    case 1:
      if (!(
#line 22184 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1605; /* tbm_bextri_di */

    default:
      return -1;
    }
}

 int
recog_107 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 17:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      return 1487; /* *memory_blockage */

    case 14:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case CONST_INT:
          if (XWINT (x4, 0) != 0L)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pnum_clobbers == NULL
                  || !register_operand (operands[0], E_SImode)
                  || GET_MODE (x2) != E_SImode
                  || !
#line 20785 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 1498; /* *set_got */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x2) != E_DImode
                  || !
#line 20815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 1500; /* set_got_rex64 */

            default:
              return -1;
            }

        case LABEL_REF:
          if (pnum_clobbers == NULL
              || !register_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode)
            return -1;
          x5 = XEXP (x4, 0);
          operands[1] = x5;
          if (!
#line 20807 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1499; /* *set_got_labelled */

        default:
          return -1;
        }

    case 15:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      if (GET_CODE (x4) != LABEL_REF)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_DImode))
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!
#line 20824 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      return 1501; /* set_rip_rex64 */

    case 16:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      if (GET_CODE (x4) != LABEL_REF)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_DImode))
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!
#line 20835 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LP64))
        return -1;
      return 1502; /* set_got_offset_rex64 */

    case 97:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern302 (x2))
        {
        case 0:
          if ((
#line 21678 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21660 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return 1546; /* tzcnt_si_nf */
          if (pnum_clobbers == NULL
              || !
#line 21660 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return -1;
          *pnum_clobbers = 1;
          return 1550; /* tzcnt_si */

        case 1:
          if ((
#line 21678 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && (((
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))))
            return 1548; /* tzcnt_di_nf */
          if (pnum_clobbers == NULL
              || !(((
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return -1;
          *pnum_clobbers = 1;
          return 1552; /* tzcnt_di */

        default:
          return -1;
        }

    case 96:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern302 (x2))
        {
        case 0:
          if ((
#line 21678 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21661 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return 1547; /* lzcnt_si_nf */
          if (pnum_clobbers == NULL
              || !
#line 21661 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          *pnum_clobbers = 1;
          return 1551; /* lzcnt_si */

        case 1:
          if ((
#line 21678 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && (((
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))))
            return 1549; /* lzcnt_di_nf */
          if (pnum_clobbers == NULL
              || !(((
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return -1;
          *pnum_clobbers = 1;
          return 1553; /* lzcnt_di */

        default:
          return -1;
        }

    case 19:
      x4 = XVECEXP (x2, 0, 0);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern23 (x2))
        {
        case 0:
          if (!
#line 1408 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode))
            return -1;
          return 1658; /* *load_tp_si */

        case 1:
          if (!
#line 1408 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode))
            return -1;
          return 1659; /* *load_tp_di */

        default:
          return -1;
        }

    case 22:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!tls_symbolic_operand (operands[1], E_VOIDmode))
        return -1;
      switch (pattern23 (x2))
        {
        case 0:
          if (!(
#line 23372 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
            return -1;
          return 1667; /* *tls_dynamic_gnu2_lea_64_si */

        case 1:
          if (!(
#line 23372 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
            return -1;
          return 1668; /* *tls_dynamic_gnu2_lea_64_di */

        default:
          return -1;
        }

    case 70:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_XFmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pnum_clobbers == NULL
              || !nonimmediate_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !
#line 25151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          *pnum_clobbers = 1;
          return 1733; /* lrintxfdi2 */

        case E_SImode:
          if (!nonimmediate_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode
              || !
#line 25160 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          return 1735; /* lrintxfsi2 */

        default:
          return -1;
        }

    case 78:
      switch (pattern120 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 25367 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1746; /* *fistsi2_floor_1 */

        case 1:
          if (!
#line 25367 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1748; /* *fistdi2_floor_1 */

        default:
          return -1;
        }

    case 79:
      switch (pattern120 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 25367 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1747; /* *fistsi2_ceil_1 */

        case 1:
          if (!
#line 25367 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1749; /* *fistdi2_ceil_1 */

        default:
          return -1;
        }

    case 49:
      return recog_106 (x1, insn, pnum_clobbers);

    case 18:
      if (pnum_clobbers == NULL)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!memory_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode
              || !const0_operand (operands[1], E_SImode)
              || !
#line 1403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
            return -1;
          *pnum_clobbers = 1;
          return 1861; /* probe_stack_1_si */

        case E_DImode:
          if (!memory_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !const0_operand (operands[1], E_DImode)
              || !
#line 1403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
            return -1;
          *pnum_clobbers = 1;
          return 1862; /* probe_stack_1_di */

        default:
          return -1;
        }

    case 33:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      return 1955; /* *pause */

    case 102:
      switch (pattern121 (x1))
        {
        case 0:
          if (!
#line 29831 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIRI))
            return -1;
          return 1986; /* movdirisi */

        case 1:
          if (!(
#line 29831 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIRI) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1987; /* movdiridi */

        default:
          return -1;
        }

    case 103:
      if (GET_MODE (x2) != E_XImode)
        return -1;
      x3 = XEXP (x1, 0);
      if (GET_CODE (x3) != MEM
          || GET_MODE (x3) != E_XImode)
        return -1;
      x6 = XEXP (x3, 0);
      operands[0] = x6;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!memory_operand (operands[1], E_XImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || !(
#line 29839 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIR64B) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 1988; /* movdir64b_si */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || !(
#line 29839 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIR64B) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 1989; /* movdir64b_di */

        default:
          return -1;
        }

    case 111:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DImode)
          || !
#line 636 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)))
        return -1;
      return 2048; /* sse_movntq */

    case 117:
      switch (pattern121 (x1))
        {
        case 0:
          if (!
#line 2012 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 2561; /* sse2_movntisi */

        case 1:
          if (!(
#line 2012 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 2562; /* sse2_movntidi */

        default:
          return -1;
        }

    case 156:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case VEC_SELECT:
          switch (pattern453 (x4))
            {
            case 0:
              switch (pattern1086 (x2, 
E_SImode))
                {
                case 0:
                  if (!
#line 7815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4474; /* avx512fp16_vcvtsh2usi */

                case 1:
                  if (!
#line 9013 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                    return -1;
                  return 4834; /* avx512f_vcvtss2usi */

                case 2:
                  if (!
#line 9049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                    return -1;
                  return 4846; /* avx512f_vcvtsd2usi */

                default:
                  return -1;
                }

            case 1:
              switch (pattern1086 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 7815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4478; /* avx512fp16_vcvtsh2usiq */

                case 1:
                  if (!(
#line 9013 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4836; /* avx512f_vcvtss2usiq */

                case 2:
                  if (!(
#line 9049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4848; /* avx512f_vcvtsd2usiq */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x4;
          if (!nonimmediate_operand (operands[1], E_HFmode))
            return -1;
          switch (pattern23 (x2))
            {
            case 0:
              if (!
#line 7826 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4482; /* avx512fp16_vcvtsh2usi_2 */

            case 1:
              if (!(
#line 7826 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 4484; /* avx512fp16_vcvtsh2usiq_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 46:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case VEC_SELECT:
          switch (pattern453 (x4))
            {
            case 0:
              switch (pattern1087 (x2, 
E_SImode))
                {
                case 0:
                  if (!
#line 7815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4476; /* avx512fp16_vcvtsh2si */

                case 1:
                  if (!
#line 8542 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 4723; /* sse_cvtss2si */

                case 2:
                  if (!
#line 9085 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 4858; /* sse2_cvtsd2si */

                default:
                  return -1;
                }

            case 1:
              switch (pattern1087 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 7815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4480; /* avx512fp16_vcvtsh2siq */

                case 1:
                  if (!(
#line 8542 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4725; /* sse_cvtss2siq */

                case 2:
                  if (!(
#line 9085 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4860; /* sse2_cvtsd2siq */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              switch (pattern762 (x2, 
E_SImode))
                {
                case 0:
                  if (!
#line 7826 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4483; /* avx512fp16_vcvtsh2si_2 */

                case 1:
                  if (!
#line 8555 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 4727; /* sse_cvtss2si_2 */

                case 2:
                  if (!
#line 9099 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 4862; /* sse2_cvtsd2si_2 */

                default:
                  return -1;
                }

            case E_DImode:
              switch (pattern762 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 7826 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4485; /* avx512fp16_vcvtsh2siq_2 */

                case 1:
                  if (!(
#line 8555 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4728; /* sse_cvtss2siq_2 */

                case 2:
                  if (!(
#line 9099 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4863; /* sse2_cvtsd2siq_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 172:
      switch (pattern123 (x1))
        {
        case 0:
          if (!
#line 7980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return -1;
          return 4626; /* unspec_avx512fp16_fix_truncsi2 */

        case 1:
          if (!
#line 8570 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 4729; /* unspec_sse_cvttss2si */

        case 2:
          if (!
#line 9114 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 4864; /* unspec_sse2_cvttsd2si */

        case 3:
          if (!(
#line 7980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4630; /* unspec_avx512fp16_fix_truncdi2 */

        case 4:
          if (!(
#line 8570 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4731; /* unspec_sse_cvttss2siq */

        case 5:
          if (!(
#line 9114 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4866; /* unspec_sse2_cvttsd2siq */

        default:
          return -1;
        }

    case 173:
      switch (pattern123 (x1))
        {
        case 0:
          if (!
#line 7980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return -1;
          return 4628; /* unspec_avx512fp16_fixuns_truncsi2 */

        case 1:
          if (!
#line 9024 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 4838; /* unspec_avx512f_vcvttss2usi */

        case 2:
          if (!
#line 9060 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 4850; /* unspec_avx512f_vcvttsd2usi */

        case 3:
          if (!(
#line 7980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4632; /* unspec_avx512fp16_fixuns_truncdi2 */

        case 4:
          if (!(
#line 9024 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4840; /* unspec_avx512f_vcvttss2usiq */

        case 5:
          if (!(
#line 9060 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4852; /* unspec_avx512f_vcvttsd2usiq */

        default:
          return -1;
        }

    case 191:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !register_operand (operands[1], E_V64QImode)
              || !(
#line 10246 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5099; /* avx512bw_cvtb2maskv64qi */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V32QImode:
              if (!register_operand (operands[1], E_V32QImode)
                  || !(
#line 10246 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 5101; /* avx512vl_cvtb2maskv32qi */

            case E_V32HImode:
              if (!register_operand (operands[1], E_V32HImode)
                  || !(
#line 10246 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 5102; /* avx512bw_cvtw2maskv32hi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 275:
      switch (pattern125 (x1))
        {
        case 0:
          if (!
#line 32618 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10808; /* avx10_2_vcvttsd2sissi */

        case 1:
          if (!
#line 32631 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10816; /* avx10_2_vcvttss2sissi */

        case 2:
          if (!(
#line 32618 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10812; /* avx10_2_vcvttsd2sisdi */

        case 3:
          if (!(
#line 32631 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10820; /* avx10_2_vcvttss2sisdi */

        default:
          return -1;
        }

    case 276:
      switch (pattern125 (x1))
        {
        case 0:
          if (!
#line 32618 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10810; /* avx10_2_vcvttsd2usissi */

        case 1:
          if (!
#line 32631 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10818; /* avx10_2_vcvttss2usissi */

        case 2:
          if (!(
#line 32618 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10814; /* avx10_2_vcvttsd2usisdi */

        case 3:
          if (!(
#line 32631 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10822; /* avx10_2_vcvttss2usisdi */

        default:
          return -1;
        }

    case 280:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0])
          || !
#line 60 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(TARGET_SSE2))
        return -1;
      return 10902; /* *sse2_lfence */

    case 281:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0])
          || !
#line 79 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(TARGET_SSE || TARGET_3DNOW_A))
        return -1;
      return 10903; /* *sse_sfence */

    case 282:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      if (
#line 98 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(TARGET_64BIT || TARGET_SSE2))
        return 10904; /* mfence_sse2 */
      if (pnum_clobbers == NULL)
        return -1;
      *pnum_clobbers = 1;
      return 10905; /* mfence_nosse */

    case 284:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DFmode)
          || !
#line 356 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(TARGET_80387))
        return -1;
      return 10913; /* storedi_via_fpu */

    case 286:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DFmode)
          || !
#line 382 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(TARGET_SSE))
        return -1;
      return 10915; /* storedi_via_sse */

    default:
      return -1;
    }
}

 int
recog_146 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (XVECLEN (x4, 0))
    {
    case 1:
      x5 = XEXP (x2, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x6 = XVECEXP (x4, 0, 0);
      operands[1] = x6;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      x8 = XEXP (x3, 2);
      operands[4] = x8;
      if (!register_operand (operands[4], E_QImode))
        return -1;
      x9 = XEXP (x2, 1);
      operands[2] = x9;
      switch (XINT (x4, 1))
        {
        case 54:
          if (pattern1270 (x2) != 0
              || !(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2982 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2886; /* avx512fp16_vmrcpv8hf2_mask */

        case 161:
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1358 (x2, 
E_V4SFmode) != 0
                  || !
#line 3038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2902; /* srcp14v4sf_mask */

            case E_V2DFmode:
              if (pattern1358 (x2, 
E_V2DFmode) != 0
                  || !(
#line 3038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2903; /* srcp14v2df_mask */

            default:
              return -1;
            }

        case 162:
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1358 (x2, 
E_V4SFmode) != 0
                  || !
#line 3192 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2974; /* rsqrt14_v4sf_mask */

            case E_V2DFmode:
              if (pattern1358 (x2, 
E_V2DFmode) != 0
                  || !(
#line 3192 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2975; /* rsqrt14_v2df_mask */

            default:
              return -1;
            }

        case 55:
          if (pattern1270 (x2) != 0
              || !(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3240 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2979; /* avx512fp16_vmrsqrtv8hf2_mask */

        default:
          return -1;
        }

    case 2:
      x5 = XEXP (x2, 2);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      switch (XINT (x4, 1))
        {
        case 63:
          switch (pattern764 (x2))
            {
            case 0:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3122; /* avx512fp16_ieee_vmmaxv8hf3_mask */

            case 1:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
                return -1;
              return 3130; /* sse_ieee_vmmaxv4sf3_mask */

            case 2:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3138; /* sse2_ieee_vmmaxv2df3_mask */

            default:
              return -1;
            }

        case 62:
          switch (pattern764 (x2))
            {
            case 0:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3126; /* avx512fp16_ieee_vmminv8hf3_mask */

            case 1:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
                return -1;
              return 3134; /* sse_ieee_vmminv4sf3_mask */

            case 2:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3142; /* sse2_ieee_vmminv2df3_mask */

            default:
              return -1;
            }

        case 221:
          if (pattern765 (x2) != 0
              || !(
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4330; /* avx512fp16_fmulcsh_v8hf_mask */

        case 222:
          if (pattern765 (x2) != 0
              || !(
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4334; /* avx512fp16_fcmulcsh_v8hf_mask */

        case 58:
          switch (pattern764 (x2))
            {
            case 0:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 5322; /* avx512f_vmscalefv8hf_mask */

            case 1:
              if (!
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 5326; /* avx512f_vmscalefv4sf_mask */

            case 2:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 5330; /* avx512f_vmscalefv2df_mask */

            default:
              return -1;
            }

        case 165:
          switch (pattern764 (x2))
            {
            case 0:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 6983; /* avx512f_sgetexpv8hf_mask */

            case 1:
              if (!
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 6987; /* avx512f_sgetexpv4sf_mask */

            case 2:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 6991; /* avx512f_sgetexpv2df_mask */

            default:
              return -1;
            }

        case 94:
          if (XWINT (x5, 0) != 1L)
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[2] = x6;
          x10 = XVECEXP (x4, 0, 1);
          operands[3] = x10;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          x7 = XEXP (x3, 1);
          operands[4] = x7;
          x8 = XEXP (x3, 2);
          operands[5] = x8;
          if (!register_operand (operands[5], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          operands[1] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern1522 (x2, 
E_V8HFmode) != 0
                  || !(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 7099; /* avx512f_rndscalev8hf_mask */

            case E_V4SFmode:
              if (pattern1522 (x2, 
E_V4SFmode) != 0
                  || !
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 7103; /* avx512f_rndscalev4sf_mask */

            case E_V2DFmode:
              if (pattern1522 (x2, 
E_V2DFmode) != 0
                  || !(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 7107; /* avx512f_rndscalev2df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 3:
      x5 = XEXP (x2, 2);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XVECEXP (x4, 0, 0);
      operands[1] = x6;
      x10 = XVECEXP (x4, 0, 1);
      operands[2] = x10;
      x11 = XVECEXP (x4, 0, 2);
      operands[3] = x11;
      switch (XINT (x4, 1))
        {
        case 192:
          switch (pattern1100 (x2))
            {
            case 0:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3196; /* reducesv8hf_mask */

            case 1:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 4044 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode)))))
                return -1;
              return 3200; /* reducesv4sf_mask */

            case 2:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3204; /* reducesv2df_mask */

            default:
              return -1;
            }

        case 217:
          switch (pattern1101 (x2))
            {
            case 0:
              if (!(
#line 371 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4317; /* avx512fp16_fma_fmaddcsh_v8hf_maskz */

            case 1:
              if (!
#line 7511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4324; /* avx512fp16_fmaddcsh_v8hf_mask */

            default:
              return -1;
            }

        case 219:
          switch (pattern1101 (x2))
            {
            case 0:
              if (!(
#line 371 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4321; /* avx512fp16_fma_fcmaddcsh_v8hf_maskz */

            case 1:
              if (!
#line 7511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4326; /* avx512fp16_fcmaddcsh_v8hf_mask */

            default:
              return -1;
            }

        case 194:
          if (XWINT (x5, 0) != 1L
              || !const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          x7 = XEXP (x3, 1);
          operands[4] = x7;
          x8 = XEXP (x3, 2);
          operands[5] = x8;
          if (!register_operand (operands[5], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1098 (x2, 
E_V4SFmode) != 0
                  || !(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29838 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
                return -1;
              return 9901; /* avx512dq_rangesv4sf_mask */

            case E_V2DFmode:
              if (pattern1098 (x2, 
E_V2DFmode) != 0
                  || !(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29838 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 9905; /* avx512dq_rangesv2df_mask */

            default:
              return -1;
            }

        case 166:
          if (XWINT (x5, 0) != 1L
              || !const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          switch (pattern1099 (x2))
            {
            case 0:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29906 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 9969; /* avx512f_vgetmantv8hf_mask */

            case 1:
              if (!
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 9973; /* avx512f_vgetmantv4sf_mask */

            case 2:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29906 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 9977; /* avx512f_vgetmantv2df_mask */

            default:
              return -1;
            }

        case 278:
          switch (pattern1100 (x2))
            {
            case 0:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32671 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 10867; /* avx10_2_minmaxsv8hf_mask */

            case 1:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32671 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10871; /* avx10_2_minmaxsv4sf_mask */

            case 2:
              if (!(
#line 355 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32671 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 10875; /* avx10_2_minmaxsv2df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 4:
      if (XINT (x4, 1) != 163)
        return -1;
      x6 = XVECEXP (x4, 0, 0);
      operands[1] = x6;
      x10 = XVECEXP (x4, 0, 1);
      operands[2] = x10;
      x11 = XVECEXP (x4, 0, 2);
      operands[3] = x11;
      x12 = XVECEXP (x4, 0, 3);
      operands[4] = x12;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      x7 = XEXP (x3, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[5] = x7;
          x5 = XEXP (x2, 2);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x8 = XEXP (x3, 2);
          operands[6] = x8;
          if (!register_operand (operands[6], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[2]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1618 (x2, 
E_V4SFmode, 
E_V4SImode) != 0
                  || !
#line 154 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 7052; /* avx512f_sfixupimmv4sf_maskz_1 */

            case E_V2DFmode:
              if (pattern1618 (x2, 
E_V2DFmode, 
E_V2DImode) != 0
                  || !(
#line 154 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14180 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 7056; /* avx512f_sfixupimmv2df_maskz_1 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          if (!rtx_equal_p (x7, operands[2]))
            return -1;
          x8 = XEXP (x3, 2);
          if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x5 = XEXP (x2, 2);
          operands[5] = x5;
          if (!register_operand (operands[5], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1619 (x2, 
E_V4SImode, 
E_V4SFmode) != 0
                  || !
#line 14199 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 7058; /* avx512f_sfixupimmv4sf_mask */

            case E_V2DFmode:
              if (pattern1619 (x2, 
E_V2DImode, 
E_V2DFmode) != 0
                  || !(
#line 14199 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 7060; /* avx512f_sfixupimmv2df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_158 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x3;
      x4 = XEXP (x2, 2);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
          operands[5] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1376 (x2, 
E_V4SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4SFmode)
                  && nonimmediate_operand (operands[2], E_V4SFmode)
                  && nonimmediate_operand (operands[3], E_V4SFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3948; /* *fma_fnmsub_v4sf */
              if (!bcst_vector_operand (operands[1], E_V4SFmode)
                  || !bcst_vector_operand (operands[2], E_V4SFmode)
                  || !bcst_vector_operand (operands[3], E_V4SFmode)
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3980; /* fma_fnmsub_v4sf_maskz_1 */

            case E_V2DFmode:
              if (pattern1376 (x2, 
E_V2DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V2DFmode)
                  && nonimmediate_operand (operands[2], E_V2DFmode)
                  && nonimmediate_operand (operands[3], E_V2DFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3952; /* *fma_fnmsub_v2df */
              if (!bcst_vector_operand (operands[1], E_V2DFmode)
                  || !bcst_vector_operand (operands[2], E_V2DFmode)
                  || !bcst_vector_operand (operands[3], E_V2DFmode)
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3989; /* fma_fnmsub_v2df_maskz_1 */

            case E_V8SFmode:
              if (pattern1376 (x2, 
E_V8SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V8SFmode)
                  && nonimmediate_operand (operands[2], E_V8SFmode)
                  && nonimmediate_operand (operands[3], E_V8SFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3956; /* *fma_fnmsub_v8sf */
              if (!bcst_vector_operand (operands[1], E_V8SFmode)
                  || !bcst_vector_operand (operands[2], E_V8SFmode)
                  || !bcst_vector_operand (operands[3], E_V8SFmode)
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3978; /* fma_fnmsub_v8sf_maskz_1 */

            case E_V4DFmode:
              if (pattern1376 (x2, 
E_V4DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4DFmode)
                  && nonimmediate_operand (operands[2], E_V4DFmode)
                  && nonimmediate_operand (operands[3], E_V4DFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3960; /* *fma_fnmsub_v4df */
              if (!bcst_vector_operand (operands[1], E_V4DFmode)
                  || !bcst_vector_operand (operands[2], E_V4DFmode)
                  || !bcst_vector_operand (operands[3], E_V4DFmode)
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3987; /* fma_fnmsub_v4df_maskz_1 */

            case E_V32HFmode:
              if (pattern1377 (x2, 
E_SImode, 
E_V32HFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5931 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 3964; /* fma_fnmsub_v32hf_maskz_1 */

            case E_V16HFmode:
              if (pattern1377 (x2, 
E_HImode, 
E_V16HFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3968; /* fma_fnmsub_v16hf_maskz_1 */

            case E_V8HFmode:
              if (pattern1377 (x2, 
E_QImode, 
E_V8HFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5933 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3970; /* fma_fnmsub_v8hf_maskz_1 */

            case E_V16SFmode:
              if (pattern1377 (x2, 
E_HImode, 
E_V16SFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5935 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3974; /* fma_fnmsub_v16sf_maskz_1 */

            case E_V8DFmode:
              if (pattern1377 (x2, 
E_QImode, 
E_V8DFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5937 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3983; /* fma_fnmsub_v8df_maskz_1 */

            case E_V32BFmode:
              if (pattern1378 (x2, 
E_SImode, 
E_V32BFmode) != 0
                  || !
#line 32350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10591; /* avx10_2_fnmsubbf16_v32bf_maskz_1 */

            case E_V16BFmode:
              if (pattern1378 (x2, 
E_HImode, 
E_V16BFmode) != 0
                  || !
#line 32350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10593; /* avx10_2_fnmsubbf16_v16bf_maskz_1 */

            case E_V8BFmode:
              if (pattern1378 (x2, 
E_QImode, 
E_V8BFmode) != 0
                  || !
#line 32350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10595; /* avx10_2_fnmsubbf16_v8bf_maskz_1 */

            default:
              return -1;
            }

        case CONST_INT:
          if (XWINT (x4, 0) != 1L)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1379 (x2, 
E_V4SFmode) != 0
                  || !
#line 7008 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA4))
                return -1;
              return 4250; /* *fma4i_vmfnmsub_v4sf */

            case E_V2DFmode:
              if (pattern1379 (x2, 
E_V2DFmode) != 0
                  || !(
#line 7008 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA4) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 4251; /* *fma4i_vmfnmsub_v2df */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      switch (pattern632 (x2))
        {
        case 0:
          if (pattern1283 (x2, 
E_V32HFmode, 
E_SImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V32HFmode)
              && vector_operand (operands[3], E_V32HFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return 3990; /* avx512bw_fnmsub_v32hf_mask */
          if (!vector_operand (operands[1], E_V32HFmode)
              || !nonimmediate_operand (operands[3], E_V32HFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return -1;
          return 4002; /* avx512bw_fnmsub_v32hf_mask3 */

        case 1:
          if (pattern1283 (x2, 
E_V16HFmode, 
E_HImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V16HFmode)
              && vector_operand (operands[3], E_V16HFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return 3992; /* avx512vl_fnmsub_v16hf_mask */
          if (!vector_operand (operands[1], E_V16HFmode)
              || !nonimmediate_operand (operands[3], E_V16HFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4004; /* avx512vl_fnmsub_v16hf_mask3 */

        case 2:
          if (pattern1283 (x2, 
E_V8HFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V8HFmode)
              && vector_operand (operands[3], E_V8HFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return 3993; /* avx512fp16_fnmsub_v8hf_mask */
          if (!vector_operand (operands[1], E_V8HFmode)
              || !nonimmediate_operand (operands[3], E_V8HFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4006; /* avx512fp16_fnmsub_v8hf_mask3 */

        case 3:
          if (pattern1283 (x2, 
E_V16SFmode, 
E_HImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V16SFmode)
              && vector_operand (operands[3], E_V16SFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 3994; /* avx512f_fnmsub_v16sf_mask */
          if (!vector_operand (operands[1], E_V16SFmode)
              || !nonimmediate_operand (operands[3], E_V16SFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4008; /* avx512f_fnmsub_v16sf_mask3 */

        case 4:
          if (pattern1283 (x2, 
E_V8SFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V8SFmode)
              && vector_operand (operands[3], E_V8SFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3996; /* avx512vl_fnmsub_v8sf_mask */
          if (!vector_operand (operands[1], E_V8SFmode)
              || !nonimmediate_operand (operands[3], E_V8SFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4010; /* avx512vl_fnmsub_v8sf_mask3 */

        case 5:
          if (pattern1283 (x2, 
E_V4SFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V4SFmode)
              && vector_operand (operands[3], E_V4SFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3997; /* avx512vl_fnmsub_v4sf_mask */
          if (!vector_operand (operands[1], E_V4SFmode)
              || !nonimmediate_operand (operands[3], E_V4SFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4012; /* avx512vl_fnmsub_v4sf_mask3 */

        case 6:
          if (pattern1283 (x2, 
E_V8DFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V8DFmode)
              && vector_operand (operands[3], E_V8DFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 3998; /* avx512f_fnmsub_v8df_mask */
          if (!vector_operand (operands[1], E_V8DFmode)
              || !nonimmediate_operand (operands[3], E_V8DFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4014; /* avx512f_fnmsub_v8df_mask3 */

        case 7:
          if (pattern1283 (x2, 
E_V4DFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V4DFmode)
              && vector_operand (operands[3], E_V4DFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4000; /* avx512vl_fnmsub_v4df_mask */
          if (!vector_operand (operands[1], E_V4DFmode)
              || !nonimmediate_operand (operands[3], E_V4DFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4016; /* avx512vl_fnmsub_v4df_mask3 */

        case 8:
          if (pattern1283 (x2, 
E_V2DFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V2DFmode)
              && vector_operand (operands[3], E_V2DFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4001; /* avx512vl_fnmsub_v2df_mask */
          if (!vector_operand (operands[1], E_V2DFmode)
              || !nonimmediate_operand (operands[3], E_V2DFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4018; /* avx512vl_fnmsub_v2df_mask3 */

        case 9:
          if (pattern1284 (x2, 
E_SImode, 
E_V32BFmode) != 0)
            return -1;
          if (rtx_equal_p (x3, operands[1])
              && 
#line 32370 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return 10596; /* avx10_2_fnmsubbf16_v32bf_mask */
          if (!rtx_equal_p (x3, operands[3])
              || !
#line 32389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10599; /* avx10_2_fnmsubbf16_v32bf_mask3 */

        case 10:
          if (pattern1284 (x2, 
E_HImode, 
E_V16BFmode) != 0)
            return -1;
          if (rtx_equal_p (x3, operands[1])
              && 
#line 32370 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return 10597; /* avx10_2_fnmsubbf16_v16bf_mask */
          if (!rtx_equal_p (x3, operands[3])
              || !
#line 32389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10600; /* avx10_2_fnmsubbf16_v16bf_mask3 */

        case 11:
          if (pattern1284 (x2, 
E_QImode, 
E_V8BFmode) != 0)
            return -1;
          if (rtx_equal_p (x3, operands[1])
              && 
#line 32370 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return 10598; /* avx10_2_fnmsubbf16_v8bf_mask */
          if (!rtx_equal_p (x3, operands[3])
              || !
#line 32389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10601; /* avx10_2_fnmsubbf16_v8bf_mask3 */

        case 12:
          if (pattern1380 (x2, 
E_V8HFmode) != 0
              || !(
#line 6655 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4166; /* *fmai_fnmsub_v8hf */

        case 13:
          if (pattern1380 (x2, 
E_V4SFmode) != 0
              || !
#line 6655 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F))
            return -1;
          return 4168; /* *fmai_fnmsub_v4sf */

        case 14:
          if (pattern1380 (x2, 
E_V2DFmode) != 0
              || !(
#line 6655 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 4170; /* *fmai_fnmsub_v2df */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_166 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  operands[2] = x5;
  if (const_0_to_7_operand (operands[2], E_VOIDmode))
    {
      x6 = XVECEXP (x4, 0, 1);
      operands[3] = x6;
      if (const_0_to_7_operand (operands[3], E_VOIDmode))
        {
          x7 = XEXP (x2, 1);
          operands[4] = x7;
          x8 = XEXP (x2, 2);
          operands[5] = x8;
          if (register_operand (operands[5], E_QImode))
            {
              switch (GET_MODE (operands[0]))
                {
                case E_V2DFmode:
                  if (pattern1527 (x2, 
E_V2DFmode, 
E_V8DFmode) == 0
                      && (
#line 12421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && INTVAL (operands[2]) % 2 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[4]))) && 
#line 717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return 5240; /* avx512dq_vextractf64x2_1_mask */
                  break;

                case E_V2DImode:
                  if (pattern1527 (x2, 
E_V2DImode, 
E_V8DImode) == 0
                      && (
#line 12421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && INTVAL (operands[2]) % 2 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[4]))) && 
#line 717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return 5241; /* avx512dq_vextracti64x2_1_mask */
                  break;

                default:
                  break;
                }
            }
        }
    }
  x6 = XVECEXP (x4, 0, 1);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XEXP (x2, 1);
  operands[2] = x7;
  x8 = XEXP (x2, 2);
  operands[3] = x8;
  if (!register_operand (operands[3], E_QImode))
    return -1;
  switch (XWINT (x5, 0))
    {
    case 0L:
      if (XWINT (x6, 0) != 1L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DImode:
          if (!nonimmediate_operand (operands[0], E_V2DImode)
              || pattern1528 (x2, 
E_V2DImode, 
E_V4DImode) != 0
              || !
#line 12851 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5264; /* vec_extract_lo_v4di_mask */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[0], E_V2DFmode)
              || pattern1528 (x2, 
E_V2DFmode, 
E_V4DFmode) != 0
              || !
#line 12851 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5265; /* vec_extract_lo_v4df_mask */

        default:
          return -1;
        }

    case 2L:
      if (XWINT (x6, 0) != 3L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DImode:
          if (!nonimmediate_operand (operands[0], E_V2DImode)
              || pattern1528 (x2, 
E_V2DImode, 
E_V4DImode) != 0
              || !
#line 12888 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5268; /* vec_extract_hi_v4di_mask */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[0], E_V2DFmode)
              || pattern1528 (x2, 
E_V2DFmode, 
E_V4DFmode) != 0
              || !
#line 12888 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5269; /* vec_extract_hi_v4df_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_174 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 4);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  operands[6] = x5;
  res = recog_173 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (XWINT (x5, 0) != 4L)
    return -1;
  x6 = XVECEXP (x4, 0, 5);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x7 = XVECEXP (x4, 0, 6);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x8 = XVECEXP (x4, 0, 7);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || pattern1457 (x4) != 0
      || pattern751 (x2, 
E_V16HImode) != 0
      || pattern889 (x4) != 0)
    return -1;
  x9 = XVECEXP (x4, 0, 8);
  operands[6] = x9;
  if (!const_8_to_11_operand (operands[6], E_VOIDmode))
    return -1;
  x10 = XVECEXP (x4, 0, 9);
  operands[7] = x10;
  if (!const_8_to_11_operand (operands[7], E_VOIDmode))
    return -1;
  x11 = XVECEXP (x4, 0, 10);
  operands[8] = x11;
  if (!const_8_to_11_operand (operands[8], E_VOIDmode))
    return -1;
  x12 = XVECEXP (x4, 0, 11);
  operands[9] = x12;
  if (!const_8_to_11_operand (operands[9], E_VOIDmode))
    return -1;
  x13 = XEXP (x2, 1);
  operands[10] = x13;
  if (!nonimm_or_0_operand (operands[10], E_V16HImode))
    return -1;
  x14 = XEXP (x2, 2);
  operands[11] = x14;
  if (!register_operand (operands[11], E_HImode)
      || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 20768 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   && TARGET_AVX512BW && TARGET_AVX512VL
   && INTVAL (operands[2]) + 8 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 8 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 8 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 8 == INTVAL (operands[9]))))
    return -1;
  return 8373; /* avx2_pshuflw_1_mask */
}

 int
recog_179 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47, x48, x49;
  rtx x50, x51, x52, x53, x54, x55, x56, x57;
  rtx x58, x59, x60, x61;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x3, 0);
  switch (GET_CODE (x5))
    {
    case VEC_CONCAT:
      x6 = XEXP (x5, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
          return recog_165 (x1, insn, pnum_clobbers);

        case SS_TRUNCATE:
          x7 = XEXP (x5, 1);
          if (GET_CODE (x7) != SS_TRUNCATE)
            return -1;
          x8 = XEXP (x6, 0);
          operands[1] = x8;
          x9 = XEXP (x7, 0);
          operands[2] = x9;
          x10 = XEXP (x2, 1);
          operands[3] = x10;
          x11 = XEXP (x2, 2);
          operands[4] = x11;
          switch (XVECLEN (x4, 0))
            {
            case 32:
              if (pattern666 (x4, 
3, 
2, 
1) != 0
                  || pattern1285 (x4) != 0
                  || pattern1768 (x4, 
23, 
22, 
21, 
20) != 0)
                return -1;
              x12 = XVECEXP (x4, 0, 20);
              if (GET_CODE (x12) != CONST_INT)
                return -1;
              x13 = XVECEXP (x4, 0, 21);
              if (GET_CODE (x13) != CONST_INT)
                return -1;
              x14 = XVECEXP (x4, 0, 22);
              if (GET_CODE (x14) != CONST_INT)
                return -1;
              x15 = XVECEXP (x4, 0, 23);
              if (GET_CODE (x15) != CONST_INT)
                return -1;
              x16 = XVECEXP (x4, 0, 24);
              if (GET_CODE (x16) != CONST_INT)
                return -1;
              x17 = XVECEXP (x4, 0, 25);
              if (GET_CODE (x17) != CONST_INT)
                return -1;
              x18 = XVECEXP (x4, 0, 26);
              if (GET_CODE (x18) != CONST_INT)
                return -1;
              x19 = XVECEXP (x4, 0, 27);
              if (GET_CODE (x19) != CONST_INT
                  || pattern1863 (x4, 
31, 
30, 
29, 
28) != 0
                  || !register_operand (operands[4], E_SImode))
                return -1;
              x20 = XVECEXP (x4, 0, 4);
              switch (XWINT (x20, 0))
                {
                case 4L:
                  x21 = XVECEXP (x4, 0, 5);
                  if (XWINT (x21, 0) != 5L)
                    return -1;
                  x22 = XVECEXP (x4, 0, 6);
                  if (XWINT (x22, 0) != 6L)
                    return -1;
                  x23 = XVECEXP (x4, 0, 7);
                  if (XWINT (x23, 0) != 7L)
                    return -1;
                  x24 = XVECEXP (x4, 0, 8);
                  if (XWINT (x24, 0) != 16L)
                    return -1;
                  x25 = XVECEXP (x4, 0, 9);
                  if (XWINT (x25, 0) != 17L)
                    return -1;
                  x26 = XVECEXP (x4, 0, 10);
                  if (XWINT (x26, 0) != 18L)
                    return -1;
                  x27 = XVECEXP (x4, 0, 11);
                  if (XWINT (x27, 0) != 19L
                      || XWINT (x12, 0) != 12L
                      || XWINT (x13, 0) != 13L
                      || XWINT (x14, 0) != 14L
                      || XWINT (x15, 0) != 15L
                      || XWINT (x16, 0) != 24L
                      || XWINT (x17, 0) != 25L
                      || XWINT (x18, 0) != 26L
                      || XWINT (x19, 0) != 27L
                      || pattern1871 (x2, 
E_V32QImode, 
E_V16HImode, 
E_V16QImode) != 0
                      || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19232 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL && TARGET_AVX512BW)))
                    return -1;
                  return 8231; /* avx2_packsswb_mask */

                case 16L:
                  x21 = XVECEXP (x4, 0, 5);
                  if (XWINT (x21, 0) != 17L)
                    return -1;
                  x22 = XVECEXP (x4, 0, 6);
                  if (XWINT (x22, 0) != 18L)
                    return -1;
                  x23 = XVECEXP (x4, 0, 7);
                  if (XWINT (x23, 0) != 19L)
                    return -1;
                  x24 = XVECEXP (x4, 0, 8);
                  if (XWINT (x24, 0) != 4L)
                    return -1;
                  x25 = XVECEXP (x4, 0, 9);
                  if (XWINT (x25, 0) != 5L)
                    return -1;
                  x26 = XVECEXP (x4, 0, 10);
                  if (XWINT (x26, 0) != 6L)
                    return -1;
                  x27 = XVECEXP (x4, 0, 11);
                  if (XWINT (x27, 0) != 7L
                      || XWINT (x12, 0) != 24L
                      || XWINT (x13, 0) != 25L
                      || XWINT (x14, 0) != 26L
                      || XWINT (x15, 0) != 27L
                      || XWINT (x16, 0) != 12L
                      || XWINT (x17, 0) != 13L
                      || XWINT (x18, 0) != 14L
                      || XWINT (x19, 0) != 15L
                      || pattern1871 (x2, 
E_V32HImode, 
E_V16SImode, 
E_V16HImode) != 0
                      || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19348 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8239; /* avx512bw_packssdw_mask */

                default:
                  return -1;
                }

            case 64:
              if (pattern665 (x4) != 0
                  || pattern1287 (x4, 
35, 
34, 
33, 
32) != 0
                  || pattern1768 (x4, 
39, 
38, 
37, 
36) != 0)
                return -1;
              x12 = XVECEXP (x4, 0, 20);
              if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
                return -1;
              x13 = XVECEXP (x4, 0, 21);
              if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
                return -1;
              x14 = XVECEXP (x4, 0, 22);
              if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
                return -1;
              x15 = XVECEXP (x4, 0, 23);
              if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
                return -1;
              x16 = XVECEXP (x4, 0, 24);
              if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 40])
                return -1;
              x17 = XVECEXP (x4, 0, 25);
              if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 41])
                return -1;
              x18 = XVECEXP (x4, 0, 26);
              if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 42])
                return -1;
              x19 = XVECEXP (x4, 0, 27);
              if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 43]
                  || pattern1863 (x4, 
47, 
46, 
45, 
44) != 0)
                return -1;
              x28 = XVECEXP (x4, 0, 32);
              if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 16])
                return -1;
              x29 = XVECEXP (x4, 0, 33);
              if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 17])
                return -1;
              x30 = XVECEXP (x4, 0, 34);
              if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 18])
                return -1;
              x31 = XVECEXP (x4, 0, 35);
              if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 19])
                return -1;
              x32 = XVECEXP (x4, 0, 36);
              if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 20])
                return -1;
              x33 = XVECEXP (x4, 0, 37);
              if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 21])
                return -1;
              x34 = XVECEXP (x4, 0, 38);
              if (x34 != const_int_rtx[MAX_SAVED_CONST_INT + 22])
                return -1;
              x35 = XVECEXP (x4, 0, 39);
              if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 23])
                return -1;
              x36 = XVECEXP (x4, 0, 40);
              if (x36 != const_int_rtx[MAX_SAVED_CONST_INT + 48])
                return -1;
              x37 = XVECEXP (x4, 0, 41);
              if (x37 != const_int_rtx[MAX_SAVED_CONST_INT + 49])
                return -1;
              x38 = XVECEXP (x4, 0, 42);
              if (x38 != const_int_rtx[MAX_SAVED_CONST_INT + 50])
                return -1;
              x39 = XVECEXP (x4, 0, 43);
              if (x39 != const_int_rtx[MAX_SAVED_CONST_INT + 51])
                return -1;
              x40 = XVECEXP (x4, 0, 44);
              if (x40 != const_int_rtx[MAX_SAVED_CONST_INT + 52])
                return -1;
              x41 = XVECEXP (x4, 0, 45);
              if (x41 != const_int_rtx[MAX_SAVED_CONST_INT + 53])
                return -1;
              x42 = XVECEXP (x4, 0, 46);
              if (x42 != const_int_rtx[MAX_SAVED_CONST_INT + 54])
                return -1;
              x43 = XVECEXP (x4, 0, 47);
              if (x43 != const_int_rtx[MAX_SAVED_CONST_INT + 55])
                return -1;
              x44 = XVECEXP (x4, 0, 48);
              if (x44 != const_int_rtx[MAX_SAVED_CONST_INT + 24])
                return -1;
              x45 = XVECEXP (x4, 0, 49);
              if (x45 != const_int_rtx[MAX_SAVED_CONST_INT + 25])
                return -1;
              x46 = XVECEXP (x4, 0, 50);
              if (x46 != const_int_rtx[MAX_SAVED_CONST_INT + 26])
                return -1;
              x47 = XVECEXP (x4, 0, 51);
              if (x47 != const_int_rtx[MAX_SAVED_CONST_INT + 27])
                return -1;
              x48 = XVECEXP (x4, 0, 52);
              if (x48 != const_int_rtx[MAX_SAVED_CONST_INT + 28])
                return -1;
              x49 = XVECEXP (x4, 0, 53);
              if (x49 != const_int_rtx[MAX_SAVED_CONST_INT + 29])
                return -1;
              x50 = XVECEXP (x4, 0, 54);
              if (x50 != const_int_rtx[MAX_SAVED_CONST_INT + 30])
                return -1;
              x51 = XVECEXP (x4, 0, 55);
              if (x51 != const_int_rtx[MAX_SAVED_CONST_INT + 31])
                return -1;
              x52 = XVECEXP (x4, 0, 56);
              if (x52 != const_int_rtx[MAX_SAVED_CONST_INT + 56])
                return -1;
              x53 = XVECEXP (x4, 0, 57);
              if (x53 != const_int_rtx[MAX_SAVED_CONST_INT + 57])
                return -1;
              x54 = XVECEXP (x4, 0, 58);
              if (x54 != const_int_rtx[MAX_SAVED_CONST_INT + 58])
                return -1;
              x55 = XVECEXP (x4, 0, 59);
              if (x55 != const_int_rtx[MAX_SAVED_CONST_INT + 59])
                return -1;
              x56 = XVECEXP (x4, 0, 60);
              if (x56 != const_int_rtx[MAX_SAVED_CONST_INT + 60])
                return -1;
              x57 = XVECEXP (x4, 0, 61);
              if (x57 != const_int_rtx[MAX_SAVED_CONST_INT + 61])
                return -1;
              x58 = XVECEXP (x4, 0, 62);
              if (x58 != const_int_rtx[MAX_SAVED_CONST_INT + 62])
                return -1;
              x59 = XVECEXP (x4, 0, 63);
              if (x59 != const_int_rtx[MAX_SAVED_CONST_INT + 63]
                  || pattern1812 (x2, 
E_DImode, 
E_V64QImode, 
E_V32HImode, 
E_V32QImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19279 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 8233; /* avx512bw_packsswb_mask */

            case 16:
              if (pattern785 (x4, 
10, 
9, 
8) != 0
                  || pattern1465 (x4, 
7, 
6, 
5, 
4, 
11) != 0
                  || pattern1812 (x2, 
E_HImode, 
E_V16HImode, 
E_V8SImode, 
E_V8HImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL && TARGET_AVX512BW)))
                return -1;
              return 8237; /* avx2_packssdw_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x5;
      switch (XVECLEN (x4, 0))
        {
        case 2:
          res = recog_166 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case 4:
          res = recog_168 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case 8:
          res = recog_172 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case 16:
          res = recog_175 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        default:
          break;
        }
      if (XVECLEN (x4, 0) >= 1)
        {
          operands[2] = x4;
          x60 = XVECEXP (x4, 0, 0);
          operands[3] = x60;
          if (const_int_operand (operands[3], E_VOIDmode))
            {
              x10 = XEXP (x2, 1);
              operands[4] = x10;
              x11 = XEXP (x2, 2);
              operands[5] = x11;
              switch (GET_MODE (operands[0]))
                {
                case E_V16SFmode:
                  if (pattern1381 (x2, 
E_V16SFmode, 
E_HImode) == 0
                      && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (64 == 64 || TARGET_AVX512VL)
   && avx_vpermilp_parallel (operands[2], V16SFmode)) && 
#line 374 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                    return 9085; /* *avx512f_vpermilpv16sf_mask */
                  break;

                case E_V8SFmode:
                  if (pattern1381 (x2, 
E_V8SFmode, 
E_QImode) == 0
                      && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (32 == 64 || TARGET_AVX512VL)
   && avx_vpermilp_parallel (operands[2], V8SFmode)) && 
#line 374 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
                    return 9087; /* *avx_vpermilpv8sf_mask */
                  break;

                case E_V4SFmode:
                  if (pattern1381 (x2, 
E_V4SFmode, 
E_QImode) == 0
                      && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 27501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (16 == 64 || TARGET_AVX512VL)
   && avx_vpermilp_parallel (operands[2], V4SFmode))))
                    return 9089; /* *avx_vpermilpv4sf_mask */
                  break;

                case E_V8DFmode:
                  if (pattern1381 (x2, 
E_V8DFmode, 
E_QImode) == 0
                      && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (64 == 64 || TARGET_AVX512VL)
   && avx_vpermilp_parallel (operands[2], V8DFmode)) && 
#line 375 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                    return 9091; /* *avx512f_vpermilpv8df_mask */
                  break;

                case E_V4DFmode:
                  if (pattern1381 (x2, 
E_V4DFmode, 
E_QImode) == 0
                      && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (32 == 64 || TARGET_AVX512VL)
   && avx_vpermilp_parallel (operands[2], V4DFmode)) && 
#line 375 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
                    return 9093; /* *avx_vpermilpv4df_mask */
                  break;

                case E_V2DFmode:
                  if (pattern1381 (x2, 
E_V2DFmode, 
E_QImode) == 0
                      && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (16 == 64 || TARGET_AVX512VL)
   && avx_vpermilp_parallel (operands[2], V2DFmode)) && 
#line 376 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                    return 9095; /* *avx_vpermilpv2df_mask */
                  break;

                default:
                  break;
                }
            }
        }
      x11 = XEXP (x2, 2);
      if (!register_operand (x11, E_QImode))
        return -1;
      switch (XVECLEN (x4, 0))
        {
        case 4:
          if (pattern890 (x2, 
E_V4DFmode) != 0)
            return -1;
          x10 = XEXP (x2, 1);
          operands[6] = x10;
          if (!nonimm_or_0_operand (operands[6], E_V4DFmode))
            return -1;
          operands[7] = x11;
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 27555 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
            return -1;
          return 9099; /* avx2_permv4df_1_mask */

        case 8:
          if (pattern890 (x2, 
E_V8DFmode) != 0)
            return -1;
          x20 = XVECEXP (x4, 0, 4);
          operands[6] = x20;
          if (!const_4_to_7_operand (operands[6], E_VOIDmode))
            return -1;
          x21 = XVECEXP (x4, 0, 5);
          operands[7] = x21;
          if (!const_4_to_7_operand (operands[7], E_VOIDmode))
            return -1;
          x22 = XVECEXP (x4, 0, 6);
          operands[8] = x22;
          if (!const_4_to_7_operand (operands[8], E_VOIDmode))
            return -1;
          x23 = XVECEXP (x4, 0, 7);
          operands[9] = x23;
          if (!const_4_to_7_operand (operands[9], E_VOIDmode))
            return -1;
          x10 = XEXP (x2, 1);
          operands[10] = x10;
          if (!nonimm_or_0_operand (operands[10], E_V8DFmode))
            return -1;
          operands[11] = x11;
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL)
   && (INTVAL (operands[2]) == (INTVAL (operands[6]) - 4)
       && INTVAL (operands[3]) == (INTVAL (operands[7]) - 4)
       && INTVAL (operands[4]) == (INTVAL (operands[8]) - 4)
       && INTVAL (operands[5]) == (INTVAL (operands[9]) - 4))) && 
#line 717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 9101; /* avx512f_permv8df_1_mask */

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x5, 0) != 1
          || XINT (x5, 1) != 149
          || GET_MODE (x5) != E_V8SFmode
          || XVECLEN (x4, 0) != 4
          || pattern666 (x4, 
3, 
2, 
1) != 0
          || !register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x2) != E_V4SFmode
          || GET_MODE (x3) != E_V4SFmode)
        return -1;
      x61 = XVECEXP (x5, 0, 0);
      operands[1] = x61;
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      x10 = XEXP (x2, 1);
      operands[2] = x10;
      if (!nonimm_or_0_operand (operands[2], E_V4SFmode))
        return -1;
      x11 = XEXP (x2, 2);
      operands[3] = x11;
      if (!register_operand (operands[3], E_QImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29080 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL)))
        return -1;
      return 9574; /* vcvtph2ps_mask */

    default:
      return -1;
    }
}

 int
recog_192 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern151 (x2))
    {
    case 0:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24121 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512BW && TARGET_AVX512VL)))
        return -1;
      return 8683; /* avx2_zero_extendv16qiv16hi2_mask */

    case 1:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
        return -1;
      return 8691; /* avx512bw_zero_extendv32qiv32hi2_mask */

    case 2:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24245 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512BW && TARGET_AVX512VL)))
        return -1;
      return 8703; /* *sse4_1_zero_extendv8qiv8hi2_mask_1 */

    case 3:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24370 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8715; /* avx512f_zero_extendv16qiv16si2_mask */

    case 4:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24513 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8743; /* avx512f_zero_extendv16hiv16si2_mask */

    case 5:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24402 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8723; /* *avx2_zero_extendv8qiv8si2_mask_1 */

    case 6:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24566 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8751; /* avx2_zero_extendv8hiv8si2_mask */

    case 7:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24463 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8735; /* *sse4_1_zero_extendv4qiv4si2_mask_1 */

    case 8:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24636 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8763; /* *sse4_1_zero_extendv4hiv4si2_mask_1 */

    case 9:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24767 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8779; /* *avx512f_zero_extendv8qiv8di2_mask_1 */

    case 10:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8810; /* avx512f_zero_extendv8hiv8di2_mask */

    case 11:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25075 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8838; /* avx512f_zero_extendv8siv8di2_mask */

    case 12:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24825 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8791; /* *avx2_zero_extendv4qiv4di2_mask_1 */

    case 13:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24968 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8818; /* *avx2_zero_extendv4hiv4di2_mask_1 */

    case 14:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25126 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8844; /* avx2_zero_extendv4siv4di2_mask */

    case 15:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24887 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8803; /* *sse4_1_zero_extendv2qiv2di2_mask_1 */

    case 16:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25026 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8830; /* *sse4_1_zero_extendv2hiv2di2_mask_1 */

    case 17:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25192 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8854; /* *sse4_1_zero_extendv2siv2di2_mask_1 */

    case 18:
      x3 = XEXP (x2, 0);
      x4 = XEXP (x3, 0);
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern892 (x2))
        {
        case 0:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24233 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512BW && TARGET_AVX512VL)))
            return 8699; /* sse4_1_zero_extendv8qiv8hi2_mask */
          break;

        case 1:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24391 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
            return 8719; /* avx2_zero_extendv8qiv8si2_mask */
          break;

        case 2:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return 8775; /* avx512f_zero_extendv8qiv8di2_mask */
          break;

        case 3:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24451 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8731; /* sse4_1_zero_extendv4qiv4si2_mask */
          break;

        case 4:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24624 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8759; /* sse4_1_zero_extendv4hiv4si2_mask */
          break;

        case 5:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24814 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
            return 8787; /* avx2_zero_extendv4qiv4di2_mask */
          break;

        case 6:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24957 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
            return 8814; /* avx2_zero_extendv4hiv4di2_mask */
          break;

        case 7:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24875 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8799; /* sse4_1_zero_extendv2qiv2di2_mask */
          break;

        case 8:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25014 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8826; /* sse4_1_zero_extendv2hiv2di2_mask */
          break;

        case 9:
          if ((
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25180 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8850; /* sse4_1_zero_extendv2siv2di2_mask */
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG)
        return -1;
      switch (pattern895 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24269 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512BW && TARGET_AVX512VL
   && ix86_pre_reload_split ())))
            return -1;
          return 8707; /* *sse4_1_zero_extendv8qiv8hi2_mask_2 */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL
   && ix86_pre_reload_split ())))
            return -1;
          return 8727; /* *avx2_zero_extendv8qiv8si2_mask_2 */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24785 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512 && ix86_pre_reload_split ())))
            return -1;
          return 8783; /* *avx512f_zero_extendv8qiv8di2_mask_2 */

        case 3:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24655 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ())))
            return -1;
          return 8767; /* *sse4_1_zero_extendv4hiv4si2_mask_2 */

        case 4:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24985 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL
   && ix86_pre_reload_split ())))
            return -1;
          return 8822; /* *avx2_zero_extendv4hiv4di2_mask_2 */

        case 5:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ())))
            return -1;
          return 8858; /* *sse4_1_zero_extendv2siv2di2_mask_2 */

        case 6:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24486 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ())))
            return -1;
          return 8739; /* *sse4_1_zero_extendv4qiv4si2_mask_2 */

        case 7:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24846 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL
   && ix86_pre_reload_split ())))
            return -1;
          return 8795; /* *avx2_zero_extendv4qiv4di2_mask_2 */

        case 8:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25048 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ())))
            return -1;
          return 8834; /* *sse4_1_zero_extendv2hiv2di2_mask_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_202 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 2);
  switch (GET_CODE (x6))
    {
    case CONST_INT:
      switch (pattern132 (x2))
        {
        case 0:
          if (!(
#line 2804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2831; /* avx512fp16_vmdivv8hf3 */

        case 1:
          if (!
#line 2804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 2839; /* sse_vmdivv4sf3 */

        case 2:
          if (!(
#line 2804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2847; /* sse2_vmdivv2df3 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      operands[4] = x6;
      x7 = XEXP (x2, 1);
      operands[3] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern998 (x2, 
E_V32HFmode, 
E_SImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
            return -1;
          return 2853; /* avx512fp16_divv32hf3_mask */

        case E_V16HFmode:
          if (pattern998 (x2, 
E_V16HFmode, 
E_HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 390 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 2856; /* avx512fp16_divv16hf3_mask */

        case E_V8HFmode:
          if (pattern998 (x2, 
E_V8HFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 391 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 2858; /* avx512fp16_divv8hf3_mask */

        case E_V16SFmode:
          if (pattern998 (x2, 
E_V16SFmode, 
E_HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 2861; /* avx512f_divv16sf3_mask */

        case E_V8SFmode:
          if (pattern998 (x2, 
E_V8SFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 2864; /* avx_divv8sf3_mask */

        case E_V4SFmode:
          if (pattern998 (x2, 
E_V4SFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL) && 1)))
            return -1;
          return 2866; /* sse_divv4sf3_mask */

        case E_V8DFmode:
          if (pattern998 (x2, 
E_V8DFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 2869; /* avx512f_divv8df3_mask */

        case E_V4DFmode:
          if (pattern998 (x2, 
E_V4DFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 2872; /* avx_divv4df3_mask */

        case E_V2DFmode:
          if (pattern998 (x2, 
E_V2DFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 394 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2874; /* sse2_divv2df3_mask */

        case E_V32BFmode:
          if (pattern130 (x2, 
E_V32BFmode, 
E_SImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32131 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10537; /* avx10_2_divbf16_v32bf_mask */

        case E_V16BFmode:
          if (pattern130 (x2, 
E_V16BFmode, 
E_HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32131 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10545; /* avx10_2_divbf16_v16bf_mask */

        case E_V8BFmode:
          if (pattern130 (x2, 
E_V8BFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32131 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10553; /* avx10_2_divbf16_v8bf_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_210 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x2) != E_V8HImode
          || !vector_operand (operands[1], E_V8HFmode)
          || !(
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4494; /* unspec_avx512fp16_fix_truncv8hi2 */

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x2) != E_V16HImode
          || !vector_operand (operands[1], E_V16HFmode)
          || !(
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4502; /* unspec_avx512fp16_fix_truncv16hi2 */

    case E_V32HImode:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x2) != E_V32HImode
          || !vector_operand (operands[1], E_V32HFmode)
          || !(
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4510; /* unspec_avx512fp16_fix_truncv32hi2 */

    case E_V8SImode:
      switch (pattern636 (x2, 
E_V8SImode))
        {
        case 0:
          if (!(
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4518; /* unspec_avx512fp16_fix_truncv8si2 */

        case 1:
          if (!
#line 8774 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
            return -1;
          return 4816; /* unspec_fix_truncv8sfv8si2 */

        case 2:
          if (!
#line 9547 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 4949; /* unspec_fix_truncv8dfv8si2 */

        default:
          return -1;
        }

    case E_V16SImode:
      switch (pattern637 (x2, 
E_V16SImode))
        {
        case 0:
          if (!(
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4526; /* unspec_avx512fp16_fix_truncv16si2 */

        case 1:
          if (!
#line 8754 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 4800; /* unspec_fix_truncv16sfv16si2 */

        default:
          return -1;
        }

    case E_V8DImode:
      switch (pattern638 (x2))
        {
        case 0:
          if (!(
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4534; /* unspec_avx512fp16_fix_truncv8di2 */

        case 1:
          if (!(
#line 9676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4978; /* unspec_fix_truncv8dfv8di2 */

        case 2:
          if (!(
#line 9719 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5026; /* unspec_fix_truncv8sfv8di2 */

        default:
          return -1;
        }

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x2) != E_V4SImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!register_operand (operands[1], E_V8HFmode)
              || !
#line 7897 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4590; /* unspec_avx512fp16_fix_truncv4si2 */

        case E_V4SFmode:
          if (!vector_operand (operands[1], E_V4SFmode)
              || !
#line 8793 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1))
            return -1;
          return 4820; /* unspec_fix_truncv4sfv4si2 */

        case E_V4DFmode:
          if (!nonimmediate_operand (operands[1], E_V4DFmode)
              || !
#line 9637 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX || (TARGET_AVX512VL && TARGET_AVX512F)))
            return -1;
          return 4970; /* unspec_fix_truncv4dfv4si2 */

        case E_V2DFmode:
          if (!vector_operand (operands[1], E_V2DFmode)
              || !
#line 9919 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1))
            return -1;
          return 5066; /* unspec_sse2_cvttpd2dq */

        default:
          return -1;
        }

    case E_V4DImode:
      switch (pattern639 (x2))
        {
        case 0:
          if (!
#line 7897 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4594; /* unspec_avx512fp16_fix_truncv4di2 */

        case 1:
          if (!(
#line 9676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4986; /* unspec_fix_truncv4dfv4di2 */

        case 2:
          if (!(
#line 9719 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 5034; /* unspec_fix_truncv4sfv4di2 */

        default:
          return -1;
        }

    case E_V2DImode:
      switch (pattern640 (x2))
        {
        case 0:
          if (!
#line 7947 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4614; /* unspec_avx512fp16_fix_truncv2di2 */

        case 1:
          if (!(
#line 9676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4990; /* unspec_fix_truncv2dfv2di2 */

        case 2:
          if (!
#line 9740 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
            return -1;
          return 5050; /* unspec_avx512dq_fix_truncv2sfv2di2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_224 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x5 = XEXP (x3, 0);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case SQRT:
      x7 = XEXP (x6, 0);
      operands[1] = x7;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      x9 = XVECEXP (x2, 0, 1);
      operands[3] = x9;
      if (!const_4_or_8_to_11_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          if (pattern1390 (x2, 
E_V8HFmode, 
E_HFmode) != 0
              || !(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3105 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 2941; /* *avx512fp16_vmsqrtv8hf2_round */

        case E_V4SFmode:
          if (pattern1390 (x2, 
E_V4SFmode, 
E_SFmode) != 0
              || !(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3105 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 2945; /* *sse_vmsqrtv4sf2_round */

        case E_V2DFmode:
          if (pattern1390 (x2, 
E_V2DFmode, 
E_DFmode) != 0
              || !(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3105 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2949; /* *sse2_vmsqrtv2df2_round */

        default:
          return -1;
        }

    case FLOAT:
      switch (pattern898 (x2))
        {
        case 0:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7842 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4487; /* avx512fp16_vcvtsi2sh_round */

        case 1:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7842 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return -1;
          return 4491; /* avx512fp16_vcvtsi2shq_round */

        case 2:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 4720; /* sse_cvtsi2ss_round */

        case 3:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return -1;
          return 4722; /* sse_cvtsi2ssq_round */

        case 4:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT)))
            return -1;
          return 4833; /* sse2_cvtsi2sdq_round */

        default:
          return -1;
        }

    case UNSIGNED_FLOAT:
      switch (pattern898 (x2))
        {
        case 0:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7842 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4489; /* avx512fp16_vcvtusi2sh_round */

        case 1:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7842 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return -1;
          return 4493; /* avx512fp16_vcvtusi2shq_round */

        case 2:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8604 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (V4SFmode == V4SFmode))))
            return -1;
          return 4738; /* cvtusi2ss32_round */

        case 3:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8618 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_64BIT)))
            return -1;
          return 4741; /* cvtusi2ss64_round */

        case 4:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8618 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_64BIT) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 4743; /* cvtusi2sd64_round */

        default:
          return -1;
        }

    case FLOAT_EXTEND:
      x7 = XEXP (x6, 0);
      if (pattern896 (x7, 
1, 
E_HFmode) != 0)
        return -1;
      x10 = XEXP (x7, 0);
      operands[1] = x10;
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      x9 = XVECEXP (x2, 0, 1);
      operands[3] = x9;
      if (!const48_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DFmode:
          if (pattern1653 (x2, 
E_V2DFmode, 
E_DFmode) != 0
              || !(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8289 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4693; /* avx512fp16_vcvtsh2sd_round */

        case E_V4SFmode:
          if (pattern1653 (x2, 
E_V4SFmode, 
E_SFmode) != 0
              || !(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8289 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4697; /* avx512fp16_vcvtsh2ss_round */

        default:
          return -1;
        }

    case FLOAT_TRUNCATE:
      x9 = XVECEXP (x2, 0, 1);
      operands[3] = x9;
      if (!const_4_or_8_to_11_operand (operands[3], E_SImode))
        return -1;
      x7 = XEXP (x6, 0);
      switch (GET_CODE (x7))
        {
        case VEC_SELECT:
          x11 = XEXP (x7, 1);
          if (GET_CODE (x11) != PARALLEL
              || XVECLEN (x11, 0) != 1)
            return -1;
          x12 = XVECEXP (x11, 0, 0);
          if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || pattern1391 (x2, 
E_HFmode, 
E_V8HFmode) != 0)
            return -1;
          x10 = XEXP (x7, 0);
          operands[1] = x10;
          x8 = XEXP (x3, 1);
          operands[2] = x8;
          if (!register_operand (operands[2], E_V8HFmode))
            return -1;
          switch (GET_MODE (x7))
            {
            case E_DFmode:
              if (!register_operand (operands[1], E_V2DFmode)
                  || !(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8319 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4704; /* avx512fp16_vcvtsd2sh_round */

            case E_SFmode:
              if (!register_operand (operands[1], E_V4SFmode)
                  || !(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8319 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4708; /* avx512fp16_vcvtss2sh_round */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[2] = x7;
          if (!nonimmediate_operand (operands[2], E_V2DFmode)
              || pattern1391 (x2, 
E_V2SFmode, 
E_V4SFmode) != 0)
            return -1;
          x8 = XEXP (x3, 1);
          operands[1] = x8;
          if (!register_operand (operands[1], E_V4SFmode)
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9990 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 5072; /* sse2_cvtsd2ss_round */

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x6, 0) != 2
          || XINT (x6, 1) != 94)
        return -1;
      x13 = XVECEXP (x6, 0, 0);
      operands[2] = x13;
      x14 = XVECEXP (x6, 0, 1);
      operands[3] = x14;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      x8 = XEXP (x3, 1);
      operands[1] = x8;
      x9 = XVECEXP (x2, 0, 1);
      operands[4] = x9;
      if (!const48_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          if (pattern1566 (x2, 
E_V8HFmode, 
E_HFmode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14241 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 7111; /* *avx512f_rndscalev8hf_round */

        case E_V4SFmode:
          if (pattern1566 (x2, 
E_V4SFmode, 
E_SFmode) != 0
              || !
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
            return -1;
          return 7113; /* *avx512f_rndscalev4sf_round */

        case E_V2DFmode:
          if (pattern1566 (x2, 
E_V2DFmode, 
E_DFmode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14241 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 7115; /* *avx512f_rndscalev2df_round */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_226 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      switch (pattern644 (x2))
        {
        case 0:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V32HFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 2686; /* *addv32hf3_mask_round */

        case 1:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V16HFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && (V16HFmode == V16SFmode
							      || V16HFmode == V8DFmode
							      || V16HFmode == V8DImode
							      || V16HFmode == V16SImode
							      || V16HFmode == V32HFmode)) && 
#line 390 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 2694; /* *addv16hf3_mask_round */

        case 2:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V8HFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && (V8HFmode == V16SFmode
							      || V8HFmode == V8DFmode
							      || V8HFmode == V8DImode
							      || V8HFmode == V16SImode
							      || V8HFmode == V32HFmode)) && 
#line 391 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 2702; /* *addv8hf3_mask_round */

        case 3:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V16SFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 2710; /* *addv16sf3_mask_round */

        case 4:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V8SFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && (V8SFmode == V16SFmode
							      || V8SFmode == V8DFmode
							      || V8SFmode == V8DImode
							      || V8SFmode == V16SImode
							      || V8SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))))
            return -1;
          return 2718; /* *addv8sf3_mask_round */

        case 5:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V4SFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && (V4SFmode == V16SFmode
							      || V4SFmode == V8DFmode
							      || V4SFmode == V8DImode
							      || V4SFmode == V16SImode
							      || V4SFmode == V32HFmode)))))
            return -1;
          return 2726; /* *addv4sf3_mask_round */

        case 6:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V8DFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 2734; /* *addv8df3_mask_round */

        case 7:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V4DFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && (V4DFmode == V16SFmode
							      || V4DFmode == V8DFmode
							      || V4DFmode == V8DImode
							      || V4DFmode == V16SImode
							      || V4DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))))
            return -1;
          return 2742; /* *addv4df3_mask_round */

        case 8:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (PLUS, V2DFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && (V2DFmode == V16SFmode
							      || V2DFmode == V8DFmode
							      || V2DFmode == V8DImode
							      || V2DFmode == V16SImode
							      || V2DFmode == V32HFmode)) && 
#line 394 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 2750; /* *addv2df3_mask_round */

        case 9:
          if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 2762; /* avx512fp16_vmaddv8hf3_round */

        case 10:
          if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2713 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 2770; /* sse_vmaddv4sf3_round */

        case 11:
          if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2778; /* sse2_vmaddv2df3_round */

        default:
          return -1;
        }

    case MINUS:
      switch (pattern644 (x2))
        {
        case 0:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V32HFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 2690; /* *subv32hf3_mask_round */

        case 1:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V16HFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && (V16HFmode == V16SFmode
							      || V16HFmode == V8DFmode
							      || V16HFmode == V8DImode
							      || V16HFmode == V16SImode
							      || V16HFmode == V32HFmode)) && 
#line 390 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 2698; /* *subv16hf3_mask_round */

        case 2:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V8HFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && (V8HFmode == V16SFmode
							      || V8HFmode == V8DFmode
							      || V8HFmode == V8DImode
							      || V8HFmode == V16SImode
							      || V8HFmode == V32HFmode)) && 
#line 391 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 2706; /* *subv8hf3_mask_round */

        case 3:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V16SFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 2714; /* *subv16sf3_mask_round */

        case 4:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V8SFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && (V8SFmode == V16SFmode
							      || V8SFmode == V8DFmode
							      || V8SFmode == V8DImode
							      || V8SFmode == V16SImode
							      || V8SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))))
            return -1;
          return 2722; /* *subv8sf3_mask_round */

        case 5:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V4SFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && (V4SFmode == V16SFmode
							      || V4SFmode == V8DFmode
							      || V4SFmode == V8DImode
							      || V4SFmode == V16SImode
							      || V4SFmode == V32HFmode)))))
            return -1;
          return 2730; /* *subv4sf3_mask_round */

        case 6:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V8DFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 2738; /* *subv8df3_mask_round */

        case 7:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V4DFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && (V4DFmode == V16SFmode
							      || V4DFmode == V8DFmode
							      || V4DFmode == V8DImode
							      || V4DFmode == V16SImode
							      || V4DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))))
            return -1;
          return 2746; /* *subv4df3_mask_round */

        case 8:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V2DFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && (V2DFmode == V16SFmode
							      || V2DFmode == V8DFmode
							      || V2DFmode == V8DImode
							      || V2DFmode == V16SImode
							      || V2DFmode == V32HFmode)) && 
#line 394 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 2754; /* *subv2df3_mask_round */

        case 9:
          if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 2766; /* avx512fp16_vmsubv8hf3_round */

        case 10:
          if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2713 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 2774; /* sse_vmsubv4sf3_round */

        case 11:
          if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2782; /* sse2_vmsubv2df3_round */

        default:
          return -1;
        }

    case VEC_MERGE:
      return recog_221 (x1, insn, pnum_clobbers);

    case MULT:
      switch (pattern644 (x2))
        {
        case 0:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2753 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MULT, V32HFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 2788; /* *mulv32hf3_mask_round */

        case 1:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2753 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MULT, V16HFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && (V16HFmode == V16SFmode
							      || V16HFmode == V8DFmode
							      || V16HFmode == V8DImode
							      || V16HFmode == V16SImode
							      || V16HFmode == V32HFmode)) && 
#line 390 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 2792; /* *mulv16hf3_mask_round */

        case 2:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2753 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MULT, V8HFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && (V8HFmode == V16SFmode
							      || V8HFmode == V8DFmode
							      || V8HFmode == V8DImode
							      || V8HFmode == V16SImode
							      || V8HFmode == V32HFmode)) && 
#line 391 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 2796; /* *mulv8hf3_mask_round */

        case 3:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2753 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MULT, V16SFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 2800; /* *mulv16sf3_mask_round */

        case 4:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2753 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MULT, V8SFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && (V8SFmode == V16SFmode
							      || V8SFmode == V8DFmode
							      || V8SFmode == V8DImode
							      || V8SFmode == V16SImode
							      || V8SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))))
            return -1;
          return 2804; /* *mulv8sf3_mask_round */

        case 5:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2753 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MULT, V4SFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && (V4SFmode == V16SFmode
							      || V4SFmode == V8DFmode
							      || V4SFmode == V8DImode
							      || V4SFmode == V16SImode
							      || V4SFmode == V32HFmode)))))
            return -1;
          return 2808; /* *mulv4sf3_mask_round */

        case 6:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2753 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MULT, V8DFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 2812; /* *mulv8df3_mask_round */

        case 7:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2753 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MULT, V4DFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && (V4DFmode == V16SFmode
							      || V4DFmode == V8DFmode
							      || V4DFmode == V8DImode
							      || V4DFmode == V16SImode
							      || V4DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))))
            return -1;
          return 2816; /* *mulv4df3_mask_round */

        case 8:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2753 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MULT, V2DFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && (V2DFmode == V16SFmode
							      || V2DFmode == V8DFmode
							      || V2DFmode == V8DImode
							      || V2DFmode == V16SImode
							      || V2DFmode == V32HFmode)) && 
#line 394 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 2820; /* *mulv2df3_mask_round */

        case 9:
          if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 2828; /* avx512fp16_vmmulv8hf3_round */

        case 10:
          if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 2836; /* sse_vmmulv4sf3_round */

        case 11:
          if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2844; /* sse2_vmmulv2df3_round */

        default:
          return -1;
        }

    case DIV:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      x7 = XVECEXP (x2, 0, 1);
      if (!const_4_or_8_to_11_operand (x7, E_SImode))
        return -1;
      x8 = XEXP (x3, 2);
      switch (GET_CODE (x8))
        {
        case CONST_INT:
          switch (pattern643 (x2))
            {
            case 0:
              if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 2832; /* avx512fp16_vmdivv8hf3_round */

            case 1:
              if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
                return -1;
              return 2840; /* sse_vmdivv4sf3_round */

            case 2:
              if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 2848; /* sse2_vmdivv2df3_round */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          switch (pattern645 (x2))
            {
            case 0:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
                return -1;
              return 2854; /* avx512fp16_divv32hf3_mask_round */

            case 1:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
                return -1;
              return 2862; /* avx512f_divv16sf3_mask_round */

            case 2:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
                return -1;
              return 2870; /* avx512f_divv8df3_mask_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SQRT:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x9 = XEXP (x3, 1);
      operands[2] = x9;
      x7 = XVECEXP (x2, 0, 1);
      if (!const_4_or_8_to_11_operand (x7, E_SImode))
        return -1;
      x8 = XEXP (x3, 2);
      switch (GET_CODE (x8))
        {
        case REG:
        case SUBREG:
          operands[3] = x8;
          operands[4] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1388 (x2, 
E_SImode, 
E_V32HFmode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
                return -1;
              return 2907; /* avx512fp16_sqrtv32hf2_mask_round */

            case E_V16SFmode:
              if (pattern1388 (x2, 
E_HImode, 
E_V16SFmode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
                return -1;
              return 2915; /* avx512f_sqrtv16sf2_mask_round */

            case E_V8DFmode:
              if (pattern1388 (x2, 
E_QImode, 
E_V8DFmode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL) && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
                return -1;
              return 2923; /* avx512f_sqrtv8df2_mask_round */

            default:
              return -1;
            }

        case CONST_INT:
          if (XWINT (x8, 0) != 1L)
            return -1;
          operands[3] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern1389 (x2, 
E_V8HFmode) != 0
                  || !(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3086 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 2929; /* avx512fp16_vmsqrtv8hf2_round */

            case E_V4SFmode:
              if (pattern1389 (x2, 
E_V4SFmode) != 0
                  || !(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3086 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
                return -1;
              return 2933; /* sse_vmsqrtv4sf2_round */

            case E_V2DFmode:
              if (pattern1389 (x2, 
E_V2DFmode) != 0
                  || !(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3086 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 2937; /* sse2_vmsqrtv2df2_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_DUPLICATE:
      return recog_224 (x1, insn, pnum_clobbers);

    case SMAX:
      switch (pattern646 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 2985; /* *smaxv32hf3_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 3001; /* *smaxv16sf3_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 3017; /* *smaxv8df3_mask_round */

        case 3:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 3099; /* *avx512fp16_vmsmaxv8hf3_round */

        case 4:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 3107; /* *sse_vmsmaxv4sf3_round */

        case 5:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 3115; /* *sse2_vmsmaxv2df3_round */

        default:
          return -1;
        }

    case SMIN:
      switch (pattern646 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 2989; /* *sminv32hf3_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 3005; /* *sminv16sf3_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 3021; /* *sminv8df3_mask_round */

        case 3:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 3103; /* *avx512fp16_vmsminv8hf3_round */

        case 4:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 3111; /* *sse_vmsminv4sf3_round */

        case 5:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 3119; /* *sse2_vmsminv2df3_round */

        default:
          return -1;
        }

    case UNSPEC:
      return recog_223 (x1, insn, pnum_clobbers);

    case FMA:
      return recog_222 (x1, insn, pnum_clobbers);

    case FLOAT:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x9 = XEXP (x3, 1);
      operands[2] = x9;
      x8 = XEXP (x3, 2);
      operands[3] = x8;
      x7 = XVECEXP (x2, 0, 1);
      operands[4] = x7;
      if (!const_4_or_8_to_11_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          switch (pattern1295 (x2))
            {
            case 0:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4411; /* avx512fp16_vcvtw2ph_v8hi_mask_round */

            case 1:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4435; /* avx512fp16_vcvtdq2ph_v8si_mask_round */

            case 2:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4451; /* avx512fp16_vcvtqq2ph_v8di_mask_round */

            default:
              return -1;
            }

        case E_V16HFmode:
          switch (pattern1296 (x2))
            {
            case 0:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4419; /* avx512fp16_vcvtw2ph_v16hi_mask_round */

            case 1:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4443; /* avx512fp16_vcvtdq2ph_v16si_mask_round */

            default:
              return -1;
            }

        case E_V32HFmode:
          if (pattern647 (x2, 
E_SImode, 
E_V32HFmode, 
E_V32HImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4427; /* avx512fp16_vcvtw2ph_v32hi_mask_round */

        case E_V16SFmode:
          if (pattern647 (x2, 
E_HImode, 
E_V16SFmode, 
E_V16SImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8628 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && (64 == 64 || TARGET_AVX512VL) && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 433 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 4747; /* floatv16siv16sf2_mask_round */

        case E_V8DFmode:
          if (pattern1297 (x2, 
E_V8DFmode, 
E_V8DImode, 
E_QImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4879; /* floatv8div8df2_mask_round */

        case E_V4DFmode:
          if (pattern1297 (x2, 
E_V4DFmode, 
E_V4DImode, 
E_QImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4887; /* floatv4div4df2_mask_round */

        case E_V2DFmode:
          if (pattern1297 (x2, 
E_V2DFmode, 
E_V2DImode, 
E_QImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4895; /* floatv2div2df2_mask_round */

        case E_V8SFmode:
          if (pattern1297 (x2, 
E_V8SFmode, 
E_V8DImode, 
E_QImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
							      || V8DImode == V8DFmode
							      || V8DImode == V8DImode
							      || V8DImode == V16SImode
							      || V8DImode == V32HFmode)) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4903; /* floatv8div8sf2_mask_round */

        default:
          return -1;
        }

    case UNSIGNED_FLOAT:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x9 = XEXP (x3, 1);
      operands[2] = x9;
      x8 = XEXP (x3, 2);
      operands[3] = x8;
      x7 = XVECEXP (x2, 0, 1);
      operands[4] = x7;
      if (!const_4_or_8_to_11_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          switch (pattern1295 (x2))
            {
            case 0:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4415; /* avx512fp16_vcvtuw2ph_v8hi_mask_round */

            case 1:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4439; /* avx512fp16_vcvtudq2ph_v8si_mask_round */

            case 2:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4455; /* avx512fp16_vcvtuqq2ph_v8di_mask_round */

            default:
              return -1;
            }

        case E_V16HFmode:
          switch (pattern1296 (x2))
            {
            case 0:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4423; /* avx512fp16_vcvtuw2ph_v16hi_mask_round */

            case 1:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4447; /* avx512fp16_vcvtudq2ph_v16si_mask_round */

            default:
              return -1;
            }

        case E_V32HFmode:
          if (pattern647 (x2, 
E_SImode, 
E_V32HFmode, 
E_V32HImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4431; /* avx512fp16_vcvtuw2ph_v32hi_mask_round */

        case E_V16SFmode:
          if (pattern1297 (x2, 
E_V16SFmode, 
E_V16SImode, 
E_HImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8641 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4755; /* floatunsv16siv16sf2_mask_round */

        case E_V8SFmode:
          if (pattern1298 (x2, 
E_V8SFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8SImode:
              if (!nonimmediate_operand (operands[1], E_V8SImode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8641 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4759; /* floatunsv8siv8sf2_mask_round */

            case E_V8DImode:
              if (!nonimmediate_operand (operands[1], E_V8DImode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
							      || V8DImode == V8DFmode
							      || V8DImode == V8DImode
							      || V8DImode == V16SImode
							      || V8DImode == V32HFmode)) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4907; /* floatunsv8div8sf2_mask_round */

            default:
              return -1;
            }

        case E_V4SFmode:
          if (pattern1297 (x2, 
E_V4SFmode, 
E_V4SImode, 
E_QImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8641 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4763; /* floatunsv4siv4sf2_mask_round */

        case E_V8DFmode:
          if (pattern1297 (x2, 
E_V8DFmode, 
E_V8DImode, 
E_QImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4883; /* floatunsv8div8df2_mask_round */

        case E_V4DFmode:
          if (pattern1297 (x2, 
E_V4DFmode, 
E_V4DImode, 
E_QImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4891; /* floatunsv4div4df2_mask_round */

        case E_V2DFmode:
          if (pattern1297 (x2, 
E_V2DFmode, 
E_V2DImode, 
E_QImode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4899; /* floatunsv2div2df2_mask_round */

        default:
          return -1;
        }

    case FIX:
      switch (pattern648 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4545; /* avx512fp16_fix_truncv8hi2_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4553; /* avx512fp16_fix_truncv16hi2_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4561; /* avx512fp16_fix_truncv32hi2_mask_round */

        case 3:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4569; /* avx512fp16_fix_truncv8si2_mask_round */

        case 4:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9557 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4960; /* fix_truncv8dfv8si2_mask_round */

        case 5:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4577; /* avx512fp16_fix_truncv16si2_mask_round */

        case 6:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8764 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4811; /* fix_truncv16sfv16si2_mask_round */

        case 7:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4585; /* avx512fp16_fix_truncv8di2_mask_round */

        case 8:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4997; /* fix_truncv8dfv8di2_mask_round */

        case 9:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9729 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 5041; /* fix_truncv8sfv8di2_mask_round */

        default:
          return -1;
        }

    case UNSIGNED_FIX:
      switch (pattern648 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4549; /* avx512fp16_fixuns_truncv8hi2_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4557; /* avx512fp16_fixuns_truncv16hi2_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4565; /* avx512fp16_fixuns_truncv32hi2_mask_round */

        case 3:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4573; /* avx512fp16_fixuns_truncv8si2_mask_round */

        case 4:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9557 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4964; /* fixuns_truncv8dfv8si2_mask_round */

        case 5:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4581; /* avx512fp16_fixuns_truncv16si2_mask_round */

        case 6:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8764 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4815; /* fixuns_truncv16sfv16si2_mask_round */

        case 7:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4589; /* avx512fp16_fixuns_truncv8di2_mask_round */

        case 8:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 5001; /* fixuns_truncv8dfv8di2_mask_round */

        case 9:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9729 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 5045; /* fixuns_truncv8sfv8di2_mask_round */

        default:
          return -1;
        }

    case FLOAT_EXTEND:
      x7 = XVECEXP (x2, 0, 1);
      if (!const48_operand (x7, E_SImode))
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
          operands[1] = x5;
          x9 = XEXP (x3, 1);
          operands[2] = x9;
          x8 = XEXP (x3, 2);
          operands[3] = x8;
          operands[4] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V8DFmode:
              if (pattern1298 (x2, 
E_V8DFmode, 
E_QImode) != 0)
                return -1;
              switch (GET_MODE (operands[1]))
                {
                case E_V8HFmode:
                  if (!register_operand (operands[1], E_V8HFmode)
                      || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8022 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                    return -1;
                  return 4649; /* avx512fp16_float_extend_phv8df2_mask_round */

                case E_V8SFmode:
                  if (!register_operand (operands[1], E_V8SFmode)
                      || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 10207 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (64 == 64 || TARGET_AVX512VL) && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 467 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
                    return -1;
                  return 5094; /* avx512f_cvtps2pd512_mask_round */

                default:
                  return -1;
                }

            case E_V16SFmode:
              if (pattern647 (x2, 
E_HImode, 
E_V16SFmode, 
E_V16HFmode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8022 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4653; /* avx512fp16_float_extend_phv16sf2_mask_round */

            case E_V8SFmode:
              if (pattern647 (x2, 
E_QImode, 
E_V8SFmode, 
E_V8HFmode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8022 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4657; /* avx512fp16_float_extend_phv8sf2_mask_round */

            default:
              return -1;
            }

        case VEC_SELECT:
          if (GET_MODE (x5) != E_V2SFmode)
            return -1;
          x10 = XEXP (x5, 1);
          if (GET_CODE (x10) != PARALLEL
              || XVECLEN (x10, 0) != 2)
            return -1;
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x12 = XVECEXP (x10, 0, 1);
          if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x8 = XEXP (x3, 2);
          if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || pattern1462 (x2) != 0)
            return -1;
          x13 = XEXP (x5, 0);
          operands[2] = x13;
          if (!register_operand (operands[2], E_V4SFmode))
            return -1;
          x9 = XEXP (x3, 1);
          operands[1] = x9;
          if (!register_operand (operands[1], E_V2DFmode))
            return -1;
          operands[3] = x7;
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10034 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 5077; /* sse2_cvtss2sd_round */

        default:
          return -1;
        }

    case FLOAT_TRUNCATE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x9 = XEXP (x3, 1);
      operands[2] = x9;
      x8 = XEXP (x3, 2);
      operands[3] = x8;
      x7 = XVECEXP (x2, 0, 1);
      operands[4] = x7;
      if (!const_4_or_8_to_11_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          if (pattern1298 (x2, 
E_V8HFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8DFmode:
              if (!register_operand (operands[1], E_V8DFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8116 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4673; /* avx512fp16_vcvtpd2ph_v8df_mask_round */

            case E_V8SFmode:
              if (!register_operand (operands[1], E_V8SFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8116 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4681; /* avx512fp16_vcvtps2ph_v8sf_mask_round */

            default:
              return -1;
            }

        case E_V16HFmode:
          if (pattern647 (x2, 
E_HImode, 
E_V16HFmode, 
E_V16SFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8116 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4677; /* avx512fp16_vcvtps2ph_v16sf_mask_round */

        case E_V8SFmode:
          if (pattern647 (x2, 
E_QImode, 
E_V8SFmode, 
E_V8DFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 5084; /* avx512f_cvtpd2ps512_mask_round */

        default:
          return -1;
        }

    case VEC_CONCAT:
      if (GET_MODE (x4) != E_V32HFmode)
        return -1;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != FLOAT_TRUNCATE
          || GET_MODE (x5) != E_V16HFmode)
        return -1;
      x6 = XEXP (x4, 1);
      if (GET_CODE (x6) != FLOAT_TRUNCATE
          || GET_MODE (x6) != E_V16HFmode
          || !register_operand (operands[0], E_V32HFmode)
          || GET_MODE (x2) != E_V32HFmode
          || GET_MODE (x3) != E_V32HFmode)
        return -1;
      x13 = XEXP (x5, 0);
      operands[2] = x13;
      if (!register_operand (operands[2], E_V16SFmode))
        return -1;
      x14 = XEXP (x6, 0);
      operands[1] = x14;
      if (!register_operand (operands[1], E_V16SFmode))
        return -1;
      x9 = XEXP (x3, 1);
      operands[3] = x9;
      if (!nonimm_or_0_operand (operands[3], E_V32HFmode))
        return -1;
      x8 = XEXP (x3, 2);
      operands[4] = x8;
      if (!register_operand (operands[4], E_SImode))
        return -1;
      x7 = XVECEXP (x2, 0, 1);
      operands[5] = x7;
      if (!const_4_or_8_to_11_operand (operands[5], E_SImode)
          || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31727 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10366; /* avx10_2_cvt2ps2phx_v32hf_mask_round */

    default:
      return -1;
    }
}

 int
recog_277 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (GET_CODE (x5) == CONST_INT)
    {
      res = recog_276 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
    }
  operands[3] = x4;
  x6 = XEXP (x2, 0);
  x7 = XEXP (x6, 1);
  operands[2] = x7;
  operands[4] = x5;
  x8 = XVECEXP (x3, 0, 2);
  operands[5] = x8;
  x9 = XVECEXP (x3, 0, 3);
  operands[6] = x9;
  x10 = XVECEXP (x3, 0, 4);
  operands[7] = x10;
  x11 = XVECEXP (x3, 0, 5);
  operands[8] = x11;
  x12 = XVECEXP (x3, 0, 6);
  operands[9] = x12;
  x13 = XVECEXP (x3, 0, 7);
  operands[10] = x13;
  x14 = XVECEXP (x3, 0, 8);
  operands[11] = x14;
  x15 = XVECEXP (x3, 0, 9);
  operands[12] = x15;
  x16 = XVECEXP (x3, 0, 10);
  operands[13] = x16;
  x17 = XVECEXP (x3, 0, 11);
  operands[14] = x17;
  x18 = XVECEXP (x3, 0, 12);
  operands[15] = x18;
  x19 = XVECEXP (x3, 0, 13);
  operands[16] = x19;
  x20 = XVECEXP (x3, 0, 14);
  operands[17] = x20;
  x21 = XVECEXP (x3, 0, 15);
  operands[18] = x21;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (pattern1401 (x2, 
E_V16SFmode, 
E_V32SFmode) != 0)
        return -1;
      if (const_0_to_3_operand (operands[3], E_VOIDmode)
          && const_0_to_3_operand (operands[4], E_VOIDmode)
          && const_16_to_19_operand (operands[5], E_VOIDmode)
          && const_16_to_19_operand (operands[6], E_VOIDmode)
          && const_4_to_7_operand (operands[7], E_VOIDmode)
          && const_4_to_7_operand (operands[8], E_VOIDmode)
          && const_20_to_23_operand (operands[9], E_VOIDmode)
          && const_20_to_23_operand (operands[10], E_VOIDmode)
          && const_8_to_11_operand (operands[11], E_VOIDmode)
          && const_8_to_11_operand (operands[12], E_VOIDmode)
          && const_24_to_27_operand (operands[13], E_VOIDmode)
          && const_24_to_27_operand (operands[14], E_VOIDmode)
          && const_12_to_15_operand (operands[15], E_VOIDmode)
          && const_12_to_15_operand (operands[16], E_VOIDmode)
          && const_28_to_31_operand (operands[17], E_VOIDmode)
          && const_28_to_31_operand (operands[18], E_VOIDmode)
          && 
#line 14270 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512
   && (INTVAL (operands[3]) == (INTVAL (operands[7]) - 4)
       && INTVAL (operands[4]) == (INTVAL (operands[8]) - 4)
       && INTVAL (operands[5]) == (INTVAL (operands[9]) - 4)
       && INTVAL (operands[6]) == (INTVAL (operands[10]) - 4)
       && INTVAL (operands[3]) == (INTVAL (operands[11]) - 8)
       && INTVAL (operands[4]) == (INTVAL (operands[12]) - 8)
       && INTVAL (operands[5]) == (INTVAL (operands[13]) - 8)
       && INTVAL (operands[6]) == (INTVAL (operands[14]) - 8)
       && INTVAL (operands[3]) == (INTVAL (operands[15]) - 12)
       && INTVAL (operands[4]) == (INTVAL (operands[16]) - 12)
       && INTVAL (operands[5]) == (INTVAL (operands[17]) - 12)
       && INTVAL (operands[6]) == (INTVAL (operands[18]) - 12))))
        return 7116; /* avx512f_shufps512_1 */
      if (!const_0_to_15_operand (operands[3], E_VOIDmode)
          || pattern1837 () != 0
          || !(
#line 20401 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[3]) & 3) == 0
   && INTVAL (operands[3]) == INTVAL (operands[4]) - 1
   && INTVAL (operands[3]) == INTVAL (operands[5]) - 2
   && INTVAL (operands[3]) == INTVAL (operands[6]) - 3
   && (INTVAL (operands[7]) & 3) == 0
   && INTVAL (operands[7]) == INTVAL (operands[8]) - 1
   && INTVAL (operands[7]) == INTVAL (operands[9]) - 2
   && INTVAL (operands[7]) == INTVAL (operands[10]) - 3
   && (INTVAL (operands[11]) & 3) == 0
   && INTVAL (operands[11]) == INTVAL (operands[12]) - 1
   && INTVAL (operands[11]) == INTVAL (operands[13]) - 2
   && INTVAL (operands[11]) == INTVAL (operands[14]) - 3
   && (INTVAL (operands[15]) & 3) == 0
   && INTVAL (operands[15]) == INTVAL (operands[16]) - 1
   && INTVAL (operands[15]) == INTVAL (operands[17]) - 2
   && INTVAL (operands[15]) == INTVAL (operands[18]) - 3) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 8356; /* avx512f_shuf_f32x4_1 */

    case E_V16SImode:
      if (pattern1401 (x2, 
E_V16SImode, 
E_V32SImode) != 0
          || !const_0_to_15_operand (operands[3], E_VOIDmode)
          || pattern1837 () != 0
          || !(
#line 20401 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[3]) & 3) == 0
   && INTVAL (operands[3]) == INTVAL (operands[4]) - 1
   && INTVAL (operands[3]) == INTVAL (operands[5]) - 2
   && INTVAL (operands[3]) == INTVAL (operands[6]) - 3
   && (INTVAL (operands[7]) & 3) == 0
   && INTVAL (operands[7]) == INTVAL (operands[8]) - 1
   && INTVAL (operands[7]) == INTVAL (operands[9]) - 2
   && INTVAL (operands[7]) == INTVAL (operands[10]) - 3
   && (INTVAL (operands[11]) & 3) == 0
   && INTVAL (operands[11]) == INTVAL (operands[12]) - 1
   && INTVAL (operands[11]) == INTVAL (operands[13]) - 2
   && INTVAL (operands[11]) == INTVAL (operands[14]) - 3
   && (INTVAL (operands[15]) & 3) == 0
   && INTVAL (operands[15]) == INTVAL (operands[16]) - 1
   && INTVAL (operands[15]) == INTVAL (operands[17]) - 2
   && INTVAL (operands[15]) == INTVAL (operands[18]) - 3) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 8358; /* avx512f_shuf_i32x4_1 */

    default:
      return -1;
    }
}

 int
recog_279 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47, x48, x49;
  rtx x50, x51, x52, x53, x54, x55, x56, x57;
  rtx x58, x59, x60, x61, x62, x63, x64, x65;
  rtx x66, x67;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (pattern667 (x3) != 0)
    return -1;
  x4 = XVECEXP (x3, 0, 32);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x3, 0, 33);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x3, 0, 34);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x3, 0, 35);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  x8 = XVECEXP (x3, 0, 36);
  if (GET_CODE (x8) != CONST_INT)
    return -1;
  x9 = XVECEXP (x3, 0, 37);
  if (GET_CODE (x9) != CONST_INT)
    return -1;
  x10 = XVECEXP (x3, 0, 38);
  if (GET_CODE (x10) != CONST_INT)
    return -1;
  x11 = XVECEXP (x3, 0, 39);
  if (GET_CODE (x11) != CONST_INT)
    return -1;
  x12 = XVECEXP (x3, 0, 40);
  if (GET_CODE (x12) != CONST_INT)
    return -1;
  x13 = XVECEXP (x3, 0, 41);
  if (GET_CODE (x13) != CONST_INT)
    return -1;
  x14 = XVECEXP (x3, 0, 42);
  if (GET_CODE (x14) != CONST_INT)
    return -1;
  x15 = XVECEXP (x3, 0, 43);
  if (GET_CODE (x15) != CONST_INT)
    return -1;
  x16 = XVECEXP (x3, 0, 44);
  if (GET_CODE (x16) != CONST_INT)
    return -1;
  x17 = XVECEXP (x3, 0, 45);
  if (GET_CODE (x17) != CONST_INT)
    return -1;
  x18 = XVECEXP (x3, 0, 46);
  if (GET_CODE (x18) != CONST_INT)
    return -1;
  x19 = XVECEXP (x3, 0, 47);
  if (GET_CODE (x19) != CONST_INT)
    return -1;
  x20 = XVECEXP (x3, 0, 48);
  if (GET_CODE (x20) != CONST_INT)
    return -1;
  x21 = XVECEXP (x3, 0, 49);
  if (GET_CODE (x21) != CONST_INT)
    return -1;
  x22 = XVECEXP (x3, 0, 50);
  if (GET_CODE (x22) != CONST_INT)
    return -1;
  x23 = XVECEXP (x3, 0, 51);
  if (GET_CODE (x23) != CONST_INT)
    return -1;
  x24 = XVECEXP (x3, 0, 52);
  if (GET_CODE (x24) != CONST_INT)
    return -1;
  x25 = XVECEXP (x3, 0, 53);
  if (GET_CODE (x25) != CONST_INT)
    return -1;
  x26 = XVECEXP (x3, 0, 54);
  if (GET_CODE (x26) != CONST_INT)
    return -1;
  x27 = XVECEXP (x3, 0, 55);
  if (GET_CODE (x27) != CONST_INT)
    return -1;
  x28 = XVECEXP (x3, 0, 56);
  if (GET_CODE (x28) != CONST_INT)
    return -1;
  x29 = XVECEXP (x3, 0, 57);
  if (GET_CODE (x29) != CONST_INT)
    return -1;
  x30 = XVECEXP (x3, 0, 58);
  if (GET_CODE (x30) != CONST_INT)
    return -1;
  x31 = XVECEXP (x3, 0, 59);
  if (GET_CODE (x31) != CONST_INT)
    return -1;
  x32 = XVECEXP (x3, 0, 60);
  if (GET_CODE (x32) != CONST_INT)
    return -1;
  x33 = XVECEXP (x3, 0, 61);
  if (GET_CODE (x33) != CONST_INT)
    return -1;
  x34 = XVECEXP (x3, 0, 62);
  if (GET_CODE (x34) != CONST_INT)
    return -1;
  x35 = XVECEXP (x3, 0, 63);
  if (GET_CODE (x35) != CONST_INT
      || pattern1601 (x2, 
E_V64QImode, 
E_V128QImode) != 0)
    return -1;
  x36 = XVECEXP (x3, 0, 0);
  switch (XWINT (x36, 0))
    {
    case 8L:
      x37 = XVECEXP (x3, 0, 1);
      if (XWINT (x37, 0) != 72L)
        return -1;
      x38 = XVECEXP (x3, 0, 2);
      if (XWINT (x38, 0) != 9L)
        return -1;
      x39 = XVECEXP (x3, 0, 3);
      if (XWINT (x39, 0) != 73L)
        return -1;
      x40 = XVECEXP (x3, 0, 4);
      if (XWINT (x40, 0) != 10L)
        return -1;
      x41 = XVECEXP (x3, 0, 5);
      if (XWINT (x41, 0) != 74L)
        return -1;
      x42 = XVECEXP (x3, 0, 6);
      if (XWINT (x42, 0) != 11L)
        return -1;
      x43 = XVECEXP (x3, 0, 7);
      if (XWINT (x43, 0) != 75L)
        return -1;
      x44 = XVECEXP (x3, 0, 8);
      if (XWINT (x44, 0) != 12L)
        return -1;
      x45 = XVECEXP (x3, 0, 9);
      if (XWINT (x45, 0) != 76L)
        return -1;
      x46 = XVECEXP (x3, 0, 10);
      if (XWINT (x46, 0) != 13L)
        return -1;
      x47 = XVECEXP (x3, 0, 11);
      if (XWINT (x47, 0) != 77L)
        return -1;
      x48 = XVECEXP (x3, 0, 12);
      if (XWINT (x48, 0) != 14L)
        return -1;
      x49 = XVECEXP (x3, 0, 13);
      if (XWINT (x49, 0) != 78L)
        return -1;
      x50 = XVECEXP (x3, 0, 14);
      if (XWINT (x50, 0) != 15L)
        return -1;
      x51 = XVECEXP (x3, 0, 15);
      if (XWINT (x51, 0) != 79L)
        return -1;
      x52 = XVECEXP (x3, 0, 16);
      if (XWINT (x52, 0) != 24L)
        return -1;
      x53 = XVECEXP (x3, 0, 17);
      if (XWINT (x53, 0) != 88L)
        return -1;
      x54 = XVECEXP (x3, 0, 18);
      if (XWINT (x54, 0) != 25L)
        return -1;
      x55 = XVECEXP (x3, 0, 19);
      if (XWINT (x55, 0) != 89L)
        return -1;
      x56 = XVECEXP (x3, 0, 20);
      if (XWINT (x56, 0) != 26L)
        return -1;
      x57 = XVECEXP (x3, 0, 21);
      if (XWINT (x57, 0) != 90L)
        return -1;
      x58 = XVECEXP (x3, 0, 22);
      if (XWINT (x58, 0) != 27L)
        return -1;
      x59 = XVECEXP (x3, 0, 23);
      if (XWINT (x59, 0) != 91L)
        return -1;
      x60 = XVECEXP (x3, 0, 24);
      if (XWINT (x60, 0) != 28L)
        return -1;
      x61 = XVECEXP (x3, 0, 25);
      if (XWINT (x61, 0) != 92L)
        return -1;
      x62 = XVECEXP (x3, 0, 26);
      if (XWINT (x62, 0) != 29L)
        return -1;
      x63 = XVECEXP (x3, 0, 27);
      if (XWINT (x63, 0) != 93L)
        return -1;
      x64 = XVECEXP (x3, 0, 28);
      if (XWINT (x64, 0) != 30L)
        return -1;
      x65 = XVECEXP (x3, 0, 29);
      if (XWINT (x65, 0) != 94L)
        return -1;
      x66 = XVECEXP (x3, 0, 30);
      if (XWINT (x66, 0) != 31L)
        return -1;
      x67 = XVECEXP (x3, 0, 31);
      if (XWINT (x67, 0) != 95L
          || XWINT (x4, 0) != 40L
          || XWINT (x5, 0) != 104L
          || XWINT (x6, 0) != 41L
          || XWINT (x7, 0) != 105L
          || XWINT (x8, 0) != 42L
          || XWINT (x9, 0) != 106L
          || XWINT (x10, 0) != 43L
          || XWINT (x11, 0) != 107L
          || XWINT (x12, 0) != 44L
          || XWINT (x13, 0) != 108L
          || XWINT (x14, 0) != 45L
          || XWINT (x15, 0) != 109L
          || XWINT (x16, 0) != 46L
          || XWINT (x17, 0) != 110L
          || XWINT (x18, 0) != 47L
          || XWINT (x19, 0) != 111L
          || XWINT (x20, 0) != 56L
          || XWINT (x21, 0) != 120L
          || XWINT (x22, 0) != 57L
          || XWINT (x23, 0) != 121L
          || XWINT (x24, 0) != 58L
          || XWINT (x25, 0) != 122L
          || XWINT (x26, 0) != 59L
          || XWINT (x27, 0) != 123L
          || XWINT (x28, 0) != 60L
          || XWINT (x29, 0) != 124L
          || XWINT (x30, 0) != 61L
          || XWINT (x31, 0) != 125L
          || XWINT (x32, 0) != 62L
          || XWINT (x33, 0) != 126L
          || XWINT (x34, 0) != 63L
          || XWINT (x35, 0) != 127L
          || !
#line 19410 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
        return -1;
      return 8246; /* avx512bw_interleave_highv64qi */

    case 0L:
      x37 = XVECEXP (x3, 0, 1);
      if (XWINT (x37, 0) != 64L)
        return -1;
      x38 = XVECEXP (x3, 0, 2);
      if (XWINT (x38, 0) != 1L)
        return -1;
      x39 = XVECEXP (x3, 0, 3);
      if (XWINT (x39, 0) != 65L)
        return -1;
      x40 = XVECEXP (x3, 0, 4);
      if (XWINT (x40, 0) != 2L)
        return -1;
      x41 = XVECEXP (x3, 0, 5);
      if (XWINT (x41, 0) != 66L)
        return -1;
      x42 = XVECEXP (x3, 0, 6);
      if (XWINT (x42, 0) != 3L)
        return -1;
      x43 = XVECEXP (x3, 0, 7);
      if (XWINT (x43, 0) != 67L)
        return -1;
      x44 = XVECEXP (x3, 0, 8);
      if (XWINT (x44, 0) != 4L)
        return -1;
      x45 = XVECEXP (x3, 0, 9);
      if (XWINT (x45, 0) != 68L)
        return -1;
      x46 = XVECEXP (x3, 0, 10);
      if (XWINT (x46, 0) != 5L)
        return -1;
      x47 = XVECEXP (x3, 0, 11);
      if (XWINT (x47, 0) != 69L)
        return -1;
      x48 = XVECEXP (x3, 0, 12);
      if (XWINT (x48, 0) != 6L)
        return -1;
      x49 = XVECEXP (x3, 0, 13);
      if (XWINT (x49, 0) != 70L)
        return -1;
      x50 = XVECEXP (x3, 0, 14);
      if (XWINT (x50, 0) != 7L)
        return -1;
      x51 = XVECEXP (x3, 0, 15);
      if (XWINT (x51, 0) != 71L)
        return -1;
      x52 = XVECEXP (x3, 0, 16);
      if (XWINT (x52, 0) != 16L)
        return -1;
      x53 = XVECEXP (x3, 0, 17);
      if (XWINT (x53, 0) != 80L)
        return -1;
      x54 = XVECEXP (x3, 0, 18);
      if (XWINT (x54, 0) != 17L)
        return -1;
      x55 = XVECEXP (x3, 0, 19);
      if (XWINT (x55, 0) != 81L)
        return -1;
      x56 = XVECEXP (x3, 0, 20);
      if (XWINT (x56, 0) != 18L)
        return -1;
      x57 = XVECEXP (x3, 0, 21);
      if (XWINT (x57, 0) != 82L)
        return -1;
      x58 = XVECEXP (x3, 0, 22);
      if (XWINT (x58, 0) != 19L)
        return -1;
      x59 = XVECEXP (x3, 0, 23);
      if (XWINT (x59, 0) != 83L)
        return -1;
      x60 = XVECEXP (x3, 0, 24);
      if (XWINT (x60, 0) != 20L)
        return -1;
      x61 = XVECEXP (x3, 0, 25);
      if (XWINT (x61, 0) != 84L)
        return -1;
      x62 = XVECEXP (x3, 0, 26);
      if (XWINT (x62, 0) != 21L)
        return -1;
      x63 = XVECEXP (x3, 0, 27);
      if (XWINT (x63, 0) != 85L)
        return -1;
      x64 = XVECEXP (x3, 0, 28);
      if (XWINT (x64, 0) != 22L)
        return -1;
      x65 = XVECEXP (x3, 0, 29);
      if (XWINT (x65, 0) != 86L)
        return -1;
      x66 = XVECEXP (x3, 0, 30);
      if (XWINT (x66, 0) != 23L)
        return -1;
      x67 = XVECEXP (x3, 0, 31);
      if (XWINT (x67, 0) != 87L
          || XWINT (x4, 0) != 32L
          || XWINT (x5, 0) != 96L
          || XWINT (x6, 0) != 33L
          || XWINT (x7, 0) != 97L
          || XWINT (x8, 0) != 34L
          || XWINT (x9, 0) != 98L
          || XWINT (x10, 0) != 35L
          || XWINT (x11, 0) != 99L
          || XWINT (x12, 0) != 36L
          || XWINT (x13, 0) != 100L
          || XWINT (x14, 0) != 37L
          || XWINT (x15, 0) != 101L
          || XWINT (x16, 0) != 38L
          || XWINT (x17, 0) != 102L
          || XWINT (x18, 0) != 39L
          || XWINT (x19, 0) != 103L
          || XWINT (x20, 0) != 48L
          || XWINT (x21, 0) != 112L
          || XWINT (x22, 0) != 49L
          || XWINT (x23, 0) != 113L
          || XWINT (x24, 0) != 50L
          || XWINT (x25, 0) != 114L
          || XWINT (x26, 0) != 51L
          || XWINT (x27, 0) != 115L
          || XWINT (x28, 0) != 52L
          || XWINT (x29, 0) != 116L
          || XWINT (x30, 0) != 53L
          || XWINT (x31, 0) != 117L
          || XWINT (x32, 0) != 54L
          || XWINT (x33, 0) != 118L
          || XWINT (x34, 0) != 55L
          || XWINT (x35, 0) != 119L
          || !
#line 19506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
        return -1;
      return 8252; /* avx512bw_interleave_lowv64qi */

    default:
      return -1;
    }
}

 int
recog_296 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x3, 0);
  operands[1] = x5;
  switch (XVECLEN (x4, 0))
    {
    case 1:
      x6 = XVECEXP (x4, 0, 0);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (!register_operand (operands[0], E_V8SFmode)
              || GET_MODE (x2) != E_V8SFmode
              || GET_MODE (x3) != E_SFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SFmode:
              if (register_operand (operands[1], E_V4SFmode)
                  && (
#line 11699 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 440 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 5185; /* avx2_vec_dupv8sf */
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9126; /* avx512vl_vec_dupv8sf */

            case E_V8SFmode:
              if (!register_operand (operands[1], E_V8SFmode)
                  || !
#line 11711 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 5187; /* avx2_vec_dupv8sf_1 */

            default:
              return -1;
            }

        case E_V4SFmode:
          if (!register_operand (operands[0], E_V4SFmode)
              || GET_MODE (x2) != E_V4SFmode
              || GET_MODE (x3) != E_SFmode)
            return -1;
          if (register_operand (operands[1], E_V4SFmode)
              && 
#line 11699 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return 5186; /* avx2_vec_dupv4sf */
          if (!nonimmediate_operand (operands[1], E_V4SFmode)
              || !(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9128; /* avx512vl_vec_dupv4sf */

        case E_V16SFmode:
          if (!register_operand (operands[0], E_V16SFmode)
              || GET_MODE (x2) != E_V16SFmode
              || GET_MODE (x3) != E_SFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V16SFmode:
              if (!register_operand (operands[1], E_V16SFmode)
                  || !(
#line 11723 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 487 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 5188; /* avx512f_vec_dupv16sf_1 */

            case E_V4SFmode:
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9124; /* avx512f_vec_dupv16sf */

            default:
              return -1;
            }

        case E_V8DFmode:
          if (!register_operand (operands[0], E_V8DFmode)
              || GET_MODE (x2) != E_V8DFmode
              || GET_MODE (x3) != E_DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8DFmode:
              if (!register_operand (operands[1], E_V8DFmode)
                  || !(
#line 11723 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 487 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 5189; /* avx512f_vec_dupv8df_1 */

            case E_V2DFmode:
              if (!nonimmediate_operand (operands[1], E_V2DFmode)
                  || !(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9130; /* avx512f_vec_dupv8df */

            default:
              return -1;
            }

        case E_V16SImode:
          if (!register_operand (operands[0], E_V16SImode)
              || GET_MODE (x2) != E_V16SImode
              || GET_MODE (x3) != E_SImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!nonimmediate_operand (operands[1], E_V4SImode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 577 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return 9017; /* avx2_pbroadcastv16si */
              if (!(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9112; /* avx512f_vec_dupv16si */

            case E_V16SImode:
              if (!nonimmediate_operand (operands[1], E_V16SImode)
                  || !(
#line 27703 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 976 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9106; /* avx512f_vec_dupv16si_1 */

            default:
              return -1;
            }

        case E_V8DImode:
          if (!register_operand (operands[0], E_V8DImode)
              || GET_MODE (x2) != E_V8DImode
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V2DImode:
              if (!nonimmediate_operand (operands[1], E_V2DImode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 578 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return 9018; /* avx2_pbroadcastv8di */
              if (!(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9118; /* avx512f_vec_dupv8di */

            case E_V8DImode:
              if (!nonimmediate_operand (operands[1], E_V8DImode)
                  || !(
#line 27703 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 976 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9107; /* avx512f_vec_dupv8di_1 */

            default:
              return -1;
            }

        case E_V64QImode:
          if (!register_operand (operands[0], E_V64QImode)
              || GET_MODE (x2) != E_V64QImode
              || GET_MODE (x3) != E_QImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V16QImode:
              if (!nonimmediate_operand (operands[1], E_V16QImode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 579 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return 9019; /* avx2_pbroadcastv64qi */
              if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9136; /* avx512bw_vec_dupv64qi */

            case E_V64QImode:
              if (!nonimmediate_operand (operands[1], E_V64QImode)
                  || !(
#line 27703 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 978 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 9109; /* avx512bw_vec_dupv64qi_1 */

            default:
              return -1;
            }

        case E_V32QImode:
          if (!register_operand (operands[0], E_V32QImode)
              || GET_MODE (x2) != E_V32QImode
              || GET_MODE (x3) != E_QImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V16QImode:
              if (!nonimmediate_operand (operands[1], E_V16QImode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 579 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 9020; /* avx2_pbroadcastv32qi */
              if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9140; /* avx512vl_vec_dupv32qi */

            case E_V32QImode:
              if (!nonimmediate_operand (operands[1], E_V32QImode)
                  || !
#line 27300 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 9035; /* avx2_pbroadcastv32qi_1 */

            default:
              return -1;
            }

        case E_V16QImode:
          if (pattern920 (x2, 
E_V16QImode, 
E_QImode) != 0)
            return -1;
          if (
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return 9021; /* avx2_pbroadcastv16qi */
          if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9138; /* avx512vl_vec_dupv16qi */

        case E_V32HImode:
          if (!register_operand (operands[0], E_V32HImode)
              || GET_MODE (x2) != E_V32HImode
              || GET_MODE (x3) != E_HImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HImode:
              if (!nonimmediate_operand (operands[1], E_V8HImode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 580 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return 9022; /* avx2_pbroadcastv32hi */
              if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9142; /* avx512bw_vec_dupv32hi */

            case E_V32HImode:
              if (!nonimmediate_operand (operands[1], E_V32HImode)
                  || !(
#line 27703 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 977 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 9108; /* avx512bw_vec_dupv32hi_1 */

            default:
              return -1;
            }

        case E_V16HImode:
          if (!register_operand (operands[0], E_V16HImode)
              || GET_MODE (x2) != E_V16HImode
              || GET_MODE (x3) != E_HImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HImode:
              if (!nonimmediate_operand (operands[1], E_V8HImode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 580 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 9023; /* avx2_pbroadcastv16hi */
              if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9144; /* avx512vl_vec_dupv16hi */

            case E_V16HImode:
              if (!nonimmediate_operand (operands[1], E_V16HImode)
                  || !
#line 27300 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 9036; /* avx2_pbroadcastv16hi_1 */

            default:
              return -1;
            }

        case E_V8HImode:
          if (pattern920 (x2, 
E_V8HImode, 
E_HImode) != 0)
            return -1;
          if (
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return 9024; /* avx2_pbroadcastv8hi */
          if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9146; /* avx512vl_vec_dupv8hi */

        case E_V8SImode:
          if (!register_operand (operands[0], E_V8SImode)
              || GET_MODE (x2) != E_V8SImode
              || GET_MODE (x3) != E_SImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!nonimmediate_operand (operands[1], E_V4SImode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 581 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 9025; /* avx2_pbroadcastv8si */
              if (!(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9114; /* avx512vl_vec_dupv8si */

            case E_V8SImode:
              if (!nonimmediate_operand (operands[1], E_V8SImode)
                  || !
#line 27300 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 9037; /* avx2_pbroadcastv8si_1 */

            default:
              return -1;
            }

        case E_V4SImode:
          if (pattern920 (x2, 
E_V4SImode, 
E_SImode) != 0)
            return -1;
          if (
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return 9026; /* avx2_pbroadcastv4si */
          if (!(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9116; /* avx512vl_vec_dupv4si */

        case E_V4DImode:
          if (!register_operand (operands[0], E_V4DImode)
              || GET_MODE (x2) != E_V4DImode
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V2DImode:
              if (!nonimmediate_operand (operands[1], E_V2DImode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 9027; /* avx2_pbroadcastv4di */
              if (!(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9120; /* avx512vl_vec_dupv4di */

            case E_V4DImode:
              if (!nonimmediate_operand (operands[1], E_V4DImode)
                  || !
#line 27300 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 9038; /* avx2_pbroadcastv4di_1 */

            default:
              return -1;
            }

        case E_V2DImode:
          if (pattern920 (x2, 
E_V2DImode, 
E_DImode) != 0)
            return -1;
          if (
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return 9028; /* avx2_pbroadcastv2di */
          if (!(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9122; /* avx512vl_vec_dupv2di */

        case E_V32HFmode:
          if (!register_operand (operands[0], E_V32HFmode)
              || GET_MODE (x2) != E_V32HFmode
              || GET_MODE (x3) != E_HFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!nonimmediate_operand (operands[1], E_V8HFmode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return 9029; /* avx2_pbroadcastv32hf */
              if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9148; /* avx512bw_vec_dupv32hf */

            case E_V32HFmode:
              if (!nonimmediate_operand (operands[1], E_V32HFmode)
                  || !(
#line 27703 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 979 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 9110; /* avx512bw_vec_dupv32hf_1 */

            default:
              return -1;
            }

        case E_V16HFmode:
          if (!register_operand (operands[0], E_V16HFmode)
              || GET_MODE (x2) != E_V16HFmode
              || GET_MODE (x3) != E_HFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!nonimmediate_operand (operands[1], E_V8HFmode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 9030; /* avx2_pbroadcastv16hf */
              if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9150; /* avx512vl_vec_dupv16hf */

            case E_V16HFmode:
              if (!nonimmediate_operand (operands[1], E_V16HFmode)
                  || !
#line 27300 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 9039; /* avx2_pbroadcastv16hf_1 */

            default:
              return -1;
            }

        case E_V8HFmode:
          if (pattern920 (x2, 
E_V8HFmode, 
E_HFmode) != 0)
            return -1;
          if (
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return 9031; /* avx2_pbroadcastv8hf */
          if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9152; /* avx512fp16_vec_dupv8hf */

        case E_V32BFmode:
          if (!register_operand (operands[0], E_V32BFmode)
              || GET_MODE (x2) != E_V32BFmode
              || GET_MODE (x3) != E_BFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8BFmode:
              if (!nonimmediate_operand (operands[1], E_V8BFmode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 584 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return 9032; /* avx2_pbroadcastv32bf */
              if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9154; /* avx512bw_vec_dupv32bf */

            case E_V32BFmode:
              if (!nonimmediate_operand (operands[1], E_V32BFmode)
                  || !(
#line 27703 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 9111; /* avx512bw_vec_dupv32bf_1 */

            default:
              return -1;
            }

        case E_V16BFmode:
          if (!register_operand (operands[0], E_V16BFmode)
              || GET_MODE (x2) != E_V16BFmode
              || GET_MODE (x3) != E_BFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8BFmode:
              if (!nonimmediate_operand (operands[1], E_V8BFmode))
                return -1;
              if ((
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 584 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 9033; /* avx2_pbroadcastv16bf */
              if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9156; /* avx512vl_vec_dupv16bf */

            case E_V16BFmode:
              if (!nonimmediate_operand (operands[1], E_V16BFmode)
                  || !
#line 27300 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 9040; /* avx2_pbroadcastv16bf_1 */

            default:
              return -1;
            }

        case E_V8BFmode:
          if (pattern920 (x2, 
E_V8BFmode, 
E_BFmode) != 0)
            return -1;
          if (
#line 27286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return 9034; /* avx2_pbroadcastv8bf */
          if (!(
#line 27736 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9158; /* avx512vl_vec_dupv8bf */

        case E_V4DFmode:
          if (!register_operand (operands[0], E_V4DFmode)
              || GET_MODE (x2) != E_V4DFmode
              || GET_MODE (x3) != E_DFmode)
            return -1;
          if (register_operand (operands[1], E_V2DFmode)
              && 
#line 27691 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return 9105; /* avx2_vec_dupv4df */
          if (!nonimmediate_operand (operands[1], E_V2DFmode)
              || !(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9132; /* avx512vl_vec_dupv4df */

        case E_V2DFmode:
          if (pattern920 (x2, 
E_V2DFmode, 
E_DFmode) != 0
              || !(
#line 27717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9134; /* avx512vl_vec_dupv2df */

        default:
          return -1;
        }

    case 2:
      x6 = XVECEXP (x4, 0, 0);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XVECEXP (x4, 0, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern916 (x2, 
E_V4SImode, 
E_V2SImode, 
E_V16SImode) != 0
              || !(
#line 28042 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28026 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9246; /* *avx512dq_broadcastv16si */

        case E_V8SImode:
          if (pattern916 (x2, 
E_V4SImode, 
E_V2SImode, 
E_V8SImode) != 0
              || !(
#line 28042 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28026 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9248; /* *avx512dq_broadcastv8si */

        case E_V4SImode:
          if (pattern920 (x2, 
E_V4SImode, 
E_V2SImode) != 0
              || !(
#line 28042 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28026 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9250; /* *avx512dq_broadcastv4si */

        case E_V16SFmode:
          if (pattern916 (x2, 
E_V4SFmode, 
E_V2SFmode, 
E_V16SFmode) != 0
              || !(
#line 28042 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28027 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9252; /* *avx512dq_broadcastv16sf */

        case E_V8SFmode:
          if (pattern916 (x2, 
E_V4SFmode, 
E_V2SFmode, 
E_V8SFmode) != 0
              || !(
#line 28042 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 28027 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9254; /* *avx512dq_broadcastv8sf */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_307 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern533 (x2))
        {
        case 0:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5771; /* *avx512bw_vpternlogv32hf_1 */

        case 1:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5798; /* *avx512vl_vpternlogv16hf_1 */

        case 2:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5825; /* *avx512fp16_vpternlogv8hf_1 */

        case 3:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5852; /* *avx512bw_vpternlogv32bf_1 */

        case 4:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5879; /* *avx512vl_vpternlogv16bf_1 */

        case 5:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5906; /* *avx512vl_vpternlogv8bf_1 */

        case 6:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5933; /* *avx512f_vpternlogv16sf_1 */

        case 7:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5960; /* *avx512vl_vpternlogv8sf_1 */

        case 8:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5987; /* *avx512vl_vpternlogv4sf_1 */

        case 9:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6014; /* *avx512f_vpternlogv8df_1 */

        case 10:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6041; /* *avx512vl_vpternlogv4df_1 */

        case 11:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6068; /* *avx512vl_vpternlogv2df_1 */

        case 12:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5774; /* *avx512bw_vpternlogv32hf_1 */

        case 13:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5801; /* *avx512vl_vpternlogv16hf_1 */

        case 14:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5828; /* *avx512fp16_vpternlogv8hf_1 */

        case 15:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5855; /* *avx512bw_vpternlogv32bf_1 */

        case 16:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5882; /* *avx512vl_vpternlogv16bf_1 */

        case 17:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5909; /* *avx512vl_vpternlogv8bf_1 */

        case 18:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5936; /* *avx512f_vpternlogv16sf_1 */

        case 19:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5963; /* *avx512vl_vpternlogv8sf_1 */

        case 20:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5990; /* *avx512vl_vpternlogv4sf_1 */

        case 21:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6017; /* *avx512f_vpternlogv8df_1 */

        case 22:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6044; /* *avx512vl_vpternlogv4df_1 */

        case 23:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6071; /* *avx512vl_vpternlogv2df_1 */

        case 24:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5777; /* *avx512bw_vpternlogv32hf_1 */

        case 25:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5804; /* *avx512vl_vpternlogv16hf_1 */

        case 26:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5831; /* *avx512fp16_vpternlogv8hf_1 */

        case 27:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5858; /* *avx512bw_vpternlogv32bf_1 */

        case 28:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5885; /* *avx512vl_vpternlogv16bf_1 */

        case 29:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5912; /* *avx512vl_vpternlogv8bf_1 */

        case 30:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5939; /* *avx512f_vpternlogv16sf_1 */

        case 31:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5966; /* *avx512vl_vpternlogv8sf_1 */

        case 32:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5993; /* *avx512vl_vpternlogv4sf_1 */

        case 33:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6020; /* *avx512f_vpternlogv8df_1 */

        case 34:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6047; /* *avx512vl_vpternlogv4df_1 */

        case 35:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6074; /* *avx512vl_vpternlogv2df_1 */

        case 36:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6839; /* *avx512bw_vpternlogv32hf_3 */

        case 37:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6848; /* *avx512vl_vpternlogv16hf_3 */

        case 38:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6857; /* *avx512fp16_vpternlogv8hf_3 */

        case 39:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6866; /* *avx512bw_vpternlogv32bf_3 */

        case 40:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6875; /* *avx512vl_vpternlogv16bf_3 */

        case 41:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6884; /* *avx512vl_vpternlogv8bf_3 */

        case 42:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6893; /* *avx512f_vpternlogv16sf_3 */

        case 43:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6902; /* *avx512vl_vpternlogv8sf_3 */

        case 44:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6911; /* *avx512vl_vpternlogv4sf_3 */

        case 45:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6920; /* *avx512f_vpternlogv8df_3 */

        case 46:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6929; /* *avx512vl_vpternlogv4df_3 */

        case 47:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6938; /* *avx512vl_vpternlogv2df_3 */

        default:
          return -1;
        }

    case AND:
      switch (pattern534 (x2))
        {
        case 0:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6419; /* *avx512bw_vpternlogv32hf_2 */

        case 1:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6446; /* *avx512vl_vpternlogv16hf_2 */

        case 2:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6473; /* *avx512fp16_vpternlogv8hf_2 */

        case 3:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6500; /* *avx512bw_vpternlogv32bf_2 */

        case 4:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6527; /* *avx512vl_vpternlogv16bf_2 */

        case 5:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6554; /* *avx512vl_vpternlogv8bf_2 */

        case 6:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6581; /* *avx512f_vpternlogv16sf_2 */

        case 7:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6608; /* *avx512vl_vpternlogv8sf_2 */

        case 8:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6635; /* *avx512vl_vpternlogv4sf_2 */

        case 9:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6662; /* *avx512f_vpternlogv8df_2 */

        case 10:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6689; /* *avx512vl_vpternlogv4df_2 */

        case 11:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6716; /* *avx512vl_vpternlogv2df_2 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern534 (x2))
        {
        case 0:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6422; /* *avx512bw_vpternlogv32hf_2 */

        case 1:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6449; /* *avx512vl_vpternlogv16hf_2 */

        case 2:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6476; /* *avx512fp16_vpternlogv8hf_2 */

        case 3:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6503; /* *avx512bw_vpternlogv32bf_2 */

        case 4:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6530; /* *avx512vl_vpternlogv16bf_2 */

        case 5:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6557; /* *avx512vl_vpternlogv8bf_2 */

        case 6:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6584; /* *avx512f_vpternlogv16sf_2 */

        case 7:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6611; /* *avx512vl_vpternlogv8sf_2 */

        case 8:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6638; /* *avx512vl_vpternlogv4sf_2 */

        case 9:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6665; /* *avx512f_vpternlogv8df_2 */

        case 10:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6692; /* *avx512vl_vpternlogv4df_2 */

        case 11:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6719; /* *avx512vl_vpternlogv2df_2 */

        default:
          return -1;
        }

    case XOR:
      switch (pattern534 (x2))
        {
        case 0:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6425; /* *avx512bw_vpternlogv32hf_2 */

        case 1:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6452; /* *avx512vl_vpternlogv16hf_2 */

        case 2:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6479; /* *avx512fp16_vpternlogv8hf_2 */

        case 3:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6506; /* *avx512bw_vpternlogv32bf_2 */

        case 4:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6533; /* *avx512vl_vpternlogv16bf_2 */

        case 5:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6560; /* *avx512vl_vpternlogv8bf_2 */

        case 6:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6587; /* *avx512f_vpternlogv16sf_2 */

        case 7:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6614; /* *avx512vl_vpternlogv8sf_2 */

        case 8:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6641; /* *avx512vl_vpternlogv4sf_2 */

        case 9:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6668; /* *avx512f_vpternlogv8df_2 */

        case 10:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6695; /* *avx512vl_vpternlogv4df_2 */

        case 11:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6722; /* *avx512vl_vpternlogv2df_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_317 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47, x48, x49;
  rtx x50, x51, x52, x53, x54, x55, x56, x57;
  rtx x58, x59, x60, x61, x62, x63, x64, x65;
  rtx x66, x67, x68, x69;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  x5 = XEXP (x2, 0);
  switch (GET_CODE (x5))
    {
    case VEC_CONCAT:
      x6 = XEXP (x5, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x6;
          res = recog_281 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          if (XVECLEN (x3, 0) < 1)
            return -1;
          operands[4] = x3;
          switch (pattern801 (x2))
            {
            case 0:
              if (
#line 24156 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return 8685; /* *avx2_zero_extendv16qiv16hi2_2 */
              break;

            case 1:
              if (
#line 24156 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return 8686; /* *avx2_zero_extendv16qiv16hi2_2 */
              break;

            case 2:
              if (
#line 24156 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return 8687; /* *avx2_zero_extendv16qiv16hi2_2 */
              break;

            case 3:
              if ((
#line 24209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 953 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 8693; /* *avx512bw_zero_extendv32qiv32hi2_2 */
              break;

            case 4:
              if ((
#line 24209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 953 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 8694; /* *avx512bw_zero_extendv32qiv32hi2_2 */
              break;

            case 5:
              if ((
#line 24209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 953 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 8695; /* *avx512bw_zero_extendv32qiv32hi2_2 */
              break;

            case 6:
              if (
#line 24320 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                return 8709; /* *sse4_1_zero_extendv8qiv8hi2_4 */
              break;

            case 7:
              if (
#line 24320 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                return 8710; /* *sse4_1_zero_extendv8qiv8hi2_4 */
              break;

            case 8:
              if (
#line 24320 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                return 8711; /* *sse4_1_zero_extendv8qiv8hi2_4 */
              break;

            case 9:
              if ((
#line 24553 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 956 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 8745; /* *avx512f_zero_extendv16hiv16si2_2 */
              break;

            case 10:
              if ((
#line 24553 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 956 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 8746; /* *avx512f_zero_extendv16hiv16si2_2 */
              break;

            case 11:
              if ((
#line 24553 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 956 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 8747; /* *avx512f_zero_extendv16hiv16si2_2 */
              break;

            case 12:
              if (
#line 24607 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return 8753; /* *avx2_zero_extendv8hiv8si2_2 */
              break;

            case 13:
              if (
#line 24607 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return 8754; /* *avx2_zero_extendv8hiv8si2_2 */
              break;

            case 14:
              if (
#line 24607 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return 8755; /* *avx2_zero_extendv8hiv8si2_2 */
              break;

            case 15:
              if (
#line 24725 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                return 8769; /* *sse4_1_zero_extendv4hiv4si2_4 */
              break;

            case 16:
              if (
#line 24725 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                return 8770; /* *sse4_1_zero_extendv4hiv4si2_4 */
              break;

            case 17:
              if (
#line 24725 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                return 8771; /* *sse4_1_zero_extendv4hiv4si2_4 */
              break;

            default:
              break;
            }
          operands[3] = x3;
          switch (pattern802 (x2))
            {
            case 0:
              if (!(
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 9549; /* *vec_concatv64qi_0_1 */

            case 1:
              if (!(
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9550; /* *vec_concatv32qi_0_1 */

            case 2:
              if (!
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                return -1;
              return 9551; /* *vec_concatv16qi_0_1 */

            case 3:
              if (!(
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 9552; /* *vec_concatv32hi_0_1 */

            case 4:
              if (!(
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9553; /* *vec_concatv16hi_0_1 */

            case 5:
              if (!
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                return -1;
              return 9554; /* *vec_concatv8hi_0_1 */

            default:
              return -1;
            }

        case SS_TRUNCATE:
          x7 = XEXP (x5, 1);
          if (GET_CODE (x7) != SS_TRUNCATE)
            return -1;
          x8 = XEXP (x6, 0);
          operands[1] = x8;
          x9 = XEXP (x7, 0);
          operands[2] = x9;
          switch (XVECLEN (x3, 0))
            {
            case 32:
              if (pattern828 (x3) != 0)
                return -1;
              x10 = XVECEXP (x3, 0, 4);
              if (GET_CODE (x10) != CONST_INT)
                return -1;
              x11 = XVECEXP (x3, 0, 5);
              if (GET_CODE (x11) != CONST_INT)
                return -1;
              x12 = XVECEXP (x3, 0, 6);
              if (GET_CODE (x12) != CONST_INT)
                return -1;
              x13 = XVECEXP (x3, 0, 7);
              if (GET_CODE (x13) != CONST_INT)
                return -1;
              x14 = XVECEXP (x3, 0, 8);
              if (GET_CODE (x14) != CONST_INT)
                return -1;
              x15 = XVECEXP (x3, 0, 9);
              if (GET_CODE (x15) != CONST_INT)
                return -1;
              x16 = XVECEXP (x3, 0, 10);
              if (GET_CODE (x16) != CONST_INT)
                return -1;
              x17 = XVECEXP (x3, 0, 11);
              if (GET_CODE (x17) != CONST_INT
                  || pattern1673 (x3, 
23, 
22, 
21, 
20, 
8) != 0)
                return -1;
              x18 = XVECEXP (x3, 0, 17);
              if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
                return -1;
              x19 = XVECEXP (x3, 0, 18);
              if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
                return -1;
              x20 = XVECEXP (x3, 0, 19);
              if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
                return -1;
              x21 = XVECEXP (x3, 0, 20);
              if (GET_CODE (x21) != CONST_INT)
                return -1;
              x22 = XVECEXP (x3, 0, 21);
              if (GET_CODE (x22) != CONST_INT)
                return -1;
              x23 = XVECEXP (x3, 0, 22);
              if (GET_CODE (x23) != CONST_INT)
                return -1;
              x24 = XVECEXP (x3, 0, 23);
              if (GET_CODE (x24) != CONST_INT)
                return -1;
              x25 = XVECEXP (x3, 0, 24);
              if (GET_CODE (x25) != CONST_INT)
                return -1;
              x26 = XVECEXP (x3, 0, 25);
              if (GET_CODE (x26) != CONST_INT)
                return -1;
              x27 = XVECEXP (x3, 0, 26);
              if (GET_CODE (x27) != CONST_INT)
                return -1;
              x28 = XVECEXP (x3, 0, 27);
              if (GET_CODE (x28) != CONST_INT
                  || pattern1844 (x3, 
31, 
30, 
29, 
28) != 0)
                return -1;
              switch (XWINT (x10, 0))
                {
                case 4L:
                  if (XWINT (x11, 0) != 5L
                      || XWINT (x12, 0) != 6L
                      || XWINT (x13, 0) != 7L
                      || XWINT (x14, 0) != 16L
                      || XWINT (x15, 0) != 17L
                      || XWINT (x16, 0) != 18L
                      || XWINT (x17, 0) != 19L
                      || XWINT (x21, 0) != 12L
                      || XWINT (x22, 0) != 13L
                      || XWINT (x23, 0) != 14L
                      || XWINT (x24, 0) != 15L
                      || pattern1869 (x3) != 0
                      || pattern1801 (x2, 
E_V16HImode, 
E_V16QImode, 
E_V32QImode) != 0
                      || !
#line 19232 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1 && 1))
                    return -1;
                  return 8230; /* avx2_packsswb */

                case 16L:
                  if (XWINT (x11, 0) != 17L
                      || XWINT (x12, 0) != 18L
                      || XWINT (x13, 0) != 19L
                      || XWINT (x14, 0) != 4L
                      || XWINT (x15, 0) != 5L
                      || XWINT (x16, 0) != 6L
                      || XWINT (x17, 0) != 7L
                      || XWINT (x21, 0) != 24L
                      || XWINT (x22, 0) != 25L
                      || XWINT (x23, 0) != 26L
                      || XWINT (x24, 0) != 27L
                      || XWINT (x25, 0) != 12L
                      || XWINT (x26, 0) != 13L
                      || XWINT (x27, 0) != 14L
                      || XWINT (x28, 0) != 15L
                      || pattern1801 (x2, 
E_V16SImode, 
E_V16HImode, 
E_V32HImode) != 0
                      || !
#line 19348 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
                    return -1;
                  return 8238; /* avx512bw_packssdw */

                default:
                  return -1;
                }

            case 64:
              if (pattern831 (x3, 
35, 
34, 
33, 
32) != 0
                  || pattern1673 (x3, 
39, 
38, 
37, 
36, 
8) != 0
                  || pattern1784 (x3, 
13, 
12, 
11, 
10, 
9) != 0
                  || pattern1826 (x3, 
42, 
41, 
40, 
15, 
14) != 0)
                return -1;
              x28 = XVECEXP (x3, 0, 27);
              if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 43]
                  || pattern1844 (x3, 
47, 
46, 
45, 
44) != 0)
                return -1;
              x29 = XVECEXP (x3, 0, 32);
              if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 16])
                return -1;
              x30 = XVECEXP (x3, 0, 33);
              if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 17])
                return -1;
              x31 = XVECEXP (x3, 0, 34);
              if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 18])
                return -1;
              x32 = XVECEXP (x3, 0, 35);
              if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 19])
                return -1;
              x33 = XVECEXP (x3, 0, 36);
              if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 20])
                return -1;
              x34 = XVECEXP (x3, 0, 37);
              if (x34 != const_int_rtx[MAX_SAVED_CONST_INT + 21])
                return -1;
              x35 = XVECEXP (x3, 0, 38);
              if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 22])
                return -1;
              x36 = XVECEXP (x3, 0, 39);
              if (x36 != const_int_rtx[MAX_SAVED_CONST_INT + 23])
                return -1;
              x37 = XVECEXP (x3, 0, 40);
              if (x37 != const_int_rtx[MAX_SAVED_CONST_INT + 48])
                return -1;
              x38 = XVECEXP (x3, 0, 41);
              if (x38 != const_int_rtx[MAX_SAVED_CONST_INT + 49])
                return -1;
              x39 = XVECEXP (x3, 0, 42);
              if (x39 != const_int_rtx[MAX_SAVED_CONST_INT + 50])
                return -1;
              x40 = XVECEXP (x3, 0, 43);
              if (x40 != const_int_rtx[MAX_SAVED_CONST_INT + 51])
                return -1;
              x41 = XVECEXP (x3, 0, 44);
              if (x41 != const_int_rtx[MAX_SAVED_CONST_INT + 52])
                return -1;
              x42 = XVECEXP (x3, 0, 45);
              if (x42 != const_int_rtx[MAX_SAVED_CONST_INT + 53])
                return -1;
              x43 = XVECEXP (x3, 0, 46);
              if (x43 != const_int_rtx[MAX_SAVED_CONST_INT + 54])
                return -1;
              x44 = XVECEXP (x3, 0, 47);
              if (x44 != const_int_rtx[MAX_SAVED_CONST_INT + 55])
                return -1;
              x45 = XVECEXP (x3, 0, 48);
              if (x45 != const_int_rtx[MAX_SAVED_CONST_INT + 24])
                return -1;
              x46 = XVECEXP (x3, 0, 49);
              if (x46 != const_int_rtx[MAX_SAVED_CONST_INT + 25])
                return -1;
              x47 = XVECEXP (x3, 0, 50);
              if (x47 != const_int_rtx[MAX_SAVED_CONST_INT + 26])
                return -1;
              x48 = XVECEXP (x3, 0, 51);
              if (x48 != const_int_rtx[MAX_SAVED_CONST_INT + 27])
                return -1;
              x49 = XVECEXP (x3, 0, 52);
              if (x49 != const_int_rtx[MAX_SAVED_CONST_INT + 28])
                return -1;
              x50 = XVECEXP (x3, 0, 53);
              if (x50 != const_int_rtx[MAX_SAVED_CONST_INT + 29])
                return -1;
              x51 = XVECEXP (x3, 0, 54);
              if (x51 != const_int_rtx[MAX_SAVED_CONST_INT + 30])
                return -1;
              x52 = XVECEXP (x3, 0, 55);
              if (x52 != const_int_rtx[MAX_SAVED_CONST_INT + 31])
                return -1;
              x53 = XVECEXP (x3, 0, 56);
              if (x53 != const_int_rtx[MAX_SAVED_CONST_INT + 56])
                return -1;
              x54 = XVECEXP (x3, 0, 57);
              if (x54 != const_int_rtx[MAX_SAVED_CONST_INT + 57])
                return -1;
              x55 = XVECEXP (x3, 0, 58);
              if (x55 != const_int_rtx[MAX_SAVED_CONST_INT + 58])
                return -1;
              x56 = XVECEXP (x3, 0, 59);
              if (x56 != const_int_rtx[MAX_SAVED_CONST_INT + 59])
                return -1;
              x57 = XVECEXP (x3, 0, 60);
              if (x57 != const_int_rtx[MAX_SAVED_CONST_INT + 60])
                return -1;
              x58 = XVECEXP (x3, 0, 61);
              if (x58 != const_int_rtx[MAX_SAVED_CONST_INT + 61])
                return -1;
              x59 = XVECEXP (x3, 0, 62);
              if (x59 != const_int_rtx[MAX_SAVED_CONST_INT + 62])
                return -1;
              x60 = XVECEXP (x3, 0, 63);
              if (x60 != const_int_rtx[MAX_SAVED_CONST_INT + 63]
                  || pattern1801 (x2, 
E_V32HImode, 
E_V32QImode, 
E_V64QImode) != 0
                  || !
#line 19279 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
                return -1;
              return 8232; /* avx512bw_packsswb */

            case 16:
              if (pattern829 (x3, 
10, 
9, 
8) != 0
                  || pattern1491 (x3, 
7, 
6, 
5, 
4, 
11) != 0
                  || pattern1801 (x2, 
E_V8SImode, 
E_V8HImode, 
E_V16HImode) != 0
                  || !
#line 19318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1 && 1))
                return -1;
              return 8236; /* avx2_packssdw */

            default:
              return -1;
            }

        case VEC_CONCAT:
          switch (pattern521 (x2))
            {
            case 0:
              if (!
#line 25108 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                return -1;
              return 8840; /* *avx512f_zero_extendv8siv8di2_2 */

            case 1:
              if (!
#line 25160 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
                return -1;
              return 8846; /* *avx2_zero_extendv4siv4di2_2 */

            case 2:
              if (!
#line 25256 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                return -1;
              return 8860; /* *sse4_1_zero_extendv2siv2di2_4 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x5;
      res = recog_295 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (GET_CODE (x5) != SUBREG)
        return -1;
      switch (pattern523 (x2))
        {
        case 0:
          if (!
#line 15021 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512 && ix86_pre_reload_split ()))
            return -1;
          return 7163; /* *avx512bw_permvar_truncv16siv16hi_1_hf */

        case 1:
          if (!
#line 15074 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW && ix86_pre_reload_split ()))
            return -1;
          return 7165; /* *avx512f_permvar_truncv8siv8hi_1_hf */

        default:
          return -1;
        }

    case UNSPEC:
      switch (XVECLEN (x5, 0))
        {
        case 2:
          switch (pattern525 (x2))
            {
            case 0:
              if (!
#line 14996 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512 && ix86_pre_reload_split ()))
                return -1;
              return 7162; /* *avx512bw_permvar_truncv16siv16hi_1 */

            case 1:
              if (!
#line 15258 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512VBMI
   && ix86_pre_reload_split ()))
                return -1;
              return 7195; /* *avx512f_permvar_truncv16hiv16qi_1 */

            case 2:
              if (!
#line 15053 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW && ix86_pre_reload_split ()))
                return -1;
              return 7164; /* *avx512f_permvar_truncv8siv8hi_1 */

            case 3:
              if (!
#line 15105 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512 && ix86_pre_reload_split ()))
                return -1;
              return 7166; /* *avx512f_vpermvar_truncv8div8si_1 */

            case 4:
              if (!
#line 15177 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI && TARGET_EVEX512 && ix86_pre_reload_split ()))
                return -1;
              return 7182; /* *avx512f_permvar_truncv32hiv32qi_1 */

            case 5:
              if (!
#line 15277 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()))
                return -1;
              return 7196; /* *avx512f_permvar_truncv4div4si_1 */

            default:
              return -1;
            }

        case 1:
          if (XINT (x5, 1) != 149
              || GET_MODE (x5) != E_V8SFmode
              || XVECLEN (x3, 0) != 4
              || pattern828 (x3) != 0
              || !register_operand (operands[0], E_V4SFmode)
              || GET_MODE (x2) != E_V4SFmode)
            return -1;
          x61 = XVECEXP (x5, 0, 0);
          operands[1] = x61;
          if (!register_operand (operands[1], E_V8HImode)
              || !
#line 29080 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL))
            return -1;
          return 9573; /* vcvtph2ps */

        case 4:
          if (pnum_clobbers == NULL
              || XINT (x5, 1) != 153)
            return -1;
          x62 = XVECEXP (x5, 0, 1);
          if (GET_CODE (x62) != MEM)
            return -1;
          x63 = XEXP (x62, 0);
          if (GET_CODE (x63) != UNSPEC
              || XVECLEN (x63, 0) != 3
              || XINT (x63, 1) != 154)
            return -1;
          x64 = XVECEXP (x5, 0, 2);
          if (GET_CODE (x64) != MEM
              || GET_MODE (x64) != E_BLKmode)
            return -1;
          x65 = XEXP (x64, 0);
          if (GET_CODE (x65) != SCRATCH
              || XVECLEN (x3, 0) != 4
              || pattern828 (x3) != 0)
            return -1;
          x66 = XVECEXP (x63, 0, 1);
          if (!register_operand (x66, E_V4DImode))
            return -1;
          x67 = XVECEXP (x63, 0, 2);
          if (!const1248_operand (x67, E_SImode))
            return -1;
          x61 = XVECEXP (x5, 0, 0);
          switch (GET_CODE (x61))
            {
            case REG:
            case SUBREG:
              operands[2] = x61;
              operands[7] = x62;
              x68 = XVECEXP (x63, 0, 0);
              operands[3] = x68;
              operands[4] = x66;
              operands[6] = x67;
              x69 = XVECEXP (x5, 0, 3);
              operands[5] = x69;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SImode:
                  switch (pattern1821 (x2, 
E_V4SImode, 
E_SImode, 
E_V8SImode))
                    {
                    case 0:
                      if (!(
#line 29407 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9660; /* *avx2_gatherdiv8si_3 */

                    case 1:
                      if (!(
#line 29407 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9662; /* *avx2_gatherdiv8si_3 */

                    default:
                      return -1;
                    }

                case E_V4SFmode:
                  switch (pattern1821 (x2, 
E_V4SFmode, 
E_SFmode, 
E_V8SFmode))
                    {
                    case 0:
                      if (!(
#line 29407 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9661; /* *avx2_gatherdiv8sf_3 */

                    case 1:
                      if (!(
#line 29407 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9663; /* *avx2_gatherdiv8sf_3 */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case PC:
              operands[6] = x62;
              x68 = XVECEXP (x63, 0, 0);
              operands[2] = x68;
              operands[3] = x66;
              operands[5] = x67;
              x69 = XVECEXP (x5, 0, 3);
              operands[4] = x69;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SImode:
                  switch (pattern1815 (x2, 
E_V4SImode, 
E_SImode, 
E_V8SImode))
                    {
                    case 0:
                      if (!(
#line 29431 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9664; /* *avx2_gatherdiv8si_4 */

                    case 1:
                      if (!(
#line 29431 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9666; /* *avx2_gatherdiv8si_4 */

                    default:
                      return -1;
                    }

                case E_V4SFmode:
                  switch (pattern1815 (x2, 
E_V4SFmode, 
E_SFmode, 
E_V8SFmode))
                    {
                    case 0:
                      if (!(
#line 29431 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9665; /* *avx2_gatherdiv8sf_4 */

                    case 1:
                      if (!(
#line 29431 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                        return -1;
                      *pnum_clobbers = 1;
                      return 9667; /* *avx2_gatherdiv8sf_4 */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_322 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 1);
  operands[2] = x4;
  x5 = XEXP (x3, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      return recog_270 (x1, insn, pnum_clobbers);

    case NEG:
      x6 = XEXP (x5, 0);
      operands[1] = x6;
      x7 = XEXP (x3, 2);
      switch (GET_CODE (x7))
        {
        case REG:
        case SUBREG:
        case MEM:
        case VEC_DUPLICATE:
          operands[3] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (!register_operand (operands[0], E_V4SFmode)
                  || GET_MODE (x3) != E_V4SFmode
                  || GET_MODE (x5) != E_V4SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4SFmode)
                  && nonimmediate_operand (operands[2], E_V4SFmode)
                  && nonimmediate_operand (operands[3], E_V4SFmode)
                  && 
#line 6123 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3888; /* *fma_fnmadd_v4sf */
              if (!bcst_vector_operand (operands[1], E_V4SFmode)
                  || !bcst_vector_operand (operands[2], E_V4SFmode)
                  || !bcst_vector_operand (operands[3], E_V4SFmode)
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3908; /* *fma_fnmadd_v4sf */

            case E_V2DFmode:
              if (!register_operand (operands[0], E_V2DFmode)
                  || GET_MODE (x3) != E_V2DFmode
                  || GET_MODE (x5) != E_V2DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_V2DFmode)
                  && nonimmediate_operand (operands[2], E_V2DFmode)
                  && nonimmediate_operand (operands[3], E_V2DFmode)
                  && 
#line 6123 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3889; /* *fma_fnmadd_v2df */
              if (!bcst_vector_operand (operands[1], E_V2DFmode)
                  || !bcst_vector_operand (operands[2], E_V2DFmode)
                  || !bcst_vector_operand (operands[3], E_V2DFmode)
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3917; /* *fma_fnmadd_v2df */

            case E_V8SFmode:
              if (!register_operand (operands[0], E_V8SFmode)
                  || GET_MODE (x3) != E_V8SFmode
                  || GET_MODE (x5) != E_V8SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_V8SFmode)
                  && nonimmediate_operand (operands[2], E_V8SFmode)
                  && nonimmediate_operand (operands[3], E_V8SFmode)
                  && 
#line 6123 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3890; /* *fma_fnmadd_v8sf */
              if (!bcst_vector_operand (operands[1], E_V8SFmode)
                  || !bcst_vector_operand (operands[2], E_V8SFmode)
                  || !bcst_vector_operand (operands[3], E_V8SFmode)
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3906; /* *fma_fnmadd_v8sf */

            case E_V4DFmode:
              if (!register_operand (operands[0], E_V4DFmode)
                  || GET_MODE (x3) != E_V4DFmode
                  || GET_MODE (x5) != E_V4DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4DFmode)
                  && nonimmediate_operand (operands[2], E_V4DFmode)
                  && nonimmediate_operand (operands[3], E_V4DFmode)
                  && 
#line 6123 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3891; /* *fma_fnmadd_v4df */
              if (!bcst_vector_operand (operands[1], E_V4DFmode)
                  || !bcst_vector_operand (operands[2], E_V4DFmode)
                  || !bcst_vector_operand (operands[3], E_V4DFmode)
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3915; /* *fma_fnmadd_v4df */

            case E_V32HFmode:
              if (pattern859 (x3, 
E_V32HFmode) != 0
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5931 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 3892; /* *fma_fnmadd_v32hf */

            case E_V16HFmode:
              if (pattern859 (x3, 
E_V16HFmode) != 0
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3896; /* *fma_fnmadd_v16hf */

            case E_V8HFmode:
              if (pattern859 (x3, 
E_V8HFmode) != 0
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5933 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3898; /* *fma_fnmadd_v8hf */

            case E_V16SFmode:
              if (pattern859 (x3, 
E_V16SFmode) != 0
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5935 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3902; /* *fma_fnmadd_v16sf */

            case E_V8DFmode:
              if (pattern859 (x3, 
E_V8DFmode) != 0
                  || !(
#line 6155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5937 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3911; /* *fma_fnmadd_v8df */

            case E_V32BFmode:
              if (pattern914 (x3, 
E_V32BFmode) != 0
                  || !
#line 32219 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10566; /* avx10_2_fnmaddbf16_v32bf */

            case E_V16BFmode:
              if (pattern914 (x3, 
E_V16BFmode) != 0
                  || !
#line 32219 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10568; /* avx10_2_fnmaddbf16_v16bf */

            case E_V8BFmode:
              if (pattern914 (x3, 
E_V8BFmode) != 0
                  || !
#line 32219 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10570; /* avx10_2_fnmaddbf16_v8bf */

            default:
              return -1;
            }

        case NEG:
          x8 = XEXP (x7, 0);
          operands[3] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern860 (x3, 
E_V4SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4SFmode)
                  && nonimmediate_operand (operands[2], E_V4SFmode)
                  && nonimmediate_operand (operands[3], E_V4SFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3947; /* *fma_fnmsub_v4sf */
              if (!bcst_vector_operand (operands[1], E_V4SFmode)
                  || !bcst_vector_operand (operands[2], E_V4SFmode)
                  || !bcst_vector_operand (operands[3], E_V4SFmode)
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3979; /* *fma_fnmsub_v4sf */

            case E_V2DFmode:
              if (pattern860 (x3, 
E_V2DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V2DFmode)
                  && nonimmediate_operand (operands[2], E_V2DFmode)
                  && nonimmediate_operand (operands[3], E_V2DFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3951; /* *fma_fnmsub_v2df */
              if (!bcst_vector_operand (operands[1], E_V2DFmode)
                  || !bcst_vector_operand (operands[2], E_V2DFmode)
                  || !bcst_vector_operand (operands[3], E_V2DFmode)
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3988; /* *fma_fnmsub_v2df */

            case E_V8SFmode:
              if (pattern860 (x3, 
E_V8SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V8SFmode)
                  && nonimmediate_operand (operands[2], E_V8SFmode)
                  && nonimmediate_operand (operands[3], E_V8SFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3955; /* *fma_fnmsub_v8sf */
              if (!bcst_vector_operand (operands[1], E_V8SFmode)
                  || !bcst_vector_operand (operands[2], E_V8SFmode)
                  || !bcst_vector_operand (operands[3], E_V8SFmode)
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3977; /* *fma_fnmsub_v8sf */

            case E_V4DFmode:
              if (pattern860 (x3, 
E_V4DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4DFmode)
                  && nonimmediate_operand (operands[2], E_V4DFmode)
                  && nonimmediate_operand (operands[3], E_V4DFmode)
                  && 
#line 6230 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3959; /* *fma_fnmsub_v4df */
              if (!bcst_vector_operand (operands[1], E_V4DFmode)
                  || !bcst_vector_operand (operands[2], E_V4DFmode)
                  || !bcst_vector_operand (operands[3], E_V4DFmode)
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3986; /* *fma_fnmsub_v4df */

            case E_V32HFmode:
              if (pattern861 (x3, 
E_V32HFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5931 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 3963; /* *fma_fnmsub_v32hf */

            case E_V16HFmode:
              if (pattern861 (x3, 
E_V16HFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3967; /* *fma_fnmsub_v16hf */

            case E_V8HFmode:
              if (pattern861 (x3, 
E_V8HFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5933 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3969; /* *fma_fnmsub_v8hf */

            case E_V16SFmode:
              if (pattern861 (x3, 
E_V16SFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5935 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3973; /* *fma_fnmsub_v16sf */

            case E_V8DFmode:
              if (pattern861 (x3, 
E_V8DFmode) != 0
                  || !(
#line 6263 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5937 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3982; /* *fma_fnmsub_v8df */

            case E_V32BFmode:
              if (pattern915 (x3, 
E_V32BFmode) != 0
                  || !
#line 32350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10590; /* avx10_2_fnmsubbf16_v32bf */

            case E_V16BFmode:
              if (pattern915 (x3, 
E_V16BFmode) != 0
                  || !
#line 32350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10592; /* avx10_2_fnmsubbf16_v16bf */

            case E_V8BFmode:
              if (pattern915 (x3, 
E_V8BFmode) != 0
                  || !
#line 32350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10594; /* avx10_2_fnmsubbf16_v8bf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_327 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[3] = x4;
      x5 = XEXP (x3, 1);
      operands[1] = x5;
      x6 = XEXP (x3, 2);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V32QImode:
          if (pattern806 (x3, 
E_V32QImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8924; /* xop_pcmov_v32qi256 */

        case E_V16QImode:
          if (pattern806 (x3, 
E_V16QImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8925; /* xop_pcmov_v16qi */

        case E_V16HImode:
          if (pattern806 (x3, 
E_V16HImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8926; /* xop_pcmov_v16hi256 */

        case E_V8HImode:
          if (pattern806 (x3, 
E_V8HImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8927; /* xop_pcmov_v8hi */

        case E_V8SImode:
          if (pattern806 (x3, 
E_V8SImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8928; /* xop_pcmov_v8si256 */

        case E_V4SImode:
          if (pattern806 (x3, 
E_V4SImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8929; /* xop_pcmov_v4si */

        case E_V4DImode:
          if (pattern806 (x3, 
E_V4DImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8930; /* xop_pcmov_v4di256 */

        case E_V2DImode:
          if (pattern806 (x3, 
E_V2DImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8931; /* xop_pcmov_v2di */

        case E_V2TImode:
          if (pattern806 (x3, 
E_V2TImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8932; /* xop_pcmov_v2ti256 */

        case E_V1TImode:
          if (pattern806 (x3, 
E_V1TImode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8933; /* xop_pcmov_v1ti */

        case E_V16HFmode:
          if (pattern806 (x3, 
E_V16HFmode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8934; /* xop_pcmov_v16hf256 */

        case E_V8HFmode:
          if (pattern806 (x3, 
E_V8HFmode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8935; /* xop_pcmov_v8hf */

        case E_V8SFmode:
          if (pattern806 (x3, 
E_V8SFmode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8936; /* xop_pcmov_v8sf256 */

        case E_V4SFmode:
          if (pattern806 (x3, 
E_V4SFmode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8937; /* xop_pcmov_v4sf */

        case E_V4DFmode:
          if (pattern806 (x3, 
E_V4DFmode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8938; /* xop_pcmov_v4df256 */

        case E_V2DFmode:
          if (pattern806 (x3, 
E_V2DFmode) != 0
              || !
#line 26215 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8939; /* xop_pcmov_v2df */

        default:
          return -1;
        }

    case GE:
      x7 = XEXP (x4, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x8 = XEXP (x4, 0);
      operands[2] = x8;
      x5 = XEXP (x3, 1);
      switch (GET_CODE (x5))
        {
        case ROTATE:
          x6 = XEXP (x3, 2);
          if (GET_CODE (x6) != ROTATERT)
            return -1;
          x9 = XEXP (x6, 1);
          if (GET_CODE (x9) != NEG)
            return -1;
          x10 = XEXP (x5, 0);
          operands[1] = x10;
          x11 = XEXP (x5, 1);
          if (!rtx_equal_p (x11, operands[2]))
            return -1;
          switch (pattern1132 (x3))
            {
            case 0:
              if (!
#line 26661 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 8967; /* xop_vrotlv16qi3 */

            case 1:
              if (!
#line 26661 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 8968; /* xop_vrotlv8hi3 */

            case 2:
              if (!
#line 26661 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 8969; /* xop_vrotlv4si3 */

            case 3:
              if (!
#line 26661 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 8970; /* xop_vrotlv2di3 */

            default:
              return -1;
            }

        case ASHIFT:
          x10 = XEXP (x5, 0);
          operands[1] = x10;
          x11 = XEXP (x5, 1);
          if (!rtx_equal_p (x11, operands[2]))
            return -1;
          x6 = XEXP (x3, 2);
          switch (GET_CODE (x6))
            {
            case ASHIFTRT:
              x9 = XEXP (x6, 1);
              if (GET_CODE (x9) != NEG)
                return -1;
              switch (pattern1132 (x3))
                {
                case 0:
                  if (!
#line 26898 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8971; /* xop_shav16qi3 */

                case 1:
                  if (!
#line 26898 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8972; /* xop_shav8hi3 */

                case 2:
                  if (!
#line 26898 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8973; /* xop_shav4si3 */

                case 3:
                  if (!
#line 26898 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8974; /* xop_shav2di3 */

                default:
                  return -1;
                }

            case LSHIFTRT:
              x9 = XEXP (x6, 1);
              if (GET_CODE (x9) != NEG)
                return -1;
              switch (pattern1132 (x3))
                {
                case 0:
                  if (!
#line 26917 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8975; /* xop_shlv16qi3 */

                case 1:
                  if (!
#line 26917 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8976; /* xop_shlv8hi3 */

                case 2:
                  if (!
#line 26917 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8977; /* xop_shlv4si3 */

                case 3:
                  if (!
#line 26917 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8978; /* xop_shlv2di3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_332 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      if (!register_operand (operands[0], E_V64QImode)
          || GET_MODE (x3) != E_V64QImode
          || !vector_operand (operands[1], E_V64QImode)
          || !(
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 23344 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
        return -1;
      return 8574; /* *absv64qi2 */

    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode)
          || GET_MODE (x3) != E_V32QImode
          || !vector_operand (operands[1], E_V32QImode)
          || !(
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 23344 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 8575; /* *absv32qi2 */

    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode
          || !vector_operand (operands[1], E_V16QImode)
          || !
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 8576; /* *absv16qi2 */

    case E_V32HImode:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x3) != E_V32HImode
          || !vector_operand (operands[1], E_V32HImode)
          || !(
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 23345 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
        return -1;
      return 8577; /* *absv32hi2 */

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x3) != E_V16HImode
          || !vector_operand (operands[1], E_V16HImode)
          || !(
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 23345 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 8578; /* *absv16hi2 */

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode
          || !vector_operand (operands[1], E_V8HImode)
          || !
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 8579; /* *absv8hi2 */

    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x3) != E_V16SImode
          || !vector_operand (operands[1], E_V16SImode)
          || !(
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 23346 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8580; /* *absv16si2 */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x3) != E_V8SImode
          || !vector_operand (operands[1], E_V8SImode)
          || !(
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 23346 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 8581; /* *absv8si2 */

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || !vector_operand (operands[1], E_V4SImode)
          || !
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 8582; /* *absv4si2 */

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x3) != E_V8DImode
          || !vector_operand (operands[1], E_V8DImode)
          || !(
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 23347 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8583; /* *absv8di2 */

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x3) != E_V4DImode
          || !vector_operand (operands[1], E_V4DImode)
          || !(
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 23347 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 8584; /* *absv4di2 */

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x3) != E_V2DImode
          || !vector_operand (operands[1], E_V2DImode)
          || !(
#line 23354 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 23348 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 8585; /* *absv2di2 */

    default:
      return -1;
    }
}

 int
recog_338 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  switch (pattern34 (x1))
    {
    case 0:
      if (!
#line 24121 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1 && 1))
        return -1;
      return 8680; /* avx2_sign_extendv16qiv16hi2 */

    case 1:
      if (!
#line 24175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))
        return -1;
      return 8688; /* avx512bw_sign_extendv32qiv32hi2 */

    case 2:
      if (!
#line 24245 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1))
        return -1;
      return 8700; /* *sse4_1_sign_extendv8qiv8hi2_1 */

    case 3:
      if (!
#line 24370 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8712; /* *avx512f_sign_extendv16qiv16si2 */

    case 4:
      if (!
#line 24513 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8740; /* avx512f_sign_extendv16hiv16si2 */

    case 5:
      if (!
#line 24402 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8720; /* *avx2_sign_extendv8qiv8si2_1 */

    case 6:
      if (!
#line 24566 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8748; /* avx2_sign_extendv8hiv8si2 */

    case 7:
      if (!
#line 24463 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8732; /* *sse4_1_sign_extendv4qiv4si2_1 */

    case 8:
      if (!
#line 24636 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8760; /* *sse4_1_sign_extendv4hiv4si2_1 */

    case 9:
      if (!
#line 24767 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8776; /* *avx512f_sign_extendv8qiv8di2_1 */

    case 10:
      if (!
#line 24938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8807; /* avx512f_sign_extendv8hiv8di2 */

    case 11:
      if (!
#line 25075 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 8835; /* avx512f_sign_extendv8siv8di2 */

    case 12:
      if (!
#line 24825 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8788; /* *avx2_sign_extendv4qiv4di2_1 */

    case 13:
      if (!
#line 24968 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8815; /* *avx2_sign_extendv4hiv4di2_1 */

    case 14:
      if (!
#line 25126 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
        return -1;
      return 8841; /* avx2_sign_extendv4siv4di2 */

    case 15:
      if (!
#line 24887 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8800; /* *sse4_1_sign_extendv2qiv2di2_1 */

    case 16:
      if (!
#line 25026 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8827; /* *sse4_1_sign_extendv2hiv2di2_1 */

    case 17:
      if (!
#line 25192 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
        return -1;
      return 8851; /* *sse4_1_sign_extendv2siv2di2_1 */

    case 18:
      x2 = XEXP (x1, 1);
      x3 = XEXP (x2, 0);
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      switch (pattern537 (x2))
        {
        case 0:
          if (
#line 24233 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1))
            return 8696; /* sse4_1_sign_extendv8qiv8hi2 */
          break;

        case 1:
          if (
#line 24391 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
            return 8716; /* avx2_sign_extendv8qiv8si2 */
          break;

        case 2:
          if (
#line 24757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return 8772; /* avx512f_sign_extendv8qiv8di2 */
          break;

        case 3:
          if (
#line 24451 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8728; /* sse4_1_sign_extendv4qiv4si2 */
          break;

        case 4:
          if (
#line 24624 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8756; /* sse4_1_sign_extendv4hiv4si2 */
          break;

        case 5:
          if (
#line 24814 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
            return 8784; /* avx2_sign_extendv4qiv4di2 */
          break;

        case 6:
          if (
#line 24957 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
            return 8811; /* avx2_sign_extendv4hiv4di2 */
          break;

        case 7:
          if (
#line 24875 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8796; /* sse4_1_sign_extendv2qiv2di2 */
          break;

        case 8:
          if (
#line 25014 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8823; /* sse4_1_sign_extendv2hiv2di2 */
          break;

        case 9:
          if (
#line 25180 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1))
            return 8847; /* sse4_1_sign_extendv2siv2di2 */
          break;

        default:
          break;
        }
      if (GET_CODE (x4) != SUBREG
          || maybe_ne (SUBREG_BYTE (x4), 0))
        return -1;
      switch (pattern675 (x2))
        {
        case 0:
          if (!
#line 24269 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1 && 1
   && ix86_pre_reload_split ()))
            return -1;
          return 8704; /* *sse4_1_sign_extendv8qiv8hi2_2 */

        case 1:
          if (!
#line 24421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()))
            return -1;
          return 8724; /* *avx2_sign_extendv8qiv8si2_2 */

        case 2:
          if (!
#line 24785 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512 && ix86_pre_reload_split ()))
            return -1;
          return 8780; /* *avx512f_sign_extendv8qiv8di2_2 */

        case 3:
          if (!
#line 24655 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()))
            return -1;
          return 8764; /* *sse4_1_sign_extendv4hiv4si2_2 */

        case 4:
          if (!
#line 24985 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()))
            return -1;
          return 8819; /* *avx2_sign_extendv4hiv4di2_2 */

        case 5:
          if (!
#line 25210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()))
            return -1;
          return 8855; /* *sse4_1_sign_extendv2siv2di2_2 */

        case 6:
          if (!
#line 24486 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()))
            return -1;
          return 8736; /* *sse4_1_sign_extendv4qiv4si2_2 */

        case 7:
          if (!
#line 24846 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1
   && ix86_pre_reload_split ()))
            return -1;
          return 8792; /* *avx2_sign_extendv4qiv4di2_2 */

        case 8:
          if (!
#line 25048 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && 1
   && ix86_pre_reload_split ()))
            return -1;
          return 8831; /* *sse4_1_sign_extendv2hiv2di2_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_342 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern28 (x1))
    {
    case 0:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4542; /* avx512fp16_fix_truncv8hi2 */

    case 1:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4550; /* avx512fp16_fix_truncv16hi2 */

    case 2:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4558; /* avx512fp16_fix_truncv32hi2 */

    case 3:
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4566; /* avx512fp16_fix_truncv8si2 */

        case E_V8SFmode:
          if (!nonimmediate_operand (operands[1], E_V8SFmode)
              || !
#line 8783 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
            return -1;
          return 4818; /* fix_truncv8sfv8si2 */

        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode)
              || !
#line 9557 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 4957; /* fix_truncv8dfv8si2 */

        default:
          return -1;
        }

    case 4:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4574; /* avx512fp16_fix_truncv16si2 */

    case 5:
      if (!
#line 8764 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 4808; /* fix_truncv16sfv16si2 */

    case 6:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4582; /* avx512fp16_fix_truncv8di2 */

    case 7:
      if (!(
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4994; /* fix_truncv8dfv8di2 */

    case 8:
      if (!(
#line 9729 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 5038; /* fix_truncv8sfv8di2 */

    case 9:
      switch (GET_MODE (operands[1]))
        {
        case E_V4HFmode:
          if (!memory_operand (operands[1], E_V4HFmode)
              || !
#line 7919 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4606; /* *avx512fp16_fix_truncv4si2_load */

        case E_V4SFmode:
          if (!vector_operand (operands[1], E_V4SFmode)
              || !
#line 8813 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1))
            return -1;
          return 4822; /* fix_truncv4sfv4si2 */

        case E_V4DFmode:
          if (!nonimmediate_operand (operands[1], E_V4DFmode)
              || !
#line 9646 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX || (TARGET_AVX512VL && TARGET_AVX512F)))
            return -1;
          return 4972; /* fix_truncv4dfv4si2 */

        default:
          return -1;
        }

    case 10:
      if (!
#line 7919 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4610; /* *avx512fp16_fix_truncv4di2_load */

    case 11:
      if (!(
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 5002; /* fix_truncv4dfv4di2 */

    case 12:
      if (!(
#line 9729 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 5046; /* fix_truncv4sfv4di2 */

    case 13:
      if (!
#line 7969 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4622; /* *avx512fp16_fix_truncv2di2_load */

    case 14:
      if (!(
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 5006; /* fix_truncv2dfv2di2 */

    case 15:
      if (!
#line 7909 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4598; /* avx512fp16_fix_truncv4si2 */

    case 16:
      if (!
#line 7909 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4602; /* avx512fp16_fix_truncv4di2 */

    case 17:
      if (!
#line 7959 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4618; /* avx512fp16_fix_truncv2di2 */

    case 18:
      if (!
#line 9752 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
        return -1;
      return 5054; /* avx512dq_fix_truncv2sfv2di2 */

    default:
      return -1;
    }
}

 int
recog_351 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_XFmode:
      if (!register_operand (operands[0], E_XFmode)
          || GET_MODE (x3) != E_XFmode
          || !register_operand (operands[1], E_XFmode)
          || !
#line 23744 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
        return -1;
      return 1708; /* sqrtxf2 */

    case E_HFmode:
      if (!register_operand (operands[0], E_HFmode)
          || GET_MODE (x3) != E_HFmode
          || !nonimmediate_operand (operands[1], E_HFmode)
          || !
#line 23805 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
        return -1;
      return 1711; /* sqrthf2 */

    case E_SFmode:
      if (!register_operand (operands[0], E_SFmode)
          || GET_MODE (x3) != E_SFmode
          || !nonimmediate_operand (operands[1], E_SFmode)
          || !
#line 23818 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH))
        return -1;
      return 1712; /* *sqrtsf2_sse */

    case E_DFmode:
      if (!register_operand (operands[0], E_DFmode)
          || GET_MODE (x3) != E_DFmode
          || !nonimmediate_operand (operands[1], E_DFmode)
          || !
#line 23818 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH))
        return -1;
      return 1713; /* *sqrtdf2_sse */

    default:
      return -1;
    }
}

 int
recog_356 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case SIGN_EXTRACT:
      x4 = XEXP (x3, 1);
      if (XWINT (x4, 0) != 1L)
        return -1;
      x5 = XEXP (x3, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x6 = XEXP (x2, 0);
      operands[0] = x6;
      switch (GET_CODE (operands[1]))
        {
        case REG:
        case SUBREG:
          switch (pattern1472 (x3))
            {
            case 0:
              return 120; /* *extvsi_1_0 */

            case 1:
              if (!
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 121; /* *extvdi_1_0 */

            default:
              return -1;
            }

        case LTU:
        case UNLT:
          if (pattern568 (operands[1]) != 0)
            return -1;
          switch (pattern1549 (x3))
            {
            case 0:
              return 1797; /* *x86_movsicc_0_m1_se */

            case 1:
              if (!
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 1798; /* *x86_movdicc_0_m1_se */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ZERO_EXTRACT:
      x4 = XEXP (x3, 1);
      if (XWINT (x4, 0) == 1L)
        {
          x6 = XEXP (x2, 0);
          if (GET_CODE (x6) == SUBREG)
            {
              switch (pattern1304 (x2))
                {
                case 0:
                  if (
#line 19356 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                    return 1434; /* *btsi_setcqi */
                  break;

                case 1:
                  if ((
#line 19356 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1435; /* *btdi_setcqi */
                  break;

                default:
                  break;
                }
            }
          x5 = XEXP (x3, 2);
          if (GET_CODE (x5) == SUBREG)
            {
              switch (pattern1306 (x2))
                {
                case 0:
                  if (
#line 19437 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                    return 1442; /* *btsi_setcsi_mask */
                  break;

                case 1:
                  if ((
#line 19437 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1443; /* *btdi_setcdi_mask */
                  break;

                default:
                  break;
                }
            }
        }
      x6 = XEXP (x2, 0);
      operands[0] = x6;
      operands[2] = x4;
      if (!const_0_to_255_operand (operands[2], E_QImode))
        return -1;
      x5 = XEXP (x3, 2);
      operands[3] = x5;
      if (!const_0_to_255_operand (operands[3], E_QImode))
        return -1;
      switch (pattern407 (x3))
        {
        case 0:
          if (!
#line 22184 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
            return -1;
          return 1604; /* tbm_bextri_si */

        case 1:
          if (!(
#line 22184 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1605; /* tbm_bextri_di */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_364 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (pattern352 (x1) != 0)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  switch (pattern1033 (x1))
    {
    case 0:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3336; /* *avx512f_cmpv16si3_zero_extendhi_2 */

    case 1:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3357; /* *avx512vl_cmpv16hf3_zero_extendhi_2 */

    case 2:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3363; /* *avx512f_cmpv16sf3_zero_extendhi_2 */

    case 3:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3429; /* *avx512vl_cmpv16qi3_zero_extendhi_2 */

    case 4:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3438; /* *avx512vl_cmpv16hi3_zero_extendhi_2 */

    case 5:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3339; /* *avx512vl_cmpv8si3_zero_extendhi_2 */

    case 6:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3342; /* *avx512vl_cmpv4si3_zero_extendhi_2 */

    case 7:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3345; /* *avx512f_cmpv8di3_zero_extendhi_2 */

    case 8:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3348; /* *avx512vl_cmpv4di3_zero_extendhi_2 */

    case 9:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3351; /* *avx512vl_cmpv2di3_zero_extendhi_2 */

    case 10:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3360; /* *avx512fp16_cmpv8hf3_zero_extendhi_2 */

    case 11:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3366; /* *avx512vl_cmpv8sf3_zero_extendhi_2 */

    case 12:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3369; /* *avx512vl_cmpv4sf3_zero_extendhi_2 */

    case 13:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3372; /* *avx512f_cmpv8df3_zero_extendhi_2 */

    case 14:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3375; /* *avx512vl_cmpv4df3_zero_extendhi_2 */

    case 15:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3378; /* *avx512vl_cmpv2df3_zero_extendhi_2 */

    case 16:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3441; /* *avx512vl_cmpv8hi3_zero_extendhi_2 */

    case 17:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 3354; /* *avx512bw_cmpv32hf3_zero_extendhi_2 */

    case 18:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3432; /* *avx512vl_cmpv32qi3_zero_extendhi_2 */

    case 19:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3435; /* *avx512bw_cmpv32hi3_zero_extendhi_2 */

    case 20:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3426; /* *avx512bw_cmpv64qi3_zero_extendhi_2 */

    case 21:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3337; /* *avx512f_cmpv16si3_zero_extendsi_2 */

    case 22:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3358; /* *avx512vl_cmpv16hf3_zero_extendsi_2 */

    case 23:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3364; /* *avx512f_cmpv16sf3_zero_extendsi_2 */

    case 24:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3430; /* *avx512vl_cmpv16qi3_zero_extendsi_2 */

    case 25:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3439; /* *avx512vl_cmpv16hi3_zero_extendsi_2 */

    case 26:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3340; /* *avx512vl_cmpv8si3_zero_extendsi_2 */

    case 27:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3343; /* *avx512vl_cmpv4si3_zero_extendsi_2 */

    case 28:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3346; /* *avx512f_cmpv8di3_zero_extendsi_2 */

    case 29:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3349; /* *avx512vl_cmpv4di3_zero_extendsi_2 */

    case 30:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3352; /* *avx512vl_cmpv2di3_zero_extendsi_2 */

    case 31:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3361; /* *avx512fp16_cmpv8hf3_zero_extendsi_2 */

    case 32:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3367; /* *avx512vl_cmpv8sf3_zero_extendsi_2 */

    case 33:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3370; /* *avx512vl_cmpv4sf3_zero_extendsi_2 */

    case 34:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3373; /* *avx512f_cmpv8df3_zero_extendsi_2 */

    case 35:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3376; /* *avx512vl_cmpv4df3_zero_extendsi_2 */

    case 36:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3379; /* *avx512vl_cmpv2df3_zero_extendsi_2 */

    case 37:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3442; /* *avx512vl_cmpv8hi3_zero_extendsi_2 */

    case 38:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 3355; /* *avx512bw_cmpv32hf3_zero_extendsi_2 */

    case 39:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3433; /* *avx512vl_cmpv32qi3_zero_extendsi_2 */

    case 40:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3436; /* *avx512bw_cmpv32hi3_zero_extendsi_2 */

    case 41:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3427; /* *avx512bw_cmpv64qi3_zero_extendsi_2 */

    case 42:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3338; /* *avx512f_cmpv16si3_zero_extenddi_2 */

    case 43:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3359; /* *avx512vl_cmpv16hf3_zero_extenddi_2 */

    case 44:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3365; /* *avx512f_cmpv16sf3_zero_extenddi_2 */

    case 45:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3431; /* *avx512vl_cmpv16qi3_zero_extenddi_2 */

    case 46:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3440; /* *avx512vl_cmpv16hi3_zero_extenddi_2 */

    case 47:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3341; /* *avx512vl_cmpv8si3_zero_extenddi_2 */

    case 48:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3344; /* *avx512vl_cmpv4si3_zero_extenddi_2 */

    case 49:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3347; /* *avx512f_cmpv8di3_zero_extenddi_2 */

    case 50:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3350; /* *avx512vl_cmpv4di3_zero_extenddi_2 */

    case 51:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3353; /* *avx512vl_cmpv2di3_zero_extenddi_2 */

    case 52:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3362; /* *avx512fp16_cmpv8hf3_zero_extenddi_2 */

    case 53:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3368; /* *avx512vl_cmpv8sf3_zero_extenddi_2 */

    case 54:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3371; /* *avx512vl_cmpv4sf3_zero_extenddi_2 */

    case 55:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3374; /* *avx512f_cmpv8df3_zero_extenddi_2 */

    case 56:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3377; /* *avx512vl_cmpv4df3_zero_extenddi_2 */

    case 57:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3380; /* *avx512vl_cmpv2df3_zero_extenddi_2 */

    case 58:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3443; /* *avx512vl_cmpv8hi3_zero_extenddi_2 */

    case 59:
      if (!(
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 3356; /* *avx512bw_cmpv32hf3_zero_extenddi_2 */

    case 60:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3434; /* *avx512vl_cmpv32qi3_zero_extenddi_2 */

    case 61:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3437; /* *avx512bw_cmpv32hi3_zero_extenddi_2 */

    case 62:
      if (!(
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3428; /* *avx512bw_cmpv64qi3_zero_extenddi_2 */

    case 63:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3510; /* *avx512bw_ucmpv64qi3_zero_extendhi_2 */

    case 64:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3513; /* *avx512vl_ucmpv16qi3_zero_extendhi_2 */

    case 65:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3522; /* *avx512vl_ucmpv16hi3_zero_extendhi_2 */

    case 66:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3582; /* *avx512f_ucmpv16si3_zero_extendhi_2 */

    case 67:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3516; /* *avx512vl_ucmpv32qi3_zero_extendhi_2 */

    case 68:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3519; /* *avx512bw_ucmpv32hi3_zero_extendhi_2 */

    case 69:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3525; /* *avx512vl_ucmpv8hi3_zero_extendhi_2 */

    case 70:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3583; /* *avx512vl_ucmpv8si3_zero_extendhi_2 */

    case 71:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3584; /* *avx512vl_ucmpv4si3_zero_extendhi_2 */

    case 72:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3585; /* *avx512f_ucmpv8di3_zero_extendhi_2 */

    case 73:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3586; /* *avx512vl_ucmpv4di3_zero_extendhi_2 */

    case 74:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3587; /* *avx512vl_ucmpv2di3_zero_extendhi_2 */

    case 75:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3511; /* *avx512bw_ucmpv64qi3_zero_extendsi_2 */

    case 76:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3514; /* *avx512vl_ucmpv16qi3_zero_extendsi_2 */

    case 77:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3523; /* *avx512vl_ucmpv16hi3_zero_extendsi_2 */

    case 78:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3588; /* *avx512f_ucmpv16si3_zero_extendsi_2 */

    case 79:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3517; /* *avx512vl_ucmpv32qi3_zero_extendsi_2 */

    case 80:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3520; /* *avx512bw_ucmpv32hi3_zero_extendsi_2 */

    case 81:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3526; /* *avx512vl_ucmpv8hi3_zero_extendsi_2 */

    case 82:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3589; /* *avx512vl_ucmpv8si3_zero_extendsi_2 */

    case 83:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3590; /* *avx512vl_ucmpv4si3_zero_extendsi_2 */

    case 84:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3591; /* *avx512f_ucmpv8di3_zero_extendsi_2 */

    case 85:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3592; /* *avx512vl_ucmpv4di3_zero_extendsi_2 */

    case 86:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3593; /* *avx512vl_ucmpv2di3_zero_extendsi_2 */

    case 87:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3512; /* *avx512bw_ucmpv64qi3_zero_extenddi_2 */

    case 88:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3515; /* *avx512vl_ucmpv16qi3_zero_extenddi_2 */

    case 89:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3524; /* *avx512vl_ucmpv16hi3_zero_extenddi_2 */

    case 90:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3594; /* *avx512f_ucmpv16si3_zero_extenddi_2 */

    case 91:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3518; /* *avx512vl_ucmpv32qi3_zero_extenddi_2 */

    case 92:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3521; /* *avx512bw_ucmpv32hi3_zero_extenddi_2 */

    case 93:
      if (!(
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3527; /* *avx512vl_ucmpv8hi3_zero_extenddi_2 */

    case 94:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3595; /* *avx512vl_ucmpv8si3_zero_extenddi_2 */

    case 95:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3596; /* *avx512vl_ucmpv4si3_zero_extenddi_2 */

    case 96:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3597; /* *avx512f_ucmpv8di3_zero_extenddi_2 */

    case 97:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3598; /* *avx512vl_ucmpv4di3_zero_extenddi_2 */

    case 98:
      if (!(
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3599; /* *avx512vl_ucmpv2di3_zero_extenddi_2 */

    default:
      return -1;
    }
}

 int
recog_392 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case ZERO_EXTEND:
      x7 = XEXP (x5, 1);
      if (GET_CODE (x7) != CONST_INT)
        return -1;
      x8 = XEXP (x4, 1);
      if (GET_CODE (x8) != ZERO_EXTEND)
        return -1;
      x9 = XEXP (x6, 0);
      switch (GET_CODE (x9))
        {
        case TRUNCATE:
          if (GET_MODE (x9) != E_QImode)
            return -1;
          x10 = XEXP (x9, 0);
          if (GET_CODE (x10) != MOD
              || GET_MODE (x10) != E_HImode
              || XWINT (x7, 0) != 8L)
            return -1;
          x11 = XEXP (x8, 0);
          if (GET_CODE (x11) != TRUNCATE
              || GET_MODE (x11) != E_QImode)
            return -1;
          x12 = XEXP (x11, 0);
          if (GET_CODE (x12) != DIV
              || GET_MODE (x12) != E_HImode)
            return -1;
          x13 = XVECEXP (x1, 0, 1);
          if (pattern231 (x13, 
E_CCmode, 
17) != 0
              || !register_operand (operands[0], E_HImode)
              || GET_MODE (x4) != E_HImode
              || GET_MODE (x5) != E_HImode
              || GET_MODE (x6) != E_HImode)
            return -1;
          x14 = XEXP (x10, 0);
          operands[1] = x14;
          if (!register_operand (operands[1], E_HImode))
            return -1;
          x15 = XEXP (x10, 1);
          if (GET_MODE (x15) != E_HImode
              || GET_MODE (x8) != E_HImode)
            return -1;
          x16 = XEXP (x12, 1);
          if (GET_MODE (x16) != E_HImode)
            return -1;
          x17 = XEXP (x12, 0);
          if (!rtx_equal_p (x17, operands[1]))
            return -1;
          switch (GET_CODE (x15))
            {
            case SIGN_EXTEND:
              if (GET_CODE (x16) != SIGN_EXTEND)
                return -1;
              x18 = XEXP (x15, 0);
              operands[2] = x18;
              if (!nonimmediate_operand (operands[2], E_QImode))
                return -1;
              x19 = XEXP (x16, 0);
              if (!rtx_equal_p (x19, operands[2])
                  || !
#line 12029 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && true))
                return -1;
              return 679; /* divmodhiqi3 */

            case ZERO_EXTEND:
              if (GET_CODE (x16) != ZERO_EXTEND)
                return -1;
              x18 = XEXP (x15, 0);
              operands[2] = x18;
              if (!nonimmediate_operand (operands[2], E_QImode))
                return -1;
              x19 = XEXP (x16, 0);
              if (!rtx_equal_p (x19, operands[2])
                  || !
#line 12029 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && true))
                return -1;
              return 681; /* udivmodhiqi3 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          operands[1] = x9;
          x13 = XVECEXP (x1, 0, 1);
          if (pattern383 (x13, 
174, 
0) != 0)
            return -1;
          x11 = XEXP (x8, 0);
          operands[2] = x11;
          switch (XWINT (x7, 0))
            {
            case 8L:
              if (pattern1550 (x4, 
E_QImode, 
E_HImode) != 0
                  || !
#line 2540 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2650; /* kunpckhi */

            case 16L:
              if (pattern1550 (x4, 
E_HImode, 
E_SImode) != 0
                  || !
#line 2554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))
                return -1;
              return 2651; /* kunpcksi */

            case 32L:
              if (pattern1550 (x4, 
E_SImode, 
E_DImode) != 0
                  || !
#line 2566 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))
                return -1;
              return 2652; /* kunpckdi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      x13 = XVECEXP (x1, 0, 1);
      if (pattern231 (x13, 
E_CCmode, 
17) != 0)
        return -1;
      switch (pattern1039 (x4, 
LSHIFTRT))
        {
        case 0:
          x8 = XEXP (x4, 1);
          x11 = XEXP (x8, 0);
          x12 = XEXP (x11, 0);
          x17 = XEXP (x12, 0);
          operands[1] = x17;
          if (nonimmediate_operand (operands[0], E_DImode))
            {
              x7 = XEXP (x5, 1);
              x20 = XEXP (x7, 0);
              operands[2] = x20;
              if (rtx_equal_p (x6, operands[0]))
                {
                  x21 = XEXP (x11, 1);
                  x22 = XEXP (x21, 1);
                  x23 = XEXP (x22, 0);
                  if (rtx_equal_p (x23, operands[2])
                      && 
#line 15415 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && true))
                    return 1063; /* x86_64_shld */
                }
            }
          operands[2] = x17;
          if (!register_operand (operands[0], E_DImode))
            return -1;
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_DImode))
            return -1;
          x7 = XEXP (x5, 1);
          x20 = XEXP (x7, 0);
          operands[3] = x20;
          x21 = XEXP (x11, 1);
          x22 = XEXP (x21, 1);
          x23 = XEXP (x22, 0);
          if (!rtx_equal_p (x23, operands[3])
              || !
#line 15436 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1065; /* x86_64_shld_ndd */

        case 1:
          if (!nonimmediate_operand (operands[0], E_SImode)
              || pattern1038 (x4, 
E_SImode, 
E_DImode) != 0)
            return -1;
          x8 = XEXP (x4, 1);
          x11 = XEXP (x8, 0);
          x12 = XEXP (x11, 0);
          x17 = XEXP (x12, 0);
          operands[1] = x17;
          x7 = XEXP (x5, 1);
          x20 = XEXP (x7, 0);
          operands[2] = x20;
          if (rtx_equal_p (x6, operands[0]))
            {
              x21 = XEXP (x11, 1);
              x22 = XEXP (x21, 1);
              x23 = XEXP (x22, 0);
              if (rtx_equal_p (x23, operands[2]))
                return 1075; /* x86_shld */
            }
          operands[2] = x17;
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          operands[3] = x20;
          x21 = XEXP (x11, 1);
          x22 = XEXP (x21, 1);
          x23 = XEXP (x22, 0);
          if (!rtx_equal_p (x23, operands[3])
              || !
#line 15667 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1077; /* x86_shld_ndd */

        case 2:
          x8 = XEXP (x4, 1);
          switch (GET_CODE (x8))
            {
            case SUBREG:
              switch (pattern1223 (x4, 
LSHIFTRT))
                {
                case 0:
                  x7 = XEXP (x5, 1);
                  operands[2] = x7;
                  if (pattern1660 (x4) == 0
                      && 
#line 15451 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && true))
                    return 1067; /* x86_64_shld_1 */
                  operands[3] = x7;
                  if (pattern1661 (x4) != 0
                      || !
#line 15473 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && INTVAL (operands[4]) == 64 - INTVAL (operands[3])
   && true))
                    return -1;
                  return 1069; /* x86_64_shld_ndd_1 */

                case 1:
                  x7 = XEXP (x5, 1);
                  operands[2] = x7;
                  if (pattern1662 (x4) == 0
                      && 
#line 15683 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
  && true))
                    return 1079; /* x86_shld_1 */
                  operands[3] = x7;
                  if (pattern1663 (x4) != 0
                      || !
#line 15705 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD 
   && INTVAL (operands[4]) == 32 - INTVAL (operands[3])
   && true))
                    return -1;
                  return 1081; /* x86_shld_ndd_1 */

                default:
                  return -1;
                }

            case LSHIFTRT:
              switch (pattern1225 (x4))
                {
                case 0:
                  if (!
#line 15545 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1071; /* *x86_64_shld_shrd_1_nozext */

                case 1:
                  if (!
#line 15777 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1083; /* *x86_shld_shrd_1_nozext */

                case 2:
                  x11 = XEXP (x8, 0);
                  operands[1] = x11;
                  if (nonimmediate_operand (operands[0], E_DImode))
                    {
                      x7 = XEXP (x5, 1);
                      operands[2] = x7;
                      if (rtx_equal_p (x6, operands[0]))
                        {
                          x24 = XEXP (x8, 1);
                          x25 = XEXP (x24, 1);
                          if (rtx_equal_p (x25, operands[2])
                              && 
#line 15598 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            return 1072; /* *x86_64_shld_2 */
                        }
                    }
                  operands[2] = x11;
                  if (!register_operand (operands[0], E_DImode))
                    return -1;
                  operands[1] = x6;
                  if (!nonimmediate_operand (operands[1], E_DImode))
                    return -1;
                  x7 = XEXP (x5, 1);
                  operands[3] = x7;
                  x24 = XEXP (x8, 1);
                  x25 = XEXP (x24, 1);
                  if (!rtx_equal_p (x25, operands[3])
                      || !
#line 15619 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1073; /* *x86_64_shld_ndd_2 */

                case 3:
                  x11 = XEXP (x8, 0);
                  operands[1] = x11;
                  if (nonimmediate_operand (operands[0], E_SImode))
                    {
                      x7 = XEXP (x5, 1);
                      operands[2] = x7;
                      if (rtx_equal_p (x6, operands[0]))
                        {
                          x24 = XEXP (x8, 1);
                          x25 = XEXP (x24, 1);
                          if (rtx_equal_p (x25, operands[2])
                              && 
#line 15829 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            return 1084; /* *x86_shld_2 */
                        }
                    }
                  operands[2] = x11;
                  if (!register_operand (operands[0], E_SImode))
                    return -1;
                  operands[1] = x6;
                  if (!nonimmediate_operand (operands[1], E_SImode))
                    return -1;
                  x7 = XEXP (x5, 1);
                  operands[3] = x7;
                  x24 = XEXP (x8, 1);
                  x25 = XEXP (x24, 1);
                  if (!rtx_equal_p (x25, operands[3])
                      || !
#line 15850 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  return 1085; /* *x86_shld_ndd_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x6, 0) != 1L)
        return -1;
      x13 = XVECEXP (x1, 0, 1);
      if (pattern231 (x13, 
E_CCmode, 
17) != 0)
        return -1;
      switch (pattern372 (x4))
        {
        case 0:
          x7 = XEXP (x5, 1);
          operands[2] = x7;
          if (register_operand (operands[2], E_QImode))
            {
              switch (pattern934 (x4))
                {
                case 0:
                  if (
#line 18837 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT))
                    return 1391; /* *btssi */
                  break;

                case 1:
                  if ((
#line 18837 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1393; /* *btsdi */
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x7) != SUBREG)
            return -1;
          switch (pattern1316 (x4))
            {
            case 0:
              if (!
#line 18856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                return -1;
              return 1395; /* *btssi_mask */

            case 1:
              if (!(
#line 18856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1397; /* *btsdi_mask */

            default:
              return -1;
            }

        case 1:
          if (!
#line 18884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
            return -1;
          return 1399; /* *btssi_mask_1 */

        case 2:
          if (!(
#line 18884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1401; /* *btsdi_mask_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_403 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          x4 = XEXP (x2, 1);
          if (GET_MODE (x4) != E_DImode)
            return -1;
          if (register_operand (operands[0], E_DImode)
              && register_operand (operands[1], E_DImode)
              && nonmemory_operand (operands[2], E_QImode)
              && 
#line 1195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 1131; /* ashrdi3_doubleword */
          if (!nonimmediate_operand (operands[0], E_DImode)
              || !nonimmediate_operand (operands[1], E_DImode))
            return -1;
          if (const_int_operand (operands[2], E_QImode)
              && (
#line 17258 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == GET_MODE_BITSIZE (DImode)-1
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1169; /* ashrdi3_cvt */
          if (!nonmemory_operand (operands[2], E_QImode)
              || !(
#line 17337 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1178; /* *ashrdi3_1 */

        case E_TImode:
          x4 = XEXP (x2, 1);
          if (pattern1233 (x4, 
E_TImode) != 0
              || !
#line 1196 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1133; /* ashrti3_doubleword */

        case E_SImode:
          x4 = XEXP (x2, 1);
          if (pattern1480 (x4, 
E_SImode) != 0
              || !
#line 17337 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          return 1176; /* *ashrsi3_1 */

        case E_QImode:
          x4 = XEXP (x2, 1);
          if (pattern1480 (x4, 
E_QImode) != 0
              || !
#line 17546 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, QImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          return 1209; /* *ashrqi3_1 */

        case E_HImode:
          x4 = XEXP (x2, 1);
          if (pattern1480 (x4, 
E_HImode) != 0
              || !
#line 17546 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, HImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          return 1211; /* *ashrhi3_1 */

        case E_V2QImode:
          x4 = XEXP (x2, 1);
          if (pattern1233 (x4, 
E_V2QImode) != 0
              || !
#line 4007 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size))
            return -1;
          return 2216; /* ashrv2qi3 */

        default:
          return -1;
        }

    case STRICT_LOW_PART:
      switch (pattern1234 (x2))
        {
        case 0:
          if (!
#line 17652 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 1217; /* *ashrqi3_1_slp */

        case 1:
          if (!
#line 17652 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 1219; /* *ashrhi3_1_slp */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_404 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  switch (pattern204 (x1))
    {
    case 0:
      x2 = XVECEXP (x1, 0, 0);
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      switch (GET_CODE (x5))
        {
        case SUBREG:
          switch (pattern1320 (x4))
            {
            case 0:
              if ((
#line 16596 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (4 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 4 * BITS_PER_UNIT - 1))
	 == (2 * 4 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return 1123; /* *ashrdi3_doubleword_mask */
              break;

            case 1:
              if ((
#line 16596 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1125; /* *ashrti3_doubleword_mask */
              break;

            default:
              break;
            }
          break;

        case CONST_INT:
          operands[2] = x5;
          if (const_int_operand (operands[2], E_QImode)
              && nonimmediate_operand (operands[0], E_SImode)
              && GET_MODE (x4) == E_SImode
              && nonimmediate_operand (operands[1], E_SImode)
              && 
#line 17258 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == GET_MODE_BITSIZE (SImode)-1
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)
   && true))
            return 1167; /* ashrsi3_cvt */
          break;

        default:
          break;
        }
      operands[2] = x5;
      res = recog_403 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (GET_CODE (x5) != SUBREG
          || maybe_ne (SUBREG_BYTE (x5), 0)
          || GET_MODE (x5) != E_QImode)
        return -1;
      switch (pattern1422 (x2))
        {
        case 0:
          if (!
#line 17854 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1))
      == 4 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()))
            return -1;
          return 1246; /* *ashrsi3_mask */

        case 1:
          if (!(
#line 17854 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1))
      == 8 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1249; /* *ashrdi3_mask */

        case 2:
          if (!
#line 17902 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
            return -1;
          return 1258; /* *ashrsi3_add */

        case 3:
          if (!(
#line 17902 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1261; /* *ashrdi3_add */

        case 4:
          if (!
#line 17948 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
            return -1;
          return 1270; /* *ashrsi3_sub */

        case 5:
          if (!(
#line 17948 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1273; /* *ashrdi3_sub */

        default:
          return -1;
        }

    case 1:
      if (register_operand (operands[0], E_DImode)
          && register_operand (operands[1], E_DImode)
          && (
#line 16657 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (4 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 4 * BITS_PER_UNIT - 1))
	 == (2 * 4 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
        return 1127; /* *ashrdi3_doubleword_mask_1 */
      if (!nonimmediate_operand (operands[0], E_DImode)
          || !nonimmediate_operand (operands[1], E_DImode)
          || !(
#line 17879 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1))
      == 8 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 1255; /* *ashrdi3_mask_1 */

    case 2:
      if (!(
#line 16657 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 1129; /* *ashrti3_doubleword_mask_1 */

    case 3:
      if (!
#line 17879 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1))
      == 4 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()))
        return -1;
      return 1252; /* *ashrsi3_mask_1 */

    case 4:
      if (!
#line 17926 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      return 1264; /* *ashrsi3_add_1 */

    case 5:
      if (!(
#line 17926 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 1267; /* *ashrdi3_add_1 */

    case 6:
      if (!
#line 17978 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      return 1276; /* *ashrsi3_sub_1 */

    case 7:
      if (!(
#line 17978 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 1279; /* *ashrdi3_sub_1 */

    case 8:
      if (!(
#line 18002 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == INTVAL (operands[3])
   && UINTVAL (operands[2]) < 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
        return -1;
      return 1280; /* *extenddi2_doubleword_highpart */

    case 9:
      if (!(
#line 18002 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == INTVAL (operands[3])
   && UINTVAL (operands[2]) < 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 1281; /* *extendti2_doubleword_highpart */

    default:
      return -1;
    }
}

 int
recog_420 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  if (pattern226 (x1) != 0)
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x2) != UNSPEC
      || XVECLEN (x2, 0) != 1
      || XINT (x2, 1) != 38)
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  x4 = XEXP (x3, 0);
  operands[0] = x4;
  x5 = XVECEXP (x2, 0, 0);
  operands[2] = x5;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 1);
  x8 = XEXP (x7, 0);
  switch (GET_CODE (x8))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x8;
      x9 = XEXP (x3, 1);
      if (GET_CODE (x9) != CTZ)
        return -1;
      x10 = XEXP (x6, 0);
      if (GET_MODE (x10) != E_CCCmode
          || GET_MODE (x7) != E_CCCmode)
        return -1;
      x11 = XEXP (x9, 0);
      if (!rtx_equal_p (x11, operands[1]))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_SImode:
          if (pattern1665 (x9, 
E_SImode) != 0
              || !
#line 21056 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return -1;
          return 1510; /* *tzcntsi_1_falsedep */

        case E_DImode:
          if (pattern1665 (x9, 
E_DImode) != 0
              || !(
#line 21056 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1511; /* *tzcntdi_1_falsedep */

        default:
          return -1;
        }

    case AND:
      x9 = XEXP (x3, 1);
      if (GET_CODE (x9) != AND)
        return -1;
      x12 = XEXP (x8, 0);
      switch (GET_CODE (x12))
        {
        case NEG:
          x11 = XEXP (x9, 0);
          if (GET_CODE (x11) != NEG)
            return -1;
          switch (pattern1555 (x1))
            {
            case 0:
              if (!
#line 21865 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)))
                return -1;
              return 1574; /* *bmi_blsi_si_falsedep */

            case 1:
              if (!(
#line 21865 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_match_ccmode (insn, CCNOmode)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1575; /* *bmi_blsi_di_falsedep */

            default:
              return -1;
            }

        case PLUS:
          x13 = XEXP (x12, 1);
          if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
            return -1;
          x11 = XEXP (x9, 0);
          if (GET_CODE (x11) != PLUS)
            return -1;
          x14 = XEXP (x11, 1);
          if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
            return -1;
          x10 = XEXP (x6, 0);
          if (GET_MODE (x10) != E_CCZmode
              || GET_MODE (x7) != E_CCZmode)
            return -1;
          switch (pattern1555 (x1))
            {
            case 0:
              if (!
#line 22013 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                return -1;
              return 1586; /* *bmi_blsr_si_cmp_falsedep */

            case 1:
              if (!(
#line 22013 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1587; /* *bmi_blsr_di_cmp_falsedep */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_424 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x3) != CLOBBER)
    return -1;
  x4 = XEXP (x2, 1);
  switch (GET_CODE (x4))
    {
    case UNSIGNED_FIX:
      switch (pattern387 (x1))
        {
        case 0:
          if (!
#line 5923 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_SSE_MATH
   && optimize_function_for_speed_p (cfun)))
            return -1;
          return 223; /* *fixuns_truncsf_1 */

        case 1:
          if (!
#line 5923 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_SSE_MATH
   && optimize_function_for_speed_p (cfun)))
            return -1;
          return 224; /* *fixuns_truncdf_1 */

        default:
          return -1;
        }

    case FIX:
      if (GET_MODE (x4) != E_DImode)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != USE)
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      if (GET_CODE (x6) != USE)
        return -1;
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x8 = XEXP (x4, 0);
      operands[1] = x8;
      if (!register_operand (operands[1], E_VOIDmode))
        return -1;
      x9 = XEXP (x5, 0);
      operands[2] = x9;
      if (!memory_operand (operands[2], E_HImode))
        return -1;
      x10 = XEXP (x6, 0);
      operands[3] = x10;
      if (!memory_operand (operands[3], E_HImode))
        return -1;
      x11 = XEXP (x3, 0);
      operands[4] = x11;
      if (!scratch_operand (operands[4], E_XFmode)
          || !
#line 6033 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(TARGET_64BIT && SSE_FLOAT_MODE_P (GET_MODE (operands[1])))))
        return -1;
      return 235; /* fix_truncdi_i387 */

    case FLOAT:
      switch (pattern389 (x1))
        {
        case 0:
          if (!
#line 6218 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (SFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)))
            return -1;
          return 254; /* floatdisf2_i387_with_xmm */

        case 1:
          if (!
#line 6218 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (DFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)))
            return -1;
          return 255; /* floatdidf2_i387_with_xmm */

        case 2:
          if (!
#line 6218 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (XFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)))
            return -1;
          return 256; /* floatdixf2_i387_with_xmm */

        default:
          return -1;
        }

    case DIV:
      switch (pattern394 (x1, 
MOD))
        {
        case 0:
          return 639; /* divmodsi4_1 */

        case 1:
          if (!
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 640; /* divmoddi4_1 */

        case 2:
          if (!
#line 1191 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH))
            return -1;
          return 667; /* *divmodhi4_noext */

        case 3:
          return 669; /* *divmodsi4_noext */

        case 4:
          if (!
#line 1192 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 671; /* *divmoddi4_noext */

        default:
          return -1;
        }

    case UDIV:
      switch (pattern394 (x1, 
UMOD))
        {
        case 0:
          return 641; /* udivmodsi4_1 */

        case 1:
          if (!
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 642; /* udivmoddi4_1 */

        case 2:
          if (!
#line 1191 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH))
            return -1;
          return 668; /* *udivmodhi4_noext */

        case 3:
          return 670; /* *udivmodsi4_noext */

        case 4:
          if (!
#line 1192 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 672; /* *udivmoddi4_noext */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      if (GET_MODE (x4) != E_DImode)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != SET)
        return -1;
      x11 = XEXP (x3, 0);
      if (GET_CODE (x11) != REG
          || REGNO (x11) != 17
          || GET_MODE (x11) != E_CCmode)
        return -1;
      switch (pattern1046 (x1))
        {
        case 0:
          switch (pattern1485 (x1, 
MOD))
            {
            case 0:
              if (!
#line 11497 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 643; /* divmodsi4_zext_1 */

            case 1:
              if (!
#line 11892 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 673; /* *divmodsi4_noext_zext_1 */

            default:
              return -1;
            }

        case 1:
          switch (pattern1485 (x1, 
UMOD))
            {
            case 0:
              if (!
#line 11533 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 644; /* udivmodsi4_zext_1 */

            case 1:
              if (!
#line 11892 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 674; /* *udivmodsi4_noext_zext_1 */

            default:
              return -1;
            }

        case 2:
          switch (pattern1486 (x1, 
DIV))
            {
            case 0:
              if (!
#line 11556 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 645; /* divmodsi4_zext_2 */

            case 1:
              if (!
#line 11906 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 675; /* *divmodsi4_noext_zext_2 */

            default:
              return -1;
            }

        case 3:
          switch (pattern1486 (x1, 
UDIV))
            {
            case 0:
              if (!
#line 11593 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 646; /* udivmodsi4_zext_2 */

            case 1:
              if (!
#line 11906 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 676; /* *udivmodsi4_noext_zext_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      switch (XVECLEN (x4, 0))
        {
        case 4:
          if (XINT (x4, 1) != 20
              || pattern808 (x4) != 0
              || pattern1232 (x1) != 0
              || !tls_symbolic_operand (operands[2], E_VOIDmode))
            return -1;
          x12 = XVECEXP (x4, 0, 2);
          operands[3] = x12;
          if (!constant_call_address_operand (operands[3], E_VOIDmode))
            return -1;
          x5 = XVECEXP (x1, 0, 1);
          x9 = XEXP (x5, 0);
          operands[4] = x9;
          if (!scratch_operand (operands[4], E_SImode))
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          x10 = XEXP (x6, 0);
          operands[5] = x10;
          if (!scratch_operand (operands[5], E_SImode)
              || !
#line 22965 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_GNU_TLS))
            return -1;
          return 1649; /* *tls_global_dynamic_32_gnu */

        case 3:
          if (XINT (x4, 1) != 21
              || GET_MODE (x4) != E_SImode)
            return -1;
          x12 = XVECEXP (x4, 0, 2);
          if (GET_CODE (x12) != REG
              || REGNO (x12) != 7
              || GET_MODE (x12) != E_SImode
              || pattern1232 (x1) != 0
              || !constant_call_address_operand (operands[2], E_VOIDmode))
            return -1;
          x5 = XVECEXP (x1, 0, 1);
          x9 = XEXP (x5, 0);
          operands[3] = x9;
          if (!scratch_operand (operands[3], E_SImode))
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          x10 = XEXP (x6, 0);
          operands[4] = x10;
          if (!scratch_operand (operands[4], E_SImode)
              || !
#line 23088 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_GNU_TLS))
            return -1;
          return 1653; /* *tls_local_dynamic_base_32_gnu */

        case 1:
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != USE)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != USE
              || !nonimmediate_operand (operands[0], E_DImode)
              || GET_MODE (x4) != E_DImode)
            return -1;
          x13 = XVECEXP (x4, 0, 0);
          operands[1] = x13;
          if (!register_operand (operands[1], E_XFmode))
            return -1;
          x9 = XEXP (x5, 0);
          operands[2] = x9;
          if (!memory_operand (operands[2], E_HImode))
            return -1;
          x10 = XEXP (x6, 0);
          operands[3] = x10;
          if (!memory_operand (operands[3], E_HImode))
            return -1;
          x11 = XEXP (x3, 0);
          operands[4] = x11;
          if (!scratch_operand (operands[4], E_XFmode))
            return -1;
          switch (XINT (x4, 1))
            {
            case 78:
              if (!
#line 25394 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1750; /* fistdi2_floor */

            case 79:
              if (!
#line 25394 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1751; /* fistdi2_ceil */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      if (pattern395 (x1) != 0)
        return -1;
      return 1657; /* *tls_local_dynamic_32_once */

    case UNSPEC_VOLATILE:
      if (XVECLEN (x4, 0) != 1
          || XINT (x4, 1) != 3)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (pattern708 (x5, 
7, 
MINUS) != 0)
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      if (pattern941 (x6, 
E_CCmode, 
17) != 0)
        return -1;
      x11 = XEXP (x3, 0);
      if (GET_CODE (x11) != MEM
          || GET_MODE (x11) != E_BLKmode)
        return -1;
      x14 = XEXP (x11, 0);
      if (GET_CODE (x14) != SCRATCH)
        return -1;
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      x13 = XVECEXP (x4, 0, 0);
      operands[1] = x13;
      x15 = XEXP (x5, 1);
      x16 = XEXP (x15, 1);
      operands[2] = x16;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern1761 (x1, 
E_SImode) != 0
              || !
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))
            return -1;
          return 1863; /* adjust_stack_and_probe_si */

        case E_DImode:
          if (pattern1761 (x1, 
E_DImode) != 0
              || !
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))
            return -1;
          return 1864; /* adjust_stack_and_probe_di */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 rtx_insn *
split_6 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case AND:
      switch (pattern70 (x3))
        {
        case 0:
          if (!(
#line 3716 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == -1
   && CONST_WIDE_INT_ELT (operands[3], 1) == 0) && 
#line 3722 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_28 (insn, operands);

        case 1:
          if (!(
#line 3738 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == 0
   && CONST_WIDE_INT_ELT (operands[3], 1) == -1) && 
#line 3744 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_31 (insn, operands);

        case 2:
          if (!(
#line 3760 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && CONST_INT_P (operands[3])
   && UINTVAL (operands[3]) == 0xffffffff00000000ll) && 
#line 3764 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_34 (insn, operands);

        default:
          return NULL;
        }

    case REG:
    case SUBREG:
      operands[1] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (pattern822 (x3, 
E_QImode) != 0
              || !
#line 7107 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && reload_completed
   && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_135 (insn, operands);

        case E_HImode:
          if (pattern822 (x3, 
E_HImode) != 0
              || !
#line 7107 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && reload_completed
   && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_136 (insn, operands);

        case E_SImode:
          if (pattern823 (x3, 
E_SImode) != 0
              || !
#line 7107 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && reload_completed
   && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_137 (insn, operands);

        case E_DImode:
          if (pattern823 (x3, 
E_DImode) != 0
              || !(
#line 7107 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && reload_completed
   && ix86_lea_for_add_ok (insn, operands)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_138 (insn, operands);

        default:
          return NULL;
        }

    case PLUS:
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          switch (pattern428 (x3))
            {
            case 0:
              if (!(
#line 7910 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7912 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_156 (insn, operands);

            case 1:
              if (!(
#line 7910 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7912 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_157 (insn, operands);

            default:
              return NULL;
            }

        case MULT:
          switch (pattern431 (x3))
            {
            case 0:
              if (!(
#line 7976 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7978 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_162 (insn, operands);

            case 1:
              if (!(
#line 7976 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7978 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_163 (insn, operands);

            default:
              return NULL;
            }

        case ASHIFT:
          switch (pattern573 (x3))
            {
            case 0:
              if (!(
#line 8002 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8004 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_164 (insn, operands);

            case 1:
              if (!(
#line 8002 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8004 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_165 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case MULT:
      switch (pattern399 (x3))
        {
        case 0:
          if (!(
#line 7932 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7934 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_158 (insn, operands);

        case 1:
          if (!(
#line 7932 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7934 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_159 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      x7 = XEXP (x4, 1);
      operands[2] = x7;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[1] = x6;
          x5 = XEXP (x3, 1);
          switch (GET_CODE (x5))
            {
            case CONST_INT:
            case CONST_WIDE_INT:
            case CONST_POLY_INT:
            case CONST_FIXED:
            case CONST_DOUBLE:
            case CONST_VECTOR:
            case CONST:
            case REG:
            case SUBREG:
            case LABEL_REF:
            case SYMBOL_REF:
            case HIGH:
              operands[3] = x5;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern1066 (x3, 
E_QImode) != 0
                      || !(
#line 7953 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7955 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_160 (insn, operands);

                case E_HImode:
                  if (pattern1066 (x3, 
E_HImode) != 0
                      || !(
#line 7953 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7955 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_161 (insn, operands);

                case E_DImode:
                  if (pattern600 (x3, 
E_DImode) != 0
                      || !((
#line 14151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT / 2
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14165 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_472 (insn, operands);

                case E_TImode:
                  if (pattern600 (x3, 
E_TImode) != 0
                      || !((
#line 14151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 16 * BITS_PER_UNIT / 2
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1196 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14165 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_475 (insn, operands);

                default:
                  return NULL;
                }

            case ZERO_EXTEND:
              switch (pattern943 (x3))
                {
                case 0:
                  if (!((
#line 14074 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14076 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_436 (insn, operands);

                case 1:
                  if (!((
#line 14074 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14076 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_439 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case SIGN_EXTEND:
          switch (pattern711 (x3))
            {
            case 0:
              if (!((
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14112 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_448 (insn, operands);

            case 1:
              if (!((
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14112 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_454 (insn, operands);

            case 2:
              if (!((
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14197 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_478 (insn, operands);

            case 3:
              if (!((
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14197 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_484 (insn, operands);

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          switch (pattern711 (x3))
            {
            case 0:
              if (!((
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14112 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_451 (insn, operands);

            case 1:
              if (!((
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14112 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_457 (insn, operands);

            case 2:
              if (!((
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14197 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_481 (insn, operands);

            case 3:
              if (!((
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14197 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_487 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case ZERO_EXTEND:
      switch (pattern404 (x3))
        {
        case 0:
          if (!((
#line 14091 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14093 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_442 (insn, operands);

        case 1:
          if (!((
#line 14091 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14093 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_445 (insn, operands);

        case 2:
          if (!((
#line 14135 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14137 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_460 (insn, operands);

        case 3:
          if (!((
#line 14135 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14137 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_466 (insn, operands);

        case 4:
          if (!((
#line 14135 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14137 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_463 (insn, operands);

        case 5:
          if (!((
#line 14135 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14137 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_469 (insn, operands);

        case 6:
          if (!((
#line 14212 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(DImode == DImode
   ? CONST_INT_P (operands[2])
     && (UINTVAL (operands[2]) & GET_MODE_MASK (SImode)) == 0
     && !ix86_endbr_immediate_operand (operands[2], VOIDmode)
   : CONST_WIDE_INT_P (operands[2])
     && CONST_WIDE_INT_NUNITS (operands[2]) == 2
     && CONST_WIDE_INT_ELT (operands[2], 0) == 0
     && !ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[2],
								    1)),
				       VOIDmode)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14223 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_490 (insn, operands);

        case 7:
          if (!((
#line 14212 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TImode == DImode
   ? CONST_INT_P (operands[2])
     && (UINTVAL (operands[2]) & GET_MODE_MASK (SImode)) == 0
     && !ix86_endbr_immediate_operand (operands[2], VOIDmode)
   : CONST_WIDE_INT_P (operands[2])
     && CONST_WIDE_INT_NUNITS (operands[2]) == 2
     && CONST_WIDE_INT_ELT (operands[2], 0) == 0
     && !ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[2],
								    1)),
				       VOIDmode)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14223 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_493 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_18 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
      operands[1] = x5;
      if (!register_operand (operands[1], E_SImode))
        return NULL;
      x6 = XEXP (x2, 0);
      operands[0] = x6;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || GET_MODE (x4) != E_DImode)
        return NULL;
      x7 = XEXP (x3, 1);
      operands[2] = x7;
      if (!x86_64_zext_immediate_operand (operands[2], E_DImode)
          || !
#line 12612 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return NULL;
      return gen_split_292 (insn, operands);

    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x5;
      x8 = XEXP (x5, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return NULL;
      x9 = XEXP (x5, 2);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8]
          || GET_MODE (x3) != E_QImode
          || GET_MODE (x4) != E_QImode)
        return NULL;
      x10 = XEXP (x5, 0);
      if (!int248_register_operand (x10, E_VOIDmode))
        return NULL;
      operands[2] = x10;
      switch (pattern1666 (x2))
        {
        case 0:
          if ((
#line 12782 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_299 (insn, operands);
          break;

        case 1:
          if ((
#line 12782 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_302 (insn, operands);
          break;

        case 2:
          if (((
#line 12782 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12786 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_305 (insn, operands);
          break;

        default:
          break;
        }
      operands[1] = x10;
      switch (pattern1667 (x2))
        {
        case 0:
          if (!(
#line 12815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_308 (insn, operands);

        case 1:
          if (!(
#line 12815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_311 (insn, operands);

        case 2:
          if (!((
#line 12815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12817 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_314 (insn, operands);

        case 3:
          if (!
#line 13058 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_328 (insn, operands);

        case 4:
          if (!
#line 13058 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_331 (insn, operands);

        case 5:
          if (!(
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 13058 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_334 (insn, operands);

        default:
          return NULL;
        }

    case ROTATE:
      if (GET_MODE (x5) != E_SImode)
        return NULL;
      x10 = XEXP (x5, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + -2])
        return NULL;
      switch (pattern1418 (x2))
        {
        case 0:
          if (!(
#line 18974 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 18976 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_814 (insn, operands);

        case 1:
          if (!(
#line 18974 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 18976 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_815 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_25 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (pattern231 (x2, 
E_CCmode, 
17) != 0)
    return NULL;
  x3 = XVECEXP (x1, 0, 0);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x5;
      res = split_15 (x1, insn);
      if (res != NULL_RTX)
        return res;
      if (GET_CODE (x5) != SUBREG
          || pattern1165 (x4) != 0)
        return NULL;
      x6 = XEXP (x5, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      switch (pattern1666 (x3))
        {
        case 0:
          if ((
#line 7007 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7011 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_122 (insn, operands);
          break;

        case 1:
          if ((
#line 7007 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7011 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_123 (insn, operands);
          break;

        case 2:
          if (((
#line 7007 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 7011 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_124 (insn, operands);
          break;

        default:
          break;
        }
      operands[1] = x7;
      switch (pattern1667 (x3))
        {
        case 0:
          if (!(
#line 7040 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7042 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_125 (insn, operands);

        case 1:
          if (!(
#line 7040 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7042 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_126 (insn, operands);

        case 2:
          if (!((
#line 7040 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 7042 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_127 (insn, operands);

        case 3:
          if (!
#line 7495 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_140 (insn, operands);

        case 4:
          if (!
#line 7495 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_141 (insn, operands);

        case 5:
          if (!(
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 7495 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_142 (insn, operands);

        default:
          return NULL;
        }

    case ZERO_EXTEND:
      switch (pattern928 (x3))
        {
        case 0:
          if (!((
#line 6523 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 6525 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_106 (insn, operands);

        case 1:
          if (!((
#line 6523 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 6525 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_107 (insn, operands);

        default:
          return NULL;
        }

    case PLUS:
      x8 = XEXP (x3, 0);
      operands[0] = x8;
      x6 = XEXP (x5, 0);
      switch (GET_CODE (x6))
        {
        case ASHIFT:
          switch (pattern1141 (x4))
            {
            case 0:
              if (!((
#line 6554 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 6556 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_108 (insn, operands);

            case 1:
              if (!((
#line 6554 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 6556 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_111 (insn, operands);

            case 2:
              if (!((
#line 6585 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 6587 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_114 (insn, operands);

            case 3:
              if (!((
#line 6585 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 6587 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_117 (insn, operands);

            default:
              return NULL;
            }

        case EQ:
          switch (pattern1144 (x4))
            {
            case 0:
              if (!(
#line 10148 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_208 (insn, operands);

            case 1:
              if (!(
#line 10148 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_209 (insn, operands);

            case 2:
              if (!(
#line 10148 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_210 (insn, operands);

            case 3:
              if (!((
#line 10148 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_211 (insn, operands);

            default:
              return NULL;
            }

        case NE:
          switch (pattern1147 (x4))
            {
            case 0:
              if (!(
#line 10169 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (QImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10175 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_212 (insn, operands);

            case 1:
              if (!(
#line 10169 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (HImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10175 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_213 (insn, operands);

            case 2:
              if (!(
#line 10169 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (SImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10175 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_214 (insn, operands);

            case 3:
              if (!((
#line 10169 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (DImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10175 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_215 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case IOR:
      switch (pattern1048 (x3))
        {
        case 0:
          if (!((
#line 6554 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 6556 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_109 (insn, operands);

        case 1:
          if (!((
#line 6554 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 6556 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_112 (insn, operands);

        case 2:
          if (!((
#line 6585 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 6587 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_115 (insn, operands);

        case 3:
          if (!((
#line 6585 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 6587 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_118 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern1048 (x3))
        {
        case 0:
          if (!((
#line 6554 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 6556 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_110 (insn, operands);

        case 1:
          if (!((
#line 6554 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 6556 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_113 (insn, operands);

        case 2:
          if (!((
#line 6585 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 6587 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_116 (insn, operands);

        case 3:
          if (!((
#line 6585 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 6587 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_119 (insn, operands);

        default:
          return NULL;
        }

    case EQ:
      x9 = XEXP (x5, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      switch (pattern361 (x3))
        {
        case 0:
          if (!(
#line 10195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, QImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10198 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_216 (insn, operands);

        case 1:
          if (!(
#line 10195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, HImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10198 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_217 (insn, operands);

        case 2:
          if (!(
#line 10195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, SImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10198 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_218 (insn, operands);

        case 3:
          if (!((
#line 10195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10198 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_219 (insn, operands);

        default:
          return NULL;
        }

    case NE:
      x9 = XEXP (x5, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      switch (pattern361 (x3))
        {
        case 0:
          if (!(
#line 10216 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, QImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10219 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_220 (insn, operands);

        case 1:
          if (!(
#line 10216 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, HImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10219 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_221 (insn, operands);

        case 2:
          if (!(
#line 10216 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, SImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10219 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_222 (insn, operands);

        case 3:
          if (!((
#line 10216 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10219 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_223 (insn, operands);

        default:
          return NULL;
        }

    case MINUS:
      switch (pattern932 (x3))
        {
        case 0:
          if (!(
#line 10264 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (QImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10270 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_228 (insn, operands);

        case 1:
          if (!(
#line 10264 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (HImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10270 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_229 (insn, operands);

        case 2:
          if (!(
#line 10264 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (SImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10270 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_230 (insn, operands);

        case 3:
          if (!((
#line 10264 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (DImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10270 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_231 (insn, operands);

        case 4:
          if (!(
#line 10293 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (QImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10299 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_232 (insn, operands);

        case 5:
          if (!(
#line 10293 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (HImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10299 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_233 (insn, operands);

        case 6:
          if (!(
#line 10293 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (SImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 10299 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_234 (insn, operands);

        case 7:
          if (!((
#line 10293 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (DImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10299 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_235 (insn, operands);

        default:
          return NULL;
        }

    case UNSPEC:
      switch (pattern936 (x3))
        {
        case 0:
          if (!
#line 1408 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode))
            return NULL;
          return gen_split_926 (insn, operands);

        case 1:
          if (!
#line 1408 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode))
            return NULL;
          return gen_split_927 (insn, operands);

        case 2:
          if (!(
#line 23344 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 23346 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_929 (insn, operands);

        case 3:
          if (!((
#line 23403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)) && 
#line 23405 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_930 (insn, operands);

        case 4:
          if (!((
#line 23403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)) && 
#line 23405 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_931 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_38 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x5;
      x6 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x6))
        {
        case CLOBBER:
          x7 = XEXP (x6, 0);
          if (GET_CODE (x7) != REG
              || REGNO (x7) != 17
              || GET_MODE (x7) != E_CCmode)
            return NULL;
          if (register_operand (operands[0], E_VOIDmode)
              && register_operand (operands[1], E_VOIDmode)
              && 
#line 27768 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(! TARGET_PARTIAL_REG_STALL && reload_completed
   && (GET_MODE (operands[0]) == HImode
       || (GET_MODE (operands[0]) == QImode && TARGET_PROMOTE_QImode))))
            return gen_split_992 (insn, operands);
          if (GET_MODE (x4) != E_V2QImode)
            return NULL;
          if (general_reg_operand (operands[0], E_V2QImode)
              && general_reg_operand (operands[1], E_V2QImode)
              && 
#line 3152 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && reload_completed))
            return gen_split_1052 (insn, operands);
          if (!sse_reg_operand (operands[0], E_V2QImode)
              || !sse_reg_operand (operands[1], E_V2QImode)
              || !
#line 3179 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && reload_completed))
            return NULL;
          return gen_split_1053 (insn, operands);

        case USE:
          switch (pattern827 (x1))
            {
            case 0:
              if (!(
#line 683 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1032 (insn, operands);

            case 1:
              if (!(
#line 2239 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2241 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1041 (insn, operands);

            case 2:
              if (!((
#line 2239 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2224 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)) && 
#line 2241 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1043 (insn, operands);

            case 3:
              if (!(
#line 2239 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2241 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1045 (insn, operands);

            case 4:
              if (!((
#line 2239 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2225 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)) && 
#line 2241 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1047 (insn, operands);

            case 5:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 411 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1264 (insn, operands);

            case 6:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 412 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1266 (insn, operands);

            case 7:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 412 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1268 (insn, operands);

            case 8:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 413 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1270 (insn, operands);

            case 9:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 414 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1272 (insn, operands);

            case 10:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 414 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1274 (insn, operands);

            case 11:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1276 (insn, operands);

            case 12:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1278 (insn, operands);

            case 13:
              if (!(
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1280 (insn, operands);

            case 14:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 416 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1282 (insn, operands);

            case 15:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1284 (insn, operands);

            case 16:
              if (!((
#line 2589 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 2591 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1286 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case LTU:
    case UNLT:
      operands[1] = x5;
      if (!ix86_carry_flag_operator (operands[1], E_VOIDmode))
        return NULL;
      x8 = XEXP (x5, 0);
      if (GET_CODE (x8) != REG
          || REGNO (x8) != 17)
        return NULL;
      x9 = XEXP (x5, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x6 = XVECEXP (x1, 0, 1);
      if (pattern231 (x6, 
E_CCmode, 
17) != 0
          || !general_reg_operand (operands[0], E_VOIDmode)
          || !
#line 27798 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(! TARGET_PARTIAL_REG_STALL && reload_completed
   && (GET_MODE (operands[0]) == HImode
       || (GET_MODE (operands[0]) == QImode && TARGET_PROMOTE_QImode))))
        return NULL;
      return gen_split_994 (insn, operands);

    case ABS:
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != USE)
        return NULL;
      x8 = XEXP (x5, 0);
      operands[1] = x8;
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V2SFmode:
          if (pattern1044 (x4) != 0
              || !(
#line 700 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE) && 
#line 702 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
            return NULL;
          return gen_split_1033 (insn, operands);

        case E_V2BFmode:
          if (pattern1045 (x4, 
E_V2BFmode) != 0
              || !(
#line 2256 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2258 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
            return NULL;
          return gen_split_1048 (insn, operands);

        case E_V4BFmode:
          if (pattern1045 (x4, 
E_V4BFmode) != 0
              || !((
#line 2256 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2224 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)) && 
#line 2258 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
            return NULL;
          return gen_split_1049 (insn, operands);

        case E_V2HFmode:
          if (pattern1045 (x4, 
E_V2HFmode) != 0
              || !(
#line 2256 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2258 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
            return NULL;
          return gen_split_1050 (insn, operands);

        case E_V4HFmode:
          if (pattern1045 (x4, 
E_V4HFmode) != 0
              || !((
#line 2256 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2225 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)) && 
#line 2258 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
            return NULL;
          return gen_split_1051 (insn, operands);

        case E_V16SFmode:
          if (pattern1042 (x4, 
E_V16SFmode) != 0
              || !((
#line 2614 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 374 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2616 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_1287 (insn, operands);

        case E_V8SFmode:
          if (pattern1042 (x4, 
E_V8SFmode) != 0
              || !((
#line 2614 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 374 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2616 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_1288 (insn, operands);

        case E_V4SFmode:
          if (pattern1042 (x4, 
E_V4SFmode) != 0
              || !(
#line 2614 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 2616 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_1289 (insn, operands);

        case E_V8DFmode:
          if (pattern1042 (x4, 
E_V8DFmode) != 0
              || !((
#line 2614 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 375 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2616 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_1290 (insn, operands);

        case E_V4DFmode:
          if (pattern1042 (x4, 
E_V4DFmode) != 0
              || !((
#line 2614 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 375 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2616 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_1291 (insn, operands);

        case E_V2DFmode:
          if (pattern1042 (x4, 
E_V2DFmode) != 0
              || !((
#line 2614 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 376 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 2616 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_1292 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_50 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case LT:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V4HImode:
          if (pattern922 (x3, 
E_V4HImode) != 0
              || !
#line 3912 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
            return NULL;
          return gen_split_1060 (insn, operands);

        case E_V2SImode:
          if (pattern922 (x3, 
E_V2SImode) != 0
              || !
#line 3912 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
            return NULL;
          return gen_split_1061 (insn, operands);

        case E_V1DImode:
          if (pattern922 (x3, 
E_V1DImode) != 0
              || !
#line 3912 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
            return NULL;
          return gen_split_1062 (insn, operands);

        case E_V2HImode:
          if (pattern922 (x3, 
E_V2HImode) != 0
              || !
#line 3975 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
            return NULL;
          return gen_split_1064 (insn, operands);

        default:
          return NULL;
        }

    case REG:
      switch (pattern238 (x3))
        {
        case 0:
          if (!
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
            return NULL;
          return gen_split_1189 (insn, operands);

        case 1:
          if (!
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
            return NULL;
          return gen_split_1192 (insn, operands);

        case 2:
          if (!(
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return NULL;
          return gen_split_1195 (insn, operands);

        case 3:
          if (!(
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return NULL;
          return gen_split_1198 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_51 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != SS_TRUNCATE)
    return NULL;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != SS_TRUNCATE)
    return NULL;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  switch (pattern272 (x2))
    {
    case 0:
      if (!(
#line 4771 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE) && 
#line 4776 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed
   && SSE_REGNO_P (REGNO (operands[0])))))
        return NULL;
      return gen_split_1108 (insn, operands);

    case 1:
      if (!(
#line 4812 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE) && 
#line 4817 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed
   && SSE_REGNO_P (REGNO (operands[0])))))
        return NULL;
      return gen_split_1110 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_52 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_DUPLICATE)
    return NULL;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  x5 = XEXP (x3, 0);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  operands[1] = x6;
  x7 = XEXP (x2, 2);
  operands[3] = x7;
  if (!const_int_operand (operands[3], E_SImode))
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_V4HFmode:
      if (pattern1053 (x2, 
E_V4HFmode, 
E_HFmode) != 0
          || !
#line 5331 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && TARGET_SSE4_1 && reload_completed
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V4HFmode))))
        return NULL;
      return gen_split_1120 (insn, operands);

    case E_V4BFmode:
      if (pattern1053 (x2, 
E_V4BFmode, 
E_BFmode) != 0
          || !
#line 5331 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && TARGET_SSE4_1 && reload_completed
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V4BFmode))))
        return NULL;
      return gen_split_1121 (insn, operands);

    case E_V4HImode:
      if (pattern1053 (x2, 
E_V4HImode, 
E_HImode) != 0
          || !
#line 5331 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && TARGET_SSE4_1 && reload_completed
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V4HImode))))
        return NULL;
      return gen_split_1122 (insn, operands);

    case E_V2HFmode:
      if (pattern1053 (x2, 
E_V2HFmode, 
E_HFmode) != 0
          || !
#line 5996 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && reload_completed
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V2HFmode))))
        return NULL;
      return gen_split_1128 (insn, operands);

    case E_V2BFmode:
      if (pattern1053 (x2, 
E_V2BFmode, 
E_BFmode) != 0
          || !
#line 5996 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && reload_completed
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V2BFmode))))
        return NULL;
      return gen_split_1129 (insn, operands);

    case E_V2HImode:
      if (pattern1053 (x2, 
E_V2HImode, 
E_HImode) != 0
          || !
#line 5996 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && reload_completed
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V2HImode))))
        return NULL;
      return gen_split_1130 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_54 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_DImode)
    return NULL;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != UNSPEC
      || XVECLEN (x3, 0) != 1
      || XINT (x3, 1) != 49
      || GET_MODE (x3) != E_SImode)
    return NULL;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!register_operand (operands[0], E_DImode))
    return NULL;
  x5 = XVECEXP (x3, 0, 0);
  switch (GET_CODE (x5))
    {
    case LT:
      switch (pattern979 (x5))
        {
        case 0:
          if (!((
#line 22004 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22006 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3419 (insn, operands);

        case 1:
          if (!(
#line 22004 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 22006 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3421 (insn, operands);

        case 2:
          if (!((
#line 22004 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22006 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3423 (insn, operands);

        case 3:
          if (!((
#line 22004 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 22006 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3425 (insn, operands);

        case 4:
          if (!(
#line 22316 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 22318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3461 (insn, operands);

        default:
          return NULL;
        }

    case SUBREG:
      switch (pattern1074 (x5))
        {
        case 0:
          if (!((
#line 22029 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22031 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3427 (insn, operands);

        case 1:
          if (!(
#line 22029 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 22031 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3429 (insn, operands);

        case 2:
          if (!((
#line 22029 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22031 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3431 (insn, operands);

        case 3:
          if (!((
#line 22029 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 22031 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3433 (insn, operands);

        case 4:
          if (!((
#line 22068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22070 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3439 (insn, operands);

        case 5:
          if (!(
#line 22068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 22070 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3441 (insn, operands);

        case 6:
          if (!((
#line 22068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 22070 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3443 (insn, operands);

        case 7:
          if (!((
#line 22068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 22070 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
            return NULL;
          return gen_split_3445 (insn, operands);

        default:
          return NULL;
        }

    case VEC_MERGE:
      switch (pattern971 (x5))
        {
        case 0:
          if (!((
#line 22345 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 22347 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3462 (insn, operands);

        case 1:
          if (!(
#line 22345 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 22347 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3463 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_57 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 2);
  if (GET_CODE (x4) != UNSPEC
      || XVECLEN (x4, 0) != 3
      || XINT (x4, 1) != 59)
    return NULL;
  switch (pattern1000 (x2))
    {
    case 0:
      x5 = XVECEXP (x4, 0, 0);
      operands[3] = x5;
      switch (pattern1451 (x2))
        {
        case 0:
          if (((
#line 3332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)) && 
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1293 (insn, operands);
          break;

        case 1:
          if (((
#line 3332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 390 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1294 (insn, operands);
          break;

        case 2:
          if (((
#line 3332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 391 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1295 (insn, operands);
          break;

        case 3:
          if (((
#line 3332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1296 (insn, operands);
          break;

        case 4:
          if (((
#line 3332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1297 (insn, operands);
          break;

        case 5:
          if ((
#line 3332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1298 (insn, operands);
          break;

        case 6:
          if (((
#line 3332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1299 (insn, operands);
          break;

        case 7:
          if (((
#line 3332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1300 (insn, operands);
          break;

        case 8:
          if (((
#line 3332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 394 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1301 (insn, operands);
          break;

        case 9:
          if (((
#line 4217 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4221 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1338 (insn, operands);
          break;

        case 10:
          if ((
#line 4217 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4221 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1339 (insn, operands);
          break;

        case 11:
          if (((
#line 4217 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4221 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1340 (insn, operands);
          break;

        case 12:
          if (((
#line 4217 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 4221 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1341 (insn, operands);
          break;

        case 13:
          if ((
#line 4246 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4250 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1342 (insn, operands);
          break;

        case 14:
          if ((
#line 4246 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4250 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1343 (insn, operands);
          break;

        case 15:
          if (((
#line 4246 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4250 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1344 (insn, operands);
          break;

        case 16:
          if (((
#line 4246 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4250 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1345 (insn, operands);
          break;

        case 17:
          if (((
#line 18013 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[2]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[1])))) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 18018 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3296 (insn, operands);
          break;

        case 18:
          if ((
#line 18013 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[2]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[1])))) && 
#line 18018 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3297 (insn, operands);
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG)
        return NULL;
      switch (pattern1454 (x2))
        {
        case 0:
          if (!(
#line 4281 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* not LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1346 (insn, operands);

        case 1:
          if (!(
#line 4281 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* not LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1347 (insn, operands);

        case 2:
          if (!((
#line 4281 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* not LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1348 (insn, operands);

        case 3:
          if (!((
#line 4281 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* not LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1349 (insn, operands);

        case 4:
          if (!((
#line 18042 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  && GET_MODE_CLASS (GET_MODE (operands[3])) == MODE_VECTOR_INT
  && GET_MODE_SIZE (GET_MODE (operands[3])) == 32
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[1]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[2])))) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 18049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3298 (insn, operands);

        case 5:
          if (!(
#line 18042 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  && GET_MODE_CLASS (GET_MODE (operands[3])) == MODE_VECTOR_INT
  && GET_MODE_SIZE (GET_MODE (operands[3])) == 16
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[1]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[2])))) && 
#line 18049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3299 (insn, operands);

        default:
          return NULL;
        }

    case 1:
      if (!((
#line 18074 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[1]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[2])))) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 18079 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_3300 (insn, operands);

    case 2:
      if (!(
#line 18074 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[1]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[2])))) && 
#line 18079 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_3301 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_67 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern529 (x2))
        {
        case 0:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1684 (insn, operands);

        case 1:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1711 (insn, operands);

        case 2:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1738 (insn, operands);

        case 3:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1765 (insn, operands);

        case 4:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1792 (insn, operands);

        case 5:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1819 (insn, operands);

        case 6:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1846 (insn, operands);

        case 7:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1873 (insn, operands);

        case 8:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1900 (insn, operands);

        case 9:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1927 (insn, operands);

        case 10:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1954 (insn, operands);

        case 11:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1981 (insn, operands);

        case 12:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1687 (insn, operands);

        case 13:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1714 (insn, operands);

        case 14:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1741 (insn, operands);

        case 15:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1768 (insn, operands);

        case 16:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1795 (insn, operands);

        case 17:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1822 (insn, operands);

        case 18:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1849 (insn, operands);

        case 19:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1876 (insn, operands);

        case 20:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1903 (insn, operands);

        case 21:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1930 (insn, operands);

        case 22:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1957 (insn, operands);

        case 23:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1984 (insn, operands);

        case 24:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1690 (insn, operands);

        case 25:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1717 (insn, operands);

        case 26:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1744 (insn, operands);

        case 27:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1771 (insn, operands);

        case 28:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1798 (insn, operands);

        case 29:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1825 (insn, operands);

        case 30:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1852 (insn, operands);

        case 31:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1879 (insn, operands);

        case 32:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1906 (insn, operands);

        case 33:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1933 (insn, operands);

        case 34:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1960 (insn, operands);

        case 35:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1987 (insn, operands);

        case 36:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2968 (insn, operands);

        case 37:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2977 (insn, operands);

        case 38:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2986 (insn, operands);

        case 39:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2995 (insn, operands);

        case 40:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3004 (insn, operands);

        case 41:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3013 (insn, operands);

        case 42:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3022 (insn, operands);

        case 43:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3031 (insn, operands);

        case 44:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3040 (insn, operands);

        case 45:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3049 (insn, operands);

        case 46:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3058 (insn, operands);

        case 47:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3067 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      switch (pattern531 (x2))
        {
        case 0:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2332 (insn, operands);

        case 1:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2359 (insn, operands);

        case 2:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2386 (insn, operands);

        case 3:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2413 (insn, operands);

        case 4:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2440 (insn, operands);

        case 5:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2467 (insn, operands);

        case 6:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2494 (insn, operands);

        case 7:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2521 (insn, operands);

        case 8:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2548 (insn, operands);

        case 9:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2575 (insn, operands);

        case 10:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2602 (insn, operands);

        case 11:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2629 (insn, operands);

        default:
          return NULL;
        }

    case IOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2335 (insn, operands);

        case 1:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2362 (insn, operands);

        case 2:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2389 (insn, operands);

        case 3:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2416 (insn, operands);

        case 4:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2443 (insn, operands);

        case 5:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2470 (insn, operands);

        case 6:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2497 (insn, operands);

        case 7:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2524 (insn, operands);

        case 8:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2551 (insn, operands);

        case 9:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2578 (insn, operands);

        case 10:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2605 (insn, operands);

        case 11:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2632 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2338 (insn, operands);

        case 1:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2365 (insn, operands);

        case 2:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2392 (insn, operands);

        case 3:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2419 (insn, operands);

        case 4:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2446 (insn, operands);

        case 5:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2473 (insn, operands);

        case 6:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2500 (insn, operands);

        case 7:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2527 (insn, operands);

        case 8:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2554 (insn, operands);

        case 9:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2581 (insn, operands);

        case 10:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2608 (insn, operands);

        case 11:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2635 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_76 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern533 (x2))
            {
            case 0:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1989 (insn, operands);

            case 1:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2016 (insn, operands);

            case 2:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2043 (insn, operands);

            case 3:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2070 (insn, operands);

            case 4:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2097 (insn, operands);

            case 5:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2124 (insn, operands);

            case 6:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2151 (insn, operands);

            case 7:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2178 (insn, operands);

            case 8:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2205 (insn, operands);

            case 9:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2232 (insn, operands);

            case 10:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2259 (insn, operands);

            case 11:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2286 (insn, operands);

            case 12:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1992 (insn, operands);

            case 13:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2019 (insn, operands);

            case 14:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2046 (insn, operands);

            case 15:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2073 (insn, operands);

            case 16:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2100 (insn, operands);

            case 17:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2127 (insn, operands);

            case 18:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2154 (insn, operands);

            case 19:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2181 (insn, operands);

            case 20:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2208 (insn, operands);

            case 21:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2235 (insn, operands);

            case 22:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2262 (insn, operands);

            case 23:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2289 (insn, operands);

            case 24:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1995 (insn, operands);

            case 25:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2022 (insn, operands);

            case 26:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2049 (insn, operands);

            case 27:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2076 (insn, operands);

            case 28:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2103 (insn, operands);

            case 29:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2130 (insn, operands);

            case 30:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2157 (insn, operands);

            case 31:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2184 (insn, operands);

            case 32:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2211 (insn, operands);

            case 33:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2238 (insn, operands);

            case 34:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2265 (insn, operands);

            case 35:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2292 (insn, operands);

            case 36:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3069 (insn, operands);

            case 37:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3078 (insn, operands);

            case 38:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3087 (insn, operands);

            case 39:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3096 (insn, operands);

            case 40:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3105 (insn, operands);

            case 41:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3114 (insn, operands);

            case 42:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3123 (insn, operands);

            case 43:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3132 (insn, operands);

            case 44:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3141 (insn, operands);

            case 45:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3150 (insn, operands);

            case 46:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3159 (insn, operands);

            case 47:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3168 (insn, operands);

            default:
              return NULL;
            }

        case AND:
          switch (pattern534 (x2))
            {
            case 0:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2637 (insn, operands);

            case 1:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2664 (insn, operands);

            case 2:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2691 (insn, operands);

            case 3:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2718 (insn, operands);

            case 4:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2745 (insn, operands);

            case 5:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2772 (insn, operands);

            case 6:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2799 (insn, operands);

            case 7:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2826 (insn, operands);

            case 8:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2853 (insn, operands);

            case 9:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2880 (insn, operands);

            case 10:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2907 (insn, operands);

            case 11:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2934 (insn, operands);

            default:
              return NULL;
            }

        case IOR:
          switch (pattern534 (x2))
            {
            case 0:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2640 (insn, operands);

            case 1:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2667 (insn, operands);

            case 2:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2694 (insn, operands);

            case 3:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2721 (insn, operands);

            case 4:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2748 (insn, operands);

            case 5:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2775 (insn, operands);

            case 6:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2802 (insn, operands);

            case 7:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2829 (insn, operands);

            case 8:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2856 (insn, operands);

            case 9:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2883 (insn, operands);

            case 10:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2910 (insn, operands);

            case 11:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2937 (insn, operands);

            default:
              return NULL;
            }

        case XOR:
          switch (pattern534 (x2))
            {
            case 0:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2643 (insn, operands);

            case 1:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2670 (insn, operands);

            case 2:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2697 (insn, operands);

            case 3:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2724 (insn, operands);

            case 4:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2751 (insn, operands);

            case 5:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2778 (insn, operands);

            case 6:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2805 (insn, operands);

            case 7:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2832 (insn, operands);

            case 8:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2859 (insn, operands);

            case 9:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2886 (insn, operands);

            case 10:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2913 (insn, operands);

            case 11:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2940 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case IOR:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern533 (x2))
            {
            case 0:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1998 (insn, operands);

            case 1:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2025 (insn, operands);

            case 2:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2052 (insn, operands);

            case 3:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2079 (insn, operands);

            case 4:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2106 (insn, operands);

            case 5:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2133 (insn, operands);

            case 6:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2160 (insn, operands);

            case 7:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2187 (insn, operands);

            case 8:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2214 (insn, operands);

            case 9:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2241 (insn, operands);

            case 10:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2268 (insn, operands);

            case 11:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2295 (insn, operands);

            case 12:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2001 (insn, operands);

            case 13:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2028 (insn, operands);

            case 14:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2055 (insn, operands);

            case 15:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2082 (insn, operands);

            case 16:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2109 (insn, operands);

            case 17:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2136 (insn, operands);

            case 18:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2163 (insn, operands);

            case 19:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2190 (insn, operands);

            case 20:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2217 (insn, operands);

            case 21:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2244 (insn, operands);

            case 22:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2271 (insn, operands);

            case 23:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2298 (insn, operands);

            case 24:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2004 (insn, operands);

            case 25:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2031 (insn, operands);

            case 26:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2058 (insn, operands);

            case 27:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2085 (insn, operands);

            case 28:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2112 (insn, operands);

            case 29:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2139 (insn, operands);

            case 30:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2166 (insn, operands);

            case 31:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2193 (insn, operands);

            case 32:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2220 (insn, operands);

            case 33:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2247 (insn, operands);

            case 34:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2274 (insn, operands);

            case 35:
              if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2301 (insn, operands);

            case 36:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3072 (insn, operands);

            case 37:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3081 (insn, operands);

            case 38:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3090 (insn, operands);

            case 39:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3099 (insn, operands);

            case 40:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3108 (insn, operands);

            case 41:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3117 (insn, operands);

            case 42:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3126 (insn, operands);

            case 43:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3135 (insn, operands);

            case 44:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3144 (insn, operands);

            case 45:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3153 (insn, operands);

            case 46:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3162 (insn, operands);

            case 47:
              if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3171 (insn, operands);

            default:
              return NULL;
            }

        case AND:
          switch (pattern534 (x2))
            {
            case 0:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2646 (insn, operands);

            case 1:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2673 (insn, operands);

            case 2:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2700 (insn, operands);

            case 3:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2727 (insn, operands);

            case 4:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2754 (insn, operands);

            case 5:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2781 (insn, operands);

            case 6:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2808 (insn, operands);

            case 7:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2835 (insn, operands);

            case 8:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2862 (insn, operands);

            case 9:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2889 (insn, operands);

            case 10:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2916 (insn, operands);

            case 11:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2943 (insn, operands);

            default:
              return NULL;
            }

        case IOR:
          switch (pattern534 (x2))
            {
            case 0:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2649 (insn, operands);

            case 1:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2676 (insn, operands);

            case 2:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2703 (insn, operands);

            case 3:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2730 (insn, operands);

            case 4:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2757 (insn, operands);

            case 5:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2784 (insn, operands);

            case 6:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2811 (insn, operands);

            case 7:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2838 (insn, operands);

            case 8:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2865 (insn, operands);

            case 9:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2892 (insn, operands);

            case 10:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2919 (insn, operands);

            case 11:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2946 (insn, operands);

            default:
              return NULL;
            }

        case XOR:
          switch (pattern534 (x2))
            {
            case 0:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2652 (insn, operands);

            case 1:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2679 (insn, operands);

            case 2:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2706 (insn, operands);

            case 3:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2733 (insn, operands);

            case 4:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2760 (insn, operands);

            case 5:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2787 (insn, operands);

            case 6:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2814 (insn, operands);

            case 7:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2841 (insn, operands);

            case 8:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2868 (insn, operands);

            case 9:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2895 (insn, operands);

            case 10:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2922 (insn, operands);

            case 11:
              if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2949 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case XOR:
      return split_70 (x1, insn);

    default:
      return NULL;
    }
}
