/* do not edit automatically generated by mc from M2Base.  */
/* M2Base.mod provides a mechanism to check fundamental types.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "Gmcrts.h"
#define _M2Base_C

#include "GM2Base.h"
#   include "GDynamicStrings.h"
#   include "GM2LexBuf.h"
#   include "GNameKey.h"
#   include "GM2Debug.h"
#   include "GSYSTEM.h"
#   include "GM2Error.h"
#   include "GM2Pass.h"
#   include "GFormatStrings.h"
#   include "GStrLib.h"
#   include "GM2MetaError.h"
#   include "GSymbolTable.h"
#   include "GM2ALU.h"
#   include "GM2Batch.h"
#   include "GM2Bitset.h"
#   include "GM2Size.h"
#   include "GM2System.h"
#   include "GM2Options.h"
#   include "Gm2type.h"
#   include "Gm2expr.h"
#   include "Ggcctypes.h"
#   include "Gm2linemap.h"
#   include "Gm2decl.h"

typedef struct M2Base_CompatibilityArray_a M2Base_CompatibilityArray;

typedef struct M2Base__T1_a M2Base__T1;

typedef enum {M2Base_const, M2Base_word, M2Base_byte, M2Base_address, M2Base_chr, M2Base_normint, M2Base_shortint, M2Base_longint, M2Base_normcard, M2Base_shortcard, M2Base_longcard, M2Base_pointer, M2Base_enum, M2Base_real, M2Base_shortreal, M2Base_longreal, M2Base_set, M2Base_opaque, M2Base_loc, M2Base_rtype, M2Base_ztype, M2Base_int8, M2Base_int16, M2Base_int32, M2Base_int64, M2Base_card8, M2Base_card16, M2Base_card32, M2Base_card64, M2Base_word16, M2Base_word32, M2Base_word64, M2Base_real32, M2Base_real64, M2Base_real96, M2Base_real128, M2Base_set8, M2Base_set16, M2Base_set32, M2Base_complex, M2Base_shortcomplex, M2Base_longcomplex, M2Base_complex32, M2Base_complex64, M2Base_complex96, M2Base_complex128, M2Base_ctype, M2Base_rec, M2Base_array, M2Base_procedure, M2Base_unknown} M2Base_MetaType;

typedef enum {M2Base_uninitialized, M2Base_no, M2Base_warnfirst, M2Base_warnsecond, M2Base_first, M2Base_second} M2Base_Compatible;

typedef enum {M2Base_expression, M2Base_assignment, M2Base_parameter, M2Base_comparison} M2Base_Compatability;

struct M2Base__T1_a { M2Base_Compatible array[M2Base_unknown-M2Base_const+1]; };
struct M2Base_CompatibilityArray_a { M2Base__T1 array[M2Base_unknown-M2Base_const+1]; };
static M2Base_CompatibilityArray Comp;
static M2Base_CompatibilityArray Expr;
static M2Base_CompatibilityArray Ass;
static unsigned int Ord;
static unsigned int OrdS;
static unsigned int OrdL;
static unsigned int Float;
static unsigned int FloatS;
static unsigned int SFloat;
static unsigned int FloatL;
static unsigned int LFloat;
static unsigned int Trunc;
static unsigned int TruncS;
static unsigned int TruncL;
static unsigned int Int;
static unsigned int IntS;
static unsigned int IntL;
static unsigned int m2rts;
static unsigned int MinReal;
static unsigned int MaxReal;
static unsigned int MinShortReal;
static unsigned int MaxShortReal;
static unsigned int MinLongReal;
static unsigned int MaxLongReal;
static unsigned int MinLongInt;
static unsigned int MaxLongInt;
static unsigned int MinLongCard;
static unsigned int MaxLongCard;
static unsigned int MinShortInt;
static unsigned int MaxShortInt;
static unsigned int MinShortCard;
static unsigned int MaxShortCard;
static unsigned int MinChar;
static unsigned int MaxChar;
static unsigned int MinCardinal;
static unsigned int MaxCardinal;
static unsigned int MinInteger;
static unsigned int MaxInteger;
static unsigned int MaxEnum;
static unsigned int MinEnum;

/*
   InitBase - initializes the base types and procedures
              used in the Modula-2 compiler.
*/

extern "C" void M2Base_InitBase (location_t location, unsigned int *sym);

/*
   GetBaseTypeMinMax - returns the minimum and maximum values for a
                       given base type. This procedure should only
                       be called if the type is NOT a subrange.
*/

extern "C" void M2Base_GetBaseTypeMinMax (unsigned int type, unsigned int *min, unsigned int *max);

/*
   IsPseudoBaseFunction - returns true if Sym is a Base pseudo function.
*/

extern "C" bool M2Base_IsPseudoBaseFunction (unsigned int Sym);

/*
   IsPseudoBaseProcedure - returns true if Sym is a Base pseudo procedure.
*/

extern "C" bool M2Base_IsPseudoBaseProcedure (unsigned int Sym);

/*
   IsNeededAtRunTime - returns TRUE if procedure, sym, is a
                       runtime procedure.  A runtime procedure is
                       not a pseudo procedure (like NEW/DISPOSE)
                       and it is implemented in M2RTS or SYSTEM
                       and also exported.
*/

extern "C" bool M2Base_IsNeededAtRunTime (unsigned int tok, unsigned int sym);

/*
   IsBaseType - returns TRUE if Sym is a Base type.
*/

extern "C" bool M2Base_IsBaseType (unsigned int Sym);

/*
   IsOrdinalType - returns TRUE if, sym, is an ordinal type.
                   An ordinal type is defined as:
                   a base type which contains whole numbers or
                   a subrange type or an enumeration type.
*/

extern "C" bool M2Base_IsOrdinalType (unsigned int Sym);

/*
   IsOrd - returns TRUE if, sym, is ORD or its typed counterparts
           ORDL, ORDS.
*/

extern "C" bool M2Base_IsOrd (unsigned int sym);

/*
   IsTrunc - returns TRUE if, sym, is TRUNC or its typed counterparts
             TRUNCL, TRUNCS.
*/

extern "C" bool M2Base_IsTrunc (unsigned int sym);

/*
   IsFloat - returns TRUE if, sym, is FLOAT or its typed counterparts
             FLOATL, FLOATS.
*/

extern "C" bool M2Base_IsFloat (unsigned int sym);

/*
   IsInt - returns TRUE if, sym, is INT or its typed counterparts
           INTL, INTS.
*/

extern "C" bool M2Base_IsInt (unsigned int sym);

/*
   AssignmentRequiresWarning - returns TRUE if t1 and t2 can be used during
                               an assignment, but should generate a warning.
                               For example in PIM we can assign ADDRESS
                               and WORD providing they are both the
                               same size.
                               No warning is necessary if the types are the same.
*/

extern "C" bool M2Base_AssignmentRequiresWarning (unsigned int t1, unsigned int t2);

/*
   IsAssignmentCompatible - returns TRUE if t1 and t2 are assignment
                            compatible.
*/

extern "C" bool M2Base_IsAssignmentCompatible (unsigned int t1, unsigned int t2);

/*
   IsExpressionCompatible - returns TRUE if t1 and t2 are expression
                            compatible.
*/

extern "C" bool M2Base_IsExpressionCompatible (unsigned int t1, unsigned int t2);

/*
   IsParameterCompatible - returns TRUE if t1 and t2 are expression
                           compatible.
*/

extern "C" bool M2Base_IsParameterCompatible (unsigned int t1, unsigned int t2);

/*
   IsComparisonCompatible - returns TRUE if t1 and t2 are comparison compatible.
*/

extern "C" bool M2Base_IsComparisonCompatible (unsigned int t1, unsigned int t2);

/*
   IsValidParameter - returns TRUE if an, actual, parameter can be passed
                      to the, formal, parameter.  This differs from
                      IsParameterCompatible as this procedure includes checks
                      for unbounded formal parameters, var parameters and
                      constant actual parameters.
*/

extern "C" bool M2Base_IsValidParameter (unsigned int formal, unsigned int actual);

/*
   CheckExpressionCompatible - returns if t1 and t2 are compatible types for
                               +, -, *, DIV, >, <, =, etc.
                               If t1 and t2 are not compatible then an error
                               message is displayed.
*/

extern "C" void M2Base_CheckExpressionCompatible (unsigned int tok, unsigned int left, unsigned int right);

/*
   CheckAssignmentCompatible - returns if t1 and t2 are compatible types for
                               :=, =, #.
                               If t1 and t2 are not compatible then an error
                               message is displayed.
*/

extern "C" void M2Base_CheckAssignmentCompatible (unsigned int tok, unsigned int left, unsigned int right);

/*
   CheckParameterCompatible - checks to see if types, t1, and, t2, are
                              compatible for parameter passing.
*/

extern "C" void M2Base_CheckParameterCompatible (unsigned int tok, unsigned int t1, unsigned int t2);

/*
   CannotCheckTypeInPass3 - returns TRUE if we are unable to check the
                            type of, e, in pass 3.
*/

extern "C" bool M2Base_CannotCheckTypeInPass3 (unsigned int e);

/*
   MixTypes - given types leftType and rightType return a type symbol that
              provides expression type compatibility.
              NearTok is used to identify the source position if a type
              incompatability occurs.
*/

extern "C" unsigned int M2Base_MixTypes (unsigned int leftType, unsigned int rightType, unsigned int NearTok);

/*
   MixTypesDecl - returns a type symbol which provides expression compatibility
                  between leftType and rightType.  An error is emitted if this
                  is not possible.  left and right are the source (variable,
                  constant) of leftType and rightType respectively.
*/

extern "C" unsigned int M2Base_MixTypesDecl (unsigned int left, unsigned int right, unsigned int leftType, unsigned int rightType, unsigned int NearTok);

/*
   NegateType - if the type is unsigned then returns the
                signed equivalent.
*/

extern "C" unsigned int M2Base_NegateType (unsigned int type);

/*
   IsMathType - returns TRUE if the type is a mathematical type.
                A mathematical type has a range larger than INTEGER.
                (Typically SHORTREAL/REAL/LONGREAL/LONGINT/LONGCARD)
*/

extern "C" bool M2Base_IsMathType (unsigned int type);

/*
   IsRealType - returns TRUE if, t, is a real type.
*/

extern "C" bool M2Base_IsRealType (unsigned int t);

/*
   IsComplexType - returns TRUE if, sym, is COMPLEX,
                   LONGCOMPLEX or SHORTCOMPLEX.
*/

extern "C" bool M2Base_IsComplexType (unsigned int sym);

/*
   ComplexToScalar - returns the scalar (or base type) of the complex type, sym.
*/

extern "C" unsigned int M2Base_ComplexToScalar (unsigned int sym);

/*
   ScalarToComplex - given a real type, t, return the equivalent complex type.
*/

extern "C" unsigned int M2Base_ScalarToComplex (unsigned int sym);

/*
   GetCmplxReturnType - this code implements the table given in the
                        ISO standard Page 293 with an addition for
                        SHORTCOMPLEX.
*/

extern "C" unsigned int M2Base_GetCmplxReturnType (unsigned int t1, unsigned int t2);

/*
   InitBuiltins -
*/

static void InitBuiltins (void);

/*
   InitBaseConstants - initialises the base constant NIL.
*/

static void InitBaseConstants (void);

/*
   InitBaseSimpleTypes - initialises the base simple types,
                         CARDINAL, INTEGER, CHAR, BOOLEAN.
*/

static void InitBaseSimpleTypes (location_t location);

/*
   FindMinMaxEnum - finds the minimum and maximum enumeration fields.
*/

static void FindMinMaxEnum (unsigned int field);

/*
   ImportFrom - imports symbol, name, from module and returns the
                symbol.
*/

static unsigned int ImportFrom (unsigned int tok, unsigned int module, const char *name_, unsigned int _name_high);

/*
   InitBaseProcedures - initialises the base procedures,
                        INC, DEC, INCL, EXCL, NEW and DISPOSE.
*/

static void InitBaseProcedures (void);

/*
   BuildOrdFunctions - creates ORD, ORDS, ORDL.
*/

static void BuildOrdFunctions (void);

/*
   BuildTruncFunctions - creates TRUNC, TRUNCS, TRUNCL.
*/

static void BuildTruncFunctions (void);

/*
   BuildFloatFunctions - creates TRUNC, TRUNCS, TRUNCL.
*/

static void BuildFloatFunctions (void);

/*
   BuildIntFunctions - creates INT, INTS, INTL.
*/

static void BuildIntFunctions (void);

/*
   InitBaseFunctions - initialises the base function, HIGH.
*/

static void InitBaseFunctions (void);

/*
   IsISOPseudoBaseFunction -
*/

static bool IsISOPseudoBaseFunction (unsigned int Sym);

/*
   IsPIMPseudoBaseFunction -
*/

static bool IsPIMPseudoBaseFunction (unsigned int Sym);

/*
   EmitTypeIncompatibleWarning - emit a type incompatibility warning.
*/

static void EmitTypeIncompatibleWarning (unsigned int tok, M2Base_Compatability kind, unsigned int t1, unsigned int t2);

/*
   EmitTypeIncompatibleError - emit a type incompatibility error.
*/

static void EmitTypeIncompatibleError (unsigned int tok, M2Base_Compatability kind, unsigned int t1, unsigned int t2);

/*
   CheckCompatible - returns if t1 and t2 are kind compatible
*/

static void CheckCompatible (unsigned int tok, unsigned int t1, unsigned int t2, M2Base_Compatability kind);

/*
   FindMetaType - returns the MetaType associated with, sym.
*/

static M2Base_MetaType FindMetaType (unsigned int sym);

/*
   IsBaseCompatible - returns an enumeration field determining whether a simple base type
                      comparison is legal.
*/

static M2Base_Compatible IsBaseCompatible (unsigned int t1, unsigned int t2, M2Base_Compatability kind);

/*
   IsCompatible - returns true if the types, t1, and, t2, are compatible.
*/

static M2Base_Compatible IsCompatible (unsigned int t1, unsigned int t2, M2Base_Compatability kind);

/*
   IsPointerSame - returns TRUE if pointers, a, and, b, are the same.
*/

static bool IsPointerSame (unsigned int a, unsigned int b, bool error);

/*
   IsSubrangeSame - checks to see whether the subranges are the same.
*/

static bool IsSubrangeSame (unsigned int a, unsigned int b);

/*
   IsVarientSame - returns TRUE if varient types, a, and, b, are identical.
*/

static bool IsVarientSame (unsigned int a, unsigned int b, bool error);

/*
   IsRecordSame -
*/

static bool IsRecordSame (unsigned int a, unsigned int b, bool error);

/*
   IsArraySame -
*/

static bool IsArraySame (unsigned int t1, unsigned int t2, bool error);

/*
   IsEnumerationSame -
*/

static bool IsEnumerationSame (unsigned int t1, unsigned int t2);

/*
   IsSetSame -
*/

static bool IsSetSame (unsigned int t1, unsigned int t2, bool error);

/*
   IsSameType - returns TRUE if
*/

static bool IsSameType (unsigned int t1, unsigned int t2, bool error);

/*
   IsProcTypeSame -
*/

static bool IsProcTypeSame (unsigned int p1, unsigned int p2, bool error);

/*
   doProcTypeCheck -
*/

static bool doProcTypeCheck (unsigned int p1, unsigned int p2, bool error);

/*
   AfterResolved - a thorough test for type compatibility.
*/

static M2Base_Compatible AfterResolved (unsigned int t1, unsigned int t2, M2Base_Compatability kind);

/*
   BeforeResolved - attempts to test for type compatibility before all types are
                    completely resolved.  In particular set types and constructor
                    types are not fully known before the end of pass 3.
                    However we can test base types.
*/

static M2Base_Compatible BeforeResolved (unsigned int t1, unsigned int t2, M2Base_Compatability kind);

/*
   MixMetaTypes -
*/

static unsigned int MixMetaTypes (unsigned int left, unsigned int right, unsigned int leftType, unsigned int rightType, unsigned int NearTok);

/*
   IsUserType - return TRUE if type was created by the user as a synonym.
*/

static bool IsUserType (unsigned int type);

/*
   IsVarParamCompatible - returns TRUE if types, actual, and, formal
                          are compatible even if formal is a VAR
                          parameter.
*/

static bool IsVarParamCompatible (unsigned int actual, unsigned int formal);

/*
   IsArrayUnboundedCompatible - returns TRUE if unbounded or array types, t1, and, t2,
                                are compatible.
*/

static bool IsArrayUnboundedCompatible (unsigned int t1, unsigned int t2);

/*
   IsValidUnboundedParameter -
*/

static bool IsValidUnboundedParameter (unsigned int formal, unsigned int actual);

/*
   PushSizeOf - pushes the size of a meta type.
*/

static void PushSizeOf (M2Base_MetaType t);

/*
   IsSizeSame -
*/

static bool IsSizeSame (M2Base_MetaType t1, M2Base_MetaType t2);

/*
   InitArray -
*/

static void InitArray (M2Base_CompatibilityArray *c, M2Base_MetaType y, const char *a_, unsigned int _a_high);

/*
   A - initialize the assignment array
*/

static void A (M2Base_MetaType y, const char *a_, unsigned int _a_high);

/*
   E - initialize the expression array
*/

static void E (M2Base_MetaType y, const char *a_, unsigned int _a_high);

/*
   C - initialize the comparision array
*/

static void C (M2Base_MetaType y, const char *a_, unsigned int _a_high);

/*
   InitCompatibilityMatrices - initializes the tables above.
*/

static void InitCompatibilityMatrices (void);


/*
   InitBuiltins -
*/

static void InitBuiltins (void)
{
  unsigned int builtins;

  if (M2Options_DebugBuiltins)
    {
      /* We will need to parse this module as functions alloca/memcpy will be used.  */
      builtins = M2Batch_MakeDefinitionSource (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "Builtins", 8));
      if (builtins == SymbolTable_NulSym)
        {
          M2MetaError_MetaError0 ((const char *) "unable to find core module Builtins", 35);
        }
    }
}


/*
   InitBaseConstants - initialises the base constant NIL.
*/

static void InitBaseConstants (void)
{
  M2Base_Nil = SymbolTable_MakeConstVar (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "NIL", 3));
  SymbolTable_PutConst (M2Base_Nil, M2System_Address);
}


/*
   InitBaseSimpleTypes - initialises the base simple types,
                         CARDINAL, INTEGER, CHAR, BOOLEAN.
*/

static void InitBaseSimpleTypes (location_t location)
{
  m2type_InitBaseTypes (location);
  M2Base_ZType = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "Modula-2 base Z", 15));
  SymbolTable_PutType (M2Base_ZType, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2ZType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_ZType);
  M2Base_RType = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "Modula-2 base R", 15));
  SymbolTable_PutType (M2Base_RType, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2RType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_RType);
  M2Base_CType = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "Modula-2 base C", 15));
  SymbolTable_PutType (M2Base_CType, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2CType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_CType);
  M2Base_Integer = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "INTEGER", 7));
  SymbolTable_PutType (M2Base_Integer, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2IntegerType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_Integer);
  M2Base_Cardinal = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "CARDINAL", 8));
  SymbolTable_PutType (M2Base_Cardinal, SymbolTable_NulSym);
  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2CardinalType ()));
  SymbolTable_PopSize (M2Base_Cardinal);
  M2Base_LongInt = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "LONGINT", 7));
  SymbolTable_PutType (M2Base_LongInt, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2LongIntType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_LongInt);
  M2Base_LongCard = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "LONGCARD", 8));
  SymbolTable_PutType (M2Base_LongCard, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2LongCardType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_LongCard);
  M2Base_ShortInt = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SHORTINT", 8));
  SymbolTable_PutType (M2Base_ShortInt, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2ShortIntType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_ShortInt);
  M2Base_ShortCard = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SHORTCARD", 9));
  SymbolTable_PutType (M2Base_ShortCard, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2ShortCardType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_ShortCard);
  M2Base_Real = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "REAL", 4));
  SymbolTable_PutType (M2Base_Real, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2RealType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_Real);
  M2Base_ShortReal = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SHORTREAL", 9));
  SymbolTable_PutType (M2Base_ShortReal, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2ShortRealType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_ShortReal);
  M2Base_LongReal = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "LONGREAL", 8));
  SymbolTable_PutType (M2Base_LongReal, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2LongRealType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_LongReal);
  M2Base_Complex = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "COMPLEX", 7));
  SymbolTable_PutType (M2Base_Complex, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2ComplexType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_Complex);
  M2Base_LongComplex = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "LONGCOMPLEX", 11));
  SymbolTable_PutType (M2Base_LongComplex, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2LongComplexType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_LongComplex);
  M2Base_ShortComplex = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SHORTCOMPLEX", 12));
  SymbolTable_PutType (M2Base_ShortComplex, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2ShortComplexType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_ShortComplex);
  M2Base_Char = SymbolTable_MakeType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "CHAR", 4));
  SymbolTable_PutType (M2Base_Char, SymbolTable_NulSym);  /* Base Type  */
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetM2CharType ()));  /* Base Type  */
  SymbolTable_PopSize (M2Base_Char);
  /* 
      Boolean = (FALSE, TRUE) ;
  */
  M2Base_Boolean = SymbolTable_MakeEnumeration (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "BOOLEAN", 7));
  SymbolTable_PutFieldEnumeration (M2LexBuf_BuiltinTokenNo, M2Base_Boolean, NameKey_MakeKey ((const char *) "FALSE", 5));
  SymbolTable_PutFieldEnumeration (M2LexBuf_BuiltinTokenNo, M2Base_Boolean, NameKey_MakeKey ((const char *) "TRUE", 4));
  M2Base_True = SymbolTable_RequestSym (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "TRUE", 4));
  M2Base_False = SymbolTable_RequestSym (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "FALSE", 5));
  M2Base_Proc = SymbolTable_MakeProcType (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "PROC", 4));
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (location, m2type_GetProcType ()));
  SymbolTable_PopSize (M2Base_Proc);
  /* MinChar  */
  MinChar = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMinFrom (location, m2type_GetM2CharType ()));
  SymbolTable_PopValue (MinChar);
  SymbolTable_PutVar (MinChar, M2Base_Char);
  /* MaxChar  */
  MaxChar = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMaxFrom (location, m2type_GetM2CharType ()));
  SymbolTable_PopValue (MaxChar);
  SymbolTable_PutVar (MaxChar, M2Base_Char);
  /* MinInteger  */
  MinInteger = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMinFrom (location, m2type_GetM2IntegerType ()));
  SymbolTable_PopValue (MinInteger);
  SymbolTable_PutVar (MinInteger, M2Base_Integer);
  /* MaxInteger  */
  MaxInteger = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMaxFrom (location, m2type_GetM2IntegerType ()));
  SymbolTable_PopValue (MaxInteger);
  SymbolTable_PutVar (MaxInteger, M2Base_Integer);
  /* MinCardinal  */
  MinCardinal = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMinFrom (m2linemap_BuiltinsLocation (), m2type_GetM2CardinalType ()));
  SymbolTable_PopValue (MinCardinal);
  SymbolTable_PutVar (MinCardinal, M2Base_Cardinal);
  /* MaxCardinal  */
  MaxCardinal = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMaxFrom (location, m2type_GetM2CardinalType ()));
  SymbolTable_PopValue (MaxCardinal);
  SymbolTable_PutVar (MaxCardinal, M2Base_Cardinal);
  /* MinLongInt  */
  MinLongInt = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMinFrom (location, m2type_GetM2LongIntType ()));
  SymbolTable_PopValue (MinLongInt);
  SymbolTable_PutVar (MinLongInt, M2Base_LongInt);
  /* MaxLongInt  */
  MaxLongInt = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMaxFrom (location, m2type_GetM2LongIntType ()));
  SymbolTable_PopValue (MaxLongInt);
  SymbolTable_PutVar (MaxLongInt, M2Base_LongInt);
  /* MinLongCard  */
  MinLongCard = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMinFrom (location, m2type_GetM2LongCardType ()));
  SymbolTable_PopValue (MinLongCard);
  SymbolTable_PutVar (MinLongCard, M2Base_LongCard);
  /* MinLongCard  */
  MaxLongCard = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMaxFrom (m2linemap_BuiltinsLocation (), m2type_GetM2LongCardType ()));
  SymbolTable_PopValue (MaxLongCard);
  SymbolTable_PutVar (MaxLongCard, M2Base_LongCard);
  /* MinReal  */
  MinReal = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushRealTree (m2type_GetMinFrom (location, m2type_GetM2RealType ()));
  SymbolTable_PopValue (MinReal);
  SymbolTable_PutVar (MinReal, M2Base_Real);
  /* MaxReal  */
  MaxReal = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushRealTree (m2type_GetMaxFrom (location, m2type_GetM2RealType ()));
  SymbolTable_PopValue (MaxReal);
  SymbolTable_PutVar (MaxReal, M2Base_Real);
  /* MinShortReal  */
  MinShortReal = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushRealTree (m2type_GetMinFrom (location, m2type_GetM2ShortRealType ()));
  SymbolTable_PopValue (MinShortReal);
  SymbolTable_PutVar (MinShortReal, M2Base_ShortReal);
  /* MaxShortReal  */
  MaxShortReal = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushRealTree (m2type_GetMaxFrom (location, m2type_GetM2ShortRealType ()));
  SymbolTable_PopValue (MaxShortReal);
  SymbolTable_PutVar (MaxShortReal, M2Base_ShortReal);
  /* MinLongReal  */
  MinLongReal = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushRealTree (m2type_GetMinFrom (location, m2type_GetM2LongRealType ()));
  SymbolTable_PopValue (MinLongReal);
  SymbolTable_PutVar (MinLongReal, M2Base_LongReal);
  /* MaxLongReal  */
  MaxLongReal = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushRealTree (m2type_GetMaxFrom (location, m2type_GetM2LongRealType ()));
  SymbolTable_PopValue (MaxLongReal);
  SymbolTable_PutVar (MaxLongReal, M2Base_LongReal);
  /* MaxShortInt  */
  MaxShortInt = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMaxFrom (location, m2type_GetM2ShortIntType ()));
  SymbolTable_PopValue (MaxShortInt);
  SymbolTable_PutVar (MaxShortInt, M2Base_ShortInt);
  /* MinShortInt  */
  MinShortInt = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMinFrom (location, m2type_GetM2ShortIntType ()));
  SymbolTable_PopValue (MinShortInt);
  SymbolTable_PutVar (MinShortInt, M2Base_ShortInt);
  /* MaxShortCard  */
  MaxShortCard = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMaxFrom (location, m2type_GetM2ShortCardType ()));
  SymbolTable_PopValue (MaxShortCard);
  SymbolTable_PutVar (MaxShortCard, M2Base_ShortCard);
  /* MinShortCard  */
  MinShortCard = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  M2ALU_PushIntegerTree (m2type_GetMinFrom (location, m2type_GetM2ShortCardType ()));
  SymbolTable_PopValue (MinShortCard);
  SymbolTable_PutVar (MinShortCard, M2Base_ShortCard);
}


/*
   FindMinMaxEnum - finds the minimum and maximum enumeration fields.
*/

static void FindMinMaxEnum (unsigned int field)
{
  if (MaxEnum == SymbolTable_NulSym)
    {
      MaxEnum = static_cast<unsigned int> (field);
    }
  else
    {
      SymbolTable_PushValue (field);
      SymbolTable_PushValue (MaxEnum);
      if (M2ALU_Gre (M2LexBuf_GetTokenNo ()))
        {
          MaxEnum = static_cast<unsigned int> (field);
        }
    }
  if (MinEnum == SymbolTable_NulSym)
    {
      MinEnum = static_cast<unsigned int> (field);
    }
  else
    {
      SymbolTable_PushValue (field);
      SymbolTable_PushValue (MinEnum);
      if (M2ALU_Less (M2LexBuf_GetTokenNo ()))
        {
          MinEnum = static_cast<unsigned int> (field);
        }
    }
}


/*
   ImportFrom - imports symbol, name, from module and returns the
                symbol.
*/

static unsigned int ImportFrom (unsigned int tok, unsigned int module, const char *name_, unsigned int _name_high)
{
  char name[_name_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);

  SymbolTable_PutImported (SymbolTable_GetExported (tok, module, NameKey_MakeKey ((const char *) name, _name_high)));
  return SymbolTable_GetSym (NameKey_MakeKey ((const char *) name, _name_high));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitBaseProcedures - initialises the base procedures,
                        INC, DEC, INCL, EXCL, NEW and DISPOSE.
*/

static void InitBaseProcedures (void)
{
  unsigned int rtexceptions;

  /* 
      The pseudo procedures NEW and DISPOSE are in fact "macro"
      substituted for ALLOCATE and DEALLOCATE.
      However they both have symbols in the base module so that
      the procedure mechanism treats all procedure calls the same.
      "Macro" substitution occurs in M2Quads.
  */
  M2Base_New = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "NEW", 3));
  M2Base_Dispose = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "DISPOSE", 7));
  M2Base_Inc = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "INC", 3));
  M2Base_Dec = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "DEC", 3));
  M2Base_Incl = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "INCL", 4));
  M2Base_Excl = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "EXCL", 4));
  if (! M2Options_Pim2)
    {
      /* PIM-2 Modula-2  */
      M2Size_MakeSize ();
    }
  /* 
      The procedure HALT is a real procedure which
      is defined in M2RTS. However to remain compatible
      with other Modula-2 implementations HALT can be used
      without the need to import it from M2RTS. ie it is
      within the BaseType module scope.
  */
  m2rts = M2Batch_MakeDefinitionSource (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "M2RTS", 5));
  SymbolTable_PutImported (SymbolTable_GetExported (M2LexBuf_BuiltinTokenNo, m2rts, NameKey_MakeKey ((const char *) "HALT", 4)));
  M2Base_ExceptionAssign = SymbolTable_NulSym;
  M2Base_ExceptionReturn = SymbolTable_NulSym;
  M2Base_ExceptionInc = SymbolTable_NulSym;
  M2Base_ExceptionDec = SymbolTable_NulSym;
  M2Base_ExceptionIncl = SymbolTable_NulSym;
  M2Base_ExceptionExcl = SymbolTable_NulSym;
  M2Base_ExceptionShift = SymbolTable_NulSym;
  M2Base_ExceptionRotate = SymbolTable_NulSym;
  M2Base_ExceptionStaticArray = SymbolTable_NulSym;
  M2Base_ExceptionDynamicArray = SymbolTable_NulSym;
  M2Base_ExceptionForLoopBegin = SymbolTable_NulSym;
  M2Base_ExceptionForLoopTo = SymbolTable_NulSym;
  M2Base_ExceptionForLoopEnd = SymbolTable_NulSym;
  M2Base_ExceptionPointerNil = SymbolTable_NulSym;
  M2Base_ExceptionNoReturn = SymbolTable_NulSym;
  M2Base_ExceptionCase = SymbolTable_NulSym;
  M2Base_ExceptionNonPosDiv = SymbolTable_NulSym;
  M2Base_ExceptionNonPosMod = SymbolTable_NulSym;
  M2Base_ExceptionZeroDiv = SymbolTable_NulSym;
  M2Base_ExceptionZeroRem = SymbolTable_NulSym;
  M2Base_ExceptionWholeValue = SymbolTable_NulSym;
  M2Base_ExceptionRealValue = SymbolTable_NulSym;
  M2Base_ExceptionParameterBounds = SymbolTable_NulSym;
  M2Base_ExceptionNo = SymbolTable_NulSym;
  if (M2Options_NilChecking)
    {
      M2Base_ExceptionPointerNil = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "PointerNilException", 19);
    }
  if (M2Options_RangeChecking)
    {
      M2Base_ExceptionAssign = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "AssignmentException", 19);
      M2Base_ExceptionReturn = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "ReturnException", 15);
      M2Base_ExceptionInc = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "IncException", 12);
      M2Base_ExceptionDec = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "DecException", 12);
      M2Base_ExceptionIncl = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "InclException", 13);
      M2Base_ExceptionExcl = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "ExclException", 13);
      M2Base_ExceptionShift = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "ShiftException", 14);
      M2Base_ExceptionRotate = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "RotateException", 15);
      M2Base_ExceptionForLoopBegin = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "ForLoopBeginException", 21);
      M2Base_ExceptionForLoopTo = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "ForLoopToException", 18);
      M2Base_ExceptionForLoopEnd = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "ForLoopEndException", 19);
      M2Base_ExceptionParameterBounds = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "ParameterException", 18);
    }
  if (M2Options_IndexChecking)
    {
      M2Base_ExceptionStaticArray = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "StaticArraySubscriptException", 29);
      M2Base_ExceptionDynamicArray = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "DynamicArraySubscriptException", 30);
    }
  if (M2Options_WholeDivChecking)
    {
      M2Base_ExceptionNonPosDiv = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "WholeNonPosDivException", 23);
      M2Base_ExceptionNonPosMod = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "WholeNonPosModException", 23);
      M2Base_ExceptionZeroDiv = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "WholeZeroDivException", 21);
      M2Base_ExceptionZeroRem = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "WholeZeroRemException", 21);
    }
  if (M2Options_ReturnChecking)
    {
      M2Base_ExceptionNoReturn = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "NoReturnException", 17);
    }
  if (M2Options_CaseElseChecking)
    {
      M2Base_ExceptionCase = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "CaseException", 13);
    }
  if (M2Options_WholeValueChecking)
    {
      M2Base_ExceptionWholeValue = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "WholeValueException", 19);
      M2Base_ExceptionRealValue = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "RealValueException", 18);
    }
  if (M2Options_Exceptions)
    {
      M2Base_ExceptionNo = ImportFrom (M2LexBuf_BuiltinTokenNo, m2rts, (const char *) "NoException", 11);
      /* ensure that this module is included  */
      rtexceptions = M2Batch_MakeDefinitionSource (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "RTExceptions", 12));
      if (rtexceptions == SymbolTable_NulSym)
        {
          M2MetaError_MetaError0 ((const char *) "unable to find required runtime module RTExceptions", 51);
        }
    }
}


/*
   BuildOrdFunctions - creates ORD, ORDS, ORDL.
*/

static void BuildOrdFunctions (void)
{
  Ord = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ORD", 3));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, Ord, SymbolTable_DefProcedure, M2Base_Cardinal);
  OrdS = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ORDS", 4));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, OrdS, SymbolTable_DefProcedure, M2Base_ShortCard);
  OrdL = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ORDL", 4));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, OrdL, SymbolTable_DefProcedure, M2Base_LongCard);
}


/*
   BuildTruncFunctions - creates TRUNC, TRUNCS, TRUNCL.
*/

static void BuildTruncFunctions (void)
{
  if ((M2Options_Pim2 || M2Options_Pim3) || M2Options_Iso)
    {
      Trunc = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "TRUNC", 5));
      SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, Trunc, SymbolTable_DefProcedure, M2Base_Cardinal);
      TruncS = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "STRUNC", 6));
      SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, TruncS, SymbolTable_DefProcedure, M2Base_ShortCard);
      TruncL = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "LTRUNC", 6));
      SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, TruncL, SymbolTable_DefProcedure, M2Base_LongCard);
    }
  else
    {
      Trunc = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "TRUNC", 5));
      SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, Trunc, SymbolTable_DefProcedure, M2Base_Integer);
      TruncS = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "STRUNC", 6));
      SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, TruncS, SymbolTable_DefProcedure, M2Base_ShortInt);
      TruncL = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "LTRUNC", 6));
      SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, TruncL, SymbolTable_DefProcedure, M2Base_LongInt);
    }
}


/*
   BuildFloatFunctions - creates TRUNC, TRUNCS, TRUNCL.
*/

static void BuildFloatFunctions (void)
{
  Float = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "FLOAT", 5));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, Float, SymbolTable_DefProcedure, M2Base_Real);
  SFloat = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "SFLOAT", 6));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, SFloat, SymbolTable_DefProcedure, M2Base_ShortReal);
  LFloat = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "LFLOAT", 6));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, LFloat, SymbolTable_DefProcedure, M2Base_LongReal);
  FloatS = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "FLOATS", 6));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, FloatS, SymbolTable_DefProcedure, M2Base_ShortReal);
  FloatL = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "FLOATL", 6));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, FloatL, SymbolTable_DefProcedure, M2Base_LongReal);
}


/*
   BuildIntFunctions - creates INT, INTS, INTL.
*/

static void BuildIntFunctions (void)
{
  Int = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "INT", 3));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, Int, SymbolTable_DefProcedure, M2Base_Integer);
  IntS = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "INTS", 4));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, IntS, SymbolTable_DefProcedure, M2Base_ShortInt);
  IntL = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "INTL", 4));
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, IntL, SymbolTable_DefProcedure, M2Base_LongInt);
}


/*
   InitBaseFunctions - initialises the base function, HIGH.
*/

static void InitBaseFunctions (void)
{
  /* Now declare the dynamic array components, HIGH  */
  M2Base_High = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "HIGH", 4));  /* Pseudo Base function HIGH  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Base_High, SymbolTable_DefProcedure, M2Base_Cardinal);
  /* 
     _TemplateProcedure is a procedure which has a local variable _ActivationPointer
      whose offset is used for all nested procedures. (The activation pointer
      being in the same relative position for all procedures).
  */
  M2Base_TemplateProcedure = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "_TemplateProcedure", 18));
  SymbolTable_StartScope (M2Base_TemplateProcedure);
  M2Base_ActivationPointer = SymbolTable_MakeVar (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "_ActivationPointer", 18));
  SymbolTable_PutVar (M2Base_ActivationPointer, M2System_Address);
  SymbolTable_EndScope ();
  /* and the base functions  */
  M2Base_Convert = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "CONVERT", 7));  /* Internal function CONVERT  */
  if (M2Options_Iso)  /* Internal function CONVERT  */
    {
      M2Base_LengthS = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "LENGTH", 6));  /* Pseudo Base function LENGTH  */
      SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Base_LengthS, SymbolTable_DefProcedure, M2Base_ZType);  /* Pseudo Base function LENGTH  */
    }
  else
    {
      M2Base_LengthS = SymbolTable_NulSym;
    }
  M2Base_Abs = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ABS", 3));  /* Pseudo Base function ABS  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Base_Abs, SymbolTable_DefProcedure, M2Base_ZType);  /* Pseudo Base function ABS  */
  M2Base_Cap = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "CAP", 3));  /* Pseudo Base function CAP  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Base_Cap, SymbolTable_DefProcedure, M2Base_Char);  /* Pseudo Base function CAP  */
  M2Base_Odd = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "ODD", 3));  /* Pseudo Base function ODD  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Base_Odd, SymbolTable_DefProcedure, M2Base_Boolean);  /* Pseudo Base function ODD  */
  M2Base_Chr = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "CHR", 3));  /* Pseudo Base function CHR  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Base_Chr, SymbolTable_DefProcedure, M2Base_Char);
  /* the parameters.  */
  M2Base_Val = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "VAL", 3));  /* Pseudo Base function VAL  */
  M2Base_Min = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "MIN", 3));  /* Pseudo Base function MIN  */
  M2Base_Max = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "MAX", 3));  /* Pseudo Base function MIN  */
  M2Base_Re = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "RE", 2));  /* Pseudo Base function RE  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Base_Re, SymbolTable_DefProcedure, M2Base_RType);  /* Pseudo Base function RE  */
  M2Base_Im = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "IM", 2));  /* Pseudo Base function IM  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Base_Im, SymbolTable_DefProcedure, M2Base_RType);  /* Pseudo Base function IM  */
  M2Base_Cmplx = SymbolTable_MakeProcedure (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "CMPLX", 5));  /* Pseudo Base function CMPLX  */
  SymbolTable_PutFunction (M2LexBuf_BuiltinTokenNo, M2Base_Cmplx, SymbolTable_DefProcedure, M2Base_CType);  /* Pseudo Base function CMPLX  */
  BuildFloatFunctions ();
  BuildTruncFunctions ();
  BuildOrdFunctions ();
  BuildIntFunctions ();
}


/*
   IsISOPseudoBaseFunction -
*/

static bool IsISOPseudoBaseFunction (unsigned int Sym)
{
  return (M2Options_Iso && (Sym != SymbolTable_NulSym)) && ((((((Sym == M2Base_LengthS) || (Sym == M2Size_Size)) || (Sym == M2Base_Cmplx)) || (Sym == M2Base_Re)) || (Sym == M2Base_Im)) || (M2Base_IsInt (Sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPIMPseudoBaseFunction -
*/

static bool IsPIMPseudoBaseFunction (unsigned int Sym)
{
  return ((! M2Options_Iso && ! M2Options_Pim2) && (Sym != SymbolTable_NulSym)) && (Sym == M2Size_Size);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   EmitTypeIncompatibleWarning - emit a type incompatibility warning.
*/

static void EmitTypeIncompatibleWarning (unsigned int tok, M2Base_Compatability kind, unsigned int t1, unsigned int t2)
{
  switch (kind)
    {
      case M2Base_expression:
        M2MetaError_MetaErrorT2 (tok, (const char *) "{%1W:} type incompatibility found {%1as:{%2as:between types {%1as} {%2as}}} in an expression, hint one of the expressions should be converted", 141, t1, t2);
        break;

      case M2Base_assignment:
        M2MetaError_MetaErrorT2 (tok, (const char *) "{%1W:} type incompatibility found {%1as:{%2as:between types {%1as} {%2as}}} during an assignment, hint maybe the expression should be converted", 143, t1, t2);
        break;

      case M2Base_parameter:
        M2MetaError_MetaErrorT2 (tok, (const char *) "{%1W:} type incompatibility found when passing a parameter {%1as:{%2as:between formal parameter and actual parameter types {%1as} {%2as}}}, hint the actual parameter {%2a} should be converted", 191, t1, t2);
        break;

      case M2Base_comparison:
        M2MetaError_MetaErrorT2 (tok, (const char *) "{%1W:} type incompatibility found {%1as:{%2as:between types {%1as} {%2as}}} in a relational expression, hint one of the expressions should be converted", 151, t1, t2);
        break;


      default:
        break;
    }
}


/*
   EmitTypeIncompatibleError - emit a type incompatibility error.
*/

static void EmitTypeIncompatibleError (unsigned int tok, M2Base_Compatability kind, unsigned int t1, unsigned int t2)
{
  switch (kind)
    {
      case M2Base_expression:
        M2MetaError_MetaErrorT2 (tok, (const char *) "type incompatibility found {%1as:{%2as:between types {%1as} and {%2as}}} in an expression, hint one of the expressions should be converted", 138, t1, t2);
        break;

      case M2Base_assignment:
        M2MetaError_MetaErrorT2 (tok, (const char *) "type incompatibility found {%1as:{%2as:between types {%1as} and {%2as}}} during an assignment, hint maybe the expression should be converted", 140, t1, t2);
        break;

      case M2Base_parameter:
        M2MetaError_MetaErrorT2 (tok, (const char *) "type incompatibility found when passing a parameter {%1as:{%2as:between formal parameter and actual parameter types {%1as} and {%2as}}}, hint the actual parameter should be converted", 182, t1, t2);
        break;

      case M2Base_comparison:
        M2MetaError_MetaErrorT2 (tok, (const char *) "type incompatibility found {%1as:{%2as:between types {%1as} and {%2as}}} in a relational expression, hint one of the expressions should be converted", 148, t1, t2);
        break;


      default:
        break;
    }
}


/*
   CheckCompatible - returns if t1 and t2 are kind compatible
*/

static void CheckCompatible (unsigned int tok, unsigned int t1, unsigned int t2, M2Base_Compatability kind)
{
  DynamicStrings_String s;
  M2Base_Compatible r;

  r = IsCompatible (t1, t2, kind);
  if ((r != M2Base_first) && (r != M2Base_second))
    {
      if ((r == M2Base_warnfirst) || (r == M2Base_warnsecond))
        {
          s = DynamicStrings_InitString ((const char *) "{%1W}", 5);
        }
      else
        {
          s = DynamicStrings_InitString ((const char *) "", 0);
        }
      if ((SymbolTable_IsUnknown (t1)) && (SymbolTable_IsUnknown (t2)))
        {
          s = DynamicStrings_ConCat (s, DynamicStrings_InitString ((const char *) "two different unknown types {%1a:{%2a:{%1a} and {%2a}}} must either be declared or imported)", 92));
          M2MetaError_MetaErrorStringT2 (tok, s, t1, t2);
        }
      else if (SymbolTable_IsUnknown (t1))
        {
          /* avoid dangling else.  */
          s = DynamicStrings_ConCat (s, DynamicStrings_InitString ((const char *) "this type {%1a} is currently unknown, it must be declared or imported", 69));
          M2MetaError_MetaErrorStringT1 (tok, s, t1);
        }
      else if (SymbolTable_IsUnknown (t2))
        {
          /* avoid dangling else.  */
          s = DynamicStrings_ConCat (s, DynamicStrings_InitString ((const char *) "this type {%1a} is currently unknown, it must be declared or imported", 69));
          M2MetaError_MetaErrorStringT1 (tok, s, t2);
        }
      else
        {
          /* avoid dangling else.  */
          if ((r == M2Base_warnfirst) || (r == M2Base_warnsecond))
            {
              EmitTypeIncompatibleWarning (tok, kind, t1, t2);
            }
          else
            {
              EmitTypeIncompatibleError (tok, kind, t1, t2);
            }
        }
    }
}


/*
   FindMetaType - returns the MetaType associated with, sym.
*/

static M2Base_MetaType FindMetaType (unsigned int sym)
{
  if (sym == SymbolTable_NulSym)
    {
      return M2Base_const;
    }
  else if (sym == M2System_Word)
    {
      /* avoid dangling else.  */
      return M2Base_word;
    }
  else if (sym == M2System_Byte)
    {
      /* avoid dangling else.  */
      return M2Base_byte;
    }
  else if (sym == M2System_Loc)
    {
      /* avoid dangling else.  */
      return M2Base_loc;
    }
  else if (sym == M2System_Address)
    {
      /* avoid dangling else.  */
      return M2Base_address;
    }
  else if (sym == M2Base_Char)
    {
      /* avoid dangling else.  */
      return M2Base_chr;
    }
  else if (sym == M2Base_Integer)
    {
      /* avoid dangling else.  */
      return M2Base_normint;
    }
  else if (sym == M2Base_ShortInt)
    {
      /* avoid dangling else.  */
      return M2Base_shortint;
    }
  else if (sym == M2Base_LongInt)
    {
      /* avoid dangling else.  */
      return M2Base_longint;
    }
  else if (sym == M2Base_Cardinal)
    {
      /* avoid dangling else.  */
      return M2Base_normcard;
    }
  else if (sym == M2Base_ShortCard)
    {
      /* avoid dangling else.  */
      return M2Base_shortcard;
    }
  else if (sym == M2Base_LongCard)
    {
      /* avoid dangling else.  */
      return M2Base_longcard;
    }
  else if (sym == M2Base_ZType)
    {
      /* avoid dangling else.  */
      return M2Base_ztype;
    }
  else if (sym == M2Base_RType)
    {
      /* avoid dangling else.  */
      return M2Base_rtype;
    }
  else if (sym == M2Base_Real)
    {
      /* avoid dangling else.  */
      return M2Base_real;
    }
  else if (sym == M2Base_ShortReal)
    {
      /* avoid dangling else.  */
      return M2Base_shortreal;
    }
  else if (sym == M2Base_LongReal)
    {
      /* avoid dangling else.  */
      return M2Base_longreal;
    }
  else if (sym == (M2System_IntegerN (8)))
    {
      /* avoid dangling else.  */
      return M2Base_int8;
    }
  else if (sym == (M2System_IntegerN (16)))
    {
      /* avoid dangling else.  */
      return M2Base_int16;
    }
  else if (sym == (M2System_IntegerN (32)))
    {
      /* avoid dangling else.  */
      return M2Base_int32;
    }
  else if (sym == (M2System_IntegerN (64)))
    {
      /* avoid dangling else.  */
      return M2Base_int64;
    }
  else if (sym == (M2System_CardinalN (8)))
    {
      /* avoid dangling else.  */
      return M2Base_card8;
    }
  else if (sym == (M2System_CardinalN (16)))
    {
      /* avoid dangling else.  */
      return M2Base_card16;
    }
  else if (sym == (M2System_CardinalN (32)))
    {
      /* avoid dangling else.  */
      return M2Base_card32;
    }
  else if (sym == (M2System_CardinalN (64)))
    {
      /* avoid dangling else.  */
      return M2Base_card64;
    }
  else if (sym == (M2System_WordN (16)))
    {
      /* avoid dangling else.  */
      return M2Base_word16;
    }
  else if (sym == (M2System_WordN (32)))
    {
      /* avoid dangling else.  */
      return M2Base_word32;
    }
  else if (sym == (M2System_WordN (64)))
    {
      /* avoid dangling else.  */
      return M2Base_word64;
    }
  else if (sym == (M2System_SetN (8)))
    {
      /* avoid dangling else.  */
      return M2Base_set8;
    }
  else if (sym == (M2System_SetN (16)))
    {
      /* avoid dangling else.  */
      return M2Base_set16;
    }
  else if (sym == (M2System_SetN (32)))
    {
      /* avoid dangling else.  */
      return M2Base_set32;
    }
  else if (sym == (M2System_RealN (32)))
    {
      /* avoid dangling else.  */
      return M2Base_real32;
    }
  else if (sym == (M2System_RealN (64)))
    {
      /* avoid dangling else.  */
      return M2Base_real64;
    }
  else if (sym == (M2System_RealN (96)))
    {
      /* avoid dangling else.  */
      return M2Base_real96;
    }
  else if (sym == (M2System_RealN (128)))
    {
      /* avoid dangling else.  */
      return M2Base_real128;
    }
  else if (sym == M2Base_Complex)
    {
      /* avoid dangling else.  */
      return M2Base_complex;
    }
  else if (sym == M2Base_ShortComplex)
    {
      /* avoid dangling else.  */
      return M2Base_shortcomplex;
    }
  else if (sym == M2Base_LongComplex)
    {
      /* avoid dangling else.  */
      return M2Base_longcomplex;
    }
  else if (sym == (M2System_ComplexN (32)))
    {
      /* avoid dangling else.  */
      return M2Base_complex32;
    }
  else if (sym == (M2System_ComplexN (64)))
    {
      /* avoid dangling else.  */
      return M2Base_complex64;
    }
  else if (sym == (M2System_ComplexN (96)))
    {
      /* avoid dangling else.  */
      return M2Base_complex96;
    }
  else if (sym == (M2System_ComplexN (128)))
    {
      /* avoid dangling else.  */
      return M2Base_complex128;
    }
  else if (sym == M2Base_CType)
    {
      /* avoid dangling else.  */
      return M2Base_ctype;
    }
  else if (SymbolTable_IsSet (sym))
    {
      /* avoid dangling else.  */
      return M2Base_set;
    }
  else if (SymbolTable_IsHiddenType (sym))
    {
      /* avoid dangling else.  */
      return M2Base_opaque;
    }
  else if (SymbolTable_IsPointer (sym))
    {
      /* avoid dangling else.  */
      return M2Base_pointer;
    }
  else if (SymbolTable_IsEnumeration (sym))
    {
      /* avoid dangling else.  */
      return M2Base_enum;
    }
  else if (SymbolTable_IsRecord (sym))
    {
      /* avoid dangling else.  */
      return M2Base_rec;
    }
  else if (SymbolTable_IsArray (sym))
    {
      /* avoid dangling else.  */
      return M2Base_array;
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      return FindMetaType (SymbolTable_GetType (sym));
    }
  else if ((SymbolTable_IsProcedure (sym)) || (SymbolTable_IsProcType (sym)))
    {
      /* avoid dangling else.  */
      return M2Base_procedure;
    }
  else
    {
      /* avoid dangling else.  */
      return M2Base_unknown;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsBaseCompatible - returns an enumeration field determining whether a simple base type
                      comparison is legal.
*/

static M2Base_Compatible IsBaseCompatible (unsigned int t1, unsigned int t2, M2Base_Compatability kind)
{
  M2Base_MetaType mt1;
  M2Base_MetaType mt2;

  if ((t1 == t2) && ((kind == M2Base_assignment) || (kind == M2Base_parameter)))
    {
      return M2Base_first;
    }
  else
    {
      mt1 = FindMetaType (t1);
      mt2 = FindMetaType (t2);
      if ((mt1 == M2Base_unknown) || (mt2 == M2Base_unknown))
        {
          return M2Base_no;
        }
      switch (kind)
        {
          case M2Base_expression:
            return Expr.array[mt1-M2Base_const].array[mt2-M2Base_const];
            break;

          case M2Base_assignment:
            return Ass.array[mt1-M2Base_const].array[mt2-M2Base_const];
            break;

          case M2Base_parameter:
            return Ass.array[mt1-M2Base_const].array[mt2-M2Base_const];
            break;

          case M2Base_comparison:
            return Comp.array[mt1-M2Base_const].array[mt2-M2Base_const];
            break;


          default:
            M2Error_InternalError ((const char *) "unexpected compatibility", 24);
            break;
        }
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2Base.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsCompatible - returns true if the types, t1, and, t2, are compatible.
*/

static M2Base_Compatible IsCompatible (unsigned int t1, unsigned int t2, M2Base_Compatability kind)
{
  t1 = SymbolTable_SkipType (t1);
  t2 = SymbolTable_SkipType (t2);
  if (t1 == t2)
    {
      /* same types are always compatible.  */
      return M2Base_first;
    }
  else if (M2Pass_IsPassCodeGeneration ())
    {
      /* avoid dangling else.  */
      return AfterResolved (t1, t2, kind);
    }
  else
    {
      /* avoid dangling else.  */
      return BeforeResolved (t1, t2, kind);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPointerSame - returns TRUE if pointers, a, and, b, are the same.
*/

static bool IsPointerSame (unsigned int a, unsigned int b, bool error)
{
  return IsSameType (SymbolTable_SkipType (SymbolTable_GetType (a)), SymbolTable_SkipType (SymbolTable_GetType (b)), error);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSubrangeSame - checks to see whether the subranges are the same.
*/

static bool IsSubrangeSame (unsigned int a, unsigned int b)
{
  unsigned int al;
  unsigned int ah;
  unsigned int bl;
  unsigned int bh;

  a = SymbolTable_SkipType (a);
  b = SymbolTable_SkipType (b);
  if (a != b)
    {
      SymbolTable_GetSubrange (a, &ah, &al);
      SymbolTable_GetSubrange (b, &bh, &bl);
      SymbolTable_PushValue (al);
      SymbolTable_PushValue (bl);
      if (! (M2ALU_Equ (SymbolTable_GetDeclaredMod (a))))
        {
          return false;
        }
      SymbolTable_PushValue (ah);
      SymbolTable_PushValue (bh);
      if (! (M2ALU_Equ (SymbolTable_GetDeclaredMod (a))))
        {
          return false;
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsVarientSame - returns TRUE if varient types, a, and, b, are identical.
*/

static bool IsVarientSame (unsigned int a, unsigned int b, bool error)
{
  unsigned int i;
  unsigned int j;
  unsigned int fa;
  unsigned int fb;
  unsigned int ga;
  unsigned int gb;

  i = 1;
  ga = SymbolTable_NulSym;
  gb = SymbolTable_NulSym;
  do {
    fa = SymbolTable_GetNth (a, i);
    fb = SymbolTable_GetNth (b, i);
    if ((fa != SymbolTable_NulSym) && (fb != SymbolTable_NulSym))
      {
        M2Debug_Assert (SymbolTable_IsFieldVarient (fa));
        M2Debug_Assert (SymbolTable_IsFieldVarient (fb));
        j = 1;
        do {
          ga = SymbolTable_GetNth (fa, j);
          gb = SymbolTable_GetNth (fb, j);
          if ((ga != SymbolTable_NulSym) && (gb != SymbolTable_NulSym))
            {
              if (! (IsSameType (SymbolTable_GetType (ga), SymbolTable_GetType (gb), error)))
                {
                  return false;
                }
              j += 1;
            }
        } while (! ((ga == SymbolTable_NulSym) || (gb == SymbolTable_NulSym)));
        if (ga != gb)
          {
            return false;
          }
      }
    i += 1;
  } while (! ((fa == SymbolTable_NulSym) || (fb == SymbolTable_NulSym)));
  return ga == gb;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRecordSame -
*/

static bool IsRecordSame (unsigned int a, unsigned int b, bool error)
{
  unsigned int ta;
  unsigned int tb;
  unsigned int fa;
  unsigned int fb;
  unsigned int i;

  i = 1;
  do {
    fa = SymbolTable_GetNth (a, i);
    fb = SymbolTable_GetNth (b, i);
    if ((fa != SymbolTable_NulSym) && (fb != SymbolTable_NulSym))
      {
        ta = SymbolTable_GetType (fa);
        tb = SymbolTable_GetType (fb);
        if ((SymbolTable_IsRecordField (fa)) && (SymbolTable_IsRecordField (fb)))
          {
            /* avoid dangling else.  */
            if (! (IsSameType (ta, tb, error)))
              {
                return false;
              }
          }
        else if ((SymbolTable_IsVarient (fa)) && (SymbolTable_IsVarient (fb)))
          {
            /* avoid dangling else.  */
            if (! (IsVarientSame (ta, tb, error)))
              {
                return false;
              }
          }
        else if ((SymbolTable_IsFieldVarient (fa)) || (SymbolTable_IsFieldVarient (fb)))
          {
            /* avoid dangling else.  */
            M2Error_InternalError ((const char *) "should not see a field varient", 30);
          }
        else
          {
            /* avoid dangling else.  */
            return false;
          }
      }
    i += 1;
  } while (! ((fa == SymbolTable_NulSym) || (fb == SymbolTable_NulSym)));
  return fa == fb;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsArraySame -
*/

static bool IsArraySame (unsigned int t1, unsigned int t2, bool error)
{
  unsigned int s1;
  unsigned int s2;

  s1 = SymbolTable_GetArraySubscript (t1);
  s2 = SymbolTable_GetArraySubscript (t2);
  return (IsSameType (SymbolTable_GetType (s1), SymbolTable_GetType (s2), error)) && (IsSameType (SymbolTable_GetType (t1), SymbolTable_GetType (t2), error));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsEnumerationSame -
*/

static bool IsEnumerationSame (unsigned int t1, unsigned int t2)
{
  return t1 == t2;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSetSame -
*/

static bool IsSetSame (unsigned int t1, unsigned int t2, bool error)
{
  return IsSameType (SymbolTable_GetType (t1), SymbolTable_GetType (t2), error);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSameType - returns TRUE if
*/

static bool IsSameType (unsigned int t1, unsigned int t2, bool error)
{
  t1 = SymbolTable_SkipType (t1);
  t2 = SymbolTable_SkipType (t2);
  if (t1 == t2)
    {
      return true;
    }
  else if ((SymbolTable_IsArray (t1)) && (SymbolTable_IsArray (t2)))
    {
      /* avoid dangling else.  */
      return IsArraySame (t1, t2, error);
    }
  else if ((SymbolTable_IsSubrange (t1)) && (SymbolTable_IsSubrange (t2)))
    {
      /* avoid dangling else.  */
      return IsSubrangeSame (t1, t2);
    }
  else if ((SymbolTable_IsProcType (t1)) && (SymbolTable_IsProcType (t2)))
    {
      /* avoid dangling else.  */
      return IsProcTypeSame (t1, t2, error);
    }
  else if ((SymbolTable_IsEnumeration (t1)) && (SymbolTable_IsEnumeration (t2)))
    {
      /* avoid dangling else.  */
      return IsEnumerationSame (t1, t2);  /* , error  */
    }
  else if ((SymbolTable_IsRecord (t1)) && (SymbolTable_IsRecord (t2)))
    {
      /* avoid dangling else.  */
      return IsRecordSame (t1, t2, error);
    }
  else if ((SymbolTable_IsSet (t1)) && (SymbolTable_IsSet (t2)))
    {
      /* avoid dangling else.  */
      return IsSetSame (t1, t2, error);
    }
  else if ((SymbolTable_IsPointer (t1)) && (SymbolTable_IsPointer (t2)))
    {
      /* avoid dangling else.  */
      return IsPointerSame (t1, t2, error);
    }
  else
    {
      /* avoid dangling else.  */
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsProcTypeSame -
*/

static bool IsProcTypeSame (unsigned int p1, unsigned int p2, bool error)
{
  unsigned int pa;
  unsigned int pb;
  unsigned int n;
  unsigned int i;

  n = SymbolTable_NoOfParamAny (p1);
  if (n != (SymbolTable_NoOfParamAny (p2)))
    {
      if (error)
        {
          M2MetaError_MetaError2 ((const char *) "parameter is incompatible as {%1Dd} was declared with {%2n} parameters", 70, p1, SymbolTable_NoOfParamAny (p1));
          M2MetaError_MetaError2 ((const char *) "whereas {%1Dd} was declared with {%2n} parameters", 49, p2, SymbolTable_NoOfParamAny (p2));
        }
      return false;
    }
  i = 1;
  while (i <= n)
    {
      pa = SymbolTable_GetNthParamAny (p1, i);
      pb = SymbolTable_GetNthParamAny (p2, i);
      if ((SymbolTable_IsParameterVar (pa)) != (SymbolTable_IsParameterVar (pb)))
        {
          if (error)
            {
              M2MetaError_MetaErrors3 ((const char *) "the {%1n} parameter is incompatible between {%2Dad} and {%3ad} as only one was declared as VAR", 94, (const char *) "the {%1n} parameter is incompatible between {%2ad} and {%3Dad} as only one was declared as VAR", 94, i, pa, pb);
            }
          return false;
        }
      if (! (IsSameType (SymbolTable_GetType (pa), SymbolTable_GetType (pb), error)))
        {
          return false;
        }
      i += 1;
    }
  return IsSameType (SymbolTable_GetType (p1), SymbolTable_GetType (p2), error);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doProcTypeCheck -
*/

static bool doProcTypeCheck (unsigned int p1, unsigned int p2, bool error)
{
  if (((SymbolTable_IsProcType (p1)) || (SymbolTable_IsProcedure (p1))) && ((SymbolTable_IsProcType (p2)) || (SymbolTable_IsProcedure (p2))))
    {
      if (p1 == p2)
        {
          return true;
        }
      else
        {
          return IsProcTypeSame (p1, p2, error);
        }
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AfterResolved - a thorough test for type compatibility.
*/

static M2Base_Compatible AfterResolved (unsigned int t1, unsigned int t2, M2Base_Compatability kind)
{
  M2Base_MetaType mt1;
  M2Base_MetaType mt2;

  if ((t1 == SymbolTable_NulSym) || (t2 == SymbolTable_NulSym))
    {
      return M2Base_first;
    }
  else if (((kind == M2Base_parameter) || (kind == M2Base_assignment)) && (t1 == t2))
    {
      /* avoid dangling else.  */
      return M2Base_first;
    }
  else if (SymbolTable_IsSubrange (t1))
    {
      /* avoid dangling else.  */
      return IsCompatible (SymbolTable_GetType (t1), t2, kind);
    }
  else if (SymbolTable_IsSubrange (t2))
    {
      /* avoid dangling else.  */
      return IsCompatible (t1, SymbolTable_GetType (t2), kind);
    }
  else
    {
      /* avoid dangling else.  */
      mt1 = FindMetaType (t1);
      mt2 = FindMetaType (t2);
      if (mt1 == mt2)
        {
          switch (mt1)
            {
              case M2Base_set:
              case M2Base_set8:
              case M2Base_set16:
              case M2Base_set32:
                if (IsSetSame (t1, t2, false))
                  {
                    return M2Base_first;
                  }
                else
                  {
                    return M2Base_no;
                  }
                break;

              case M2Base_enum:
                if (IsEnumerationSame (t1, t2))  /* , FALSE  */
                  {
                    return M2Base_first;
                  }
                else
                  {
                    return M2Base_no;
                  }
                break;

              case M2Base_pointer:
                if (IsPointerSame (t1, t2, false))
                  {
                    return M2Base_first;
                  }
                else
                  {
                    return M2Base_no;
                  }
                break;

              case M2Base_opaque:
                return M2Base_no;
                break;

              case M2Base_procedure:
                if (doProcTypeCheck (t1, t2, false))
                  {
                    return M2Base_first;
                  }
                else
                  {
                    return M2Base_no;
                  }
                break;


              default:
                break;
            }
        }
      /* fall through  */
      return IsBaseCompatible (t1, t2, kind);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BeforeResolved - attempts to test for type compatibility before all types are
                    completely resolved.  In particular set types and constructor
                    types are not fully known before the end of pass 3.
                    However we can test base types.
*/

static M2Base_Compatible BeforeResolved (unsigned int t1, unsigned int t2, M2Base_Compatability kind)
{
  if ((t1 == SymbolTable_NulSym) || (t2 == SymbolTable_NulSym))
    {
      return M2Base_first;
    }
  else if (SymbolTable_IsSubrange (t1))
    {
      /* avoid dangling else.  */
      return IsCompatible (SymbolTable_GetType (t1), t2, kind);
    }
  else if (SymbolTable_IsSubrange (t2))
    {
      /* avoid dangling else.  */
      return IsCompatible (t1, SymbolTable_GetType (t2), kind);
    }
  else if ((SymbolTable_IsSet (t1)) || (SymbolTable_IsSet (t2)))
    {
      /* avoid dangling else.  */
      /* cannot test set compatibility at this point so we do this again after pass 3  */
      return M2Base_first;
    }
  else if (((SymbolTable_IsProcType (t1)) && (SymbolTable_IsProcedure (t2))) || ((SymbolTable_IsProcedure (t1)) && (SymbolTable_IsProcType (t2))))
    {
      /* avoid dangling else.  */
      /* we will perform checking during code generation  */
      return M2Base_first;
    }
  else if ((SymbolTable_IsHiddenType (t1)) && (SymbolTable_IsHiddenType (t2)))
    {
      /* avoid dangling else.  */
      if (t1 == t2)
        {
          M2MetaError_MetaError0 ((const char *) "assert about to fail as t1 = t2", 31);
        }
      M2Debug_Assert (t1 != t2);
      /* different opaque types are not assignment or expression compatible.  */
      return M2Base_no;
    }
  else
    {
      /* avoid dangling else.  */
      /* 
   see M2Quads for the fixme comment at assignment.

   PIM2 says that CARDINAL and INTEGER are compatible with subranges of CARDINAL and INTEGER,
        however we do not know the type to our subranges yet as (GetType(SubrangeType)=NulSym).
        So we add type checking in the range checking module which is done post pass 3,
        when all is resolved.
  */
      return IsBaseCompatible (t1, t2, kind);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MixMetaTypes -
*/

static unsigned int MixMetaTypes (unsigned int left, unsigned int right, unsigned int leftType, unsigned int rightType, unsigned int NearTok)
{
  M2Base_MetaType mt1;
  M2Base_MetaType mt2;

  mt1 = FindMetaType (leftType);
  mt2 = FindMetaType (rightType);
  switch (Expr.array[mt1-M2Base_const].array[mt2-M2Base_const])
    {
      case M2Base_no:
        M2MetaError_MetaErrorT2 (NearTok, (const char *) "type incompatibility between {%1asd} and {%2asd}", 48, leftType, rightType);
        M2MetaError_MetaErrorDecl (left, true);
        M2MetaError_MetaErrorDecl (right, true);
        M2Error_FlushErrors ();  /* unrecoverable at present  */
        break;

      case M2Base_warnfirst:
      case M2Base_first:
        return leftType;
        break;

      case M2Base_warnsecond:
      case M2Base_second:
        return rightType;
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this metatype value", 33);
        break;
    }
  return SymbolTable_MakeError (NearTok, NameKey_NulName);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsUserType - return TRUE if type was created by the user as a synonym.
*/

static bool IsUserType (unsigned int type)
{
  return (((SymbolTable_IsType (type)) && (! (M2Base_IsBaseType (type)))) && (! (M2System_IsSystemType (type)))) && (type != M2Base_ZType);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsVarParamCompatible - returns TRUE if types, actual, and, formal
                          are compatible even if formal is a VAR
                          parameter.
*/

static bool IsVarParamCompatible (unsigned int actual, unsigned int formal)
{
  actual = SymbolTable_SkipType (actual);
  formal = SymbolTable_SkipType (formal);
  if ((SymbolTable_IsParameter (formal)) && (SymbolTable_IsParameterUnbounded (formal)))
    {
      formal = SymbolTable_SkipType (SymbolTable_GetType (SymbolTable_GetType (formal)));  /* move over unbounded  */
      if (M2System_IsGenericSystemType (formal))  /* move over unbounded  */
        {
          return true;
        }
      return (formal == actual) || ((SymbolTable_IsArray (actual)) && (formal == (SymbolTable_SkipType (SymbolTable_GetType (actual)))));
    }
  else
    {
      return (((((actual == formal) || ((SymbolTable_IsPointer (actual)) && (formal == M2System_Address))) || ((SymbolTable_IsPointer (formal)) && (actual == M2System_Address))) || ((M2System_IsGenericSystemType (actual)) && (IsSizeSame (FindMetaType (actual), FindMetaType (formal))))) || ((M2System_IsGenericSystemType (formal)) && (IsSizeSame (FindMetaType (actual), FindMetaType (formal))))) || (M2System_IsSameSizePervasiveType (formal, actual));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsArrayUnboundedCompatible - returns TRUE if unbounded or array types, t1, and, t2,
                                are compatible.
*/

static bool IsArrayUnboundedCompatible (unsigned int t1, unsigned int t2)
{
  if ((t1 == SymbolTable_NulSym) || (t2 == SymbolTable_NulSym))
    {
      return false;
    }
  else if (((SymbolTable_IsUnbounded (t1)) || (SymbolTable_IsArray (t1))) && ((SymbolTable_IsUnbounded (t2)) || (SymbolTable_IsArray (t2))))
    {
      /* avoid dangling else.  */
      return (SymbolTable_SkipType (SymbolTable_GetType (t1))) == (SymbolTable_SkipType (SymbolTable_GetType (t2)));
    }
  else
    {
      /* avoid dangling else.  */
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsValidUnboundedParameter -
*/

static bool IsValidUnboundedParameter (unsigned int formal, unsigned int actual)
{
  unsigned int ft;
  unsigned int at;
  unsigned int n;
  unsigned int m;
  unsigned int o;

  M2Debug_Assert (SymbolTable_IsParameterUnbounded (formal));
  ft = SymbolTable_SkipType (SymbolTable_GetType (SymbolTable_GetType (formal)));  /* ARRAY OF ft  */
  if ((M2System_IsGenericSystemType (ft)) || (IsArrayUnboundedCompatible (SymbolTable_GetType (formal), SymbolTable_GetType (actual))))  /* ARRAY OF ft  */
    {
      return true;
    }
  else
    {
      if ((SymbolTable_IsParameter (actual)) && (SymbolTable_IsParameterUnbounded (actual)))
        {
          n = SymbolTable_GetDimension (actual);
          m = SymbolTable_GetDimension (formal);
          if (n != m)
            {
              return (M2System_IsGenericSystemType (ft)) && (n < m);
            }
          else
            {
              return ((SymbolTable_GetDimension (actual)) == (SymbolTable_GetDimension (formal))) && (M2Base_IsParameterCompatible (SymbolTable_GetType (SymbolTable_GetType (actual)), ft));
            }
        }
      else
        {
          if (SymbolTable_IsConstString (actual))
            {
              return M2Base_IsParameterCompatible (M2Base_Char, ft);
            }
          else
            {
              at = SymbolTable_SkipType (SymbolTable_GetType (actual));
              if (SymbolTable_IsArray (at))
                {
                  m = SymbolTable_GetDimension (formal);
                  n = SymbolTable_GetDimension (at);
                  o = 0;
                  while (SymbolTable_IsArray (at))
                    {
                      o += 1;
                      at = SymbolTable_SkipType (SymbolTable_GetType (at));
                      if ((m == o) && (at == ft))
                        {
                          return true;
                        }
                    }
                  if (n != m)
                    {
                      return (M2System_IsGenericSystemType (ft)) && (n < m);
                    }
                  else if (SymbolTable_IsParameterVar (formal))
                    {
                      /* avoid dangling else.  */
                      return IsVarParamCompatible (at, formal);
                    }
                  else
                    {
                      /* avoid dangling else.  */
                      return M2Base_IsParameterCompatible (at, ft);
                    }
                }
              else
                {
                  if (SymbolTable_IsParameterVar (formal))
                    {
                      return IsVarParamCompatible (at, formal);
                    }
                  else
                    {
                      return M2Base_IsParameterCompatible (at, ft);
                    }
                }
            }
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushSizeOf - pushes the size of a meta type.
*/

static void PushSizeOf (M2Base_MetaType t)
{
  switch (t)
    {
      case M2Base_const:
        M2Error_InternalError ((const char *) "do not know the size of a constant", 34);
        break;

      case M2Base_word:
        if (M2Options_Iso)
          {
            M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetISOWordType ()));
          }
        else
          {
            M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetWordType ()));
          }
        break;

      case M2Base_byte:
        if (M2Options_Iso)
          {
            M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetISOByteType ()));
          }
        else
          {
            M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetByteType ()));
          }
        break;

      case M2Base_address:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetPointerType ()));
        break;

      case M2Base_chr:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2CharType ()));
        break;

      case M2Base_normint:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2IntegerType ()));
        break;

      case M2Base_shortint:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2ShortIntType ()));
        break;

      case M2Base_longint:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2LongIntType ()));
        break;

      case M2Base_normcard:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2CardinalType ()));
        break;

      case M2Base_shortcard:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2ShortCardType ()));
        break;

      case M2Base_longcard:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2LongCardType ()));
        break;

      case M2Base_pointer:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetPointerType ()));
        break;

      case M2Base_enum:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetIntegerType ()));
        break;

      case M2Base_real:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2RealType ()));
        break;

      case M2Base_shortreal:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2ShortRealType ()));
        break;

      case M2Base_longreal:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2LongRealType ()));
        break;

      case M2Base_set:
        M2Error_InternalError ((const char *) "do not know the size of a set", 29);
        break;

      case M2Base_opaque:
        M2Error_InternalError ((const char *) "do not know the size of an opaque", 33);
        break;

      case M2Base_loc:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetISOLocType ()));
        break;

      case M2Base_rtype:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2RType ()));
        break;

      case M2Base_ztype:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2ZType ()));
        break;

      case M2Base_int8:
      case M2Base_card8:
      case M2Base_set8:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (1));
        break;

      case M2Base_word16:
      case M2Base_set16:
      case M2Base_card16:
      case M2Base_int16:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (2));
        break;

      case M2Base_real32:
      case M2Base_word32:
      case M2Base_set32:
      case M2Base_card32:
      case M2Base_int32:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (4));
        break;

      case M2Base_real64:
      case M2Base_word64:
      case M2Base_card64:
      case M2Base_int64:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (8));
        break;

      case M2Base_real96:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (12));
        break;

      case M2Base_real128:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (16));
        break;

      case M2Base_complex:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2ComplexType ()));
        break;

      case M2Base_shortcomplex:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2ShortComplexType ()));
        break;

      case M2Base_longcomplex:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2LongComplexType ()));
        break;

      case M2Base_complex32:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (4*2));
        break;

      case M2Base_complex64:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (8*2));
        break;

      case M2Base_complex96:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (12*2));
        break;

      case M2Base_complex128:
        M2ALU_PushIntegerTree (m2decl_BuildIntegerConstant (16*2));
        break;

      case M2Base_ctype:
        M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetM2CType ()));
        break;

      case M2Base_unknown:
        M2Error_InternalError ((const char *) "should not get here", 19);
        break;


      default:
        M2Error_InternalError ((const char *) "should not get here", 19);
        break;
    }
}


/*
   IsSizeSame -
*/

static bool IsSizeSame (M2Base_MetaType t1, M2Base_MetaType t2)
{
  PushSizeOf (t1);
  PushSizeOf (t2);
  return M2ALU_Equ (0);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitArray -
*/

static void InitArray (M2Base_CompatibilityArray *c, M2Base_MetaType y, const char *a_, unsigned int _a_high)
{
  M2Base_MetaType x;
  unsigned int h;
  unsigned int i;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  h = StrLib_StrLen ((const char *) a, _a_high);
  i = 0;
  x = M2Base_const;
  while (i < h)
    {
      if ((((*c).array[x-M2Base_const].array[y-M2Base_const] != M2Base_uninitialized) && (x != M2Base_unknown)) && (y != M2Base_unknown))
        {
          M2Error_InternalError ((const char *) "expecting array element to be uninitialized", 43);
        }
      switch (a[i])
        {
          case ' ':
            break;

          case '.':
            switch ((*c).array[y-M2Base_const].array[x-M2Base_const])
              {
                case M2Base_uninitialized:
                  M2Error_InternalError ((const char *) "cannot reflect value as it is unknown", 37);
                  break;

                case M2Base_first:
                  (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_second;
                  break;

                case M2Base_second:
                  (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_first;
                  break;

                case M2Base_warnfirst:
                  (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_warnsecond;
                  break;

                case M2Base_warnsecond:
                  (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_warnfirst;
                  break;


                default:
                  (*c).array[x-M2Base_const].array[y-M2Base_const] = (*c).array[y-M2Base_const].array[x-M2Base_const];
                  break;
              }
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;

          case 'F':
            (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_no;
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;

          case 'T':
          case '1':
            (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_first;
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;

          case '2':
            (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_second;
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;

          case 'W':
            if (M2Options_Pim)
              {
                if (IsSizeSame (x, y))
                  {
                    (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_warnsecond;
                  }
                else
                  {
                    (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_no;
                  }
              }
            else
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_no;
              }
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;

          case 'w':
            if (M2Options_Pim)
              {
                if (IsSizeSame (x, y))
                  {
                    (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_warnfirst;
                  }
                else
                  {
                    (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_no;
                  }
              }
            else
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_no;
              }
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;

          case 'P':
            if (M2Options_Pim)
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_second;
              }
            else
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_no;
              }
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;

          case 'p':
            if (M2Options_Pim)
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_first;
              }
            else
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_no;
              }
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;

          case 's':
            if (IsSizeSame (x, y))
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_first;
              }
            else
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_no;
              }
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;

          case 'S':
            if (IsSizeSame (x, y))
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_second;
              }
            else
              {
                (*c).array[x-M2Base_const].array[y-M2Base_const] = M2Base_no;
              }
            x = static_cast<M2Base_MetaType>(static_cast<int>(x)+1);
            break;


          default:
            M2Error_InternalError ((const char *) "unexpected specifier", 20);
            break;
        }
      i += 1;
    }
}


/*
   A - initialize the assignment array
*/

static void A (M2Base_MetaType y, const char *a_, unsigned int _a_high)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  InitArray (&Ass, y, (const char *) a, _a_high);
}


/*
   E - initialize the expression array
*/

static void E (M2Base_MetaType y, const char *a_, unsigned int _a_high)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  InitArray (&Expr, y, (const char *) a, _a_high);
}


/*
   C - initialize the comparision array
*/

static void C (M2Base_MetaType y, const char *a_, unsigned int _a_high)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  InitArray (&Comp, y, (const char *) a, _a_high);
}


/*
   InitCompatibilityMatrices - initializes the tables above.
*/

static void InitCompatibilityMatrices (void)
{
  M2Base_MetaType i;
  M2Base_MetaType j;

  for (i=M2Base_const; i<=M2Base_unknown; i= static_cast<M2Base_MetaType>(static_cast<int>(i+1)))
    {
      for (j=M2Base_const; j<=M2Base_unknown; j= static_cast<M2Base_MetaType>(static_cast<int>(j+1)))
        {
          /* initialize to a known state  */
          Ass.array[i-M2Base_const].array[j-M2Base_const] = M2Base_uninitialized;
          Expr.array[i-M2Base_const].array[j-M2Base_const] = M2Base_uninitialized;
        }
    }
  for (i=M2Base_const; i<=M2Base_unknown; i= static_cast<M2Base_MetaType>(static_cast<int>(i+1)))
    {
      /* all unknowns are false  */
      Ass.array[i-M2Base_const].array[M2Base_unknown-M2Base_const] = M2Base_no;
      Expr.array[M2Base_unknown-M2Base_const].array[i-M2Base_const] = M2Base_no;
    }
  /* 
                                                     1 p w

                    C W B A C I S L C S L P E R S L S O L R Z I I I I C C C C W W W R R R R S S S C S L C C C C C R A P
                    o o y d h n h o a h o t n e h o e p o t t n n n n a a a a o o o e e e e e e e o h o o o o o t e r r
                    n r t d a t o n r o n r u a o n t a c y y t t t t r r r r r r r a a a a t t t m o n m m m m y c r o
                    s d e r r e r g d r g   m l r g   q   p p 8 1 3 6 d d d d d d d l l l l 8 1 3 p r g p p p p p   a c
                    t     e   g t i i t c       t r   u   e e   6 2 4 8 1 3 6 1 3 6 3 6 9 1   6 2 l t C l l l l e   y
                          s   e i n n c a       r e   e                 6 2 4 6 2 4 2 4 6 2       e C o e e e e
                          s   r n t a a r       e a                                       8       x o m x x x x
                                t   l r d       a l                                                 m p 3 6 9 1
                                      d         l                                                   p l 2 4 6 2
                                                                                                    l e       8
                                                                                                    e x
                                                                                                    x
         --------------------------------------------------------------------------------------------------------------
   2
   P
   W
  */
  A (M2Base_const, (const char *) "T T T T T T T T T T T T T T T T T T T F T T T T T T T T T T T T F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_word, (const char *) ". T S S S 2 S S 2 S S S 2 S S S T T S S T S S S S S S S S S S S S S S S S S S S S S S S S S T T T F", 99);
  A (M2Base_byte, (const char *) ". . T S 2 S S S S S S S S S S S T T S S T S S S S S S S S S S S S S S S S S S S S S S S S S T T T F", 99);
  A (M2Base_address, (const char *) ". . . T F F F F P F F 2 F F F F F 2 2 F T F F F F F F F F F F F F F F F F F F F F F F F F F F F F T", 99);
  A (M2Base_chr, (const char *) ". . . . T F F F F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_normint, (const char *) ". . . . . T T T T T T F F F F F F F F F T T T T T T T T T F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_shortint, (const char *) ". . . . . . T T T T T F F F F F F F F F T T T T T T T T T F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_longint, (const char *) ". . . . . . . T T T T F F F F F F F F F T T T T T T T T T F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_normcard, (const char *) ". . . . . . . . T T T F F F F F F F F F T T T T T T T T T F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_shortcard, (const char *) ". . . . . . . . . T T F F F F F F F F F T T T T T T T T T F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_longcard, (const char *) ". . . . . . . . . . T F F F F F F F F F T T T T T T T T T F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_pointer, (const char *) ". . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_enum, (const char *) ". . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F T T F F F F F F F F F F F F F F F F", 99);
  A (M2Base_real, (const char *) ". . . . . . . . . . . . . T T T F F F 2 F F F F F F F F F F F F T T T T F F F F F F F F F F F F F F", 99);
  A (M2Base_shortreal, (const char *) ". . . . . . . . . . . . . . T T F F F 2 F F F F F F F F F F F F T T T T F F F F F F F F F F F F F F", 99);
  A (M2Base_longreal, (const char *) ". . . . . . . . . . . . . . . T F F F 2 F F F F F F F F F F F F T T T T F F F F F F F F F F F F F F", 99);
  A (M2Base_set, (const char *) ". . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_opaque, (const char *) ". . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_loc, (const char *) ". . . . . . . . . . . . . . . . . . T F F T F F F T F F F F F F F F F F S F F F F F F F F F F T T F", 99);
  A (M2Base_rtype, (const char *) ". . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F 1 1 1 1 F F F F F F F F F F F F F F", 99);
  A (M2Base_ztype, (const char *) ". . . . . . . . . . . . . . . . . . . . T T T T T T T T T T T T F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_int8, (const char *) ". . . . . . . . . . . . . . . . . . . . . T T T T T T T T F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_int16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . T T T T T T T T F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_int32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . T T T T T T F T T F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_int64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . T T T T T F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_card8, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . T T T T T F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_card16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . T T T F F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_card32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . T T F T F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_card64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F T F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_word16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_word32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F T F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_word64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F T F F F F F F F F F F F F F F F F", 99);
  A (M2Base_real32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F", 99);
  A (M2Base_real64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F", 99);
  A (M2Base_real96, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F", 99);
  A (M2Base_real128, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F", 99);
  A (M2Base_set8, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F", 99);
  A (M2Base_set16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F", 99);
  A (M2Base_set32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F", 99);
  A (M2Base_complex, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F T F F F", 99);
  A (M2Base_shortcomplex, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F T F F F", 99);
  A (M2Base_longcomplex, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F T F F F", 99);
  A (M2Base_complex32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F T F F F", 99);
  A (M2Base_complex64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F T F F F", 99);
  A (M2Base_complex96, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F T F F F", 99);
  A (M2Base_complex128, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T T F F F", 99);
  A (M2Base_ctype, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F", 99);
  A (M2Base_rec, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F", 99);
  A (M2Base_array, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F", 99);
  A (M2Base_procedure, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T", 99);
  /* 
                                                     1 p w

                    C W B A C I S L C S L P E R S L S O L R Z I I I I C C C C W W W R R R R S S S C S L C C C C C R A P
                    o o y d h n h o a h o t n e h o e p o t t n n n n a a a a o o o e e e e e e e o h o o o o o t e r r
                    n r t d a t o n r o n r u a o n t a c y y t t t t r r r r r r r a a a a t t t m o n m m m m y c r o
                    s d e r r e r g d r g   m l r g   q   p p 8 1 3 6 d d d d d d d l l l l 8 1 3 p r g p p p p p   a c
                    t     e   g t i i t c       t r   u   e e   6 2 4 8 1 3 6 1 3 6 3 6 9 1   6 2 l t C l l l l e   y
                          s   e i n n c a       r e   e                 6 2 4 6 2 4 2 4 6 2       e C o e e e e
                          s   r n t a a r       e a                                       8       x o m x x x x
                                t   l r d       a l                                                 m p 3 6 9 1
                                      d         l                                                   p l 2 4 6 2
                                                                                                    l e       8
                                                                                                    e x
                                                                                                    x
         ------------------------------------------------------------------------------------------------------------
   2
   P
   W
  */
  E (M2Base_const, (const char *) "T T T T T T T T T T T T T T T T T T F F T T T T T T T T T T T T T T T T F F F F F F F F F F F F F F", 99);
  E (M2Base_word, (const char *) ". T F F F F F F F F F F F F F F F F F W F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_byte, (const char *) ". . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_address, (const char *) ". . . T F P F F P F F T F F F F F F F F P F F F F F F F F F F F F F F F F F F F F F F F F F F F F T", 99);
  E (M2Base_chr, (const char *) ". . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_normint, (const char *) ". . . . . T F F F F F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_shortint, (const char *) ". . . . . . T F F F F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_longint, (const char *) ". . . . . . . T F F F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_normcard, (const char *) ". . . . . . . . T F F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_shortcard, (const char *) ". . . . . . . . . T F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_longcard, (const char *) ". . . . . . . . . . T F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_pointer, (const char *) ". . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_enum, (const char *) ". . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_real, (const char *) ". . . . . . . . . . . . . T F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_shortreal, (const char *) ". . . . . . . . . . . . . . T F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_longreal, (const char *) ". . . . . . . . . . . . . . . T F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_set, (const char *) ". . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_opaque, (const char *) ". . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_loc, (const char *) ". . . . . . . . . . . . . . . . . . F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_rtype, (const char *) ". . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F 1 1 1 1 F F F F F F F F F F F F F F", 99);
  E (M2Base_ztype, (const char *) ". . . . . . . . . . . . . . . . . . . . T 1 1 1 1 1 1 1 1 1 1 1 F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_int8, (const char *) ". . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_int16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_int32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_int64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_card8, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_card16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_card32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_card64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_word16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_word32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_word64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_real32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F", 99);
  E (M2Base_real64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F", 99);
  E (M2Base_real96, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F", 99);
  E (M2Base_real128, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F", 99);
  E (M2Base_set8, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F", 99);
  E (M2Base_set16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F", 99);
  E (M2Base_set32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F", 99);
  E (M2Base_complex, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F T F F F", 99);
  E (M2Base_shortcomplex, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F T F F F", 99);
  E (M2Base_longcomplex, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F T F F F", 99);
  E (M2Base_complex32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F T F F F", 99);
  E (M2Base_complex64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F T F F F", 99);
  E (M2Base_complex96, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F T F F F", 99);
  E (M2Base_complex128, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T T F F F", 99);
  E (M2Base_ctype, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F", 99);
  E (M2Base_rec, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F F", 99);
  E (M2Base_array, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F", 99);
  E (M2Base_procedure, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T", 99);
  /* 
                                                     1 p w

                    C W B A C I S L C S L P E R S L S O L R Z I I I I C C C C W W W R R R R S S S C S L C C C C C R A P
                    o o y d h n h o a h o t n e h o e p o t t n n n n a a a a o o o e e e e e e e o h o o o o o t e r r
                    n r t d a t o n r o n r u a o n t a c y y t t t t r r r r r r r a a a a t t t m o n m m m m y c r o
                    s d e r r e r g d r g   m l r g   q   p p 8 1 3 6 d d d d d d d l l l l 8 1 3 p r g p p p p p   a c
                    t     e   g t i i t c       t r   u   e e   6 2 4 8 1 3 6 1 3 6 3 6 9 1   6 2 l t C l l l l e   y
                          s   e i n n c a       r e   e                 6 2 4 6 2 4 2 4 6 2       e C o e e e e
                          s   r n t a a r       e a                                       8       x o m x x x x
                                t   l r d       a l                                                 m p 3 6 9 1
                                      d         l                                                   p l 2 4 6 2
                                                                                                    l e       8
                                                                                                    e x
                                                                                                    x
         ------------------------------------------------------------------------------------------------------------
   2
   P
   W
  */
  C (M2Base_const, (const char *) "T T T T T T T T T T T T T T T T T T F F T T T T T T T T T T T T T T T T F F F F F F F F F F F F F F", 99);
  C (M2Base_word, (const char *) ". T F F F F F F F F F F F F F F F F F F T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_byte, (const char *) ". . T F F F F F F F F F F F F F F F F F T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_address, (const char *) ". . . T F F F F F F F T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F T", 99);
  C (M2Base_chr, (const char *) ". . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_normint, (const char *) ". . . . . T F F F F F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_shortint, (const char *) ". . . . . . T F F F F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_longint, (const char *) ". . . . . . . T F F F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_normcard, (const char *) ". . . . . . . . T F F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_shortcard, (const char *) ". . . . . . . . . T F F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_longcard, (const char *) ". . . . . . . . . . T F F F F F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_pointer, (const char *) ". . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_enum, (const char *) ". . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_real, (const char *) ". . . . . . . . . . . . . T F F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_shortreal, (const char *) ". . . . . . . . . . . . . . T F F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_longreal, (const char *) ". . . . . . . . . . . . . . . T F F F 2 F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_set, (const char *) ". . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_opaque, (const char *) ". . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_loc, (const char *) ". . . . . . . . . . . . . . . . . . F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_rtype, (const char *) ". . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F 1 1 1 1 F F F F F F F F F F F F F F", 99);
  C (M2Base_ztype, (const char *) ". . . . . . . . . . . . . . . . . . . . T 1 1 1 1 1 1 1 1 1 1 1 F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_int8, (const char *) ". . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_int16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_int32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_int64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_card8, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_card16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_card32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_card64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_word16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_word32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_word64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_real32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F F", 99);
  C (M2Base_real64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F F", 99);
  C (M2Base_real96, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F F", 99);
  C (M2Base_real128, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F F", 99);
  C (M2Base_set8, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F F", 99);
  C (M2Base_set16, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F F", 99);
  C (M2Base_set32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F F F F F F", 99);
  C (M2Base_complex, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F F T F F F", 99);
  C (M2Base_shortcomplex, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F F T F F F", 99);
  C (M2Base_longcomplex, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F F T F F F", 99);
  C (M2Base_complex32, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F T F F F", 99);
  C (M2Base_complex64, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F T F F F", 99);
  C (M2Base_complex96, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F T F F F", 99);
  C (M2Base_complex128, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T T F F F", 99);
  C (M2Base_ctype, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T F F F", 99);
  C (M2Base_rec, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F F", 99);
  C (M2Base_array, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . F F", 99);
  C (M2Base_procedure, (const char *) ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . T", 99);
}


/*
   InitBase - initializes the base types and procedures
              used in the Modula-2 compiler.
*/

extern "C" void M2Base_InitBase (location_t location, unsigned int *sym)
{
  (*sym) = SymbolTable_MakeModule (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "_BaseTypes", 10));
  SymbolTable_PutModuleBuiltin ((*sym), true);
  SymbolTable_SetCurrentModule ((*sym));
  SymbolTable_StartScope ((*sym));
  InitBaseSimpleTypes (location);
  /* Initialize the SYSTEM module before we ADDRESS.  */
  M2System_InitSystem ();
  M2Bitset_MakeBitset ();  /* We do this after SYSTEM has been created as BITSET
                    is dependant upon WORD.  */
  InitBaseConstants ();  /* We do this after SYSTEM has been created as BITSET
                    is dependant upon WORD.  */
  InitBaseFunctions ();
  InitBaseProcedures ();
  /* 
      Note: that we do end the Scope since we keep the symbol to the head
            of the base scope. This head of base scope is searched
            when all other scopes fail to deliver a symbol.
  */
  SymbolTable_EndScope ();
  InitBuiltins ();
  InitCompatibilityMatrices ();
}


/*
   GetBaseTypeMinMax - returns the minimum and maximum values for a
                       given base type. This procedure should only
                       be called if the type is NOT a subrange.
*/

extern "C" void M2Base_GetBaseTypeMinMax (unsigned int type, unsigned int *min, unsigned int *max)
{
  if (type == M2Base_Integer)
    {
      (*min) = MinInteger;
      (*max) = MaxInteger;
    }
  else if (type == M2Base_Cardinal)
    {
      /* avoid dangling else.  */
      (*min) = MinCardinal;
      (*max) = MaxCardinal;
    }
  else if (type == M2Base_Char)
    {
      /* avoid dangling else.  */
      (*min) = MinChar;
      (*max) = MaxChar;
    }
  else if (type == M2Bitset_Bitset)
    {
      /* avoid dangling else.  */
      M2Bitset_GetBitsetMinMax (min, max);
    }
  else if (type == M2Base_LongInt)
    {
      /* avoid dangling else.  */
      (*min) = MinLongInt;
      (*max) = MaxLongInt;
    }
  else if (type == M2Base_LongCard)
    {
      /* avoid dangling else.  */
      (*min) = MinLongCard;
      (*max) = MaxLongCard;
    }
  else if (type == M2Base_ShortInt)
    {
      /* avoid dangling else.  */
      (*min) = MinShortInt;
      (*max) = MaxShortInt;
    }
  else if (type == M2Base_ShortCard)
    {
      /* avoid dangling else.  */
      (*min) = MinShortCard;
      (*max) = MaxShortCard;
    }
  else if (type == M2Base_Real)
    {
      /* avoid dangling else.  */
      (*min) = MinReal;
      (*max) = MaxReal;
    }
  else if (type == M2Base_ShortReal)
    {
      /* avoid dangling else.  */
      (*min) = MinShortReal;
      (*max) = MaxShortReal;
    }
  else if (type == M2Base_LongReal)
    {
      /* avoid dangling else.  */
      (*min) = MinLongReal;
      (*max) = MaxLongReal;
    }
  else if (SymbolTable_IsEnumeration (type))
    {
      /* avoid dangling else.  */
      MinEnum = SymbolTable_NulSym;
      MaxEnum = SymbolTable_NulSym;
      SymbolTable_ForeachFieldEnumerationDo (type, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) FindMinMaxEnum});
      (*min) = MinEnum;
      (*max) = MaxEnum;
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "unable to find MIN or MAX for the base type {%1as}", 50, type);
    }
}


/*
   IsPseudoBaseFunction - returns true if Sym is a Base pseudo function.
*/

extern "C" bool M2Base_IsPseudoBaseFunction (unsigned int Sym)
{
  return (((((((((((((Sym == M2Base_High) || (Sym == M2Base_Val)) || (Sym == M2Base_Convert)) || (M2Base_IsOrd (Sym))) || (Sym == M2Base_Chr)) || (M2Base_IsFloat (Sym))) || (M2Base_IsTrunc (Sym))) || (Sym == M2Base_Min)) || (Sym == M2Base_Max)) || (Sym == M2Base_Abs)) || (Sym == M2Base_Odd)) || (Sym == M2Base_Cap)) || (IsISOPseudoBaseFunction (Sym))) || (IsPIMPseudoBaseFunction (Sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPseudoBaseProcedure - returns true if Sym is a Base pseudo procedure.
*/

extern "C" bool M2Base_IsPseudoBaseProcedure (unsigned int Sym)
{
  return (((((Sym == M2Base_New) || (Sym == M2Base_Dispose)) || (Sym == M2Base_Inc)) || (Sym == M2Base_Dec)) || (Sym == M2Base_Incl)) || (Sym == M2Base_Excl);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsNeededAtRunTime - returns TRUE if procedure, sym, is a
                       runtime procedure.  A runtime procedure is
                       not a pseudo procedure (like NEW/DISPOSE)
                       and it is implemented in M2RTS or SYSTEM
                       and also exported.
*/

extern "C" bool M2Base_IsNeededAtRunTime (unsigned int tok, unsigned int sym)
{
  return (((SymbolTable_FromModuleGetSym (tok, SymbolTable_GetSymName (sym), M2System_System)) == sym) || ((SymbolTable_FromModuleGetSym (tok, SymbolTable_GetSymName (sym), m2rts)) == sym)) && ((SymbolTable_IsExportQualified (sym)) || (SymbolTable_IsExportUnQualified (sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsBaseType - returns TRUE if Sym is a Base type.
*/

extern "C" bool M2Base_IsBaseType (unsigned int Sym)
{
  return (((((((((((((((Sym == M2Base_Cardinal) || (Sym == M2Base_Integer)) || (Sym == M2Base_Boolean)) || (Sym == M2Base_Char)) || (Sym == M2Base_Proc)) || (Sym == M2Base_LongInt)) || (Sym == M2Base_LongCard)) || (Sym == M2Base_ShortInt)) || (Sym == M2Base_ShortCard)) || (Sym == M2Base_Real)) || (Sym == M2Base_LongReal)) || (Sym == M2Base_ShortReal)) || (Sym == M2Base_Complex)) || (Sym == M2Base_LongComplex)) || (Sym == M2Base_ShortComplex)) || (Sym == M2Bitset_Bitset);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsOrdinalType - returns TRUE if, sym, is an ordinal type.
                   An ordinal type is defined as:
                   a base type which contains whole numbers or
                   a subrange type or an enumeration type.
*/

extern "C" bool M2Base_IsOrdinalType (unsigned int Sym)
{
  return ((((((((((((Sym == M2Base_Cardinal) || (Sym == M2Base_Integer)) || (Sym == M2Base_Char)) || (Sym == M2Base_Boolean)) || (Sym == M2Base_LongInt)) || (Sym == M2Base_LongCard)) || (Sym == M2Base_ShortInt)) || (Sym == M2Base_ShortCard)) || (Sym == M2Base_ZType)) || (SymbolTable_IsSubrange (Sym))) || (SymbolTable_IsEnumeration (Sym))) || (M2System_IsIntegerN (Sym))) || (M2System_IsCardinalN (Sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsOrd - returns TRUE if, sym, is ORD or its typed counterparts
           ORDL, ORDS.
*/

extern "C" bool M2Base_IsOrd (unsigned int sym)
{
  return ((sym == Ord) || (sym == OrdS)) || (sym == OrdL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsTrunc - returns TRUE if, sym, is TRUNC or its typed counterparts
             TRUNCL, TRUNCS.
*/

extern "C" bool M2Base_IsTrunc (unsigned int sym)
{
  return ((sym == Trunc) || (sym == TruncS)) || (sym == TruncL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsFloat - returns TRUE if, sym, is FLOAT or its typed counterparts
             FLOATL, FLOATS.
*/

extern "C" bool M2Base_IsFloat (unsigned int sym)
{
  return ((((sym == Float) || (sym == FloatS)) || (sym == FloatL)) || (sym == SFloat)) || (sym == LFloat);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsInt - returns TRUE if, sym, is INT or its typed counterparts
           INTL, INTS.
*/

extern "C" bool M2Base_IsInt (unsigned int sym)
{
  return ((sym == Int) || (sym == IntS)) || (sym == IntL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AssignmentRequiresWarning - returns TRUE if t1 and t2 can be used during
                               an assignment, but should generate a warning.
                               For example in PIM we can assign ADDRESS
                               and WORD providing they are both the
                               same size.
                               No warning is necessary if the types are the same.
*/

extern "C" bool M2Base_AssignmentRequiresWarning (unsigned int t1, unsigned int t2)
{
  return (t1 != t2) && (((IsCompatible (t1, t2, M2Base_assignment)) == M2Base_warnfirst) || ((IsCompatible (t1, t2, M2Base_assignment)) == M2Base_warnsecond));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsAssignmentCompatible - returns TRUE if t1 and t2 are assignment
                            compatible.
*/

extern "C" bool M2Base_IsAssignmentCompatible (unsigned int t1, unsigned int t2)
{
  return ((t1 == t2) || ((IsCompatible (t1, t2, M2Base_assignment)) == M2Base_first)) || ((IsCompatible (t1, t2, M2Base_assignment)) == M2Base_second);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsExpressionCompatible - returns TRUE if t1 and t2 are expression
                            compatible.
*/

extern "C" bool M2Base_IsExpressionCompatible (unsigned int t1, unsigned int t2)
{
  return ((IsCompatible (t1, t2, M2Base_expression)) == M2Base_first) || ((IsCompatible (t1, t2, M2Base_expression)) == M2Base_second);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsParameterCompatible - returns TRUE if t1 and t2 are expression
                           compatible.
*/

extern "C" bool M2Base_IsParameterCompatible (unsigned int t1, unsigned int t2)
{
  return ((IsCompatible (t1, t2, M2Base_parameter)) == M2Base_first) || ((IsCompatible (t1, t2, M2Base_parameter)) == M2Base_second);  /* ; tokenNo: CARDINAL  */
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsComparisonCompatible - returns TRUE if t1 and t2 are comparison compatible.
*/

extern "C" bool M2Base_IsComparisonCompatible (unsigned int t1, unsigned int t2)
{
  return ((IsCompatible (t1, t2, M2Base_comparison)) == M2Base_first) || ((IsCompatible (t1, t2, M2Base_comparison)) == M2Base_second);  /* ; tokenNo: CARDINAL  */
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsValidParameter - returns TRUE if an, actual, parameter can be passed
                      to the, formal, parameter.  This differs from
                      IsParameterCompatible as this procedure includes checks
                      for unbounded formal parameters, var parameters and
                      constant actual parameters.
*/

extern "C" bool M2Base_IsValidParameter (unsigned int formal, unsigned int actual)
{
  unsigned int at;
  unsigned int ft;

  M2Debug_Assert (SymbolTable_IsParameter (formal));  /* ; tokenNo: CARDINAL  */
  M2Debug_Assert (M2Pass_IsPassCodeGeneration ());
  if ((SymbolTable_IsConst (actual)) && (SymbolTable_IsParameterVar (formal)))
    {
      return false;
    }
  else
    {
      if (SymbolTable_IsParameterUnbounded (formal))
        {
          return IsValidUnboundedParameter (formal, actual);
        }
      else
        {
          ft = SymbolTable_SkipType (SymbolTable_GetType (formal));
        }
      if ((((SymbolTable_IsConst (actual)) && ((SymbolTable_SkipType (SymbolTable_GetType (actual))) == M2Base_Char)) && (SymbolTable_IsArray (ft))) && ((SymbolTable_SkipType (SymbolTable_GetType (ft))) == M2Base_Char))
        {
          /* a constant char can be either a char or a string  */
          return true;
        }
      if (SymbolTable_IsProcType (ft))
        {
          if (SymbolTable_IsProcedure (actual))
            {
              /* we check this by calling IsValidProcedure for each and every
               parameter of actual and formal  */
              return true;
            }
          else
            {
              at = SymbolTable_SkipType (SymbolTable_GetType (actual));
              return doProcTypeCheck (at, ft, true);
            }
        }
      else if (SymbolTable_IsParameterVar (formal))
        {
          /* avoid dangling else.  */
          return IsVarParamCompatible (SymbolTable_GetType (actual), ft);
        }
      else
        {
          /* avoid dangling else.  */
          return M2Base_IsParameterCompatible (SymbolTable_GetType (actual), ft);
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckExpressionCompatible - returns if t1 and t2 are compatible types for
                               +, -, *, DIV, >, <, =, etc.
                               If t1 and t2 are not compatible then an error
                               message is displayed.
*/

extern "C" void M2Base_CheckExpressionCompatible (unsigned int tok, unsigned int left, unsigned int right)
{
  CheckCompatible (tok, left, right, M2Base_expression);
}


/*
   CheckAssignmentCompatible - returns if t1 and t2 are compatible types for
                               :=, =, #.
                               If t1 and t2 are not compatible then an error
                               message is displayed.
*/

extern "C" void M2Base_CheckAssignmentCompatible (unsigned int tok, unsigned int left, unsigned int right)
{
  if (left != right)
    {
      CheckCompatible (tok, left, right, M2Base_assignment);
    }
}


/*
   CheckParameterCompatible - checks to see if types, t1, and, t2, are
                              compatible for parameter passing.
*/

extern "C" void M2Base_CheckParameterCompatible (unsigned int tok, unsigned int t1, unsigned int t2)
{
  CheckCompatible (tok, t1, t2, M2Base_parameter);
}


/*
   CannotCheckTypeInPass3 - returns TRUE if we are unable to check the
                            type of, e, in pass 3.
*/

extern "C" bool M2Base_CannotCheckTypeInPass3 (unsigned int e)
{
  unsigned int t;
  M2Base_MetaType mt;

  t = SymbolTable_SkipType (SymbolTable_GetType (e));
  mt = FindMetaType (t);
  switch (mt)
    {
      case M2Base_pointer:
      case M2Base_enum:
      case M2Base_set:
      case M2Base_set8:
      case M2Base_set16:
      case M2Base_set32:
      case M2Base_opaque:
        return true;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MixTypes - given types leftType and rightType return a type symbol that
              provides expression type compatibility.
              NearTok is used to identify the source position if a type
              incompatability occurs.
*/

extern "C" unsigned int M2Base_MixTypes (unsigned int leftType, unsigned int rightType, unsigned int NearTok)
{
  return M2Base_MixTypesDecl (SymbolTable_NulSym, SymbolTable_NulSym, leftType, rightType, NearTok);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MixTypesDecl - returns a type symbol which provides expression compatibility
                  between leftType and rightType.  An error is emitted if this
                  is not possible.  left and right are the source (variable,
                  constant) of leftType and rightType respectively.
*/

extern "C" unsigned int M2Base_MixTypesDecl (unsigned int left, unsigned int right, unsigned int leftType, unsigned int rightType, unsigned int NearTok)
{
  if (leftType == rightType)
    {
      return leftType;
    }
  else if ((leftType == M2System_Address) && (rightType == M2Base_Cardinal))
    {
      /* avoid dangling else.  */
      return M2System_Address;
    }
  else if ((leftType == M2Base_Cardinal) && (rightType == M2System_Address))
    {
      /* avoid dangling else.  */
      return M2System_Address;
    }
  else if ((leftType == M2System_Address) && (rightType == M2Base_Integer))
    {
      /* avoid dangling else.  */
      return M2System_Address;
    }
  else if ((leftType == M2Base_Integer) && (rightType == M2System_Address))
    {
      /* avoid dangling else.  */
      return M2System_Address;
    }
  else if (leftType == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      return rightType;
    }
  else if (rightType == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      return leftType;
    }
  else if ((leftType == M2Bitset_Bitset) && (SymbolTable_IsSet (rightType)))
    {
      /* avoid dangling else.  */
      return leftType;
    }
  else if ((SymbolTable_IsSet (leftType)) && (rightType == M2Bitset_Bitset))
    {
      /* avoid dangling else.  */
      return rightType;
    }
  else if (SymbolTable_IsEnumeration (leftType))
    {
      /* avoid dangling else.  */
      return M2Base_MixTypesDecl (left, right, M2Base_Integer, rightType, NearTok);
    }
  else if (SymbolTable_IsEnumeration (rightType))
    {
      /* avoid dangling else.  */
      return M2Base_MixTypesDecl (left, right, leftType, M2Base_Integer, NearTok);
    }
  else if (SymbolTable_IsSubrange (leftType))
    {
      /* avoid dangling else.  */
      return M2Base_MixTypesDecl (left, right, SymbolTable_GetType (leftType), rightType, NearTok);
    }
  else if (SymbolTable_IsSubrange (rightType))
    {
      /* avoid dangling else.  */
      return M2Base_MixTypesDecl (left, right, leftType, SymbolTable_GetType (rightType), NearTok);
    }
  else if ((M2Base_IsRealType (leftType)) && (M2Base_IsRealType (rightType)))
    {
      /* avoid dangling else.  */
      if (leftType == M2Base_RType)
        {
          return rightType;
        }
      else if (rightType == M2Base_RType)
        {
          /* avoid dangling else.  */
          return leftType;
        }
      else
        {
          /* avoid dangling else.  */
          return M2Base_RType;
        }
    }
  else if ((M2Base_IsComplexType (leftType)) && (M2Base_IsComplexType (rightType)))
    {
      /* avoid dangling else.  */
      if (leftType == M2Base_CType)
        {
          return rightType;
        }
      else if (rightType == M2Base_CType)
        {
          /* avoid dangling else.  */
          return leftType;
        }
      else
        {
          /* avoid dangling else.  */
          return M2Base_CType;
        }
    }
  else if (IsUserType (leftType))
    {
      /* avoid dangling else.  */
      return M2Base_MixTypesDecl (left, right, SymbolTable_GetType (leftType), rightType, NearTok);
    }
  else if (IsUserType (rightType))
    {
      /* avoid dangling else.  */
      return M2Base_MixTypes (leftType, SymbolTable_GetType (rightType), NearTok);
    }
  else if (leftType == M2Base_ZType)
    {
      /* avoid dangling else.  */
      return rightType;
    }
  else if (rightType == M2Base_ZType)
    {
      /* avoid dangling else.  */
      return leftType;
    }
  else if ((leftType == (SymbolTable_GetLowestType (leftType))) && (rightType == (SymbolTable_GetLowestType (rightType))))
    {
      /* avoid dangling else.  */
      return MixMetaTypes (left, right, leftType, rightType, NearTok);
    }
  else
    {
      /* avoid dangling else.  */
      leftType = SymbolTable_GetLowestType (leftType);
      rightType = SymbolTable_GetLowestType (rightType);
      return M2Base_MixTypesDecl (left, right, leftType, rightType, NearTok);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NegateType - if the type is unsigned then returns the
                signed equivalent.
*/

extern "C" unsigned int M2Base_NegateType (unsigned int type)
{
  unsigned int lowType;

  if (type != SymbolTable_NulSym)  /* ; sympos: CARDINAL  */
    {
      lowType = SymbolTable_GetLowestType (type);
      if (lowType == M2Base_LongCard)
        {
          return M2Base_LongInt;
        }
      else if (lowType == M2Base_Cardinal)
        {
          /* avoid dangling else.  */
          /* ELSE
         MetaErrorT1 (sympos, 'the type {%1ad} does not have a negated equivalent and an unary minus cannot be used on an operand of this type', type)
  */
          return M2Base_Integer;
        }
    }
  return type;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsMathType - returns TRUE if the type is a mathematical type.
                A mathematical type has a range larger than INTEGER.
                (Typically SHORTREAL/REAL/LONGREAL/LONGINT/LONGCARD)
*/

extern "C" bool M2Base_IsMathType (unsigned int type)
{
  return ((((((type == M2Base_LongCard) || (type == M2Base_LongInt)) || (type == M2Base_Real)) || (type == M2Base_LongReal)) || (type == M2Base_ShortReal)) || (type == M2Base_RType)) || (type == M2Base_ZType);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRealType - returns TRUE if, t, is a real type.
*/

extern "C" bool M2Base_IsRealType (unsigned int t)
{
  return (((t == M2Base_Real) || (t == M2Base_LongReal)) || (t == M2Base_ShortReal)) || (t == M2Base_RType);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsComplexType - returns TRUE if, sym, is COMPLEX,
                   LONGCOMPLEX or SHORTCOMPLEX.
*/

extern "C" bool M2Base_IsComplexType (unsigned int sym)
{
  return ((((sym == M2Base_Complex) || (sym == M2Base_LongComplex)) || (sym == M2Base_ShortComplex)) || (sym == M2Base_CType)) || (M2System_IsComplexN (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ComplexToScalar - returns the scalar (or base type) of the complex type, sym.
*/

extern "C" unsigned int M2Base_ComplexToScalar (unsigned int sym)
{
  if (sym == SymbolTable_NulSym)
    {
      /* a const complex may have a NulSym type  */
      return M2Base_RType;
    }
  else if (sym == M2Base_Complex)
    {
      /* avoid dangling else.  */
      return M2Base_Real;
    }
  else if (sym == M2Base_LongComplex)
    {
      /* avoid dangling else.  */
      return M2Base_LongReal;
    }
  else if (sym == M2Base_ShortComplex)
    {
      /* avoid dangling else.  */
      return M2Base_ShortReal;
    }
  else if (sym == M2Base_CType)
    {
      /* avoid dangling else.  */
      return M2Base_RType;
    }
  else if (sym == (M2System_ComplexN (32)))
    {
      /* avoid dangling else.  */
      return M2System_RealN (32);
    }
  else if (sym == (M2System_ComplexN (64)))
    {
      /* avoid dangling else.  */
      return M2System_RealN (64);
    }
  else if (sym == (M2System_ComplexN (96)))
    {
      /* avoid dangling else.  */
      return M2System_RealN (96);
    }
  else if (sym == (M2System_ComplexN (128)))
    {
      /* avoid dangling else.  */
      return M2System_RealN (128);
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "{%1ad} must be a COMPLEX type", 29, sym);
      return M2Base_RType;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ScalarToComplex - given a real type, t, return the equivalent complex type.
*/

extern "C" unsigned int M2Base_ScalarToComplex (unsigned int sym)
{
  if (sym == M2Base_Real)
    {
      return M2Base_Complex;
    }
  else if (sym == M2Base_LongReal)
    {
      /* avoid dangling else.  */
      return M2Base_LongComplex;
    }
  else if (sym == M2Base_ShortReal)
    {
      /* avoid dangling else.  */
      return M2Base_ShortComplex;
    }
  else if (sym == M2Base_RType)
    {
      /* avoid dangling else.  */
      return M2Base_CType;
    }
  else if (sym == (M2System_RealN (32)))
    {
      /* avoid dangling else.  */
      return M2System_ComplexN (32);
    }
  else if (sym == (M2System_RealN (64)))
    {
      /* avoid dangling else.  */
      return M2System_ComplexN (64);
    }
  else if (sym == (M2System_RealN (96)))
    {
      /* avoid dangling else.  */
      return M2System_ComplexN (96);
    }
  else if (sym == (M2System_RealN (128)))
    {
      /* avoid dangling else.  */
      return M2System_ComplexN (128);
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "{%1ad} must be a REAL type", 26, sym);
      return M2Base_Complex;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetCmplxReturnType - this code implements the table given in the
                        ISO standard Page 293 with an addition for
                        SHORTCOMPLEX.
*/

extern "C" unsigned int M2Base_GetCmplxReturnType (unsigned int t1, unsigned int t2)
{
  M2Base_MetaType mt1;
  M2Base_MetaType mt2;

  t1 = SymbolTable_SkipType (t1);
  t2 = SymbolTable_SkipType (t2);
  if (((M2Base_IsRealType (t1)) || (M2System_IsRealN (t1))) && ((M2Base_IsRealType (t2)) || (M2System_IsRealN (t2))))
    {
      mt1 = FindMetaType (t1);
      mt2 = FindMetaType (t2);
      if (mt1 == mt2)
        {
          return M2Base_ScalarToComplex (t1);
        }
      else
        {
          if (mt1 == M2Base_rtype)
            {
              return M2Base_ScalarToComplex (t2);
            }
          else if (mt2 == M2Base_rtype)
            {
              /* avoid dangling else.  */
              return M2Base_ScalarToComplex (t1);
            }
          else
            {
              /* avoid dangling else.  */
              return SymbolTable_NulSym;
            }
        }
    }
  else
    {
      return SymbolTable_NulSym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Base_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2Base_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
