/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* AArch64PostLegalizerLoweringImpl Combiner Match Table                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GICOMBINER_DEPS
#include "llvm/ADT/SparseBitVector.h"
namespace llvm {
extern cl::OptionCategory GICombinerOptionCategory;
} // end namespace llvm
#endif // ifdef GET_GICOMBINER_DEPS

#ifdef GET_GICOMBINER_TYPES
struct AArch64PostLegalizerLoweringImplRuleConfig {
  SparseBitVector<> DisabledRules;

  bool isRuleEnabled(unsigned RuleID) const;
  bool parseCommandLineOption();
  bool setRuleEnabled(StringRef RuleIdentifier);
  bool setRuleDisabled(StringRef RuleIdentifier);
};

static std::optional<uint64_t> getRuleIdxForIdentifier(StringRef RuleIdentifier) {
  uint64_t I;
  // getAtInteger(...) returns false on success
  bool Parsed = !RuleIdentifier.getAsInteger(0, I);
  if (Parsed)
    return I;

#ifndef NDEBUG
  switch (RuleIdentifier.size()) {
  default: break;
  case 3:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "up", 2) != 0)
        break;
      return 0;	 // "dup"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xt", 2) != 0)
        break;
      return 3;	 // "ext"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ev", 2) != 0)
        break;
      return 2;	 // "rev"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "rn", 2) != 0)
        break;
      return 6;	 // "trn"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "zp", 2) != 0)
        break;
      return 5;	 // "uzp"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ip", 2) != 0)
        break;
      return 4;	 // "zip"
    }
    break;
  case 7:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "fullrev", 7) != 0)
      break;
    return 7;	 // "fullrev"
  case 11:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "shuf_to_ins", 11) != 0)
      break;
    return 8;	 // "shuf_to_ins"
  case 12:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "form_duplane", 12) != 0)
      break;
    return 1;	 // "form_duplane"
  case 14:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "lower_mulv2s64", 14) != 0)
      break;
    return 18;	 // "lower_mulv2s64"
  case 15:	 // 3 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "djust_icmp_imm", 14) != 0)
        break;
      return 10;	 // "adjust_icmp_imm"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "orm_truncstore", 14) != 0)
        break;
      return 15;	 // "form_truncstore"
    case 'v':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ashr_vlshr_imm", 14) != 0)
        break;
      return 9;	 // "vashr_vlshr_imm"
    }
    break;
  case 16:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "unmerge_duplane8", 16) != 0)
      break;
    return 21;	 // "unmerge_duplane8"
  case 17:	 // 3 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ower_vector_fcmp", 16) != 0)
        break;
      return 14;	 // "lower_vector_fcmp"
    case 'u':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_duplane", 14) != 0)
        break;
      switch (RuleIdentifier[15]) {
      default: break;
      case '1':	 // 1 string to match.
        if (RuleIdentifier[16] != '6')
          break;
        return 22;	 // "unmerge_duplane16"
      case '3':	 // 1 string to match.
        if (RuleIdentifier[16] != '2')
          break;
        return 23;	 // "unmerge_duplane32"
      }
      break;
    }
    break;
  case 18:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nsertelt_nonconst", 17) != 0)
        break;
      return 20;	 // "insertelt_nonconst"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "wap_icmp_operands", 17) != 0)
        break;
      return 11;	 // "swap_icmp_operands"
    }
    break;
  case 19:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "build_vector_to_dup", 19) != 0)
      break;
    return 12;	 // "build_vector_to_dup"
  case 22:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "unmerge_ext_to_unmerge", 22) != 0)
      break;
    return 17;	 // "unmerge_ext_to_unmerge"
  case 23:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "vector_unmerge_lowering", 23) != 0)
      break;
    return 19;	 // "vector_unmerge_lowering"
  case 26:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "vector_sext_inreg_to_shift", 26) != 0)
      break;
    return 16;	 // "vector_sext_inreg_to_shift"
  case 29:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "build_vector_to_vector_insert", 29) != 0)
      break;
    return 13;	 // "build_vector_to_vector_insert"
  }
#endif // ifndef NDEBUG

  return std::nullopt;
}
static std::optional<std::pair<uint64_t, uint64_t>> getRuleRangeForIdentifier(StringRef RuleIdentifier) {
  std::pair<StringRef, StringRef> RangePair = RuleIdentifier.split('-');
  if (!RangePair.second.empty()) {
    const auto First = getRuleIdxForIdentifier(RangePair.first);
    const auto Last = getRuleIdxForIdentifier(RangePair.second);
    if (!First || !Last)
      return std::nullopt;
    if (First >= Last)
      report_fatal_error("Beginning of range should be before end of range");
    return {{*First, *Last + 1}};
  }
  if (RangePair.first == "*") {
    return {{0, 24}};
  }
  const auto I = getRuleIdxForIdentifier(RangePair.first);
  if (!I)
    return std::nullopt;
  return {{*I, *I + 1}};
}

bool AArch64PostLegalizerLoweringImplRuleConfig::setRuleEnabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.reset(I);
  return true;
}

bool AArch64PostLegalizerLoweringImplRuleConfig::setRuleDisabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.set(I);
  return true;
}

static std::vector<std::string> AArch64PostLegalizerLoweringOption;
static cl::list<std::string> AArch64PostLegalizerLoweringDisableOption(
    "aarch64postlegalizerlowering-disable-rule",
    cl::desc("Disable one or more combiner rules temporarily in the AArch64PostLegalizerLowering pass"),
    cl::CommaSeparated,
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &Str) {
      AArch64PostLegalizerLoweringOption.push_back(Str);
    }));
static cl::list<std::string> AArch64PostLegalizerLoweringOnlyEnableOption(
    "aarch64postlegalizerlowering-only-enable-rule",
    cl::desc("Disable all rules in the AArch64PostLegalizerLowering pass then re-enable the specified ones"),
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &CommaSeparatedArg) {
      StringRef Str = CommaSeparatedArg;
      AArch64PostLegalizerLoweringOption.push_back("*");
      do {
        auto X = Str.split(",");
        AArch64PostLegalizerLoweringOption.push_back(("!" + X.first).str());
        Str = X.second;
      } while (!Str.empty());
    }));


bool AArch64PostLegalizerLoweringImplRuleConfig::isRuleEnabled(unsigned RuleID) const {
    return  !DisabledRules.test(RuleID);
}
bool AArch64PostLegalizerLoweringImplRuleConfig::parseCommandLineOption() {
  for (StringRef Identifier : AArch64PostLegalizerLoweringOption) {
    bool Enabled = Identifier.consume_front("!");
    if (Enabled && !setRuleEnabled(Identifier))
      return false;
    if (!Enabled && !setRuleDisabled(Identifier))
      return false;
  }
  return true;
}

#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_TYPES
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_CLASS_MEMBERS
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS
#ifdef GET_GICOMBINER_CLASS_MEMBERS
  mutable MatcherState State;
  typedef ComplexRendererFns(AArch64PostLegalizerLoweringImpl::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AArch64PostLegalizerLoweringImpl::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AArch64PostLegalizerLoweringImpl::ComplexMatcherMemFn ComplexPredicateFns[];
  static AArch64PostLegalizerLoweringImpl::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS

#ifdef GET_GICOMBINER_IMPL
// LLT Objects.
enum {
  GILLT_s1,
};
const static size_t NumTypeObjects = 1;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset AArch64PostLegalizerLoweringImpl::
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const {
  PredicateBitset Features{};
  return Features;
}

void AArch64PostLegalizerLoweringImpl::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AArch64Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AArch64PostLegalizerLoweringImpl::
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

AArch64PostLegalizerLoweringImpl::ComplexMatcherMemFn
AArch64PostLegalizerLoweringImpl::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

enum {
  GICXXPred_MI_Predicate_GICombiner0 = GICXXPred_Invalid + 1,
};
bool AArch64PostLegalizerLoweringImpl::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_GICombiner0: {
    return MRI.getType(State.MIs[0]->getOperand(0).getReg()).getSizeInBits() == 64;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64PostLegalizerLoweringImpl::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64PostLegalizerLoweringImpl::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64PostLegalizerLoweringImpl::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64PostLegalizerLoweringImpl::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
enum {
  GICXXPred_Simple_IsRule0Enabled = GICXXPred_Invalid + 1,
  GICXXPred_Simple_IsRule1Enabled,
  GICXXPred_Simple_IsRule2Enabled,
  GICXXPred_Simple_IsRule3Enabled,
  GICXXPred_Simple_IsRule4Enabled,
  GICXXPred_Simple_IsRule5Enabled,
  GICXXPred_Simple_IsRule6Enabled,
  GICXXPred_Simple_IsRule7Enabled,
  GICXXPred_Simple_IsRule8Enabled,
  GICXXPred_Simple_IsRule9Enabled,
  GICXXPred_Simple_IsRule10Enabled,
  GICXXPred_Simple_IsRule11Enabled,
  GICXXPred_Simple_IsRule12Enabled,
  GICXXPred_Simple_IsRule13Enabled,
  GICXXPred_Simple_IsRule14Enabled,
  GICXXPred_Simple_IsRule15Enabled,
  GICXXPred_Simple_IsRule16Enabled,
  GICXXPred_Simple_IsRule17Enabled,
  GICXXPred_Simple_IsRule18Enabled,
  GICXXPred_Simple_IsRule19Enabled,
  GICXXPred_Simple_IsRule20Enabled,
  GICXXPred_Simple_IsRule21Enabled,
  GICXXPred_Simple_IsRule22Enabled,
  GICXXPred_Simple_IsRule23Enabled,
};

bool AArch64PostLegalizerLoweringImpl::testSimplePredicate(unsigned Predicate) const {
    return RuleConfig.isRuleEnabled(Predicate - GICXXPred_Invalid - 1);
}
// Custom renderers.
enum {
  GICR_Invalid,
};
AArch64PostLegalizerLoweringImpl::CustomRendererFn
AArch64PostLegalizerLoweringImpl::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool AArch64PostLegalizerLoweringImpl::tryCombineAll(MachineInstr &I) const {
  const TargetSubtargetInfo &ST = MF.getSubtarget();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  B.setInstrAndDebugLoc(I);
  State.MIs.clear();
  State.MIs.push_back(&I);
  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), *ST.getInstrInfo(), MRI, *MRI.getTargetRegisterInfo(), *ST.getRegBankInfo(), AvailableFeatures, /*CoverageInfo*/ nullptr)) {
    return true;
  }

  return false;
}

enum {
  GICXXCustomAction_GICombiner0 = GICXXCustomAction_Invalid + 1,
  GICXXCustomAction_GICombiner1,
  GICXXCustomAction_GICombiner2,
  GICXXCustomAction_GICombiner3,
  GICXXCustomAction_GICombiner4,
  GICXXCustomAction_GICombiner5,
  GICXXCustomAction_GICombiner6,
  GICXXCustomAction_GICombiner7,
  GICXXCustomAction_GICombiner8,
  GICXXCustomAction_GICombiner9,
  GICXXCustomAction_GICombiner10,
  GICXXCustomAction_GICombiner11,
  GICXXCustomAction_GICombiner12,
  GICXXCustomAction_GICombiner13,
  GICXXCustomAction_GICombiner14,
  GICXXCustomAction_GICombiner15,
  GICXXCustomAction_GICombiner16,
  GICXXCustomAction_GICombiner17,
  GICXXCustomAction_GICombiner18,
  GICXXCustomAction_GICombiner19,
  GICXXCustomAction_GICombiner20,
};
bool AArch64PostLegalizerLoweringImpl::runCustomAction(unsigned ApplyID, const MatcherState &State, NewMIVector &OutMIs) const {
  Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
  switch(ApplyID) {
  case GICXXCustomAction_GICombiner0:{
    ShuffleVectorPseudo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchDup(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyShuffleVectorPseudo(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner1:{
    std::pair<unsigned, int> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchDupLane(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyDupLane(*State.MIs[0], MRI, B, GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner2:{
    ShuffleVectorPseudo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchREV(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyShuffleVectorPseudo(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner3:{
    ShuffleVectorPseudo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchEXT(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyEXT(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner4:{
    ShuffleVectorPseudo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchZip(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyShuffleVectorPseudo(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner5:{
    ShuffleVectorPseudo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchUZP(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyShuffleVectorPseudo(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner6:{
    ShuffleVectorPseudo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchTRN(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyShuffleVectorPseudo(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner7:{
    ShuffleVectorPseudo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return ShuffleVectorInst::isReverseMask(State.MIs[0]->getOperand(3).getShuffleMask(),
                                                            State.MIs[0]->getOperand(3).getShuffleMask().size());}()) {
      return false;
    }
    // Apply Patterns
    applyFullRev(*State.MIs[0], MRI);
    return true;
  }
  case GICXXCustomAction_GICombiner8:{
    std::tuple<Register, int, Register, int> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchINS(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyINS(*State.MIs[0], MRI, B, GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner9:{
    int64_t GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchVAshrLshrImm(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyVAshrLshrImm(*State.MIs[0], MRI, GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner10:{
    std::pair<uint64_t, CmpInst::Predicate> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchAdjustICmpImmAndPred(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyAdjustICmpImmAndPred(*State.MIs[0], GIMatchData_matchinfo, B, Observer);
    return true;
  }
  case GICXXCustomAction_GICombiner11:{
    // Match Patterns
    if(![&](){return trySwapICmpOperands(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applySwapICmpOperands(*State.MIs[0], Observer);
    return true;
  }
  case GICXXCustomAction_GICombiner12:{
    // Match Patterns
    if(![&](){return matchBuildVectorToDup(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applyBuildVectorToDup(*State.MIs[0], MRI, B);
    return true;
  }
  case GICXXCustomAction_GICombiner13:{
    // Match Patterns
    if(![&](){return matchLowerBuildToInsertVecElt(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applyLowerBuildToInsertVecElt(*State.MIs[0], MRI, B);
    return true;
  }
  case GICXXCustomAction_GICombiner14:{
    // Match Patterns
    if(![&](){return matchLowerVectorFCMP(*State.MIs[0], MRI, B);}()) {
      return false;
    }
    // Apply Patterns
    applyLowerVectorFCMP(*State.MIs[0], MRI, B);
    return true;
  }
  case GICXXCustomAction_GICombiner15:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchFormTruncstore(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyFormTruncstore(*State.MIs[0], MRI, B, Observer, GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner16:{
    // Match Patterns
    if(![&](){return matchVectorSextInReg(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applyVectorSextInReg(*State.MIs[0], MRI, B, Observer);
    return true;
  }
  case GICXXCustomAction_GICombiner17:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchUnmergeExtToUnmerge(*State.MIs[0], MRI, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyUnmergeExtToUnmerge(*State.MIs[0], MRI, B, Observer, GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner18:{
    // Match Patterns
    if(![&](){return matchMulv2s64(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applyMulv2s64(*State.MIs[0], MRI, B, Observer);
    return true;
  }
  case GICXXCustomAction_GICombiner19:{
    // Match Patterns
    if(![&](){return matchScalarizeVectorUnmerge(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applyScalarizeVectorUnmerge(*State.MIs[0], MRI, B);
    return true;
  }
  case GICXXCustomAction_GICombiner20:{
    ShuffleVectorPseudo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchNonConstInsert(*State.MIs[0], MRI);}()) {
      return false;
    }
    // Apply Patterns
    applyNonConstInsert(*State.MIs[0], MRI, B);
    return true;
  }
  }
  llvm_unreachable("Unknown Apply Action");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *AArch64PostLegalizerLoweringImpl::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*    0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(55), GIMT_Encode2(245), /*)*//*default:*//*Label 11*/ GIMT_Encode4(1175),
     /*   10 */ /*TargetOpcode::G_MUL*//*Label 0*/ GIMT_Encode4(770), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   86 */ /*TargetOpcode::G_UNMERGE_VALUES*//*Label 1*/ GIMT_Encode4(782), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   98 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 2*/ GIMT_Encode4(944), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  186 */ /*TargetOpcode::G_STORE*//*Label 3*/ GIMT_Encode4(970), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  362 */ /*TargetOpcode::G_SEXT_INREG*//*Label 4*/ GIMT_Encode4(982), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  374 */ /*TargetOpcode::G_LSHR*//*Label 5*/ GIMT_Encode4(994),
     /*  378 */ /*TargetOpcode::G_ASHR*//*Label 6*/ GIMT_Encode4(1006), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  398 */ /*TargetOpcode::G_ICMP*//*Label 7*/ GIMT_Encode4(1018),
     /*  402 */ /*TargetOpcode::G_FCMP*//*Label 8*/ GIMT_Encode4(1041), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  758 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 9*/ GIMT_Encode4(1053), GIMT_Encode4(0),
     /*  766 */ /*TargetOpcode::G_SHUFFLE_VECTOR*//*Label 10*/ GIMT_Encode4(1065),
     /*  770 */ // Label 0: @770
     /*  770 */ GIM_Try, /*On fail goto*//*Label 12*/ GIMT_Encode4(781), // Rule ID 19 //
     /*  775 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /*  778 */   // MIs[0] dst
     /*  778 */   // No operand predicates
     /*  778 */   // MIs[0] src1
     /*  778 */   // No operand predicates
     /*  778 */   // MIs[0] src2
     /*  778 */   // No operand predicates
     /*  778 */   // Combiner Rule #18: lower_mulv2s64
     /*  778 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner18),
     /*  781 */ // Label 12: @781
     /*  781 */ GIM_Reject,
     /*  782 */ // Label 1: @782
     /*  782 */ GIM_Try, /*On fail goto*//*Label 13*/ GIMT_Encode4(793), // Rule ID 18 //
     /*  787 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /*  790 */   // Combiner Rule #17: unmerge_ext_to_unmerge; wip_match_opcode 'G_UNMERGE_VALUES'
     /*  790 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner17),
     /*  793 */ // Label 13: @793
     /*  793 */ GIM_Try, /*On fail goto*//*Label 14*/ GIMT_Encode4(804), // Rule ID 20 //
     /*  798 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule19Enabled),
     /*  801 */   // Combiner Rule #19: vector_unmerge_lowering; wip_match_opcode 'G_UNMERGE_VALUES'
     /*  801 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner19),
     /*  804 */ // Label 14: @804
     /*  804 */ GIM_Try, /*On fail goto*//*Label 15*/ GIMT_Encode4(943),
     /*  809 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /*  812 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner0),
     /*  816 */   GIM_Try, /*On fail goto*//*Label 16*/ GIMT_Encode4(858), // Rule ID 23 //
     /*  821 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule22Enabled),
     /*  824 */     // MIs[0] d1
     /*  824 */     // No operand predicates
     /*  824 */     // MIs[0] d2
     /*  824 */     // No operand predicates
     /*  824 */     // MIs[0] a
     /*  824 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  828 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  832 */     // MIs[1] src
     /*  832 */     // No operand predicates
     /*  832 */     // MIs[1] c
     /*  832 */     // No operand predicates
     /*  832 */     GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/1, /*NewInsnId*/0, /*NewOpIdx*/0,
     /*  837 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  839 */     // Combiner Rule #22: unmerge_duplane16
     /*  839 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  842 */     GIR_RootToRootCopy, /*OpIdx*/0, // d1
     /*  844 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  848 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // c
     /*  852 */     GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/1, /*NewInsnId*/0, /*NewOpIdx*/0,
     /*  857 */     GIR_EraseRootFromParent_Done,
     /*  858 */   // Label 16: @858
     /*  858 */   GIM_Try, /*On fail goto*//*Label 17*/ GIMT_Encode4(900), // Rule ID 24 //
     /*  863 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /*  866 */     // MIs[0] d1
     /*  866 */     // No operand predicates
     /*  866 */     // MIs[0] d2
     /*  866 */     // No operand predicates
     /*  866 */     // MIs[0] a
     /*  866 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  870 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  874 */     // MIs[1] src
     /*  874 */     // No operand predicates
     /*  874 */     // MIs[1] c
     /*  874 */     // No operand predicates
     /*  874 */     GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/1, /*NewInsnId*/0, /*NewOpIdx*/0,
     /*  879 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  881 */     // Combiner Rule #23: unmerge_duplane32
     /*  881 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  884 */     GIR_RootToRootCopy, /*OpIdx*/0, // d1
     /*  886 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  890 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // c
     /*  894 */     GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/1, /*NewInsnId*/0, /*NewOpIdx*/0,
     /*  899 */     GIR_EraseRootFromParent_Done,
     /*  900 */   // Label 17: @900
     /*  900 */   GIM_Try, /*On fail goto*//*Label 18*/ GIMT_Encode4(942), // Rule ID 22 //
     /*  905 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule21Enabled),
     /*  908 */     // MIs[0] d1
     /*  908 */     // No operand predicates
     /*  908 */     // MIs[0] d2
     /*  908 */     // No operand predicates
     /*  908 */     // MIs[0] a
     /*  908 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  912 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_DUPLANE8),
     /*  916 */     // MIs[1] src
     /*  916 */     // No operand predicates
     /*  916 */     // MIs[1] c
     /*  916 */     // No operand predicates
     /*  916 */     GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/1, /*NewInsnId*/0, /*NewOpIdx*/0,
     /*  921 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  923 */     // Combiner Rule #21: unmerge_duplane8
     /*  923 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::G_DUPLANE8),
     /*  926 */     GIR_RootToRootCopy, /*OpIdx*/0, // d1
     /*  928 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  932 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // c
     /*  936 */     GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/1, /*NewInsnId*/0, /*NewOpIdx*/0,
     /*  941 */     GIR_EraseRootFromParent_Done,
     /*  942 */   // Label 18: @942
     /*  942 */   GIM_Reject,
     /*  943 */ // Label 15: @943
     /*  943 */ GIM_Reject,
     /*  944 */ // Label 2: @944
     /*  944 */ GIM_Try, /*On fail goto*//*Label 19*/ GIMT_Encode4(955), // Rule ID 13 //
     /*  949 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule12Enabled),
     /*  952 */   // Combiner Rule #12: build_vector_to_dup; wip_match_opcode 'G_BUILD_VECTOR'
     /*  952 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner12),
     /*  955 */ // Label 19: @955
     /*  955 */ GIM_Try, /*On fail goto*//*Label 20*/ GIMT_Encode4(969), // Rule ID 14 //
     /*  960 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule13Enabled),
     /*  963 */   GIM_CheckNumOperandsGE, /*MI*/0, /*Expected*/2,
     /*  966 */   // MIs[0] dst
     /*  966 */   // No operand predicates
     /*  966 */   // MIs[0] unused
     /*  966 */   // No operand predicates
     /*  966 */   // Combiner Rule #13: build_vector_to_vector_insert
     /*  966 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /*  969 */ // Label 20: @969
     /*  969 */ GIM_Reject,
     /*  970 */ // Label 3: @970
     /*  970 */ GIM_Try, /*On fail goto*//*Label 21*/ GIMT_Encode4(981), // Rule ID 16 //
     /*  975 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /*  978 */   // MIs[0] src
     /*  978 */   // No operand predicates
     /*  978 */   // MIs[0] addr
     /*  978 */   // No operand predicates
     /*  978 */   // Combiner Rule #15: form_truncstore
     /*  978 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /*  981 */ // Label 21: @981
     /*  981 */ GIM_Reject,
     /*  982 */ // Label 4: @982
     /*  982 */ GIM_Try, /*On fail goto*//*Label 22*/ GIMT_Encode4(993), // Rule ID 17 //
     /*  987 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule16Enabled),
     /*  990 */   // Combiner Rule #16: vector_sext_inreg_to_shift; wip_match_opcode 'G_SEXT_INREG'
     /*  990 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner16),
     /*  993 */ // Label 22: @993
     /*  993 */ GIM_Reject,
     /*  994 */ // Label 5: @994
     /*  994 */ GIM_Try, /*On fail goto*//*Label 23*/ GIMT_Encode4(1005), // Rule ID 10 //
     /*  999 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule9Enabled),
     /* 1002 */   // Combiner Rule #9: vashr_vlshr_imm; wip_match_opcode 'G_LSHR'
     /* 1002 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 1005 */ // Label 23: @1005
     /* 1005 */ GIM_Reject,
     /* 1006 */ // Label 6: @1006
     /* 1006 */ GIM_Try, /*On fail goto*//*Label 24*/ GIMT_Encode4(1017), // Rule ID 9 //
     /* 1011 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule9Enabled),
     /* 1014 */   // Combiner Rule #9: vashr_vlshr_imm; wip_match_opcode 'G_ASHR'
     /* 1014 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 1017 */ // Label 24: @1017
     /* 1017 */ GIM_Reject,
     /* 1018 */ // Label 7: @1018
     /* 1018 */ GIM_Try, /*On fail goto*//*Label 25*/ GIMT_Encode4(1029), // Rule ID 11 //
     /* 1023 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule10Enabled),
     /* 1026 */   // MIs[0] dst
     /* 1026 */   // No operand predicates
     /* 1026 */   // MIs[0] tst
     /* 1026 */   // No operand predicates
     /* 1026 */   // MIs[0] src1
     /* 1026 */   // No operand predicates
     /* 1026 */   // MIs[0] src2
     /* 1026 */   // No operand predicates
     /* 1026 */   // Combiner Rule #10: adjust_icmp_imm
     /* 1026 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner10),
     /* 1029 */ // Label 25: @1029
     /* 1029 */ GIM_Try, /*On fail goto*//*Label 26*/ GIMT_Encode4(1040), // Rule ID 12 //
     /* 1034 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule11Enabled),
     /* 1037 */   // MIs[0] dst
     /* 1037 */   // No operand predicates
     /* 1037 */   // MIs[0] tst
     /* 1037 */   // No operand predicates
     /* 1037 */   // MIs[0] src1
     /* 1037 */   // No operand predicates
     /* 1037 */   // MIs[0] src2
     /* 1037 */   // No operand predicates
     /* 1037 */   // Combiner Rule #11: swap_icmp_operands
     /* 1037 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner11),
     /* 1040 */ // Label 26: @1040
     /* 1040 */ GIM_Reject,
     /* 1041 */ // Label 8: @1041
     /* 1041 */ GIM_Try, /*On fail goto*//*Label 27*/ GIMT_Encode4(1052), // Rule ID 15 //
     /* 1046 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule14Enabled),
     /* 1049 */   // MIs[0] dst
     /* 1049 */   // No operand predicates
     /* 1049 */   // MIs[0] tst
     /* 1049 */   // No operand predicates
     /* 1049 */   // MIs[0] src1
     /* 1049 */   // No operand predicates
     /* 1049 */   // MIs[0] src2
     /* 1049 */   // No operand predicates
     /* 1049 */   // Combiner Rule #14: lower_vector_fcmp
     /* 1049 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1052 */ // Label 27: @1052
     /* 1052 */ GIM_Reject,
     /* 1053 */ // Label 9: @1053
     /* 1053 */ GIM_Try, /*On fail goto*//*Label 28*/ GIMT_Encode4(1064), // Rule ID 21 //
     /* 1058 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule20Enabled),
     /* 1061 */   // Combiner Rule #20: insertelt_nonconst; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 1061 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 1064 */ // Label 28: @1064
     /* 1064 */ GIM_Reject,
     /* 1065 */ // Label 10: @1065
     /* 1065 */ GIM_Try, /*On fail goto*//*Label 29*/ GIMT_Encode4(1076), // Rule ID 0 //
     /* 1070 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule0Enabled),
     /* 1073 */   // Combiner Rule #0: dup; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 1073 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner0),
     /* 1076 */ // Label 29: @1076
     /* 1076 */ GIM_Try, /*On fail goto*//*Label 30*/ GIMT_Encode4(1087), // Rule ID 1 //
     /* 1081 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule1Enabled),
     /* 1084 */   // Combiner Rule #1: form_duplane; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 1084 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 1087 */ // Label 30: @1087
     /* 1087 */ GIM_Try, /*On fail goto*//*Label 31*/ GIMT_Encode4(1098), // Rule ID 2 //
     /* 1092 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule2Enabled),
     /* 1095 */   // Combiner Rule #2: rev; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 1095 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 1098 */ // Label 31: @1098
     /* 1098 */ GIM_Try, /*On fail goto*//*Label 32*/ GIMT_Encode4(1109), // Rule ID 3 //
     /* 1103 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule3Enabled),
     /* 1106 */   // Combiner Rule #3: ext; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 1106 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner3),
     /* 1109 */ // Label 32: @1109
     /* 1109 */ GIM_Try, /*On fail goto*//*Label 33*/ GIMT_Encode4(1120), // Rule ID 4 //
     /* 1114 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule4Enabled),
     /* 1117 */   // Combiner Rule #4: zip; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 1117 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner4),
     /* 1120 */ // Label 33: @1120
     /* 1120 */ GIM_Try, /*On fail goto*//*Label 34*/ GIMT_Encode4(1131), // Rule ID 5 //
     /* 1125 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1128 */   // Combiner Rule #5: uzp; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 1128 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /* 1131 */ // Label 34: @1131
     /* 1131 */ GIM_Try, /*On fail goto*//*Label 35*/ GIMT_Encode4(1142), // Rule ID 6 //
     /* 1136 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule6Enabled),
     /* 1139 */   // Combiner Rule #6: trn; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 1139 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner6),
     /* 1142 */ // Label 35: @1142
     /* 1142 */ GIM_Try, /*On fail goto*//*Label 36*/ GIMT_Encode4(1153), // Rule ID 8 //
     /* 1147 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule8Enabled),
     /* 1150 */   // Combiner Rule #8: shuf_to_ins; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 1150 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner8),
     /* 1153 */ // Label 36: @1153
     /* 1153 */ GIM_Try, /*On fail goto*//*Label 37*/ GIMT_Encode4(1174), // Rule ID 7 //
     /* 1158 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /* 1161 */   // MIs[0] src
     /* 1161 */   // No operand predicates
     /* 1161 */   // MIs[0] src1
     /* 1161 */   // No operand predicates
     /* 1161 */   // MIs[0] src2
     /* 1161 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1165 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 1169 */   // MIs[0] mask
     /* 1169 */   // No operand predicates
     /* 1169 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1171 */   // Combiner Rule #7: fullrev
     /* 1171 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner7),
     /* 1174 */ // Label 37: @1174
     /* 1174 */ GIM_Reject,
     /* 1175 */ // Label 11: @1175
     /* 1175 */ GIM_Reject,
     /* 1176 */ }; // Size: 1176 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GICOMBINER_IMPL

#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS

