/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * Lanai Disassembler                                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// an integer-typed field.
template <typename IntType>
static std::enable_if_t<std::is_integral_v<IntType>, void>
insertBits(IntType &field, IntType bits, unsigned startBit, unsigned numBits) {
  // Check that no bit beyond numBits is set, so that a simple bitwise |
  // is sufficient.
  assert((~(((IntType)1 << numBits) - 1) & bits) == 0 &&
           "bits has more than numBits bits set");
  assert(startBit + numBits <= sizeof(IntType) * 8);
  (void)numBits;
  field |= bits << startBit;
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTableLanai32[] = {
/* 0 */       MCD::OPC_ExtractField, 28, 4,  // Inst{31-28} ...
/* 3 */       MCD::OPC_FilterValue, 0, 120, 0, // Skip to: 127
/* 7 */       MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 10 */      MCD::OPC_FilterValue, 0, 91, 0, // Skip to: 105
/* 14 */      MCD::OPC_ExtractField, 0, 16,  // Inst{15-0} ...
/* 17 */      MCD::OPC_FilterValue, 1, 10, 0, // Skip to: 31
/* 21 */      MCD::OPC_CheckField, 18, 10, 0, 74, 0, // Skip to: 101
/* 27 */      MCD::OPC_Decode, 234, 2, 0, // Opcode: NOP, DecodeIdx: 0
/* 31 */      MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 45
/* 35 */      MCD::OPC_CheckField, 18, 10, 0, 60, 0, // Skip to: 101
/* 41 */      MCD::OPC_Decode, 228, 2, 0, // Opcode: LOG0, DecodeIdx: 0
/* 45 */      MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 59
/* 49 */      MCD::OPC_CheckField, 18, 10, 0, 46, 0, // Skip to: 101
/* 55 */      MCD::OPC_Decode, 229, 2, 0, // Opcode: LOG1, DecodeIdx: 0
/* 59 */      MCD::OPC_FilterValue, 4, 10, 0, // Skip to: 73
/* 63 */      MCD::OPC_CheckField, 18, 10, 0, 32, 0, // Skip to: 101
/* 69 */      MCD::OPC_Decode, 230, 2, 0, // Opcode: LOG2, DecodeIdx: 0
/* 73 */      MCD::OPC_FilterValue, 5, 10, 0, // Skip to: 87
/* 77 */      MCD::OPC_CheckField, 18, 10, 0, 18, 0, // Skip to: 101
/* 83 */      MCD::OPC_Decode, 231, 2, 0, // Opcode: LOG3, DecodeIdx: 0
/* 87 */      MCD::OPC_FilterValue, 6, 10, 0, // Skip to: 101
/* 91 */      MCD::OPC_CheckField, 18, 10, 0, 4, 0, // Skip to: 101
/* 97 */      MCD::OPC_Decode, 232, 2, 0, // Opcode: LOG4, DecodeIdx: 0
/* 101 */     MCD::OPC_Decode, 201, 2, 1, // Opcode: ADD_I_LO, DecodeIdx: 1
/* 105 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 113
/* 109 */     MCD::OPC_Decode, 200, 2, 1, // Opcode: ADD_I_HI, DecodeIdx: 1
/* 113 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 121
/* 117 */     MCD::OPC_Decode, 198, 2, 1, // Opcode: ADD_F_I_LO, DecodeIdx: 1
/* 121 */     MCD::OPC_FilterValueOrFail, 3, 
/* 123 */     MCD::OPC_Decode, 197, 2, 1, // Opcode: ADD_F_I_HI, DecodeIdx: 1
/* 127 */     MCD::OPC_FilterValue, 1, 33, 0, // Skip to: 164
/* 131 */     MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 134 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 142
/* 138 */     MCD::OPC_Decode, 195, 2, 1, // Opcode: ADDC_I_LO, DecodeIdx: 1
/* 142 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 150
/* 146 */     MCD::OPC_Decode, 194, 2, 1, // Opcode: ADDC_I_HI, DecodeIdx: 1
/* 150 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 158
/* 154 */     MCD::OPC_Decode, 192, 2, 1, // Opcode: ADDC_F_I_LO, DecodeIdx: 1
/* 158 */     MCD::OPC_FilterValueOrFail, 3, 
/* 160 */     MCD::OPC_Decode, 191, 2, 1, // Opcode: ADDC_F_I_HI, DecodeIdx: 1
/* 164 */     MCD::OPC_FilterValue, 2, 33, 0, // Skip to: 201
/* 168 */     MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 171 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 179
/* 175 */     MCD::OPC_Decode, 146, 3, 1, // Opcode: SUB_I_LO, DecodeIdx: 1
/* 179 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 187
/* 183 */     MCD::OPC_Decode, 145, 3, 1, // Opcode: SUB_I_HI, DecodeIdx: 1
/* 187 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 195
/* 191 */     MCD::OPC_Decode, 143, 3, 1, // Opcode: SUB_F_I_LO, DecodeIdx: 1
/* 195 */     MCD::OPC_FilterValueOrFail, 3, 
/* 197 */     MCD::OPC_Decode, 142, 3, 1, // Opcode: SUB_F_I_HI, DecodeIdx: 1
/* 201 */     MCD::OPC_FilterValue, 3, 33, 0, // Skip to: 238
/* 205 */     MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 208 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 216
/* 212 */     MCD::OPC_Decode, 140, 3, 1, // Opcode: SUBB_I_LO, DecodeIdx: 1
/* 216 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 224
/* 220 */     MCD::OPC_Decode, 139, 3, 1, // Opcode: SUBB_I_HI, DecodeIdx: 1
/* 224 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 232
/* 228 */     MCD::OPC_Decode, 137, 3, 1, // Opcode: SUBB_F_I_LO, DecodeIdx: 1
/* 232 */     MCD::OPC_FilterValueOrFail, 3, 
/* 234 */     MCD::OPC_Decode, 136, 3, 1, // Opcode: SUBB_F_I_HI, DecodeIdx: 1
/* 238 */     MCD::OPC_FilterValue, 4, 33, 0, // Skip to: 275
/* 242 */     MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 245 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 253
/* 249 */     MCD::OPC_Decode, 207, 2, 1, // Opcode: AND_I_LO, DecodeIdx: 1
/* 253 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 261
/* 257 */     MCD::OPC_Decode, 206, 2, 1, // Opcode: AND_I_HI, DecodeIdx: 1
/* 261 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 269
/* 265 */     MCD::OPC_Decode, 204, 2, 1, // Opcode: AND_F_I_LO, DecodeIdx: 1
/* 269 */     MCD::OPC_FilterValueOrFail, 3, 
/* 271 */     MCD::OPC_Decode, 203, 2, 1, // Opcode: AND_F_I_HI, DecodeIdx: 1
/* 275 */     MCD::OPC_FilterValue, 5, 33, 0, // Skip to: 312
/* 279 */     MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 282 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 290
/* 286 */     MCD::OPC_Decode, 239, 2, 1, // Opcode: OR_I_LO, DecodeIdx: 1
/* 290 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 298
/* 294 */     MCD::OPC_Decode, 238, 2, 1, // Opcode: OR_I_HI, DecodeIdx: 1
/* 298 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 306
/* 302 */     MCD::OPC_Decode, 236, 2, 1, // Opcode: OR_F_I_LO, DecodeIdx: 1
/* 306 */     MCD::OPC_FilterValueOrFail, 3, 
/* 308 */     MCD::OPC_Decode, 235, 2, 1, // Opcode: OR_F_I_HI, DecodeIdx: 1
/* 312 */     MCD::OPC_FilterValue, 6, 33, 0, // Skip to: 349
/* 316 */     MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 319 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 327
/* 323 */     MCD::OPC_Decode, 155, 3, 1, // Opcode: XOR_I_LO, DecodeIdx: 1
/* 327 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 335
/* 331 */     MCD::OPC_Decode, 154, 3, 1, // Opcode: XOR_I_HI, DecodeIdx: 1
/* 335 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 343
/* 339 */     MCD::OPC_Decode, 152, 3, 1, // Opcode: XOR_F_I_LO, DecodeIdx: 1
/* 343 */     MCD::OPC_FilterValueOrFail, 3, 
/* 345 */     MCD::OPC_Decode, 151, 3, 1, // Opcode: XOR_F_I_HI, DecodeIdx: 1
/* 349 */     MCD::OPC_FilterValue, 7, 33, 0, // Skip to: 386
/* 353 */     MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 356 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 364
/* 360 */     MCD::OPC_Decode, 254, 2, 2, // Opcode: SL_I, DecodeIdx: 2
/* 364 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 372
/* 368 */     MCD::OPC_Decode, 244, 2, 2, // Opcode: SA_I, DecodeIdx: 2
/* 372 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 380
/* 376 */     MCD::OPC_Decode, 253, 2, 2, // Opcode: SL_F_I, DecodeIdx: 2
/* 380 */     MCD::OPC_FilterValueOrFail, 3, 
/* 382 */     MCD::OPC_Decode, 243, 2, 2, // Opcode: SA_F_I, DecodeIdx: 2
/* 386 */     MCD::OPC_FilterValue, 8, 17, 0, // Skip to: 407
/* 390 */     MCD::OPC_CheckField, 0, 28, 252, 255, 219, 8, 4, 0, // Skip to: 403
/* 399 */     MCD::OPC_Decode, 242, 2, 0, // Opcode: RET, DecodeIdx: 0
/* 403 */     MCD::OPC_Decode, 224, 2, 3, // Opcode: LDW_RI, DecodeIdx: 3
/* 407 */     MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 415
/* 411 */     MCD::OPC_Decode, 148, 3, 3, // Opcode: SW_RI, DecodeIdx: 3
/* 415 */     MCD::OPC_FilterValue, 10, 49, 0, // Skip to: 468
/* 419 */     MCD::OPC_ExtractField, 0, 3,  // Inst{2-0} ...
/* 422 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 430
/* 426 */     MCD::OPC_Decode, 221, 2, 4, // Opcode: LDHs_RR, DecodeIdx: 4
/* 430 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 438
/* 434 */     MCD::OPC_Decode, 223, 2, 4, // Opcode: LDHz_RR, DecodeIdx: 4
/* 438 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 446
/* 442 */     MCD::OPC_Decode, 225, 2, 4, // Opcode: LDW_RR, DecodeIdx: 4
/* 446 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 454
/* 450 */     MCD::OPC_Decode, 226, 2, 4, // Opcode: LDWz_RR, DecodeIdx: 4
/* 454 */     MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 462
/* 458 */     MCD::OPC_Decode, 217, 2, 4, // Opcode: LDBs_RR, DecodeIdx: 4
/* 462 */     MCD::OPC_FilterValueOrFail, 5, 
/* 464 */     MCD::OPC_Decode, 219, 2, 4, // Opcode: LDBz_RR, DecodeIdx: 4
/* 468 */     MCD::OPC_FilterValue, 11, 25, 0, // Skip to: 497
/* 472 */     MCD::OPC_ExtractField, 0, 3,  // Inst{2-0} ...
/* 475 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 483
/* 479 */     MCD::OPC_Decode, 135, 3, 4, // Opcode: STH_RR, DecodeIdx: 4
/* 483 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 491
/* 487 */     MCD::OPC_Decode, 149, 3, 4, // Opcode: SW_RR, DecodeIdx: 4
/* 491 */     MCD::OPC_FilterValueOrFail, 4, 
/* 493 */     MCD::OPC_Decode, 133, 3, 4, // Opcode: STB_RR, DecodeIdx: 4
/* 497 */     MCD::OPC_FilterValue, 12, 0, 1, // Skip to: 757
/* 501 */     MCD::OPC_ExtractField, 3, 8,  // Inst{10-3} ...
/* 504 */     MCD::OPC_FilterValue, 0, 17, 0, // Skip to: 525
/* 508 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 511 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 519
/* 515 */     MCD::OPC_Decode, 202, 2, 5, // Opcode: ADD_R, DecodeIdx: 5
/* 519 */     MCD::OPC_FilterValueOrFail, 1, 
/* 521 */     MCD::OPC_Decode, 199, 2, 5, // Opcode: ADD_F_R, DecodeIdx: 5
/* 525 */     MCD::OPC_FilterValue, 32, 17, 0, // Skip to: 546
/* 529 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 532 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 540
/* 536 */     MCD::OPC_Decode, 196, 2, 5, // Opcode: ADDC_R, DecodeIdx: 5
/* 540 */     MCD::OPC_FilterValueOrFail, 1, 
/* 542 */     MCD::OPC_Decode, 193, 2, 5, // Opcode: ADDC_F_R, DecodeIdx: 5
/* 546 */     MCD::OPC_FilterValue, 64, 17, 0, // Skip to: 567
/* 550 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 553 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 561
/* 557 */     MCD::OPC_Decode, 147, 3, 5, // Opcode: SUB_R, DecodeIdx: 5
/* 561 */     MCD::OPC_FilterValueOrFail, 1, 
/* 563 */     MCD::OPC_Decode, 144, 3, 5, // Opcode: SUB_F_R, DecodeIdx: 5
/* 567 */     MCD::OPC_FilterValue, 96, 17, 0, // Skip to: 588
/* 571 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 574 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 582
/* 578 */     MCD::OPC_Decode, 141, 3, 5, // Opcode: SUBB_R, DecodeIdx: 5
/* 582 */     MCD::OPC_FilterValueOrFail, 1, 
/* 584 */     MCD::OPC_Decode, 138, 3, 5, // Opcode: SUBB_F_R, DecodeIdx: 5
/* 588 */     MCD::OPC_FilterValue, 128, 1, 17, 0, // Skip to: 610
/* 593 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 596 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 604
/* 600 */     MCD::OPC_Decode, 208, 2, 5, // Opcode: AND_R, DecodeIdx: 5
/* 604 */     MCD::OPC_FilterValueOrFail, 1, 
/* 606 */     MCD::OPC_Decode, 205, 2, 5, // Opcode: AND_F_R, DecodeIdx: 5
/* 610 */     MCD::OPC_FilterValue, 160, 1, 65, 0, // Skip to: 680
/* 615 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 618 */     MCD::OPC_FilterValue, 0, 52, 0, // Skip to: 674
/* 622 */     MCD::OPC_CheckField, 18, 10, 64, 16, 0, // Skip to: 644
/* 628 */     MCD::OPC_CheckField, 16, 1, 0, 10, 0, // Skip to: 644
/* 634 */     MCD::OPC_CheckField, 0, 3, 0, 4, 0, // Skip to: 644
/* 640 */     MCD::OPC_Decode, 214, 2, 6, // Opcode: JR, DecodeIdx: 6
/* 644 */     MCD::OPC_CheckField, 23, 5, 2, 10, 0, // Skip to: 660
/* 650 */     MCD::OPC_CheckField, 11, 5, 0, 4, 0, // Skip to: 660
/* 656 */     MCD::OPC_Decode, 210, 2, 7, // Opcode: BRIND_CC, DecodeIdx: 7
/* 660 */     MCD::OPC_CheckField, 23, 5, 2, 4, 0, // Skip to: 670
/* 666 */     MCD::OPC_Decode, 211, 2, 8, // Opcode: BRIND_CCA, DecodeIdx: 8
/* 670 */     MCD::OPC_Decode, 240, 2, 5, // Opcode: OR_R, DecodeIdx: 5
/* 674 */     MCD::OPC_FilterValueOrFail, 1, 
/* 676 */     MCD::OPC_Decode, 237, 2, 5, // Opcode: OR_F_R, DecodeIdx: 5
/* 680 */     MCD::OPC_FilterValue, 192, 1, 17, 0, // Skip to: 702
/* 685 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 688 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 696
/* 692 */     MCD::OPC_Decode, 156, 3, 5, // Opcode: XOR_R, DecodeIdx: 5
/* 696 */     MCD::OPC_FilterValueOrFail, 1, 
/* 698 */     MCD::OPC_Decode, 153, 3, 5, // Opcode: XOR_F_R, DecodeIdx: 5
/* 702 */     MCD::OPC_FilterValue, 224, 1, 8, 0, // Skip to: 715
/* 707 */     MCD::OPC_CheckFieldOrFail, 17, 1, 0, 
/* 711 */     MCD::OPC_Decode, 246, 2, 9, // Opcode: SELECT, DecodeIdx: 9
/* 715 */     MCD::OPC_FilterValue, 240, 1, 17, 0, // Skip to: 737
/* 720 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 723 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 731
/* 727 */     MCD::OPC_Decode, 251, 2, 5, // Opcode: SHL_R, DecodeIdx: 5
/* 731 */     MCD::OPC_FilterValueOrFail, 1, 
/* 733 */     MCD::OPC_Decode, 250, 2, 5, // Opcode: SHL_F_R, DecodeIdx: 5
/* 737 */     MCD::OPC_FilterValueOrFail, 248, 1, 
/* 740 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 743 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 751
/* 747 */     MCD::OPC_Decode, 128, 3, 5, // Opcode: SRA_R, DecodeIdx: 5
/* 751 */     MCD::OPC_FilterValueOrFail, 1, 
/* 753 */     MCD::OPC_Decode, 255, 2, 5, // Opcode: SRA_F_R, DecodeIdx: 5
/* 757 */     MCD::OPC_FilterValue, 13, 25, 0, // Skip to: 786
/* 761 */     MCD::OPC_ExtractField, 0, 18,  // Inst{17-0} ...
/* 764 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 772
/* 768 */     MCD::OPC_Decode, 241, 2, 10, // Opcode: POPC, DecodeIdx: 10
/* 772 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 780
/* 776 */     MCD::OPC_Decode, 227, 2, 10, // Opcode: LEADZ, DecodeIdx: 10
/* 780 */     MCD::OPC_FilterValueOrFail, 3, 
/* 782 */     MCD::OPC_Decode, 150, 3, 10, // Opcode: TRAILZ, DecodeIdx: 10
/* 786 */     MCD::OPC_FilterValue, 14, 54, 0, // Skip to: 844
/* 790 */     MCD::OPC_ExtractField, 1, 1,  // Inst{1} ...
/* 793 */     MCD::OPC_FilterValue, 0, 20, 0, // Skip to: 817
/* 797 */     MCD::OPC_CheckField, 25, 3, 0, 10, 0, // Skip to: 813
/* 803 */     MCD::OPC_CheckField, 0, 1, 0, 4, 0, // Skip to: 813
/* 809 */     MCD::OPC_Decode, 213, 2, 11, // Opcode: BT, DecodeIdx: 11
/* 813 */     MCD::OPC_Decode, 209, 2, 12, // Opcode: BRCC, DecodeIdx: 12
/* 817 */     MCD::OPC_FilterValueOrFail, 1, 
/* 819 */     MCD::OPC_ExtractField, 23, 2,  // Inst{24-23} ...
/* 822 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 834
/* 826 */     MCD::OPC_CheckFieldOrFail, 2, 16, 0, 
/* 830 */     MCD::OPC_Decode, 245, 2, 13, // Opcode: SCC, DecodeIdx: 13
/* 834 */     MCD::OPC_FilterValueOrFail, 2, 
/* 836 */     MCD::OPC_CheckFieldOrFail, 16, 7, 0, 
/* 840 */     MCD::OPC_Decode, 212, 2, 14, // Opcode: BRR, DecodeIdx: 14
/* 844 */     MCD::OPC_FilterValueOrFail, 15, 
/* 846 */     MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 849 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 857
/* 853 */     MCD::OPC_Decode, 215, 2, 15, // Opcode: LDADDR, DecodeIdx: 15
/* 857 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 865
/* 861 */     MCD::OPC_Decode, 131, 3, 15, // Opcode: STADDR, DecodeIdx: 15
/* 865 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 873
/* 869 */     MCD::OPC_Decode, 252, 2, 15, // Opcode: SLI, DecodeIdx: 15
/* 873 */     MCD::OPC_FilterValueOrFail, 3, 
/* 875 */     MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 878 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 886
/* 882 */     MCD::OPC_Decode, 220, 2, 16, // Opcode: LDHs_RI, DecodeIdx: 16
/* 886 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 894
/* 890 */     MCD::OPC_Decode, 222, 2, 16, // Opcode: LDHz_RI, DecodeIdx: 16
/* 894 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 902
/* 898 */     MCD::OPC_Decode, 134, 3, 16, // Opcode: STH_RI, DecodeIdx: 16
/* 902 */     MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 910
/* 906 */     MCD::OPC_Decode, 216, 2, 16, // Opcode: LDBs_RI, DecodeIdx: 16
/* 910 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 918
/* 914 */     MCD::OPC_Decode, 218, 2, 16, // Opcode: LDBz_RI, DecodeIdx: 16
/* 918 */     MCD::OPC_FilterValueOrFail, 6, 
/* 920 */     MCD::OPC_Decode, 132, 3, 16, // Opcode: STB_RI, DecodeIdx: 16
/* 924 */     MCD::OPC_Fail,
  0
};

// Handling 17 cases.
template <typename InsnType>
static DecodeStatus decodeToMCInst(unsigned Idx, DecodeStatus S, InsnType insn, MCInst &MI, uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 23, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 2:
    tmp = fieldFromInstruction(insn, 23, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, decodeShiftImm(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 3:
    tmp = fieldFromInstruction(insn, 23, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 23);
    if (!Check(S, decodeRiMemoryValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 4:
    tmp = fieldFromInstruction(insn, 23, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 3, 8), 0, 8);
    insertBits(tmp, fieldFromInstruction(insn, 11, 5), 10, 5);
    insertBits(tmp, fieldFromInstruction(insn, 16, 2), 8, 2);
    insertBits(tmp, fieldFromInstruction(insn, 18, 5), 15, 5);
    if (!Check(S, decodeRrMemoryValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    tmp = fieldFromInstruction(insn, 23, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 3), 1, 3);
    insertBits(tmp, fieldFromInstruction(insn, 16, 1), 0, 1);
    if (!Check(S, decodePredicateOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 6:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 7:
    tmp = fieldFromInstruction(insn, 18, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 3), 1, 3);
    insertBits(tmp, fieldFromInstruction(insn, 16, 1), 0, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 8:
    tmp = fieldFromInstruction(insn, 18, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 3), 1, 3);
    insertBits(tmp, fieldFromInstruction(insn, 16, 1), 0, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 23, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 3), 1, 3);
    insertBits(tmp, fieldFromInstruction(insn, 16, 1), 0, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 10:
    tmp = fieldFromInstruction(insn, 23, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 2, 23) << 2;
    if (!Check(S, decodeBranch(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 2, 23) << 2;
    if (!Check(S, decodeBranch(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 1), 0, 1);
    insertBits(tmp, fieldFromInstruction(insn, 25, 3), 1, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 18, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 1), 0, 1);
    insertBits(tmp, fieldFromInstruction(insn, 25, 3), 1, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 2, 14) << 2;
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 1), 0, 1);
    insertBits(tmp, fieldFromInstruction(insn, 25, 3), 1, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 15:
    tmp = fieldFromInstruction(insn, 23, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 16), 0, 16);
    insertBits(tmp, fieldFromInstruction(insn, 18, 5), 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 16:
    tmp = fieldFromInstruction(insn, 23, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 12), 0, 12);
    insertBits(tmp, fieldFromInstruction(insn, 18, 5), 12, 5);
    if (!Check(S, decodeSplsValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  }
}

static unsigned decodeNumToSkip(const uint8_t *&Ptr) {
  unsigned NumToSkip = *Ptr++;
  NumToSkip |= (*Ptr++) << 8;
  return NumToSkip;
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    const uint8_t DecoderOp = *Ptr++;
    switch (DecoderOp) {
    default:
      errs() << Loc << ": Unexpected decode table opcode: "
             << (int)DecoderOp << '\n';
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr++;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue:
    case MCD::OPC_FilterValueOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_FilterValueOrFail;
      // Decode the field value.
      uint64_t Val = decodeULEB128AndIncUnsafe(Ptr);
      bool Failed = Val != CurFieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      // Note: Print NumToSkip even for OPC_FilterValueOrFail to simplify debug
      // prints.
      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_FilterValueOrFail" : "OPC_FilterValue";
        dbgs() << Loc << ": " << OpName << '(' << Val << ", " << NumToSkip
                << ") " << (Failed ? "FAIL:" : "PASS:")
                << " continuing at " << (Ptr - DecodeTable) << '\n';
      });

      // Perform the filter operation.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckField:
    case MCD::OPC_CheckFieldOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckFieldOrFail;
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      bool Failed = ExpectedValue != FieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckFieldOrFail" : "OPC_CheckField";
        dbgs() << Loc << ": " << OpName << '(' << Start << ", " << Len << ", "
                << ExpectedValue << ", " << NumToSkip << "): FieldValue = "
                << FieldValue << ", ExpectedValue = " << ExpectedValue << ": "
                << (Failed ? "FAIL\n" : "PASS\n");
      });

      // If the actual and expected values don't match, skip or fail.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_Decode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(DecodeIdx, S, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS\n" : "FAIL\n"));
      return S;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // namespace
