#include "nv_push_clc1b5.h"

#include <stdio.h>





const char *P_PARSE_NVB0B5_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVB0B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC1B5_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVB0B5_MTHD(idx);

            case NVC1B5_SET_SEMAPHORE_A:
        return "NVC1B5_SET_SEMAPHORE_A";
                                case NVC1B5_LAUNCH_DMA:
        return "NVC1B5_LAUNCH_DMA";
    case NVC1B5_OFFSET_IN_UPPER:
        return "NVC1B5_OFFSET_IN_UPPER";
        case NVC1B5_OFFSET_OUT_UPPER:
        return "NVC1B5_OFFSET_OUT_UPPER";
                                    case NVC1B5_SET_DST_BLOCK_SIZE:
        return "NVC1B5_SET_DST_BLOCK_SIZE";
                        case NVC1B5_SET_SRC_BLOCK_SIZE:
        return "NVC1B5_SET_SRC_BLOCK_SIZE";
                        case NVC1B5_SRC_ORIGIN_X:
        return "NVC1B5_SRC_ORIGIN_X";
    case NVC1B5_SRC_ORIGIN_Y:
        return "NVC1B5_SRC_ORIGIN_Y";
    case NVC1B5_DST_ORIGIN_X:
        return "NVC1B5_DST_ORIGIN_X";
    case NVC1B5_DST_ORIGIN_Y:
        return "NVC1B5_DST_ORIGIN_Y";
    
    }
}

void
P_DUMP_NVC1B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVB0B5_MTHD_DATA(fp, idx, data, prefix);
    break;

          
    case NVC1B5_SET_SEMAPHORE_A:

    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                              
    case NVC1B5_LAUNCH_DMA:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.DATA_TRANSFER_TYPE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC1B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PIPELINED:
            fprintf(fp, "PIPELINED\n");
            break;
        case NVC1B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NON_PIPELINED:
            fprintf(fp, "NON_PIPELINED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_ENABLE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_FLUSH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC1B5_LAUNCH_DMA_FLUSH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 2) - 1);
        fprintf(fp, "%s.SEMAPHORE_TYPE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE:
            fprintf(fp, "RELEASE_ONE_WORD_SEMAPHORE\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE:
            fprintf(fp, "RELEASE_FOUR_WORD_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC1B5_LAUNCH_DMA_INTERRUPT_TYPE_BLOCKING:
            fprintf(fp, "BLOCKING\n");
            break;
        case NVC1B5_LAUNCH_DMA_INTERRUPT_TYPE_NON_BLOCKING:
            fprintf(fp, "NON_BLOCKING\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVC1B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVC1B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.MULTI_LINE_ENABLE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_MULTI_LINE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC1B5_LAUNCH_DMA_MULTI_LINE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.REMAP_ENABLE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_REMAP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC1B5_LAUNCH_DMA_REMAP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.FORCE_RMWDISABLE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_FORCE_RMWDISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC1B5_LAUNCH_DMA_FORCE_RMWDISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_TYPE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_SRC_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NVC1B5_LAUNCH_DMA_SRC_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_TYPE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_DST_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NVC1B5_LAUNCH_DMA_DST_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 14) & ((1u << 4) - 1);
        fprintf(fp, "%s.SEMAPHORE_REDUCTION = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMIN:
            fprintf(fp, "IMIN\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMAX:
            fprintf(fp, "IMAX\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IXOR:
            fprintf(fp, "IXOR\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IAND:
            fprintf(fp, "IAND\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IOR:
            fprintf(fp, "IOR\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IADD:
            fprintf(fp, "IADD\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INC:
            fprintf(fp, "INC\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_DEC:
            fprintf(fp, "DEC\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FADD:
            fprintf(fp, "FADD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 18) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_REDUCTION_SIGN = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 19) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC1B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_BYPASS_L2 = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_SRC_BYPASS_L2_USE_PTE_SETTING:
            fprintf(fp, "USE_PTE_SETTING\n");
            break;
        case NVC1B5_LAUNCH_DMA_SRC_BYPASS_L2_FORCE_VOLATILE:
            fprintf(fp, "FORCE_VOLATILE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 21) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_BYPASS_L2 = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_DST_BYPASS_L2_USE_PTE_SETTING:
            fprintf(fp, "USE_PTE_SETTING\n");
            break;
        case NVC1B5_LAUNCH_DMA_DST_BYPASS_L2_FORCE_VOLATILE:
            fprintf(fp, "FORCE_VOLATILE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 22) & ((1u << 2) - 1);
        fprintf(fp, "%s.VPRMODE = ", prefix);
        switch (parsed) {
        case NVC1B5_LAUNCH_DMA_VPRMODE_VPR_NONE:
            fprintf(fp, "VPR_NONE\n");
            break;
        case NVC1B5_LAUNCH_DMA_VPRMODE_VPR_VID2VID:
            fprintf(fp, "VPR_VID2VID\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.RESERVED_START_OF_COPY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.RESERVED_ERR_CODE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC1B5_OFFSET_IN_UPPER:

    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
      
    case NVC1B5_OFFSET_OUT_UPPER:

    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                  
    case NVC1B5_SET_DST_BLOCK_SIZE:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVC1B5_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVC1B5_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVC1B5_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC1B5_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.GOB_HEIGHT = ", prefix);
        switch (parsed) {
        case NVC1B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8:
            fprintf(fp, "GOB_HEIGHT_FERMI_8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                      
    case NVC1B5_SET_SRC_BLOCK_SIZE:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVC1B5_SET_SRC_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVC1B5_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVC1B5_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC1B5_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.GOB_HEIGHT = ", prefix);
        switch (parsed) {
        case NVC1B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8:
            fprintf(fp, "GOB_HEIGHT_FERMI_8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                      
    case NVC1B5_SRC_ORIGIN_X:

    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC1B5_SRC_ORIGIN_Y:

    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC1B5_DST_ORIGIN_X:

    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC1B5_DST_ORIGIN_Y:

    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
        }
}
