﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/s3-crt/S3Crt_EXPORTS.h>

namespace Aws {
namespace S3Crt {
namespace Model {
enum class JSONType { NOT_SET, DOCUMENT, LINES };

namespace JSONTypeMapper {
AWS_S3CRT_API JSONType GetJSONTypeForName(const Aws::String& name);

AWS_S3CRT_API Aws::String GetNameForJSONType(JSONType value);
}  // namespace JSONTypeMapper
}  // namespace Model
}  // namespace S3Crt
}  // namespace Aws
