/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.art.ArtCompression;
import ghidra.file.formats.android.art.ArtStorageMode;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ArtBlock
implements StructConverter,
ArtCompression {
    private ArtStorageMode storage_mode_ = ArtStorageMode.kDefaultStorageMode;
    private int data_offset_;
    private int data_size_;
    private int image_offset_;
    private int image_size_;

    public ArtBlock(BinaryReader reader) throws IOException {
        this.storage_mode_ = ArtStorageMode.get(reader.readNextInt());
        this.data_offset_ = reader.readNextInt();
        this.data_size_ = reader.readNextInt();
        this.image_offset_ = reader.readNextInt();
        this.image_size_ = reader.readNextInt();
    }

    @Override
    public ArtStorageMode getStorageMode() {
        return this.storage_mode_;
    }

    @Override
    public long getCompressedOffset() {
        return Integer.toUnsignedLong(this.data_offset_);
    }

    @Override
    public int getCompressedSize() {
        return this.data_size_;
    }

    @Override
    public long getDecompressedOffset() {
        return Integer.toUnsignedLong(this.image_offset_);
    }

    @Override
    public int getDecompressedSize() {
        return this.image_size_;
    }

    public int getDataOffset() {
        return this.data_offset_;
    }

    public int getDataSize() {
        return this.data_size_;
    }

    public int getImageOffset() {
        return this.image_offset_;
    }

    public int getImageSize() {
        return this.image_size_;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(ArtBlock.class.getSimpleName(), 0);
        structure.setCategoryPath(new CategoryPath("/art"));
        structure.add(DWORD, "storage_mode_", this.storage_mode_.name());
        structure.add(DWORD, "data_offset_", null);
        structure.add(DWORD, "data_size_", null);
        structure.add(DWORD, "image_offset_", null);
        structure.add(DWORD, "image_size_", null);
        return structure;
    }
}

