/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import docking.DialogComponentProvider;
import ghidra.util.layout.VerticalLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FilterDialog
extends DialogComponentProvider {
    private static final String VERTEX_TITLE = "Vertex Filters";
    private static final String EDGE_TITLE = "Edge Filters";
    private final List<? extends AbstractButton> vertexButtons;
    List<? extends AbstractButton> edgeButtons;

    public FilterDialog(List<? extends AbstractButton> vertexButtons, List<? extends AbstractButton> edgeButtons) {
        super("Filters", false);
        this.vertexButtons = vertexButtons;
        this.edgeButtons = edgeButtons;
        super.addWorkPanel(this.createPanel());
        this.setRememberSize(false);
        this.addDismissButton();
        this.setDefaultButton(this.dismissButton);
    }

    JComponent createPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(10));
        if (!this.vertexButtons.isEmpty()) {
            JPanel vertexPanel = new JPanel((LayoutManager)new VerticalLayout(5));
            vertexPanel.setBorder(BorderFactory.createTitledBorder(VERTEX_TITLE));
            this.vertexButtons.forEach(vertexPanel::add);
            vertexPanel.getAccessibleContext().setAccessibleName("Vertex");
            panel.add(vertexPanel);
        }
        if (!this.edgeButtons.isEmpty()) {
            JPanel edgePanel = new JPanel((LayoutManager)new VerticalLayout(5));
            edgePanel.setBorder(BorderFactory.createTitledBorder(EDGE_TITLE));
            this.edgeButtons.forEach(edgePanel::add);
            edgePanel.getAccessibleContext().setAccessibleName("Edge");
            panel.add(edgePanel);
        }
        if (this.vertexButtons.isEmpty() && this.edgeButtons.isEmpty()) {
            JLabel label = new JLabel("No Filters available for this graph!");
            label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            label.getAccessibleContext().setAccessibleName("No Filter");
            panel.add(label);
        }
        panel.getAccessibleContext().setAccessibleName("Filter");
        return panel;
    }
}

