# frozen_string_literal: true

class FinalizeMigrateRemediationsForVulnerabilityFindings < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!

  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  milestone '18.3'

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: 'MigrateRemediationsForVulnerabilityFindings',
      table_name: :vulnerability_occurrences,
      column_name: :id,
      job_arguments: [],
      finalize: true
    )
  end

  def down
    # no-op
  end
end
