/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.impl.VcsChangesMerger;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rJ\u001a\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0011H\u0002J8\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J*\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J4\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*H\u0007J \u0010+\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\tH\u0007J\u001a\u0010.\u001a\u00020#2\b\u0010/\u001a\u0004\u0018\u00010\u001f2\u0006\u00100\u001a\u00020\u0005H\u0007J \u00101\u001a\u00020\t2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020#H\u0007\u00a8\u00067"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryUtil;", "", "<init>", "()V", "createVcsVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "revision", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "affectsFile", "", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "file", "Lcom/intellij/openapi/vcs/FilePath;", "isDeleted", "affectsDirectory", "directory", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "createChangeToParents", "commitRow", "", "parentRows", "", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "diffHandler", "Lcom/intellij/vcs/log/VcsLogDiffHandler;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "createContentRevision", "commitHash", "Lcom/intellij/vcs/log/Hash;", "commitIndex", "Lcom/intellij/vcs/log/VcsLogDataPack;", "createLogPathsFilter", "Lcom/intellij/vcs/log/VcsLogFilter;", "project", "Lcom/intellij/openapi/project/Project;", "logProviders", "", "Lcom/intellij/vcs/log/VcsLogProvider;", "paths", "", "getCorrectedPath", "path", "isRevisionHistory", "createHashFilter", "hash", "root", "matches", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "pathsFilter", "hashFilter", "MyVcsChangesMerger", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryUtil.kt\ncom/intellij/vcs/log/history/FileHistoryUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1563#2:165\n1634#2,3:166\n1563#2:169\n1634#2,3:170\n1617#2,9:173\n1869#2:182\n1870#2:184\n1626#2:185\n1#3:183\n*S KotlinDebug\n*F\n+ 1 FileHistoryUtil.kt\ncom/intellij/vcs/log/history/FileHistoryUtil\n*L\n74#1:165\n74#1:166,3\n75#1:169\n75#1:170,3\n77#1:173,9\n77#1:182\n77#1:184\n77#1:185\n77#1:183\n*E\n"})
public final class FileHistoryUtil {
    @NotNull
    public static final FileHistoryUtil INSTANCE = new FileHistoryUtil();

    private FileHistoryUtil() {
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile createVcsVirtualFile(@Nullable VcsFileRevision revision) {
        if (!VcsHistoryUtil.isEmpty((VcsFileRevision)revision) && revision instanceof VcsFileRevisionEx) {
            FilePath filePath = ((VcsFileRevisionEx)revision).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getPath(...)");
            FilePath path = filePath;
            return path.isDirectory() ? (VirtualFile)new VcsVirtualFolder(path, null) : (VirtualFile)new VcsVirtualFile(path, revision);
        }
        return null;
    }

    public final boolean affectsFile(@NotNull Change change, @NotNull FilePath file, boolean isDeleted) {
        ContentRevision revision;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ContentRevision contentRevision = revision = isDeleted ? change.getBeforeRevision() : change.getAfterRevision();
        if (revision == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)file, (Object)revision.getFile());
    }

    public final boolean affectsDirectory(@NotNull Change change, @NotNull FilePath directory) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return this.affectsDirectory(directory, change.getAfterRevision()) || this.affectsDirectory(directory, change.getBeforeRevision());
    }

    private final boolean affectsDirectory(FilePath directory, ContentRevision revision) {
        if (revision == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((File)directory.getIOFile(), (File)revision.getFile().getIOFile(), (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Change createChangeToParents(int commitRow, @NotNull List<Integer> parentRows, @NotNull VisiblePack visiblePack, @NotNull VcsLogDiffHandler diffHandler, @NotNull VcsLogData logData) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(parentRows, (String)"parentRows");
        Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"visiblePack");
        Intrinsics.checkNotNullParameter((Object)diffHandler, (String)"diffHandler");
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Object object = visiblePack.getVisibleGraph().getRowInfo(commitRow).getCommit();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCommit(...)");
        int commitIndex = ((Number)object).intValue();
        FilePath path = FileHistoryPaths.filePath(visiblePack, commitIndex);
        if (path == null) {
            return null;
        }
        CommitId commitId = logData.getCommitId(commitIndex);
        Intrinsics.checkNotNull((Object)commitId);
        Hash hash = commitId.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
        Hash commitHash = hash;
        ContentRevision afterRevision = INSTANCE.createContentRevision(commitHash, commitIndex, visiblePack, diffHandler);
        if (parentRows.isEmpty()) {
            if (afterRevision == null) {
                return null;
            }
            return new Change(null, afterRevision);
        }
        Iterable $this$map$iv = parentRows;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Integer)visiblePack.getVisibleGraph().getRowInfo((int)it).getCommit());
        }
        List parentCommits = (List)destination$iv$iv;
        Iterable $this$map$iv2 = parentCommits;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Integer bl = (Integer)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            CommitId commitId2 = logData.getCommitId(it.intValue());
            Intrinsics.checkNotNull((Object)commitId2);
            collection.add(commitId2.getHash());
        }
        List parentHashes = (List)destination$iv$iv2;
        Iterable $this$mapNotNull$iv = CollectionsKt.zip((Iterable)parentCommits, (Iterable)parentHashes);
        boolean $i$f$mapNotNull = false;
        destination$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Change it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl3 = false;
            Object object2 = pair.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component1(...)");
            Integer index = (Integer)object2;
            Object object3 = pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"component2(...)");
            Hash hash2 = (Hash)object3;
            ContentRevision beforeRevision = INSTANCE.createContentRevision(hash2, index, visiblePack, diffHandler);
            if ((afterRevision == null && beforeRevision == null ? null : new Change(beforeRevision, afterRevision)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List parentChanges = (List)destination$iv$iv3;
        if (parentChanges.size() <= 1) {
            return (Change)CollectionsKt.firstOrNull((List)parentChanges);
        }
        return new MyVcsChangesMerger(commitHash, parentHashes, diffHandler).mergedChange(path, parentChanges);
    }

    private final ContentRevision createContentRevision(Hash commitHash, int commitIndex, VcsLogDataPack visiblePack, VcsLogDiffHandler diffHandler) {
        boolean isDeleted = FileHistoryPaths.isDeletedInCommit(visiblePack, commitIndex);
        if (isDeleted) {
            return null;
        }
        FilePath path = FileHistoryPaths.filePath(visiblePack, commitIndex);
        if (path == null) {
            return null;
        }
        return diffHandler.createContentRevision(path, commitHash);
    }

    @ApiStatus.Internal
    @Nullable
    public final VcsLogFilter createLogPathsFilter(@NotNull Project project, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull Collection<? extends FilePath> paths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Set forRootFilter = new LinkedHashSet();
        List forPathsFilter = new ArrayList();
        for (FilePath filePath : paths) {
            FilePath correctedPath;
            VirtualFile root = VcsLogUtil.getActualRoot(project, filePath);
            if (root == null) {
                return null;
            }
            if (!logProviders.keySet().contains(root) || !((Boolean)VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY.getOrDefault(logProviders.get(root))).booleanValue()) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath), (String)"getLastCommitPath(...)");
            if (!correctedPath.isDirectory()) {
                return null;
            }
            boolean bl = Intrinsics.areEqual((Object)filePath.getVirtualFile(), (Object)root) ? forRootFilter.add(root) : forPathsFilter.add(correctedPath);
            if (!(!((Collection)forPathsFilter).isEmpty()) || !(!((Collection)forRootFilter).isEmpty())) continue;
            return null;
        }
        if (!((Collection)forPathsFilter).isEmpty()) {
            return (VcsLogFilter)VcsLogFilterObject.fromPaths(forPathsFilter);
        }
        return (VcsLogFilter)VcsLogFilterObject.fromRoots(forRootFilter);
    }

    @ApiStatus.Internal
    @NotNull
    public final FilePath getCorrectedPath(@NotNull Project project, @NotNull FilePath path, boolean isRevisionHistory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (isRevisionHistory) {
            return path;
        }
        FilePath filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)path);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getLastCommitPath(...)");
        return filePath;
    }

    @ApiStatus.Internal
    @NotNull
    public final VcsLogFilter createHashFilter(@Nullable Hash hash, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (hash == null) {
            return (VcsLogFilter)VcsLogFilterObject.fromBranch("HEAD");
        }
        return (VcsLogFilter)VcsLogFilterObject.fromCommit(new CommitId(hash, root));
    }

    @ApiStatus.Internal
    public final boolean matches(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogFilter pathsFilter, @NotNull VcsLogFilter hashFilter) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)pathsFilter, (String)"pathsFilter");
        Intrinsics.checkNotNullParameter((Object)hashFilter, (String)"hashFilter");
        VcsLogFilterCollection.FilterKey[] filterKeyArray = new VcsLogFilterCollection.FilterKey[2];
        Intrinsics.checkNotNullExpressionValue((Object)hashFilter.getKey(), (String)"getKey(...)");
        Intrinsics.checkNotNullExpressionValue((Object)pathsFilter.getKey(), (String)"getKey(...)");
        if (!VcsLogFiltersKt.matches(filters, filterKeyArray)) {
            return false;
        }
        return Intrinsics.areEqual((Object)filters.get(pathsFilter.getKey()), (Object)pathsFilter) && Intrinsics.areEqual((Object)filters.get(hashFilter.getKey()), (Object)hashFilter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryUtil$MyVcsChangesMerger;", "Lcom/intellij/vcs/log/impl/VcsChangesMerger;", "commit", "Lcom/intellij/vcs/log/Hash;", "parentCommits", "", "diffHandler", "Lcom/intellij/vcs/log/VcsLogDiffHandler;", "<init>", "(Lcom/intellij/vcs/log/Hash;Ljava/util/List;Lcom/intellij/vcs/log/VcsLogDiffHandler;)V", "firstParent", "createChange", "Lcom/intellij/openapi/vcs/changes/Change;", "type", "Lcom/intellij/openapi/vcs/changes/Change$Type;", "beforePath", "Lcom/intellij/openapi/vcs/FilePath;", "afterPath", "intellij.platform.vcs.log.impl"})
    private static final class MyVcsChangesMerger
    extends VcsChangesMerger {
        @NotNull
        private final Hash commit;
        @NotNull
        private final VcsLogDiffHandler diffHandler;
        @NotNull
        private final Hash firstParent;

        public MyVcsChangesMerger(@NotNull Hash commit, @NotNull List<? extends Hash> parentCommits, @NotNull VcsLogDiffHandler diffHandler) {
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter(parentCommits, (String)"parentCommits");
            Intrinsics.checkNotNullParameter((Object)diffHandler, (String)"diffHandler");
            this.commit = commit;
            this.diffHandler = diffHandler;
            this.firstParent = (Hash)CollectionsKt.first(parentCommits);
        }

        @Override
        @NotNull
        protected Change createChange(@NotNull Change.Type type, @Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            ContentRevision beforeRevision = beforePath == null ? null : this.diffHandler.createContentRevision(beforePath, this.firstParent);
            ContentRevision afterRevision = afterPath == null ? null : this.diffHandler.createContentRevision(afterPath, this.commit);
            return new Change(beforeRevision, afterRevision);
        }
    }
}

