/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.editor.actions.GroovyTypedHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public final class GroovyBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean myToDeleteGt;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            GroovyBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GroovyBackspaceHandler.$$$reportNull$$$0(1);
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        this.myToDeleteGt = c == '<' && file instanceof GroovyFile && GroovyTypedHandler.isAfterClassLikeIdentifier(offset, editor);
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            GroovyBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GroovyBackspaceHandler.$$$reportNull$$$0(3);
        }
        int offset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (editor.getDocument().getTextLength() <= offset) {
            return false;
        }
        char c1 = chars.charAt(offset);
        if (c == '<' && this.myToDeleteGt) {
            if (c1 != '>') {
                return true;
            }
            TypedHandlerUtil.handleGenericLTDeletion((Editor)editor, (int)offset, (IElementType)GroovyTokenTypes.mLT, (IElementType)GroovyTokenTypes.mGT, (TokenSet)TokenSets.INVALID_INSIDE_REFERENCE);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/editor/actions/GroovyBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

