/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.util.TextRange;
import com.intellij.terminal.frontend.view.TerminalTextSelection;
import com.intellij.terminal.frontend.view.TerminalTextSelectionChangeEvent;
import com.intellij.terminal.frontend.view.TerminalTextSelectionListener;
import com.intellij.terminal.frontend.view.TerminalTextSelectionModel;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelsSet;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001a\u001b\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalTextSelectionModelImpl;", "Lcom/intellij/terminal/frontend/view/TerminalTextSelectionModel;", "outputModels", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModelsSet;", "regularEditor", "Lcom/intellij/openapi/editor/Editor;", "alternateBufferEditor", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lorg/jetbrains/plugins/terminal/view/TerminalOutputModelsSet;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/Editor;Lkotlinx/coroutines/CoroutineScope;)V", "selection", "Lcom/intellij/terminal/frontend/view/TerminalTextSelection;", "getSelection", "()Lcom/intellij/terminal/frontend/view/TerminalTextSelection;", "listeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/intellij/terminal/frontend/view/TerminalTextSelectionListener;", "updateSelection", "", "newSelection", "getCurrentSelection", "addListener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "MyEditorSelectionListener", "TerminalTextSelectionChangeEventImpl", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalTextSelectionModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTextSelectionModelImpl.kt\ncom/intellij/terminal/frontend/view/impl/TerminalTextSelectionModelImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,110:1\n13#2:111\n*S KotlinDebug\n*F\n+ 1 TerminalTextSelectionModelImpl.kt\ncom/intellij/terminal/frontend/view/impl/TerminalTextSelectionModelImpl\n*L\n108#1:111\n*E\n"})
public final class TerminalTextSelectionModelImpl
implements TerminalTextSelectionModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalOutputModelsSet outputModels;
    @NotNull
    private final Editor regularEditor;
    @NotNull
    private final Editor alternateBufferEditor;
    @NotNull
    private final DisposableWrapperList<TerminalTextSelectionListener> listeners;
    @NotNull
    private static final Logger LOG;

    public TerminalTextSelectionModelImpl(@NotNull TerminalOutputModelsSet outputModels, @NotNull Editor regularEditor, @NotNull Editor alternateBufferEditor, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)outputModels, (String)"outputModels");
        Intrinsics.checkNotNullParameter((Object)regularEditor, (String)"regularEditor");
        Intrinsics.checkNotNullParameter((Object)alternateBufferEditor, (String)"alternateBufferEditor");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.outputModels = outputModels;
        this.regularEditor = regularEditor;
        this.alternateBufferEditor = alternateBufferEditor;
        this.listeners = new DisposableWrapperList();
        MyEditorSelectionListener listener2 = new MyEditorSelectionListener();
        this.regularEditor.getSelectionModel().addSelectionListener((SelectionListener)listener2, CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope));
        this.alternateBufferEditor.getSelectionModel().addSelectionListener((SelectionListener)listener2, CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope));
    }

    @Override
    @Nullable
    public TerminalTextSelection getSelection() {
        return this.getCurrentSelection();
    }

    @Override
    public void updateSelection(@Nullable TerminalTextSelection newSelection) {
        block6: {
            SelectionModel editorSelectionModel;
            block3: {
                TerminalOutputModel outputModel;
                block5: {
                    block4: {
                        outputModel = (TerminalOutputModel)this.outputModels.getActive().getValue();
                        Editor curEditor = Intrinsics.areEqual((Object)outputModel, (Object)this.outputModels.getRegular()) ? this.regularEditor : this.alternateBufferEditor;
                        SelectionModel selectionModel = curEditor.getSelectionModel();
                        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
                        editorSelectionModel = selectionModel;
                        if (newSelection == null) break block3;
                        TerminalOffset terminalOffset = outputModel.getStartOffset();
                        TerminalOffset terminalOffset2 = outputModel.getEndOffset();
                        TerminalOffset terminalOffset3 = newSelection.getStartOffset();
                        boolean bl = 0 <= ((Comparable)terminalOffset3).compareTo(terminalOffset) ? ((Comparable)terminalOffset3).compareTo(terminalOffset2) <= 0 : false;
                        if (!bl) break block4;
                        terminalOffset = outputModel.getStartOffset();
                        terminalOffset2 = outputModel.getEndOffset();
                        terminalOffset3 = newSelection.getEndOffset();
                        if (0 <= ((Comparable)terminalOffset3).compareTo(terminalOffset) ? ((Comparable)terminalOffset3).compareTo(terminalOffset2) <= 0 : false) break block5;
                    }
                    throw new IllegalStateException(("Selection range is out of model bounds: " + newSelection + ", model: " + outputModel).toString());
                }
                long start2 = newSelection.getStartOffset().minus(outputModel.getStartOffset());
                long end = newSelection.getEndOffset().minus(outputModel.getStartOffset());
                editorSelectionModel.setSelection((int)start2, (int)end);
                break block6;
            }
            editorSelectionModel.removeSelection();
        }
    }

    private final TerminalTextSelection getCurrentSelection() {
        TerminalOutputModel outputModel = (TerminalOutputModel)this.outputModels.getActive().getValue();
        Editor curEditor = Intrinsics.areEqual((Object)outputModel, (Object)this.outputModels.getRegular()) ? this.regularEditor : this.alternateBufferEditor;
        SelectionModel selectionModel = curEditor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel editorSelectionModel = selectionModel;
        return editorSelectionModel.hasSelection() ? TerminalTextSelection.Companion.of(outputModel.getStartOffset().plus(editorSelectionModel.getSelectionStart()), outputModel.getStartOffset().plus(editorSelectionModel.getSelectionEnd())) : null;
    }

    @Override
    public void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalTextSelectionListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add((Object)listener2, parentDisposable);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalTextSelectionModelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalTextSelectionModelImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalTextSelectionModelImpl$MyEditorSelectionListener;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "<init>", "(Lcom/intellij/terminal/frontend/view/impl/TerminalTextSelectionModelImpl;)V", "selectionChanged", "", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "toTerminalTextSelection", "Lcom/intellij/terminal/frontend/view/TerminalTextSelection;", "Lcom/intellij/openapi/util/TextRange;", "model", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "intellij.terminal.frontend"})
    private final class MyEditorSelectionListener
    implements SelectionListener {
        public void selectionChanged(@NotNull SelectionEvent e) {
            TerminalOutputModel terminalOutputModel;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = e.getEditor();
            if (Intrinsics.areEqual((Object)editor, (Object)TerminalTextSelectionModelImpl.this.regularEditor)) {
                terminalOutputModel = TerminalTextSelectionModelImpl.this.outputModels.getRegular();
            } else if (Intrinsics.areEqual((Object)editor, (Object)TerminalTextSelectionModelImpl.this.alternateBufferEditor)) {
                terminalOutputModel = TerminalTextSelectionModelImpl.this.outputModels.getAlternative();
            } else {
                throw new IllegalStateException(("Unexpected editor: " + e.getEditor()).toString());
            }
            TerminalOutputModel outputModel = terminalOutputModel;
            TextRange textRange = e.getOldRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getOldRange(...)");
            TerminalTextSelection oldSelection = this.toTerminalTextSelection(textRange, outputModel);
            TextRange textRange2 = e.getNewRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getNewRange(...)");
            TerminalTextSelection newSelection = this.toTerminalTextSelection(textRange2, outputModel);
            if (!Intrinsics.areEqual((Object)newSelection, (Object)oldSelection)) {
                TerminalTextSelectionChangeEventImpl event = new TerminalTextSelectionChangeEventImpl(outputModel, oldSelection, newSelection);
                TerminalUtilKt.fireListenersAndLogAllExceptions((List)TerminalTextSelectionModelImpl.this.listeners, LOG, "Exception during handling " + event, arg_0 -> MyEditorSelectionListener.selectionChanged$lambda$0(event, arg_0));
            }
        }

        private final TerminalTextSelection toTerminalTextSelection(TextRange $this$toTerminalTextSelection, TerminalOutputModel model) {
            return !$this$toTerminalTextSelection.isEmpty() ? TerminalTextSelection.Companion.of(model.getStartOffset().plus($this$toTerminalTextSelection.getStartOffset()), model.getStartOffset().plus($this$toTerminalTextSelection.getEndOffset())) : null;
        }

        private static final Unit selectionChanged$lambda$0(TerminalTextSelectionChangeEventImpl $event, TerminalTextSelectionListener it) {
            it.selectionChanged($event);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalTextSelectionModelImpl$TerminalTextSelectionChangeEventImpl;", "Lcom/intellij/terminal/frontend/view/TerminalTextSelectionChangeEvent;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "oldSelection", "Lcom/intellij/terminal/frontend/view/TerminalTextSelection;", "newSelection", "<init>", "(Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lcom/intellij/terminal/frontend/view/TerminalTextSelection;Lcom/intellij/terminal/frontend/view/TerminalTextSelection;)V", "getOutputModel", "()Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "getOldSelection", "()Lcom/intellij/terminal/frontend/view/TerminalTextSelection;", "getNewSelection", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.terminal.frontend"})
    private static final class TerminalTextSelectionChangeEventImpl
    implements TerminalTextSelectionChangeEvent {
        @NotNull
        private final TerminalOutputModel outputModel;
        @Nullable
        private final TerminalTextSelection oldSelection;
        @Nullable
        private final TerminalTextSelection newSelection;

        public TerminalTextSelectionChangeEventImpl(@NotNull TerminalOutputModel outputModel, @Nullable TerminalTextSelection oldSelection, @Nullable TerminalTextSelection newSelection) {
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            this.outputModel = outputModel;
            this.oldSelection = oldSelection;
            this.newSelection = newSelection;
        }

        @Override
        @NotNull
        public TerminalOutputModel getOutputModel() {
            return this.outputModel;
        }

        @Override
        @Nullable
        public TerminalTextSelection getOldSelection() {
            return this.oldSelection;
        }

        @Override
        @Nullable
        public TerminalTextSelection getNewSelection() {
            return this.newSelection;
        }

        @NotNull
        public final TerminalOutputModel component1() {
            return this.outputModel;
        }

        @Nullable
        public final TerminalTextSelection component2() {
            return this.oldSelection;
        }

        @Nullable
        public final TerminalTextSelection component3() {
            return this.newSelection;
        }

        @NotNull
        public final TerminalTextSelectionChangeEventImpl copy(@NotNull TerminalOutputModel outputModel, @Nullable TerminalTextSelection oldSelection, @Nullable TerminalTextSelection newSelection) {
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            return new TerminalTextSelectionChangeEventImpl(outputModel, oldSelection, newSelection);
        }

        public static /* synthetic */ TerminalTextSelectionChangeEventImpl copy$default(TerminalTextSelectionChangeEventImpl terminalTextSelectionChangeEventImpl, TerminalOutputModel terminalOutputModel, TerminalTextSelection terminalTextSelection, TerminalTextSelection terminalTextSelection2, int n, Object object) {
            if ((n & 1) != 0) {
                terminalOutputModel = terminalTextSelectionChangeEventImpl.outputModel;
            }
            if ((n & 2) != 0) {
                terminalTextSelection = terminalTextSelectionChangeEventImpl.oldSelection;
            }
            if ((n & 4) != 0) {
                terminalTextSelection2 = terminalTextSelectionChangeEventImpl.newSelection;
            }
            return terminalTextSelectionChangeEventImpl.copy(terminalOutputModel, terminalTextSelection, terminalTextSelection2);
        }

        @NotNull
        public String toString() {
            return "TerminalTextSelectionChangeEventImpl(outputModel=" + this.outputModel + ", oldSelection=" + this.oldSelection + ", newSelection=" + this.newSelection + ")";
        }

        public int hashCode() {
            int result2 = this.outputModel.hashCode();
            result2 = result2 * 31 + (this.oldSelection == null ? 0 : this.oldSelection.hashCode());
            result2 = result2 * 31 + (this.newSelection == null ? 0 : this.newSelection.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TerminalTextSelectionChangeEventImpl)) {
                return false;
            }
            TerminalTextSelectionChangeEventImpl terminalTextSelectionChangeEventImpl = (TerminalTextSelectionChangeEventImpl)other;
            if (!Intrinsics.areEqual((Object)this.outputModel, (Object)terminalTextSelectionChangeEventImpl.outputModel)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.oldSelection, (Object)terminalTextSelectionChangeEventImpl.oldSelection)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.newSelection, (Object)terminalTextSelectionChangeEventImpl.newSelection);
        }
    }
}

