/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.externalSystem.JavaModuleData;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleSdkData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectSdkData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.api.JavaVersion;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingModel;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.GradleBuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.GradleSourceSetModel;
import org.jetbrains.plugins.gradle.model.data.AnnotationProcessingData;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public final class JavaGradleProjectResolver
extends AbstractProjectResolverExtension {
    private final HashMap<GradleBuildScriptClasspathModel, List<BuildScriptClasspathData.ClasspathEntry>> buildScriptEntriesMap = new HashMap();

    public void resolveFinished(@NotNull DataNode<ProjectData> projectDataNode) {
        if (projectDataNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(0);
        }
        this.buildScriptEntriesMap.clear();
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        Set<Class<?>> set = Set.of(AnnotationProcessingModel.class, ProjectDependencies.class);
        if (set == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(1);
        }
        return set;
    }

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(2);
        }
        if (ideProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(3);
        }
        this.populateJavaProjectCompilerSettings(gradleProject, ideProject);
        this.nextResolver.populateProjectExtraModels(gradleProject, ideProject);
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(4);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(5);
        }
        this.populateJavaModuleCompilerSettings(gradleModule, ideModule);
        this.populateBuildScriptClasspathData(gradleModule, ideModule);
        this.populateAnnotationProcessorData(gradleModule, ideModule);
        this.populateDependenciesGraphData(gradleModule, ideModule);
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    private void populateAnnotationProcessorData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        AnnotationProcessingModel apModel;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(6);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(7);
        }
        if ((apModel = (AnnotationProcessingModel)this.resolverCtx.getProjectModel((ProjectModel)gradleModule, AnnotationProcessingModel.class)) == null) {
            return;
        }
        if (!this.resolverCtx.isResolveModulePerSourceSet()) {
            AnnotationProcessingData apData = JavaGradleProjectResolver.getMergedAnnotationProcessingData(apModel);
            DataNode dataNode = ideModule.createChild(AnnotationProcessingData.KEY, (Object)apData);
            JavaGradleProjectResolver.populateAnnotationProcessingOutput((DataNode<AnnotationProcessingData>)dataNode, apModel);
        } else {
            for (DataNode node : ExternalSystemApiUtil.findAll(ideModule, (Key)GradleSourceSetData.KEY)) {
                AnnotationProcessingData apData = JavaGradleProjectResolver.getAnnotationProcessingData(apModel, ((GradleSourceSetData)node.getData()).getModuleName());
                if (apData == null) continue;
                DataNode dataNode = node.createChild(AnnotationProcessingData.KEY, (Object)apData);
                JavaGradleProjectResolver.populateAnnotationProcessorOutput((DataNode<AnnotationProcessingData>)dataNode, apModel, ((GradleSourceSetData)node.getData()).getModuleName());
            }
        }
    }

    private static void populateAnnotationProcessorOutput(@NotNull DataNode<AnnotationProcessingData> parent, @NotNull AnnotationProcessingModel apModel, @NotNull String sourceSetName) {
        AnnotationProcessingConfig config;
        if (parent == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(8);
        }
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(9);
        }
        if (sourceSetName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(10);
        }
        if ((config = apModel.bySourceSetName(sourceSetName)) != null && config.getProcessorOutput() != null) {
            AnnotationProcessingData.AnnotationProcessorOutput annotationProcessorOutput = new AnnotationProcessingData.AnnotationProcessorOutput(config.getProcessorOutput(), config.isTestSources());
            parent.createChild(AnnotationProcessingData.OUTPUT_KEY, (Object)annotationProcessorOutput);
        }
    }

    private static void populateAnnotationProcessingOutput(@NotNull DataNode<AnnotationProcessingData> parent, @NotNull AnnotationProcessingModel apModel) {
        if (parent == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(11);
        }
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(12);
        }
        for (AnnotationProcessingConfig config : apModel.allConfigs().values()) {
            if (config.getProcessorOutput() == null) continue;
            AnnotationProcessingData.AnnotationProcessorOutput annotationProcessorOutput = new AnnotationProcessingData.AnnotationProcessorOutput(config.getProcessorOutput(), config.isTestSources());
            parent.createChild(AnnotationProcessingData.OUTPUT_KEY, (Object)annotationProcessorOutput);
        }
    }

    @NotNull
    private static AnnotationProcessingData getMergedAnnotationProcessingData(@NotNull AnnotationProcessingModel apModel) {
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(13);
        }
        LinkedHashSet<String> mergedAnnotationProcessorPath = new LinkedHashSet<String>();
        for (AnnotationProcessingConfig config : apModel.allConfigs().values()) {
            mergedAnnotationProcessorPath.addAll(config.getAnnotationProcessorPath());
        }
        ArrayList<String> apArguments = new ArrayList<String>();
        AnnotationProcessingConfig mainConfig = apModel.bySourceSetName("main");
        if (mainConfig != null) {
            apArguments.addAll(mainConfig.getAnnotationProcessorArguments());
        }
        AnnotationProcessingData annotationProcessingData = AnnotationProcessingData.create(mergedAnnotationProcessorPath, apArguments);
        if (annotationProcessingData == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(14);
        }
        return annotationProcessingData;
    }

    @Nullable
    private static AnnotationProcessingData getAnnotationProcessingData(@NotNull AnnotationProcessingModel apModel, @NotNull String sourceSetName) {
        AnnotationProcessingConfig config;
        if (apModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(15);
        }
        if (sourceSetName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(16);
        }
        if ((config = apModel.bySourceSetName(sourceSetName)) == null) {
            return null;
        }
        return AnnotationProcessingData.create(config.getAnnotationProcessorPath(), config.getAnnotationProcessorArguments());
    }

    private void populateBuildScriptClasspathData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(17);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(18);
        }
        GradleBuildScriptClasspathModel buildScriptClasspathModel = (GradleBuildScriptClasspathModel)this.resolverCtx.getProjectModel((ProjectModel)gradleModule, GradleBuildScriptClasspathModel.class);
        List classpathEntries = ContainerUtil.emptyList();
        if (buildScriptClasspathModel != null) {
            classpathEntries = this.buildScriptEntriesMap.computeIfAbsent(buildScriptClasspathModel, model -> ContainerUtil.map((Collection)model.getClasspath(), it -> BuildScriptClasspathData.ClasspathEntry.create((Set)it.getClasses(), (Set)it.getSources(), (Set)it.getJavadoc())));
        }
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        buildScriptClasspathData.setGradleHomeDir(buildScriptClasspathModel != null ? buildScriptClasspathModel.getGradleHomeDir() : null);
        ideModule.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
    }

    private void populateDependenciesGraphData(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ProjectDependencies projectDependencies;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(19);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(20);
        }
        if ((projectDependencies = (ProjectDependencies)this.resolverCtx.getProjectModel((ProjectModel)gradleModule, ProjectDependencies.class)) != null) {
            ideModule.createChild(ProjectKeys.DEPENDENCIES_GRAPH, (Object)projectDependencies);
        }
    }

    private void populateJavaProjectCompilerSettings(@NotNull IdeaProject ideaProject, @NotNull DataNode<ProjectData> projectNode) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(21);
        }
        if (projectNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(22);
        }
        projectNode.createChild(JavaProjectData.KEY, (Object)this.createProjectData(ideaProject));
        projectNode.createChild(ProjectSdkData.KEY, (Object)this.createProjectSdkData(ideaProject));
    }

    @NotNull
    private JavaProjectData createProjectData(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(23);
        }
        String compileOutputPath = this.getProjectCompileOutputPath();
        LanguageLevel languageLevel = this.getProjectLanguageLevel(ideaProject);
        String targetBytecodeVersion = this.getProjectTargetBytecodeVersion(ideaProject);
        List<String> compilerArguments = this.getProjectCompilerArguments(ideaProject);
        JavaProjectData javaProjectData = new JavaProjectData(GradleConstants.SYSTEM_ID, compileOutputPath, languageLevel, targetBytecodeVersion, compilerArguments);
        javaProjectData.setJdkName(ideaProject.getJdkName());
        JavaProjectData javaProjectData2 = javaProjectData;
        if (javaProjectData2 == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(24);
        }
        return javaProjectData2;
    }

    @NotNull
    private String getProjectCompileOutputPath() {
        String string = this.resolverCtx.getProjectPath() + "/build/classes";
        if (string == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(25);
        }
        return string;
    }

    private void populateJavaModuleCompilerSettings(@NotNull IdeaModule ideaModule, @NotNull DataNode<ModuleData> moduleNode) {
        GradleSourceSetModel sourceSetModel;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(26);
        }
        if (moduleNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(27);
        }
        if ((sourceSetModel = (GradleSourceSetModel)this.resolverCtx.getProjectModel((ProjectModel)ideaModule, GradleSourceSetModel.class)) == null) {
            return;
        }
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            Map<ExternalSourceSet, DataNode<GradleSourceSetData>> sourceSets = this.findSourceSets(ideaModule, sourceSetModel, moduleNode);
            for (Map.Entry<ExternalSourceSet, DataNode<GradleSourceSetData>> entry : sourceSets.entrySet()) {
                ExternalSourceSet sourceSet = entry.getKey();
                DataNode<GradleSourceSetData> sourceSetDataNode = entry.getValue();
                sourceSetDataNode.createChild(JavaModuleData.KEY, (Object)JavaGradleProjectResolver.createSourceSetModuleData(ideaModule, sourceSet));
                sourceSetDataNode.createChild(ModuleSdkData.KEY, (Object)this.createSourceSetModuleSdkData(ideaModule, sourceSet));
            }
        }
        moduleNode.createChild(JavaModuleData.KEY, (Object)JavaGradleProjectResolver.createHolderModuleData(ideaModule, sourceSetModel));
        moduleNode.createChild(ModuleSdkData.KEY, (Object)this.createHolderModuleSdkData(ideaModule, sourceSetModel));
    }

    @NotNull
    private static JavaModuleData createHolderModuleData(@NotNull IdeaModule ideaModule, @NotNull GradleSourceSetModel sourceSetModel) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(28);
        }
        if (sourceSetModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(29);
        }
        LanguageLevel languageLevel = JavaGradleProjectResolver.getHolderModuleLanguageLevel(ideaModule, sourceSetModel);
        String targetBytecodeVersion = JavaGradleProjectResolver.getHolderTargetBytecodeVersion(ideaModule, sourceSetModel);
        List<String> compilerArguments = JavaGradleProjectResolver.getHolderCompilerArguments(sourceSetModel);
        return new JavaModuleData(GradleConstants.SYSTEM_ID, languageLevel, targetBytecodeVersion, compilerArguments);
    }

    @NotNull
    private static JavaModuleData createSourceSetModuleData(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(30);
        }
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(31);
        }
        LanguageLevel languageLevel = JavaGradleProjectResolver.getSourceSetModuleLanguageLevel(ideaModule, sourceSet);
        String targetBytecodeVersion = JavaGradleProjectResolver.getSourceSetTargetBytecodeVersion(ideaModule, sourceSet);
        List<String> compilerArguments = JavaGradleProjectResolver.getSourceSetCompilerArguments(sourceSet);
        return new JavaModuleData(GradleConstants.SYSTEM_ID, languageLevel, targetBytecodeVersion, compilerArguments);
    }

    @NotNull
    private Map<ExternalSourceSet, DataNode<GradleSourceSetData>> findSourceSets(@NotNull IdeaModule ideaModule, @NotNull GradleSourceSetModel sourceSetModel, @NotNull DataNode<ModuleData> moduleNode) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(32);
        }
        if (sourceSetModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(33);
        }
        if (moduleNode == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(34);
        }
        Collection sourceSetNodes = ExternalSystemApiUtil.getChildren(moduleNode, (Key)GradleSourceSetData.KEY);
        LinkedHashMap<String, DataNode> sourceSetIndex = new LinkedHashMap<String, DataNode>();
        for (DataNode sourceSetNode : sourceSetNodes) {
            sourceSetIndex.put(((GradleSourceSetData)sourceSetNode.getData()).getId(), sourceSetNode);
        }
        LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>> result = new LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>>();
        for (ExternalSourceSet sourceSet : sourceSetModel.getSourceSets().values()) {
            String moduleId = GradleProjectResolverUtil.getModuleId((ProjectResolverContext)this.resolverCtx, (IdeaModule)ideaModule, (ExternalSourceSet)sourceSet);
            DataNode sourceSetNode = (DataNode)sourceSetIndex.get(moduleId);
            if (sourceSetNode == null) continue;
            result.put(sourceSet, (DataNode<GradleSourceSetData>)sourceSetNode);
        }
        LinkedHashMap<ExternalSourceSet, DataNode<GradleSourceSetData>> linkedHashMap = result;
        if (linkedHashMap == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(35);
        }
        return linkedHashMap;
    }

    @NotNull
    private Stream<? extends Pair<? extends IdeaModule, ? extends GradleSourceSetModel>> collectAllSourceSetModels(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(36);
        }
        Stream<Pair> stream = ideaProject.getModules().stream().map(it -> (Pair)ObjectUtils.doIfNotNull((Object)((GradleSourceSetModel)this.resolverCtx.getProjectModel((ProjectModel)it, GradleSourceSetModel.class)), m -> new Pair(it, m))).filter(Objects::nonNull);
        if (stream == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(37);
        }
        return stream;
    }

    @Nullable
    private LanguageLevel getProjectLanguageLevel(@NotNull IdeaProject ideaProject) {
        LanguageLevel languageLevel;
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(38);
        }
        if ((languageLevel = (LanguageLevel)this.collectAllSourceSetModels(ideaProject).map(it -> JavaGradleProjectResolver.getHolderModuleLanguageLevel((IdeaModule)it.first, (GradleSourceSetModel)it.second)).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null)) != null) {
            return languageLevel;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaProject.getJavaLanguageSettings();
        boolean isPreview = this.getProjectCompilerArguments(ideaProject).contains("--enable-preview");
        return JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, isPreview);
    }

    @Nullable
    private static LanguageLevel getHolderModuleLanguageLevel(@NotNull IdeaModule ideaModule, @NotNull GradleSourceSetModel sourceSetModel) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(39);
        }
        if (sourceSetModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(40);
        }
        boolean isPreview = JavaGradleProjectResolver.getHolderCompilerArguments(sourceSetModel).contains("--enable-preview");
        LanguageLevel languageLevel = JavaGradleProjectResolver.parseLanguageLevel(sourceSetModel.getSourceCompatibility(), isPreview);
        if (languageLevel != null) {
            return languageLevel;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, isPreview);
    }

    @Nullable
    private static LanguageLevel getSourceSetModuleLanguageLevel(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(41);
        }
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(42);
        }
        boolean isPreview = JavaGradleProjectResolver.getSourceSetCompilerArguments(sourceSet).contains("--enable-preview");
        LanguageLevel languageLevel = JavaGradleProjectResolver.parseLanguageLevel(sourceSet.getSourceCompatibility(), isPreview);
        if (languageLevel != null) {
            return languageLevel;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getLanguageLevel(javaLanguageSettings, isPreview);
    }

    @Nullable
    private static LanguageLevel getLanguageLevel(@Nullable IdeaJavaLanguageSettings languageSettings, boolean isPreview) {
        if (languageSettings == null) {
            return null;
        }
        JavaVersion languageLevel = languageSettings.getLanguageLevel();
        if (languageLevel == null) {
            return null;
        }
        return JavaGradleProjectResolver.parseLanguageLevel(languageLevel.toString(), isPreview);
    }

    @Nullable
    private static LanguageLevel parseLanguageLevel(@Nullable String languageLevelString, boolean isPreview) {
        LanguageLevel languageLevel = LanguageLevel.parse((String)languageLevelString);
        if (languageLevel == null) {
            return null;
        }
        return JavaGradleProjectResolver.setPreview(languageLevel, isPreview);
    }

    @NotNull
    private static LanguageLevel setPreview(@NotNull LanguageLevel languageLevel, boolean isPreview) {
        if (languageLevel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(43);
        }
        if (languageLevel.isPreview() == isPreview) {
            LanguageLevel languageLevel2 = languageLevel;
            if (languageLevel2 == null) {
                JavaGradleProjectResolver.$$$reportNull$$$0(44);
            }
            return languageLevel2;
        }
        com.intellij.util.lang.JavaVersion javaVersion = languageLevel.toJavaVersion();
        LanguageLevel languageLevel3 = LanguageLevel.getEntries().stream().filter(it -> it.isPreview() == isPreview).filter(it -> it.toJavaVersion().equals((Object)javaVersion)).findFirst().orElse(languageLevel);
        if (languageLevel3 == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(45);
        }
        return languageLevel3;
    }

    @Nullable
    private String getProjectTargetBytecodeVersion(@NotNull IdeaProject ideaProject) {
        String targetBytecodeVersion;
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(46);
        }
        if ((targetBytecodeVersion = (String)this.collectAllSourceSetModels(ideaProject).map(it -> JavaGradleProjectResolver.getHolderTargetBytecodeVersion((IdeaModule)it.first, (GradleSourceSetModel)it.second)).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null)) != null) {
            return targetBytecodeVersion;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaProject.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
    }

    @Nullable
    private static String getHolderTargetBytecodeVersion(@NotNull IdeaModule ideaModule, @NotNull GradleSourceSetModel sourceSetModel) {
        String targetCompatibility;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(47);
        }
        if (sourceSetModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(48);
        }
        if ((targetCompatibility = sourceSetModel.getTargetCompatibility()) != null) {
            return targetCompatibility;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
    }

    @Nullable
    private static String getSourceSetTargetBytecodeVersion(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        String targetCompatibility;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(49);
        }
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(50);
        }
        if ((targetCompatibility = sourceSet.getTargetCompatibility()) != null) {
            return targetCompatibility;
        }
        IdeaJavaLanguageSettings javaLanguageSettings = ideaModule.getJavaLanguageSettings();
        return JavaGradleProjectResolver.getTargetBytecodeVersion(javaLanguageSettings);
    }

    @Nullable
    private static String getTargetBytecodeVersion(@Nullable IdeaJavaLanguageSettings languageSettings) {
        if (languageSettings == null) {
            return null;
        }
        JavaVersion targetByteCodeVersion = languageSettings.getTargetBytecodeVersion();
        if (targetByteCodeVersion == null) {
            return null;
        }
        return targetByteCodeVersion.toString();
    }

    @NotNull
    private List<String> getProjectCompilerArguments(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(51);
        }
        List<String> list = this.collectAllSourceSetModels(ideaProject).map(it -> JavaGradleProjectResolver.getHolderCompilerArguments((GradleSourceSetModel)it.getSecond())).min(Comparator.comparing(it -> it.size())).orElse(Collections.emptyList());
        if (list == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    private static List<String> getHolderCompilerArguments(@NotNull GradleSourceSetModel sourceSetModel) {
        if (sourceSetModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(53);
        }
        List<String> list = sourceSetModel.getSourceSets().values().stream().map(it -> JavaGradleProjectResolver.getSourceSetCompilerArguments(it)).min(Comparator.comparing(it -> it.size())).orElse(Collections.emptyList());
        if (list == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(54);
        }
        return list;
    }

    @NotNull
    private static List<String> getSourceSetCompilerArguments(@NotNull ExternalSourceSet sourceSet) {
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(55);
        }
        List list = sourceSet.getCompilerArguments();
        if (list == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NotNull
    private ProjectSdkData createProjectSdkData(@NotNull IdeaProject ideaProject) {
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(57);
        }
        Sdk sdk = this.lookupProjectSdk(ideaProject);
        String sdkName = (String)ObjectUtils.doIfNotNull((Object)sdk, it -> it.getName());
        return new ProjectSdkData(sdkName);
    }

    @NotNull
    private ModuleSdkData createHolderModuleSdkData(@NotNull IdeaModule ideaModule, @NotNull GradleSourceSetModel sourceSetModel) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(58);
        }
        if (sourceSetModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(59);
        }
        Sdk sdk = this.lookupHolderModuleSdk(ideaModule, sourceSetModel);
        String sdkName = (String)ObjectUtils.doIfNotNull((Object)sdk, it -> it.getName());
        return new ModuleSdkData(sdkName);
    }

    @NotNull
    private ModuleSdkData createSourceSetModuleSdkData(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(60);
        }
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(61);
        }
        Sdk sdk = this.lookupSourceSetModuleSdk(ideaModule, sourceSet);
        String sdkName = (String)ObjectUtils.doIfNotNull((Object)sdk, it -> it.getName());
        return new ModuleSdkData(sdkName);
    }

    @Nullable
    private Sdk lookupProjectSdk(@NotNull IdeaProject ideaProject) {
        Sdk sdk;
        if (ideaProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(62);
        }
        if ((sdk = (Sdk)this.collectAllSourceSetModels(ideaProject).map(it -> this.lookupHolderModuleSdk((IdeaModule)it.first, (GradleSourceSetModel)it.second)).filter(Objects::nonNull).min(JavaSdkVersionUtil.naturalJavaSdkOrder((boolean)false)).orElse(null)) != null) {
            return sdk;
        }
        String sdkName = ideaProject.getJdkName();
        if (sdkName != null) {
            return this.lookupGradleJdkByName(sdkName);
        }
        return null;
    }

    @Nullable
    private Sdk lookupHolderModuleSdk(@NotNull IdeaModule ideaModule, @NotNull GradleSourceSetModel sourceSetModel) {
        String sdkName;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(63);
        }
        if (sourceSetModel == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(64);
        }
        if ((sdkName = ideaModule.getJdkName()) != null) {
            return this.lookupGradleJdkByName(sdkName);
        }
        Integer toolchainVersion = sourceSetModel.getToolchainVersion();
        if (toolchainVersion != null) {
            return this.lookupGradleJdkByVersion(com.intellij.util.lang.JavaVersion.compose((int)toolchainVersion));
        }
        String projectSdkName = ideaModule.getProject().getJdkName();
        if (projectSdkName != null) {
            return this.lookupGradleJdkByName(projectSdkName);
        }
        return null;
    }

    @Nullable
    private Sdk lookupSourceSetModuleSdk(@NotNull IdeaModule ideaModule, @NotNull ExternalSourceSet sourceSet) {
        String sdkName;
        if (ideaModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(65);
        }
        if (sourceSet == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(66);
        }
        if ((sdkName = ideaModule.getJdkName()) != null) {
            return this.lookupGradleJdkByName(sdkName);
        }
        File javaToolchainHome = (File)ObjectUtils.doIfNotNull((Object)sourceSet, it -> it.getJavaToolchainHome());
        if (javaToolchainHome != null) {
            return this.lookupGradleJdkByPath(NioPathUtil.toCanonicalPath((Path)javaToolchainHome.toPath()));
        }
        String projectSdkName = ideaModule.getProject().getJdkName();
        if (projectSdkName != null) {
            return this.lookupGradleJdkByName(projectSdkName);
        }
        return null;
    }

    @Nullable
    private Sdk lookupGradleJdkByName(@NotNull String sdkName) {
        Sdk gradleJvm;
        if (sdkName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(67);
        }
        if ((gradleJvm = this.lookupGradleJvmByName(sdkName)) != null) {
            return gradleJvm;
        }
        return ExternalSystemJdkUtil.lookupJdkByName((String)sdkName);
    }

    @NotNull
    private Sdk lookupGradleJdkByPath(@NotNull String sdkHome) {
        Sdk gradleJvm;
        if (sdkHome == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(68);
        }
        if ((gradleJvm = this.lookupGradleJvmByPath(sdkHome)) != null) {
            Sdk sdk = gradleJvm;
            if (sdk == null) {
                JavaGradleProjectResolver.$$$reportNull$$$0(69);
            }
            return sdk;
        }
        Sdk sdk = ExternalSystemJdkUtil.lookupJdkByPath((String)sdkHome);
        if (sdk == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(70);
        }
        return sdk;
    }

    @Nullable
    private Sdk lookupGradleJdkByVersion(@NotNull com.intellij.util.lang.JavaVersion sdkVersion) {
        Sdk gradleJvm;
        if (sdkVersion == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(71);
        }
        if ((gradleJvm = this.lookupGradleJvmByVersion(sdkVersion)) != null) {
            return gradleJvm;
        }
        return ExternalSystemJdkUtil.lookupJdkByVersion((com.intellij.util.lang.JavaVersion)sdkVersion);
    }

    @Nullable
    private Sdk lookupGradleJvmByName(@NotNull String sdkName) {
        com.intellij.util.lang.JavaVersion javaVersion;
        if (sdkName == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(72);
        }
        if ((javaVersion = com.intellij.util.lang.JavaVersion.tryParse((String)sdkName)) == null) {
            return null;
        }
        return this.lookupGradleJvmByVersion(javaVersion);
    }

    @Nullable
    private Sdk lookupGradleJvmByPath(@NotNull String sdkHome) {
        com.intellij.util.lang.JavaVersion javaVersion;
        if (sdkHome == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(73);
        }
        if ((javaVersion = ExternalSystemJdkUtil.getJavaVersion((String)sdkHome)) == null) {
            return null;
        }
        return this.lookupGradleJvmByVersion(javaVersion);
    }

    @Nullable
    private Sdk lookupGradleJvmByVersion(@NotNull com.intellij.util.lang.JavaVersion sdkVersion) {
        Sdk sdk;
        if (sdkVersion == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(74);
        }
        if ((sdk = this.lookupGradleJvm()) == null) {
            return null;
        }
        if (ExternalSystemJdkUtil.matchJavaVersion((com.intellij.util.lang.JavaVersion)sdkVersion, (String)sdk.getVersionString())) {
            return sdk;
        }
        return null;
    }

    @Nullable
    private Sdk lookupGradleJvm() {
        GradleProjectSettings projectSettings = this.getProjectSettings();
        if (projectSettings == null) {
            return null;
        }
        String gradleJvm = projectSettings.getGradleJvm();
        if (gradleJvm == null) {
            return null;
        }
        return ProjectJdkTable.getInstance().findJdk(gradleJvm);
    }

    @Nullable
    private GradleProjectSettings getProjectSettings() {
        Project project = this.resolverCtx.getExternalSystemTaskId().findProject();
        if (project == null) {
            return null;
        }
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        String linkedProjectPath = this.resolverCtx.getProjectPath();
        return (GradleProjectSettings)settings.getLinkedProjectSettings(linkedProjectPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 14, 24, 25, 35, 37, 44, 45, 52, 54, 56, 69, 70 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 1: 
            case 14: 
            case 24: 
            case 25: 
            case 35: 
            case 37: 
            case 44: 
            case 45: 
            case 52: 
            case 54: 
            case 56: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/JavaGradleProjectResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 5: 
            case 7: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apModel";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetName";
                break;
            }
            case 21: 
            case 23: 
            case 36: 
            case 38: 
            case 46: 
            case 51: 
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaProject";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectNode";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 39: 
            case 41: 
            case 47: 
            case 49: 
            case 58: 
            case 60: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaModule";
                break;
            }
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
            case 29: 
            case 33: 
            case 40: 
            case 48: 
            case 53: 
            case 59: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetModel";
                break;
            }
            case 31: 
            case 42: 
            case 50: 
            case 55: 
            case 61: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 68: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/JavaGradleProjectResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedAnnotationProcessingData";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectData";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectCompileOutputPath";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceSets";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllSourceSetModels";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "setPreview";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectCompilerArguments";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolderCompilerArguments";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceSetCompilerArguments";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupGradleJdkByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveFinished";
                break;
            }
            case 1: 
            case 14: 
            case 24: 
            case 25: 
            case 35: 
            case 37: 
            case 44: 
            case 45: 
            case 52: 
            case 54: 
            case 56: 
            case 69: 
            case 70: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "populateAnnotationProcessorData";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "populateAnnotationProcessorOutput";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "populateAnnotationProcessingOutput";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMergedAnnotationProcessingData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationProcessingData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "populateBuildScriptClasspathData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "populateDependenciesGraphData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "populateJavaProjectCompilerSettings";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createProjectData";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "populateJavaModuleCompilerSettings";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createHolderModuleData";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createSourceSetModuleData";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findSourceSets";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectAllSourceSetModels";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getProjectLanguageLevel";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getHolderModuleLanguageLevel";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSourceSetModuleLanguageLevel";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setPreview";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getProjectTargetBytecodeVersion";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getHolderTargetBytecodeVersion";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSourceSetTargetBytecodeVersion";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getProjectCompilerArguments";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getHolderCompilerArguments";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getSourceSetCompilerArguments";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createProjectSdkData";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createHolderModuleSdkData";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createSourceSetModuleSdkData";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lookupProjectSdk";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lookupHolderModuleSdk";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lookupSourceSetModuleSdk";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lookupGradleJdkByName";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lookupGradleJdkByPath";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lookupGradleJdkByVersion";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lookupGradleJvmByName";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "lookupGradleJvmByPath";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lookupGradleJvmByVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 14, 24, 25, 35, 37, 44, 45, 52, 54, 56, 69, 70 -> new IllegalStateException(string);
        };
    }
}

