/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public final class AclRoutingProcessor
extends AbstractProcessor {
    public static final String TYPE = "acl_routing";
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final String aclField;
    private final String targetField;
    private final boolean ignoreMissing;
    private final boolean overrideExisting;

    AclRoutingProcessor(String tag, String description, String aclField, String targetField, boolean ignoreMissing, boolean overrideExisting) {
        super(tag, description);
        this.aclField = aclField;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
        this.overrideExisting = overrideExisting;
    }

    public IngestDocument execute(IngestDocument document) throws Exception {
        Object aclValue = document.getFieldValue(this.aclField, Object.class, this.ignoreMissing);
        if (aclValue == null) {
            if (this.ignoreMissing) {
                return document;
            }
            throw new IllegalArgumentException("field [" + this.aclField + "] not present as part of path [" + this.aclField + "]");
        }
        if (!this.overrideExisting && document.hasField(this.targetField)) {
            return document;
        }
        String routingValue = this.generateRoutingValue(aclValue.toString());
        document.setFieldValue(this.targetField, (Object)routingValue);
        return document;
    }

    private String generateRoutingValue(String aclValue) {
        byte[] bytes = aclValue.getBytes(StandardCharsets.UTF_8);
        MurmurHash3.Hash128 hash = MurmurHash3.hash128((byte[])bytes, (int)0, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
        byte[] hashBytes = new byte[16];
        System.arraycopy(this.longToBytes(hash.h1), 0, hashBytes, 0, 8);
        System.arraycopy(this.longToBytes(hash.h2), 0, hashBytes, 8, 8);
        return BASE64_ENCODER.encodeToString(hashBytes);
    }

    private byte[] longToBytes(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public AclRoutingProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String aclField = ConfigurationUtils.readStringProperty((String)AclRoutingProcessor.TYPE, (String)processorTag, config, (String)"acl_field");
            String targetField = ConfigurationUtils.readStringProperty((String)AclRoutingProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)"_routing");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)AclRoutingProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            boolean overrideExisting = ConfigurationUtils.readBooleanProperty((String)AclRoutingProcessor.TYPE, (String)processorTag, config, (String)"override_existing", (boolean)true);
            return new AclRoutingProcessor(processorTag, description, aclField, targetField, ignoreMissing, overrideExisting);
        }
    }
}

