/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.model;

import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.model.NotificationConfig;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 a2\u00020\u00012\u00020\u0002:\u0004abcdB\u0097\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dB\u0011\b\u0016\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0004\b\u001c\u0010 J\b\u00109\u001a\u00020\u0004H\u0016J\b\u0010>\u001a\u00020\u0012H\u0016J\n\u0010?\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010@\u001a\u00020\u0015H\u0016J\b\u0010A\u001a\u00020\u0010H\u0016J\r\u0010B\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010CJ\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020E2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0016J\t\u0010M\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010N\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010O\u001a\u00020\u0007H\u00c6\u0003J\t\u0010P\u001a\u00020\tH\u00c6\u0003J\u000b\u0010Q\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u0015\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\t\u0010S\u001a\u00020\u0010H\u00c6\u0003J\t\u0010T\u001a\u00020\u0012H\u00c6\u0003J\u000b\u0010U\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\t\u0010V\u001a\u00020\u0015H\u00c6\u0003J\t\u0010W\u001a\u00020\u0007H\u00c6\u0003J\t\u0010X\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010Y\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003J\u000b\u0010Z\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u00ab\u0001\u0010[\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00c6\u0001J\u0013\u0010\\\u001a\u00020\u00102\b\u0010]\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010^\u001a\u00020_H\u00d6\u0001J\t\u0010`\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010/R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010%R\u0011\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010%R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0011\u0010:\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\"R\u0011\u0010<\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\"\u00a8\u0006e"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParameter;", "Lorg/opensearch/core/common/io/stream/Writeable;", "id", "", "description", "schemaVersion", "", "creation", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Creation;", "deletion", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Deletion;", "snapshotConfig", "", "", "jobEnabled", "", "jobLastUpdateTime", "Ljava/time/Instant;", "jobEnabledTime", "jobSchedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "seqNo", "primaryTerm", "notificationConfig", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/NotificationConfig;", "user", "Lorg/opensearch/commons/authuser/User;", "<init>", "(Ljava/lang/String;Ljava/lang/String;JLorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Creation;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Deletion;Ljava/util/Map;ZLjava/time/Instant;Ljava/time/Instant;Lorg/opensearch/jobscheduler/spi/schedule/Schedule;JJLorg/opensearch/indexmanagement/snapshotmanagement/model/NotificationConfig;Lorg/opensearch/commons/authuser/User;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getId", "()Ljava/lang/String;", "getDescription", "getSchemaVersion", "()J", "getCreation", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Creation;", "getDeletion", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Deletion;", "getSnapshotConfig", "()Ljava/util/Map;", "getJobEnabled", "()Z", "getJobLastUpdateTime", "()Ljava/time/Instant;", "getJobEnabledTime", "getJobSchedule", "()Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "getSeqNo", "getPrimaryTerm", "getNotificationConfig", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/NotificationConfig;", "getUser", "()Lorg/opensearch/commons/authuser/User;", "getName", "policyName", "getPolicyName", "metadataID", "getMetadataID", "getLastUpdateTime", "getEnabledTime", "getSchedule", "isEnabled", "getLockDurationSeconds", "()Ljava/lang/Long;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "Creation", "Deletion", "DeleteCondition", "opensearch-index-management"})
public final class SMPolicy
implements ScheduledJobParameter,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @Nullable
    private final String description;
    private final long schemaVersion;
    @NotNull
    private final Creation creation;
    @Nullable
    private final Deletion deletion;
    @NotNull
    private final Map<String, Object> snapshotConfig;
    private final boolean jobEnabled;
    @NotNull
    private final Instant jobLastUpdateTime;
    @Nullable
    private final Instant jobEnabledTime;
    @NotNull
    private final Schedule jobSchedule;
    private final long seqNo;
    private final long primaryTerm;
    @Nullable
    private final NotificationConfig notificationConfig;
    @Nullable
    private final User user;
    @NotNull
    public static final String SM_TYPE = "sm_policy";
    @NotNull
    public static final String SM_DOC_ID_SUFFIX = "-sm-policy";
    @NotNull
    public static final String SM_METADATA_ID_SUFFIX = "-sm-metadata";
    @NotNull
    public static final String NAME_FIELD = "name";
    @NotNull
    public static final String DESCRIPTION_FIELD = "description";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String CREATION_FIELD = "creation";
    @NotNull
    public static final String DELETION_FIELD = "deletion";
    @NotNull
    public static final String SNAPSHOT_CONFIG_FIELD = "snapshot_config";
    @NotNull
    public static final String DATE_FORMAT_FIELD = "date_format";
    @NotNull
    public static final String DATE_FORMAT_TIMEZONE_FIELD = "date_format_timezone";
    @NotNull
    public static final String ENABLED_FIELD = "enabled";
    @NotNull
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    @NotNull
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    @NotNull
    public static final String SCHEDULE_FIELD = "schedule";
    @NotNull
    public static final String NOTIFICATION_FIELD = "notification";
    @NotNull
    public static final String USER_FIELD = "user";
    @NotNull
    public static final String TIME_LIMIT_FIELD = "time_limit";

    public SMPolicy(@NotNull String id, @Nullable String description, long schemaVersion, @NotNull Creation creation, @Nullable Deletion deletion, @NotNull Map<String, ? extends Object> snapshotConfig, boolean jobEnabled, @NotNull Instant jobLastUpdateTime, @Nullable Instant jobEnabledTime, @NotNull Schedule jobSchedule, long seqNo, long primaryTerm, @Nullable NotificationConfig notificationConfig, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)creation, (String)CREATION_FIELD);
        Intrinsics.checkNotNullParameter(snapshotConfig, (String)"snapshotConfig");
        Intrinsics.checkNotNullParameter((Object)jobLastUpdateTime, (String)"jobLastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)jobSchedule, (String)"jobSchedule");
        this.id = id;
        this.description = description;
        this.schemaVersion = schemaVersion;
        this.creation = creation;
        this.deletion = deletion;
        this.snapshotConfig = snapshotConfig;
        this.jobEnabled = jobEnabled;
        this.jobLastUpdateTime = jobLastUpdateTime;
        this.jobEnabledTime = jobEnabledTime;
        this.jobSchedule = jobSchedule;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.notificationConfig = notificationConfig;
        this.user = user;
        if (!(this.snapshotConfig.get("repository") != null && !Intrinsics.areEqual((Object)this.snapshotConfig.get("repository"), (Object)""))) {
            boolean $i$a$-require-SMPolicy$42 = false;
            String $i$a$-require-SMPolicy$42 = "Must provide the repository in snapshot config.";
            throw new IllegalArgumentException($i$a$-require-SMPolicy$42.toString());
        }
        if (!(this.creation.getSchedule().getNextExecutionTime(Instant.now()) != null)) {
            boolean $i$a$-require-SMPolicy$52 = false;
            String $i$a$-require-SMPolicy$52 = "Next execution time from the creation schedule is null, please provide a valid cron expression.";
            throw new IllegalArgumentException($i$a$-require-SMPolicy$52.toString());
        }
        if (!(this.deletion == null || this.deletion.getSchedule().getNextExecutionTime(Instant.now()) != null)) {
            boolean bl = false;
            String string = "Next execution time from the deletion schedule is null, please provide a valid cron expression.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SMPolicy(String string, String string2, long l, Creation creation, Deletion deletion, Map map, boolean bl, Instant instant, Instant instant2, Schedule schedule, long l2, long l3, NotificationConfig notificationConfig, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 0x400) != 0) {
            l2 = -2L;
        }
        if ((n & 0x800) != 0) {
            l3 = 0L;
        }
        if ((n & 0x1000) != 0) {
            notificationConfig = null;
        }
        if ((n & 0x2000) != 0) {
            user = null;
        }
        this(string, string2, l, creation, deletion, map, bl, instant, instant2, schedule, l2, l3, notificationConfig, user);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    public final long getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final Creation getCreation() {
        return this.creation;
    }

    @Nullable
    public final Deletion getDeletion() {
        return this.deletion;
    }

    @NotNull
    public final Map<String, Object> getSnapshotConfig() {
        return this.snapshotConfig;
    }

    public final boolean getJobEnabled() {
        return this.jobEnabled;
    }

    @NotNull
    public final Instant getJobLastUpdateTime() {
        return this.jobLastUpdateTime;
    }

    @Nullable
    public final Instant getJobEnabledTime() {
        return this.jobEnabledTime;
    }

    @NotNull
    public final Schedule getJobSchedule() {
        return this.jobSchedule;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public final NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    @NotNull
    public String getName() {
        return this.id;
    }

    @NotNull
    public final String getPolicyName() {
        return SMUtilsKt.smDocIdToPolicyName(this.id);
    }

    @NotNull
    public final String getMetadataID() {
        return SMUtilsKt.smPolicyNameToMetadataDocId(SMUtilsKt.smDocIdToPolicyName(this.id));
    }

    @NotNull
    public Instant getLastUpdateTime() {
        return this.jobLastUpdateTime;
    }

    @Nullable
    public Instant getEnabledTime() {
        return this.jobEnabledTime;
    }

    @NotNull
    public Schedule getSchedule() {
        return this.jobSchedule;
    }

    public boolean isEnabled() {
        return this.jobEnabled;
    }

    @NotNull
    public Long getLockDurationSeconds() {
        return 1800L;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(SM_TYPE);
        }
        XContentBuilder xContentBuilder = builder.field(NAME_FIELD, SMUtilsKt.smDocIdToPolicyName(this.id));
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalField(xContentBuilder, DESCRIPTION_FIELD, this.description).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(CREATION_FIELD, (ToXContent)this.creation);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"field(...)");
        XContentBuilder xContentBuilder3 = OpenSearchExtensionsKt.optionalField(xContentBuilder2, DELETION_FIELD, this.deletion).field(SNAPSHOT_CONFIG_FIELD, this.snapshotConfig).field(SCHEDULE_FIELD, (ToXContent)this.jobSchedule).field(ENABLED_FIELD, this.jobEnabled);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder3, (String)"field(...)");
        OpenSearchExtensionsKt.optionalField(OpenSearchExtensionsKt.optionalTimeField(OpenSearchExtensionsKt.optionalTimeField(xContentBuilder3, LAST_UPDATED_TIME_FIELD, this.jobLastUpdateTime), ENABLED_TIME_FIELD, this.jobEnabledTime), NOTIFICATION_FIELD, this.notificationConfig);
        if (params.paramAsBoolean("with_user", true)) {
            OpenSearchExtensionsKt.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder4 = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder4, (String)"endObject(...)");
        return xContentBuilder4;
    }

    public SMPolicy(@NotNull StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readOptionalString();
        long l = sin.readLong();
        Creation creation = new Creation(sin);
        Deletion deletion = (Deletion)sin.readOptionalWriteable(SMPolicy::_init_$lambda$3);
        Map map = sin.readMap();
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map map2 = map;
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        Instant instant2 = instant;
        Instant instant3 = sin.readOptionalInstant();
        IntervalSchedule intervalSchedule = new IntervalSchedule(sin);
        boolean bl = sin.readBoolean();
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        String string3 = string2;
        long l2 = sin.readLong();
        long l3 = sin.readLong();
        NotificationConfig notificationConfig = (NotificationConfig)sin.readOptionalWriteable(SMPolicy::_init_$lambda$4);
        User user = (User)sin.readOptionalWriteable(User::new);
        this(string3, string, l, creation, deletion, map2, bl, instant2, instant3, (Schedule)intervalSchedule, l2, l3, notificationConfig, user);
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeOptionalString(this.description);
        out.writeLong(this.schemaVersion);
        this.creation.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.deletion);
        out.writeMap(this.snapshotConfig);
        out.writeInstant(this.jobLastUpdateTime);
        out.writeOptionalInstant(this.jobEnabledTime);
        this.jobSchedule.writeTo(out);
        out.writeBoolean(this.jobEnabled);
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeOptionalWriteable((Writeable)this.notificationConfig);
        out.writeOptionalWriteable((Writeable)this.user);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @Nullable
    public final String component2() {
        return this.description;
    }

    public final long component3() {
        return this.schemaVersion;
    }

    @NotNull
    public final Creation component4() {
        return this.creation;
    }

    @Nullable
    public final Deletion component5() {
        return this.deletion;
    }

    @NotNull
    public final Map<String, Object> component6() {
        return this.snapshotConfig;
    }

    public final boolean component7() {
        return this.jobEnabled;
    }

    @NotNull
    public final Instant component8() {
        return this.jobLastUpdateTime;
    }

    @Nullable
    public final Instant component9() {
        return this.jobEnabledTime;
    }

    @NotNull
    public final Schedule component10() {
        return this.jobSchedule;
    }

    public final long component11() {
        return this.seqNo;
    }

    public final long component12() {
        return this.primaryTerm;
    }

    @Nullable
    public final NotificationConfig component13() {
        return this.notificationConfig;
    }

    @Nullable
    public final User component14() {
        return this.user;
    }

    @NotNull
    public final SMPolicy copy(@NotNull String id, @Nullable String description, long schemaVersion, @NotNull Creation creation, @Nullable Deletion deletion, @NotNull Map<String, ? extends Object> snapshotConfig, boolean jobEnabled, @NotNull Instant jobLastUpdateTime, @Nullable Instant jobEnabledTime, @NotNull Schedule jobSchedule, long seqNo, long primaryTerm, @Nullable NotificationConfig notificationConfig, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)creation, (String)CREATION_FIELD);
        Intrinsics.checkNotNullParameter(snapshotConfig, (String)"snapshotConfig");
        Intrinsics.checkNotNullParameter((Object)jobLastUpdateTime, (String)"jobLastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)jobSchedule, (String)"jobSchedule");
        return new SMPolicy(id, description, schemaVersion, creation, deletion, snapshotConfig, jobEnabled, jobLastUpdateTime, jobEnabledTime, jobSchedule, seqNo, primaryTerm, notificationConfig, user);
    }

    public static /* synthetic */ SMPolicy copy$default(SMPolicy sMPolicy, String string, String string2, long l, Creation creation, Deletion deletion, Map map, boolean bl, Instant instant, Instant instant2, Schedule schedule, long l2, long l3, NotificationConfig notificationConfig, User user, int n, Object object) {
        if ((n & 1) != 0) {
            string = sMPolicy.id;
        }
        if ((n & 2) != 0) {
            string2 = sMPolicy.description;
        }
        if ((n & 4) != 0) {
            l = sMPolicy.schemaVersion;
        }
        if ((n & 8) != 0) {
            creation = sMPolicy.creation;
        }
        if ((n & 0x10) != 0) {
            deletion = sMPolicy.deletion;
        }
        if ((n & 0x20) != 0) {
            map = sMPolicy.snapshotConfig;
        }
        if ((n & 0x40) != 0) {
            bl = sMPolicy.jobEnabled;
        }
        if ((n & 0x80) != 0) {
            instant = sMPolicy.jobLastUpdateTime;
        }
        if ((n & 0x100) != 0) {
            instant2 = sMPolicy.jobEnabledTime;
        }
        if ((n & 0x200) != 0) {
            schedule = sMPolicy.jobSchedule;
        }
        if ((n & 0x400) != 0) {
            l2 = sMPolicy.seqNo;
        }
        if ((n & 0x800) != 0) {
            l3 = sMPolicy.primaryTerm;
        }
        if ((n & 0x1000) != 0) {
            notificationConfig = sMPolicy.notificationConfig;
        }
        if ((n & 0x2000) != 0) {
            user = sMPolicy.user;
        }
        return sMPolicy.copy(string, string2, l, creation, deletion, map, bl, instant, instant2, schedule, l2, l3, notificationConfig, user);
    }

    @NotNull
    public String toString() {
        return "SMPolicy(id=" + this.id + ", description=" + this.description + ", schemaVersion=" + this.schemaVersion + ", creation=" + this.creation + ", deletion=" + this.deletion + ", snapshotConfig=" + this.snapshotConfig + ", jobEnabled=" + this.jobEnabled + ", jobLastUpdateTime=" + this.jobLastUpdateTime + ", jobEnabledTime=" + this.jobEnabledTime + ", jobSchedule=" + this.jobSchedule + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", notificationConfig=" + this.notificationConfig + ", user=" + this.user + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
        result2 = result2 * 31 + Long.hashCode(this.schemaVersion);
        result2 = result2 * 31 + this.creation.hashCode();
        result2 = result2 * 31 + (this.deletion == null ? 0 : this.deletion.hashCode());
        result2 = result2 * 31 + ((Object)this.snapshotConfig).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.jobEnabled);
        result2 = result2 * 31 + this.jobLastUpdateTime.hashCode();
        result2 = result2 * 31 + (this.jobEnabledTime == null ? 0 : this.jobEnabledTime.hashCode());
        result2 = result2 * 31 + this.jobSchedule.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seqNo);
        result2 = result2 * 31 + Long.hashCode(this.primaryTerm);
        result2 = result2 * 31 + (this.notificationConfig == null ? 0 : this.notificationConfig.hashCode());
        result2 = result2 * 31 + (this.user == null ? 0 : this.user.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SMPolicy)) {
            return false;
        }
        SMPolicy sMPolicy = (SMPolicy)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)sMPolicy.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)sMPolicy.description)) {
            return false;
        }
        if (this.schemaVersion != sMPolicy.schemaVersion) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.creation, (Object)sMPolicy.creation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.deletion, (Object)sMPolicy.deletion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.snapshotConfig, sMPolicy.snapshotConfig)) {
            return false;
        }
        if (this.jobEnabled != sMPolicy.jobEnabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobLastUpdateTime, (Object)sMPolicy.jobLastUpdateTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobEnabledTime, (Object)sMPolicy.jobEnabledTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobSchedule, (Object)sMPolicy.jobSchedule)) {
            return false;
        }
        if (this.seqNo != sMPolicy.seqNo) {
            return false;
        }
        if (this.primaryTerm != sMPolicy.primaryTerm) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.notificationConfig, (Object)sMPolicy.notificationConfig)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.user, (Object)sMPolicy.user);
    }

    private static final Deletion _init_$lambda$3(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new Deletion(it);
    }

    private static final NotificationConfig _init_$lambda$4(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new NotificationConfig(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Companion;", "", "<init>", "()V", "SM_TYPE", "", "SM_DOC_ID_SUFFIX", "SM_METADATA_ID_SUFFIX", "NAME_FIELD", "DESCRIPTION_FIELD", "SCHEMA_VERSION_FIELD", "CREATION_FIELD", "DELETION_FIELD", "SNAPSHOT_CONFIG_FIELD", "DATE_FORMAT_FIELD", "DATE_FORMAT_TIMEZONE_FIELD", "ENABLED_FIELD", "LAST_UPDATED_TIME_FIELD", "ENABLED_TIME_FIELD", "SCHEDULE_FIELD", "NOTIFICATION_FIELD", "USER_FIELD", "TIME_LIMIT_FIELD", "parse", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "seqNo", "", "primaryTerm", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nSMPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMPolicy.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 OpenSearchExtensions.kt\norg/opensearch/indexmanagement/opensearchapi/OpenSearchExtensionsKt\n*L\n1#1,424:1\n1#2:425\n340#3:426\n*S KotlinDebug\n*F\n+ 1 SMPolicy.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Companion\n*L\n155#1:426\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SMPolicy parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String description = null;
            Creation creation = null;
            Deletion deletion = null;
            Map snapshotConfig = null;
            Instant lastUpdatedTime = null;
            long schemaVersion = 1L;
            Instant enabledTime = null;
            Schedule schedule = null;
            boolean enabled = true;
            NotificationConfig notificationConfig = null;
            User user = null;
            if (xcp.currentToken() == null) {
                xcp.nextToken();
            }
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case 1684719674: {
                        if (string.equals(SMPolicy.SCHEMA_VERSION_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case -1219796725: {
                        if (string.equals(SMPolicy.ENABLED_TIME_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case -697920873: {
                        if (string.equals(SMPolicy.SCHEDULE_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case 595233003: {
                        if (string.equals(SMPolicy.NOTIFICATION_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case -1670470950: {
                        if (string.equals(SMPolicy.LAST_UPDATED_TIME_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                    case 819717070: {
                        if (string.equals(SMPolicy.DELETION_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                    case 3373707: {
                        if (string.equals(SMPolicy.NAME_FIELD)) {
                            n = 7;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (string.equals(SMPolicy.DESCRIPTION_FIELD)) {
                            n = 8;
                        }
                        break;
                    }
                    case -181311971: {
                        if (string.equals(SMPolicy.SNAPSHOT_CONFIG_FIELD)) {
                            n = 9;
                        }
                        break;
                    }
                    case 3599307: {
                        if (string.equals(SMPolicy.USER_FIELD)) {
                            n = 10;
                        }
                        break;
                    }
                    case 1820421855: {
                        if (string.equals(SMPolicy.CREATION_FIELD)) {
                            n = 11;
                        }
                        break;
                    }
                    case -1609594047: {
                        if (string.equals(SMPolicy.ENABLED_FIELD)) {
                            n = 12;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 7: {
                        if (xcp.text() == null) {
                            boolean $i$a$-requireNotNull-SMPolicy$Companion$parse$22 = false;
                            String $i$a$-requireNotNull-SMPolicy$Companion$parse$22 = "The name field of SMPolicy must not be null.";
                            throw new IllegalArgumentException($i$a$-requireNotNull-SMPolicy$Companion$parse$22.toString());
                        }
                        break;
                    }
                    case 8: {
                        String string2;
                        XContentParser $this$nullValueHandler$iv = xcp;
                        boolean $i$f$nullValueHandler = false;
                        if ($this$nullValueHandler$iv.currentToken() == XContentParser.Token.VALUE_NULL) {
                            string2 = null;
                        } else {
                            XContentParser $this$parse_u24lambda_u241 = $this$nullValueHandler$iv;
                            boolean bl = false;
                            string2 = $this$parse_u24lambda_u241.text();
                        }
                        description = string2;
                        break;
                    }
                    case 1: {
                        schemaVersion = xcp.longValue();
                        break;
                    }
                    case 11: {
                        creation = Creation.Companion.parse(xcp);
                        break;
                    }
                    case 6: {
                        deletion = Deletion.Companion.parse(xcp);
                        break;
                    }
                    case 9: {
                        snapshotConfig = xcp.map();
                        break;
                    }
                    case 5: {
                        lastUpdatedTime = OpenSearchExtensionsKt.instant(xcp);
                        break;
                    }
                    case 2: {
                        enabledTime = OpenSearchExtensionsKt.instant(xcp);
                        break;
                    }
                    case 3: {
                        schedule = ScheduleParser.parse((XContentParser)xcp);
                        break;
                    }
                    case 12: {
                        enabled = xcp.booleanValue();
                        break;
                    }
                    case 4: {
                        notificationConfig = NotificationConfig.Companion.parse(xcp);
                        break;
                    }
                    case 10: {
                        user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    }
                }
            }
            if (enabled && enabledTime == null) {
                enabledTime = Instant.now();
            } else if (!enabled) {
                enabledTime = null;
            }
            if (lastUpdatedTime == null) {
                lastUpdatedTime = Instant.now();
            }
            if (schedule == null) {
                schedule = (Schedule)new IntervalSchedule(Instant.now(), 1, ChronoUnit.MINUTES);
            }
            if (!(creation != null)) {
                boolean bl = false;
                String string = "Must provide the creation configuration.";
                throw new IllegalArgumentException(string.toString());
            }
            if (deletion != null && !deletion.getScheduleProvided()) {
                deletion = Deletion.copy$default(deletion, creation.getSchedule(), false, null, null, 14, null);
            }
            if (snapshotConfig == null) {
                boolean $i$a$-requireNotNull-SMPolicy$Companion$parse$62 = false;
                String $i$a$-requireNotNull-SMPolicy$Companion$parse$62 = "snapshot_config field must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-SMPolicy$Companion$parse$62.toString());
            }
            if (snapshotConfig.get(SMPolicy.DATE_FORMAT_FIELD) != null) {
                Object v = snapshotConfig.get(SMPolicy.DATE_FORMAT_FIELD);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                String validMsg = SMUtilsKt.validateDateFormat((String)v);
                if (validMsg != null) {
                    throw new IllegalArgumentException("Please provide a valid date format. " + validMsg);
                }
            }
            String string = description;
            long l = schemaVersion;
            Creation creation2 = creation;
            Deletion deletion2 = deletion;
            Map map = snapshotConfig;
            Instant instant = lastUpdatedTime;
            if (instant == null) {
                boolean bl = false;
                String string3 = "last_updated_time field must not be null";
                throw new IllegalArgumentException(string3.toString());
            }
            Instant instant2 = instant;
            Instant instant3 = enabledTime;
            Schedule schedule2 = schedule;
            boolean bl = enabled;
            NotificationConfig notificationConfig2 = notificationConfig;
            User user2 = user;
            return new SMPolicy(id, string, l, creation2, deletion2, map, bl, instant2, instant3, schedule2, seqNo, primaryTerm, notificationConfig2, user2);
        }

        public static /* synthetic */ SMPolicy parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) {
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u001f\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Creation;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "schedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "timeLimit", "Lorg/opensearch/common/unit/TimeValue;", "<init>", "(Lorg/opensearch/jobscheduler/spi/schedule/Schedule;Lorg/opensearch/common/unit/TimeValue;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getSchedule", "()Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "getTimeLimit", "()Lorg/opensearch/common/unit/TimeValue;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "opensearch-index-management"})
    public static final class Creation
    implements Writeable,
    ToXContent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Schedule schedule;
        @Nullable
        private final TimeValue timeLimit;
        @NotNull
        public static final String SCHEDULE_FIELD = "schedule";

        public Creation(@NotNull Schedule schedule, @Nullable TimeValue timeLimit) {
            Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
            this.schedule = schedule;
            this.timeLimit = timeLimit;
        }

        public /* synthetic */ Creation(Schedule schedule, TimeValue timeValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                timeValue = null;
            }
            this(schedule, timeValue);
        }

        @NotNull
        public final Schedule getSchedule() {
            return this.schedule;
        }

        @Nullable
        public final TimeValue getTimeLimit() {
            return this.timeLimit;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            XContentBuilder xContentBuilder = builder.startObject().field("schedule", (ToXContent)this.schedule);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
            XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalField(xContentBuilder, SMPolicy.TIME_LIMIT_FIELD, this.timeLimit).endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
            return xContentBuilder2;
        }

        public Creation(@NotNull StreamInput sin) {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            this((Schedule)new CronSchedule(sin), sin.readOptionalTimeValue());
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.schedule.writeTo(out);
            out.writeOptionalTimeValue(this.timeLimit);
        }

        @NotNull
        public final Schedule component1() {
            return this.schedule;
        }

        @Nullable
        public final TimeValue component2() {
            return this.timeLimit;
        }

        @NotNull
        public final Creation copy(@NotNull Schedule schedule, @Nullable TimeValue timeLimit) {
            Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
            return new Creation(schedule, timeLimit);
        }

        public static /* synthetic */ Creation copy$default(Creation creation, Schedule schedule, TimeValue timeValue, int n, Object object) {
            if ((n & 1) != 0) {
                schedule = creation.schedule;
            }
            if ((n & 2) != 0) {
                timeValue = creation.timeLimit;
            }
            return creation.copy(schedule, timeValue);
        }

        @NotNull
        public String toString() {
            return "Creation(schedule=" + this.schedule + ", timeLimit=" + this.timeLimit + ")";
        }

        public int hashCode() {
            int result2 = this.schedule.hashCode();
            result2 = result2 * 31 + (this.timeLimit == null ? 0 : this.timeLimit.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Creation)) {
                return false;
            }
            Creation creation = (Creation)other;
            if (!Intrinsics.areEqual((Object)this.schedule, (Object)creation.schedule)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timeLimit, (Object)creation.timeLimit);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Creation$Companion;", "", "<init>", "()V", "SCHEDULE_FIELD", "", "parse", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Creation;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
        @SourceDebugExtension(value={"SMAP\nSMPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMPolicy.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Creation$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,424:1\n1#2:425\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Creation parse(@NotNull XContentParser xcp) {
                Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
                Schedule schedule = null;
                TimeValue timeLimit = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (Intrinsics.areEqual((Object)string, (Object)"schedule")) {
                        schedule = ScheduleParser.parse((XContentParser)xcp);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)string, (Object)SMPolicy.TIME_LIMIT_FIELD)) continue;
                    timeLimit = TimeValue.parseTimeValue((String)xcp.text(), (String)SMPolicy.TIME_LIMIT_FIELD);
                }
                Schedule schedule2 = schedule;
                if (schedule2 == null) {
                    boolean bl = false;
                    String string = "schedule field must not be null";
                    throw new IllegalArgumentException(string.toString());
                }
                TimeValue timeValue = timeLimit;
                Schedule schedule3 = schedule2;
                return new Creation(schedule3, timeValue);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B'\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J0\u0010 \u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u0006H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$DeleteCondition;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "maxAge", "Lorg/opensearch/common/unit/TimeValue;", "minCount", "", "maxCount", "<init>", "(Lorg/opensearch/common/unit/TimeValue;ILjava/lang/Integer;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getMaxAge", "()Lorg/opensearch/common/unit/TimeValue;", "getMinCount", "()I", "getMaxCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "component3", "copy", "(Lorg/opensearch/common/unit/TimeValue;ILjava/lang/Integer;)Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$DeleteCondition;", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nSMPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMPolicy.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$DeleteCondition\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,424:1\n1#2:425\n*E\n"})
    public static final class DeleteCondition
    implements Writeable,
    ToXContent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final TimeValue maxAge;
        private final int minCount;
        @Nullable
        private final Integer maxCount;
        @NotNull
        public static final String MAX_COUNT_FIELD = "max_count";
        @NotNull
        public static final String MAX_AGE_FIELD = "max_age";
        @NotNull
        public static final String MIN_COUNT_FIELD = "min_count";
        private static final int DEFAULT_MIN_COUNT = 1;

        public DeleteCondition(@Nullable TimeValue maxAge, int minCount, @Nullable Integer maxCount) {
            this.maxAge = maxAge;
            this.minCount = minCount;
            this.maxCount = maxCount;
            if (!(this.maxAge != null || this.maxCount != null)) {
                boolean $i$a$-require-SMPolicy$DeleteCondition$42 = false;
                String $i$a$-require-SMPolicy$DeleteCondition$42 = "Please provide max_age or max_count.";
                throw new IllegalArgumentException($i$a$-require-SMPolicy$DeleteCondition$42.toString());
            }
            if (!(this.minCount > 0)) {
                boolean $i$a$-require-SMPolicy$DeleteCondition$52 = false;
                String $i$a$-require-SMPolicy$DeleteCondition$52 = "min_count should be bigger than 0.";
                throw new IllegalArgumentException($i$a$-require-SMPolicy$DeleteCondition$52.toString());
            }
            if (!(this.maxCount == null || this.maxCount - this.minCount > 0)) {
                boolean bl = false;
                String string = "max_count should be bigger than min_count.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ DeleteCondition(TimeValue timeValue, int n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                timeValue = null;
            }
            if ((n3 & 4) != 0) {
                n2 = null;
            }
            this(timeValue, n, n2);
        }

        @Nullable
        public final TimeValue getMaxAge() {
            return this.maxAge;
        }

        public final int getMinCount() {
            return this.minCount;
        }

        @Nullable
        public final Integer getMaxCount() {
            return this.maxCount;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            XContentBuilder xContentBuilder = builder.startObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"startObject(...)");
            XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalField(xContentBuilder, MAX_AGE_FIELD, this.maxAge).field(MIN_COUNT_FIELD, this.minCount);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"field(...)");
            XContentBuilder xContentBuilder3 = OpenSearchExtensionsKt.optionalField(xContentBuilder2, MAX_COUNT_FIELD, this.maxCount).endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder3, (String)"endObject(...)");
            return xContentBuilder3;
        }

        public DeleteCondition(@NotNull StreamInput sin) {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            Integer n = sin.readOptionalInt();
            TimeValue timeValue = sin.readOptionalTimeValue();
            int n2 = sin.readInt();
            this(timeValue, n2, n);
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeOptionalInt(this.maxCount);
            out.writeOptionalTimeValue(this.maxAge);
            out.writeInt(this.minCount);
        }

        @Nullable
        public final TimeValue component1() {
            return this.maxAge;
        }

        public final int component2() {
            return this.minCount;
        }

        @Nullable
        public final Integer component3() {
            return this.maxCount;
        }

        @NotNull
        public final DeleteCondition copy(@Nullable TimeValue maxAge, int minCount, @Nullable Integer maxCount) {
            return new DeleteCondition(maxAge, minCount, maxCount);
        }

        public static /* synthetic */ DeleteCondition copy$default(DeleteCondition deleteCondition, TimeValue timeValue, int n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                timeValue = deleteCondition.maxAge;
            }
            if ((n3 & 2) != 0) {
                n = deleteCondition.minCount;
            }
            if ((n3 & 4) != 0) {
                n2 = deleteCondition.maxCount;
            }
            return deleteCondition.copy(timeValue, n, n2);
        }

        @NotNull
        public String toString() {
            return "DeleteCondition(maxAge=" + this.maxAge + ", minCount=" + this.minCount + ", maxCount=" + this.maxCount + ")";
        }

        public int hashCode() {
            int result2 = this.maxAge == null ? 0 : this.maxAge.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.minCount);
            result2 = result2 * 31 + (this.maxCount == null ? 0 : ((Object)this.maxCount).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeleteCondition)) {
                return false;
            }
            DeleteCondition deleteCondition = (DeleteCondition)other;
            if (!Intrinsics.areEqual((Object)this.maxAge, (Object)deleteCondition.maxAge)) {
                return false;
            }
            if (this.minCount != deleteCondition.minCount) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.maxCount, (Object)deleteCondition.maxCount);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$DeleteCondition$Companion;", "", "<init>", "()V", "MAX_COUNT_FIELD", "", "MAX_AGE_FIELD", "MIN_COUNT_FIELD", "DEFAULT_MIN_COUNT", "", "parse", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$DeleteCondition;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DeleteCondition parse(@NotNull XContentParser xcp) {
                Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
                TimeValue maxAge = null;
                int minCount = 1;
                Integer maxCount = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) continue;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -249250188: {
                            if (string.equals(DeleteCondition.MAX_COUNT_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case 844430244: {
                            if (string.equals(DeleteCondition.MAX_AGE_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case 523228386: {
                            if (string.equals(DeleteCondition.MIN_COUNT_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            maxCount = xcp.intValue();
                            break;
                        }
                        case 2: {
                            maxAge = TimeValue.parseTimeValue((String)xcp.text(), (String)DeleteCondition.MAX_AGE_FIELD);
                            break;
                        }
                        case 3: {
                            minCount = xcp.intValue();
                        }
                    }
                }
                return new DeleteCondition(maxAge, minCount, maxCount);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\nH\u00c6\u0003J3\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00062\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Deletion;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "schedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "scheduleProvided", "", "condition", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$DeleteCondition;", "timeLimit", "Lorg/opensearch/common/unit/TimeValue;", "<init>", "(Lorg/opensearch/jobscheduler/spi/schedule/Schedule;ZLorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$DeleteCondition;Lorg/opensearch/common/unit/TimeValue;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getSchedule", "()Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "getScheduleProvided", "()Z", "getCondition", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$DeleteCondition;", "getTimeLimit", "()Lorg/opensearch/common/unit/TimeValue;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "opensearch-index-management"})
    public static final class Deletion
    implements Writeable,
    ToXContent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Schedule schedule;
        private final boolean scheduleProvided;
        @NotNull
        private final DeleteCondition condition;
        @Nullable
        private final TimeValue timeLimit;
        @NotNull
        public static final String SCHEDULE_FIELD = "schedule";
        @NotNull
        public static final String CONDITION_FIELD = "condition";

        public Deletion(@NotNull Schedule schedule, boolean scheduleProvided, @NotNull DeleteCondition condition, @Nullable TimeValue timeLimit) {
            Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
            Intrinsics.checkNotNullParameter((Object)condition, (String)CONDITION_FIELD);
            this.schedule = schedule;
            this.scheduleProvided = scheduleProvided;
            this.condition = condition;
            this.timeLimit = timeLimit;
        }

        public /* synthetic */ Deletion(Schedule schedule, boolean bl, DeleteCondition deleteCondition, TimeValue timeValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                timeValue = null;
            }
            this(schedule, bl, deleteCondition, timeValue);
        }

        @NotNull
        public final Schedule getSchedule() {
            return this.schedule;
        }

        public final boolean getScheduleProvided() {
            return this.scheduleProvided;
        }

        @NotNull
        public final DeleteCondition getCondition() {
            return this.condition;
        }

        @Nullable
        public final TimeValue getTimeLimit() {
            return this.timeLimit;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            XContentBuilder xContentBuilder = builder.startObject().field("schedule", (ToXContent)this.schedule).field(CONDITION_FIELD, (ToXContent)this.condition);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
            XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalField(xContentBuilder, SMPolicy.TIME_LIMIT_FIELD, this.timeLimit).endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
            return xContentBuilder2;
        }

        public Deletion(@NotNull StreamInput sin) {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            CronSchedule cronSchedule = new CronSchedule(sin);
            TimeValue timeValue = sin.readOptionalTimeValue();
            DeleteCondition deleteCondition = new DeleteCondition(sin);
            this((Schedule)cronSchedule, false, deleteCondition, timeValue, 2, null);
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.schedule.writeTo(out);
            out.writeOptionalTimeValue(this.timeLimit);
            this.condition.writeTo(out);
        }

        @NotNull
        public final Schedule component1() {
            return this.schedule;
        }

        public final boolean component2() {
            return this.scheduleProvided;
        }

        @NotNull
        public final DeleteCondition component3() {
            return this.condition;
        }

        @Nullable
        public final TimeValue component4() {
            return this.timeLimit;
        }

        @NotNull
        public final Deletion copy(@NotNull Schedule schedule, boolean scheduleProvided, @NotNull DeleteCondition condition, @Nullable TimeValue timeLimit) {
            Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
            Intrinsics.checkNotNullParameter((Object)condition, (String)CONDITION_FIELD);
            return new Deletion(schedule, scheduleProvided, condition, timeLimit);
        }

        public static /* synthetic */ Deletion copy$default(Deletion deletion, Schedule schedule, boolean bl, DeleteCondition deleteCondition, TimeValue timeValue, int n, Object object) {
            if ((n & 1) != 0) {
                schedule = deletion.schedule;
            }
            if ((n & 2) != 0) {
                bl = deletion.scheduleProvided;
            }
            if ((n & 4) != 0) {
                deleteCondition = deletion.condition;
            }
            if ((n & 8) != 0) {
                timeValue = deletion.timeLimit;
            }
            return deletion.copy(schedule, bl, deleteCondition, timeValue);
        }

        @NotNull
        public String toString() {
            return "Deletion(schedule=" + this.schedule + ", scheduleProvided=" + this.scheduleProvided + ", condition=" + this.condition + ", timeLimit=" + this.timeLimit + ")";
        }

        public int hashCode() {
            int result2 = this.schedule.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.scheduleProvided);
            result2 = result2 * 31 + this.condition.hashCode();
            result2 = result2 * 31 + (this.timeLimit == null ? 0 : this.timeLimit.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Deletion)) {
                return false;
            }
            Deletion deletion = (Deletion)other;
            if (!Intrinsics.areEqual((Object)this.schedule, (Object)deletion.schedule)) {
                return false;
            }
            if (this.scheduleProvided != deletion.scheduleProvided) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.condition, (Object)deletion.condition)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timeLimit, (Object)deletion.timeLimit);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Deletion$Companion;", "", "<init>", "()V", "SCHEDULE_FIELD", "", "CONDITION_FIELD", "parse", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Deletion;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
        @SourceDebugExtension(value={"SMAP\nSMPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMPolicy.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy$Deletion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,424:1\n1#2:425\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Deletion parse(@NotNull XContentParser xcp) {
                Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
                Schedule schedule = null;
                TimeValue timeLimit = null;
                DeleteCondition condition = null;
                boolean scheduleProvided = true;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) continue;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -697920873: {
                            if (string.equals("schedule")) {
                                n = 1;
                            }
                            break;
                        }
                        case -861311717: {
                            if (string.equals(Deletion.CONDITION_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case 1129182153: {
                            if (string.equals(SMPolicy.TIME_LIMIT_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            schedule = ScheduleParser.parse((XContentParser)xcp);
                            break;
                        }
                        case 3: {
                            timeLimit = TimeValue.parseTimeValue((String)xcp.text(), (String)SMPolicy.TIME_LIMIT_FIELD);
                            break;
                        }
                        case 2: {
                            condition = DeleteCondition.Companion.parse(xcp);
                        }
                    }
                }
                if (schedule == null) {
                    scheduleProvided = false;
                    schedule = (Schedule)new CronSchedule("0 1 * * *", ZoneId.systemDefault());
                }
                Schedule schedule2 = schedule;
                boolean bl = scheduleProvided;
                TimeValue timeValue = timeLimit;
                DeleteCondition deleteCondition = condition;
                if (deleteCondition == null) {
                    boolean bl2 = false;
                    String string = "condition must not be null.";
                    throw new IllegalArgumentException(string.toString());
                }
                DeleteCondition deleteCondition2 = deleteCondition;
                return new Deletion(schedule2, bl, deleteCondition2, timeValue);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

