/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.Keyring;

public class CreateMultiKeyringInput {
    private final IKeyring generator;
    private final List<IKeyring> childKeyrings;

    protected CreateMultiKeyringInput(BuilderImpl builder) {
        this.generator = builder.generator();
        this.childKeyrings = builder.childKeyrings();
    }

    public IKeyring generator() {
        return this.generator;
    }

    public List<IKeyring> childKeyrings() {
        return this.childKeyrings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected IKeyring generator;
        protected List<IKeyring> childKeyrings;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateMultiKeyringInput model) {
            this.generator = model.generator();
            this.childKeyrings = model.childKeyrings();
        }

        @Override
        public Builder generator(IKeyring generator) {
            this.generator = Keyring.wrap(generator);
            return this;
        }

        @Override
        public IKeyring generator() {
            return this.generator;
        }

        @Override
        public Builder childKeyrings(List<IKeyring> childKeyrings) {
            this.childKeyrings = childKeyrings;
            return this;
        }

        @Override
        public List<IKeyring> childKeyrings() {
            return this.childKeyrings;
        }

        @Override
        public CreateMultiKeyringInput build() {
            if (Objects.isNull(this.childKeyrings())) {
                throw new IllegalArgumentException("Missing value for required field `childKeyrings`");
            }
            return new CreateMultiKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder generator(IKeyring var1);

        public IKeyring generator();

        public Builder childKeyrings(List<IKeyring> var1);

        public List<IKeyring> childKeyrings();

        public CreateMultiKeyringInput build();
    }
}

