/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.quantization;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.similarities.Similarity;
import org.opensearch.neuralsearch.sparse.quantization.ByteQuantizer;

public final class ByteQuantizationUtil {
    public static final int MAX_UNSIGNED_BYTE_VALUE = 255;

    private ByteQuantizationUtil() {
    }

    public static int getUnsignedByte(byte value) {
        return value & 0xFF;
    }

    public static int compareUnsignedByte(byte x, byte y) {
        return (x & 0xFF) - (y & 0xFF);
    }

    public static int multiplyUnsignedByte(byte x, byte y) {
        return (x & 0xFF) * (y & 0xFF);
    }

    public static Similarity.SimScorer getSimScorer(final float boost) {
        return new Similarity.SimScorer(){

            public float score(float freq, long norm) {
                return boost * freq;
            }
        };
    }

    public static float getCeilingValueIngest(FieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return 3.0f;
        }
        String stringValue = fieldInfo.getAttribute("quantization_ceiling_ingest");
        return StringUtils.isEmpty((CharSequence)stringValue) ? 3.0f : NumberUtils.createFloat((String)stringValue).floatValue();
    }

    public static float getCeilingValueSearch(FieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return 16.0f;
        }
        String stringValue = fieldInfo.getAttribute("quantization_ceiling_search");
        return StringUtils.isEmpty((CharSequence)stringValue) ? 16.0f : NumberUtils.createFloat((String)stringValue).floatValue();
    }

    public static ByteQuantizer getByteQuantizerIngest(FieldInfo fieldInfo) {
        float quantizationCeilIngest = ByteQuantizationUtil.getCeilingValueIngest(fieldInfo);
        return new ByteQuantizer(quantizationCeilIngest);
    }
}

