/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.services.sns.message.HttpException;
import com.amazonaws.services.sns.model.ConfirmSubscriptionResult;
import com.amazonaws.services.sns.model.transform.ConfirmSubscriptionResultStaxUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

@SdkInternalApi
final class Utils {
    private Utils() {
    }

    public static URL createUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new SdkClientException("Could not create URL: " + url, (Throwable)e);
        }
    }

    static ConfirmSubscriptionResult confirmSubscription(HttpClient httpClient, String subscribeUrl) {
        try {
            HttpGet request = new HttpGet(subscribeUrl);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (ApacheUtils.isRequestSuccessful((HttpResponse)response)) {
                return (ConfirmSubscriptionResult)new StaxResponseHandler((Unmarshaller)ConfirmSubscriptionResultStaxUnmarshaller.getInstance()).handle(ApacheUtils.createResponse(null, (HttpRequestBase)request, (HttpResponse)response, null)).getResult();
            }
            throw new HttpException("Could not confirm subscription", response);
        }
        catch (Exception e) {
            throw new SdkClientException((Throwable)e);
        }
    }
}

