/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Set;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;

public class ShouldContainCharSequence
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContain(CharSequence actual, CharSequence sequence2) {
        return new ShouldContainCharSequence("%nExpecting actual:%n  %s%nto contain:%n  %s %s", actual, sequence2, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldContain(Throwable actual, CharSequence sequence2) {
        String format = "%nExpecting throwable message:%n  %s%nto contain:%n  %s%nbut did not.%n%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual));
        return new ShouldContainCharSequence(format, actual.getMessage(), sequence2, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldContain(Throwable actual, CharSequence[] sequence2, Set<? extends CharSequence> notFound) {
        String format = "%nExpecting throwable message:%n  %s%nto contain:%n  %s%nbut could not find:%n  %s%n%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual));
        return new ShouldContainCharSequence(format, actual.getMessage(), sequence2, notFound, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldContain(CharSequence actual, CharSequence sequence2, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainCharSequence("%nExpecting actual:%n  %s%nto contain:%n  %s %s", actual, sequence2, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContain(CharSequence actual, CharSequence[] strings, Set<? extends CharSequence> notFound, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainCharSequence("%nExpecting actual:%n  %s%nto contain:%n  %s%nbut could not find:%n  %s%n %s", actual, strings, notFound, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContain(CharSequence actual, CharSequence[] strings, Set<? extends CharSequence> notFound) {
        return ShouldContainCharSequence.shouldContain(actual, strings, notFound, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldContainIgnoringCase(CharSequence actual, CharSequence sequence2) {
        return new ShouldContainCharSequence("%nExpecting actual:%n  %s%nto contain:%n  %s%n (ignoring case)", actual, sequence2, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldContainIgnoringWhitespaces(CharSequence actual, CharSequence sequence2, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainCharSequence("%nExpecting actual:%n  %s%nto contain (ignoring whitespaces):%n  %s %s", actual, sequence2, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainIgnoringWhitespaces(CharSequence actual, CharSequence[] strings, Set<? extends CharSequence> notFound, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainCharSequence("%nExpecting actual:%n  %s%nto contain (ignoring whitespaces):%n  %s%nbut could not find:%n  %s%n %s", actual, strings, notFound, comparisonStrategy);
    }

    public static ErrorMessageFactory containsIgnoringNewLines(CharSequence actual, CharSequence[] expectedValues, Set<? extends CharSequence> notFound, ComparisonStrategy comparisonWay) {
        String start = "%nExpecting actual:%n  %s%nto contain (ignoring new lines):%n";
        if (notFound.size() > 1) {
            return new ShouldContainCharSequence("%nExpecting actual:%n  %s%nto contain (ignoring new lines):%n  %s%nbut could not find:%n  %s%n %s", actual, expectedValues, notFound, comparisonWay);
        }
        return new ShouldContainCharSequence("%nExpecting actual:%n  %s%nto contain (ignoring new lines):%n  %s %s", actual, notFound.iterator().next(), comparisonWay);
    }

    private ShouldContainCharSequence(String format, CharSequence actual, CharSequence sequence2, ComparisonStrategy comparisonStrategy) {
        super(format, actual, sequence2, comparisonStrategy);
    }

    private ShouldContainCharSequence(String format, CharSequence actual, CharSequence[] values, Set<? extends CharSequence> notFound, ComparisonStrategy comparisonStrategy) {
        super(format, actual, values, notFound, comparisonStrategy);
    }
}

