
use builtin;
use str;

set edit:completion:arg-completer[rbw] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'rbw'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'rbw'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand config 'Get or set configuration options'
            cand register 'Register this device with the Bitwarden server'
            cand login 'Log in to the Bitwarden server'
            cand unlock 'Unlock the local Bitwarden database'
            cand unlocked 'Check if the local Bitwarden database is unlocked'
            cand sync 'Update the local copy of the Bitwarden database'
            cand list 'List all entries in the local Bitwarden database'
            cand ls 'List all entries in the local Bitwarden database'
            cand get 'Display the password for a given entry'
            cand search 'Search for entries'
            cand code 'Display the authenticator code for a given entry'
            cand totp 'Display the authenticator code for a given entry'
            cand add 'Add a new password to the database'
            cand generate 'Generate a new password'
            cand gen 'Generate a new password'
            cand edit 'Modify an existing password'
            cand remove 'Remove a given entry'
            cand rm 'Remove a given entry'
            cand history 'View the password history for a given entry'
            cand lock 'Lock the password database'
            cand purge 'Remove the local copy of the password database'
            cand stop-agent 'Terminate the background agent'
            cand gen-completions 'Generate completion script for the given shell'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rbw;config'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand show 'Show the values of all configuration settings'
            cand set 'Set a configuration option'
            cand unset 'Reset a configuration option to its default'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rbw;config;show'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;config;set'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;config;unset'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;config;help'= {
            cand show 'Show the values of all configuration settings'
            cand set 'Set a configuration option'
            cand unset 'Reset a configuration option to its default'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rbw;config;help;show'= {
        }
        &'rbw;config;help;set'= {
        }
        &'rbw;config;help;unset'= {
        }
        &'rbw;config;help;help'= {
        }
        &'rbw;register'= {
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rbw;login'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;unlock'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;unlocked'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;sync'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;list'= {
            cand --fields 'Fields to display. Available options are id, name, user, folder, type. Multiple fields will be separated by tabs.'
            cand --raw 'Display output as JSON'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;ls'= {
            cand --fields 'Fields to display. Available options are id, name, user, folder, type. Multiple fields will be separated by tabs.'
            cand --raw 'Display output as JSON'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;get'= {
            cand --folder 'Folder name to search in'
            cand -f 'Field to get'
            cand --field 'Field to get'
            cand -i 'Ignore case'
            cand --ignorecase 'Ignore case'
            cand --full 'Display the notes in addition to the password'
            cand --raw 'Display output as JSON'
            cand -c 'Copy result to clipboard'
            cand --clipboard 'Copy result to clipboard'
            cand -l 'List fields in this entry'
            cand --list-fields 'List fields in this entry'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;search'= {
            cand --fields 'Fields to display. Available options are id, name, user, folder. Multiple fields will be separated by tabs.'
            cand --folder 'Folder name to search in'
            cand --raw 'Display output as JSON'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;code'= {
            cand --folder 'Folder name to search in'
            cand -i 'Ignore case'
            cand --ignorecase 'Ignore case'
            cand --clipboard 'Copy result to clipboard'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;totp'= {
            cand --folder 'Folder name to search in'
            cand -i 'Ignore case'
            cand --ignorecase 'Ignore case'
            cand --clipboard 'Copy result to clipboard'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;add'= {
            cand --uri 'URI for the password entry'
            cand --folder 'Folder for the password entry'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rbw;generate'= {
            cand --uri 'URI for the password entry'
            cand --folder 'Folder for the password entry'
            cand --no-symbols 'Generate a password with no special characters'
            cand --only-numbers 'Generate a password consisting of only numbers'
            cand --nonconfusables 'Generate a password without visually similar characters (useful for passwords intended to be written down)'
            cand --diceware 'Generate a password of multiple dictionary words chosen from the EFF word list. The len parameter for this option will set the number of words to generate, rather than characters.'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rbw;gen'= {
            cand --uri 'URI for the password entry'
            cand --folder 'Folder for the password entry'
            cand --no-symbols 'Generate a password with no special characters'
            cand --only-numbers 'Generate a password consisting of only numbers'
            cand --nonconfusables 'Generate a password without visually similar characters (useful for passwords intended to be written down)'
            cand --diceware 'Generate a password of multiple dictionary words chosen from the EFF word list. The len parameter for this option will set the number of words to generate, rather than characters.'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rbw;edit'= {
            cand --folder 'Folder name to search in'
            cand -i 'Ignore case'
            cand --ignorecase 'Ignore case'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'rbw;remove'= {
            cand --folder 'Folder name to search in'
            cand -i 'Ignore case'
            cand --ignorecase 'Ignore case'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;rm'= {
            cand --folder 'Folder name to search in'
            cand -i 'Ignore case'
            cand --ignorecase 'Ignore case'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;history'= {
            cand --folder 'Folder name to search in'
            cand -i 'Ignore case'
            cand --ignorecase 'Ignore case'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;lock'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;purge'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;stop-agent'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;gen-completions'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'rbw;help'= {
            cand config 'Get or set configuration options'
            cand register 'Register this device with the Bitwarden server'
            cand login 'Log in to the Bitwarden server'
            cand unlock 'Unlock the local Bitwarden database'
            cand unlocked 'Check if the local Bitwarden database is unlocked'
            cand sync 'Update the local copy of the Bitwarden database'
            cand list 'List all entries in the local Bitwarden database'
            cand get 'Display the password for a given entry'
            cand search 'Search for entries'
            cand code 'Display the authenticator code for a given entry'
            cand add 'Add a new password to the database'
            cand generate 'Generate a new password'
            cand edit 'Modify an existing password'
            cand remove 'Remove a given entry'
            cand history 'View the password history for a given entry'
            cand lock 'Lock the password database'
            cand purge 'Remove the local copy of the password database'
            cand stop-agent 'Terminate the background agent'
            cand gen-completions 'Generate completion script for the given shell'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'rbw;help;config'= {
            cand show 'Show the values of all configuration settings'
            cand set 'Set a configuration option'
            cand unset 'Reset a configuration option to its default'
        }
        &'rbw;help;config;show'= {
        }
        &'rbw;help;config;set'= {
        }
        &'rbw;help;config;unset'= {
        }
        &'rbw;help;register'= {
        }
        &'rbw;help;login'= {
        }
        &'rbw;help;unlock'= {
        }
        &'rbw;help;unlocked'= {
        }
        &'rbw;help;sync'= {
        }
        &'rbw;help;list'= {
        }
        &'rbw;help;get'= {
        }
        &'rbw;help;search'= {
        }
        &'rbw;help;code'= {
        }
        &'rbw;help;add'= {
        }
        &'rbw;help;generate'= {
        }
        &'rbw;help;edit'= {
        }
        &'rbw;help;remove'= {
        }
        &'rbw;help;history'= {
        }
        &'rbw;help;lock'= {
        }
        &'rbw;help;purge'= {
        }
        &'rbw;help;stop-agent'= {
        }
        &'rbw;help;gen-completions'= {
        }
        &'rbw;help;help'= {
        }
    ]
    $completions[$command]
}
