﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/RecommendedIntentSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class ListRecommendedIntentsResult {
 public:
  AWS_LEXMODELSV2_API ListRecommendedIntentsResult() = default;
  AWS_LEXMODELSV2_API ListRecommendedIntentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API ListRecommendedIntentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier of the bot associated with the recommended intent.</p>
   */
  inline const Aws::String& GetBotId() const { return m_botId; }
  template <typename BotIdT = Aws::String>
  void SetBotId(BotIdT&& value) {
    m_botIdHasBeenSet = true;
    m_botId = std::forward<BotIdT>(value);
  }
  template <typename BotIdT = Aws::String>
  ListRecommendedIntentsResult& WithBotId(BotIdT&& value) {
    SetBotId(std::forward<BotIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the bot that contains the intent.</p>
   */
  inline const Aws::String& GetBotVersion() const { return m_botVersion; }
  template <typename BotVersionT = Aws::String>
  void SetBotVersion(BotVersionT&& value) {
    m_botVersionHasBeenSet = true;
    m_botVersion = std::forward<BotVersionT>(value);
  }
  template <typename BotVersionT = Aws::String>
  ListRecommendedIntentsResult& WithBotVersion(BotVersionT&& value) {
    SetBotVersion(std::forward<BotVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the language and locale of the intents to list. The string
   * must match one of the supported locales. For more information, see <a
   * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
   * languages</a>.</p>
   */
  inline const Aws::String& GetLocaleId() const { return m_localeId; }
  template <typename LocaleIdT = Aws::String>
  void SetLocaleId(LocaleIdT&& value) {
    m_localeIdHasBeenSet = true;
    m_localeId = std::forward<LocaleIdT>(value);
  }
  template <typename LocaleIdT = Aws::String>
  ListRecommendedIntentsResult& WithLocaleId(LocaleIdT&& value) {
    SetLocaleId(std::forward<LocaleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the bot recommendation that contains the recommended
   * intent.</p>
   */
  inline const Aws::String& GetBotRecommendationId() const { return m_botRecommendationId; }
  template <typename BotRecommendationIdT = Aws::String>
  void SetBotRecommendationId(BotRecommendationIdT&& value) {
    m_botRecommendationIdHasBeenSet = true;
    m_botRecommendationId = std::forward<BotRecommendationIdT>(value);
  }
  template <typename BotRecommendationIdT = Aws::String>
  ListRecommendedIntentsResult& WithBotRecommendationId(BotRecommendationIdT&& value) {
    SetBotRecommendationId(std::forward<BotRecommendationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Summary information for the intents that meet the filter criteria specified
   * in the request. The length of the list is specified in the maxResults parameter
   * of the request. If there are more intents available, the nextToken field
   * contains a token to get the next page of results.</p>
   */
  inline const Aws::Vector<RecommendedIntentSummary>& GetSummaryList() const { return m_summaryList; }
  template <typename SummaryListT = Aws::Vector<RecommendedIntentSummary>>
  void SetSummaryList(SummaryListT&& value) {
    m_summaryListHasBeenSet = true;
    m_summaryList = std::forward<SummaryListT>(value);
  }
  template <typename SummaryListT = Aws::Vector<RecommendedIntentSummary>>
  ListRecommendedIntentsResult& WithSummaryList(SummaryListT&& value) {
    SetSummaryList(std::forward<SummaryListT>(value));
    return *this;
  }
  template <typename SummaryListT = RecommendedIntentSummary>
  ListRecommendedIntentsResult& AddSummaryList(SummaryListT&& value) {
    m_summaryListHasBeenSet = true;
    m_summaryList.emplace_back(std::forward<SummaryListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token that indicates whether there are more results to return in a response
   * to the ListRecommendedIntents operation. If the nextToken field is present, you
   * send the contents as the nextToken parameter of a ListRecommendedIntents
   * operation request to get the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListRecommendedIntentsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListRecommendedIntentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_botId;

  Aws::String m_botVersion;

  Aws::String m_localeId;

  Aws::String m_botRecommendationId;

  Aws::Vector<RecommendedIntentSummary> m_summaryList;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_botIdHasBeenSet = false;
  bool m_botVersionHasBeenSet = false;
  bool m_localeIdHasBeenSet = false;
  bool m_botRecommendationIdHasBeenSet = false;
  bool m_summaryListHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
