%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in PKIX1-PSS-OAEP-Algorithms-2009.

-module('PKIX1-PSS-OAEP-Algorithms-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("PKIX1-PSS-OAEP-Algorithms-2009.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'PKIX1-PSS-OAEP-Algorithms-2009'},
            {options,[{i,"/startdir/src/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/startdir/src/otp/lib/public_key/asn1"},
 {outdir,"/startdir/src/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/startdir/src/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_EncodingParameters/2,
enc_HashAlgorithm/2,
enc_MaskGenAlgorithm/2,
enc_PSourceAlgorithm/2,
'enc_RSASSA-PSS-params'/2,
'enc_RSAES-OAEP-params'/2
]).

-export([
dec_EncodingParameters/2,
dec_HashAlgorithm/2,
dec_MaskGenAlgorithm/2,
dec_PSourceAlgorithm/2,
'dec_RSASSA-PSS-params'/2,
'dec_RSAES-OAEP-params'/2
]).

-export([
'enc_pk-rsaSSA-PSS'/3,
'enc_sa-rsaSSA-PSS'/3,
'enc_sa-sha224WithRSAEncryption'/3,
'enc_sa-sha256WithRSAEncryption'/3,
'enc_sa-sha384WithRSAEncryption'/3,
'enc_sa-sha512WithRSAEncryption'/3,
'enc_pk-rsaES-OAEP'/3,
'enc_kta-rsaES-OAEP'/3,
'enc_mda-sha224'/3,
'enc_mda-sha256'/3,
'enc_mda-sha384'/3,
'enc_mda-sha512'/3,
'enc_sa-sha512WithRSAEncryption_smimeCaps'/3,
'enc_sa-sha384WithRSAEncryption_smimeCaps'/3,
'enc_sa-sha256WithRSAEncryption_smimeCaps'/3,
'enc_sa-sha224WithRSAEncryption_smimeCaps'/3,
'enc_sa-rsaSSA-PSS_smimeCaps'/3,
'enc_kta-rsaES-OAEP_smimeCaps'/3
]).

-export([
'dec_pk-rsaSSA-PSS'/3,
'dec_sa-rsaSSA-PSS'/3,
'dec_sa-sha224WithRSAEncryption'/3,
'dec_sa-sha256WithRSAEncryption'/3,
'dec_sa-sha384WithRSAEncryption'/3,
'dec_sa-sha512WithRSAEncryption'/3,
'dec_pk-rsaES-OAEP'/3,
'dec_kta-rsaES-OAEP'/3,
'dec_mda-sha224'/3,
'dec_mda-sha256'/3,
'dec_mda-sha384'/3,
'dec_mda-sha512'/3,
'dec_sa-sha512WithRSAEncryption_smimeCaps'/3,
'dec_sa-sha384WithRSAEncryption_smimeCaps'/3,
'dec_sa-sha256WithRSAEncryption_smimeCaps'/3,
'dec_sa-sha224WithRSAEncryption_smimeCaps'/3,
'dec_sa-rsaSSA-PSS_smimeCaps'/3,
'dec_kta-rsaES-OAEP_smimeCaps'/3
]).

-export([
getenc_PublicKeys/1,
getenc_SignatureAlgs/1,
getenc_KeyTransportAlgs/1,
getenc_HashAlgs/1,
getenc_SMimeCaps/1,
getenc_HashAlgorithms/1,
getenc_PKCS1MGFAlgorithms/1,
'getenc_PSS-SourceAlgorithms'/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_4/1,
getenc_internal_object_set_argument_2/1
]).

-export([
getdec_PublicKeys/1,
getdec_SignatureAlgs/1,
getdec_KeyTransportAlgs/1,
getdec_HashAlgs/1,
getdec_SMimeCaps/1,
getdec_HashAlgorithms/1,
getdec_PKCS1MGFAlgorithms/1,
'getdec_PSS-SourceAlgorithms'/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_4/1,
getdec_internal_object_set_argument_2/1
]).

-export([
sha224WithRSAEncryption/0,
sha256WithRSAEncryption/0,
sha384WithRSAEncryption/0,
sha512WithRSAEncryption/0,
'pkcs-1'/0,
'id-RSAES-OAEP'/0,
'id-mgf1'/0,
'id-pSpecified'/0,
'id-RSASSA-PSS'/0,
'id-sha224'/0,
'id-sha256'/0,
'id-sha384'/0,
'id-sha512'/0,
nullOctetString/0,
nullParameters/0,
sha1Identifier/0,
mgf1SHA1/0,
pSpecifiedEmpty/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('EncodingParameters', Data) -> enc_EncodingParameters(Data);
encode_disp('HashAlgorithm', Data) -> enc_HashAlgorithm(Data);
encode_disp('MaskGenAlgorithm', Data) -> enc_MaskGenAlgorithm(Data);
encode_disp('PSourceAlgorithm', Data) -> enc_PSourceAlgorithm(Data);
encode_disp('RSASSA-PSS-params', Data) -> 'enc_RSASSA-PSS-params'(Data);
encode_disp('RSAES-OAEP-params', Data) -> 'enc_RSAES-OAEP-params'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('EncodingParameters', Data) -> dec_EncodingParameters(Data);
decode_disp('HashAlgorithm', Data) -> dec_HashAlgorithm(Data);
decode_disp('MaskGenAlgorithm', Data) -> dec_MaskGenAlgorithm(Data);
decode_disp('PSourceAlgorithm', Data) -> dec_PSourceAlgorithm(Data);
decode_disp('RSASSA-PSS-params', Data) -> 'dec_RSASSA-PSS-params'(Data);
decode_disp('RSAES-OAEP-params', Data) -> 'dec_RSAES-OAEP-params'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  EncodingParameters
%%================================
enc_EncodingParameters(Val) ->
    enc_EncodingParameters(Val, [<<4>>]).

enc_EncodingParameters(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_EncodingParameters(Tlv) ->
   dec_EncodingParameters(Tlv, [4]).

dec_EncodingParameters(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  HashAlgorithm
%%================================
enc_HashAlgorithm(Val) ->
    enc_HashAlgorithm(Val, [<<48>>]).

enc_HashAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1-PSS-OAEP-Algorithms-2009':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_HashAlgorithm(Tlv) ->
   dec_HashAlgorithm(Tlv, [16]).

dec_HashAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1-PSS-OAEP-Algorithms-2009':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'HashAlgorithm',Term1,Term2},
Res1.


%%================================
%%  MaskGenAlgorithm
%%================================
enc_MaskGenAlgorithm(Val) ->
    enc_MaskGenAlgorithm(Val, [<<48>>]).

enc_MaskGenAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1-PSS-OAEP-Algorithms-2009':'getenc_internal_object_set_argument_4'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_MaskGenAlgorithm(Tlv) ->
   dec_MaskGenAlgorithm(Tlv, [16]).

dec_MaskGenAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1-PSS-OAEP-Algorithms-2009':'getdec_internal_object_set_argument_4'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'MaskGenAlgorithm',Term1,Term2},
Res1.


%%================================
%%  PSourceAlgorithm
%%================================
enc_PSourceAlgorithm(Val) ->
    enc_PSourceAlgorithm(Val, [<<48>>]).

enc_PSourceAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1-PSS-OAEP-Algorithms-2009':'getenc_internal_object_set_argument_6'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PSourceAlgorithm(Tlv) ->
   dec_PSourceAlgorithm(Tlv, [16]).

dec_PSourceAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1-PSS-OAEP-Algorithms-2009':'getdec_internal_object_set_argument_6'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PSourceAlgorithm',Term1,Term2},
Res1.


%%================================
%%  RSASSA-PSS-params
%%================================
'enc_RSASSA-PSS-params'(Val) ->
    'enc_RSASSA-PSS-params'(Val, [<<48>>]).

'enc_RSASSA-PSS-params'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External PKIX1-PSS-OAEP-Algorithms-2009:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_1(Cindex1) of
true -> {[],0};
false ->
'enc_HashAlgorithm'(Cindex1, [<<48>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External PKIX1-PSS-OAEP-Algorithms-2009:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
'enc_MaskGenAlgorithm'(Cindex2, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute saltLength(3) with type INTEGER DEFAULT = 20
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_3(Cindex3) of
true -> {[],0};
false ->
encode_integer(Cindex3, [<<2>>,<<162>>])
       end,

%%-------------------------------------------------
%% attribute trailerField(4) with type INTEGER DEFAULT = 1
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case is_default_4(Cindex4) of
true -> {[],0};
false ->
encode_integer(Cindex4, [<<2>>,<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSASSA-PSS-params'(Tlv) ->
   'dec_RSASSA-PSS-params'(Tlv, [16]).

'dec_RSASSA-PSS-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashAlgorithm(1)   External PKIX1-PSS-OAEP-Algorithms-2009:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_HashAlgorithm'(V1, [16]), TempTlv2};
    _ ->
        {{'HashAlgorithm',{1,3,14,3,2,26},'NULL'},Tlv1}
end,

%%-------------------------------------------------
%% attribute maskGenAlgorithm(2)   External PKIX1-PSS-OAEP-Algorithms-2009:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_MaskGenAlgorithm'(V2, [16]), TempTlv3};
    _ ->
        {{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}},Tlv2}
end,

%%-------------------------------------------------
%% attribute saltLength(3) with type INTEGER DEFAULT = 20
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_integer(V3, [2]), TempTlv4};
    _ ->
        {20,Tlv3}
end,

%%-------------------------------------------------
%% attribute trailerField(4) with type INTEGER DEFAULT = 1
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {decode_integer(V4, [2]), TempTlv5};
    _ ->
        {1,Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'RSASSA-PSS-params',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  RSAES-OAEP-params
%%================================
'enc_RSAES-OAEP-params'(Val) ->
    'enc_RSAES-OAEP-params'(Val, [<<48>>]).

'enc_RSAES-OAEP-params'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute hashFunc(1)   External PKIX1-PSS-OAEP-Algorithms-2009:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_5(Cindex1) of
true -> {[],0};
false ->
'enc_HashAlgorithm'(Cindex1, [<<48>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute maskGenFunc(2)   External PKIX1-PSS-OAEP-Algorithms-2009:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_6(Cindex2) of
true -> {[],0};
false ->
'enc_MaskGenAlgorithm'(Cindex2, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute pSourceFunc(3)   External PKIX1-PSS-OAEP-Algorithms-2009:PSourceAlgorithm DEFAULT = {'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_7(Cindex3) of
true -> {[],0};
false ->
'enc_PSourceAlgorithm'(Cindex3, [<<48>>,<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RSAES-OAEP-params'(Tlv) ->
   'dec_RSAES-OAEP-params'(Tlv, [16]).

'dec_RSAES-OAEP-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashFunc(1)   External PKIX1-PSS-OAEP-Algorithms-2009:HashAlgorithm DEFAULT = {'HashAlgorithm',{1,3,14,3,2,26},'NULL'}
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_HashAlgorithm'(V1, [16]), TempTlv2};
    _ ->
        {{'HashAlgorithm',{1,3,14,3,2,26},'NULL'},Tlv1}
end,

%%-------------------------------------------------
%% attribute maskGenFunc(2)   External PKIX1-PSS-OAEP-Algorithms-2009:MaskGenAlgorithm DEFAULT = {'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}}
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_MaskGenAlgorithm'(V2, [16]), TempTlv3};
    _ ->
        {{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}},Tlv2}
end,

%%-------------------------------------------------
%% attribute pSourceFunc(3)   External PKIX1-PSS-OAEP-Algorithms-2009:PSourceAlgorithm DEFAULT = {'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_PSourceAlgorithm'(V3, [16]), TempTlv4};
    _ ->
        {{'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>},Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'RSAES-OAEP-params',Term1,Term2,Term3},
Res1.
sha224WithRSAEncryption() ->
{1,2,840,113549,1,1,14}.

sha256WithRSAEncryption() ->
{1,2,840,113549,1,1,11}.

sha384WithRSAEncryption() ->
{1,2,840,113549,1,1,12}.

sha512WithRSAEncryption() ->
{1,2,840,113549,1,1,13}.

'pkcs-1'() ->
{1,2,840,113549,1,1}.

'id-RSAES-OAEP'() ->
{1,2,840,113549,1,1,7}.

'id-mgf1'() ->
{1,2,840,113549,1,1,8}.

'id-pSpecified'() ->
{1,2,840,113549,1,1,9}.

'id-RSASSA-PSS'() ->
{1,2,840,113549,1,1,10}.

'id-sha224'() ->
{2,16,840,1,101,3,4,2,4}.

'id-sha256'() ->
{2,16,840,1,101,3,4,2,1}.

'id-sha384'() ->
{2,16,840,1,101,3,4,2,2}.

'id-sha512'() ->
{2,16,840,1,101,3,4,2,3}.

nullOctetString() ->
<<>>.

nullParameters() ->
'NULL'.

sha1Identifier() ->
{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}.

mgf1SHA1() ->
{'MaskGenAlgorithm',{1,2,840,113549,1,1,8},{'Externalvaluereference',283,'PKIX1-PSS-OAEP-Algorithms-2009',sha1Identifier}}.

pSpecifiedEmpty() ->
{'PSourceAlgorithm',{1,2,840,113549,1,1,9},<<>>}.




%%================================
%%  pk-rsaSSA-PSS
%%================================
'enc_pk-rsaSSA-PSS'('KeyValue', Val, _RestPrimFieldName) ->
   'PKIXAlgs-2009':enc_RSAPublicKey(Val, [<<48>>]);
'enc_pk-rsaSSA-PSS'('Params', Val, _RestPrimFieldName) ->
   'enc_RSASSA-PSS-params'(Val, [<<48>>]);
'enc_pk-rsaSSA-PSS'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-rsaSSA-PSS'('KeyValue', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIXAlgs-2009':dec_RSAPublicKey(Tlv, [16]);
'dec_pk-rsaSSA-PSS'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_RSASSA-PSS-params'(Tlv, [16]);
'dec_pk-rsaSSA-PSS'('PrivateKey',  Bytes,_) ->
   Bytes.

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  sa-rsaSSA-PSS
%%================================
'enc_sa-rsaSSA-PSS'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-rsaSSA-PSS'('Params', Val, _RestPrimFieldName) ->
   'enc_RSASSA-PSS-params'(Val, [<<48>>]);
'enc_sa-rsaSSA-PSS'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-rsaSSA-PSS_smimeCaps'(H, Val, T).


'dec_sa-rsaSSA-PSS'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-rsaSSA-PSS'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_RSASSA-PSS-params'(Tlv, [16]);
'dec_sa-rsaSSA-PSS'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-rsaSSA-PSS_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-sha224WithRSAEncryption
%%================================
'enc_sa-sha224WithRSAEncryption'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-sha224WithRSAEncryption'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-sha224WithRSAEncryption'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-sha224WithRSAEncryption_smimeCaps'(H, Val, T).


'dec_sa-sha224WithRSAEncryption'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-sha224WithRSAEncryption'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-sha224WithRSAEncryption'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-sha224WithRSAEncryption_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-sha256WithRSAEncryption
%%================================
'enc_sa-sha256WithRSAEncryption'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-sha256WithRSAEncryption'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-sha256WithRSAEncryption'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-sha256WithRSAEncryption_smimeCaps'(H, Val, T).


'dec_sa-sha256WithRSAEncryption'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-sha256WithRSAEncryption'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-sha256WithRSAEncryption'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-sha256WithRSAEncryption_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-sha384WithRSAEncryption
%%================================
'enc_sa-sha384WithRSAEncryption'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-sha384WithRSAEncryption'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-sha384WithRSAEncryption'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-sha384WithRSAEncryption_smimeCaps'(H, Val, T).


'dec_sa-sha384WithRSAEncryption'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-sha384WithRSAEncryption'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-sha384WithRSAEncryption'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-sha384WithRSAEncryption_smimeCaps'(H, Bytes, T).




%%================================
%%  sa-sha512WithRSAEncryption
%%================================
'enc_sa-sha512WithRSAEncryption'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-sha512WithRSAEncryption'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_sa-sha512WithRSAEncryption'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-sha512WithRSAEncryption_smimeCaps'(H, Val, T).


'dec_sa-sha512WithRSAEncryption'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-sha512WithRSAEncryption'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_sa-sha512WithRSAEncryption'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-sha512WithRSAEncryption_smimeCaps'(H, Bytes, T).




%%================================
%%  pk-rsaES-OAEP
%%================================
'enc_pk-rsaES-OAEP'('KeyValue', Val, _RestPrimFieldName) ->
   'PKIXAlgs-2009':enc_RSAPublicKey(Val, [<<48>>]);
'enc_pk-rsaES-OAEP'('Params', Val, _RestPrimFieldName) ->
   'enc_RSAES-OAEP-params'(Val, [<<48>>]);
'enc_pk-rsaES-OAEP'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-rsaES-OAEP'('KeyValue', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIXAlgs-2009':dec_RSAPublicKey(Tlv, [16]);
'dec_pk-rsaES-OAEP'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_RSAES-OAEP-params'(Tlv, [16]);
'dec_pk-rsaES-OAEP'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  kta-rsaES-OAEP
%%================================
'enc_kta-rsaES-OAEP'('Params', Val, _RestPrimFieldName) ->
   'enc_RSAES-OAEP-params'(Val, [<<48>>]);
'enc_kta-rsaES-OAEP'(smimeCaps,  Val, [H|T]) ->
   'enc_kta-rsaES-OAEP_smimeCaps'(H, Val, T).


'dec_kta-rsaES-OAEP'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_RSAES-OAEP-params'(Tlv, [16]);
'dec_kta-rsaES-OAEP'(smimeCaps, Bytes,[H|T]) ->
   'dec_kta-rsaES-OAEP_smimeCaps'(H, Bytes, T).




%%================================
%%  mda-sha224
%%================================
'enc_mda-sha224'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_mda-sha224'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  mda-sha256
%%================================
'enc_mda-sha256'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_mda-sha256'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  mda-sha384
%%================================
'enc_mda-sha384'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_mda-sha384'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  mda-sha512
%%================================
'enc_mda-sha512'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_mda-sha512'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  sa-sha512WithRSAEncryption_smimeCaps
%%================================
'enc_sa-sha512WithRSAEncryption_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-sha512WithRSAEncryption_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-sha384WithRSAEncryption_smimeCaps
%%================================
'enc_sa-sha384WithRSAEncryption_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-sha384WithRSAEncryption_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-sha256WithRSAEncryption_smimeCaps
%%================================
'enc_sa-sha256WithRSAEncryption_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-sha256WithRSAEncryption_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-sha224WithRSAEncryption_smimeCaps
%%================================
'enc_sa-sha224WithRSAEncryption_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-sha224WithRSAEncryption_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  sa-rsaSSA-PSS_smimeCaps
%%================================
'enc_sa-rsaSSA-PSS_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-rsaSSA-PSS_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  kta-rsaES-OAEP_smimeCaps
%%================================
'enc_kta-rsaES-OAEP_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   'enc_RSAES-OAEP-params'(Val, [<<48>>]).


'dec_kta-rsaES-OAEP_smimeCaps'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_RSAES-OAEP-params'(Tlv, [16]).




%%================================
%%  PublicKeys
%%================================
getenc_PublicKeys(Id) when Id =:= {1,2,840,113549,1,1,7} ->
    fun 'enc_pk-rsaES-OAEP'/3;
getenc_PublicKeys(Id) when Id =:= {1,2,840,113549,1,1,10} ->
    fun 'enc_pk-rsaSSA-PSS'/3;
getenc_PublicKeys(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_PublicKeys(Id) when Id =:= {1,2,840,113549,1,1,7} ->
    fun 'dec_pk-rsaES-OAEP'/3;
getdec_PublicKeys(Id) when Id =:= {1,2,840,113549,1,1,10} ->
    fun 'dec_pk-rsaSSA-PSS'/3;
getdec_PublicKeys(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SignatureAlgs
%%================================
getenc_SignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,10} ->
    fun 'enc_sa-rsaSSA-PSS'/3;
getenc_SignatureAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,10} ->
    fun 'dec_sa-rsaSSA-PSS'/3;
getdec_SignatureAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyTransportAlgs
%%================================
getenc_KeyTransportAlgs(Id) when Id =:= {1,2,840,113549,1,1,7} ->
    fun 'enc_kta-rsaES-OAEP'/3;
getenc_KeyTransportAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyTransportAlgs(Id) when Id =:= {1,2,840,113549,1,1,7} ->
    fun 'dec_kta-rsaES-OAEP'/3;
getdec_KeyTransportAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  HashAlgs
%%================================
getenc_HashAlgs(Id) when Id =:= {2,16,840,1,101,3,4,2,1} ->
    fun 'enc_mda-sha256'/3;
getenc_HashAlgs(Id) when Id =:= {2,16,840,1,101,3,4,2,2} ->
    fun 'enc_mda-sha384'/3;
getenc_HashAlgs(Id) when Id =:= {2,16,840,1,101,3,4,2,3} ->
    fun 'enc_mda-sha512'/3;
getenc_HashAlgs(Id) when Id =:= {2,16,840,1,101,3,4,2,4} ->
    fun 'enc_mda-sha224'/3;
getenc_HashAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_HashAlgs(Id) when Id =:= {2,16,840,1,101,3,4,2,1} ->
    fun 'dec_mda-sha256'/3;
getdec_HashAlgs(Id) when Id =:= {2,16,840,1,101,3,4,2,2} ->
    fun 'dec_mda-sha384'/3;
getdec_HashAlgs(Id) when Id =:= {2,16,840,1,101,3,4,2,3} ->
    fun 'dec_mda-sha512'/3;
getdec_HashAlgs(Id) when Id =:= {2,16,840,1,101,3,4,2,4} ->
    fun 'dec_mda-sha224'/3;
getdec_HashAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SMimeCaps
%%================================
getenc_SMimeCaps({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_RSAES-OAEP-params'(Val)
      end
   end;
getenc_SMimeCaps({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_SMimeCaps'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_RSAES-OAEP-params'(Bytes)
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_SMimeCaps(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  HashAlgorithms
%%================================
getenc_HashAlgorithms({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_HashAlgorithms({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_HashAlgorithms({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_HashAlgorithms({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_HashAlgorithms({2,16,840,1,101,3,4,2,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_HashAlgorithms(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

'getdec_HashAlgorithms'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_HashAlgorithms'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_HashAlgorithms'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_HashAlgorithms'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_HashAlgorithms'({2,16,840,1,101,3,4,2,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_HashAlgorithms'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.





%%================================
%%  PKCS1MGFAlgorithms
%%================================
getenc_PKCS1MGFAlgorithms({1,2,840,113549,1,1,8}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'enc_HashAlgorithm'(Val)
      end
   end;
getenc_PKCS1MGFAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PKCS1MGFAlgorithms'({1,2,840,113549,1,1,8}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'dec_HashAlgorithm'(Bytes)
      end
   end;
getdec_PKCS1MGFAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PSS-SourceAlgorithms
%%================================
'getenc_PSS-SourceAlgorithms'({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'enc_EncodingParameters'(Val)
      end
   end;
'getenc_PSS-SourceAlgorithms'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PSS-SourceAlgorithms'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
'getdec_PSS-SourceAlgorithms'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6({1,2,840,113549,1,1,9}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'enc_EncodingParameters'(Val)
      end
   end;
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_6'({1,2,840,113549,1,1,9}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'dec_EncodingParameters'(Bytes)
      end
   end;
getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4({1,2,840,113549,1,1,8}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'enc_HashAlgorithm'(Val)
      end
   end;
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_4'({1,2,840,113549,1,1,8}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            'dec_HashAlgorithm'(Bytes)
      end
   end;
getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2({1,3,14,3,2,26}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2({2,16,840,1,101,3,4,2,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            encode_null(Val, [<<5>>])
      end
   end;
getenc_internal_object_set_argument_2(ErrV) ->
   fun(C,V,_) ->
exit({'Type not compatible with table constraint',{component,C},{value,V}, {unique_name_and_value,id, ErrV}}) end.

'getdec_internal_object_set_argument_2'({1,3,14,3,2,26}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({2,16,840,1,101,3,4,2,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({2,16,840,1,101,3,4,2,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({2,16,840,1,101,3,4,2,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'({2,16,840,1,101,3,4,2,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Params' ->
            decode_null(Bytes, [5])
      end
   end;
'getdec_internal_object_set_argument_2'(ErrV) ->
  fun(C,V,_) -> exit({{component,C},{value,V},{unique_name_and_value,id, ErrV}}) end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Value) ->
try is_default_cs_8(Value) of
_ -> true
catch throw:false -> false
end.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Value) ->
try is_default_cs_9(Value) of
_ -> true
catch throw:false -> false
end.


is_default_3(asn1_DEFAULT) ->
true;
is_default_3(Def) when Def =:= 20 ->
true;
is_default_3(_) ->
false.


is_default_4(asn1_DEFAULT) ->
true;
is_default_4(Def) when Def =:= 1 ->
true;
is_default_4(_) ->
false.


is_default_5(asn1_DEFAULT) ->
true;
is_default_5(Value) ->
try is_default_cs_8(Value) of
_ -> true
catch throw:false -> false
end.


is_default_6(asn1_DEFAULT) ->
true;
is_default_6(Value) ->
try is_default_cs_9(Value) of
_ -> true
catch throw:false -> false
end.


is_default_7(asn1_DEFAULT) ->
true;
is_default_7(Value) ->
try is_default_cs_10(Value) of
_ -> true
catch throw:false -> false
end.


is_default_cs_10(Value) ->
case Value of
{'PSourceAlgorithm',
E1,
<<>>} ->
check_objectidentifier(E1, {[[1,iso],[2,'member-body']],[840,113549,1,1,9]});
_ ->
throw(false)
end.

is_default_cs_8(Value) ->
case Value of
{'HashAlgorithm',
E1,
'NULL'} ->
check_objectidentifier(E1, {[[1,iso],[3,'identified-organization']],[14,3,2,26]});
_ ->
throw(false)
end.

is_default_cs_9(Value) ->
case Value of
{'MaskGenAlgorithm',
E1,
{'HashAlgorithm',{1,3,14,3,2,26},'NULL'}} ->
check_objectidentifier(E1, {[[1,iso],[2,'member-body']],[840,113549,1,1,8]});
_ ->
throw(false)
end.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_objectidentifier(Value, {Prefix, Tail}) when is_tuple(Value) ->
    check_oid(tuple_to_list(Value), Prefix, Tail);
check_objectidentifier(_, _) ->
    throw(false).

check_oid([H | T], [K | Ks], Tail) ->
    case lists:member(H, K) of
        false ->
            throw(false);
        true ->
            check_oid(T, Ks, Tail)
    end;
check_oid(Tail, [], Tail) ->
    true;
check_oid(_, _, _) ->
    throw(false).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).
