/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.renderer.types.impl.KaTypeRendererForSource;
import org.jetbrains.kotlin.analysis.api.types.KaErrorType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.SpecifyTypeExplicitlyInDestructuringAssignmentIntentionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SpecifyTypeExplicitlyInDestructuringAssignmentIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SpecifyTypeExplicitlyInDestructuringAssignmentIntention$Context;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "isApplicableByPsi", "", "element", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Context", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nSpecifyTypeExplicitlyInDestructuringAssignmentIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecifyTypeExplicitlyInDestructuringAssignmentIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SpecifyTypeExplicitlyInDestructuringAssignmentIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class SpecifyTypeExplicitlyInDestructuringAssignmentIntention
extends KotlinApplicableModCommandAction<KtDestructuringDeclaration, Context> {
    public SpecifyTypeExplicitlyInDestructuringAssignmentIntention() {
        super(Reflection.getOrCreateKotlinClass(KtDestructuringDeclaration.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"specify.all.types.explicitly.in.destructuring.declaration", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtDestructuringDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getContainingFile() instanceof KtCodeFragment) {
            return false;
        }
        List entries = SpecifyTypeExplicitlyInDestructuringAssignmentIntentionKt.access$entriesWithoutExplicitTypes(element);
        return !((Collection)entries).isEmpty();
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtDestructuringDeclaration element) {
        int n;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getInitializer();
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)) - 1;
        } else {
            n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element));
        }
        int endOffset = n;
        return CollectionsKt.listOf((Object)new TextRange(0, endOffset - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element))));
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtDestructuringDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List entries = SpecifyTypeExplicitlyInDestructuringAssignmentIntentionKt.access$entriesWithoutExplicitTypes(element);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        Map entriesAndTypeReferences = new LinkedHashMap();
        for (KtDestructuringDeclarationEntry entry : entries) {
            KaType returnType = $this$prepareContext.getSymbol(entry).getReturnType();
            if (returnType instanceof KaErrorType) {
                return null;
            }
            String type2 = $this$prepareContext.render(returnType, KaTypeRendererForSource.INSTANCE.getWITH_SHORT_NAMES(), Variance.OUT_VARIANCE);
            KtTypeReference typeReference = factory2.createType(type2);
            entriesAndTypeReferences.put(entry, typeReference);
        }
        return new Context(entriesAndTypeReferences);
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtDestructuringDeclaration element, @NotNull Context elementContext, @NotNull ModPsiUpdater updater2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            Map<KtDestructuringDeclarationEntry, KtTypeReference> entriesAndTypeReferences = elementContext.getEntriesAndTypeReferences();
            KtDestructuringDeclarationEntry lastEntry = null;
            for (Map.Entry<KtDestructuringDeclarationEntry, KtTypeReference> entryAndTypeReference : entriesAndTypeReferences.entrySet()) {
                entryAndTypeReference.getKey().setTypeReference(entryAndTypeReference.getValue());
                lastEntry = entryAndTypeReference.getKey();
            }
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = lastEntry;
            if (ktDestructuringDeclarationEntry == null) break block1;
            KtDestructuringDeclarationEntry it = ktDestructuringDeclarationEntry;
            boolean bl = false;
            updater2.moveCaretTo(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lastEntry)));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SpecifyTypeExplicitlyInDestructuringAssignmentIntention$Context;", "", "entriesAndTypeReferences", "", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "<init>", "(Ljava/util/Map;)V", "getEntriesAndTypeReferences", "()Ljava/util/Map;", "kotlin.code-insight.intentions.shared"})
    public static final class Context {
        @NotNull
        private final Map<KtDestructuringDeclarationEntry, KtTypeReference> entriesAndTypeReferences;

        public Context(@NotNull Map<KtDestructuringDeclarationEntry, KtTypeReference> entriesAndTypeReferences) {
            Intrinsics.checkNotNullParameter(entriesAndTypeReferences, (String)"entriesAndTypeReferences");
            this.entriesAndTypeReferences = entriesAndTypeReferences;
        }

        @NotNull
        public final Map<KtDestructuringDeclarationEntry, KtTypeReference> getEntriesAndTypeReferences() {
            return this.entriesAndTypeReferences;
        }
    }
}

